/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplateQuery;
import org.intermine.web.autocompletion.AutoCompleter;
import org.intermine.web.logic.query.DisplayConstraint;
import org.intermine.web.logic.query.DisplayConstraintFactory;
import org.intermine.web.logic.querybuilder.DisplayPath;
import org.intermine.web.logic.session.SessionMethods;

public class QueryBuilderConstraintController
extends TilesAction {
    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        PathQuery query = SessionMethods.getQuery((HttpSession)session);
        DisplayConstraintFactory factory = this.getFactory(session);
        if (session.getAttribute("newConstraintPath") != null) {
            DisplayPath displayPath = (DisplayPath)session.getAttribute("newConstraintPath");
            DisplayConstraint displayConstraint = factory.get(displayPath.getPath(), profile, query);
            request.setAttribute("dec", (Object)displayConstraint);
            session.removeAttribute("newConstraintPath");
            this.saveToken(request);
        } else if (session.getAttribute("editingConstraint") != null) {
            DisplayConstraint displayConstraint;
            PathConstraint con = (PathConstraint)session.getAttribute("editingConstraint");
            if (query instanceof TemplateQuery) {
                TemplateQuery template = (TemplateQuery)query;
                displayConstraint = factory.get(con, profile, (PathQuery)template);
            } else {
                displayConstraint = factory.get(con, profile, query);
            }
            request.setAttribute("dec", (Object)displayConstraint);
            session.removeAttribute("editingConstraint");
            if (session.getAttribute("editingTemplateConstraint") != null) {
                SessionMethods.moveToRequest((String)"editingTemplateConstraint", (HttpServletRequest)request);
            }
            this.saveToken(request);
        } else if (session.getAttribute("joinStylePath") != null) {
            String joinStylePathStr = (String)session.getAttribute("joinStylePath");
            Path joinStylePath = query.makePath(joinStylePathStr);
            DisplayConstraint displayConstraint = factory.get(joinStylePath, profile, query);
            session.removeAttribute("joinStylePath");
            if (query.getOuterMap().containsKey(joinStylePathStr)) {
                request.setAttribute("joinType", (Object)"outer");
            } else {
                request.setAttribute("joinType", (Object)"inner");
            }
            request.setAttribute("dec", (Object)displayConstraint);
            request.setAttribute("joinStyleOnly", (Object)"true");
            this.saveToken(request);
        }
        return null;
    }

    private DisplayConstraintFactory getFactory(HttpSession session) {
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        AutoCompleter ac = SessionMethods.getAutoCompleter((ServletContext)session.getServletContext());
        DisplayConstraintFactory factory = new DisplayConstraintFactory(im, ac);
        return factory;
    }
}

