/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.uri;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;

public final class ClassNameURIIdentifierMapper {
    private static ClassNameURIIdentifierMapper instance = null;
    private static final String URI_SUFFIX = "_URI";
    private Properties properties = new Properties();
    private static Map<String, String> classNameIdentifiersMap = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(ClassNameURIIdentifierMapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassNameURIIdentifierMapper() {
        try (InputStream inputStream = null;){
            inputStream = this.getClass().getClassLoader().getResourceAsStream("uri_keys.properties");
            if (inputStream == null) {
                LOGGER.error((Object)"File uri_keys.properties not found");
                return;
            }
            this.properties.load(inputStream);
            inputStream = this.getClass().getClassLoader().getResourceAsStream("class_keys.properties");
            if (inputStream == null) {
                LOGGER.error((Object)"File class_keys.properties not found");
                return;
            }
            this.properties.load(inputStream);
            String key = null;
            Set subClassNames = null;
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                key = (String)entry.getKey();
                if (!key.endsWith(URI_SUFFIX)) continue;
                String className = key.replace(URI_SUFFIX, "");
                classNameIdentifiersMap.put(className, (String)entry.getValue());
                subClassNames = this.getSubClassNames(className);
                for (String subClassName : subClassNames) {
                    classNameIdentifiersMap.put(subClassName, (String)entry.getValue());
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Error loading uri_keys.properties/class_keys.properties file", (Throwable)ex);
            return;
        }
    }

    public static ClassNameURIIdentifierMapper getMapper() {
        if (instance == null) {
            instance = new ClassNameURIIdentifierMapper();
        }
        return instance;
    }

    public String getIdentifier(String className) {
        if (classNameIdentifiersMap != null) {
            return (String)classNameIdentifiersMap.get(className);
        }
        return null;
    }

    private Set<String> getSubClassNames(String className) {
        HashSet<String> subClassNames = new HashSet<String>();
        Model model = Model.getInstanceByName((String)"genomic");
        ClassDescriptor cl = model.getClassDescriptorByName(className);
        if (cl != null) {
            Set subDescriptors = cl.getSubDescriptors();
            for (ClassDescriptor descriptor : subDescriptors) {
                subClassNames.add(descriptor.getSimpleName());
            }
        }
        return subClassNames;
    }
}

