/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.branding;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.util.PropertiesUtil;
import org.intermine.webservice.server.core.JSONService;

public class BrandingService
extends JSONService {
    private static final String PROPERTIES_NEED_2_SECTIONS = "Branding properties should contain at least two sections. Skipping ";
    private static final String PREFIX = "branding.";
    private static final Logger LOG = Logger.getLogger(BrandingService.class);

    public BrandingService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        Properties props = PropertiesUtil.getPropertiesStartingWith((String)PREFIX, (Properties)this.webProperties);
        HashMap branding = new HashMap();
        for (Object key : props.keySet()) {
            String keyString = String.valueOf(key);
            String[] keyParts = keyString.split("\\.");
            if (keyParts.length < 2) {
                LOG.warn((Object)(PROPERTIES_NEED_2_SECTIONS + key));
                continue;
            }
            LinkedList<String> path = new LinkedList<String>();
            for (int i = 1; i < keyParts.length; ++i) {
                path.add(keyParts[i]);
            }
            this.setProperty(branding, path, props.getProperty(keyString));
        }
        this.addResultItem(branding, false);
    }

    public String getResultsKey() {
        return "properties";
    }

    private void setProperty(Map<String, Object> branding, Queue<String> path, String value) {
        String key = path.remove();
        if (path.isEmpty()) {
            branding.put(key, value);
        } else {
            Map thisLevel;
            if (!branding.containsKey(key)) {
                thisLevel = new HashMap();
                branding.put(key, thisLevel);
            } else {
                thisLevel = (Map)branding.get(key);
            }
            this.setProperty(thisLevel, path, value);
        }
    }
}

