/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.lists.AuthenticatedListService;
import org.intermine.webservice.server.lists.ListInput;
import org.intermine.webservice.server.lists.ListServiceUtils;

public class ListDeletionService
extends AuthenticatedListService {
    public static final String USAGE = "List Deletion Service\n=====================\nDelete a list\nParameters:\nname: the name of the list to delete\nNOTE: All requests to this service must authenticate to a valid user account\n";

    public ListDeletionService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        ListInput input = this.getInput();
        this.addOutputInfo("listName", input.getListName());
        if (!profile.getAllBags().containsKey(input.getListName())) {
            throw new BadRequestException(input.getListName() + " doesn't exists");
        }
        ListServiceUtils.ensureBagIsDeleted((Profile)profile, (String)input.getListName());
    }
}

