/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.TagManager;
import org.intermine.api.query.MainHelper;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Query;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.lists.ListInput;
import org.intermine.webservice.server.template.TemplateToListService;

public class TemplateListAppendService
extends TemplateToListService {
    public TemplateListAppendService(InterMineAPI im) {
        super(im);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateListFromQuery(PathQuery pq, ListInput input, Profile profile) throws ObjectStoreException, PathException {
        Query q = MainHelper.makeQuery((PathQuery)pq, (Map)this.bagManager.getBags(profile), new HashMap(), (BagQueryRunner)this.im.getBagQueryRunner(), new HashMap());
        String name = input.getListName();
        InterMineBag list = (InterMineBag)profile.getSavedBags().get(name);
        if (list == null) {
            throw new BadRequestException("You do not have access to a list called '" + name + "'");
        }
        try {
            list.addToBagFromQuery(q);
            try {
                this.im.getBagManager().addTagsToBag((Collection)input.getTags(), list, profile);
            }
            catch (TagManager.TagNameException e) {
                throw new BadRequestException(e.getMessage());
            }
            catch (TagManager.TagNamePermissionException e) {
                throw new ServiceForbiddenException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            this.output.addResultItem(Arrays.asList("" + list.size()));
            throw throwable;
        }
        this.output.addResultItem(Arrays.asList("" + list.size()));
    }
}

