/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.user.JSONUserFormatter;

public class WhoAmIService
extends JSONService {
    private static final String DENIAL_MSG = "All whoami requests must be authenticated.";

    public WhoAmIService(InterMineAPI im) {
        super(im);
    }

    protected void validateState() {
        if (!this.isAuthenticated()) {
            throw new ServiceForbiddenException(DENIAL_MSG);
        }
    }

    protected String getResultsKey() {
        return "user";
    }

    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        this.addResultItem(new JSONUserFormatter(profile).format(), false);
    }
}

