/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.LinkRedirectManager;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.DataSource;
import org.intermine.model.bio.Organism;

public class BioLinkRedirectManager
extends LinkRedirectManager {
    protected static final Logger LOG = Logger.getLogger(BioLinkRedirectManager.class);

    public BioLinkRedirectManager(Properties webProperties) {
        super(webProperties);
    }

    public String generateLink(InterMineAPI im, InterMineObject imo) {
        Model model = im.getModel();
        Set classDescriptors = model.getClassDescriptorsForClass(imo.getClass());
        StringBuffer sb = new StringBuffer();
        for (ClassDescriptor cd : classDescriptors) {
            if (sb.length() <= 0) {
                sb.append("(");
            } else {
                sb.append("|");
            }
            sb.append(TypeUtil.unqualifiedName((String)cd.getName()));
        }
        sb.append(")");
        Organism organismReference = null;
        String geneOrgKey = sb.toString();
        try {
            organismReference = (Organism)imo.getFieldValue("organism");
        }
        catch (Exception exception) {
            // empty catch block
        }
        geneOrgKey = organismReference == null || organismReference.getTaxonId() == null ? geneOrgKey + "(\\.(\\*))" : geneOrgKey + "(\\.(" + organismReference.getTaxonId() + "|\\*))";
        String url = null;
        if (geneOrgKey.contains("CrossReference")) {
            String xrefId = null;
            try {
                xrefId = (String)imo.getFieldValue("identifier");
            }
            catch (IllegalAccessException e1) {
                return url;
            }
            if (xrefId == null) {
                return url;
            }
            DataSource ds = null;
            try {
                ds = (DataSource)imo.getFieldValue("source");
            }
            catch (IllegalAccessException e) {
                return url;
            }
            if (ds == null) {
                return url;
            }
            String dataSourceName = null;
            String dataSourceUrl = null;
            try {
                dataSourceName = (String)ds.getFieldValue("name");
                dataSourceUrl = (String)ds.getFieldValue("url");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (dataSourceName != null) {
                String xrefUrl = this.webPropertiesHasXrefUrl(dataSourceName);
                if (xrefUrl != null) {
                    url = xrefUrl.contains("<<attributeValue>>") ? xrefUrl.replaceAll("<<attributeValue>>", xrefId) : xrefUrl + xrefId;
                } else if (dataSourceUrl != null) {
                    url = dataSourceUrl.contains("<<attributeValue>>") ? dataSourceUrl.replaceAll("<<attributeValue>>", xrefId) : dataSourceUrl;
                }
                return url;
            }
        }
        String regexp = "externallink\\.([^.]+)\\." + geneOrgKey + "\\.([^.]+)(\\.list)?\\.(url)";
        Pattern p = Pattern.compile(regexp);
        for (Map.Entry<Object, Object> entry : this.webProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Matcher matcher = p.matcher(key);
            if (!matcher.matches()) continue;
            String attrName = matcher.group(5);
            Object attrValue = null;
            try {
                attrValue = imo.getFieldValue(attrName);
            }
            catch (IllegalAccessException e) {
                return null;
            }
            if (value.contains("<<attributeValue>>")) {
                url = value.replaceAll("<<attributeValue>>", String.valueOf(attrValue));
                continue;
            }
            url = value + attrValue;
        }
        return url;
    }

    private String webPropertiesHasXrefUrl(String dataSourceName) {
        String xrefexp = "xreflink." + dataSourceName + ".url";
        Pattern xrefp = Pattern.compile(xrefexp);
        for (Map.Entry<Object, Object> entry : this.webProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Matcher matcher = xrefp.matcher(key);
            if (!matcher.matches()) continue;
            return value;
        }
        return null;
    }
}

