/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.bio.web.export.BEDExporter;
import org.intermine.bio.web.logic.SequenceFeatureExportUtil;
import org.intermine.bio.webservice.BioQueryService;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.exceptions.BadRequestException;

public class BEDQueryService
extends BioQueryService {
    private static final String TRACK_DESCRIPTION = "trackDescription";
    private static final String UCSC_COMPATIBLE = "ucscCompatible";

    public BEDQueryService(InterMineAPI im) {
        super(im);
    }

    protected String getSuffix() {
        return ".bed";
    }

    protected String getContentType() {
        return "text/x-ucsc-bed";
    }

    protected BEDExporter getExporter(PathQuery pq) {
        String sourceName = this.webProperties.getProperty("project.title");
        String sourceReleaseVersion = this.webProperties.getProperty("project.releaseVersion");
        boolean makeUcscCompatible = !"no".equalsIgnoreCase(this.getOptionalParameter(UCSC_COMPATIBLE, "yes"));
        String trackDescription = this.getOptionalParameter(TRACK_DESCRIPTION, sourceName + " " + sourceReleaseVersion + " Custom Track");
        Set orgs = SequenceFeatureExportUtil.getOrganisms((PathQuery)pq, (InterMineAPI)this.im, (Profile)this.getPermission().getProfile());
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList viewColumns = new ArrayList(pq.getView());
        for (int i = 0; i < viewColumns.size(); ++i) {
            indexes.add(i);
        }
        return new BEDExporter(this.getPrintWriter(), indexes, sourceName, StringUtils.join((Collection)orgs, (String)","), makeUcscCompatible, trackDescription);
    }

    protected void checkPathQuery(PathQuery pq) throws Exception {
        try {
            SequenceFeatureExportUtil.isValidSequenceFeatureQuery((PathQuery)pq);
        }
        catch (SequenceFeatureExportUtil.InvalidQueryException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

