/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.dwr;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.tracker.util.ListTrackerEvent;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.web.context.InterMineContext;

public class TrackAjaxServices {
    protected static final Logger LOG = Logger.getLogger(TrackAjaxServices.class);
    private ObjectStore uos = null;
    private static final String LAST_2WEEKS = "LAST2WEEKS";
    private static final String LAST_MONTH = "LASTMONTH";
    private static final String LAST_90_DAYS = "LAST3MONTHES";
    private static final String LAST_YEAR = "LASTYEAR";
    private static final long ONEDAY = 86400000L;

    public TrackAjaxServices() {
        InterMineAPI im = InterMineContext.getInterMineAPI();
        this.uos = im.getProfileManager().getProfileObjectStoreWriter().getObjectStore();
    }

    private List<Object[]> getTracksTrend(String tableName) {
        ArrayList<Object[]> tracksTrend = new ArrayList<Object[]>();
        String sql = "SELECT date_part('doy', timestamp) AS day, COUNT(timestamp) FROM " + tableName + " GROUP BY date_part('doy', timestamp)";
        Connection connection = null;
        Calendar calendar = Calendar.getInstance();
        try {
            connection = ((ObjectStoreInterMineImpl)this.uos).getConnection();
            Statement stm = connection.createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Object[] track = new Object[2];
                int dayOfYear = rs.getInt(1);
                calendar.set(6, dayOfYear);
                track[0] = calendar.getTime();
                track[1] = rs.getInt(2);
                tracksTrend.add(track);
            }
            ((ObjectStoreInterMineImpl)this.uos).releaseConnection(connection);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return tracksTrend;
    }

    public List<Object[]> getQueryTracksTrend() {
        return this.getTracksTrend("querytrack");
    }

    public List<Object[]> getTemplateTracksTrend() {
        return this.getTracksTrend("templatetrack");
    }

    public List<Object[]> getLoginTracksTrend() {
        return this.getTracksTrend("logintrack");
    }

    public List<Object[]> getSearchTracksTrend() {
        return this.getTracksTrend("searchtrack");
    }

    private List<Object[]> getListTracksTrend(String event) {
        ArrayList<Object[]> listTracksTrend = new ArrayList<Object[]>();
        String sql = "SELECT date_part('doy', timestamp) AS day, COUNT(timestamp) FROM listtrack WHERE event='" + event + "' GROUP BY date_part('doy', timestamp)";
        Connection connection = null;
        Calendar calendar = Calendar.getInstance();
        try {
            connection = ((ObjectStoreInterMineImpl)this.uos).getConnection();
            Statement stm = connection.createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Object[] track = new Object[2];
                int dayOfYear = rs.getInt(1);
                calendar.set(6, dayOfYear);
                track[0] = calendar.getTime();
                track[1] = rs.getInt(2);
                listTracksTrend.add(track);
            }
            ((ObjectStoreInterMineImpl)this.uos).releaseConnection(connection);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return listTracksTrend;
    }

    public List<Object[]> getListExecutionTrend() {
        return this.getListTracksTrend(ListTrackerEvent.EXECUTION.toString());
    }

    public List<Object[]> getListCreationTrend() {
        return this.getListTracksTrend(ListTrackerEvent.CREATION.toString());
    }

    private List<Object[]> getTracksDataTable(String sqlQuery) {
        ArrayList<Object[]> trackTable = new ArrayList<Object[]>();
        Connection connection = null;
        try {
            connection = ((ObjectStoreInterMineImpl)this.uos).getConnection();
            Statement stm = connection.createStatement();
            ResultSet rs = stm.executeQuery(sqlQuery);
            while (rs.next()) {
                Object[] track = new Object[]{rs.getString(1), rs.getInt(2), rs.getInt(3) + rs.getInt(4)};
                trackTable.add(track);
            }
            ((ObjectStoreInterMineImpl)this.uos).releaseConnection(connection);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return trackTable;
    }

    public List<Object[]> getQueryTracksDataTable(String timeRange) {
        Date startTimeRange = this.calculateDate(timeRange);
        String timeStampConstraint = " timestamp > '" + startTimeRange.toString() + "' ";
        String sql = "SELECT type, COUNT(type), (SELECT COUNT(*) FROM (SELECT username FROM querytrack WHERE username!='' AND type=qt.type AND" + timeStampConstraint + " GROUP BY username) AS querysubselect), (SELECT COUNT(*) FROM (SELECT sessionidentifier FROM querytrack WHERE username='' AND type=qt.type AND" + timeStampConstraint + " GROUP BY sessionidentifier) AS querysubselect2) FROM querytrack AS qt WHERE qt.timestamp > '" + startTimeRange.toString() + "' GROUP BY qt.type ORDER BY COUNT(type) DESC LIMIT 20";
        return this.getTracksDataTable(sql);
    }

    public List<Object[]> getTemplateTracksPercentage(String timeRange) {
        Date startTimeRange = this.calculateDate(timeRange);
        String timeStampConstraint = " timestamp > '" + startTimeRange.toString() + "'";
        String sql = "SELECT templatename, COUNT(templatename), (SELECT COUNT(*) FROM (SELECT username FROM templatetrack WHERE username!='' AND templatename=tt.templatename AND" + timeStampConstraint + "GROUP BY username) AS templatesubselect), (SELECT COUNT(*) FROM (SELECT sessionidentifier FROM templatetrack WHERE username='' AND templatename=tt.templatename AND" + timeStampConstraint + " GROUP BY sessionidentifier) AS templatesubselect2) FROM templatetrack AS tt WHERE tt.timestamp > '" + startTimeRange.toString() + "' GROUP BY tt.templatename ORDER BY COUNT(templatename) DESC LIMIT 20";
        return this.getTracksDataTable(sql);
    }

    private Date calculateDate(String timeRange) {
        long startTimeMs;
        long currentDateMs = System.currentTimeMillis();
        if (StringUtils.isBlank((String)timeRange)) {
            startTimeMs = -1L;
        } else if (timeRange.equals(LAST_2WEEKS)) {
            startTimeMs = currentDateMs - 1209600000L;
        } else if (timeRange.equals(LAST_MONTH)) {
            startTimeMs = currentDateMs - 2592000000L;
        } else if (timeRange.equals(LAST_90_DAYS)) {
            startTimeMs = currentDateMs - 7776000000L;
        } else if (timeRange.equals(LAST_YEAR)) {
            startTimeMs = currentDateMs - 31536000000L;
        } else {
            throw new RuntimeException("Unknown time range: " + timeRange);
        }
        Date startDate = new Date(startTimeMs);
        return startDate;
    }

    public List<Object[]> getSearchTracksDataTable(String timeRange) {
        Date startTimeRange = this.calculateDate(timeRange);
        String timeStampConstraint = " timestamp > '" + startTimeRange.toString() + "'";
        String sql = "SELECT keyword, COUNT(keyword), (SELECT COUNT(*) FROM (SELECT username FROM searchtrack WHERE username!='' AND keyword=st.keyword AND" + timeStampConstraint + "GROUP BY username) AS searchsubselect), (SELECT COUNT(*) FROM (SELECT sessionidentifier FROM searchtrack WHERE username='' AND keyword=st.keyword AND" + timeStampConstraint + "GROUP BY sessionidentifier) AS searchsubselect2) FROM searchtrack AS st WHERE st.timestamp > '" + startTimeRange.toString() + "' GROUP BY st.keyword ORDER BY COUNT(keyword) DESC LIMIT 50";
        return this.getTracksDataTable(sql);
    }

    public List<Object[]> getListExecutionTracksDataTable(String timeRange) {
        Date startTimeRange = this.calculateDate(timeRange);
        String timeStampConstraint = " timestamp > '" + startTimeRange.toString() + "'";
        String sql = "SELECT type, COUNT(type), (SELECT COUNT(*) FROM (SELECT username FROM listtrack WHERE username!='' AND event='EXECUTION' AND type=lt.type AND" + timeStampConstraint + "GROUP BY username) AS listsubselect), (SELECT COUNT(*) FROM (SELECT sessionidentifier FROM listtrack WHERE username='' AND event='EXECUTION' AND type=lt.type AND" + timeStampConstraint + "GROUP BY sessionidentifier) AS listsubselect2) FROM listtrack AS lt WHERE lt.timestamp > '" + startTimeRange.toString() + "' AND lt.event='EXECUTION' GROUP BY lt.type ORDER BY COUNT(type) DESC LIMIT 20";
        return this.getTracksDataTable(sql);
    }

    public List<Object[]> getListCreationTracksDataTable(String timeRange) {
        Date startTimeRange = this.calculateDate(timeRange);
        String timeStampConstraint = " timestamp > '" + startTimeRange.toString() + "'";
        String sql = "SELECT type, COUNT(type), (SELECT COUNT(*) FROM (SELECT username FROM listtrack WHERE username!='' AND event='CREATION' AND type=lt.type AND" + timeStampConstraint + "GROUP BY username) AS listsubselect), (SELECT COUNT(*) FROM (SELECT sessionidentifier FROM listtrack WHERE username='' AND event='CREATION' AND type=lt.type AND" + timeStampConstraint + " GROUP BY sessionidentifier) AS listsubselect2) FROM listtrack AS lt WHERE lt.timestamp > '" + startTimeRange.toString() + "' AND lt.event='CREATION' GROUP BY lt.type ORDER BY COUNT(type) DESC LIMIT 20";
        return this.getTracksDataTable(sql);
    }
}

