/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.util.List;
import org.apache.log4j.Logger;
import org.intermine.api.profile.InterMineBag;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.ConstraintOp;
import org.intermine.objectstore.ObjectStore;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.widget.GraphWidgetLoader;
import org.intermine.web.logic.widget.Widget;
import org.intermine.web.logic.widget.WidgetOptions;
import org.intermine.web.logic.widget.config.GraphWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfigUtil;

public class GraphWidget
extends Widget {
    private static final String NOT_ACCEPTABLE = "The %s chart widget only accepts lists of %s, but you provided a list of %s";
    private static final String WIDGET_TYPE_NOT_IN_MODEL = "This widget is configured incorrectly. Its type is not in the model: ";
    private static final String NOT_IN_MODEL = "This bag has a type not found in the current model: ";
    private static final Logger LOG = Logger.getLogger(GraphWidget.class);
    private GraphWidgetLoader grapgWidgetLdr = null;
    private String filter;

    public GraphWidget(GraphWidgetConfig config, InterMineBag interMineBag, ObjectStore os, WidgetOptions options, String ids) {
        super((WidgetConfig)config);
        this.bag = interMineBag;
        this.os = os;
        this.ids = ids;
        this.filter = options.getFilter();
        this.validateBagType();
    }

    public void setFilter(String filter) {
        this.checkNotProcessed();
        this.filter = filter;
    }

    private void checkNotProcessed() {
        if (this.grapgWidgetLdr != null) {
            throw new IllegalStateException("This widget has already been processed.");
        }
    }

    private void checkProcessed() {
        if (this.grapgWidgetLdr == null) {
            throw new IllegalStateException("This widget has not been processed yet.");
        }
    }

    private void validateBagType() {
        String type = this.bag.getType();
        String accepts = this.config.getTypeClass();
        ClassDescriptor bagType = this.os.getModel().getClassDescriptorByName(type);
        if (bagType == null) {
            throw new IllegalArgumentException(NOT_IN_MODEL + type);
        }
        ClassDescriptor accepted = this.os.getModel().getClassDescriptorByName(accepts);
        if (accepted == null) {
            throw new IllegalStateException(WIDGET_TYPE_NOT_IN_MODEL + accepts);
        }
        if ("InterMineObject".equals(accepted.getUnqualifiedName())) {
            return;
        }
        if (bagType.equals((Object)accepted)) {
            return;
        }
        if (bagType.getAllSuperDescriptors().contains(accepted)) {
            return;
        }
        throw new IllegalArgumentException(String.format(NOT_ACCEPTABLE, this.config.getId(), accepts, type));
    }

    public void process() {
        this.checkNotProcessed();
        this.grapgWidgetLdr = new GraphWidgetLoader(this.bag, this.os, (GraphWidgetConfig)this.config, this.filter, this.ids);
        if (this.grapgWidgetLdr == null || this.grapgWidgetLdr.getResults() == null) {
            LOG.warn((Object)"No data found for graph widget");
            return;
        }
        try {
            this.notAnalysed = this.bag.getSize() - this.grapgWidgetLdr.getWidgetTotal();
        }
        catch (Exception err) {
            LOG.warn((Object)"Error rendering graph widget.", (Throwable)err);
            return;
        }
    }

    public List<List<String>> getExportResults(String[] selected) throws Exception {
        return null;
    }

    public boolean getHasResults() {
        this.checkProcessed();
        return this.grapgWidgetLdr != null && this.grapgWidgetLdr.getResults() != null && this.grapgWidgetLdr.getResults().size() > 0;
    }

    public List<List<Object>> getResults() {
        this.checkProcessed();
        return this.grapgWidgetLdr.getResultTable();
    }

    public PathQuery getPathQuery() {
        PathQuery q = this.createPathQueryView(this.os, this.config);
        if (((GraphWidgetConfig)this.config).isListPathSet()) {
            q.addConstraint((PathConstraint)Constraints.in((String)((GraphWidgetConfig)this.config).getListPath(), (String)this.bag.getName()));
        } else {
            q.addConstraint((PathConstraint)Constraints.in((String)this.config.getStartClass(), (String)this.bag.getName()));
        }
        String prefix = this.config.getStartClass() + ".";
        q.addConstraint((PathConstraint)Constraints.eq((String)(prefix + ((GraphWidgetConfig)this.config).getCategoryPath()), (String)"%category"));
        if (!((GraphWidgetConfig)this.config).comparesActualToExpected() && ((GraphWidgetConfig)this.config).hasSeries()) {
            q.addConstraint((PathConstraint)Constraints.eq((String)(prefix + ((GraphWidgetConfig)this.config).getSeriesPath()), (String)"%series"));
        }
        List pathConstraints = this.config.getPathConstraints();
        for (PathConstraint pc : pathConstraints) {
            if (WidgetConfigUtil.isFilterConstraint((WidgetConfig)this.config, (PathConstraint)pc)) continue;
            if (pc.getOp().equals(ConstraintOp.EQUALS)) {
                q.addConstraint((PathConstraint)Constraints.eq((String)(prefix + pc.getPath()), (String)PathConstraint.getValue((PathConstraint)pc)));
                continue;
            }
            if (!pc.getOp().equals(ConstraintOp.NOT_EQUALS)) continue;
            q.addConstraint((PathConstraint)Constraints.neq((String)(prefix + pc.getPath()), (String)PathConstraint.getValue((PathConstraint)pc)));
        }
        return q;
    }

    public PathQuery getSimplePathQuery() {
        PathQuery q = new PathQuery(this.os.getModel());
        List keyFieldNames = this.bag.getKeyFieldNames();
        String prefix = !((GraphWidgetConfig)this.config).isListPathSet() ? this.config.getStartClass() + "." : ((GraphWidgetConfig)this.config).getListPath() + ".";
        for (String keyFieldName : keyFieldNames) {
            if (!keyFieldName.startsWith(prefix)) {
                keyFieldName = prefix + keyFieldName;
            }
            q.addView(keyFieldName);
        }
        if (((GraphWidgetConfig)this.config).isListPathSet()) {
            q.addConstraint((PathConstraint)Constraints.in((String)((GraphWidgetConfig)this.config).getListPath(), (String)this.bag.getName()));
        } else {
            q.addConstraint((PathConstraint)Constraints.in((String)this.config.getStartClass(), (String)this.bag.getName()));
        }
        q.addConstraint((PathConstraint)Constraints.eq((String)(prefix + ((GraphWidgetConfig)this.config).getCategoryPath()), (String)"%category"));
        if (((GraphWidgetConfig)this.config).hasSeries()) {
            q.addConstraint((PathConstraint)Constraints.eq((String)(prefix + ((GraphWidgetConfig)this.config).getSeriesPath()), (String)"%series"));
        }
        return q;
    }
}

