/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.upload.FormFile;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.idresolution.IDResolver;
import org.intermine.api.idresolution.Job;
import org.intermine.api.idresolution.JobInput;
import org.intermine.api.profile.Profile;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.bag.WebJobInput;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.BuildBagForm;
import org.intermine.web.struts.InterMineAction;

public class BuildBagAction
extends InterMineAction {
    private static final int READ_AHEAD_CHARS = 10000;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String thisLine;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        ServletContext servletContext = request.getSession().getServletContext();
        Properties webProperties = (Properties)servletContext.getAttribute("WEB_PROPERTIES");
        BuildBagForm buildBagForm = (BuildBagForm)form;
        String type = buildBagForm.getType();
        if (StringUtils.isEmpty((String)type)) {
            this.recordError(new ActionMessage("bagBuild.typeNotSet"), request);
            return mapping.findForward("bags");
        }
        BagQueryRunner bagRunner = im.getBagQueryRunner();
        int maxBagSize = WebUtil.getIntSessionProperty((HttpSession)session, (String)"max.bag.size", (int)100000);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        if (profile == null || profile.getUsername() == null) {
            int defaultMaxNotLoggedSize = 3;
            maxBagSize = WebUtil.getIntSessionProperty((HttpSession)session, (String)"max.bag.size.notloggedin", (int)defaultMaxNotLoggedSize);
        }
        BufferedReader reader = null;
        FormFile formFile = buildBagForm.getFormFile();
        if (formFile != null && formFile.getFileName() != null && formFile.getFileName().length() > 0) {
            String fileName = formFile.getFileName();
            Integer lastPos = new Integer(fileName.lastIndexOf(46));
            if (lastPos > 0) {
                fileName = fileName.substring(0, lastPos);
            }
            fileName = fileName.replaceAll("_", " ");
            request.setAttribute("bagName", (Object)fileName);
            String mimetype = formFile.getContentType();
            if (!"application/octet-stream".equals(mimetype) && !mimetype.startsWith("text")) {
                this.recordError(new ActionMessage("bagBuild.notText", (Object)mimetype), request);
                return mapping.findForward("bags");
            }
            if (formFile.getFileSize() == 0) {
                this.recordError(new ActionMessage("bagBuild.noBagFileOrEmpty"), request);
                return mapping.findForward("bags");
            }
            reader = new BufferedReader(new InputStreamReader(formFile.getInputStream()));
        } else if (buildBagForm.getText() != null && buildBagForm.getText().length() != 0) {
            String trimmedText = buildBagForm.getText().trim();
            if (trimmedText.length() == 0) {
                this.recordError(new ActionMessage("bagBuild.noBagPaste"), request);
                return mapping.findForward("bags");
            }
            reader = new BufferedReader(new StringReader(trimmedText));
        } else {
            this.recordError(new ActionMessage("bagBuild.noBagFile"), request);
            return mapping.findForward("bags");
        }
        reader.mark(10000);
        char[] buf = new char[10000];
        int read = reader.read(buf, 0, 10000);
        for (int i = 0; i < read; ++i) {
            if (buf[i] != '\u0000') continue;
            this.recordError(new ActionMessage("bagBuild.notText", (Object)"binary"), request);
            return mapping.findForward("bags");
        }
        reader.reset();
        ArrayList<String> list = new ArrayList<String>();
        int elementCount = 0;
        while ((thisLine = reader.readLine()) != null) {
            String bagUploadDelims = (String)webProperties.get("list.upload.delimiters") + " ";
            StrMatcher matcher = StrMatcher.charSetMatcher((String)bagUploadDelims);
            StrTokenizer st = new StrTokenizer(thisLine, matcher, StrMatcher.doubleQuoteMatcher());
            while (st.hasNext()) {
                String token = st.nextToken();
                list.add(token);
                if (++elementCount <= maxBagSize) continue;
                ActionMessage actionMessage = null;
                actionMessage = profile == null || profile.getUsername() == null ? new ActionMessage("bag.bigNotLoggedIn", (Object)new Integer(maxBagSize)) : new ActionMessage("bag.tooBig", (Object)new Integer(maxBagSize));
                this.recordError(actionMessage, request);
                return mapping.findForward("bags");
            }
        }
        WebJobInput input = new WebJobInput(type, list, buildBagForm);
        Job job = IDResolver.getInstance().submit(bagRunner, (JobInput)input);
        session.setAttribute("idresolutionjobid", (Object)job.getUid());
        request.setAttribute("bagType", (Object)type);
        request.setAttribute("bagExtraFilter", (Object)buildBagForm.getExtraFieldValue());
        request.setAttribute("buildNewBag", (Object)"true");
        return mapping.findForward("bagUploadConfirm");
    }
}

