/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.validator.ValidatorForm;
import org.intermine.api.profile.Profile;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.web.logic.session.SessionMethods;

public class ContactForm
extends ValidatorForm {
    private String name;
    private String monkey;
    private String subject;
    private String message;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMonkey() {
        return this.monkey;
    }

    public void setMonkey(String monkey) {
        this.monkey = monkey;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = super.validate(mapping, request);
        if ((errors == null || errors.size() == 0) && this.getMonkey() != null && this.getMonkey().indexOf(64) == -1) {
            if (errors == null) {
                errors = new ActionErrors();
            }
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.email", (Object)this.getMonkey()));
            request.setAttribute("response", (Object)"Please check that you have provided your email.");
        }
        StringBuffer buffer = new StringBuffer();
        boolean badMessage = false;
        if (this.containsHeaders(this.getMessage(), buffer)) {
            this.message = buffer.toString();
            badMessage = true;
        }
        buffer = new StringBuffer();
        if (this.containsHeaders(this.getMonkey(), buffer)) {
            this.monkey = buffer.toString();
            badMessage = true;
        }
        buffer = new StringBuffer();
        if (this.containsHeaders(this.getSubject(), buffer)) {
            this.subject = buffer.toString();
            badMessage = true;
        }
        buffer = new StringBuffer();
        if (this.containsHeaders(this.getName(), buffer)) {
            this.name = buffer.toString();
            badMessage = true;
        }
        if (badMessage) {
            if (errors == null) {
                errors = new ActionErrors();
            }
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.contact.invalidmessage"));
            request.setAttribute("response", (Object)"Please check that you have provided your message.");
        }
        return errors;
    }

    protected boolean containsHeaders(String msg, StringBuffer buffer) {
        boolean found = false;
        if (StringUtils.isEmpty((String)msg)) {
            return found;
        }
        String[] lines = msg.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (this.isEmailHeader(lines[i], "to") || this.isEmailHeader(lines[i], "from") || this.isEmailHeader(lines[i], "bcc") || this.isEmailHeader(lines[i], "cc")) {
                found = true;
                continue;
            }
            buffer.append(lines[i]);
            if (i >= lines.length - 1) continue;
            buffer.append("\n");
        }
        return found;
    }

    private boolean isEmailHeader(String line, String header) {
        return line.toLowerCase().startsWith(header + ":") && line.indexOf("@") >= 0;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.name = "";
        this.subject = "";
        this.message = this.createDefaultFeedbackMsg(request);
        this.monkey = "";
        Profile profile = SessionMethods.getProfile((HttpSession)request.getSession());
        if (profile != null) {
            this.monkey = profile.getUsername();
        }
    }

    protected String createDefaultFeedbackMsg(HttpServletRequest request) {
        PathQuery query;
        HttpSession session = request.getSession();
        String msg = "\n\n\n\n---- Current page: ----\n\n";
        msg = msg + request.getAttribute("javax.servlet.forward.request_uri");
        if (request.getQueryString() != null) {
            msg = msg + "?" + request.getQueryString();
        }
        if ((query = SessionMethods.getQuery((HttpSession)session)) != null) {
            msg = msg + "\n\n---- Current query: ----\n\n";
            msg = msg + PathQueryBinding.marshal((PathQuery)query, (String)"", (String)query.getModel().getName(), (int)2);
        }
        return msg;
    }
}

