/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts.oauth2;

import java.util.ArrayList;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.OAuthProviderType;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.struts.InterMineAction;

public class Authenticator
extends InterMineAction {
    private static final Logger LOG = Logger.getLogger(Authenticator.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Properties webProperties = InterMineContext.getWebProperties();
        String providerName = request.getParameter("provider");
        String redirectUri = this.getRedirectUri(webProperties, providerName);
        String realm = webProperties.getProperty("webapp.baseurl");
        String state = UUID.randomUUID().toString();
        request.getSession().setAttribute("oauth2.state", (Object)state);
        String authorisationUrl = webProperties.getProperty("oauth2." + providerName + ".url.auth");
        if (authorisationUrl == null) {
            try {
                OAuthProviderType provider = OAuthProviderType.valueOf((String)providerName);
                authorisationUrl = provider.getAuthzEndpoint();
            }
            catch (IllegalArgumentException e) {
                ActionErrors errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("oauth2.error.unknown-provider"));
                this.saveErrors(request, (ActionMessages)errors);
                return mapping.findForward("login");
            }
        }
        try {
            OAuthClientRequest authRequest = OAuthClientRequest.authorizationLocation((String)authorisationUrl).setClientId(webProperties.getProperty("oauth2." + providerName + ".client-id")).setRedirectURI(redirectUri).setScope(webProperties.getProperty("oauth2." + providerName + ".scopes")).setState(state).setParameter("response_type", "code").setParameter("openid.realm", realm).buildQueryMessage();
            String goHere = authRequest.getLocationUri();
            LOG.info((Object)("[OAuth2]: Redirecting to " + goHere));
            response.sendRedirect(goHere);
            return null;
        }
        catch (OAuthSystemException e) {
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("oauth2.error.system-exception", (Object)e));
            this.saveErrors(request, (ActionMessages)errors);
            return mapping.findForward("login");
        }
    }

    private String getRedirectUri(Properties webProperties, String providerName) {
        ArrayList<String> redirectParts = new ArrayList<String>();
        redirectParts.add(webProperties.getProperty("webapp.baseurl"));
        redirectParts.add(webProperties.getProperty("webapp.path"));
        redirectParts.add("oauth2callback.do?provider=" + providerName);
        String redirectUri = StringUtils.join(redirectParts, (String)"/");
        return redirectUri;
    }
}

