/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.jbrowse.genomic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.Model;
import org.intermine.model.FastPathObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryCast;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryExpression;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintRange;
import org.intermine.pathquery.PathQuery;
import org.intermine.util.CacheMap;
import org.intermine.util.DynamicUtil;
import org.intermine.webservice.server.jbrowse.Command;
import org.intermine.webservice.server.jbrowse.CommandRunner;
import org.intermine.webservice.server.jbrowse.Queries;
import org.intermine.webservice.server.jbrowse.Segment;
import org.intermine.webservice.server.jbrowse.genomic.Engine;

/*
 * Exception performing whole class analysis ignored.
 */
public class Engine
extends CommandRunner {
    private static final Logger LOG = Logger.getLogger(CommandRunner.class);
    private final Model model;
    private static final Map<Command, Map<String, Object>> STATS_CACHE = new CacheMap("jbrowse.genomic.engine.STATS_CACHE");
    private static Map<MultiKey, Integer> maxima = new ConcurrentHashMap();

    public Engine(InterMineAPI api) {
        super(api);
        this.model = api.getModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stats(Command command) {
        HashMap stats;
        Query q = this.getStatsQuery(command);
        Map map = STATS_CACHE;
        synchronized (map) {
            stats = (HashMap)STATS_CACHE.get(command);
            if (stats == null) {
                stats = new HashMap();
                try {
                    List results = this.getAPI().getObjectStore().execute(q, 0, 1, false, false, ObjectStore.SEQUENCE_IGNORE);
                    List row = (List)results.get(0);
                    stats.put("featureDensity", row.get(0));
                    stats.put("featureCount", row.get(1));
                }
                catch (ObjectStoreException e) {
                    throw new RuntimeException("Error getting statistics.", e);
                }
                LOG.debug((Object)("caching " + stats));
                STATS_CACHE.put(command, stats);
            }
        }
        this.sendMap(stats);
    }

    private void sendMap(Map<String, Object> map) {
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            this.onData(e, it.hasNext());
        }
    }

    public void reference(Command command) {
        Query q = this.getReferenceQuery(command);
        Segment seg = command.getSegment();
        Integer start = seg.getStart() == null ? 0 : seg.getStart();
        Integer end = seg.getEnd();
        Iterator it = this.getResults(q).iterator();
        while (it.hasNext()) {
            FastPathObject fpo = (FastPathObject)it.next();
            this.onData(Engine.makeReferenceFeature((FastPathObject)fpo, (Integer)start, (Integer)end), it.hasNext());
        }
    }

    public void features(Command command) {
        if (command.getSegment() != Segment.NEGATIVE_SEGMENT) {
            Query q = this.getFeatureQuery(command);
            Iterator it = this.getResults(q).iterator();
            while (it.hasNext()) {
                FastPathObject fpo = (FastPathObject)it.next();
                this.onData(this.makeFeatureWithSubFeatures(fpo), it.hasNext());
            }
        }
    }

    private static List<Segment> sliceUp(int n, Segment segment) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        if (segment == null || segment.getWidth() == null) {
            throw new IllegalArgumentException("segment must be non null with defined width");
        }
        ArrayList<Segment> subsegments = new ArrayList<Segment>();
        int sliceWidth = segment.getWidth() / n;
        int inital = Math.max(0, segment.getStart());
        int end = segment.getEnd();
        for (int i = inital; i < end; i += sliceWidth) {
            subsegments.add(segment.subsegment(i, Math.min(end, i + sliceWidth)));
        }
        return subsegments;
    }

    public void densities(Command command) {
        int nSlices = Engine.getNumberOfSlices((Command)command);
        List segmentQueries = this.getSliceQueries(command, nSlices);
        List pending = this.countInParallel(segmentQueries);
        ArrayList<Integer> results = new ArrayList<Integer>();
        int max = 0;
        int sum = 0;
        for (Future future : pending) {
            try {
                Integer r = (Integer)future.get();
                if (r != null && r > max) {
                    max = r;
                }
                sum += r.intValue();
                results.add(r);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        double mean = Double.valueOf(sum) / (double)results.size();
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        HashMap<String, Number> binStats = new HashMap<String, Number>();
        Integer currentMax = 0;
        if (command.getSegment() != Segment.NEGATIVE_SEGMENT) {
            Integer bpb = command.getSegment().getWidth() / nSlices;
            binStats.put("basesPerBin", bpb);
            MultiKey maxKey = new MultiKey((Object)command.getDomain(), (Object)command.getType("SequenceFeature"), (Object)command.getSegment().getSection(), (Object)bpb);
            currentMax = (Integer)maxima.get(maxKey);
            if (currentMax == null || max > currentMax) {
                maxima.put(maxKey, max);
            }
        }
        binStats.put("max", currentMax != null && max < currentMax ? currentMax : max);
        binStats.put("mean", mean);
        result.put("bins", results);
        result.put("stats", binStats);
        this.sendMap(result);
    }

    private static int getNumberOfSlices(Command command) {
        int defaultNum = 10;
        String bpb = command.getParameter("basesPerBin");
        if (command == null || bpb == null || command.getSegment() == null || command.getSegment().getWidth() == null) {
            return defaultNum;
        }
        int width = command.getSegment().getWidth();
        int numBPB = Integer.valueOf(bpb);
        return width / numBPB;
    }

    private List<PathQuery> getSliceQueries(Command command, int nSlices) {
        if (command.getSegment() == Segment.NEGATIVE_SEGMENT) {
            return Collections.emptyList();
        }
        List slices = Engine.sliceUp((int)nSlices, (Segment)command.getSegment());
        ArrayList<PathQuery> segmentQueries = new ArrayList<PathQuery>();
        for (Segment s : slices) {
            segmentQueries.add(this.getSFPathQuery(command, s));
        }
        return segmentQueries;
    }

    private List<Future<Integer>> countInParallel(List<PathQuery> segmentQueries) {
        if (segmentQueries.isEmpty()) {
            return Collections.emptyList();
        }
        ExecutorService executor = Executors.newFixedThreadPool(segmentQueries.size());
        ArrayList<Future<Integer>> pending = new ArrayList<Future<Integer>>();
        for (PathQuery pq : segmentQueries) {
            PathQueryCounter counter = new PathQueryCounter(pq, this.getAPI().getObjectStore());
            pending.add(executor.submit(counter));
        }
        executor.shutdown();
        return pending;
    }

    private PathQuery getSFPathQuery(Command command) {
        return this.getSFPathQuery(command, command.getSegment());
    }

    private PathQuery getSFPathQuery(Command command, Segment segment) {
        PathQuery pq = new PathQuery(this.model);
        String type = command.getType("SequenceFeature");
        pq.addView(String.format("%s.id", type));
        pq.addConstraint((PathConstraint)Constraints.eq((String)String.format("%s.organism.taxonId", type), (String)command.getDomain()));
        if (segment != Segment.GLOBAL_SEGMENT) {
            pq.addConstraint((PathConstraint)Engine.makeRangeConstraint((String)type, (Segment)segment));
        }
        return pq;
    }

    private static ConstraintSet constrainToOrganism(QueryClass features, QueryClass organisms, String taxonId) {
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)new QueryObjectReference(features, "organism"), ConstraintOp.CONTAINS, organisms));
        cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)new QueryField(organisms, "taxonId"), ConstraintOp.EQUALS, (QueryEvaluable)new QueryValue((Object)taxonId)));
        return cs;
    }

    private Query getStatsQuery(Command command) {
        QueryValue length;
        String featureType = command.getType("SequenceFeature");
        ClassDescriptor seqf = this.model.getClassDescriptorByName("SequenceFeature");
        ClassDescriptor fcd = this.model.getClassDescriptorByName(featureType);
        if (fcd == null) {
            throw new RuntimeException(featureType + " is not in the model.");
        }
        if (fcd != seqf && !fcd.getAllSuperDescriptors().contains(seqf)) {
            throw new RuntimeException(featureType + " is not a sequence feature");
        }
        QueryClass organisms = new QueryClass(this.model.getClassDescriptorByName("Organism").getType());
        Query countQ = Queries.pathQueryToOSQ((PathQuery)this.getSFPathQuery(command));
        QueryFunction count = new QueryFunction();
        countQ.clearSelect();
        countQ.addToSelect((QuerySelectable)count);
        Query subqTwo = new Query();
        Segment seg = command.getSegment();
        if (seg.getWidth() == null || seg == Segment.GLOBAL_SEGMENT) {
            QueryClass chromosomes = new QueryClass(this.model.getClassDescriptorByName("Chromosome").getType());
            subqTwo.addFrom((FromElement)chromosomes);
            subqTwo.addFrom((FromElement)organisms);
            length = new QueryFunction((QueryEvaluable)new QueryField(chromosomes, "length"), 0);
            if (seg.getStart() != null) {
                subqTwo.addToSelect((QuerySelectable)new QueryExpression((QueryEvaluable)length, 1, (QueryEvaluable)new QueryValue((Object)seg.getStart())));
            } else if (seg.getEnd() != null) {
                subqTwo.addToSelect((QuerySelectable)new QueryExpression((QueryEvaluable)new QueryValue((Object)seg.getStart()), 1, (QueryEvaluable)length));
            } else {
                subqTwo.addToSelect((QuerySelectable)length);
            }
            ConstraintSet cs = Engine.constrainToOrganism((QueryClass)chromosomes, (QueryClass)organisms, (String)command.getDomain());
            if (seg.getSection() != null) {
                cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)new QueryField(chromosomes, "primaryIdentifier"), ConstraintOp.EQUALS, (QueryEvaluable)new QueryValue((Object)seg.getSection())));
            }
            subqTwo.setConstraint((Constraint)cs);
        } else {
            length = new QueryValue((Object)seg.getWidth());
            subqTwo.addToSelect((QuerySelectable)length);
        }
        Query q = new Query();
        q.addFrom((FromElement)countQ);
        q.addFrom((FromElement)subqTwo);
        q.addToSelect((QuerySelectable)new QueryExpression((QueryEvaluable)new QueryCast((QueryEvaluable)new QueryField(countQ, (QueryEvaluable)count), Double.class), 3, (QueryEvaluable)new QueryCast((QueryEvaluable)new QueryField(subqTwo, (QueryEvaluable)length), Double.class)));
        q.addToSelect((QuerySelectable)new QueryField(countQ, (QueryEvaluable)count));
        return q;
    }

    private static PathConstraintRange makeRangeConstraint(String type, Segment seg) {
        return new PathConstraintRange(String.format("%s.chromosomeLocation", type), ConstraintOp.OVERLAPS, Collections.singleton(seg.toRangeString()));
    }

    private List<Object> getResults(Query q) {
        return this.getAPI().getObjectStore().executeSingleton(q);
    }

    private static Map<String, Object> makeReferenceFeature(FastPathObject fpo, Integer start, Integer end) {
        CharSequence cs;
        try {
            cs = (CharSequence)fpo.getFieldValue("residues");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not fetch reference sequence.", e);
        }
        int featureLength = cs.length();
        Integer featEnd = end == null ? featureLength : Math.min(end, featureLength);
        CharSequence subSequence = cs.subSequence(start, featEnd);
        HashMap<String, Object> refFeature = new HashMap<String, Object>();
        refFeature.put("start", start);
        refFeature.put("end", featEnd);
        refFeature.put("seq", String.valueOf(subSequence));
        return refFeature;
    }

    private Map<String, Object> makeFeatureWithSubFeatures(FastPathObject fpo) {
        return this.makeFeature(fpo, true);
    }

    private Map<String, Object> makeFeature(FastPathObject fpo, boolean includeSubfeatures) {
        try {
            String primId;
            String symbol;
            String name;
            HashMap<String, Object> feature = new HashMap<String, Object>();
            try {
                feature.put("type", DynamicUtil.getSimpleClassName((FastPathObject)fpo));
            }
            catch (Exception e) {
                feature.put("type", fpo.getClass().getSimpleName());
            }
            try {
                name = (String)fpo.getFieldValue("name");
                symbol = (String)fpo.getFieldValue("symbol");
                primId = (String)fpo.getFieldValue("primaryIdentifier");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Expected a BioEntity, got a " + fpo.getClass().getName());
            }
            feature.put("name", name != null ? name : (symbol != null ? symbol : primId));
            feature.put("symbol", symbol);
            feature.put("uniqueID", primId != null ? primId : fpo.getFieldValue("id"));
            feature.put("score", fpo.getFieldValue("score"));
            try {
                feature.put("description", fpo.getFieldValue("description"));
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            FastPathObject chrLoc = (FastPathObject)fpo.getFieldValue("chromosomeLocation");
            if (chrLoc != null) {
                feature.put("start", (Integer)chrLoc.getFieldValue("start") - 1);
                feature.put("end", chrLoc.getFieldValue("end"));
                feature.put("strand", chrLoc.getFieldValue("strand"));
            }
            if (includeSubfeatures) {
                ArrayList<Map> subFeatures = new ArrayList<Map>();
                Collection childFeatures = (Collection)fpo.getFieldValue("childFeatures");
                if (childFeatures != null && !feature.get("type").toString().contains("Exon") && !feature.get("type").toString().contains("TransposonFragment")) {
                    for (FastPathObject child : childFeatures) {
                        LOG.debug((Object)("CF " + feature.get("type") + " p of -> " + child.getClass().getSimpleName()));
                        if (child.getClass().getSimpleName().startsWith("Intron") || feature.get("type").toString().endsWith(".Gene") && (child.getClass().getSimpleName().startsWith("Exon") || child.getClass().getSimpleName().startsWith("CDS"))) continue;
                        subFeatures.add(this.makeFeatureWithSubFeatures(child));
                    }
                }
                String soType = this.getSOType(feature);
                feature.put("type", soType);
                feature.put("subfeatures", subFeatures);
            }
            return feature;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error reading results", e);
        }
    }

    private String getSOType(Map<String, Object> feature) {
        String path = "org.intermine.model.bio.";
        String camelName = feature.get("type").toString().replace(path, "");
        if (camelName.contentEquals("MiRNA")) {
            return "miRNA";
        }
        if (camelName.contentEquals("SnRNA")) {
            return "snRNA";
        }
        if (camelName.contentEquals("SnoRNA")) {
            return "snoRNA";
        }
        if (camelName.contentEquals("NcRNA")) {
            return "ncRNA";
        }
        if (camelName.contentEquals("LncRNA")) {
            return "lncRNA";
        }
        if (camelName.contentEquals("AntisenseLncRNA")) {
            return "antisense_lncRNA";
        }
        if (camelName.contentEquals("MiRNAPrimaryTranscript")) {
            return "miRNA_primary_transcript";
        }
        StringBuffer so = new StringBuffer();
        int i = 0;
        for (String w : camelName.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])")) {
            if (i > 0) {
                so.append("_");
            }
            so.append(w);
            ++i;
        }
        if (so.toString().contentEquals("CDS")) {
            return so.toString();
        }
        String sosmall = so.toString().toLowerCase();
        if (sosmall.contains("rna")) {
            return sosmall.replace("rna", "RNA");
        }
        if (sosmall.contains("orf")) {
            return sosmall.replace("orf", "ORF");
        }
        if (sosmall.contains("utr")) {
            return sosmall.replace("utr", "UTR");
        }
        return sosmall;
    }

    private Query getReferenceQuery(Command command) {
        PathQuery pq = new PathQuery(this.model);
        String type = command.getType("Chromosome");
        pq.addView(String.format("%s.sequence.id", type));
        pq.addConstraint((PathConstraint)Constraints.eq((String)String.format("%s.organism.taxonId", type), (String)command.getDomain()));
        pq.addConstraint((PathConstraint)Constraints.eq((String)String.format("%s.primaryIdentifier", type), (String)command.getSegment().getSection()));
        return Queries.pathQueryToOSQ((PathQuery)pq);
    }

    private Query getFeatureQuery(Command command) {
        PathQuery pq = new PathQuery(this.model);
        String type = command.getType("SequenceFeature");
        pq.addView(String.format("%s.id", type));
        pq.addConstraint((PathConstraint)Constraints.eq((String)String.format("%s.organism.taxonId", type), (String)command.getDomain()));
        pq.addConstraint((PathConstraint)Engine.makeRangeConstraint((String)type, (Segment)command.getSegment()));
        return Queries.pathQueryToOSQ((PathQuery)pq);
    }
}

