/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.beans.ObjectDetails;
import org.intermine.api.beans.PartnerLink;
import org.intermine.api.mines.Mine;
import org.intermine.api.mines.ObjectRequest;
import org.intermine.metadata.Util;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.InterMineLinkGenerator;
import org.intermine.webservice.server.core.Predicate;

public final class FriendlyMineLinkGenerator
implements InterMineLinkGenerator {
    private static final Logger LOG = Logger.getLogger(FriendlyMineLinkGenerator.class);

    public Collection<PartnerLink> getLinks(Mine thisMine, Mine mine, ObjectRequest req) {
        String organismShortName = req.getDomain();
        String primaryIdentifier = req.getIdentifier();
        if (StringUtils.isEmpty((String)organismShortName) || StringUtils.isEmpty((String)primaryIdentifier)) {
            return Collections.emptySet();
        }
        if (organismShortName.contains(",")) {
            return Collections.emptySet();
        }
        LinkFetcher fetcher = new LinkFetcher(thisMine, mine);
        return fetcher.fetch(req);
    }

    private class LinkFetcher {
        private final Mine thisMine;
        private final Mine thatMine;
        private MustBeIn predicate;

        LinkFetcher(Mine thisMine, Mine mine) {
            this.thisMine = thisMine;
            this.thatMine = mine;
            this.predicate = new MustBeIn(this.thatMine.getDefaultValues());
        }

        Collection<PartnerLink> fetch(ObjectRequest req) {
            PathQuery q;
            Map<String, Set<ObjectDetails>> matches;
            Map<String, Set<ObjectDetails>> genes = this.remoteHomologueStrategy(req);
            if (genes == null || genes.isEmpty()) {
                genes = this.localHomologueStrategy(req);
            }
            if ((matches = this.runQuery(this.thatMine, q = this.getGeneQuery(this.thatMine, req))) != null) {
                genes.putAll(matches);
            }
            return this.toLinks(genes);
        }

        private Map<String, Set<ObjectDetails>> remoteHomologueStrategy(ObjectRequest req) {
            PathQuery q = this.getHomologueQuery(this.thatMine, req);
            return this.runQuery(this.thatMine, q);
        }

        private Map<String, Set<ObjectDetails>> localHomologueStrategy(ObjectRequest req) {
            PathQuery q = this.getHomologueQuery(this.thisMine, req);
            return this.runQuery(this.thisMine, q);
        }

        private PathQuery getHomologueQuery(Mine mine, ObjectRequest req) {
            PathQuery q = new PathQuery(mine.getModel());
            q.addViews(new String[]{"Gene.homologues.homologue.primaryIdentifier", "Gene.homologues.homologue.symbol", "Gene.homologues.homologue.organism.shortName"});
            q.addOrderBy("Gene.homologues.homologue.organism.shortName", OrderDirection.ASC);
            q.addConstraint((PathConstraint)Constraints.lookup((String)"Gene", (String)req.getIdentifier(), (String)req.getDomain()));
            q.addConstraint((PathConstraint)Constraints.neq((String)"Gene.homologues.type", (String)"paralogue"));
            return q;
        }

        private Map<String, Set<ObjectDetails>> runQuery(Mine mine, PathQuery q) {
            HashMap<String, Set<ObjectDetails>> retval = new HashMap<String, Set<ObjectDetails>>();
            List results = mine.getRows(q);
            for (List row : results) {
                if (!this.predicate.call(row).booleanValue()) continue;
                ObjectDetails details = new ObjectDetails();
                details.setType("Gene");
                if (row.get(1) != null) {
                    details.setName((String)row.get(1));
                }
                if (row.get(0) != null) {
                    details.setIdentifier((String)row.get(0));
                }
                Util.addToSetMap(retval, (Object)String.valueOf(row.get(2)), (Object)details);
            }
            return retval;
        }

        private Collection<PartnerLink> toLinks(Map<String, Set<ObjectDetails>> orthologueMapping) {
            HashSet<PartnerLink> retVal = new HashSet<PartnerLink>();
            for (Map.Entry<String, Set<ObjectDetails>> entry : orthologueMapping.entrySet()) {
                String organismName = entry.getKey();
                Set<ObjectDetails> genes = entry.getValue();
                PartnerLink link = new PartnerLink();
                link.setDomain(organismName);
                link.setObjects(genes);
                retVal.add(link);
            }
            return retVal;
        }

        private PathQuery getGeneQuery(Mine mine, ObjectRequest req) {
            PathQuery q = new PathQuery(mine.getModel());
            q.addViews(new String[]{"Gene.primaryIdentifier", "Gene.symbol", "Gene.organism.shortName"});
            q.addOrderBy("Gene.symbol", OrderDirection.ASC);
            q.addConstraint((PathConstraint)Constraints.lookup((String)"Gene", (String)req.getIdentifier(), (String)req.getDomain()));
            return q;
        }
    }

    private class MustBeIn
    implements Predicate<List<Object>> {
        private final Set<String> collection;

        MustBeIn(Set<String> coll) {
            this.collection = coll;
        }

        public Boolean call(List<Object> row) {
            return row != null && this.collection.contains(row.get(2));
        }
    }
}

