/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.mines.FriendlyMineManager;
import org.intermine.api.mines.Mine;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.StringUtil;
import org.intermine.metadata.Util;
import org.intermine.model.bio.Gene;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.util.CacheMap;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class MinePathwaysDisplayer
extends ReportDisplayer {
    private static Map<ReportObject, Map<Mine, String>> minePathwayCache = new CacheMap();
    private static Map<ReportObject, Mine> localMineCache = new CacheMap();
    protected static final Logger LOG = Logger.getLogger(MinePathwaysDisplayer.class);

    public MinePathwaysDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        Gene gene = (Gene)reportObject.getObject();
        request.setAttribute("gene", (Object)gene);
        Map<Mine, String> mineToOrthologues = null;
        Mine localMine = null;
        if (minePathwayCache.get(reportObject) != null) {
            mineToOrthologues = minePathwayCache.get(reportObject);
        } else {
            Map<String, Set<String>> orthologues = this.getLocalHomologues(gene);
            HttpSession session = request.getSession();
            ServletContext servletContext = session.getServletContext();
            Properties webProperties = SessionMethods.getWebProperties((ServletContext)servletContext);
            FriendlyMineManager linkManager = FriendlyMineManager.getInstance((InterMineAPI)this.im, (Properties)webProperties);
            Collection mines = linkManager.getFriendlyMines();
            mineToOrthologues = this.buildHomologueMap(mines, orthologues);
            localMine = linkManager.getLocalMine();
            minePathwayCache.put(reportObject, mineToOrthologues);
        }
        if (localMineCache.get(reportObject) != null) {
            localMine = localMineCache.get(reportObject);
        } else {
            HttpSession session = request.getSession();
            ServletContext servletContext = session.getServletContext();
            Properties webProperties = SessionMethods.getWebProperties((ServletContext)servletContext);
            FriendlyMineManager linkManager = FriendlyMineManager.getInstance((InterMineAPI)this.im, (Properties)webProperties);
            localMine = linkManager.getLocalMine();
            localMineCache.put(reportObject, localMine);
        }
        request.setAttribute("minesForPathways", mineToOrthologues);
        request.setAttribute("localMine", (Object)localMine);
    }

    private Map<Mine, String> buildHomologueMap(Collection<Mine> mines, Map<String, Set<String>> orthologues) {
        HashMap<Mine, String> mineToOrthologues = new HashMap<Mine, String>();
        for (Mine mine : mines) {
            Set remoteMineOrganisms = mine.getDefaultValues();
            StringBuffer genes = new StringBuffer();
            for (Map.Entry<String, Set<String>> entry : orthologues.entrySet()) {
                if (!remoteMineOrganisms.contains(entry.getKey())) continue;
                if (genes.length() > 0) {
                    genes.append(",");
                }
                genes.append(StringUtil.join((Collection)entry.getValue(), (String)","));
            }
            if (genes.length() > 0) {
                mineToOrthologues.put(mine, genes.toString());
                continue;
            }
            mineToOrthologues.put(mine, "");
        }
        return mineToOrthologues;
    }

    private PathQuery getQuery(Gene gene) {
        PathQuery q = new PathQuery(this.im.getModel());
        q.addViews(new String[]{"Gene.homologues.homologue.primaryIdentifier", "Gene.homologues.homologue.secondaryIdentifier", "Gene.homologues.homologue.organism.shortName"});
        q.addConstraint((PathConstraint)Constraints.eq((String)"Gene.primaryIdentifier", (String)gene.getPrimaryIdentifier()));
        q.addOrderBy("Gene.homologues.homologue.organism.shortName", OrderDirection.ASC);
        return q;
    }

    private Map<String, Set<String>> getLocalHomologues(Gene gene) {
        ExportResultsIterator it;
        HashMap<String, Set<String>> orthologues = new HashMap<String, Set<String>>();
        ProfileManager profileManager = this.im.getProfileManager();
        PathQueryExecutor executor = this.im.getPathQueryExecutor(profileManager.getSuperuserProfile());
        PathQuery q = null;
        try {
            q = this.getQuery(gene);
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
        if (!q.isValid()) {
            return Collections.emptyMap();
        }
        try {
            it = executor.execute(q);
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
        while (it.hasNext()) {
            List row = it.next();
            String identifier = (String)((ResultElement)row.get(0)).getField();
            String secondaryIdentifier = (String)((ResultElement)row.get(1)).getField();
            String organism = (String)((ResultElement)row.get(2)).getField();
            if (!StringUtils.isEmpty((String)identifier)) {
                Util.addToSetMap(orthologues, (Object)organism, (Object)identifier);
                continue;
            }
            if (StringUtils.isEmpty((String)secondaryIdentifier)) continue;
            Util.addToSetMap(orthologues, (Object)organism, (Object)secondaryIdentifier);
        }
        return orthologues;
    }
}

