/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.export;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.results.ResultElement;
import org.intermine.bio.io.bed.BEDRecord;
import org.intermine.bio.web.export.BEDUtil;
import org.intermine.bio.web.logic.OrganismGenomeBuildLookup;
import org.intermine.metadata.StringUtil;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.pathquery.Path;
import org.intermine.util.IntPresentSet;
import org.intermine.web.logic.export.ExportException;
import org.intermine.web.logic.export.ExportHelper;
import org.intermine.web.logic.export.Exporter;

public class BEDExporter
implements Exporter {
    PrintWriter out;
    private boolean makeUcscCompatible = true;
    private int writtenResultsCount = 0;
    private boolean headerPrinted = false;
    private List<Integer> featureIndexes;
    private IntPresentSet exportedIds = new IntPresentSet();
    private List<String> orgSet = null;
    private static final String FORMAT = "# UCSC BED format";
    private static final String SOURCE_PRE = "\n# Source: ";
    private String sourceName;
    private static final String GENOME_BUILD_PRE = "\n# Genome Build: ";
    private String genomeBuild = "not available";
    private static final String TRACK_NAME_PRE = "\ntrack name=";
    private String trackName;
    private static final String TRACK_DESCRIPTION_PRE = " description=\"";
    private String trackDescription;
    private static final String TRACK_DESCRIPTION_END = "\"";
    private static final String TRACK_USE_SCORE = " useScore=0";
    private Integer lastLsfId = null;
    private SequenceFeature lastLsf = null;

    public BEDExporter(PrintWriter out, List<Integer> featureIndexes, String sourceName, String organismString, boolean makeUcscCompatible, String trackDescription) {
        this.out = out;
        this.featureIndexes = featureIndexes;
        this.sourceName = sourceName;
        this.makeUcscCompatible = makeUcscCompatible;
        this.trackDescription = trackDescription;
        if ("".equals(trackDescription) || trackDescription == null) {
            this.trackName = "track";
            this.trackDescription = "A Custom Track";
        } else {
            this.trackName = trackDescription.replaceAll(" ", "_");
        }
        if (!"".equals(organismString) && organismString != null) {
            this.orgSet = StringUtil.tokenize((String)organismString, (String)",");
        }
    }

    public void export(Iterator<? extends List<ResultElement>> resultIt) {
        this.export(resultIt, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public void export(Iterator<? extends List<ResultElement>> resultIt, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) {
        if (this.featureIndexes.size() == 0) {
            throw new ExportException("No columns with sequence");
        }
        try {
            while (resultIt.hasNext()) {
                List<ResultElement> row = resultIt.next();
                this.exportRow(row);
            }
            this.finishLastRow();
            if (this.writtenResultsCount == 0) {
                this.out.println("Nothing was found for export");
            }
            this.out.flush();
        }
        catch (Exception ex) {
            throw new ExportException("Export failed", ex);
        }
    }

    private void exportRow(List<ResultElement> row) {
        List<ResultElement> elWithObject = this.getResultElements(row);
        if (elWithObject == null) {
            return;
        }
        for (ResultElement re : elWithObject) {
            try {
                SequenceFeature lsf = (SequenceFeature)re.getObject();
                if (this.exportedIds.contains(lsf.getId()) && !lsf.getId().equals(this.lastLsfId)) continue;
                if (this.lastLsfId != null && !lsf.getId().equals(this.lastLsfId)) {
                    this.makeRecord();
                }
                this.lastLsfId = lsf.getId();
                this.lastLsf = lsf;
            }
            catch (Exception ex) {}
        }
    }

    private String getHeader() {
        StringBuffer header = new StringBuffer();
        if (this.orgSet != null && this.orgSet != null) {
            ArrayList<String> genomeBuildList = new ArrayList<String>();
            for (String org : this.orgSet) {
                String gb = OrganismGenomeBuildLookup.getGenomeBuildbyOrgansimAbbreviation(org);
                if (gb != null && gb.length() > 0) {
                    genomeBuildList.add(org + " " + gb);
                    continue;
                }
                genomeBuildList.add(org + " unknown build");
            }
            if (genomeBuildList.size() > 0) {
                this.genomeBuild = StringUtil.join(genomeBuildList, (String)" | ");
            }
        }
        header.append(FORMAT);
        if (StringUtils.isNotEmpty((String)this.sourceName)) {
            header.append(SOURCE_PRE).append(this.sourceName);
        }
        header.append(GENOME_BUILD_PRE).append(this.genomeBuild).append(TRACK_NAME_PRE).append(this.trackName).append(TRACK_DESCRIPTION_PRE).append(this.trackDescription).append(TRACK_DESCRIPTION_END).append(TRACK_USE_SCORE);
        return header.toString();
    }

    private List<ResultElement> getResultElements(List<ResultElement> row) {
        ArrayList<ResultElement> els = new ArrayList<ResultElement>();
        for (Integer index : this.featureIndexes) {
            if (row.get(index) == null) continue;
            els.add(row.get(index));
        }
        return els;
    }

    private void makeRecord() {
        BEDRecord bedRecord = null;
        if (this.orgSet != null) {
            if (this.orgSet.contains(this.lastLsf.getOrganism().getShortName())) {
                bedRecord = BEDUtil.makeBEDRecord((SequenceFeature)this.lastLsf, (boolean)this.makeUcscCompatible);
            }
        } else {
            bedRecord = BEDUtil.makeBEDRecord((SequenceFeature)this.lastLsf, (boolean)this.makeUcscCompatible);
        }
        if (bedRecord != null) {
            if (!this.headerPrinted) {
                this.out.println(this.getHeader());
                this.headerPrinted = true;
            }
            this.out.println(bedRecord.toBED());
            this.exportedIds.add(this.lastLsf.getId());
            ++this.writtenResultsCount;
        }
        this.lastLsfId = null;
    }

    public int getWrittenResultsCount() {
        return this.writtenResultsCount;
    }

    private void finishLastRow() {
        BEDRecord bedRecord = null;
        if (this.orgSet != null) {
            if (this.orgSet.contains(this.lastLsf.getOrganism().getShortName())) {
                bedRecord = BEDUtil.makeBEDRecord((SequenceFeature)this.lastLsf, (boolean)this.makeUcscCompatible);
            }
        } else {
            bedRecord = BEDUtil.makeBEDRecord((SequenceFeature)this.lastLsf, (boolean)this.makeUcscCompatible);
        }
        if (bedRecord != null) {
            if (!this.headerPrinted) {
                this.out.println(this.getHeader());
                this.headerPrinted = true;
            }
            this.out.println(bedRecord.toBED());
            ++this.writtenResultsCount;
        }
        this.lastLsfId = null;
    }

    public boolean canExport(List<Class<?>> clazzes) {
        return BEDExporter.canExportStatic(clazzes);
    }

    public static boolean canExportStatic(List<Class<?>> clazzes) {
        return ExportHelper.getClassIndex(clazzes, SequenceFeature.class) >= 0;
    }
}

