/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;

public class DiseaseDisplayer
extends ReportDisplayer {
    private static final String RAT = "R. norvegicus";
    protected static final Logger LOG = Logger.getLogger(DiseaseDisplayer.class);

    public DiseaseDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        Integer geneId = reportObject.getObject().getId();
        Set orthologues = this.getLocalHomologues(geneId);
        if (orthologues != null && !orthologues.isEmpty()) {
            request.setAttribute("ratGenes", (Object)StringUtil.join((Collection)orthologues, (String)","));
        }
    }

    private PathQuery getQuery(Integer geneId) {
        PathQuery q = new PathQuery(this.im.getModel());
        q.addViews(new String[]{"Gene.homologues.homologue.primaryIdentifier", "Gene.homologues.homologue.secondaryIdentifier"});
        q.addConstraint((PathConstraint)Constraints.inIds((String)"Gene", Collections.singleton(geneId)));
        q.addConstraint((PathConstraint)Constraints.eq((String)"Gene.homologues.homologue.organism.shortName", (String)RAT));
        return q;
    }

    private Set<String> getLocalHomologues(Integer geneId) {
        ExportResultsIterator it;
        HashSet<String> orthologues = new HashSet<String>();
        ProfileManager profileManager = this.im.getProfileManager();
        PathQueryExecutor executor = this.im.getPathQueryExecutor(profileManager.getSuperuserProfile());
        PathQuery q = null;
        try {
            q = this.getQuery(geneId);
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
        if (!q.isValid()) {
            return Collections.emptySet();
        }
        try {
            it = executor.execute(q);
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
        while (it.hasNext()) {
            List row = it.next();
            String identifier = (String)((ResultElement)row.get(0)).getField();
            String secondaryIdentifier = (String)((ResultElement)row.get(1)).getField();
            if (!StringUtils.isEmpty((String)identifier)) {
                orthologues.add(identifier);
                continue;
            }
            if (StringUtils.isEmpty((String)secondaryIdentifier)) continue;
            orthologues.add(secondaryIdentifier);
        }
        return orthologues;
    }
}

