/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import org.intermine.api.results.ResultCell;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.pathquery.Path;
import org.intermine.util.DynamicUtil;

public final class TableCell
implements ResultCell {
    private final FastPathObject fpo;
    private final boolean isKeyField;
    private final Path column;

    public TableCell(FastPathObject fpo, Path view, boolean isKeyField) {
        this.fpo = fpo;
        this.column = view;
        this.isKeyField = isKeyField;
    }

    public TableCell(Path view) {
        this.fpo = null;
        this.column = view;
        this.isKeyField = false;
    }

    public boolean isKeyField() {
        return this.isKeyField;
    }

    public Object getField() {
        if (this.fpo == null) {
            return null;
        }
        try {
            return this.fpo.getFieldValue(this.column.getEndFieldDescriptor().getName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error retrieving field value for " + this.column, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error retrieving field value for " + this.column, e);
        }
    }

    public FastPathObject getObject() {
        return this.fpo;
    }

    public String getType() {
        if (this.fpo == null) {
            return null;
        }
        String cls = DynamicUtil.getSimpleClassName(this.fpo.getClass());
        return TypeUtil.unqualifiedName((String)cls);
    }

    public Path getPath() {
        return this.column;
    }

    public Integer getId() {
        if (this.fpo instanceof InterMineObject) {
            return ((InterMineObject)this.fpo).getId();
        }
        return null;
    }

    public String toString() {
        return String.format("TableCell [ %s=%s ]", this.column, this.getField());
    }
}

