/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileAlreadyExistsException;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.lists.AuthenticatedListService;
import org.intermine.webservice.server.lists.ListRenameInput;

public class ListRenameService
extends AuthenticatedListService {
    public static final String USAGE = "List Renaming Service\n=====================\nRename a list\nParameters:\noldname: the old name of the list\nnewname: the new name of the list\nNOTE: All requests to this service must authenticate to a valid user account\n";

    public ListRenameService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        ListRenameInput input = new ListRenameInput(this.request, this.bagManager, profile);
        this.output.setHeaderAttributes(this.getHeaderAttributes());
        try {
            profile.renameBag(input.getOldName(), input.getNewName());
        }
        catch (ProfileAlreadyExistsException ex) {
            throw new BadRequestException(ex.getMessage());
        }
        InterMineBag list = (InterMineBag)profile.getSavedBags().get(input.getNewName());
        this.addOutputInfo("listName", list.getName());
        this.addOutputInfo("listSize", "" + list.size());
        this.addOutputInfo("listId", "" + list.getSavedBagId());
    }
}

