/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.SharedBagManager;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.StorableBag;
import org.intermine.api.profile.UserAlreadyShareBagException;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.context.MailAction;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.lists.ListShareCreationService;

public class ListShareCreationService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(ListShareCreationService.class);
    private final ProfileManager pm;
    private final SharedBagManager sbm;

    public ListShareCreationService(InterMineAPI im) {
        super(im);
        this.pm = im.getProfileManager();
        this.sbm = SharedBagManager.getInstance((ProfileManager)this.pm);
    }

    public String getResultsKey() {
        return "share";
    }

    protected void execute() throws Exception {
        InformUserOfNewShare action;
        UserInput input = new UserInput(this);
        try {
            this.sbm.shareBagWithUser(input.bag, input.recipient.getUsername());
        }
        catch (UserAlreadyShareBagException e) {
            throw new BadRequestException("This bag is already shared with this user", (Throwable)e);
        }
        HashMap<String, Set> data = new HashMap<String, Set>();
        data.put(input.bag.getName(), this.sbm.getUsersWithAccessToBag((StorableBag)input.bag));
        if (input.notify.booleanValue() && !input.recipient.prefers("do_not_spam") && !InterMineContext.queueMessage((MailAction)(action = new InformUserOfNewShare(this, input.recipient.getEmailAddress(), input.owner, input.bag)))) {
            LOG.error((Object)"Could not send email message");
        }
        this.addResultItem(data, false);
    }

    static /* synthetic */ ProfileManager.ApiPermission access$000(ListShareCreationService x0) {
        return x0.getPermission();
    }

    static /* synthetic */ String access$100(ListShareCreationService x0, String x1) {
        return x0.getRequiredParameter(x1);
    }

    static /* synthetic */ String access$200(ListShareCreationService x0, String x1) {
        return x0.getRequiredParameter(x1);
    }

    static /* synthetic */ ProfileManager access$300(ListShareCreationService x0) {
        return x0.pm;
    }

    static /* synthetic */ String access$400(ListShareCreationService x0, String x1, String x2) {
        return x0.getOptionalParameter(x1, x2);
    }
}

