/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template.result;

import javax.servlet.http.HttpServletRequest;
import org.intermine.web.logic.template.TemplateResultInput;
import org.intermine.web.logic.template.Templates;
import org.intermine.webservice.server.WebServiceInput;
import org.intermine.webservice.server.WebServiceRequestParser;
import org.intermine.webservice.server.exceptions.BadRequestException;

public class TemplateResultRequestParser
extends WebServiceRequestParser {
    private static final String NAME_PARAMETER = "name";
    private HttpServletRequest request;

    public TemplateResultRequestParser(HttpServletRequest request) {
        this.request = request;
    }

    public TemplateResultInput getInput() {
        TemplateResultInput input = new TemplateResultInput();
        this.parseRequest(input);
        return input;
    }

    private void parseRequest(TemplateResultInput input) {
        super.parseRequest(this.request, (WebServiceInput)input);
        input.setName(this.getRequiredStringParameter(NAME_PARAMETER));
        try {
            input.setConstraints(Templates.parseConstraints((HttpServletRequest)this.request));
        }
        catch (Templates.TemplateValueParseException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        input.setLayout(this.request.getParameter("layout"));
    }

    private String getRequiredStringParameter(String name) {
        String param = this.request.getParameter(name);
        if (param == null || "".equals(param)) {
            throw new BadRequestException("Missing required parameter: " + name);
        }
        return param;
    }
}

