/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.TagManager;
import org.intermine.api.userprofile.Tag;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.logic.widget.CorrectionCoefficient;
import org.intermine.web.logic.widget.EnrichmentWidget;
import org.intermine.web.logic.widget.Widget;
import org.intermine.web.logic.widget.WidgetOptions;
import org.intermine.web.logic.widget.config.EnrichmentWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.widget.EnrichmentJSONProcessor;
import org.intermine.webservice.server.widget.EnrichmentWidgetResultService;
import org.intermine.webservice.server.widget.EnrichmentXMLProcessor;
import org.intermine.webservice.server.widget.FlatFileWidgetResultProcessor;
import org.intermine.webservice.server.widget.WidgetResultProcessor;
import org.intermine.webservice.server.widget.WidgetService;
import org.intermine.webservice.server.widget.WidgetsRequestParser;
import org.intermine.webservice.server.widget.WidgetsServiceInput;

public class EnrichmentWidgetResultService
extends WidgetService {
    private static final Logger LOG = Logger.getLogger(EnrichmentWidgetResultService.class);
    private final WidgetsRequestParser requestParser = new WidgetsRequestParser();
    private static final String BAD_POPULATION_MSG = "One or more of the %1$ss in this list are missing from your background population. The background population should include all %1$ss that were tested as part of your experiment.";

    public EnrichmentWidgetResultService(InterMineAPI im) {
        super(im);
        this.requestParser.parameterIsRequired("maxp");
        this.requestParser.parameterIsRequired("correction");
        this.requestParser.setDefaultValue("correction", this.getProperty("widgets.correction.default"));
        this.requestParser.setDefaultValue("maxp", this.getProperty("widgets.maxp.default"));
    }

    protected boolean canServe(Format format) {
        return format == Format.JSON || format == Format.XML || Format.FLAT_FILES.contains(format);
    }

    protected void execute() throws Exception {
        WidgetsServiceInput input = this.getInput();
        InterMineBag imBag = this.retrieveBag(input.getBagName());
        this.addOutputListInfo(imBag);
        String ids = input.getIds();
        String populationIds = input.getPopulationIds();
        this.addOutputIdsInfo(ids, populationIds);
        LOG.debug((Object)("Enriching with " + input));
        WebConfig webConfig = InterMineContext.getWebConfig();
        WidgetConfig widgetConfig = (WidgetConfig)webConfig.getWidgets().get(input.getWidgetId());
        if (widgetConfig == null || !(widgetConfig instanceof EnrichmentWidgetConfig)) {
            throw new ResourceNotFoundException("Could not find an enrichment widget called \"" + input.getWidgetId() + "\"");
        }
        this.addOutputConfig(widgetConfig);
        String filterSelectedValue = input.getFilter();
        if (StringUtils.isBlank((String)filterSelectedValue)) {
            filterSelectedValue = this.getDefaultFilterValue(widgetConfig, imBag, ids);
        }
        this.addOutputFilter(widgetConfig, filterSelectedValue, imBag, ids);
        this.addOutputUserLogged();
        InterMineBag populationBag = this.getReferencePopulationBag(input);
        if (populationBag != null) {
            if (imBag != null && !this.verifyPopulationContainsBag(imBag, populationBag)) {
                if (input.shouldSavePopulation()) {
                    this.deleteReferencePopulationPreference(input);
                }
                this.addOutputAttribute("message", String.format(BAD_POPULATION_MSG, imBag.getType()));
                return;
            }
            if (!this.verifyPopulationContainsIds(ids, populationBag)) {
                if (input.shouldSavePopulation()) {
                    this.deleteReferencePopulationPreference(input);
                }
                this.addOutputAttribute("message", String.format(BAD_POPULATION_MSG, populationBag.getType()));
                return;
            }
        }
        EnrichmentWidget widget = null;
        try {
            widget = (EnrichmentWidget)widgetConfig.getWidget(imBag, populationBag, this.im.getObjectStore(), (WidgetOptions)input, ids, populationIds);
            if (filterSelectedValue != null) {
                widget.setFilter(filterSelectedValue);
            }
            widget.process();
        }
        catch (IllegalArgumentException e) {
            this.addOutputAttribute("message", e.getMessage());
            this.deleteReferencePopulationPreference(input);
            return;
        }
        catch (ClassCastException e) {
            throw new ResourceNotFoundException("Could not find an enrichment widget called \"" + input.getWidgetId() + "\"");
        }
        this.addOutputInfo("notAnalysed", Integer.toString(widget.getNotAnalysed()));
        this.addOutputInfo("populationCount", Integer.toString(widget.getPopulationCount()));
        this.addOutputPathQuery(widget, widgetConfig);
        this.addOutputExtraAttribute(input, widget);
        this.addOutputResult((Widget)widget);
    }

    protected void addOutputConfig(WidgetConfig config) {
        super.addOutputConfig(config);
        this.addOutputAttribute("label", ((EnrichmentWidgetConfig)config).getLabel());
        this.addOutputAttribute("externalLink", ((EnrichmentWidgetConfig)config).getExternalLink());
    }

    private void addOutputPathQuery(EnrichmentWidget widget, WidgetConfig config) {
        this.addOutputInfo("pathQuery", widget.getPathQuery().toJson());
        this.addOutputInfo("pathConstraint", widget.getPathConstraint());
        this.addOutputInfo("pathQueryForMatches", widget.getPathQueryForMatches().toJson());
    }

    private void addOutputUserLogged() {
        if (this.isProfileLoggedIn()) {
            this.addOutputAttribute("is_logged", "true");
        } else {
            this.addOutputAttribute("is_logged", "false");
        }
    }

    private void addOutputExtraAttribute(WidgetsServiceInput input, EnrichmentWidget widget) throws Exception {
        WidgetResultProcessor processor = this.getProcessor();
        String extra = input.getExtraAttribute();
        CorrectionCoefficient cc = widget.getExtraCorrectionCoefficient();
        if (cc != null) {
            Map extraAttributes = cc.getOutputInfo(extra);
            if (processor instanceof EnrichmentJSONProcessor) {
                String jsonExtraAttribute = ((EnrichmentJSONProcessor)processor).formatExtraAttributes(extraAttributes);
                this.addOutputInfo("extraAttribute", jsonExtraAttribute);
            }
        } else {
            this.addOutputInfo("extraAttribute", null);
        }
    }

    protected WidgetResultProcessor getProcessor() {
        if (this.formatIsJSON()) {
            return EnrichmentJSONProcessor.instance();
        }
        if (this.formatIsXML()) {
            return EnrichmentXMLProcessor.instance();
        }
        return FlatFileWidgetResultProcessor.instance();
    }

    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader((HttpServletResponse)this.response, (String)"result.xml");
        return new StreamedOutput(out, (Formatter)new EnrichmentXMLFormatter(this, null), separator);
    }

    private WidgetsServiceInput getInput() {
        return this.requestParser.getInput(this.request);
    }

    private boolean isProfileLoggedIn() {
        Profile profile = this.getPermission().getProfile();
        return profile.isLoggedIn();
    }

    private InterMineBag getReferencePopulationBag(WidgetsServiceInput input) throws TagManager.TagNamePermissionException, TagManager.TagNameException {
        String populationBagName = input.getPopulationBagName();
        if (populationBagName == null) {
            populationBagName = this.getReferencePopulationPreference(input);
        }
        if ("".equals(populationBagName)) {
            this.addOutputInfo("current_population", null);
        } else {
            this.addOutputInfo("current_population", populationBagName);
        }
        InterMineBag populationBag = null;
        populationBag = this.retrieveBag(populationBagName);
        this.saveReferencePopulationPreference(input);
        return populationBag;
    }

    private void saveReferencePopulationPreference(WidgetsServiceInput input) throws TagManager.TagNamePermissionException, TagManager.TagNameException {
        if (input.shouldSavePopulation() && this.isProfileLoggedIn()) {
            TagManager tm = this.im.getTagManager();
            String tagName = "im:widget:" + input.getWidgetId() + ":" + input.getPopulationBagName();
            this.deleteReferencePopulationPreference(input);
            if (!"".equals(input.getPopulationBagName())) {
                tm.addTag(tagName, input.getBagName(), "bag", this.getPermission().getProfile());
            }
        }
    }

    private void deleteReferencePopulationPreference(WidgetsServiceInput input) {
        if (this.isProfileLoggedIn()) {
            TagManager tm = this.im.getTagManager();
            List currentTags = this.getReferencePopulationTags(input);
            for (Tag tag : currentTags) {
                tm.deleteTag(tag);
            }
        }
    }

    private List<Tag> getReferencePopulationTags(WidgetsServiceInput input) {
        ArrayList<Tag> populationTags = new ArrayList<Tag>();
        if (this.isProfileLoggedIn()) {
            Profile profile = this.getPermission().getProfile();
            TagManager tm = this.im.getTagManager();
            String prefixTagPopulation = "im:widget:" + input.getWidgetId() + ":";
            List tags = tm.getTags(null, null, "bag", profile.getUsername());
            for (Tag tag : tags) {
                if (!tag.getObjectIdentifier().equals(input.getBagName()) || !tag.getTagName().startsWith(prefixTagPopulation)) continue;
                populationTags.add(tag);
            }
        }
        return populationTags;
    }

    private String getReferencePopulationPreference(WidgetsServiceInput input) {
        List populationTags;
        if (this.isProfileLoggedIn() && !(populationTags = this.getReferencePopulationTags(input)).isEmpty()) {
            String prefixTagPopulation = "im:widget:" + input.getWidgetId() + ":";
            String tagName = ((Tag)populationTags.get(0)).getTagName();
            return tagName.replace(prefixTagPopulation, "");
        }
        return "";
    }

    private boolean verifyPopulationContainsBag(InterMineBag bag, InterMineBag populationBag) {
        ArrayList bagContentdIds;
        ArrayList populationBagContentdIds = new ArrayList(populationBag.getContentsAsIds());
        return populationBagContentdIds.containsAll(bagContentdIds = new ArrayList(bag.getContentsAsIds()));
    }

    private boolean verifyPopulationContainsIds(String ids, InterMineBag populationBag) {
        ArrayList populationBagContentdIds = new ArrayList(populationBag.getContentsAsIds());
        String[] idArray = ids.split(",");
        ArrayList<Integer> idsList = new ArrayList<Integer>();
        for (String id : idArray) {
            try {
                idsList.add(Integer.valueOf(id.trim()));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("List of IDs contains invalid integer: " + id, e);
            }
        }
        return populationBagContentdIds.containsAll(idsList);
    }
}

