
/*
 * CanvasXpress 4.1 - JavaScript Canvas Library
 *
 * Copyright (c) 2009-2010 Isaac Neuhaus
 *
 * imnphd@gmail.com
 *
 * Redistributions of this source code must retain this copyright
 * notice and the following disclaimer.
 *
 * CanvasXpress is licensed under the terms of the Open Source
 * LGPL 3.0 license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Commercial use is permitted to the extent that this source code
 * do NOT become part of any other Open Source or Commercially licensed
 * development library or toolkit without explicit permission.
 *
 * Network graphs were implemented based on the HeyGraph by Tom Martin
 * <http://www.heychinaski.com>.
 *
 * Thanks to Mingyi Liu for his contributions in extending the Ext panel
 * and adding major capabilities to the network graphs and animations.
 *
 */

function str_repeat(b,a){for(var c=[];a>0;c[--a]=b){}return(c.join(""))}function sprintf(){var g=0,e,h=arguments[g++],k=[],d,j,l,b;while(h){if(d=/^[^\x25]+/.exec(h)){k.push(d[0])}else{if(d=/^\x25{2}/.exec(h)){k.push("%")}else{if(d=/^\x25(?:(\d+)\$)?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(h)){if(((e=arguments[d[1]||g++])==null)||(e==undefined)){throw ("Too few arguments.")}if(/[^s]/.test(d[7])&&(typeof(e)!="number")){throw ("Expecting number but found "+typeof(e))}switch(d[7]){case"b":e=e.toString(2);break;case"c":e=String.fromCharCode(e);break;case"d":e=parseInt(e);break;case"e":e=d[6]?e.toExponential(d[6]):e.toExponential();break;case"f":e=d[6]?parseFloat(e).toFixed(d[6]):parseFloat(e);break;case"o":e=e.toString(8);break;case"s":e=((e=String(e))&&d[6]?e.substring(0,d[6]):e);break;case"u":e=Math.abs(e);break;case"x":e=e.toString(16);break;case"X":e=e.toString(16).toUpperCase();break}e=(/[def]/.test(d[7])&&d[2]&&e>0?"+"+e:e);l=d[3]?d[3]=="0"?"0":d[3].charAt(1):" ";b=d[5]-String(e).length;j=d[5]?str_repeat(l,b):"";k.push(d[4]?e+j:j+e)}else{throw ("Huh ?!")}}}h=h.substring(d[0].length)}return k.join("")};var dateFormat=function(){var a=/d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,b=/\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,d=/[^-+\dA-Z]/g,c=function(f,e){f=String(f);e=e||2;while(f.length<e){f="0"+f}return f};return function(i,v,q){var g=dateFormat;if(arguments.length==1&&Object.prototype.toString.call(i)=="[object String]"&&!/\d/.test(i)){v=i;i=undefined}i=i?new Date(i):new Date;if(isNaN(i)){throw SyntaxError("invalid date")}v=String(g.masks[v]||v||g.masks["default"]);if(v.slice(0,4)=="UTC:"){v=v.slice(4);q=true}var t=q?"getUTC":"get",l=i[t+"Date"](),e=i[t+"Day"](),j=i[t+"Month"](),p=i[t+"FullYear"](),r=i[t+"Hours"](),k=i[t+"Minutes"](),u=i[t+"Seconds"](),n=i[t+"Milliseconds"](),f=q?0:i.getTimezoneOffset(),h={d:l,dd:c(l),ddd:g.i18n.dayNames[e],dddd:g.i18n.dayNames[e+7],m:j+1,mm:c(j+1),mmm:g.i18n.monthNames[j],mmmm:g.i18n.monthNames[j+12],yy:String(p).slice(2),yyyy:p,h:r%12||12,hh:c(r%12||12),H:r,HH:c(r),M:k,MM:c(k),s:u,ss:c(u),l:c(n,3),L:c(n>99?Math.round(n/10):n),t:r<12?"a":"p",tt:r<12?"am":"pm",T:r<12?"A":"P",TT:r<12?"AM":"PM",Z:q?"UTC":(String(i).match(b)||[""]).pop().replace(d,""),o:(f>0?"-":"+")+c(Math.floor(Math.abs(f)/60)*100+Math.abs(f)%60,4),S:["th","st","nd","rd"][l%10>3?0:(l%100-l%10!=10)*l%10]};return v.replace(a,function(m){return m in h?h[m]:m.slice(1,m.length-1)})}}();dateFormat.masks={"default":"ddd mmm dd yyyy HH:MM:ss",shortDate:"m/d/yy",mediumDate:"mmm d, yyyy",longDate:"mmmm d, yyyy",fullDate:"dddd, mmmm d, yyyy",shortTime:"h:MM TT",mediumTime:"h:MM:ss TT",longTime:"h:MM:ss TT Z",isoDate:"yyyy-mm-dd",isoTime:"HH:MM:ss",isoDateTime:"yyyy-mm-dd'T'HH:MM:ss",isoUtcDateTime:"UTC:yyyy-mm-dd'T'HH:MM:ss'Z'"};dateFormat.i18n={dayNames:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],monthNames:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","January","February","March","April","May","June","July","August","September","October","November","December"]};Date.prototype.format=function(a,b){return dateFormat(this,a,b)};if(typeof(CanvasXpress)=="undefined"){CanvasXpress={}}var CanvasXpress=function(f,d,a,b,c,e){if(!f){f=this.createNewTarget()}else{if(typeof(f)=="object"){d=f.data||false;a=f.config||false;b=f.events||false;c=f.hidden||false;e=f.info||false;f=f.renderTo||this.createNewTarget()}}this.validateParameters=function(){this.validateData();this.validateConfig();this.validateEvents();this.validateInfo()};this.validateData=function(){if(d&&!this.subBrowser){try{JSON.stringify(d)}catch(g){alert("Data object malformed:\n"+g)}}};this.validateConfig=function(){if(!a){a={}}else{if(!this.subBrowser){try{JSON.stringify(a)}catch(g){alert("Config object malformed:\n"+g)}}}this.userConfig=a};this.validateEvents=function(){};this.validateInfo=function(){if(!e){e=""}};this.createNewTarget=function(){var k=document.createElement("canvas");var j=0;var g="canvasXpress"+j;var h=document.getElementById(g);while(h){j++;g="canvasXpress"+j;h=document.getElementById(g)}k.id=g;document.body.appendChild(k);return g};this.insertTarget=function(j,l,i,k,g){if(j&&l){var m=document.getElementById(j);if(m){return}else{m=document.createElement("canvas")}m.id=j;m.width=i;m.height=k;if(g){l.parentNode.insertBefore(m,l.nextSibling)}else{l.parentNode.insertBefore(m,l)}}};this.removeTarget=function(g){var h=document.getElementById(g);if(h){h.parentNode.removeChild(h)}};this.setConfig=function(g){if(a.graphType=="Network"){if(!a.backgroundType){this.backgroundType="gradient";this.nodeFontColor=this.background}}if(a){for(var h=0;h<g.length;h++){var j=g[h];if(a.hasOwnProperty(j)){this[j]=a[j]}}}if(this.isVML){this.showAnimation=false}};this.setInitialConfig=function(){if(a){for(var g in a){this[g]=a[g]}}};this.resetConfig=function(g){var j={};for(var h=0;h<g.length;h++){j[g[h]]=this[g[h]]}this.initConfig(true);for(var h in j){this[h]=j[h]}};this.updateConfig=function(h){if(h){this.userConfig=h;for(var g in h){this[g]=h[g]}}};this.getConfig=function(){var k={};for(var h=0;h<this.config.length;h++){var g=this.config[h];if(this[g]!=undefined){k[g]=this[g]}}return k};this.getUserConfig=function(){return this.userConfig};this.updateData=function(g){this.initData(g);this.initEvents();this.initGraph()};this.save=function(){return{renderTo:this.target,data:this.data,config:this.getConfig(),events:this.events}};this.print=function(g){return function(h){alert("A new window will open so you can right click on the graph and save it");if(g.isIE){var j=g.canvas.parentNode.childNodes[0];return window.open().document.write("<html><body>"+j.innerHTML+"</body></html>")}else{var i=g.canvas.toDataURL("image/png");return window.open().document.write('<html><body><img src="'+i+'" /></body></html>')}}}(this);this.prettyJSON=function(g,p){var q=function(i){if(typeof(i)=="object"){if(i===null){return"null"}if(i.constructor==(new Array).constructor){return"array"}if(i.constructor==(new Date).constructor){return"date"}if(i.constructor==(new RegExp).constructor){return"regex"}return"object"}return typeof(i)};if(!p){p=""}var r;var m="  ";var h=q(g);var j=0;if(h=="array"){if(g.length==0){return"[]"}r="["}else{for(var n in g){j++;break}if(j==0){return"{}"}r="{"}j=0;for(var l in g){v=g[l];if(j>0){r+=","}if(h=="array"){r+=("\n"+p+m)}else{r+=("\n"+p+m+'"'+l+'": ')}switch(q(v)){case"array":case"object":r+=this.prettyJSON(v,(p+m));break;case"boolean":case"number":r+=v.toString();break;case"null":r+="null";break;case"string":r+=('"'+v+'"');break;default:r+=("TYPEOF: "+typeof(v))}j++}if(h=="array"){r+=("\n"+p+"]")}else{r+=("\n"+p+"}")}return r};this.dumpToConsole=function(g){console.log(this.target);console.log(this.prettyJSON(g))};this.stack=function(){if(this.debug){for(var g in this){if(arguments.callee.caller===this[g]){CanvasXpress.stack[this.target].push(g);return}}}};this.setCanvas=function(){this.version=4.1;this.target=f;this.events=b;this.info=e;var g=document.getElementById("wrapper-"+this.target);if(!g){var i=document.createElement("div");i.id="wrapper-"+this.target;i.style.position="relative";i.style.cssFloat="left";if(c){i.style.display="none"}var j=document.getElementById(this.target);var h=j.parentNode;h.insertBefore(i,j);i.appendChild(j.parentNode.appendChild(j))}this.canvas=this.browser=="Explorer"&&(this.browserVersion<9&&navigator.userAgent.toLowerCase().indexOf("chromeframe")<0)?window.G_vmlCanvasManager.initElement(j):j;this.ctx=this.canvas.getContext("2d")};this.setPath=function(){var j=document.getElementsByTagName("script");if(j){for(var h=0;h<j.length;h++){if(!j[h].src){continue}var k=j[h].src;var g=k.lastIndexOf("/");var m=k.substring(0,g+1);var l=k.substring(g+1);if(l.match(/canvasXpress/)){this.path=m}}}};this.initialize=function(){this.initBrowser();this.validateParameters();this.addCSS();this.setPath();this.setCanvas();this.initConfig();this.isGoogleChromeFrame();this.initData(d);this.initLayout();this.initEvents();this.initAnimation();this.initRemote();this.initGraph()};this.initialize();CanvasXpress.references.push(this);CanvasXpress.stack[this.target]=[]};CanvasXpress.references=[];CanvasXpress.cacheImages={};CanvasXpress.stack={};CanvasXpress.prototype.addCSS=function(){var a="table.shorts {border: 1px solid; border-collapse: collapse; font-size: x-small}";a+="td.k {text-align: center; padding: 2px 5px; margin: 2px 5px; border: 1px solid;}";a+="td.d {padding: 2px 5px; margin: 2px 5px; border: 1px solid;}";a+="th.d {padding: 2px 5px; margin: 2px 5px; border: 1px solid;}";a+="th.cxx, th.cxz, th.cxb, th.cxs, th.cxv, td.cxx, td.cxz, td.cxb, td.cxs, td.cxv {padding: 2px 5px; margin: 2px 5px; border: 1px solid; valign: center;}";a+="td.cxx, td.cxz, td.cxb, td.cxs, td.cxv {background: #fefefe}";a+="th.cxx, th.cxz, th.cxb, th.cxs, th.cxv {background: #d4d0c8}";a+="td.cxy {border: 1px solid; valign: center; text-align: right;}";a+="div.cxc {width: 100%; height: 100%; overflow: hidden;}";var b=document.createElement("style");b.type="text/css";if(b.styleSheet){b.styleSheet.cssText=a}else{b.appendChild(document.createTextNode(a))}document.getElementsByTagName("head")[0].appendChild(b)};CanvasXpress.prototype.initBrowser=function(){this.isGoogleChromeFrame=function(){if(this.browser=="Explorer"&&this.checkGoogleChromeFrame){if(this.browserVersion<9){if(navigator.userAgent.toLowerCase().indexOf("chromeframe")<0){try{var b=document.createElement("script");b.type="text/javascript";b.src="http://ajax.googleapis.com/ajax/libs/chrome-frame/1/CFInstall.min.js";document.getElementsByTagName("head")[0].appendChild(b);CFInstall.check({mode:"overlay"})}catch(a){alert("CanvasXpress works much faster in HTML 5 compliant browsers.\nPlease consider installing Google chrome frame to make this browser compliant.")}}}}};this.dataBrowser=[{string:navigator.userAgent,subString:"Chrome",identity:"Chrome"},{string:navigator.userAgent,subString:"OmniWeb",versionSearch:"OmniWeb/",identity:"OmniWeb"},{string:navigator.vendor,subString:"Apple",identity:"Safari",versionSearch:"Version"},{prop:window.opera,identity:"Opera"},{string:navigator.vendor,subString:"iCab",identity:"iCab"},{string:navigator.vendor,subString:"KDE",identity:"Konqueror"},{string:navigator.userAgent,subString:"Firefox",identity:"Firefox"},{string:navigator.vendor,subString:"Camino",identity:"Camino"},{string:navigator.userAgent,subString:"Netscape",identity:"Netscape"},{string:navigator.userAgent,subString:"MSIE",identity:"Explorer",versionSearch:"MSIE"},{string:navigator.userAgent,subString:"Gecko",identity:"Mozilla",versionSearch:"rv"},{string:navigator.userAgent,subString:"Mozilla",identity:"Netscape",versionSearch:"Mozilla"},{string:navigator.platform,subString:"iPhone",identity:"iPhone"},{string:navigator.platform,subString:"iPod",identity:"iPod"},{string:navigator.userAgent,subString:"iPad",identity:"iPad"},{string:navigator.userAgent,subString:"Android",identity:"Android"},{string:navigator.userAgent,subString:"BlackBerry",identity:"BlackBerry"}];this.dataOS=[{string:navigator.platform,subString:"Win",identity:"Windows"},{string:navigator.platform,subString:"Mac",identity:"Mac"},{string:navigator.platform,subString:"iPhone",identity:"iPhone"},{string:navigator.platform,subString:"iPod",identity:"iPod"},{string:navigator.userAgent,subString:"iPad",identity:"iPad"},{string:navigator.userAgent,subString:"Android",identity:"Android"},{string:navigator.userAgent,subString:"BlackBerry",identity:"BlackBerry"},{string:navigator.platform,subString:"Linux",identity:"Linux"}];this.isSubstandardBrowser=function(){if((this.browser=="Firefox"&&this.browserVersion>4)||(this.browser=="Opera"&&this.browserVersion>9)||(this.browser=="Safari"&&this.browserVersion>4)||(this.browser=="Chrome"&&this.browserVersion>1)){return false}else{return true}};this.isMobileApp=function(){if(this.browser.match(/iPhone|iPod|iPad|Android|BlackBerry/i)){return true}else{return false}};this.searchString=function(d){for(var a=0;a<d.length;a++){var b=d[a].string;var c=d[a].prop;this.versionSearchString=d[a].versionSearch||d[a].identity;if(b){if(b.indexOf(d[a].subString)!=-1){return d[a].identity}}else{if(c){return d[a].identity}}}};this.searchVersion=function(b){var a=b.indexOf(this.versionSearchString);if(a==-1){return}return parseFloat(b.substring(a+this.versionSearchString.length+1))};this.initializeBrowser=function(){this.browser=this.searchString(this.dataBrowser)||"An unknown browser";this.browserVersion=this.searchVersion(navigator.userAgent)||this.searchVersion(navigator.appVersion)||"an unknown version";this.browserOS=this.searchString(this.dataOS)||"an unknown OS";if(this.browser=="Explorer"){this.isIE=true;this.subBrowser=true;this.mobileApp=false;if(this.browserVersion>=9){this.isVML=false}else{if(navigator.userAgent.toLowerCase().indexOf("chromeframe")<0){this.isVML=true}else{this.isVML=false}}}else{this.isIE=false;this.subBrowser=this.isSubstandardBrowser();this.mobileApp=this.isMobileApp();this.isVML=false}};this.initializeBrowser()};CanvasXpress.prototype.initConfig=function(a){this.config=[];this.graphType="Bar";this.config.push("graphType");this.graphOrientation="horizontal";this.config.push("graphOrientation");this.foreground="rgb(0,0,0)";this.config.push("foreground");this.foregroundWindow="rgb(0,0,0)";this.config.push("foregroundWindow");this.background="rgb(255,255,255)";this.config.push("background");this.backgroundWindow="rgb(255,255,255)";this.config.push("backgroundWindow");this.backgroundType="solid";this.config.push("backgroundType");this.backgroundImage=false;this.config.push("backgroundImage");this.backgroundWindowGradientOrientation="vertical";this.config.push("backgroundWindowGradientOrientation");this.backgroundGradient1Color="rgb(0,0,200)";this.config.push("backgroundGradient1Color");this.backgroundGradient2Color="rgb(0,0,36)";this.config.push("backgroundGradient2Color");this.backgroundWindowGradient1Color="rgb(0,0,200)";this.config.push("backgroundWindowGradient1Color");this.backgroundWindowGradient2Color="rgb(0,0,36)";this.config.push("backgroundWindowGradient2Color");this.gradient=false;this.config.push("gradient");this.gradientType="radial";this.config.push("gradientType");this.gradientRatio=1.3;this.config.push("gradientRatio");this.transparency=null;this.config.push("transparency");this.margin=5;this.config.push("margin");this.marginLeft=20;this.config.push("marginLeft");this.marginTop=20;this.config.push("marginTop");this.marginBottom=20;this.config.push("marginBottom");this.marginRight=20;this.config.push("marginRight");this.showShadow=false;this.config.push("showShadow");this.shadowOffsetX=3;this.config.push("shadowOffsetX");this.shadowOffsetY=3;this.config.push("shadowOffsetY");this.shadowBlur=2;this.config.push("shadowBlur");this.shadowColor="rgba(0,0,0,0.5)";this.config.push("shadowColor");this.canvasBox=true;this.config.push("canvasBox");this.canvasBoxColor="rgb(0,0,0)";this.config.push("canvasBoxColor");this.autoAdjust=true;this.config.push("autoAdjust");this.functions=[];this.fonts=this.isVML||this.subBrowser?["Gentilis","Helvetiker","Optimer"]:["Gentilis","Helvetiker","Optimer","Verdana, sans-serif"];this.fontName=this.isVML?"Gentilis":this.subBrowser?"Optimer":"Verdana, sans-serif";this.config.push("fontName");this.fontStyle=false;this.config.push("fontStyle");this.fontSize=12;this.config.push("fontSize");this.font=this.fontStyle?this.fontStyle+this.fontSize+"pt "+this.fontName:this.fontSize+"pt "+this.fontName;this.align="center";this.config.push("align");this.baseline="middle";this.config.push("baseline");this.maxTextSize=14;this.config.push("maxTextSize");this.minTextSize=4;this.config.push("minTextSize");this.autoScaleFont=true;this.config.push("autoScaleFont");this.scaleTextConstantMult=40;this.scaleTextConstantAdd=2.5;this.title=false;this.config.push("title");this.titleHeight=30;this.config.push("titleHeight");this.subtitle=false;this.config.push("subtitle");this.subtitleHeight=16;this.config.push("subtitleHeight");this.dashLength=8;this.config.push("dashLength");this.dotLength=5;this.config.push("dotLength");this.arrowPointSize=10;this.config.push("arrowPointSize");this.capType="butt";this.config.push("capType");this.outlineWidth=1;this.config.push("outlineWidth");this.lines=[];this.colorScheme="user";this.config.push("colorScheme");this.colors=["rgb(255,0,0)","rgb(0,0,255)","rgb(0,255,0)","rgb(255,255,0)","rgb(0,255,255)","rgb(255,0,255)","rgb(153,51,0)","rgb(0,0,128)","rgb(128,128,0)","rgb(255,102,0)","rgb(0,128,128)","rgb(102,0,102)","rgb(255,153,204)","rgb(102,102,153)","rgb(51,51,0)","rgb(255,204,153)","rgb(204,255,255)","rgb(153,153,255)","rgb(255,128,128)","rgb(51,102,255)","rgb(51,153,102)","rgb(255,204,0)","rgb(0,204,255)","rgb(208,32,144)","rgb(153,51,102)","rgb(0,102,204)","rgb(153,204,0)","rgb(255,153,0)","rgb(51,204,204)","rgb(204,153,255)","rgb(128,0,0)","rgb(51,51,153)","rgb(0,128,0)","rgb(255,255,204)","rgb(153,204,255)","rgb(128,0,128)"];this.colors0=["rgb(0,0,255)","rgb(255,0,77)","rgb(255,191,0)","rgb(116,255,0)","rgb(164,0,255)","rgb(255,116,0)","rgb(255,255,0)","rgb(0,255,255)","rgb(255,0,0)","rgb(255,211,0)","rgb(61,0,255)","rgb(0,255,0)","rgb(255,0,255)","rgb(255,146,0)","rgb(211,255,0)","rgb(0,144,255)","rgb(109,0,255)","rgb(255,73,0)","rgb(255,232,0)","rgb(0,255,146)","rgb(255,0,144)","rgb(255,170,0)","rgb(170,255,0)","rgb(0,77,255)"];this.colors1=["rgb(60,60,157)","rgb(157,60,90)","rgb(157,133,60)","rgb(104,157,60)","rgb(122,60,157)","rgb(157,104,60)","rgb(157,157,60)","rgb(60,157,157)","rgb(157,60,60)","rgb(157,140,60)","rgb(83,60,157)","rgb(60,157,60)","rgb(157,60,157)","rgb(157,115,60)","rgb(140,157,60)","rgb(60,115,157)","rgb(102,60,157)","rgb(157,88,60)","rgb(157,148,60)","rgb(60,157,115)","rgb(157,60,115)","rgb(157,125,60)","rgb(125,157,60)","rgb(60,90,157)"];this.colors2=["rgb(0,0,117)","rgb(117,0,36)","rgb(117,88,0)","rgb(53,117,0)","rgb(76,0,117)","rgb(117,53,0)","rgb(117,117,0)","rgb(0,117,117)","rgb(117,0,0)","rgb(117,97,0)","rgb(28,0,117)","rgb(0,117,0)","rgb(117,0,117)","rgb(117,67,0)","rgb(97,117,0)","rgb(0,66,117)","rgb(50,0,117)","rgb(117,33,0)","rgb(117,107,0)","rgb(0,117,67)","rgb(117,0,66)","rgb(117,78,0)","rgb(78,117,0)","rgb(0,36,117)"];this.colors3=["rgb(101,101,255)","rgb(255,101,147)","rgb(255,216,101)","rgb(171,255,101)","rgb(200,101,255)","rgb(255,171,101)","rgb(255,255,101)","rgb(101,255,255)","rgb(255,101,101)","rgb(255,229,101)","rgb(137,101,255)","rgb(101,255,101)","rgb(255,101,255)","rgb(255,189,101)","rgb(229,255,101)","rgb(101,188,255)","rgb(167,101,255)","rgb(255,145,101)","rgb(255,241,101)","rgb(101,255,189)","rgb(255,101,188)","rgb(255,204,101)","rgb(204,255,101)","rgb(101,147,255)"];this.colors4=["rgb(181,181,255)","rgb(255,181,203)","rgb(255,237,181)","rgb(215,255,181)","rgb(229,181,255)","rgb(255,215,181)","rgb(255,255,181)","rgb(181,255,255)","rgb(255,181,181)","rgb(255,242,181)","rgb(199,181,255)","rgb(181,255,181)","rgb(255,181,255)","rgb(255,223,181)","rgb(242,255,181)","rgb(181,223,255)","rgb(213,181,255)","rgb(255,202,181)","rgb(255,248,181)","rgb(181,255,223)","rgb(255,181,223)","rgb(255,230,181)","rgb(230,255,181)","rgb(181,203,255)"];this.config.push("colors");this.shapes=["sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","pacman","mdavid","rect2","rect3","rectangle","image"];this.sizes=[4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34];this.images=[];this.config.push("images");this.timeFormat="isoDate";this.config.push("timeFormat");this.maxSmpStringLen=50;this.config.push("maxSmpStringLen");this.maxVarStringLen=30;this.config.push("maxVarStringLen");this.smpLabelDescription=false;this.config.push("smpLabelDescription");this.smpTitle=false;this.config.push("smpTitle");this.smpTitleFontSize=10;this.config.push("smpTitleFontSize");this.smpTitleFont=(this.smpTitleFontSize)+"Pt "+this.fontName;this.smpTitleColor=this.foreground;this.config.push("smpTitleColor");this.smpTitleScaleFontFactor=1;this.config.push("smpTitleScaleFontFactor");this.smpLabelFontSize=10;this.config.push("smpLabelFontSize");this.smpLabelFont=(this.smpLabelFontSize)+"Pt "+this.fontName;this.smpLabelColor=this.foreground;this.config.push("smpLabelColor");this.smpLabelScaleFontFactor=1;this.config.push("smpLabelScaleFontFactor");this.smpLabelRotate=0;this.config.push("smpLabelRotate");this.varLabelDescription=false;this.config.push("varLabelDescription");this.varTitle=false;this.config.push("varTitle");this.varTitleFontSize=10;this.config.push("varTitleFontSize");this.varTitleFont=(this.varTitleFontSize)+"Pt "+this.fontName;this.varTitleColor=this.foreground;this.config.push("varTitleColor");this.varTitleScaleFontFactor=1;this.config.push("varTitleScaleFontFactor");this.varLabelFontSize=10;this.config.push("varLabelFontSize");this.varLabelFont=(this.varLabelFontSize)+"Pt "+this.fontName;this.varLabelColor=this.foreground;this.config.push("varLabelColor");this.varLabelScaleFontFactor=1;this.config.push("varLabelScaleFontFactor");this.varLabelRotate=0;this.config.push("varLabelRotate");this.varTitleLabelOverlayPosition="bottom";this.config.push("varTitleLabelOverlayPosition");this.showSampleNames=true;this.config.push("showSampleNames");this.showVariableNames=true;this.config.push("showVariableNames");this.highlightVar=[];this.config.push("highlightVar");this.highlightSmp=[];this.config.push("highlightSmp");this.highlightNode=[];this.config.push("highlightNode");this.smpHighlightColor="rgb(255,0,0)";this.config.push("smpHighlightColor");this.varHighlightColor="rgb(255,0,0)";this.config.push("varHighlightColor");this.nodeHighlightColor="rgb(255,0,0)";this.config.push("nodeHighlightColor");this.selectNode={};this.isSelectNodes=0;this.overlaysWidth=30;this.config.push("overlaysWidth");this.overlays=[];this.smpOverlays=[];this.config.push("smpOverlays");this.varOverlays=[];this.config.push("varOverlays");this.showOverlays=true;this.config.push("showOverlays");this.overlayFontSize=6;this.config.push("overlayFontSize");this.overlayFont=(this.overlayFontSize)+"Pt "+this.fontName;this.overlayFontColor=this.foreground;this.config.push("overlayFontColor");this.overlayScaleFontFactor=1;this.config.push("overlayScaleFontFactor");this.showLegend=true;this.config.push("showLegend");this.legendPosition="right";this.config.push("legendPosition");this.legendColor=this.foreground;this.config.push("legendColor");this.legendBox=true;this.config.push("legendBox");this.legendBoxColor="rgb(0,0,0)";this.config.push("legendBoxColor");this.legendBackgroundColor=this.background;this.config.push("legendBackgroundColor");this.legendFontSize=10;this.config.push("legendFontSize");this.legendFont=(this.legendFontSize)+"Pt "+this.fontName;this.legendScaleFontFactor=1;this.config.push("legendScaleFontFactor");this.showIndicators=true;this.config.push("showIndicators");this.indicatorsPosition="bottom";this.config.push("indicatorsPosition");this.showDecorations=false;this.config.push("showDecorations");this.decorationsPosition="bottom";this.config.push("decorationsPosition");this.decorationsColor=this.foreground;this.config.push("decorationsColor");this.decorationFontSize=10;this.config.push("decorationFontSize");this.decorationFont=(this.decorationFontSize)+"Pt "+this.fontName;this.decorationScaleFontFactor=1;this.config.push("decorationScaleFontFactor");this.decorationsWidth=10;this.config.push("decorationsWidth");this.decorationsHeight=20;this.config.push("decorationsHeight");this.decorationsType="bar";this.config.push("decorationsType");this.decorations=[];this.config.push("decorations");this.decorationsColors=[];this.config.push("decorationsColors");this.axisTickColor=this.foreground;this.config.push("axisTickColor");this.axisTickFontSize=10;this.config.push("axisTickFontSize");this.axisTickFont=(this.axisTickFontSize)+"Pt "+this.fontName;this.tickScaleFontFactor=1;this.config.push("tickScaleFontFactor");this.tickRotate=0;this.config.push("tickRotate");this.axisTitleColor=this.foreground;this.config.push("axisTitleColor");this.axisTitleFontSize=10;this.config.push("axisTitleFontSize");this.axisTitleFont=(this.axisTitleFontSize)+"Pt "+this.fontName;this.axisTitleScaleFontFactor=1;this.config.push("axisTitleScaleFontFactor");this.isGroupedData=false;this.isTransformedData=false;this.isBoxPlotCalc=false;this.isMarketDataFormated=false;this.isMarketSwitched=false;this.isGraphTime=false;this.config.push("isGraphTime");this.groupingFactors=[];this.config.push("groupingFactors");this.segregateSamplesBy=false;this.config.push("segregateSamplesBy");this.segregateVariablesBy=false;this.config.push("segregateVariablesBy");this.isLogData=false;this.config.push("isLogData");this.smpSort=-1;this.varSort=-1;this.tmpAsciiArray=[];this.sortDir="ascending";this.config.push("sortDir");this.transformBase=2;this.config.push("transformBase");this.transformType=false;this.config.push("transformType");this.ratioReference=0;this.config.push("ratioReference");this.zscoreAxis="samples";this.config.push("zscoreAxis");this.showErrorBars=true;this.config.push("showErrorBars");this.randomData=false;this.config.push("randomData");this.randomDataMean=100;this.config.push("randomDataMean");this.randomDataSigma=50;this.config.push("randomDataSigma");this.randomDataVariables=6;this.config.push("randomDataVariables");this.randomDataSamples=12;this.config.push("randomDataSamples");this.randomDataVariableAnnotations=2;this.config.push("randomDataVariableAnnotations");this.randomDataSampleAnnotations=3;this.config.push("randomDataSampleAnnotations");this.randomDataVariableAnnotationRatio=2;this.config.push("randomDataVariableAnnotationRatio");this.randomDataSampleAnnotationRatio=2;this.config.push("randomDataSampleAnnotationRatio");this.randomMissingDataPercentage=0;this.config.push("randomMissingDataPercentage");this.missingDataColor="rgb(255,255,0)";this.config.push("missingDataColor");this.zoom=1;this.config.push("zoom");this.zoomStep=0.1;this.config.push("zoomStep");this.panningX=0;this.config.push("panningX");this.panningY=0;this.config.push("panningY");this.panningGlobalX=0;this.panningGlobalY=0;this.panningStep=0.1;this.config.push("panningStep");this.distance="euclidian";this.config.push("distance");this.linkage="single";this.config.push("linkage");this.clusterAxis="samples";this.config.push("clusterAxis");this.kmeansClusters=3;this.config.push("kmeansClusters");this.maxIterations=10;this.config.push("maxIterations");this.imputeMethod="mean";this.config.push("imputeMethod");this.centerData=false;this.config.push("centerData");this.xAxisAbsMax=null;this.xAxisAbsMin=null;this.xAxis2AbsMax=null;this.xAxis2AbsMin=null;this.yAxisAbsMax=null;this.yAxisAbsMin=null;this.zAxisAbsMax=null;this.zAxisAbsMin=null;this.xAxisMaxStrLength=false;this.xAxis2MaxStrLength=false;this.yAxisMaxStrLength=false;this.zAxisMaxStrLength=false;this.setMax=null;this.config.push("setMax");this.setMin=null;this.config.push("setMin");this.setMax2=null;this.config.push("setMax2");this.setMin2=null;this.config.push("setMin2");this.setMaxX=null;this.config.push("setMaxX");this.setMinX=null;this.config.push("setMinX");this.setMaxY=null;this.config.push("setMaxY");this.setMinY=null;this.config.push("setMinY");this.setMaxZ=null;this.config.push("setMaxZ");this.setMinZ=null;this.config.push("setMinZ");this.xAxisCurrent=0;this.config.push("xAxisCurrent");this.yAxisCurrent=0;this.config.push("yAxisCurrent");this.zAxisCurrent=0;this.config.push("zAxisCurrent");this.xAxisTitle=false;this.config.push("xAxisTitle");this.yAxisTitle=false;this.config.push("yAxisTitle");this.zAxisTitle=false;this.config.push("zAxisTitle");this.xAxis=[];this.config.push("xAxis");this.xAxis2=[];this.config.push("xAxis2");this.yAxis=[];this.config.push("yAxis");this.zAxis=[];this.config.push("zAxis");this.xAxisTickStyle="solid";this.config.push("xAxisTickStyle");this.yAxisTickStyle="solid";this.config.push("yAxisTickStyle");this.zAxisTickStyle="solid";this.config.push("zAxisTickStyle");this.xAxisTickFormat=false;this.config.push("xAxisTickFormat");this.xAxis2TickFormat=false;this.config.push("xAxis2TickFormat");this.yAxisTickFormat=false;this.config.push("yAxisTickFormat");this.zAxisTickFormat=false;this.config.push("zAxisTickFormat");this.xAxisTickColor="rgb(220,220,220)";this.config.push("xAxisTickColor");this.yAxisTickColor="rgb(220,220,220)";this.config.push("yAxisTickColor");this.zAxisTickColor="rgb(220,220,220)";this.config.push("zAxisTickColor");this.axisExtension=0.1;this.config.push("axisExtension");this.axisExact=false;this.config.push("axisExact");this.xAxisExact=false;this.config.push("xAxisExact");this.xAxis2Exact=false;this.config.push("xAxis2Exact");this.yAxisExact=false;this.config.push("yAxisExact");this.zAxisExact=false;this.config.push("zAxisExact");this.timeValues=[];this.config.push("timeValues");this.timeValueIndices=[];this.config.push("timeValueIndices");this.xAxisValues=[];this.config.push("xAxisValues");this.xAxis2Values=[];this.config.push("xAxis2Values");this.yAxisValues=[];this.config.push("yAxisValues");this.zAxisValues=[];this.config.push("zAxisValues");this.xAxisMinorValues=[];this.config.push("xAxisMinorValues");this.xAxis2MinorValues=[];this.config.push("xAxis2MinorValues");this.yAxisMinorValues=[];this.config.push("yAxisMinorValues");this.zAxisMinorValues=[];this.config.push("zAxisMinorValues");this.xAxisTransform=false;this.config.push("xAxisTransform");this.yAxisTransform=false;this.config.push("yAxisTransform");this.zAxisTransform=false;this.config.push("zAxisTransform");this.xAxisTransformTicks=true;this.config.push("xAxisTransformTicks");this.yAxisTransformTicks=true;this.config.push("yAxisTransformTicks");this.zAxisTransformTicks=true;this.config.push("zAxisTransformTicks");this.xAxisShow=true;this.config.push("xAxisShow");this.yAxisShow=true;this.config.push("yAxisShow");this.zAxisShow=true;this.config.push("zAxisShow");this.ticks=50;this.config.push("ticks");this.timeTicksFirst=false;this.config.push("timeTicksFirst");this.xAxisTicks=5;this.config.push("xAxisTicks");this.xAxis2Ticks=5;this.config.push("xAxis2Ticks");this.yAxisTicks=5;this.config.push("yAxisTicks");this.zAxisTicks=5;this.config.push("zAxisTicks");this.xAxisMinorTicks=true;this.config.push("xAxisMinorTicks");this.xAxis2MinorTicks=true;this.config.push("xAxis2MinorTicks");this.yAxisMinorTicks=true;this.config.push("yAxisMinorTicks");this.zAxisMinorTicks=false;this.config.push("zAxisMinorTicks");this.smpHairline="dotted";this.config.push("smpHairline");this.smpHairlineColor="rgb(220,220,220)";this.config.push("smpHairlineColor");this.blockContrast=false;this.config.push("blockContrast");this.blockContrastOddColor=this.background;this.config.push("blockContrastOddColor");this.blockContrastEvenColor="rgb(240,240,240)";this.config.push("blockContrastEvenColor");this.seriesSeparationFactor=2;this.config.push("seriesSeparationFactor");this.blockSeparationFactor=1;this.config.push("blockSeparationFactor");this.blockFactor=1;this.config.push("blockFactor");this.showDataValues=false;this.config.push("showDataValues");this.lineDecoration="symbol";this.config.push("lineDecoration");this.coordinateLineColor=true;this.config.push("coordinateLineColor");this.lineThickness=1;this.config.push("lineThickness");this.lineType="rect";this.config.push("lineType");this.areaIsCumulative=false;this.config.push("areaIsCumulative");this.colorBy=false;this.config.push("colorBy");this.shapeBy=false;this.config.push("shapeBy");this.sizeBy=false;this.config.push("sizeBy");this.scatterType=false;this.config.push("scatterType");this.selectDataPoint=[];this.hideDataPoint=[];this.isSelectDataPoints=0;this.isHistogram=false;this.config.push("isHistogram");this.histogramBarWidth=0.5;this.config.push("histogramBarWidth");this.histogramBins=20;this.config.push("histogramBins");this.isCreateHistogram=false;this.allVsAll=false;this.config.push("allVsAll");this.allVsAllType="both";this.config.push("allVsAllType");this.functionIntervals=20;this.config.push("functionIntervals");this.xRotate=45;this.config.push("xRotate");this.yRotate=0;this.config.push("yRotate");this.zRotate=0;this.config.push("zRotate");this.minRotate=null;this.config.push("minRotate");this.maxRotate=null;this.config.push("maxRotate");this.show3DGrid=true;this.config.push("show3DGrid");this.rotationDelay=100;this.config.push("rotationDelay");this.rotationSensitivity=45;this.config.push("rotationSensitivity");this.rotationStep=2;this.config.push("rotationStep");this.indicatorCenter="white";this.config.push("indicatorCenter");this.indicatorHeight=8;this.config.push("indicatorHeight");this.indicatorWidth=1;this.config.push("indicatorWidth");this.heatmapType="blue-red";this.config.push("heatmapType");this.varIndicesStart=-1;this.smpIndicesStart=-1;this.correlationAxis="samples";this.config.push("correlationAxis");this.correlationAnchorLegend=false;this.config.push("correlationAnchorLegend");this.correlationAnchorLegendAlignWidth=40;this.config.push("correlationAnchorLegendAlignWidth");this.showSmpDendrogram=false;this.config.push("showSmpDendrogram");this.showVarDendrogram=false;this.config.push("showVarDendrogram");this.varDendrogramPosition="top";this.config.push("varDendrogramPosition");this.smpDendrogramPosition="left";this.config.push("smpDendrogramPosition");this.dendrogramSpace=6;this.config.push("dendrogramSpace");this.dendrogramHang=false;this.config.push("dendrogramHang");this.dendrogramHeight=false;this.config.push("dendrogramHeight");this.vennGroups=4;this.config.push("vennGroups");this.vennCompartments=["A","B","AB","C","AC","BC","ABC","D","AD","BD","CD","ABD","ACD","BCD","ABCD"];this.vennColors=false;this.config.push("vennColors");this.pieType="separated";this.config.push("pieType");this.pieSegmentPrecision=0;this.config.push("pieSegmentPrecision");this.pieSegmentSeparation=3;this.config.push("pieSegmentSeparation");this.pieSegmentLabels="inside";this.config.push("pieSegmentLabels");this.maxPieSectors=20;this.config.push("maxPieSectors");this.showPieGrid=true;this.config.push("showPieGrid");this.showPieValues=true;this.config.push("showPieValues");this.showPieSampleLabel=true;this.config.push("showPieSampleLabel");this.startPieSectors=0;this.config.push("startPieSectors");this.showVolume=true;this.config.push("showVolume");this.stockIndicators=["Sma5","Sma10","Sma25"];this.config.push("stockIndicators");this.sma5Color="rgb(255,0,0)";this.config.push("sma5Color");this.sma10Color="rgb(0,255,0)";this.config.push("sma1Color");this.sma20Color="rgb(0,0,255)";this.config.push("sma20Color");this.sma25Color="rgb(255,0,255)";this.config.push("sma25Color");this.sma50Color="rgb(0,0,0)";this.config.push("sma50Color");this.calculateLayout=true;this.config.push("calculateLayout");this.networkFreeze=false;this.config.push("networkFreeze");this.networkFreezeOnLoad=false;this.config.push("networkFreezeOnLoad");this.networkStack=[];this.networkStack[0]=[];this.networkStack[1]=[];this.networkStackStates=5;this.config.push("networkStackStates");this.approximateNodePositions=false;this.config.push("approximateNodePositions");this.networkLayoutType="forceDirected";this.config.push("networkLayoutType");this.networkRoot=false;this.config.push("networkRoot");this.showNetworkRadialLayout=false;this.config.push("showNetworkRadialLayout");this.networkDepth=0;this.networkDivisions=0;this.preScaleNetwork=false;this.config.push("preScaleNetwork");this.showNetworkNodesLegend=true;this.config.push("showNetworkNodesLegend");this.showNetworkEdgesLegend=true;this.config.push("showNetworkEdgesLegend");this.showNetworkTextLegend=true;this.config.push("showNetworkTextLegend");this.showNetworkDecorationsLegend=true;this.config.push("showNetworkDecorationsLegend");this.showNodeNameThreshold=50;this.config.push("showNodeNameThreshold");this.showHiddenChildEdges=true;this.config.push("showHiddenChildEdges");this.nodeSize=this.preScaleNetwork?10:20;this.config.push("nodeSize");this.edgeWidth=1;this.config.push("edgeWidth");this.layoutTime=15;this.config.push("layoutTime");this.nodeFontSize=this.nodeSize;this.config.push("nodeFontSize");this.nodeFont=this.nodeFontSize+"Pt "+this.fontName;this.nodeFontColor=this.foreground;this.config.push("nodeFontColor");this.nodeScaleFontFactor=1;this.config.push("nodeScaleFontFactor");this.randomNetwork=false;this.config.push("randomNetwork");this.reduceRandomNetwork=false;this.config.push("reduceRandomNetwork");this.randomNetworkNodes=50;this.config.push("randomNetworkNodes");this.randomNetworkNodeEdgesMax=5;this.config.push("randomNetworkNodeEdgesMax");this.colorNodeBy=false;this.config.push("colorNodeBy");this.shapeNodeBy=false;this.config.push("shapeNodeBy");this.sizeNodeBy=false;this.config.push("sizeNodeBy");this.colorEdgeBy=false;this.config.push("colorEdgeBy");this.shapeEdgeBy=false;this.config.push("shapeEdgeBy");this.sizeEdgeBy=false;this.config.push("sizeEdgeBy");this.sizeDecorationBy=false;this.config.push("sizeDecorationBy");this.is3DNetwork=false;this.config.push("is3DNetwork");this.network2DRotate=0;this.skipClick=false;this.autoHideOnDecorationsCenter=false;this.config.push("autoHideOnDecorationsCenter");this.trackNameFontSize=10;this.config.push("trackNameFontSize");this.trackNameFont=(this.trackNameFontSize)+"Pt "+this.fontName;this.trackNameFontColor=this.background;this.config.push("trackNameFontColor");this.showFeatureNameThereshold=20;this.config.push("showFeatureNameThereshold ");this.featureNameFontSize=8;this.config.push("featureNameFontSize");this.featureNameFont=(this.featureNameFontSize)+"Pt "+this.fontName;this.featureNameFontColor=this.background;this.config.push("featureNameFontColor");this.featureWidthDefault=3;this.config.push("featureWidthDefault");this.featureHeightDefault=8;this.config.push("featureHeightDefault");this.featureTypeDefault="line";this.config.push("featureTypeDefault");this.sequenceFontSize=10;this.config.push("sequenceFontSize");this.sequenceFont=(this.sequenceFontSize)+"Pt "+this.fontName;this.sequenceAColor="rgb(255,255,0)";this.config.push("sequenceAColor");this.sequenceCColor="rgb(0,255,255)";this.config.push("sequenceCColor");this.sequenceGColor="rgb(0,255,0)";this.config.push("sequenceGColor");this.sequenceTColor="rgb(255,0,0)";this.config.push("sequenceTColor");this.sequenceMColor="rgb(255,0,255)";this.config.push("sequenceMColor");this.wireColor=this.isVML?"rgb(220,220,220)":"rgba(220,220,220,0.1)";this.config.push("wireColor");this.periodTicksLabels=5;this.config.push("periodTicksLabels");this.tension=0.3;this.config.push("tension");this.debug=false;this.config.push("debug");this.showVersion=true;this.config.push("showVersion");this.showCode=false;this.config.push("showCode");this.codeType="pretty";this.config.push("codeType");this.checkGoogleChromeFrame=true;this.config.push("checkGoogleChromeFrame");this.disableConfigurator=false;this.config.push("disableConfigurator");this.disableEvents=false;this.config.push("disableEvents");this.eventKeys=true;this.config.push("eventKeys");this.eventArrowKeys=true;this.config.push("eventArrowKeys");this.eventPlusMinusKeys=false;this.config.push("eventPlusMinusKeys");this.helpKeyEvents=true;this.config.push("helpKeyEvents");this.dragAreaColor="rgb(208,222,240)";this.config.push("dragAreaColor");this.selectedBackgroundColor="rgb(255,0,0)";this.config.push("selectedBackgroundColor");this.infoAreaColor="rgb(208,222,240)";this.config.push("infoAreaColor");this.infoTimeOut=3000;this.config.push("infoTimeOut");this.modelEvent="global";this.config.push("modelEvent");this.dataEvent=[];this.broadcast=true;this.config.push("broadcast");this.broadcastType="var";this.config.push("broadcastType");this.resizerAreaColor=this.isVML?"rgb(210,210,210)":"rgba(210,210,210,0.7)";this.config.push("resizerAreaColor");this.resizerAreaColorCurrent="rgb(237,247,255)";this.config.push("resizerAreaColorCurrent");this.resizerAreaColorOutlineCurrent="rgb(59,138,229)";this.config.push("resizerAreaColorOutlineCurrent");this.resizerTransparency=true;this.config.push("resizerTransparency");this.resizerType=false;this.config.push("resizerType");this.resizerDraw=false;this.config.push("resizerDraw");this.resizerPosition="bottom";this.config.push("resizerPosition");this.resizerWidth=50;this.config.push("resizerWidth");this.resizerBackgroundImage=false;this.config.push("resizerBackgroundImage");this.resizerDataIndex=0;this.config.push("resizerDataIndex");this.resizerEventData={};this.showAnimation=false;this.config.push("showAnimation");this.showAnimationFontSize=10;this.config.push("showAnimationFontSize");this.showAnimationFont=(this.showAnimationFontSize)+"Pt "+this.fontName;this.showAnimationFontColor=this.background;this.config.push("showAnimationFontColor");this.animationTime=30;this.config.push("animationTime");this.animationType="grow";this.config.push("animationType");this.animationCycles=20;this.config.push("animationCycles");this.snapshotCopyChangeOnly=true;this.config.push("snapshotCopyChangeOnly");this.snapshots=[];this.isAnimation=false;this.weight=1;this.scaleX=1;this.scaleY=1;this.translateX=0;this.translateY=0;this.offsetX=0;this.offsetY=0;this.layoutWidth=0;this.layoutHeight=0;this.layout="1X1";this.config.push("layout");this.layoutComb=false;this.config.push("layoutComb");this.layoutAdjust=false;this.config.push("layoutAdjust");this.layoutCurrent=0;this.layoutMaxVarLegend=0;this.layoutMulticolor=true;this.config.push("layoutMulticolor");this.layoutAxis=3;this.imageDir="http://canvasxpress.org/images/";this.config.push("imageDir");this.playButton="play.png";this.config.push("playButton");this.stopButton="stop.png";this.config.push("stopButton");this.previousButton="rewind.png";this.config.push("previousButton");this.nextButton="fast_forward.png";this.config.push("nextButton");this.remoteService=false;this.config.push("remoteService");this.remoteParams={};this.config.push("remoteParams");this.remoteDirection="next";this.config.push("remoteDirection");this.remoteDataIndex=0;this.remoteWindow=1;this.config.push("remoteWindow");this.remoteAutoPlay=false;this.config.push("remoteAutoPlay");this.remoteAutoPlayDelay=3000;this.config.push("remoteAutoPlayDelay");this.remoteUpdating=false;this.showDataTable=false;this.config.push("showDataTable");this.dataTableTransposed=true;this.config.push("dataTableTransposed");this.maxRows=5;this.config.push("maxRows");this.maxCols=8;this.config.push("maxCols");this.colWidth=50;this.config.push("colWidth");this.rowHeight=15;this.config.push("rowHeight");this.freezeColLeft=0;this.config.push("freezeColLeft");this.freezeColRight=0;this.config.push("freezeColRight");this.freezeRowTop=0;this.config.push("freezeRowTop");this.freezeRowBottom=0;this.config.push("freezeRowBottom");this.refresehDataTableOnDraw=false;this.config.push("refresehDataTableOnDraw");this.showDataTableOnSelect=true;this.config.push("showDataTableOnSelect");this.networkShowDataTable="nodes";this.config.push("networkShowDataTable");this.startCol=0;this.startRow=0;if(!a){this.setConfig(this.config);this.initDimensions();this.initUtils();this.initPlotUtils();this.initConfigUtils();this.initLegendUtils();this.init3dUtils();this.initApi();this.initText();this.initTime();this.initColor();this.initAttributes()}};CanvasXpress.prototype.initDimensions=function(){this.resizeCanvas=function(c,a,b){if(this.ctx){this.disableGradientTransparency();if(c||a||b){if(a||b){if(a){this.width=a;this.originalWidth=a}if(b){this.height=b;this.originalHeight=b}}else{if(c){this.width=this.originalWidth;this.height=this.originalHeight}}this.top=this.margin;if(this.title){this.top+=this.titleHeight+this.margin;if(this.subtitle){this.top+=this.subtitleHeight+this.margin}}this.left=this.margin;this.right=this.margin;this.bottom=this.margin;this.resetMap()}this.canvas.width=this.width;this.canvas.height=this.height;if(this.backgroundType=="image"||this.backgroundType=="windowImage"){this.ctx.save();this.ctx.translate(0,0);this.ctx.drawImage(CanvasXpress.cacheImages[this.backgroundImage],0,0,this.width,this.height);this.ctx.restore()}else{if(this.backgroundType=="solid"||this.backgroundType=="window"||this.backgroundType=="windowSolidGradient"){this.rectangle(0,0,this.width,this.height,this.background,this.background)}else{this.setLinearGradient(0,0,0,this.height,this.backgroundGradient1Color,this.backgroundGradient2Color);this.ctx.fillRect(0,0,this.width,this.height)}}this.enableGradientTransparency()}};this.setWidth=function(a){if(!a){a=1000}this.draw(a)};this.setHeight=function(a){if(!a){a=8000}this.draw(false,a)};this.setDimensions=function(a,b){if(!a){a=1000}if(!b){b=1000}this.draw(a,b)};this.initializeDimensions=function(){if(this.canvas.width){this.originalWidth=this.canvas.width;this.width=this.canvas.width}else{if(this.width){this.originalWidth=this.width;this.canvas.width=this.width}else{this.width=600;this.originalWidth=this.width;this.canvas.width=this.width}}if(this.canvas.height){this.originalHeight=this.canvas.height;this.height=this.canvas.height}else{if(this.height){this.originalHeight=this.height;this.canvas.height=this.height}else{this.height=600;this.originalHeight=this.height;this.canvas.height=this.height}}this.top=this.margin;if(this.title){this.top+=this.titleHeight+this.margin;if(this.subtitle){this.top+=this.subtitleHeight+this.margin}}this.left=this.margin;this.right=this.margin;this.bottom=this.margin;this.x=this.width-(this.leftMargin+this.left+this.rightMargin+this.right);this.y=this.height-(this.topMargin+this.top+this.bottomMargin+this.bottom)};this.initializeDimensions()};CanvasXpress.prototype.initPlotUtils=function(){this.drawCanvasBox=function(){if(this.canvasBox&&this.graphType!="Network"){this.rectangle(0,0,this.width-1,this.height-1,false,this.canvasBoxColor,"open")}};this.drawPlotWindow=function(){if(this.backgroundType.match("window")){this.disableGradientTransparency();var a=this.marginLeft+this.offsetX;var b=this.marginTop+this.offsetY;if(this.backgroundType=="windowGradient2"||this.backgroundType=="windowSolidGradient"){this.ctx.save();if(this.backgroundWindowGradientOrientation=="horizontal"){this.setLinearGradient(a+this.left,b,a+this.left+this.x,b,this.backgroundWindowGradient1Color,this.backgroundWindowGradient2Color)}else{this.setLinearGradient(a,b+this.top,a,b+this.top+this.y,this.backgroundWindowGradient1Color,this.backgroundWindowGradient2Color)}this.ctx.fillRect(a+this.left,b+this.top,this.x,this.y)}else{this.rectangle(a+this.left,b+this.top,this.x,this.y,this.backgroundWindow,this.backgroundWindow)}this.enableGradientTransparency()}};this.maskArea=function(q){this.disableGradientTransparency();var n=function(i,e,t,l){this.ctx.fillRect(i,e,t,l)};var d=function(l,i,w,v,t){this.ctx.drawImage(l,i,w,v,t)};var r;var g=this.marginLeft+this.offsetX;var u=this.marginTop+this.offsetY;var o=this.outlineWidth+1;var a=[0,0,this.width,this.marginTop];var j=[0,0,this.marginLeft,this.height];var s=[0,this.height-this.marginBottom,this.width,this.marginBottom];var c=[this.width-this.marginRight,0,this.marginRight,this.height];var h=q?[g,u,this.left,this.top-o]:[g,u,(this.left+this.x+this.right),this.top-o];var p=q?[g,u+this.top+this.y,this.left-o,this.bottom]:[g,u,this.left-o,(this.top+this.y+this.bottom)];var b=q?[g+this.left+this.x,u+this.top+this.y+o,this.right,this.bottom]:[g,u+this.top+this.y+o,(this.left+this.x+this.right),this.bottom];var m=q?[g+this.left+this.x+o,u,this.right,this.top]:[g+this.left+this.x+o,u,this.right,(this.top+this.y+this.bottom)];var f=[a,j,s,c,h,p,b,m];if(this.backgroundType=="image"||this.backgroundType=="windowImage"){this.ctx.save();this.ctx.translate(0,0);for(var k=0;k<f.length;k++){f[k].unshift(CanvasXpress.cacheImages[this.backgroundImage])}r=d}else{if(this.backgroundType=="solid"||this.backgroundType=="window"||this.backgroundType=="windowSolidGradient"){for(var k=0;k<f.length;k++){f[k].push(this.background);f[k].push(this.background)}r=this.rectangle}else{this.setLinearGradient(0,0,0,this.height,this.backgroundGradient1Color,this.backgroundGradient2Color);r=n}}if(this.marginTop){r.apply(this,a)}if(this.marginLeft){r.apply(this,j)}if(this.marginBottom){r.apply(this,s)}if(this.marginRight){r.apply(this,c)}r.apply(this,h);r.apply(this,p);r.apply(this,b);r.apply(this,m);if(this.backgroundType=="image"||this.backgroundType=="windowImage"){this.ctx.restore()}this.enableGradientTransparency()};this.maskPlotArea=function(){this.maskArea()};this.maskTreeArea=function(){this.maskArea(true)}};CanvasXpress.prototype.initColor=function(){this.validateColor=function(b,a){if(b.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)){if(RegExp.$2){b="rgba("+RegExp.$1+","+RegExp.$2+")"}else{b="rgb("+RegExp.$1+")"}}else{if(b.match(/^#?[0-9abcdef]/i)){b=this.hexToRgb(b)}else{b=false}}return b&&a!=null?this.addColorTransparency(b,a):b};this.darkenLightenColor=function(j,e){j=this.rgbToHex(j).substring(1,7);var i=parseInt(j,16);var h=(i>>16)+e;h=h>255?255:h<0?0:h;var f=((i>>8)&255)+e;f=f>255?255:f<0?0:f;var d=(i&255)+e;d=d>255?255:d<0?0:d;j=d|(f<<8)|(h<<16);return this.hexToRgb(j.toString(16))};this.rgbToHex=function(i){if(i.substr(0,1)==="#"){return i}if(i.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){var f=parseInt(RegExp.$1);var e=parseInt(RegExp.$2);var a=parseInt(RegExp.$3);var d=a|(e<<8)|(f<<16);return"#"+d.toString(16)}else{return i}};this.hexToRgb=function(c){var b=function(){return parseInt(c.substring(0,2),16)};var a=function(){return parseInt(c.substring(2,4),16)};var d=function(){return parseInt(c.substring(4,6),16)};c=c.charAt(0)=="#"?c.substring(1,7):c;return"rgb("+b()+","+a()+","+d()+")"};this.addColorTransparency=function(b,a){if(b.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)){if(RegExp.$2){return"rgba("+RegExp.$1+","+a+")"}else{return"rgba("+RegExp.$1+","+a+")"}}else{return false}};this.disableGradientTransparency=function(){this.gradientTemp=this.gradient;this.transparencyTemp=this.transparency;this.gradient=false;this.transparency=null};this.enableGradientTransparency=function(){this.gradient=this.gradientTemp;this.transparency=this.transparencyTemp};this.getGradientColor=function(h){if(h.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var f=Math.floor(parseInt(RegExp.$1)/this.gradientRatio);var e=Math.floor(parseInt(RegExp.$2)/this.gradientRatio);var a=Math.floor(parseInt(RegExp.$3)/this.gradientRatio);var d=RegExp.$4?parseFloat(RegExp.$4):false;if(d){return"rgba("+f+","+e+","+a+","+d+")"}else{return"rgb("+f+","+e+","+a+")"}}else{return false}};this.setGradient=function(e,d,c,b,a){if(this.gradientType=="radial"){this.setRadialGradient(e,d,c,b,false,false,true)}else{this.setLinearGradient(e,d,c,b,a,false,true)}};this.setLinearGradient=function(c,i,a,f,e,b,d){if(!d){this.ctx.save()}var h=this.ctx.createLinearGradient(c,i,a,f);if(!b){b=this.getGradientColor(e);h.addColorStop(0,b);h.addColorStop(0.6,e);h.addColorStop(1,e)}else{h.addColorStop(0,e);h.addColorStop(1,b)}this.ctx.fillStyle=h};this.setRadialGradient=function(j,h,a,e,d,c,i){if(!i){this.ctx.save()}var b=a/5.5;var f=this.ctx.createRadialGradient(j-b,h-b,1,j,h,a);if(!d){if(this.transparency!=null){d="rgba(0,0,0,"+this.transparency+")"}else{d="rgb(0,0,0)"}}if(!c){c="rgba(0,0,0,0)"}f.addColorStop(0,e);f.addColorStop(1,d);f.addColorStop(1,c);this.ctx.fillStyle=f}};CanvasXpress.prototype.initUtils=function(){this.modifyObjectArray=function(f,b,g){var a=this[g];if(b){var d={};var c=[];if(this.isArray(f)){for(var e=0;e<f.length;e++){d[f[e]]=1}}else{d[f]=1}for(var e=0;e<a.length;e++){if(!d.hasOwnProperty(a[e])){c.push(a[e])}}this[g]=c}else{if(this.isArray(f)){for(var e=0;e<f.length;e++){a.push(f[e])}}else{a.push(f)}}};this.getObjectArray=function(a){var b={};for(var c=0;c<a.length;c++){b[a[c]]=1}return b};this.isInArray=function(d,b){if(b&&!(b.propertyIsEnumerable("length"))&&typeof b==="object"&&typeof b.length==="number"){for(var c=0;c<b.length;c++){if(b[c]==d){return true}}}return false};this.isArray=function(a){if(a&&!(a.propertyIsEnumerable("length"))&&typeof a==="object"&&typeof a.length==="number"){return true}else{return false}};this.toArray=function(a){return this.isArray(a)?a:[a]};this.toNumber=function(b,e){var g=[];var c=this.isArray(b);b=this.toArray(b);for(var d=0;d<b.length;d++){if(e){g.push(parseFloat(b[d]))}else{g.push(parseInt(b[d]))}}return c?g:g[0]};this.cloneObject=function(c){if(c==null||typeof(c)!="object"){return c}var a=new c.constructor();for(var b in c){a[b]=this.cloneObject(c[b])}return a};this.isSameObject=function(d,c){if(d===c){return true}if(typeof(d)!="object"||typeof(c)!="object"){return false}for(var e in d){if(d[e]===c[e]){continue}if(c[e]===undefined||typeof(d[e])!=typeof(c[e])){return false}if(!this.isSameObject(d[e],c[e])){return false}}for(var e in c){if(d[e]===undefined){return false}}return true}};CanvasXpress.prototype.initConfigUtils=function(){this.getPixelImage=function(){if(navigator.onLine){return this.imageDir+"canvasXpress.gif"}else{if(this.path){return this.path+"canvasXpress.gif"}else{alert("Dude! I couldn't find canvasXpress.js")}}};this.drawTitle=function(){var c;var b;var a;if(this.title){b=this.titleHeight/2;c=this.scaleTextToFont(this.title,this.titleHeight-b,this.x);this.drawText(this.title,this.width/2,this.marginTop+(this.titleHeight/2),c,false,"center","middle");if(this.subtitle){a=this.subtitleHeight/4;c=this.scaleTextToFont(this.subtitle,this.subtitleHeight-a,this.x);this.drawText(this.subtitle,this.width/2,(this.marginTop+this.titleHeight)+(this.subtitleHeight/2),c,false,"center","middle")}}};this.drawSelectedBackground=function(f,i,j,b,d,e,c,a,g){if(this.isInSelectedDataPoints(f,i)){this.drawShape(j,b,d,e+12,c+12,this.selectedBackgroundColor,this.foreground,"closed",a,1,g)}};this.isInSelectedDataPoints=function(a,b){if(this.isSelectDataPoints){if(this.selectDataPoint[a]){if(this.broadcastType=="var"){return true}else{if(this.selectDataPoint[a].hasOwnProperty(b)){return true}}}}return false};this.isVisibleSelectedDataPoint=function(a,b){if(this.isSelectDataPoints){if(this.hideDataPoint.length>0&&this.hideDataPoint[a]){if(this.hideDataPoint[a].hasOwnProperty(b)){return false}}}return true};this.getVarColor=function(a){if(this.isArray(this.highlightVar)){for(var b=0;b<this.highlightVar.length;b++){if(this.highlightVar[b]==a){return this.varHighlightColor}}}else{if(this.highlightVar==a){return this.varHighlightColor}}return this.varLabelColor};this.getSmpColor=function(b){if(this.isArray(this.highlightSmp)){for(var a=0;a<this.highlightSmp.length;a++){if(this.highlightSmp[a]==b){return this.smpHighlightColor}}}else{if(this.highlightSmp==b){return this.smpHighlightColor}}return this.smpLabelColor};this.getNodeColor=function(b){if(this.isArray(this.highlightNode)){for(var a=0;a<this.highlightNode.length;a++){if(this.highlightNode[a]==b){return this.nodeHighlightColor}}}else{if(this.highlightNode==b){return this.nodeHighlightColor}}return this.selectNode.hasOwnProperty(b)?this.nodeHighlightColor:this.nodeFontColor};this.getTechnicalIndicatorColor=function(a){return this[a.toLowerCase()+"Color"]?this[a.toLowerCase()+"Color"]:"rgb(255,255,0)"};this.setPieData=function(g,a){var f={no:0,idso:[],ids:[],data:{},oprc:0,tot:this.sum(g)};for(var c=0;c<g.length;c++){var b=a?this.varIndices[c]:c;var e=g[b]/f.tot;f.data[b]=e;if(c>=this.maxPieSectors-1){f.oprc+=e;f.idso.push(b);f.no++}else{f.ids.push(b)}}if(f.no){f.ids.push(-1)}return f};this.drawPie=function(t,h,g,q,I){var o=this.startPieSectors?(this.startPieSectors*Math.PI/180)%360:0;var z=this.pieSegmentLabels=="inside"?q-(q/3):q+(q/10);var G=0;var C=this.layoutComb?this.smpIndices[0]:this.xAxisIndices?this.xAxisIndices[0]:0;var m=this.ctx.lineWidth;var v,e;for(var D=0;D<t.ids.length;D++){var n=t.ids[D];var u=n>-1?t.data[n]:t.oprc;var f=D%this.colors.length;v=e!=null?e:(Math.PI*(2*G))-o;if(v>(Math.PI*2)){v=v%(Math.PI*2)}e=v+(Math.PI*(2*(u)));if(e>(Math.PI*2)){e=e%(Math.PI*2)}var H=(v+e)/2;var B=(e-v)/32;var F=this.transparency!=null?this.validateColor(this.colors[f],this.transparency):this.colors[f];if(this.gradient){this.setRadialGradient(h,g,q*1.3,F)}else{this.ctx.fillStyle=F}this.ctx.beginPath();this.ctx.lineWidth=this.pieSegmentSeparation;this.ctx.strokeStyle=this.pieType=="separated"?this.background:this.pieType=="solid"?this.foreground:this.foreground;if(this.showShadow){this.ctx.shadowOffsetX=this.shadowOffsetX;this.ctx.shadowOffsetY=this.shadowOffsetY;this.ctx.shadowBlur=this.shadowBlur;this.ctx.shadowColor=this.shadowColor}this.ctx.moveTo(h,g);this.ctx.arc(h,g,q,v,e,false);this.ctx.lineTo(h,g);this.ctx.closePath();this.ctx.fill();if(this.graphType!="Network"){this.ctx.stroke()}if(this.showShadow){this.ctx.restore();this.ctx.shadowOffsetX=0;this.ctx.shadowOffsetY=0;this.ctx.shadowBlur=0;this.ctx.shadowColor=this.background}var E=h-Math.sin(H-(Math.PI/2))*z;var d=g+Math.cos(H-(Math.PI/2))*z;if(this.graphType!="Network"&&this.showPieValues){this.drawText(sprintf("%."+this.pieSegmentPrecision+"f",u*100)+"%",E,d,this.axisTickFont,this.axisTickColor,"center","middle")}if(I){E=h+q*Math.cos(v);d=g+q*Math.sin(v);var b=["poly",h,g,E,d];var o=v;for(var A=0;A<32;A++){o+=B;E=h+q*Math.cos(o);d=g+q*Math.sin(o);b.push(E);b.push(d)}b.push(h);b.push(g);if(n>-1){this.addArea(b,[n,C])}else{t.idso.push(C);this.addArea(b,t.idso)}}G+=u}this.ctx.lineWidth=m};this.drawBarPlot=function(K,J,F,x,k,C,p,g,E,D,L,N){var n,j,I,B;var M=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;var A=this.seriesSeparationFactor/2;var H=k/2;if(D=="vertical"){for(var G=0;G<K.length;G++){n=((K[G]-E)*p)-g;if(!isNaN(n)){this.addArea(this.rectangle(F+A,x,k-this.seriesSeparationFactor,-n,L[G],L[G],"closed",false,false,true),N[G]);I=x-n;B=F+H;if(J[G]&&!isNaN(J[G])){j=(((J[G]-E)/2)*p)-(g/2);this.errorBar(B,I,B,I+j,-H,M);this.errorBar(B,I,B,I-j,-H,M)}if(this.showDataValues){this.drawText(K[G],B,x-(j+this.overlayFontSize),this.overlayFont,L[G],"center","bottom")}}F+=C}}else{for(var G=0;G<K.length;G++){n=((K[G]-E)*p)-g;if(!isNaN(n)){this.addArea(this.rectangle(F,x+A,n,k-this.seriesSeparationFactor,L[G],L[G],"closed",false,false,true),N[G]);I=F+n;B=x+H;if(J[G]&&!isNaN(J[G])){j=(((J[G]-E)/2)*p)-(g/2);this.errorBar(I,B,I+j,B,H,M);this.errorBar(I,B,I-j,B,H,M)}if(this.showDataValues){this.drawText(K[G],K+j+this.overlayFontSize,B,this.overlayFont,L[G],"left","middle")}}x+=C}}};this.drawLinePlot=function(M,L,F,y,v,H,x,E,C,N,A,P){var B,K,J,I,j,g,f;var r=v/2;var q=v/3;var O=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;var D=M.length-1;var k=[[],[]];if(C=="vertical"){K=F;J=F+H;for(var G=1;G<M.length;G++){B=G-1;j=y-((M[B]-E)*x);g=y-((M[G]-E)*x);if(!isNaN(j)&&!isNaN(g)){if(this.lineType=="spline"){k[0].push(K);k[1].push(j)}else{this.drawLine("line",K,j,J,g,N,this.lineThickness,"butt",false,false,true)}if(this.lineDecoration&&A){this.addArea(this.drawShape(A,K,j,q,q,N,O,"closed",false,false,true),P[B])}if(L[B]&&!isNaN(L[B])){f=((L[B]-E)/2)*x;this.errorBar(K,j,K,j+f,-r,N);this.errorBar(K,j,K,j-f,-r,N)}}K+=H;J+=H}if(!isNaN(g)){if(this.lineDecoration&&A){this.addArea(this.drawShape(A,K,g,q,q,N,O,"closed",false,false,true),P[D])}if(L[D]&&!isNaN(L[D])){f=((L[D]-E)/2)*x;this.errorBar(K,g,K,g+f,-r,N);this.errorBar(K,g,K,g-f,-r,N)}if(this.lineType=="spline"){k[0].push(K);k[1].push(g);this.drawLine("spline",k[0],k[1],false,false,N,this.lineThickness)}}}else{j=y;g=y+H;for(var G=1;G<M.length;G++){B=G-1;K=F+((M[B]-E)*x);J=F+((M[G]-E)*x);if(!isNaN(K)&&!isNaN(J)){if(this.lineType=="spline"){k[0].push(K);k[1].push(j)}else{this.drawLine("line",J,g,K,j,N,this.lineThickness,"butt",false,false,true)}if(this.lineDecoration&&A){this.addArea(this.drawShape(A,K,j,q,q,N,O,"closed",false,false,true),P[B])}if(L[B]&&!isNaN(L[B])){I=((L[B]-E)/2)*x;this.errorBar(K,j,K+I,j,r,N);this.errorBar(K,j,K-I,j,r,N)}}j+=H;g+=H}if(!isNaN(J)){if(this.lineDecoration&&A){this.addArea(this.drawShape(A,J,j,q,q,N,O,"closed",false,false,true),P[D])}if(L[D]&&!isNaN(L[D])){I=((L[D]-E)/2)*x;this.errorBar(J,j,J+I,j,-r,N);this.errorBar(J,j,J-I,j,-r,N)}if(this.lineType=="spline"){k[0].push(J);k[1].push(j);this.drawLine("spline",k[0],k[1],false,false,N,this.lineThickness)}}}};this.drawStackedPlot=function(k,f,x,q,b,j,s,e,m,n){if(e=="vertical"){for(var h=0;h<k.length;h++){var r=b?(k[h]*100/j)*s:k[h]*s;this.addArea(this.rectangle(f,x,q,-r,m[h]),n[h]);x-=r}}else{for(var h=0;h<k.length;h++){var r=b?(k[h]*100/j)*s:k[h]*s;this.addArea(this.rectangle(f,x,r,q,m[h]),n[h]);f+=r}}};this.drawAreaPlot=function(T,M,E,B,Q,F,D,L,J,S,U,V){var I=S?"open":"close";var K=T.length-1;var N=S&&this.lineType=="rect"?"path":this.lineType=="rect"?"polygon":"spline";var R=[];var G=[];if(this.graphOrientation=="vertical"){for(var P=0;P<T[0].length;P++){R[P]=E}for(var P=0;P<T.length;P++){var H=M;var A=S?[]:[M];var e=S?[]:[E];for(var O=0;O<T[0].length;O++){var C=!isNaN(T[P][O])?(T[P][O]-L)*D:0;A.push(H);if(this.areaIsCumulative){e.push(R[O]-C);R[O]-=C}else{e.push(E-C)}H+=F}if(!S){A.push(M+B);e.push(E)}G.push([A,e])}}else{for(var P=0;P<T[0].length;P++){R[P]=M}for(var P=0;P<T.length;P++){var H=E;var A=S?[]:[M];var e=S?[]:[E];for(var O=0;O<T[0].length;O++){var C=!isNaN(T[P][O])?(T[P][O]-L)*D:0;e.push(H);if(this.areaIsCumulative){A.push(R[O]+C);R[O]+=C}else{A.push(M+C)}H+=F}if(!S){A.push(M);e.push(E+Q)}G.push([A,e])}}while(K>=0){var b=G.pop();if(S&&this.lineType=="spline"){this.addArea(this.drawLine(N,b[0],b[1],false,false,U[K],this.lineThickness),V[K])}else{this.addArea(this.drawShape(N,b[0],b[1],false,false,U[K],U[K],I),V[K])}K--}};this.drawBoxPlot=function(G,C,n,f,y,k,B,A,H,J){var e=function(a){return A=="vertical"?n-((a-B)*k):C+((a-B)*k)};var I=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;var p=this.seriesSeparationFactor/2;var F=f/2;if(A=="vertical"){for(var E=0;E<G.length;E++){var x=C+F;var g=[];for(var D=0;D<5;D++){g.push(e(G[E][D]))}this.addArea(this.rectangle(C+p,g[2],f-this.seriesSeparationFactor,g[3]-g[2],H,H,"closed",false,false,true),J[E]);this.drawLine("line",C+p,g[4],C+(f-p),g[4],I,false,"butt",false,false,true);this.errorBar(x,g[2],x,g[0],-F,I);this.errorBar(x,g[3],x,g[1],-F,I);if(G[E][5]){for(var D=0;D<G[E][5].length;D++){this.drawShape("sphere",x,e(G[E][5][D]),F,F,H,I,"closed",false,false,true)}}C+=y}}else{for(var E=0;E<G.length;E++){var x=n+F;var g=[];for(var D=0;D<5;D++){g.push(e(G[E][D]))}this.addArea(this.rectangle(g[2],n+p,g[3]-g[2],f-this.seriesSeparationFactor,H,H,"closed",false,false,true),J[E]);this.drawLine("line",g[4],n+p,g[4],n+(f-p),I,false,"butt",false,false,true);this.errorBar(g[2],x,g[0],x,F,I);this.errorBar(g[3],x,g[1],x,F,I);if(G[E][5]){for(var D=0;D<G[E][5].length;D++){this.drawShape("sphere",e(G[E][5][D]),x,F,F,H,I,"closed",false,false,true)}}n+=y}}};this.drawCandlestickPlot=function(G,B,q,f,F,n,A,x,y,H,J){var e=function(a){return y=="vertical"?q-((a-A)*n):B+((a-A)*n)};var I=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;var E=f/2;if(y=="vertical"){for(var D=0;D<G.length;D++){var s=B+E;var k=[];for(var C=0;C<G[D].length;C++){k.push(e(G[D][C]))}if(x){if(k[0]>k[1]){this.addArea(this.rectangle(B,k[0],f,k[1]-k[0],false,H,"open",false,false,true),J[D]);this.drawLine("line",s,k[1],s,k[2],H,false,"butt",false,false,true);this.drawLine("line",s,k[3],s,k[0],H,false,"butt",false,false,true)}else{this.addArea(this.rectangle(B,k[0],f,k[1]-k[0],H,H,"closed",false,false,true),J[D]);this.drawLine("line",s,k[3],s,k[1],H,false,"butt",false,false,true);this.drawLine("line",s,k[0],s,k[2],H,false,"butt",false,false,true)}}else{this.addArea(this.rectangle(B,k[0],f,q-k[0],H,H,"closed",false,false,true),J[D])}B+=F}}else{for(var D=0;D<G.length;D++){var s=q+E;var k=[];for(var C=0;C<G[D].length;C++){k.push(e(G[D][C]))}if(x){if(k[1]>k[0]){this.addArea(this.rectangle(k[0],q,k[1]-k[0],f,false,H,"open",false,false,true),J[D]);this.drawLine("line",k[1],s,k[2],s,H,false,"butt",false,false,true);this.drawLine("line",k[3],s,k[0],s,H,false,"butt",false,false,true)}else{this.addArea(this.rectangle(k[0],q,k[1]-k[0],f,H,H,"closed",false,false,true),J[D]);this.drawLine("line",k[3],s,k[1],s,H,false,"butt",false,false,true);this.drawLine("line",k[0],s,k[2],s,H,false,"butt",false,false,true)}}else{this.addArea(this.rectangle(B,q,k[0]-B,f,H,H,"closed",false,false,true),J[D])}q+=F}}};this.drawDotPlot=function(H,G,C,r,g,F,y,n,B,x,A,I,z,K){var k,f;var J=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;if(A=="vertical"){for(var E=0;E<H.length;E++){for(var D=0;D<H[E].length;D++){k=r-((H[E][D]-B)*n);if(!isNaN(k)){this.addArea(this.drawShape(z,C,k,x,x,I,J,"closed",false,false,true),K[E]);if(G[E]&&!isNaN(G[E])){f=((G[E]-B)/2)*n;this.errorBar(C,k,C,k+f,-F,I);this.errorBar(C,k,C,k-f,-F,I)}}}C+=y}}else{for(var E=0;E<H.length;E++){for(var D=0;D<H[E].length;D++){k=C+((H[E][D]-B)*n);if(!isNaN(k)){this.addArea(this.drawShape(z,k,r,x,x,I,J,"closed",false,false,true),K[E]);if(G[E]&&!isNaN(G[E])){f=((G[E]-B)/2)*n;this.errorBar(k,r,k+f,r,F,I);this.errorBar(k,r,k-f,r,F,I)}}}r+=y}}};this.drawHeatmap=function(u,k,F,D,q,j,C,s,B,r){var g=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;var A="rgb(255,255, 0)";var b=this.graphType=="Network"?false:true;for(var m=0;m<u.length;m++){var E=u[m];var z=!isNaN(E)?this.getHeatmapColor(j,C,E):A;g=s?z:g;this.addArea(this.rectangleHM(k,F,D,q,z,g,"closed",false,false,b),B[m],r);if(this.showDataValues){this.drawText(E,(k+D)-2,(F+q)-2,this.overlayFont,this.foreground,"right","bottom")}k+=D}}};CanvasXpress.prototype.init3dUtils=function(){this.set3DRotation=function(){var a;var c=0;var b=0;if(this.graphType=="Network"){c=this.maxRotate!=null?this.maxRotate:360;b=this.minRotate!=null?this.minRotate:360}else{if(this.graphType=="Scatter3D"){c=this.maxRotate!=null?this.maxRotate:90;b=this.minRotate!=null?this.minRotate:0}}if(this.xRotate>c){this.xRotate=c}if(this.xRotate<0){this.xRotate=b}if(this.yRotate>c){this.yRotate=c}if(this.yRotate<0){this.yRotate=b}if(this.zRotate>c){this.zRotate=c}if(this.zRotate<0){this.zRotate=b}if(this.xRotate>0){a=180/this.xRotate;this.ry=Math.PI/a}else{this.ry=0}if(this.yRotate>0){a=180/this.yRotate;this.rx=Math.PI/a}else{this.rx=0}if(this.zRotate>0){a=180/this.zRotate;this.rz=Math.PI/a}else{this.rz=0}};this.set3DParams=function(){this.perspective=this.x*1.5;this.len=this.x/4*this.zoom;this.pad=this.x/2};this.get3DTransfrom=function(e,f,g){var d,c,b;var a=[];c=f;b=g;f=c*Math.cos(this.rx)-b*Math.sin(this.rx);g=c*Math.sin(this.rx)+b*Math.cos(this.rx);d=e;b=g;e=b*Math.sin(this.ry)+d*Math.cos(this.ry);g=b*Math.cos(this.ry)-d*Math.sin(this.ry);d=e;c=f;e=d*Math.cos(this.rz)-c*Math.sin(this.rz);f=d*Math.sin(this.rz)+c*Math.cos(this.rz);e=e*(this.perspective/(g+this.perspective));f=f*(this.perspective/(g+this.perspective));g=g*(this.perspective/(g+this.perspective));a.push(e+this.pad);a.push(f+this.pad);a.push(g+this.pad);return a};this.backfaceCulling=function(s){var y=[];var w=[];var u=[];var r=[];var q=[];var p=[];for(var o=0;o<s.length;o++){var k=s[o][1][0]-s[o][0][0];var x=s[o][1][1]-s[o][0][1];var n=s[o][1][2]-s[o][0][2];var j=s[o][2][0]-s[o][0][0];var v=s[o][2][1]-s[o][0][1];var m=s[o][2][2]-s[o][0][2];var h=s[o][3][0]-s[o][0][0];var t=s[o][3][1]-s[o][0][1];var l=s[o][3][2]-s[o][0][2];y[o]=x*m-v*n;w[o]=j*n-k*m;u[o]=k*v-j*x;r[o]=t*m-v*l;q[o]=j*l-h*m;p[o]=h*v-j*t}return[y,w,u,r,q,p]}};CanvasXpress.prototype.initLegendUtils=function(){this.drawDecorationData=function(){var T=this.marginLeft+this.offsetX+this.left;var K=this.marginTop+this.offsetY+this.top;var aa=this.data.d;if(this.showDecorations&&aa){if(aa.nlfit){var X,w,Z;var h=this.smpIndices;var s,a;for(var W=0;W<aa.nlfit.length;W++){var E=[];var D=[];var m=W%this.colors.length;var R=aa.nlfit[W].param[0];var P=aa.nlfit[W].param[1];var N=aa.nlfit[W].param[2];var L=aa.nlfit[W].param[3];var F=this.xAxisIndices[W];if(this.xAxisTransform=="percentile"){X=this.getAxisRangeBySample(F);Z=X[0];w=X[1]}var G=this.data.y.data[F];h.sort(function(i,d){return G[i]-G[d]});m=aa.nlfit[W].color?aa.nlfit[W].color:this.colors[m];for(var V=0;V<h.length;V++){var o=h[V];var J=this.getDataAtPos(F,o,false,this.xAxisTransform,Z,w);var I;var p=[];if(J>0){if(V>0){var b=h[V-1];var H=this.getDataAtPos(F,b,false,this.xAxisTransform,Z,w);if(H>0){var c=(J-H)/this.functionIntervals;for(var U=0;U<this.functionIntervals;U++){p.push(H);H+=c}}}else{p=[J]}for(var U=0;U<p.length;U++){if(aa.nlfit[W].type=="reg"){I=R+((P-R)/(1+N/(Math.pow(p[U],L))))}else{I=R+((P-R)/(1+(Math.pow((p[U]/N),L))))}s=T+((p[U]-this.xAxisMin)*this.xAxisUnit);a=(K+this.y)-((I-this.yAxisMin)*this.yAxisUnit);E.push(s);D.push(a)}}}if(E.length>0){this.drawShape("path",E,D,false,false,m,m,"open");if(aa.nlfit[W].type=="reg"){I=R+((P-R)/(1+N/(Math.pow(N,L))))}else{I=R+((P-R)/(1+(Math.pow((N/N),L))))}s=T+((N-this.xAxisMin)*this.xAxisUnit);a=(K+this.y)-((I-this.yAxisMin)*this.yAxisUnit);this.drawLine("dashedLine",T,a,s,a,m);this.drawLine("dashedLine",s,a,s,(K+this.y),m)}}}if(aa.line){for(var W=0;W<aa.line.length;W++){if(aa.line[W].x||aa.line[W].y){var m=aa.line[W].color?aa.line[W].color:this.colors[W%this.colors.length];var ac=aa.line[W].type?aa.line[W].type:"line";var J=aa.line[W].x?aa.line[W].x:false;var I=aa.line[W].y?aa.line[W].y:false;var s,a,q,ad;if(J){s=T+(J*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);a=K;q=s;ad=a+this.y;this.drawLine(ac,s,a,q,ad,m)}if(I){s=T;a=K+(I*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);q=s+this.x;ad=a;this.drawLine(ac,s,a,q,ad,m)}}}}if(aa.reg){for(var W=0;W<aa.reg.length;W++){if(aa.reg[W].slope&&aa.reg[W].intercept){var m=W%this.colors.length;var ac=aa.reg[W].type?aa.reg[W].type:"line";var v=aa.reg[W].slope;var Q=aa.reg[W].intercept;var f=aa.reg[W].cor;var s=aa.reg[W].start?aa.reg[W].start:this.xAxisMin;var a=(v*s)+Q;var q=aa.reg[W].end?aa.reg[W].end:this.xAxisMax;var ad=(v*q)+Q;s=T+(s*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);a=(K+this.y)-(a*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);q=T+(q*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);ad=(K+this.y)-(ad*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);m=aa.reg[W].color?aa.reg[W].color:this.colors[m];this.drawLine(ac,s,a,q,ad,m)}}}if(aa.nor){for(var W=0;W<aa.nor.length;W++){if(aa.nor[W].mu&&aa.nor[W].sigma){var S=[];var O=[];var C=[];var s,a;var m=W%this.colors.length;var n=aa.nor[W].mu;var e=aa.nor[W].sigma;var A=aa.nor[W].start?aa.nor[W].start:aa.nor[W].yAxis?this.yAxisMin:this.xAxisMin;var u=aa.nor[W].end?aa.nor[W].end:aa.nor[W].yAxis?this.yAxisMax:this.xAxisMax;var g=120;if(A<n&&n<u){var H,r,z,Y;var c=(n-A)/g;var ab=e*e;var M=ab*2;var B=1/Math.sqrt(2*Math.PI*ab);if(aa.nor[W].yAxis){z=aa.nor[W].max?aa.nor[W].max*this.xAxisUnit:this.x-(this.x*this.axisExtension);Y=z/B;H=A;for(var V=0;V<g-1;V++){r=(B*Math.pow(Math.E,-Math.pow(H-n,2)/ab));C.push([H,r]);s=T+(r*Y);a=(K+this.y)-(H*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);S.push(s);O.push(a);H+=c}c=(u-n)/g;H=n;for(var V=0;V<g;V++){r=(B*Math.pow(Math.E,-Math.pow(H-n,2)/ab));C.push([H,r]);s=T+(r*Y);a=(K+this.y)-(H*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);S.push(s);O.push(a);H+=c}m=aa.nor[W].color?aa.nor[W].color:this.colors[m];this.drawShape("path",S,O,false,false,m,m,"open")}else{z=aa.nor[W].max?aa.nor[W].max*this.yAxisUnit:this.y-(this.y*this.axisExtension);Y=z/B;H=A;for(var V=0;V<g-1;V++){r=(B*Math.pow(Math.E,-Math.pow(H-n,2)/ab));C.push([H,r]);s=T+(H*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);a=(K+this.y)-(r*Y);S.push(s);O.push(a);H+=c}c=(u-n)/g;H=n;for(var V=0;V<g;V++){r=(B*Math.pow(Math.E,-Math.pow(H-n,2)/ab));C.push([H,r]);s=T+(H*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);a=(K+this.y)-(r*Y);S.push(s);O.push(a);H+=c}m=aa.nor[W].color?aa.nor[W].color:this.colors[m];this.drawShape("path",S,O,false,false,m,m,"open")}}}}}if(aa.area){for(var W=0;W<aa.area.length;W++){if(aa.area[W].type&&aa.area[W].x&&aa.area[W].y&&aa.area[W].size){if(this.isValidShape(aa.area[W].type)){var s=T+(aa.area[W].x*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);var a=(K+this.y)-(aa.area[W].y*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var m=aa.area[W].color?aa.area[W].color:this.colors[W%this.colors.length];this[aa.area[W].type](s,a,m,aa.area[W].size)}}}}}};this.setDecorationLegendDimension=function(){this.legendDecorationWidth=0;this.legendDecorationHeight=0;var f=this.data.d;if(this.showDecorations&&f){var k=this.getFontPt(this.decorationFont);var j=0;var g=0;var j=0;var b=0;if(f.nlfit){var a=this.measureText(sprintf("%75s","X"),this.decorationFont)+(this.margin*4);var h=0;for(var e=0;e<f.nlfit.length;e++){var c=this.measureText(f.nlfit[e].label,this.decorationFont);h=Math.max(c,h)}j=this.margin+h+this.margin+a+this.margin;this.legendDecorationHeight=(f.nlfit.length*k*2)+k+this.margin}if(f.line){var h=0;for(var e=0;e<f.line.length;e++){var c=this.measureText(f.line[e].label,this.decorationFont);h=Math.max(c,h)}b=this.margin+h+this.margin;this.legendDecorationHeight+=(f.line.length*k*2)+this.margin}if(f.reg){var a=this.measureText(sprintf("%45s","X"),this.decorationFont)+(this.margin*2);var h=0;for(var e=0;e<f.reg.length;e++){var c=this.measureText(f.reg[e].label,this.decorationFont);h=Math.max(c,h)}g=this.margin+h+this.margin+a+this.margin;this.legendDecorationHeight+=(f.reg.length*k*2)+k+this.margin}if(f.nor){var a=this.measureText(sprintf("%30s","X"),this.decorationFont)+(this.margin*1);var h=0;for(var e=0;e<f.nor.length;e++){var c=this.measureText(f.nor[e].label,this.decorationFont);h=Math.max(c,h)}j=this.margin+h+this.margin+a+this.margin;this.legendDecorationHeight+=(f.nor.length*k*2)+k+this.margin}if(f.area){var h=0;for(var e=0;e<f.area.length;e++){var c=this.measureText(f.area[e].label,this.decorationFont);h=Math.max(c,h)}b=this.margin+h+this.margin;this.legendDecorationHeight+=(f.area.length*k*2)+this.margin}this.legendDecorationWidth=Math.max(Math.max(Math.max(j,g),j),b)}};this.drawDecorationLegend=function(){var e=this.marginLeft+this.offsetX+this.left;var p=this.marginTop+this.offsetY+this.top;var k=this.data.d;if(this.showDecorations&&k){var q=this.getFontPt(this.decorationFont);var c=this.measureText(sprintf("%15s","X"),this.decorationFont);var a,o,m,n;if(this.decorationsPosition=="right"){o=p+(q/2)+((this.y-this.legendDecorationHeight)/2)}else{o=(p+this.y+this.bottom)-this.legendDecorationHeight}if(k.nlfit){n=(this.margin*5)+(5*c);if(this.decorationsPosition=="right"){m=(e+this.x+this.right+c)-n}else{m=e+((this.x-this.legendDecorationWidth)/2)+(this.legendDecorationWidth-n)+c}a=m;this.drawText("Min",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("Max",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("EC50",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("Slope",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("p-Val",a,o,this.decorationFont,this.decorationsColor,"right","middle");o+=q+q;for(var h=0;h<k.nlfit.length;h++){var f=h%this.colors.length;f=k.nlfit[h].color?k.nlfit[h].color:this.colors[f];a=(m+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.drawText(k.nlfit[h].label,a,o,this.decorationFont,f,"right","middle");a=m;for(var g=0;g<5;g++){var b=k.nlfit[h].param[g];this.drawText(this.formatNumber(b),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin}o+=q+q}}if(k.line){for(var h=0;h<k.line.length;h++){if(k.line[h].label){if(this.decorationsPosition=="right"){a=e+this.x+this.margin}else{a=e+((this.x-this.legendDecorationWidth)/2)+this.margin}for(var h=0;h<k.line.length;h++){var f=k.line[h].color?k.line[h].color:this.colors[h%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.drawText(k.line[h].label,a,o,this.decorationFont,f,"left","middle");o+=q+q}}}}if(k.reg){n=(this.margin*3)+(3*c);if(this.decorationsPosition=="right"){m=(e+this.x+this.right)-n}else{m=e+((this.x-this.legendDecorationWidth)/2)+(this.legendDecorationWidth-n)+c}a=m;this.drawText("Slope",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("Int",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("Cor",a,o,this.decorationFont,this.decorationsColor,"right","middle");o+=q+q;for(var h=0;h<k.reg.length;h++){var f=h%this.colors.length;f=k.reg[h].color?k.reg[h].color:this.colors[f];a=(m+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.drawText(k.reg[h].label,a,o,this.decorationFont,f,"right","middle");a=m;this.drawText(this.formatNumber(k.reg[h].slope),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText(this.formatNumber(k.reg[h].intercept),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText(this.formatNumber(k.reg[h].cor),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;o+=q+q}}if(k.nor){n=(this.margin*2)+(2*c);if(this.decorationsPosition=="right"){m=(e+this.x+this.right)-n}else{m=e+((this.x-this.legendDecorationWidth)/2)+(this.legendDecorationWidth-n)+c}a=m;this.drawText("Mu",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("Sigma",a,o,this.decorationFont,this.decorationsColor,"right","middle");o+=q+q;for(var h=0;h<k.nor.length;h++){var f=h%this.colors.length;f=k.nor[h].color?k.nor[h].color:this.colors[f];a=(m+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.drawText(k.nor[h].label,a,o,this.decorationFont,f,"right","middle");a=m;this.drawText(this.formatNumber(k.nor[h].mu),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText(this.formatNumber(k.nor[h].sigma),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;o+=q+q}}if(k.area){for(var h=0;h<k.area.length;h++){if(k.area[h].label){if(this.decorationsPosition=="right"){a=e+this.x+this.margin}else{a=e+((this.x-this.legendDecorationWidth)/2)+this.margin}for(var h=0;h<k.area.length;h++){var f=k.area[h].color?k.area[h].color:this.colors[h%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.drawText(k.area[h].label,a,o,this.decorationFont,f,"left","middle");o+=q+q}}}}}};this.setLegendFont=function(){if(this.autoScaleFont){if(this.layoutComb){this.legendFont=(parseInt(Math.max(this.minTextSize,this.legendFontSize-Math.min(this.layoutRows,this.layoutCols))*this.legendScaleFontFactor))}else{this.legendFont=(parseInt(this.legendFontSize*this.legendScaleFontFactor))}this.legendFont=this.legendFont+"Pt "+this.fontName}else{this.legendFont=parseInt(this.legendFontSize)+"Pt "+this.fontName}};this.setSampleLegendDimension=function(){this.legendSampleWidth=0;this.legendSampleHeight=0;if(this.xAxisIndices.length!=this.yAxisIndices.length||this.xAxisIndices.length>1){var d=this.getFontPt(this.legendFont);var b=0;if(this.xAxisIndices.length==this.yAxisIndices.length&&this.xAxisIndices.length>1){for(var c=0;c<this.xAxisIndices.length;c++){var a=this.measureText(this.shortenText(this.xAxis[c],this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[c],this.maxSmpStringLen),this.legendFont);b=Math.max(a,b)}}else{if(this.xAxisIndices.length>this.yAxisIndices.length){b=this.measureText(this.shortenText(this.getMaxText(this.xAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[0],this.maxSmpStringLen),this.legendFont)}else{if(this.yAxisIndices.length>this.xAxisIndices.length){b=this.measureText(this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.xAxis[0],this.maxSmpStringLen),this.legendFont)}}}this.legendSampleWidth=(d-1)+b+(this.margin*3);this.legendSampleHeight=(Math.max(this.xAxisIndices.length,this.yAxisIndices.length)*(d+this.margin))+this.margin}};this.drawSampleLegend=function(b,j){var h=b;var d=j;var o=this.getFontPt(this.legendFont);var n=(o-1)/2;j+=this.margin+n;if(this.legendBox){this.disableGradientTransparency();this.rectangle(h,d,this.legendSampleWidth,this.legendSampleHeight,this.legendBackgroundColor,this.legendBoxColor);this.enableGradientTransparency()}var l=Math.max(this.xAxisIndices.length,this.yAxisIndices.length);for(var f=0;f<l;f++){var c=f%this.colors.length;var m=0;var g=this.xAxisIndices.length==this.yAxisIndices.length?this.yAxis[f]:this.xAxisIndices.length>this.yAxisIndices.length?this.yAxis[0]:this.xAxis[0];var k=this.shortenText(this.xAxisIndices.length<this.yAxisIndices.length?this.yAxis[f]:this.xAxis[f],this.maxSmpStringLen)+" vs "+this.shortenText(g,this.maxSmpStringLen);var e=b+n+this.margin;var a=j+n+this.margin;if(this.colorBy){this.drawShape(this.shapes[m],e,j,o-1,o-1,this.background,this.colors[c],"open")}else{this.drawShape(this.shapes[m],e,j,o-1,o-1,this.colors[c],this.foreground,"closed")}this.drawText(k,e+n+this.margin,j,this.legendFont,this.legendColor,"left","middle");j+=o+this.margin}if(this.legendBox){this.rectangle(h,d,this.legendSampleWidth,this.legendSampleHeight,false,this.legendBoxColor,"open")}this.addArea(["rect",h,d,h+this.legendSampleWidth,d+this.legendSampleHeight],[-1],"-legend-sample")};this.setVariableLegendDimension=function(){this.legendVariableWidth=0;this.legendVariableHeight=0;if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")){var a=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],this.getFontPt(this.legendFont)):this.getFontPt(this.legendFont);var b=this.shortenText(this.maxVarNameStr,this.maxVarStringLen);this.legendVariableWidth=(a-1)+this.measureText(b,this.legendFont)+(this.margin*3);this.legendVariableHeight=(this.varIndices.length*(a+this.margin))+this.margin}};this.drawVariableLegend=function(c,l){if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")){var j=c;var e=l;var p=this.getFontPt(this.legendFont);var k=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],p):p;l+=this.margin+(k/2);if(this.legendBox&&this.legendBackgroundColor){this.disableGradientTransparency();this.rectangle(j,e,this.legendVariableWidth,this.legendVariableHeight,this.legendBackgroundColor,this.legendBoxColor);this.enableGradientTransparency()}for(var g=0;g<this.varIndices.length;g++){var m=this.varIndices[g];var d=this.colorBy&&this.colorBy=="variable"?g%this.colors.length:0;var o=this.shapeBy&&this.shapeBy=="variable"?g%this.shapes.length:0;var b=this.sizeBy&&this.sizeBy=="variable"?this.sizes[g%this.sizes.length]:k;var n=k/2;var f=c+n+this.margin;var a=l+n+this.margin;var h=this.shortenText(this.data.y.vars[m],this.maxVarStringLen);if(this.colorBy&&this.colorBy!="variable"){this.drawShape(this.shapes[o],f,l,b,b,this.background,this.foreground,"open")}else{this.drawShape(this.shapes[o],f,l,b,b,this.colors[d],this.foreground,"closed")}this.drawText(h,f+n+this.margin,l,this.legendFont,this.legendColor,"left","middle");l+=k+this.margin}if(this.legendBox){this.rectangle(j,e,this.legendVariableWidth,this.legendVariableHeight,false,this.legendBoxColor,"open")}this.addArea(["rect",j,e,j+this.legendVariableWidth,e+this.legendVariableHeight],[-1],"-legend-variable")}};this.setColorLegendIndicatorDimensions=function(){var a=this.heatmapType.split("-");if(this.heatmapType.split("-").length>1){this.legendColorIndicatorWidth=parseInt(2*256*this.indicatorWidth/this.indicatorBins)+(this.margin*4)+1}else{this.legendColorIndicatorWidth=parseInt(1*256*this.indicatorWidth/this.indicatorBins)+(this.margin*4)+1}this.legendColorIndicatorHeight=this.indicatorHeight+(this.margin*3)+this.getFontPt(this.legendFont);if(this.colorBy){this.legendColorIndicatorHeight+=this.getFontPt(this.legendFont)+this.margin}};this.getHeatmapColor=function(d,c,e){var b=Math.abs(d);d+=b;c+=b;e+=b;var a=(e*this.heatmapColors.length/c).toFixed()-1;return this.heatmapColors[Math.max(0,Math.min(this.heatmapColors.length-1,a))]};this.drawColorIndicator=function(b,m,e,k,g){var j=b;var d=m;var a=this.indicatorHeight;var l=this.indicatorHeight;if(this.indicatorsPosition=="bottom"){for(var f=0;f<this.heatmapColors.length;f++){var h=this.transparency!=null?this.addColorTransparency(this.heatmapColors[f],this.transparency):this.heatmapColors[f];this.drawLine("line",b,m,b,m+l,h,this.indicatorWidth+0.5);b+=this.indicatorWidth}b=j-(this.indicatorWidth/2);m+=l+this.margin;this.drawText(sprintf("%."+g+"f",e),b,m,this.legendFont,this.legendColor,"center","top");b+=(this.heatmapColors.length*this.indicatorWidth/2)-(this.indicatorWidth/2);if(this.heatmapColors.length>=10){this.drawText(sprintf("%."+g+"f",(e+k)/2),b,m,this.legendFont,this.legendColor,"center","top")}if(this.colorBy){this.drawText(this.colorBy,b,m+this.margin+this.getFontPt(this.legendFont),this.legendFont,this.legendColor,"center","top")}b+=(this.heatmapColors.length*this.indicatorWidth/2)-(this.indicatorWidth/2);this.drawText(sprintf("%."+g+"f",k),b,m,this.legendFont,this.legendColor,"center","top");this.addArea(["rect",j-(this.margin*2),d-this.margin,b+(this.margin*2),m+this.getFontPt(this.legendFont)+this.margin],[-1],"-legend-indicator-color")}else{for(var f=0;f<this.heatmapColors.length;f++){var h=this.transparency!=null?this.addColorTransparency(this.heatmapColors[f],this.transparency):this.heatmapColors[f];this.drawLine("line",b,m,b+a,m,h,this.indicatorWidth+0.5);m-=this.indicatorWidth}b+=a+this.margin;m=d-(this.indicatorWidth/2);this.drawText(sprintf("%."+g+"f",e),b,m,this.legendFont,this.legendColor,"center","top",-Math.PI/2);m-=(this.heatmapColors.length*this.indicatorWidth/2)-(this.indicatorWidth/2);if(this.heatmapColors.length>=10){this.drawText(sprintf("%."+g+"f",(e+k)/2),b,m,this.legendFont,this.legendColor,"center","top",-Math.PI/2)}if(this.colorBy){this.drawText(this.colorBy,b+this.margin+this.getFontPt(this.legendFont),m,this.legendFont,this.legendColor,"center","top",-Math.PI/2)}m-=(this.heatmapColors.length*this.indicatorWidth/2)-(this.indicatorWidth/2);this.drawText(sprintf("%."+g+"f",k),b,m,this.legendFont,this.legendColor,"center","top",-Math.PI/2);this.addArea(["rect",j-this.margin,m-(this.margin*2),b+this.margin+this.getFontPt(this.legendFont),d+(this.margin*2)],[-1],"-legend-indicator-color")}};this.setShapeLegendIndicatorDimensions=function(){this.legendShapeIndicatorWidth=(10*(this.indicatorHeight+this.margin))+(this.margin*2);this.legendShapeIndicatorHeight=this.indicatorHeight+(this.margin*3)+this.getFontPt(this.legendFont);if(this.shapeBy){this.legendShapeIndicatorHeight+=this.getFontPt(this.legendFont)+this.margin}};this.drawShapeIndicator=function(b,m,e,l,g){var k=b;var c=m;var j=this.indicatorHeight/2;var d=b;var a=m;if(this.indicatorsPosition=="bottom"){for(var f=0;f<10;f++){this.drawShape("pie"+f,d,a+this.margin,this.indicatorHeight,this.indicatorHeight,this.background,this.foreground,"open");d+=this.indicatorHeight+j}b=k;m+=this.indicatorHeight+this.margin;this.drawText(sprintf("%."+g+"f",e),b,m,this.legendFont,this.legendColor,"center","top");b+=this.indicatorHeight*7;this.drawText(sprintf("%."+g+"f",(e+l)/2),b,m,this.legendFont,this.legendColor,"center","top");if(this.shapeBy){this.drawText(this.shapeBy,b,m+this.margin+this.getFontPt(this.legendFont),this.legendFont,this.legendColor,"center","top")}b+=this.indicatorHeight*7;this.drawText(sprintf("%."+g+"f",l),b,m,this.legendFont,this.legendColor,"center","top");this.addArea(["rect",k-(this.margin*2),c-this.margin,b+(this.margin*2),m+this.getFontPt(this.legendFont)+this.margin],[-1],"-legend-indicator-shape")}else{for(var f=0;f<10;f++){this.drawShape("pie"+f,d+this.margin,a,this.indicatorHeight,this.indicatorHeight,this.background,this.foreground,"open");a-=this.indicatorHeight+j}b+=this.indicatorHeight+this.margin;m=c;this.drawText(sprintf("%."+g+"f",e),b,m,this.legendFont,this.legendColor,"center","top",-Math.PI/2);m-=this.indicatorHeight*7;if(this.heatmapColors.length>=10){this.drawText(sprintf("%."+g+"f",(e+l)/2),b,m,this.legendFont,this.legendColor,"center","top",-Math.PI/2)}if(this.shapeBy){this.drawText(this.shapeBy,b+this.margin+this.getFontPt(this.legendFont),m,this.legendFont,this.legendColor,"center","top",-Math.PI/2)}m-=this.indicatorHeight*7;this.drawText(sprintf("%."+g+"f",l),b,m,this.legendFont,this.legendColor,"center","top",-Math.PI/2);this.addArea(["rect",k-this.margin,m-(this.margin*2),b+this.margin+this.getFontPt(this.legendFont),c+(this.margin*2)],[-1],"-legend-indicator-shape")}};this.setSizeLegendIndicatorDimensions=function(){var a=0;var c=this.indicatorHeight/2;for(var b=0;b<10;b++){a+=this.sizes[b]+c}this.legendSizeIndicatorWidth=(a-(this.sizes[0]+this.sizes[9]))+(this.margin*4);this.legendSizeIndicatorHeight=this.sizes[9]+(this.margin*3)+this.getFontPt(this.legendFont);if(this.sizeBy){this.legendSizeIndicatorHeight+=this.getFontPt(this.legendFont)+this.margin}};this.drawSizeIndicator=function(d,p,g,o,k){var n=d;var e=p;var l=this.indicatorHeight/2;var q=this.sizes[9];var f=d;var a=p;var m=d;var c=p;if(this.indicatorsPosition=="bottom"){for(var j=0;j<10;j++){var b=this.sizes[j];this.drawShape("sphere",f,a+(q/2),b,b,this.background,this.foreground,"open");f+=b+l;if(j<4){m+=b+l}else{if(j==5){m+=(b+l)/2}}}p+=q+this.margin;this.drawText(sprintf("%."+k+"f",g),n,p,this.legendFont,this.legendColor,"center","top");this.drawText(sprintf("%."+k+"f",(g+o)/2),m,p,this.legendFont,this.legendColor,"center","top");if(this.sizeBy){this.drawText(this.sizeBy,n+(this.legendColorIndicatorWidth/2),p+this.margin+this.getFontPt(this.legendFont),this.legendFont,this.legendColor,"center","top")}this.drawText(sprintf("%."+k+"f",o),f-(q+l),p,this.legendFont,this.legendColor,"center","top");this.addArea(["rect",n-(this.margin*2),e-this.margin,(f-q)+(this.margin*2),p+this.getFontPt(this.legendFont)+this.margin],[-1],"-legend-indicator-size")}else{for(var j=0;j<10;j++){var b=this.sizes[j];this.drawShape("sphere",f+(q/2),a,b,b,this.background,this.foreground,"open");a-=(b+l);if(j<4){c-=(b+l)}else{if(j==5){c-=((b+l)/2)}}}d+=q+this.margin;this.drawText(sprintf("%."+k+"f",g),d,p,this.legendFont,this.legendColor,"center","top",-Math.PI/2);this.drawText(sprintf("%."+k+"f",(g+o)/2),d,c,this.legendFont,this.legendColor,"center","top",-Math.PI/2);if(this.sizeBy){this.drawText(this.sizeBy,d+this.margin+this.getFontPt(this.legendFont),e-(this.legendColorIndicatorWidth/2),this.legendFont,this.legendColor,"center","top",-Math.PI/2)}this.drawText(sprintf("%."+k+"f",o),d,a+(q+l),this.legendFont,this.legendColor,"center","top",-Math.PI/2);this.addArea(["rect",n-this.margin,(a+(q+l))-(this.margin*2),d+this.margin+this.getFontPt(this.legendFont),e+(this.margin*2)],[-1],"-legend-indicator-size")}};this.setDataColorShapeSizeIndicatorDimensions=function(){this.setColorLegendIndicatorDimensions();this.setShapeLegendIndicatorDimensions();this.setSizeLegendIndicatorDimensions()};this.getDiameterLegend=function(){return this.x>=600?10:this.x>=400?8:this.x>=200?6:4};this.setColorLegendDimensions=function(a){this.legendColorWidth=0;this.legendColorHeight=0;if(this.colorBy){var f,e;var i=this.getDiameterLegend();if(a&&this.data.x.hasOwnProperty(this.colorBy)){f=this.setMaxSmpStringAnnt(this.colorBy);e=this.setMaxSmpStringLabel(this.colorBy)}else{if(this.data.z.hasOwnProperty(this.colorBy)){f=this.setMaxVarStringAnnt(this.colorBy);e=this.setMaxVarStringLabel(this.colorBy)}}var b=this.measureText(f,this.legendFont);var c=this.measureText(e,this.legendFont)+i+this.margin;this.legendColorWidth=Math.max(b,c)+(this.margin*2);var h=this.getFontPt(this.legendFont);var g=Math.max(i,h);this.legendColorHeight=(this.legendColorsN*(g+this.margin))+h+(this.margin*3)}};this.drawColorLegend=function(c,e){if(this.colorBy&&((this.data.x&&this.data.x.hasOwnProperty(this.colorBy))||(this.data.z&&this.data.z.hasOwnProperty(this.colorBy)))){var h=this.getDiameterLegend();var f=this.getFontPt(this.legendFont);var i=f/2;var g=e+this.margin+i;var a=Math.max(h,f);this.disableGradientTransparency();if(this.legendBackgroundColor){this.rectangle(c,e,this.legendColorWidth,this.legendColorHeight,this.legendBackgroundColor)}else{this.rectangle(c,e,this.legendColorWidth,this.legendColorHeight,false,this.foreground,"open")}this.enableGradientTransparency();this.drawText(this.colorBy,c+(this.legendColorWidth/2),g,this.legendFont,this.colorLegend,"center","middle");g+=i+this.margin;this.drawLine("line",c,g,c+this.legendColorWidth,g,this.foreground);g+=this.margin+(a/2);for(var b in this.legendColors){this.drawShape("circle",c+this.margin+(h/2),g,h,h,this.legendColors[b],this.foreground,"closed");this.drawText(b,c+(this.margin*2)+h,g,this.legendFont,this.colorLegend,"left","middle");g+=this.margin+a}this.addArea(["rect",c,e,c+this.legendColorWidth,e+this.legendColorHeight],[-1],"-legend-color")}};this.setShapeLegendDimensions=function(){this.legendShapeWidth=0;this.legendShapeHeight=0;if(this.shapeBy&&this.data.z.hasOwnProperty(this.shapeBy)){var h=this.getDiameterLegend();var e=this.setMaxVarStringAnnt(this.shapeBy);var c=this.setMaxVarStringLabel(this.shapeBy);var a=this.measureText(e,this.legendFont);var b=this.measureText(c,this.legendFont)+h+this.margin;this.legendShapeWidth=Math.max(a,b)+(this.margin*2);var g=this.getFontPt(this.legendFont);var f=Math.max(h,g);this.legendShapeHeight=(this.legendShapesN*(f+this.margin))+g+(this.margin*3)}};this.drawShapeLegend=function(b,c){if(this.shapeBy&&this.data.z.hasOwnProperty(this.shapeBy)){var h=this.getDiameterLegend();var e=this.getFontPt(this.legendFont);var i=e/2;var g=c+this.margin+i;var a=Math.max(h,e);this.disableGradientTransparency();if(this.legendBackgroundColor){this.rectangle(b,c,this.legendShapeWidth,this.legendShapeHeight,this.legendBackgroundColor)}else{this.rectangle(b,c,this.legendShapeWidth,this.legendShapeHeight,false,this.foreground,"open")}this.enableGradientTransparency();this.drawText(this.shapeBy,b+(this.legendShapeWidth/2),g,this.legendFont,this.colorLegend,"center","middle");g+=i+this.margin;this.drawLine("line",b,g,b+this.legendShapeWidth,g,this.foreground);g+=this.margin+(a/2);for(var f in this.legendShapes){this.drawShape(this.legendShapes[f],b+this.margin+(h/2),g,h,h,this.background,this.foreground,"closed");this.drawText(f,b+(this.margin*2)+h,g,this.legendFont,this.colorLegend,"left","middle");g+=this.margin+a}this.addArea(["rect",b,c,b+this.legendShapeWidth,c+this.legendShapeHeight],[-1],"-legend-shape")}};this.setSizeLegendDimensions=function(){this.legendSizeWidth=0;this.legendSizeHeight=0;if(this.sizeBy&&this.data.z.hasOwnProperty(this.sizeBy)){var h=this.sizes[this.legendSizesN-1];var e=this.setMaxVarStringAnnt(this.sizeBy);var c=this.setMaxVarStringLabel(this.sizeBy);var a=this.measureText(e,this.legendFont);var b=this.measureText(c,this.legendFont)+h+this.margin;this.legendSizeWidth=Math.max(a,b)+(this.margin*2);var g=this.getFontPt(this.legendFont);var f=Math.max(h,g);this.legendSizeHeight=(this.legendSizesN*(f+this.margin))+g+(this.margin*3)}};this.drawSizeLegend=function(c,e){if(this.sizeBy&&this.data.z.hasOwnProperty(this.sizeBy)){var h=this.sizes[this.legendSizesN-1];var f=this.getFontPt(this.legendFont);var i=f/2;var g=e+this.margin+i;var a=Math.max(h,f);this.disableGradientTransparency();if(this.legendBackgroundColor){this.rectangle(c,e,this.legendSizeWidth,this.legendSizeHeight,this.legendBackgroundColor)}else{this.rectangle(c,e,this.legendSizeWidth,this.legendSizeHeight,false,this.foreground,"open")}this.enableGradientTransparency();this.drawText(this.sizeBy,c+(this.legendSizeWidth/2),g,this.legendFont,this.colorLegend,"center","middle");g+=i+this.margin;this.drawLine("line",c,g,c+this.legendSizeWidth,g,this.foreground);g+=this.margin+(a/2);for(var b in this.legendSizes){this.drawShape("circle",c+this.margin+(h/2),g,this.legendSizes[b],this.legendSizes[b],this.background,this.foreground,"closed");this.drawText(b,c+(this.margin*2)+h,g,this.legendFont,this.colorLegend,"left","middle");g+=this.margin+a}this.addArea(["rect",c,e,c+this.legendSizeWidth,e+this.legendSizeHeight],[-1],"-legend-size")}};this.setDataColorShapeSizeDimensions=function(){this.setColorLegendDimensions();this.setShapeLegendDimensions();this.setSizeLegendDimensions()};this.setDataColor=function(d){if(this.colorBy){var a=0;var b={};this.dataColors=[];this.legendColors={};this.legendColorsN=0;if(d){if(!this.isGroupedData&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)){if(this.isNumeric(this.data.x[this.colorBy],true)){var c=this.range(this.data.x[this.colorBy],true);for(var f=0;f<this.smpIndices.length;f++){var g=this.smpIndices[f];var h=this.data.x[this.colorBy][g];var e=!isNaN(h)?this.getHeatmapColor(c[0],c[1],h):this.missingDataColor;this.dataColors.push(e)}this.legendColorsN=-1;this.legendColorRange=c;this.legendColorDecs=this.getAxisDecimals(this.getAxisIncrements(c[0],c[1],this.heatmapColors.length));this.setColorLegendIndicatorDimensions()}else{for(var f=0;f<this.smpIndices.length;f++){var g=this.smpIndices[f];var e=this.data.x[this.colorBy][g];if(!b.hasOwnProperty(e)){b[e]=a%this.colors.length;this.legendColors[e]=this.colors[b[e]];a++}this.dataColors.push(this.colors[b[e]])}this.legendColorsN=a;this.setColorLegendDimensions(d)}}}else{if(this.data.z&&this.data.z.hasOwnProperty(this.colorBy)){if(this.isNumeric(this.data.z[this.colorBy],false,true)){var c=this.range(this.data.z[this.colorBy],false,true);for(var f=0;f<this.varIndices.length;f++){var g=this.varIndices[f];var h=this.data.z[this.colorBy][g];if(!isNaN(h)){this.dataColors.push(this.getHeatmapColor(c[0],c[1],h))}else{this.dataColors.push(this.missingDataColor)}}this.legendColorRange=c;this.legendColorDecs=this.getAxisDecimals(this.getAxisIncrements(c[0],c[1],this.heatmapColors.length));this.setColorLegendIndicatorDimensions()}else{for(var f=0;f<this.varIndices.length;f++){var g=this.varIndices[f];var e=this.data.z[this.colorBy][g];if(!b.hasOwnProperty(e)){b[e]=a%this.colors.length;this.legendColors[e]=this.colors[b[e]];a++}this.dataColors.push(this.colors[b[e]])}this.legendColorsN=a;this.setColorLegendDimensions()}}else{if(this.getSampleIndices(this.colorBy)>-1){a=this.getSampleIndices(this.colorBy);var c=this.getAxisRangeBySample(a);if(!this.scatterType||this.scatterType!="function"){for(var f=0;f<this.varIndices.length;f++){var g=this.varIndices[f];var h=this.getDataAtPos(g,a);if(!isNaN(h)){this.dataColors.push(this.getHeatmapColor(c[0],c[1],h))}else{this.dataColors.push(this.missingDataColor)}}}this.legendColorRange=c;this.legendColorDecs=this.getAxisDecimals(this.getAxisIncrements(c[0],c[1],this.heatmapColors.length));this.setColorLegendIndicatorDimensions()}else{if(this.colorBy=="variable"){for(var f=0;f<this.varIndices.length;f++){var e=f%this.colors.length;this.dataColors.push(this.colors[e])}this.setVariableLegendDimension()}else{for(var f=0;f<this.varIndices.length;f++){this.dataColors.push(this.colors[0])}}}}}}};this.setDataShape=function(){if(this.shapeBy){var f=0;var a={};var j="square";this.dataShapes=[];this.legendShapes={};this.legendShapesN=0;if(this.data.z&&this.data.z.hasOwnProperty(this.shapeBy)){if(this.isNumeric(this.data.z[this.shapeBy],false,true)){var e=this.range(this.data.z[this.shapeBy],false,true);for(var d=0;d<this.varIndices.length;d++){var g=this.varIndices[d];var b=this.data.z[this.shapeBy][g];if(!isNaN(b)){var c=this.percentile(e[0],e[1],b);var h=parseInt(c/10);if(h>0){h--}this.dataShapes.push("pie"+h)}else{this.dataShapes.push(j)}}this.legendShapeRange=e;this.legendShapeDecs=this.getAxisDecimals(this.getAxisIncrements(e[0],e[1],10));this.setShapeLegendIndicatorDimensions()}else{for(var d=0;d<this.varIndices.length;d++){var g=this.varIndices[d];var h=this.data.z[this.shapeBy][g];if(!a.hasOwnProperty(h)){a[h]=f%this.shapes.length;this.legendShapes[h]=this.shapes[a[h]];f++}this.dataShapes.push(this.shapes[a[h]])}this.legendShapesN=f;this.setShapeLegendDimensions()}}else{if(this.getSampleIndices(this.shapeBy)>-1){f=this.getSampleIndices(this.shapeBy);var e=this.getAxisRangeBySample(f);for(var d=0;d<this.varIndices.length;d++){var g=this.varIndices[d];var b=this.getDataAtPos(g,f);if(!isNaN(b)){var c=this.percentile(e[0],e[1],b);var h=parseInt(c/10);if(h>0){h--}this.dataShapes.push("pie"+h)}else{this.dataShapes.push(j)}}this.legendShapeRange=e;this.legendShapeDecs=this.getAxisDecimals(this.getAxisIncrements(e[0],e[1],10));this.setShapeLegendIndicatorDimensions()}else{if(this.shapeBy=="variable"){for(var d=0;d<this.varIndices.length;d++){var h=d%this.shapes.length;this.dataShapes.push(this.shapes[h])}this.setVariableLegendDimension()}else{for(var d=0;d<this.varIndices.length;d++){this.dataShapes.push(this.shapes[0])}}}}}};this.setDataSize=function(){if(this.sizeBy){var a=0;var c={};this.dataSizes=[];this.legendSizes={};this.legendSizesN=0;if(this.data.z&&this.data.z.hasOwnProperty(this.sizeBy)){if(this.isNumeric(this.data.z[this.sizeBy],false,true)){var d=this.range(this.data.z[this.sizeBy],false,true);for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];var g=this.data.z[this.sizeBy][f];if(!isNaN(g)){var h=this.percentile(d[0],d[1],g);var b=parseInt(h/10);if(b>0){b--}this.dataSizes.push(this.sizes[b])}else{this.dataSizes.push(0)}}this.legendSizeRange=d;this.legendSizeDecs=this.getAxisDecimals(this.getAxisIncrements(d[0],d[1],10));this.setSizeLegendIndicatorDimensions()}else{for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];var b=this.data.z[this.sizeBy][f];if(!c.hasOwnProperty(b)){c[b]=a%this.sizes.length;this.legendSizes[b]=this.sizes[c[b]];a++}this.dataSizes.push(this.sizes[c[b]])}this.legendSizesN=a;this.setSizeLegendDimensions()}}else{if(this.getSampleIndices(this.sizeBy)>-1){a=this.getSampleIndices(this.sizeBy);var d=this.getAxisRangeBySample(a);for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];var g=this.getDataAtPos(f,a);if(!isNaN(g)){var h=this.percentile(d[0],d[1],g);var b=parseInt(h/10);if(b>0){b--}this.dataSizes.push(this.sizes[b])}else{this.dataSizes.push(0)}}this.legendSizeRange=d;this.legendSizeDecs=this.getAxisDecimals(this.getAxisIncrements(d[0],d[1],10));this.setSizeLegendIndicatorDimensions()}else{if(this.sizeBy=="variable"){for(var e=0;e<this.varIndices.length;e++){var b=e%this.sizes.length;this.dataSizes.push(this.sizes[b])}this.setVariableLegendDimension()}else{for(var e=0;e<this.varIndices.length;e++){this.dataSizes.push(this.scatterPointSize)}}}}}};this.setDataColorShapeSize=function(){this.resetLegends();this.setLegendFont();this.setDataColor();this.setDataShape();this.setDataSize();if(!this.allVsAll&&(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2d")){this.setSampleLegendDimension()}};this.resetLegends=function(){var a=["Color","Shape","Size"];for(var c=0;c<a.length;c++){this["legend"+a[c]+"IndicatorWidth"]=0;this["legend"+a[c]+"IndicatorHeight"]=0;this["data"+a[c]+"s"]=[];this["legend"+a[c]+"s"]={};this["legend"+a[c]+"sN"]=0}var b=this.allVsAll?["Color","Shape","Size","Variable"]:["Color","Shape","Size","Variable","Sample"];for(var c=0;c<b.length;c++){this["legend"+b[c]+"Width"]=0;this["legend"+b[c]+"Height"]=0}};this.setLegendDimensions=function(){this.legendLayout=[];var a=this.margin;var l=this.margin;if(this.showIndicators){var f=["Color","Shape","Size"];for(var c=0;c<f.length;c++){var j=this["legend"+f[c]+"IndicatorWidth"];var d=this["legend"+f[c]+"IndicatorHeight"];if(j){if(this.indicatorsPosition=="bottom"){l+=this.margin+d}else{a+=this.margin+d}}}}var b=0;var k=0;var g=0;if(this.showLegend){var e=this.allVsAll?["Color","Shape","Size","Variable"]:["Color","Shape","Size","Variable","Sample"];for(var c=0;c<e.length;c++){var j=this["legend"+e[c]+"Width"];var d=this["legend"+e[c]+"Height"];if(j>0){if(this.legendPosition=="right"){if(k+this.margin+d>this.height){a+=this.margin+j;b=j;k=d;g++;this.legendLayout[g]=[e[c]]}else{if(j>b){a+=(j-b);b=j}k+=d;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}else{if(b+this.margin+j>this.width){l+=this.margin+d;b=j;k=d;g++;this.legendLayout[c]=[e[c]]}else{if(d>k){l+=(d-k);k=d}b+=j;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}}}}this.legendWidth=a+this.margin;this.legendHeight=l+this.margin};this.getXYLegendCoords=function(o,a,q){var n,e,m,g;var k=0;var c=0;var p=-1;var f=-1;if(this.legendLayout){for(var d=0;d<this.legendLayout.length;d++){n=0;e=0;for(var b=0;b<this.legendLayout[d].length;b++){if(this.legendLayout[d][b]==o){f=b}n+=this["legend"+this.legendLayout[d][b]+"Width"]+this.margin;e+=this["legend"+this.legendLayout[d][b]+"Height"]+this.margin;k=Math.max(k,n);c=Math.max(c,e)}if(f>-1){p=d;break}}if(this.legendPosition=="right"){q=f==0&&this.allVsAll?this.marginTop+this.layoutTop:f==0?this.marginTop+this.offsetY+this.top:q;m=a;g=f==0&&this.allVsAll?(this.height-c)/2:f==0?this.marginTop+this.offsetY+this.top+((this.y-c)/2):q;a=f==this.legendLayout[p].length-1?a+k:a;q=g+this["legend"+this.legendLayout[p][f]+"Height"]+this.margin}else{a=f==0&&this.allVsAll?this.marginLeft+this.layoutLeft:f==0?this.marginLeft+this.offsetX+this.left:a;m=f==0&&this.allVsAll?(this.width-k)/2:f==0?this.marginLeft+this.offsetX+this.left+((this.x-k)/2)+this.margin:a+this.margin;g=q;a=m+this["legend"+this.legendLayout[p][f]+"Width"]+this.margin;q=f==this.legendLayout[p].length-1?q+c:q}}return[m,g,a,q]};this.drawScatterLegend=function(){var c=this.allVsAll?this.width-(this.marginRight+this.layoutRight):this.marginLeft+this.offsetX+this.left+this.x;var k=this.allVsAll?this.height-(this.marginBottom+this.layoutBottom):this.marginTop+this.offsetY+this.top+this.y;if(this.showIndicators){var o,g;var a,n;if(!this.allVsAll&&(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D")){c+=(this.margin*2);k+=this.get2DXAxisHeight()+this.margin;if(this.graphType=="ScatterBubble2D"&&this.zAxisShow){c+=this.getFontPt(this.axisTitleFont)+(this.margin*2)}}else{c+=(this.margin*1);k+=(this.margin*1)}var l=["Color","Shape","Size"];for(var e=0;e<l.length;e++){o=this["legend"+l[e]+"IndicatorWidth"];g=this["legend"+l[e]+"IndicatorHeight"];if(o){var b="draw"+l[e]+"Indicator";var f=this["legend"+l[e]+"Range"];var d=this["legend"+l[e]+"Decs"];if(this.indicatorsPosition=="bottom"){a=this.allVsAll?(this.width-o)/2:this.marginLeft+this.offsetX+this.left+((this.x-o)/2);n=k;this[b](a,n,f[0],f[1],d);k+=g+this.margin}else{a=c;n=this.allVsAll?(this.height-g)/2:this.marginTop+this.offsetY+this.top+(this.y-((this.y-o)/2));this[b](a,n,f[0],f[1],d);c+=g+this.margin}}}}if(this.showLegend){var j=this.allVsAll?["Color","Shape","Size","Variable"]:["Color","Shape","Size","Variable","Sample"];for(var e=0;e<j.length;e++){o=this["legend"+j[e]+"Width"];g=this["legend"+j[e]+"Height"];if(o>0){var b="draw"+j[e]+"Legend";var m=this.getXYLegendCoords(j[e],c,k);this[b](m[0],m[1]);if(this.legendPosition=="right"){k=m[3]+this.margin}else{c=m[2]+this.margin}}}}}};CanvasXpress.prototype.initApi=function(){this.getValidGraphTypes=function(){return this.validGraphTypes};this.setHeatmapScheme=function(){this.initializeAttributes()};this.hasIndicator=function(){if(this.graphType.match(/Scatter/)||this.graphType=="Bar"){return true}else{return false}};this.hasLegend=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"){return true}else{return false}};this.hasLegendProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"&&this.graphType!="Pie"){return true}else{return false}};this.hasData=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){return true}else{return false}};this.hasDataSamples=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}return true}else{return false}};this.hasDataGroups=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}if(this.data.x){return true}else{return false}}else{return false}};this.hasDataVariables=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){if(this.graphType=="Correlation"&&this.correlationAxis!="variables"){return false}return true}else{return false}};this.hasDataProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Heatmap"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"){return true}else{return false}};this.hasOrientation=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasOverlays=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasDendrograms=function(){if(this.graphType!="Heatmap"&&(this.data.t.smps||this.data.t.vars)){return true}else{return false}};this.hasDecorations=function(){return this.data.d&&(this.data.d.nlfit||this.data.d.line||this.data.d.reg||this.data.d.nor||this.data.d.area)?true:false};this.isSegregable=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.getLineTypes=function(){var e=["line"];var c=["","dashed","dotted","bezierY","bezierX","curved"];var a=["arrow","arrowHead","arrowTail","arrowHeadSquareTail","arrowTailSquareHead","square","squareHead","squareTail","squareHeadArrowTail","squareTailArrowHead"];for(var d=0;d<a.length;d++){e.push(a[d]+"Line")}for(var d=1;d<c.length;d++){for(var b=0;b<a.length;b++){e.push(c[d]+this.capitalize(a[b])+"Line")}}return e};this.isValidShape=function(b){for(var a=0;a<this.shapes.length;a++){if(this.shapes[a]==b){return true}}return false};this.modifyHighlights=function(c,b,d){var a=d?"highlightVar":"highlightSmp";this.modifyObjectArray(c,b,a)};this.getHighlights=function(b){var a=b?this.highlightVar:this.highlightSmp;return this.getObjectArray(a)};this.modifySmpOverlays=function(b,a){this.modifyObjectArray(b,a,"smpOverlays")};this.modifyVarOverlays=function(b,a){this.modifyObjectArray(b,a,"varOverlays")};this.getSmpOverlays=function(){return this.getObjectArray(this.smpOverlays)};this.getVarOverlays=function(){return this.getObjectArray(this.varOverlays)};this.clusterSamples=function(){this.clusterAxis="samples";this.showSmpDendrogram=true;if(!this.data.t){this.data.t={}}this.data.t.smps=this.cluster();this.draw()};this.clusterVariables=function(){this.clusterAxis="variables";this.showVarDendrogram=true;if(!this.data.t){this.data.t={}}this.data.t.vars=this.cluster();this.draw()};this.kmeansSamples=function(){this.clusterAxis="samples";this.showOverlays=true;if(!this.data.x){this.data.x={}}this.data.x["k-Means"]=this.kmeans();if(!this.isInArray("k-Means",this.smpOverlays)){this.smpOverlays.push("k-Means")}this.draw()};this.kmeansVariables=function(){this.clusterAxis="variables";this.showOverlays=true;if(!this.data.z){this.data.z={}}this.data.z["k-Means"]=this.kmeans();if(!this.isInArray("k-Means",this.varOverlays)){this.varOverlays.push("k-Means")}this.draw()};this.reset=function(){this.masterReset()};this.setFunctions=function(){this.functions.push("clusterSamples");this.functions.push("clusterVariables");this.functions.push("transpose");this.functions.push("transform");this.functions.push("sortSamples");this.functions.push("sortVariables");this.functions.push("hideUnhideSmps");this.functions.push("hideUnhideVars");this.functions.push("desegregateSamples");this.functions.push("segregateSamples");this.functions.push("groupSamples");this.functions.push("ungroupSamples");this.functions.push("desegregateVariables");this.functions.push("segregateVariables");this.functions.push("kmeansSamples");this.functions.push("kmeansVariables");this.functions.push("undoNetworkOp");this.functions.push("redoNetworkOp");this.functions.push("setWidth");this.functions.push("setHeight");this.functions.push("setDimensions");this.functions.push("showCodeDiv");this.functions.push("hideCodeDiv");this.functions.push("showInfoDiv");this.functions.push("hideInfoDiv");this.functions.push("updateCodeDiv");this.functions.push("createHistogram");this.functions.push("removeHistogram");this.functions.push("addRegressionLine");this.functions.push("addNormalDistributionLine");this.functions.push("draw");this.functions.push("reset");this.functions.push("print")};this.initializeApi=function(){this.setFunctions()};this.initializeApi()};CanvasXpress.prototype.initText=function(){this.drawTextMultiple=function(v,u,p,n,o,r,q,d,e,w){var h=v.split(/\n/);if(!n){n=this.font}var k=this.getFontPt(n)+4;if(h.length%2){p-=(parseInt(h.length/2)*k)+(k/2)}else{p=(p-parseInt(h.length/2)*k)}for(var j=0;j<h.length;j++){this.drawText(h[j],u,p,n,o,r,q,d,e,w);p+=k}};this.drawText=function(l,j,i,u,z,B,A,g,o,n){var p=function(c){c.shift();var f=[];var m=(Math.PI/2)+g==0?-Math.PI/2:g-Math.PI/2;var b=["poly"];var t=c.shift()-j;var h=c.shift()-i;var a=c.shift()-j;var s=c.shift()-i;f.push((h*Math.sin(m))-(t*Math.cos(m)));f.push((h*Math.cos(m))+(t*Math.sin(m)));f.push((s*Math.sin(m))-(t*Math.cos(m)));f.push((s*Math.cos(m))+(t*Math.sin(m)));f.push((s*Math.sin(m))-(a*Math.cos(m)));f.push((s*Math.cos(m))+(a*Math.sin(m)));f.push((h*Math.sin(m))-(a*Math.cos(m)));f.push((h*Math.cos(m))+(a*Math.sin(m)));while(f.length>1){b.push(f.shift()+j);b.push(f.shift()+i)}return b};var C=[];if(!l){return}if(this.isMultipleLines(l)){return this.drawTextMultiple(l,j,i,u,z,B,A,g,o,n)}if(!this.ctx){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(j)||isNaN(i)){if(this.debug){alert("Not a valid coordinate ("+j+", "+i+") to draw "+l)}return}if(g<(Math.PI/-2)||g>(Math.PI/2)){if(this.debug){alert("Dude, you can only rotate between -PI/2 and PI/2")}return}if(!isNaN(l)){l=this.formatNumber(l)}if(!j){j=0}if(!i){i=0}if(!u){u=this.font}if(!z){z=this.foreground}if(!B){B=this.align}if(!A){A=this.baseline}var k=this.measureText(l,u);var q=this.getFontPt(u);if(o){while(k>o){l=l.substring(0,l.length-1);k=this.measureText(l,u)}}var v,e,r,d;if(B=="left"){v=j;r=v+k}else{if(B=="right"){v=j-k;r=j}else{v=j-(k/2);r=j+(k/2)}}if(A=="top"){e=i;d=e+q}else{if(A=="bottom"){e=i-q;d=i}else{e=i-(q/2);d=i+(q/2)}}C=["rect",v,e,r,d];if(g){C=p(C)}this.ctx.save();this.ctx.strokeStyle=z;this.ctx.fillStyle=z;this.ctx.font=u;this.ctx.save();this.ctx.translate(j,i);this.ctx.textAlign=B;this.ctx.textBaseline=A;if(this.showShadow){this.ctx.shadowOffsetX=this.shadowOffsetX;this.ctx.shadowOffsetY=this.shadowOffsetY;this.ctx.shadowBlur=this.shadowBlur;this.ctx.shadowColor=this.shadowColor}if(g){this.ctx.rotate(g)}if(n){this.ctx.strokeText(l,0,0)}else{this.ctx.fillText(l,0,0)}this.ctx.restore();if(this.showShadow){this.ctx.shadowOffsetX=0;this.ctx.shadowOffsetY=0;this.ctx.shadowBlur=0;this.ctx.shadowColor=this.background}return C};this.isMultipleLines=function(b){var a=b.toString().split(/\n/);return a.length-1};this.capitalize=function(a){if(a){return a.charAt(0).toUpperCase()+a.slice(1)}};this.measureTextMultiple=function(d,e){var b=d.split(/\n/);var a=0;if(!this.ctx){return 0}if(!e){e=this.font}this.ctx.font=e;for(var c=0;c<b.length;c++){a=Math.max(a,this.ctx.measureText(b[c]).width)}return a};this.measureText=function(a,b){if(!this.ctx){return 0}if(!b){b=this.font}this.ctx.font=b;if(this.isMultipleLines(a)){return this.measureTextMultiple(a,b)}else{return this.ctx.measureText(a).width}};this.scaleTextToFont=function(b,d,a){var c=d+"pt "+this.fontName;if(b){while(this.measureText(b,c)>a&&d>=this.minTextSize){d-=2;c=d+"pt "+this.fontName}}return c};this.getFontPt=function(a){return parseInt(a.match(/^\d+/)[0])};this.scaleTextToSize=function(a){var d=this.scaleTextConstantMult;if(!a){a=1}return Math.ceil(1/Math.sqrt(a)*d)};this.formatNumber=function(c){if(c.toString().length>=7){var b=sprintf("%.2e",Number(c));var a=sprintf("%.2f",Number(c));if(a.toString().length>b.toString().length){return b.toString()}else{return a.toString()}}else{return c.toString()}};this.getMaxText=function(d){var f="";var b=0;for(var e=0;e<d.length;e++){var g=this.measureText(d[e],this.font);if(g>b){f=d[e];b=g}}return f};this.shortenText=function(b,a){if(b.length<=a){return b}else{return b.substring(0,a-3)+" ..."}};this.convertToNumber=function(a){if(!isNaN(a)){return parseFloat(a)}else{return a}}};CanvasXpress.prototype.initTime=function(){Date.prototype.getWeek=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((((this-a)/86400000)+a.getDay()+1)/7)};this.getYearWeek=function(a){return a.getFullYear()+"-"+a.getWeek()};this.getYearMonth=function(a){return a.getFullYear()+"-"+a.getMonth()};this.getYear=function(a){return a.getFullYear()};this.times={second:1000,minute:60000,hour:3600000,day:86400000,week:604800000,month:2592000000,year:31556952000};this.parseDate=function(c){var e=parseInt(c.toString().substring(0,4));var a=parseInt(c.toString().substring(4,6).replace(/^0/,""));var b=parseInt(c.toString().substring(6,8).replace(/^0/,""));return new Date(e,a-1,b,0,0)};this.setTimeAxis=function(){var h=this.validateTimeAxis();if(h){var g=Date.parse(h[h.length-1])-Date.parse(h[0]);var d;var b={};var c=[];this.timeValues=[];this.timeValueIndices=[];if(g>this.times.year*2){d="getYear"}else{if(g>this.times.month*2){d="getYearMonth"}else{if(g>this.times.week*2){d="getYearWeek"}else{d=false}}}if(d){if(this.timeTicksFirst){for(var a=0;a<h.length;a++){var e=this[d](h[a]);if(!b.hasOwnProperty(e)){c.push(h[a]);this.timeValueIndices.push(a);b[e]=true}}}else{for(var a=h.length-1;a>=0;a--){var e=this[d](h[a]);if(!b.hasOwnProperty(e)){c.unshift(h[a]);this.timeValueIndices.unshift(a);b[e]=true}}}}else{for(var a=0;a<h.length;a++){this.timeValues.push(dateFormat(h[a],this.timeFormat));this.timeValueIndices.push(a)}}var g=Date.parse(c[c.length-1])-Date.parse(c[c.length-2]);if(d=="getYear"&&g<this.times.month*3){this.timeValues.pop();this.timeValueIndices.pop()}else{if(d=="getYearMonth"&&g<this.times.week*4){this.timeValues.pop();this.timeValueIndices.pop()}else{if(d=="getYearWeek"&&g<this.times.day*7){this.timeValues.pop();this.timeValueIndices.pop()}}}for(var a=0;a<c.length;a++){this.timeValues.push(dateFormat(c[a],this.timeFormat))}}};this.createRandomTimes=function(b){var e;var g=new Date();var a=g.getTime();var f=[new Date(a)];var h=this.isGroupedData?this.data.w:this.data.y;if(!b||!this.times[b]){b="day"}for(var c=0;c<h.smps.length;c++){e=Date.parse(h.smps[c]);if(!isNaN(e)){a=e}else{a-=this.times[b]}f.unshift(new Date(a))}return f};this.validateTimeAxis=function(){var f=this.isGroupedData?this.data.w:this.data.y;var a=false;var e=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices.length!=f.smps.length?Date.parse(f.smps[this.smpIndices[b]]):Date.parse(f.smps[b]);if(isNaN(c)){if(this.isExample){e=this.createRandomTimes();return e}else{a=true;break}}else{e.push(new Date(c))}}return a?false:e}};CanvasXpress.prototype.initAttributes=function(){this.validateNumbers=function(b){for(var c=0;c<b.length;c++){if(isNaN(b[c])){return false}}return true};this.lineTo=function(b,d,a,c){if(b==a){b=Math.round(b)+0.5;a=b}else{if(d==c){d=Math.round(d)+0.5;c=d}}this.ctx.moveTo(b,d);this.ctx.lineTo(a,c);this.ctx.stroke()};this.clip=function(q,f,i){var d,c,n,k,g,m,q;var o,e,a,j;var p=[];if(i&&i.length==4){e=i[0];o=i[1];a=e+i[2];j=o+i[3]}else{e=this.marginLeft+this.offsetX+this.left;o=this.marginTop+this.offsetY+this.top;a=e+this.x;j=o+this.y}if(q=="rect"){d=parseInt(f[0]);n=parseInt(f[1]);c=parseInt(d+f[2]);k=parseInt(n+f[3]);if(d>a+this.outlineWidth||k>j+this.outlineWidth||c<e||n<o){return false}if(d<e){d=e}if(c>a){c=a}if(k<o){k=o}if(n>j){n=j}p=[d,n,c-d,k-n]}else{if(q=="poly"){}else{if(q=="circle"){d=parseInt(f[0]);n=parseInt(f[1]);if(d>a||d<e||n<o||n>j){return false}p=[d,n]}else{if(q=="line"){d=parseFloat(f[0]);n=parseFloat(f[1]);c=parseFloat(f[2]);k=parseFloat(f[3]);if(d==c){if(d<e||d>a){return false}else{if(n>k){if(n<o){return false}else{if(n>j){n=j}}if(k>j){return false}else{if(k<o){k=o}}}else{if(n>j){return false}else{if(n<o){n=o}}if(k<o){return false}else{if(k>j){k=j}}}}}else{if(n==k){if(n<o||n>j){return false}else{if(d>c){if(d<e){return false}else{if(d>a){d=a}}if(c>a){return false}else{if(c<e){c=e}}}else{if(d>a){return false}else{if(d<e){d=e}}if(c<e){return false}else{if(c>a){c=a}}}}}else{if(d>c){if(d<e||c>a){return false}else{if(n>k){if(n<o||k>j){return false}else{g=n-k;m=d-c;if(d>a){n-=(d-a)*g/m;d=a}if(n>j){d-=(n-j)*m/g;n=j}if(c<e){k+=(e-c)*g/m;c=e}if(k<o){c+=(o-k)*m/g;k=o}}}else{if(k<o||n>j){return false}else{g=k-n;m=d-c;if(d>a){n+=(d-a)*g/m;d=a}if(n<o){d-=(o-n)*m/g;n=o}if(c<e){k-=(e-c)*g/m;c=e}if(k>j){c+=(k-j)*m/g;k=j}}}}}else{if(c<e||d>a){return false}else{if(n>k){if(n<o||k>j){return false}else{g=n-k;m=c-d;if(d<e){n-=(e-d)*g/m;d=e}if(n>j){d+=(n-j)*m/g;n=j}if(c>a){k+=(c-a)*g/m;c=a}if(k<o){c-=(o-k)*m/g;k=o}}}else{if(k<o||n>j){return false}else{g=k-n;m=c-d;if(d<e){n+=(e-d)*g/m;d=e}if(n<o){d+=(o-n)*m/g;n=o}if(c>a){k-=(c-a)*g/m;c=a}if(k>j){c-=(k-j)*m/g;k=j}}}}}}}p=[d,n,c,k]}else{return false}}}}return p};this.lineLength=function(b,d,a,c){return Math.sqrt(Math.pow(a-b,2)+Math.pow(c-d,2))};this.shortenLine=function(b,j,a,i,k,f,l){if(this.validateNumbers([b,j,a,i,k,f])){if(l.match(/bezier/)){if(l.match(/beziery/i)){return i>j?[b,j+k,a,i-f]:[b,j-k,a,i+f]}else{return a>b?[b+k,j,a-f,i]:[b-k,j,a+f,i]}}else{if(l.match(/curved/)){return[b,j,a,i]}else{var c=Math.atan2(i-j,a-b);var d=Math.cos(c);var h=Math.sin(c);var g=this.lineLength(b,j,a,i);if(g){b+=d*k;j+=h*k;a-=d*f;i-=h*f}}}return[b,j,a,i]}};this.errorBar=function(e,g,d,f,a,h){if(!this.isGroupedData&&this.isRawData){return}if(this.showErrorBars&&this.validateNumbers([a])){var b=this.drawLine("line",e,g,d,f,h,false,false,false,false,true);if(a>0){this.drawLine("line",d,f-a/2,d,f+a/2,h,false,false,false,false,true)}else{this.drawLine("line",d-a/2,f,d+a/2,f,h,false,false,false,false,true)}return b}};this.splineControlPoint=function(e,m,d,l,c,k){var n=Math.sqrt(Math.pow(d-e,2)+Math.pow(l-m,2));var h=Math.sqrt(Math.pow(c-d,2)+Math.pow(k-l,2));var g=this.tension*n/(n+h);var f=this.tension-g;var b=d+g*(e-c);var a=l+g*(m-k);var j=d-f*(e-c);var i=l-f*(m-k);return[b,a,j,i]};this.drawLine=function(Y,E,a,B,aq,ak,X,ac,aa,am,an,ap){var R=this;var af;var L=[];var T=false;var u=false;var r=false;var S=function(){R.ctx.save();if(R.transparency!=null){if(ak){ak=R.validateColor(ak,R.transparency)||R.addColorTransparency(R.foreground,R.transparency)}else{ak=R.addColorTransparency(R.foreground,R.transparency)}}else{if(ak){ak=R.validateColor(ak)||R.foreground}else{ak=R.foreground}}R.ctx.fillStyle=ak;R.ctx.strokeStyle=ak;R.ctx.lineWidth=X?X:R.outlineWidth;R.ctx.lineCap=ac?ac:R.capType;if(R.showShadow){R.ctx.shadowOffsetX=R.shadowOffsetX;R.ctx.shadowOffsetY=R.shadowOffsetY;R.ctx.shadowBlur=R.shadowBlur;R.ctx.shadowColor=R.shadowColor}};var G=function(){if(R.showShadow){R.ctx.shadowOffsetX=0;R.ctx.shadowOffsetY=0;R.ctx.shadowBlur=0;R.ctx.shadowColor=R.background}R.ctx.restore()};var F=function(y){var w=function(aA,aD,ay,aE){var az=[];for(var aB=0;aB<aA.length;aB++){az.push([(aA[aB][0]*Math.cos(aD))-(aA[aB][1]*Math.sin(aD)),(aA[aB][0]*Math.sin(aD))+(aA[aB][1]*Math.cos(aD))])}var aC=[];for(var aB=0;aB<az.length;aB++){aC.push([az[aB][0]+ay,az[aB][1]+aE])}return aC};var t=R.arrowPointSize;var s=Math.max((t/2)-1,1);var n=y?[[0,-t],[0,t]]:[[Math.floor((t/2.5)),0],[-t,-s],[-t,s]];var ax=B-E;var av=aq-a;if(u){if(u=="Y"){if(Math.abs(av)>Math.abs(ax)){ax=0}else{ax=B>E?R.arrowPointSize:-R.arrowPointSize}}else{if(Math.abs(ax)>Math.abs(av)){av=0}else{av=aq>a?R.arrowPointSize:-R.arrowPointSize}}}else{if(r){var at=R.lineLength(E,a,B,aq);var f=R.shortenLine(E,a,B,aq,0,at/2,"line");var p=f[2];var b=f[3];var aw=at/2;var ar=r/aw;var au=B>E?Math.asin((b-a)/aw):Math.asin(-(b-a)/aw);var c=au-(Math.PI/20);if(B>E){E=p+aw*Math.cos(c-ar);a=b+aw*Math.sin(c-ar);B=p+aw*Math.cos(au-ar);aq=b+aw*Math.sin(au-ar)}else{E=p+aw*Math.cos((c-ar)+Math.PI);a=b+aw*Math.sin((c-ar)+Math.PI);B=p+aw*Math.cos((au-ar)+Math.PI);aq=b+aw*Math.sin((au-ar)+Math.PI)}ax=B-E;av=aq-a}}var e=w(n,Math.atan2(av,ax),B,aq);S();R.ctx.beginPath();R.ctx.moveTo(e[0][0],e[0][1]);for(var x=1;x<e.length;x++){if(!isNaN(e[x][0])&&!isNaN(e[x][1])){R.ctx.lineTo(e[x][0],e[x][1])}}if(!y){if(!isNaN(e[0][0])&&!isNaN(e[0][1])){R.ctx.lineTo(e[0][0],e[0][1])}R.ctx.closePath();R.ctx.fill()}else{R.ctx.closePath();R.ctx.stroke()}G()};if(Y=="spline"){if(E.length<3){return false}var Z=[];var ao=[];var ab=[];var ae=0;L=["poly"];for(var ai=0;ai<E.length;ai++){if(this.validateNumbers([E[ai],a[ai]])){ao.push(E[ai],a[ai]);L.push(E[ai],a[ai]-2);ab.push(a[ai]+2,E[ai]);ae+=2}else{return false}}L=L.concat(ab.reverse());S();for(var ai=0;ai<ae-4;ai+=2){Z=Z.concat(this.splineControlPoint(ao[ai],ao[ai+1],ao[ai+2],ao[ai+3],ao[ai+4],ao[ai+5]))}this.ctx.beginPath();this.ctx.moveTo(ao[0],ao[1]);this.ctx.quadraticCurveTo(Z[0],Z[1],ao[2],ao[3]);for(var ai=2;ai<ae-5;ai+=2){this.ctx.bezierCurveTo(Z[2*ai-2],Z[2*ai-1],Z[2*ai],Z[2*ai+1],ao[ai+2],ao[ai+3])}this.ctx.moveTo(ao[ae-2],ao[ae-1]);this.ctx.quadraticCurveTo(Z[2*ae-10],Z[2*ae-9],ao[ae-4],ao[ae-3]);this.ctx.stroke();G();return L}else{if(this.validateNumbers([E,a,B,aq])){if(!aa){aa=0}if(!am){am=0}if(Y.match(/bezier/i)){if(Y.match(/beziery/i)){af="bezierLine";u="Y";T="Y";if(aa||am){if(aq>a){if(a+aa>aq-am){Y=Y.replace(/beziery/i,"");af="line";u=false;T=false}}else{if(a-aa<aq+am){Y=Y.replace(/beziery/i,"");af="line";u=false;T=false}}}}else{af="bezierLine";u="X";T="X";if(aa||am){if(B>E){if(E+aa>B-am){Y=Y.replace(/bezier[x]?/i,"");af="line";u=false;T=false}}else{if(E-aa<B+am){Y=Y.replace(/bezier[x]?/i,"");af="line";u=false;T=false}}}}}else{if(Y.match(/curved/i)){if(Y.match(/curvedc/i)){af="curvedLine";r=true;T=true}else{af="curvedLine";r=true;T=false}}else{if(Y.match(/dashed/i)){af="dashedLine"}else{if(Y.match(/dotted/i)){af="dottedLine"}else{af="line"}}}}if(aa||am){var ad=this.shortenLine(E,a,B,aq,aa,am,Y);E=ad[0];a=ad[1];B=ad[2];aq=ad[3]}if(an){var J=this.clip("line",[E,a,B,aq],ap);if(J){E=J[0];a=J[1];B=J[2];aq=J[3]}else{return false}}switch(af){case"dashedLine":var k=Math.atan2(aq-a,B-E);var P=Math.cos(k);var H=Math.sin(k);var K=this.lineLength(E,a,B,aq);var ah=Math.floor(K/(this.dashLength*2));if(ah){var V=P*this.dashLength;var U=H*this.dashLength;var g=E;var al=a;var d=B;var aj=aq;d=g+V;aj=al+U;for(var ai=0;ai<ah;ai++){this.drawLine("line",g,al,d,aj,ak,X,ac);g+=(V*2);al+=(U*2);d=g+V;aj=al+U}this.drawLine("line",g,al,d,aj,ak,X,ac);L=["poly",E+2,a,B+2,aq,B-2,aq,E-2,a]}else{return false}break;case"dottedLine":var k=Math.atan2(aq-a,B-E);var P=Math.cos(k);var H=Math.sin(k);var K=this.lineLength(E,a,B,aq);var ah=Math.ceil(K/(this.dotLength*2));var Q=K/ah;if(ah){var V=P*Q;var U=H*Q;var g=E;var al=a;var d=B;var aj=aq;g+=V;al+=U;for(var ai=0;ai<ah-1;ai++){this.drawShape("circle",g,al,2,2,ak,ak,"closed");g+=V;al+=U}L=["poly",E+2,a,B+2,aq,B-2,aq,E-2,a]}else{return false}break;case"bezierLine":if(E==B||a==aq){return this.drawLine("line",E,a,B,aq,ak,X,ac,aa,am,an,ap)}E=parseInt(E)+0.5;a=parseInt(a)+0.5;B=parseInt(B)+0.5;aq=parseInt(aq)+0.5;T=T=="Y"?"Y":"X";var N=B>E?true:false;var m=(E+B)/2;var l=(a+aq)/2;if(N){if(T=="X"){L=["poly",E,a-2,m+2,a-2,m+2,aq-2,B,aq-2,B,aq+2,m-2,aq+2,m-2,a+2,E,a+2]}else{L=["poly",E-2,a,E-2,l+2,B-2,l+2,B-2,aq,B+2,aq,B+2,l-2,E+2,l-2,E+2,a]}}else{if(T=="X"){L=["poly",E,a-2,m-2,a-2,m-2,aq-2,B,aq-2,B,aq+2,m+2,aq+2,m+2,a+2,E,a+2]}else{L=["poly",E-2,a,E-2,l-2,B-2,l-2,B-2,aq,B+2,aq,B+2,l+2,E+2,l+2,E+2,a]}}S();this.ctx.moveTo(E,a);if(T=="Y"){this.ctx.bezierCurveTo(E,aq,B,a,B,aq)}else{this.ctx.bezierCurveTo(B,a,E,aq,B,aq)}this.ctx.stroke();G();break;case"curvedLine":var m=12;var q=1;var K=this.lineLength(E,a,B,aq);var D=this.shortenLine(E,a,B,aq,0,K/2,"line");var O=D[2];var C=D[3];var W=K/2;var M=aa/W;var I=am/W;var j=(O-E);var h=(C-a);var A=T&&E>B?false:!T&&B>=E?true:T;var o=B>=E?Math.asin(h/W):Math.asin(-h/W);var ag=o+Math.PI;var z=Math.PI/m;var v=B>=E?0:Math.PI;L=["poly"];for(var ai=q;ai<=m-q;ai++){L.push(O-(W+2)*Math.cos(o+((z*ai))-v));L.push(C-(W+2)*Math.sin(o+((z*ai))-v))}for(var ai=m-q;ai>=q;ai--){L.push(O-(W-2)*Math.cos(o+((z*ai))-v));L.push(C-(W-2)*Math.sin(o+((z*ai))-v))}S();this.ctx.beginPath();if(B>=E){this.ctx.arc(O,C,W,o-I,ag+M,A)}else{this.ctx.arc(O,C,W,o+M,ag-I,A)}this.ctx.stroke();G();break;case"line":L=["poly",E+2,a,B+2,aq,B-2,aq,E-2,a];S();this.ctx.beginPath();this.lineTo(E,a,B,aq);G();break}if(Y.match(/arrowheadsquaretail|squaretailarrowhead/i)){r=r?am:false;F(false,u,r);r=r?aa:false;F(true,u,r)}else{if(Y.match(/arrowtailsquarehead|squareheadarrowtail/i)){r=r?am:false;F(true,u,r);r=r?aa:false;F(false,u,r)}else{if(Y.match(/arrowhead/i)){r=r?am:false;F(false,u,r)}else{if(Y.match(/squarehead/i)){r=r?am:false;F(true,u,r)}else{if(Y.match(/arrowtail/i)){r=r?aa:false;F(false,u,r)}else{if(Y.match(/squaretail/i)){r=r?aa:false;F(true,u,r)}else{if(Y.match(/arrow/i)){r=r?am:false;F(false,u,r);r=r?aa:false;F(false,u,r)}else{if(Y.match(/square/i)){r=r?aa:false;F(true,u,r);r=r?am:false;F(true,u,r)}}}}}}}}return L}else{return false}}};this.rectangle=function(n,m,q,g,i,e,d,a,k,j,l){return this.drawShape("rectangle",n+(q/2),m+(g/2),q,g,i,e,d,a,k,j,l)};this.rectangleHM=function(n,m,q,g,i,e,d,a,k,j,l){return this.drawShape("rectangleHM",n+(q/2),m+(g/2),q,g,i,e,d,a,k,j,l)};this.drawShape=function(N,I,H,K,aa,ab,U,T,P,G,ah,aj,O,ae,M,ag,L){var F=this;var R=function(){F.ctx.save();F.ctx.translate(I,H);if(P){F.ctx.rotate(P)}if(F.transparency!=null){if(ab){ab=F.validateColor(ab,F.transparency)||F.addColorTransparency(F.foreground,F.transparency)}else{ab=F.addColorTransparency(F.foreground,F.transparency)}}else{if(ab){ab=F.validateColor(ab)||F.foreground}else{ab=F.foreground}}if(F.gradient){if(F.gradientType=="radial"){F.setGradient(0,0,Math.max(Math.abs(K),Math.abs(aa)),ab)}else{F.setGradient(0,0,K,aa,ab)}}else{F.ctx.fillStyle=ab}if(U){U=F.validateColor(U)||F.foreground}F.ctx.strokeStyle=U?U:F.foreground;F.ctx.lineWidth=G?G:F.outlineWidth;if(F.showShadow){F.ctx.shadowOffsetX=F.shadowOffsetX;F.ctx.shadowOffsetY=F.shadowOffsetY;F.ctx.shadowBlur=F.shadowBlur;F.ctx.shadowColor=F.shadowColor}};var am=function(f,d,o){if(N=="image"||L){}else{if(N=="rectangleHM"){if(f){f[0][0]=Math.round(f[0][0])+0.5;f[3][0]=f[0][0];f[1][0]=Math.round(f[1][0])+1.5;f[2][0]=f[1][0];f[0][1]=Math.round(f[0][1])+0.5;f[1][1]=f[0][1];f[2][1]=Math.round(f[2][1])+1.5;f[3][1]=f[2][1];F.ctx.beginPath();F.ctx.moveTo(f[0][0],f[0][1]);for(var e=1;e<f.length;e++){F.ctx.lineTo(f[e][0],f[e][1])}if(!d){F.ctx.closePath()}if(T&&T=="open"){F.ctx.stroke()}else{F.ctx.stroke();F.ctx.fill()}}}else{if(N=="spline"){var h=[];var c=[];var b=[];c.push(o.shift());c.push(o.shift());b.push(o.pop());b.unshift(o.pop());var p=o.length;for(var e=0;e<p-4;e+=2){h=h.concat(F.splineControlPoint(o[e],o[e+1],o[e+2],o[e+3],o[e+4],o[e+5]))}F.ctx.beginPath();F.ctx.moveTo(c[0],c[1]);F.ctx.lineTo(o[0],o[1]);F.ctx.quadraticCurveTo(h[0],h[1],o[2],o[3]);for(var e=2;e<p-5;e+=2){F.ctx.bezierCurveTo(h[2*e-2],h[2*e-1],h[2*e],h[2*e+1],o[e+2],o[e+3])}F.ctx.quadraticCurveTo(h[2*p-10],h[2*p-9],o[p-2],o[p-1]);F.ctx.lineTo(b[0],b[1]);F.ctx.lineTo(c[0],c[1]);if(T&&T=="open"){F.ctx.stroke()}else{F.ctx.stroke();F.ctx.fill()}}else{if(f){F.ctx.beginPath();F.ctx.moveTo(f[0][0]+0.5,f[0][1]+0.5);for(var e=1;e<f.length;e++){F.ctx.lineTo(f[e][0]+0.5,f[e][1]+0.5)}if(!d){F.ctx.closePath()}}if(T&&T=="open"){F.ctx.stroke()}else{F.ctx.stroke();F.ctx.fill()}}}}if(F.showShadow){F.ctx.shadowOffsetX=0;F.ctx.shadowOffsetY=0;F.ctx.shadowBlur=0;F.ctx.shadowColor=F.background}F.ctx.restore()};var ac=function(p){if(p){if(p[0]=="circle"){return p}var e=p.shift();var i=[];if(e=="rect"){var o=p.shift()-I;var r=p.shift()-H;var d=p.shift()-I;var f=p.shift()-H;i.push((r*Math.sin(P))-(o*Math.cos(P)));i.push((r*Math.cos(P))+(o*Math.sin(P)));i.push((f*Math.sin(P))-(o*Math.cos(P)));i.push((f*Math.cos(P))+(o*Math.sin(P)));i.push((f*Math.sin(P))-(d*Math.cos(P)));i.push((f*Math.cos(P))+(d*Math.sin(P)));i.push((r*Math.sin(P))-(d*Math.cos(P)));i.push((r*Math.cos(P))+(d*Math.sin(P)))}else{while(p.length>1){var h=p.shift()-I;var b=p.shift()-H;i.push((b*Math.sin(P))-(h*Math.cos(P)));i.push((b*Math.cos(P))+(h*Math.sin(P)))}}var c=["poly"];while(i.length>1){c.push(i.shift()+I);c.push(i.shift()+H)}return c}};var D,E;if(N=="polygon"||N=="path"||N=="spline"){var X=Number.MAX_VALUE;var B=Number.MIN_VALUE;var W=Number.MAX_VALUE;var A=Number.MIN_VALUE;var C=N=="polygon"?false:true;var S=[];var ai=[];D=[];E=["poly"];if(I.length==H.length){if(N=="spline"&&I.length<5){return false}for(var Z=0;Z<I.length;Z++){if(this.validateNumbers([I[Z],H[Z]])){X=Math.min(X,I[Z]);B=Math.max(B,I[Z]);W=Math.min(W,H[Z]);A=Math.max(A,H[Z]);D.push([I[Z],H[Z]]);if(N=="spline"){E.push(I[Z],H[Z]-2);S.push(H[Z]+2,I[Z])}else{E.push(I[Z],H[Z])}}else{return false}}I=(X+B)/2;H=(W+A)/2;for(var Z=0;Z<D.length;Z++){D[Z][0]-=I;D[Z][1]-=H;ai.push(D[Z][0],D[Z][1])}if(P){E=ac(E)}if(D){if(N=="spline"){E=E.concat(S.reverse())}R(C);am(D,C,ai);return E}else{return false}}else{return false}}else{if(this.validateNumbers([I,H,K,aa])){if(ah){D=N.match(/rectangle/)?this.clip("rect",[I-(K/2),H-(aa/2),K,aa],aj):this.clip("circle",[I,H],aj);if(D){if(N.match(/rectangle/)){K=D[2];aa=D[3];I=D[0]+(K/2);H=D[1]+(aa/2)}else{I=D[0];H=D[1]}}else{return false}}var j=K/2;var ak=aa/2;var Q=aa/K;var V=1.5;var E=["rect",I-j,H-ak,I+j,H+ak];switch(N){case"image":D=false;this.ctx.save();this.ctx.translate(I,H);if(P){this.ctx.rotate(P)}this.ctx.drawImage(CanvasXpress.cacheImages[M],-j*this.zoom,-ak*this.zoom,K*this.zoom,aa*this.zoom);E=["rect",I-(j*this.zoom),H-(ak*this.zoom),I+(j*this.zoom),H+(ak*this.zoom)];this.ctx.restore();break;case"circle":case"sphere":E=["circle",I,H,K/2];D=false;R();if(!L){this.ctx.beginPath();this.ctx.arc(0,0,K/2,0,Math.PI*2,true);this.ctx.closePath()}am();break;case"box":case"rect":case"rectangle":case"rectangleHM":D=[[-j,-ak],[j,-ak],[j,ak],[-j,ak]];break;case"rect2":return this.drawShape("rectangle",I,H,K,K/2,ab,U,T,P,G,ah,aj,O,ae,M,ag,L);break;case"rect3":return this.drawShape("rectangle",I,H,K,K/3,ab,U,T,P,G,ah,aj,O,ae,M,ag,L);break;case"roundrect":var J=K>aa?aa/4:K/4;D=false;R();if(!L){this.ctx.beginPath();ctx.moveTo(-j,-ak+J);ctx.lineTo(-j,ak-J);ctx.quadraticCurveTo(-j,ak,-j+J,ak);ctx.lineTo(j-J,ak);ctx.quadraticCurveTo(j,ak,j,ak-J);ctx.lineTo(j,-ak+J);ctx.quadraticCurveTo(j,-ak,j-J,-ak);ctx.lineTo(-j+J,-ak);ctx.quadraticCurveTo(-j,-ak,-j,-ak+J);this.ctx.closePath()}am();break;case"square":D=[[-j,-j],[j,-j],[j,j],[-j,j]];break;case"triangle":if(K==aa){return this.drawShape("equilateral",I,H,K,aa,ab,U,T,P,G,ah,aj,O,ae,M,ag,L)}E=["poly",I,H-ak,I+j,H+ak,I-j,H+ak];D=[[0,-ak],[j,ak],[-j,ak]];break;case"equilateral":var J=K*Math.sqrt(3)/6;var g=J/2;var n=Math.sqrt((J*J)-(g*g));E=["poly",I,H-J,I+n,H+g,I-n,H+g];D=[[0,-ak],[j,ak],[-j,ak]];break;case"diamond":case"rhombus":E=["poly",I,H-ak,I+j,H,I,H+ak,I-j,H];D=[[0,-ak],[j,0],[0,ak],[-j,0]];break;case"hexagon":var af=K/3;var l=af-j;D=[[l,-ak],[-l,-ak],[j,0],[-l,ak],[l,ak],[-j,0]];break;case"octagon":var al=K/4;var Y=aa/4;D=[[-al,-ak],[al,-ak],[j,-Y],[j,Y],[al,ak],[-al,ak],[-j,Y],[-j,-Y]];break;case"oval":D=false;R();if(!L){this.ctx.scale(1,Q);this.ctx.beginPath();this.ctx.arc(0,0,K/2,0,Math.PI*2,true);this.ctx.closePath()}am();break;case"oval2":return this.drawShape("oval",I,H,K,K/2,ab,U,T,P,G,ah,aj,O,ae,M,ag,L);break;case"oval3":return this.drawShape("oval",I,H,K,K/3,ab,U,T,P,G,ah,aj,O,ae,M,ag,L);break;case"ellipse":var a=j*0.5522848;var ad=ak*0.5522848;D=false;R();if(!L){this.ctx.beginPath();this.ctx.moveTo(0,ak);this.ctx.bezierCurveTo(0,ak-ad,j-a,0,j,0);this.ctx.bezierCurveTo(j+a,0,K,ak-ad,K,ak);this.ctx.bezierCurveTo(K,ak+ad,j+a,aa,j,aa);this.ctx.bezierCurveTo(j-a,aa,0,ak+ad,0,ak);this.ctx.closePath()}am();break;case"ellipse2":return this.drawShape("ellipse",I,H,K,K/2,ab,U,T,P,G,ah,aj,O,ae,M,ag,L);break;case"ellipse3":return this.drawShape("ellipse",I,H,K,K/3,ab,U,T,P,G,ah,aj,O,ae,M,ag,L);break;case"plus":D=[[-V,-ak],[V,-ak],[V,-V],[j,-V],[j,V],[V,V],[V,ak],[-V,ak],[-V,V],[-j,V],[-j,-V],[-V,-V],[-V,-ak]];break;case"minus":D=[[-j,-V],[j,-V],[j,V],[-j,V],[-j,-V]];break;case"mdavid":var af=K/3;var m=Math.PI/6;E=["circle",I,H,K/2];D=false;R();if(!L){this.ctx.beginPath();this.ctx.moveTo(af,0);for(var Z=0;Z<11;Z++){this.ctx.rotate(m);if(Z%2==0){this.ctx.lineTo((af/0.55),0)}else{this.ctx.lineTo(af,0)}}this.ctx.closePath()}am();break;case"star":var k=K/4;var q=Math.PI/5;E=["circle",I,H,K/2];D=false;R();if(!L){this.ctx.rotate(q*0.45);this.ctx.beginPath();this.ctx.moveTo(k,0);for(var Z=0;Z<9;Z++){this.ctx.rotate(q);if(Z%2==0){this.ctx.lineTo((k/0.35),0)}else{this.ctx.lineTo(k,0)}}this.ctx.closePath()}am();break;case"pie":if(typeof(O)=="undefined"){O=0}if(typeof(ae)=="undefined"){ae=Math.PI*2}D=false;R();if(!L){this.ctx.scale(1,Q);this.ctx.beginPath();this.ctx.arc(0,0,K/2,O,ae,false);this.ctx.closePath()}am();break;case"pie0":return this.drawShape("pie",I,H,K,K/2,ab,U,T,P,G,ah,aj,0,Math.PI/5,M,ag,L);break;case"pie1":return this.drawShape("pie",I,H,K,K/2,ab,U,T,P,G,ah,aj,0,Math.PI/3.5,M,ag,L);break;case"pie2":return this.drawShape("pie",I,H,K,K/2,ab,U,T,P,G,ah,aj,0,Math.PI/2,M,ag,L);break;case"pie3":return this.drawShape("pie",I,H,K,K/2,ab,U,T,P,G,ah,aj,0,Math.PI/1.5,M,ag,L);break;case"pie4":return this.drawShape("pie",I,H,K,K/2,ab,U,T,P,G,ah,aj,0,Math.PI,M,ag,L);break;case"pie5":return this.drawShape("pie",I,H,K,K/2,ab,U,T,P,G,ah,aj,0,Math.PI*1.2,M,ag,L);break;case"pie6":return this.drawShape("pie",I,H,K,K/2,ab,U,T,P,G,ah,aj,0,Math.PI*1.4,M,ag,L);break;case"pie7":return this.drawShape("pie",I,H,K,K/2,ab,U,T,P,G,ah,aj,0,Math.PI*1.6,M,ag,L);break;case"pie8":return this.drawShape("pie",I,H,K,K/2,ab,U,T,P,G,ah,aj,0,Math.PI*1.8,M,ag,L);break;case"pie9":return this.drawShape("pie",I,H,K,K/2,ab,U,T,P,G,ah,aj,0,Math.PI*2,M,ag,L);break;case"pacman":return this.drawShape("pie",I,H,K,K/2,ab,U,T,P,G,ah,aj,Math.PI*5/4,Math.PI*3/4,M,ag,L);break}if(P){E=ac(E)}if(D){R();am(D)}return E}else{return false}}};this.setRGB=function(){this.reds=[];this.greens=[];this.blues=[];this.yellows=[];this.cyans=[];this.purples=[];this.indicatorBins=this.allVsAll?Math.min(this.x,this.y)/(this.layoutRows*2):Math.min(this.x,this.y)/4;this.indicatorBins=this.indicatorBins>512?1:this.indicatorBins>256?2:this.indicatorBins>128?4:8;var e=this.indicatorBins;var c=parseInt(256/e);var d;var b;if(this.indicatorCenter=="rainbow-green"){d=e-1;b=255;for(var a=0;a<c;a++){this.greens.push("rgb(0,255,"+d+")");this.cyans.push("rgb(0,"+b+",255)");this.blues.push("rgb("+d+",0,255)");this.purples.push("rgb(255,0,"+b+")");this.reds.push("rgb(255,"+d+",0)");this.yellows.push("rgb("+b+",255,0)");d+=e;b-=e}}else{if(this.indicatorCenter.match("rainbow")){d=e-1;b=255;for(var a=0;a<c;a++){this.reds.push("rgb(255,0,"+d+")");this.purples.push("rgb("+b+",0,255)");this.blues.push("rgb(0,"+d+",255)");this.cyans.push("rgb(0,255,"+b+")");this.greens.push("rgb("+d+",255,0)");this.yellows.push("rgb(255,"+b+",0)");d+=e;b-=e}}else{if(this.indicatorCenter=="black"){d=255;for(var a=0;a<c;a++){this.reds.push("rgb("+d+",0,0)");this.purples.push("rgb("+d+",0,"+d+")");this.blues.push("rgb(0,0,"+d+")");this.cyans.push("rgb(0,"+d+","+d+")");this.greens.push("rgb(0,"+d+",0)");this.yellows.push("rgb("+d+","+d+",0)");d-=e}}else{this.reds.push("rgb(255,0,0)");this.purples.push("rgb(255,0,255)");this.blues.push("rgb(0,0,255)");this.cyans.push("rgb(0,255,255)");this.greens.push("rgb(0,255,0)");this.yellows.push("rgb(255,255,0)");d=e-1;for(var a=0;a<c-1;a++){this.reds.push("rgb(255,"+d+","+d+")");this.purples.push("rgb(255,"+d+",255)");this.blues.push("rgb("+d+","+d+",255)");this.cyans.push("rgb("+d+",255,255)");this.greens.push("rgb("+d+",255,"+d+")");this.yellows.push("rgb(255,255,"+d+")");d+=e}}}}};this.setLineTypes=function(){this.lines=this.getLineTypes()};this.initializeAttributes=function(){this.setLineTypes();this.setRGB()};this.initializeAttributes()};CanvasXpress.prototype.initLayout=function(){this.isValidLayout=function(){var a=this.layout.split(/X/i);if(a.length==2){this.layoutRows=a[0];this.layoutCols=a[1]}else{this.layoutRows=1;this.layoutCols=1;this.layoutValid=false}if(!this.graphType.match(/Scatter/)&&this.layoutComb&&this.data.l&&(this.data.l.vars||this.data.l.smps)&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];if(this.data.l.vars&&this.data.l.smps){var f=0;for(var d=0;d<this.data.l.smps.length;d++){for(var b=0;b<this.data.l.vars.length;b++){this.data.l.comp[f]=[this.getVariableIndices(this.data.l.vars[b]),this.getSampleIndices(this.data.l.smps[d])];f++}}this.layoutRows=this.data.l.smps.length;this.layoutCols=this.data.l.vars.length}else{if(this.data.l.vars){for(var d=0;d<this.data.l.vars.length;d++){this.data.l.comp[d]=this.getVariableIndices(this.data.l.vars[d])}}else{for(var d=0;d<this.data.l.smps.length;d++){this.data.l.comp[d]=this.getSampleIndices(this.data.l.smps[d])}}if(this.graphType!="Pie"){if(this.graphOrientation=="vertical"){this.layoutRows=this.data.l.comp.length}else{this.layoutCols=this.data.l.comp.length}}}this.layoutValid=true;this.layoutAdjust=true}else{if(this.layoutComb&&this.data.l&&this.data.l.smps&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];var e=this.getVariableIndices(this.data.y.vars);for(var d=0;d<this.data.l.type.length;d++){this.data.l.comp[d]=e}this.layoutValid=true}else{if(this.data.l&&this.data.l.comp){if(this.data.l.comp.length<=(this.layoutRows*this.layoutCols)){this.layoutValid=true}else{this.layoutValid=false}}else{this.layoutValid=false}}}};this.setLayout=function(a){};this.addLayoutResizer=function(b){var a=0;if(this.resizerType&&this.resizerPosition==b){a+=this.resizerWidth+(this.margin*2);if(this.resizerType=="samples"){a+=14+this.margin}}return a};this.getLayoutResizerDimensions=function(){if(this.resizerType){var u,j,e,d;var f=this.data.l.comp.length-1;var k=this.resizerWidth;var z=this.resizerWidth;var B=this.marginTop+this.layoutTop;var c=this.marginRight+this.layoutRight;var q=this.marginBottom+this.layoutBottom;var g=this.marginLeft+this.layoutLeft;var A=this.getAxesVals(0);var s=0;var m=0;switch(this.resizerPosition){case"right":u="xAxis";j="y";e="v";d="r";B+=this["subGraphTop"+0];g=this.resizerType=="samples"?this.width-((this.margin*2)+this.resizerWidth+14):this.width-(this.margin+this.resizerWidth);k=this.height-(B+q+this["subGraphBottom"+f]);break;case"left":u="xAxis";j="y";e="v";d="l";B+=this["subGraphTop"+0];g=this.resizerType=="samples"&&this.graphOrientation=="horizontal"?(this.margin*2):this.margin;k=this.height-(B+q+this["subGraphBottom"+f]);break;case"top":u="xAxis";j="x";e="h";d="t";B=this.resizerType=="samples"?(this.margin*2)+14:this.margin;g+=this["subGraphLeft"+0];z=this.width-(g+c+this["subGraphRight"+f]);m+=this.resizerWidth;break;case"bottom":u="xAxis";j="x";e="h";d="b";B=this.resizerType=="samples"&&this.graphOrientation=="vertical"?this.height-((this.margin*2)+this.resizerWidth+14):this.width-(this.margin+this.resizerWidth);g+=this["subGraphLeft"+0];z=this.width-(g+c+this["subGraphRight"+f]);m+=this.resizerWidth;break}if(e=="v"){return([u,g+s,g+s+z,B+m,B+m+k,j,e,d,A,g+14,B,z,k])}else{return([u,g+s,g+s+z,B+m,B+m+k,j,e,d,A,g,B,z,k])}}};this.drawLayoutResizer=function(){if(this.resizerType){var a=this.getLayoutResizerDimensions();this.showAxesResizer(a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],"",0,0,0);this.drawAxesResizerBackgroundData(a[9],a[10],a[11],a[12]);this.drawAxesResizerMasks()}};this.getLayoutMaxLegend=function(){if(this.data.l.vars){var a=0;if(this.data.l.comp){for(var b=0;b<this.data.l.comp.length;b++){a=Math.max(a,this.data.l.comp[b].length)}}return a}else{return this.varIndices.length}};this.setLayoutLeft=function(){var a=0;if(this.graphOrientation!="vertical"&&this.segregateSamplesBy&&this.segregateVariablesBy){this.set1DVarSmpLabelFont();a=this.fontSize+(this.margin*4)+this.measureText(this.maxSmpNameStr,this.smpLabelFont)+this.getSmpOverlaysLength()}else{if(this.graphOrientation!="vertical"&&this.segregateVariablesBy){this.set1DVarSmpLabelFont();a=(this.margin*2)+this.measureText(this.maxSmpNameStr,this.smpLabelFont)+this.getSmpOverlaysLength()}else{if((this.segregateSamplesBy||this.segregateVariablesBy)&&this.graphOrientation=="vertical"){a=this.fontSize+(this.margin*2)}else{if(this.graphType=="Candlestick"&&this.graphOrientation!="vertical"){this.setTimeAxis();this.set1DVarSmpLabelFont();a=this.getSampleLabelLength()+this.getSmpOverlaysLength()}else{if(this.graphType=="Pie"){a=(this.margin*2)+this.measureText("XX",this.smpLabelFont)}}}}}return a+this.addLayoutResizer("left")};this.setLayoutRight=function(){var a=0;if(this.graphType=="Pie"&&this.showLegend){var b=this.getPieLegendDimensions();a=b[0]}else{if(this.graphType.match(/Scatter/)&&(this.showLegend||this.showIndicators)){if(this.xAxis&&this.yAxis){this.setDataColorShapeSize()}this.setLegendDimensions();a=this.legendWidth}}return a+this.addLayoutResizer("right")};this.setLayoutTop=function(){var a=0;if(((this.segregateSamplesBy||this.segregateVariablesBy)&&this.graphOrientation!="vertical")||(this.segregateSamplesBy&&this.segregateVariablesBy)||(this.graphType=="Pie")){a=this.fontSize+(this.margin*2)}return a+this.addLayoutResizer("top")};this.setLayoutBottom=function(){var a=0;if(this.segregateSamplesBy&&this.segregateVariablesBy){a=this.getLegendHeight()}else{if(this.segregateVariablesBy&&this.graphOrientation=="vertical"){this.set1DVarSmpLabelFont();a=(this.margin*2)+this.measureText(this.maxSmpNameStr,this.smpLabelFont)+this.getSmpOverlaysLength()}else{if(this.graphType=="Candlestick"&&this.graphOrientation=="vertical"){this.setTimeAxis();this.set1DVarSmpLabelFont();a=this.getSampleLabelLength()+this.getSmpOverlaysLength()}else{if(this.graphType.match(/Scatter/)&&(this.showLegend||this.showIndicators)){if(this.xAxis&&this.yAxis){this.setDataColorShapeSize()}this.setLegendDimensions();a=this.legendHeight}}}}return a+this.addLayoutResizer("bottom")};this.drawLayoutSampleOverlays=function(b){var a=this.smpIndices;this.smpIndices=b;this.set1DVarSmpLabelFont();this.smpIndices=a;this.showSampleNames=true;this.showOverlays=true;this.draw1DYLayout()};this.drawLayoutVariableLegend=function(){this.showLegend=true;if(this.graphType=="Pie"){this.drawPieLegend()}else{this.draw1DLegend()}this.showLegend=false};this.setLayoutDimensions=function(){this.offsetX=0;this.offsetY=0;this.layoutLeft=this.setLayoutLeft();this.layoutRight=this.setLayoutRight();this.layoutTop=this.setLayoutTop();this.layoutBottom=this.setLayoutBottom()};this.drawLabelsLayout=function(){var q=0;var p=0;var o=0;var f=0;var k=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var d=this.height-(this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom);if(this.resizerType){if(this.resizerPosition=="top"){p=this.resizerType=="samples"?(this.margin*2)+this.resizerWidth+14:this.margin+this.resizerWidth;f=p}else{if(this.resizerPosition=="left"){q=this.resizerType=="samples"?(this.margin*2)+this.resizerWidth+14:this.margin+this.resizerWidth;o=q}}}if(this.segregateSamplesBy&&this.segregateVariablesBy){p+=this.fontSize+(this.margin*4);q=this.marginLeft+this.layoutLeft;for(var s=0;s<this.data.l.vars.length;s++){var l=s*this.data.l.smps.length;var r=k*this["subGraphWeight"+l][0];q+=(r/2);this.drawText(this.data.l.name[l][0],q,p,this.font,this.foreground,"center","middle");q+=(r/2)}q=o+this.fontSize+(this.margin*4);p=this.marginTop+this.layoutTop;for(var l=0;l<this.data.l.smps.length;l++){var m=d*this["subGraphWeight"+l][1];p+=(m/2);this.drawText(this.data.l.name[l][1],q,p,this.font,this.foreground,"center","middle",-Math.PI/2);p+=(m/2)}}else{if((this.segregateSamplesBy||this.segregateVariablesBy)&&this.graphOrientation=="vertical"&&this.data.l.name){q+=this.fontSize+(this.margin*4);p+=this.marginTop+this.layoutTop;for(var l=0;l<this.data.l.name.length;l++){var m=d*this["subGraphWeight"+l];p+=(m/2);this.drawText(this.data.l.name[l],q,p,this.font,this.foreground,"center","middle",-Math.PI/2);p+=(m/2)}}else{if((this.segregateSamplesBy||this.segregateVariablesBy)&&this.graphOrientation=="horizontal"&&this.data.l.name){p+=this.fontSize+(this.margin*4);q+=this.marginLeft+this.layoutLeft;for(var l=0;l<this.data.l.name.length;l++){var r=k*this["subGraphWeight"+l];q+=(r/2);this.drawText(this.data.l.name[l],q,p,this.font,this.foreground,"center","middle");q+=(r/2)}}else{if(this.graphType=="Pie"&&(this.showPieGrid||this.showPieSampleLabel)){var m,r;var n=0;var t=this.getFontPt(this.font);var b=this.marginTop+this.layoutTop;var e=this.marginLeft+this.layoutLeft;var a=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];for(var l=0;l<this.layoutRows;l++){m=d*this["subGraphWeight"+n][1];q=(this.marginLeft+this.layoutLeft)-this.margin;b+=m;if(this.showPieGrid){this.drawText(a[l],q,(b+(t/2))-(m/2),this.font,this.foreground,"right","middle")}for(var g=0;g<this.layoutCols;g++){if(this.xAxis.length<=n){break}r=k*this["subGraphWeight"+n][0];e+=r;p=(this.marginTop+this.layoutTop)-this.margin;if(l==0){if(this.showPieGrid){this.drawText(g+1,(e+(t/2))-(r/2),p,this.font,this.foreground,"center","bottom")}}if(this.showPieSampleLabel){this.drawText(this.xAxis[n],e-(r/1.1),b-(m/5),this.legendFont,this.foreground,"center","middle")}n++}e=this.marginLeft+this.layoutLeft}}}}}};this.setLayoutGraphAttributes=function(){var g=0;for(var d=0;d<this.layoutRows;d++){for(var b=0;b<this.layoutCols;b++){var e="subGraphType"+g;if(!this[e]){if(this.data.l.type&&this.data.l.type[g]){this[e]=this.data.l.type[g]}else{this[e]=this.graphType}}var f="subSummaryType"+g;if(this[e]=="Boxplot"||this.summaryType=="iqr"){this[f]="iqr"}else{if(this.summaryType=="median"){this[f]="median"}else{if(this.summaryType=="sum"){this[f]="sum"}else{if(this[e]=="Correlation"){this[f]="cor"}else{if(this[e]=="Candlestick"){if((this.graphOrientation=="vertical"&&d>0)||(this.graphOrientation=="horizontal"&&b==0)){this[f]="volume"}else{this[f]="candle"}}else{this[f]="mean"}}}}}var a="subTransformType"+g;if(!this[a]){if(this.data.l.transform&&this.data.l.transform[g]){this[a]=this.data.l.transform[g]}else{this[a]=this.subTransformType}}g++}}};this.setLayoutWeights=function(){if(this.data.l.weight){var d=0;var e=0;var a;var b;if(this.allVsAll){for(var c=0;c<this.layoutRows;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];d+=b}for(var c=0;c<this.data.l.weight.length;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];this.data.l.weight[c]=b/d;this[a]=this.data.l.weight[c]}}else{if(this.data.l.vars&&this.data.l.smps){for(var c=0;c<this.data.l.weight.length;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];d+=b[0];e+=b[1]}for(var c=0;c<this.data.l.weight.length;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];this.data.l.weight[c][0]=b[0]/d*this.data.l.smps.length;this.data.l.weight[c][1]=b[1]/e*this.data.l.vars.length;this[a]=this.data.l.weight[c]}}else{if(this.graphType=="Pie"){for(var c=0;c<this.data.l.comp.length;c++){a="subGraphWeight"+c;this[a]=this.data.l.weight[c]}}else{for(var c=0;c<this.data.l.weight.length;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];d+=b}for(var c=0;c<this.data.l.weight.length;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];this.data.l.weight[c]=b/d;this[a]=this.data.l.weight[c]}}}}}else{if(this.data.l.comp){this.data.l.weight=[];for(var c=0;c<this.data.l.comp.length;c++){a="subGraphWeight"+c;this.data.l.weight[c]=this.data.l.comp.length;this[a]=this.data.l.weight[c]}}else{alert("Wuz going on dude? This aint't gonna work!")}}};this.setMinimumLayoutAxisFonts=function(){var h=0;var e=Number.MAX_VALUE;for(var d=0;d<this.layoutRows;d++){for(var b=0;b<this.layoutCols;b++){var g,f,a;if(this.data.l.desc&&this.data.l.desc[h]){g=this.data.l.desc[h]}else{g="NA"}a=this.graphOrientation=="vertical"?this.height*this["subGraphWeight"+h]:this.width*this["subGraphWeight"+h];this.setAxisFont(g,a);f=this.getFontPt(this.axisTitleFont);if(f<e){e=f;this.minLayoutAxis=e;this.minLayoutAxisTitle=g}h++}}};this.getLayoutSummaryTypes=function(){var g=0;var a={};var e=[];for(var d=0;d<this.layoutRows;d++){for(var b=0;b<this.layoutCols;b++){var f="subSummaryType"+g;if(!a.hasOwnProperty(this[f])){e.push(this[f]);a[this[f]]=true}g++}}return e};this.validateLayoutSummaryGrouping=function(){if(this.isGroupedData){var b=this.getLayoutSummaryTypes();for(var a=0;a<b.length;a++){if(!this.isValidPlotData(b[a])){this.groupSamples(this.groupingFactors,b);break}}}};this.resetLayout=function(){delete (this.data.l);delete (this.layoutParams);this.offsetX=0;this.offsetY=0;this.layoutValidN=false;this.layoutValidR=false;this.layoutValidC=false;this.layoutComb=false;this.layout="1X1"};this.drawLayoutCompartments=function(g){var a=[];var z=0;var s=0;var x=this.varIndices;var u=this.smpIndices;var r=this.showSampleNames;var o=this.showOverlays;var h=this.showLegend;var w=this.showIndicators;var d=this.getObjectArray(x);var f=this.getObjectArray(u);var C=false;var B=["left","right","top","bottom","x","y","width","height","weight","offsetX","offsetY","varIndices","smpIndices","grpIndices","graphType","summaryType","transformType","varIndicesStart","smpIndicesStart","minData","maxData","xAxisMin","xAxisMax","xAxis2Min","xAxis2Max","yAxisMin","yAxisMax","zAxisMin","zAxisMax","xAxisAbsMin","xAxisAbsMax","xAxis2AbsMin","xAxis2AbsMax","yAxisAbsMin","yAxisAbsMax","zAxisAbsMin","zAxisAbsMax","xAxisUnit","xAxis2Unit","yAxisUnit","zAxisUnit","setMin","setMax","setMin2","setMax2","setMinX","setMaxX","setMinY","setMaxY","setMinZ","setMaxZ"];var n=["graphType","transformType","varIndicesStart","smpIndicesStart","setMin","setMax","setMin2","setMax2","setMinX","setMaxX","setMinY","setMaxY","setMinZ","setMaxZ"];var q;if(this.layoutComb){if(!this.graphType.match(/Scatter/)){this.layoutMaxVarLegend=this.getLayoutMaxLegend()}if(this.graphType.match(/Scatter/)){this.xAxis=this.data.y.smps;this.yAxis=this.data.y.smps;this.initAxes(true)}else{this.initAxes(false,true)}this.setLayoutDimensions();var D=this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight;var e=this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom;if(this.graphType.match(/Scatter/)){this.draw2DLegend()}if(this.layoutParams&&this.layoutValidN>-1){q=this.layoutParams;if(q[this.layoutValidN]){for(var y=0;y<B.length;y++){q[this.layoutValidN][B[y]]=this[B[y]]}}}this.offsetX=this.layoutLeft;this.offsetY=this.layoutTop;this.layoutMaxVarLegendLabel=this.data.l.vars?this.maxVarNameStr:this.maxSmpNameStr;this.layoutParams=[];if(!this.graphType.match(/Scatter/)){if(this.data.l.vars&&this.data.l.smps){this.layoutRows=this.data.l.smps.length;this.layoutCols=this.data.l.vars.length;this.layoutMaxSamples=this.smpIndices.length*this.layoutCols/this.layoutRows;this.legendPosition="bottom"}else{z=Math.max(this.layoutRows,this.layoutCols);if(this.graphType!="Pie"){if(this.graphOrientation=="vertical"){this.layoutRows=z;this.layoutCols=1;this.legendPosition="right"}else{this.layoutRows=1;this.layoutCols=z;this.legendPosition="bottom"}}}}this.setLayoutWeights();this.setMinimumLayoutAxisFonts();this.setLayoutGraphAttributes();this.validateLayoutSummaryGrouping();var A=0;for(var y=0;y<this.layoutRows;y++){for(var v=0;v<this.layoutCols;v++){this.layoutCurrent=A;if(this.graphType=="Pie"){if(this.data.l.smps.length<=A){break}}if(q){for(var t=0;t<n.length;t++){this[n[t]]=q[A][n[t]]}}this.weight=this["subGraphWeight"+A];this.graphType=this["subGraphType"+A];this.summaryType=this["subSummaryType"+A];this.transformType=this["subTransformType"+A];if(this["subTransformType"+A]){this.isTransformedData=true}if(this.data.l.log&&this.data.l.log[A]){this.isLogData=this.data.l.log[A]}if(this.graphType.match(/Scatter/)){if(this.data.l.smps[A].xAxis&&this.data.l.smps[A].yAxis){this.xAxis=this.data.l.smps[A].xAxis;this.yAxis=this.data.l.smps[A].yAxis;this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis)}else{this.xAxis=false;this.yAxis=false;this.xAxisIndices=false;this.yAxisIndices=false}this.layoutWidth=(this.width-D)*this["subGraphWeight"+A];this.layoutHeight=(this.height-e)*this["subGraphWeight"+A];this.varIndices=this.data.l.comp[A];if(this.graphType.match(/Scatter/)&&this.layoutAdjust&&this.xAxis&&this.yAxis){this.initAxes(true);this.layoutAxis=3}else{if(this.graphType.match(/Scatter/)){this.layoutAxis=v==0?2:0;this.layoutAxis=y==this.layoutRows&&this.layoutAxis?3:y==this.layoutRows?1:0}}this.showLegend=false;this.showIndicators=false}else{if(this.data.l.vars&&this.data.l.smps){C=this.graphOrientation=="vertical"?true:false;this.showLegend=false}else{if(this.graphType=="Pie"){C=false;this.showLegend=false}else{C=this.data.l.smps?true:false}}this.showSampleNames=C;this.showOverlays=C;this.xAxisTitle=this.data.l.desc&&this.data.l.desc[A]?this.data.l.desc[A]:false;if(this.data.l.vars&&this.data.l.smps){this.layoutHeight=(this.height-e)*this["subGraphWeight"+A][1];this.layoutWidth=(this.width-D)*this["subGraphWeight"+A][0];a=[];for(var t=0;t<this.data.l.comp[A][0].length;t++){if(d.hasOwnProperty(this.data.l.comp[A][0][t])){a.push(this.data.l.comp[A][0][t])}}this.varIndices=a;a=[];for(var t=0;t<this.data.l.comp[A][1].length;t++){if(f.hasOwnProperty(this.data.l.comp[A][1][t])){a.push(this.data.l.comp[A][1][t])}}this.smpIndices=a}else{if(this.graphType=="Pie"){this.layoutWidth=(this.width-D)*this["subGraphWeight"+A][0];this.layoutHeight=(this.height-e)*this["subGraphWeight"+A][1]}else{if(this.graphOrientation=="vertical"){this.layoutHeight=(this.height-e)*this["subGraphWeight"+A];this.layoutWidth=this.width-D}else{this.layoutWidth=(this.width-D)*this["subGraphWeight"+A];this.layoutHeight=this.height-e}}a=[];if(this.data.l.vars){for(var t=0;t<this.data.l.comp[A].length;t++){if(d.hasOwnProperty(this.data.l.comp[A][t])){a.push(this.data.l.comp[A][t])}}this.varIndices=a}else{for(var t=0;t<this.data.l.comp[A].length;t++){if(f.hasOwnProperty(this.data.l.comp[A][t])){a.push(this.data.l.comp[A][t])}}this.smpIndices=a}}if(this.layoutAdjust){this.layoutAxis=3;this.initAxes(true)}}g.call(this);this["subGraphTop"+A]=this.top;this["subGraphBottom"+A]=this.bottom;this["subGraphRight"+A]=this.right;this["subGraphLeft"+A]=this.left;this["subGraphX"+A]=this.x;this["subGraphY"+A]=this.y;var l=["rect",this.marginLeft+this.offsetX+this.left,this.marginTop+this.offsetY+this.top,this.marginLeft+this.offsetX+this.left+this.x,this.marginTop+this.offsetY+this.top+this.y];if(this.graphType.match(/Scatter/)){if(y==v){var p=this.scaleTextToFont(this.maxSmpNameStr,this.maxTextSize,(this.width-D)*0.8/this.layoutCols);this.drawText(this.data.y.smps[y],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),p,this.foreground,"center","middle")}else{this.addGlobalArea(l,true)}}else{if(!C){this.addGlobalArea(l,true);if(this.data.l.vars&&this.data.l.smps){if(this.graphOrientation!="vertical"&&A%this.data.l.vars.length==0){this.drawLayoutSampleOverlays(u)}if(A>=this.data.l.vars.length*(this.data.l.smps.length-1)){this.drawLayoutVariableLegend()}}else{if(this.graphType!="Pie"){if((this.graphOrientation=="vertical"&&(A+1)==z)||(this.graphOrientation!="vertical"&&A==0)){this.drawLayoutSampleOverlays(u)}}else{if(this.graphType=="Pie"&&A==0){if(h){this.drawLayoutVariableLegend()}}}}}else{if(this.data.l.vars&&this.data.l.smps){this.addGlobalArea(l,true);if(A>=this.data.l.vars.length*(this.data.l.smps.length-1)){this.drawLayoutVariableLegend()}}}}var b={};for(var t=0;t<B.length;t++){b[B[t]]=this[B[t]]}b.width=this.layoutWidth;b.height=this.layoutHeight;b.subGraphType=this.graphType;b.subSummaryType=this.SummaryType;b.subTransformType=this.transformType;this.layoutParams.push(b);if(this.graphType.match(/Scatter/)||(this.data.l.vars&&this.data.l.smps)){this.offsetX+=this.layoutWidth}else{if(this.graphOrientation=="vertical"){this.offsetY+=this.layoutHeight}else{this.offsetX+=this.layoutWidth}}A++}if(this.graphType.match(/Scatter|Pie/)||(this.data.l.vars&&this.data.l.smps)){this.offsetX=this.layoutLeft;this.offsetY+=this.layoutHeight}}this.drawLabelsLayout();this.drawLayoutResizer();this.varIndices=x;this.smpIndices=u;this.showSampleNames=r;this.showOverlays=o;this.showLegend=h;this.showIndicators=w}};this.initializeLayout=function(){this.isValidLayout()};this.initializeLayout()};CanvasXpress.prototype.initConfigurator=function(){this.addConfigurator=function(a){return function(g,d){if(a.isVML||a.disableConfigurator){return}a.configuringOn=true;if(d){a.configuringNetwork=d}var n=a.adjustedCoordinates(g);if(n){var l=n.x;var j=n.y;var h=document.createElement("div");var f=document.createElement("input");var o=document.createElement("select");var m=document.createElement("input");var i=document.createElement("input");h.id=a.target+"canvasXpressConfigurator";h.style.left=l+"px";h.style.top=j+"px";h.style.position="absolute";f.id=a.target+"canvasXpressConfiguratorKey";f.type="text";f.style.display="block";o.id=a.target+"canvasXpressConfiguratorSugestions";o.style.display="none";m.id=a.target+"canvasXpressConfiguratorValue";m.type="text";m.style.display="none";i.id=a.target+"canvasXpressConfiguratorButton";i.value="Draw";i.type="button";i.style.display="none";h.appendChild(f);h.appendChild(o);h.appendChild(m);h.appendChild(i);a.canvas.parentNode.appendChild(h);a.addRemoveConfiguratorListeners("addEvtListener");setTimeout(function(){f.focus()},300)}}}(this);this.addRemoveConfiguratorListeners=function(c){var d=document.getElementById(this.target+"canvasXpressConfiguratorSugestions");var a=document.getElementById(this.target+"canvasXpressConfiguratorButton");if(d){this[c](d,"change",this.clickSelect,false);this[c](d,"click",this.clickSelect,false)}if(a){this[c](a,"click",this.handleSelect,false)}};this.selectConfig=function(g){var c;var m=document.getElementById(this.target+"canvasXpressConfiguratorSugestions");var d=document.getElementById(this.target+"canvasXpressConfiguratorKey");var l=document.getElementById(this.target+"canvasXpressConfiguratorValue");var b=[];if(this.configuringNetwork){c=this.configuringNetwork<this.data.nodes.length?this.data.nodes[this.configuringNetwork]:this.data.edges[this.configuringNetwork-this.data.nodes.length]}else{c=this}if(d&&l&&l.value&&c.hasOwnProperty(d.value)){if(this.getKeyCode(g)==13){if(typeof(this[d.value])=="function"){this.resetConfigurator();if(this[d.value].length>0&&l&&l.value){var j=JSON.parse(l.value);this[d.value].apply(this,j)}else{this[d.value]()}}else{c[d.value]=JSON.parse(l.value);this.userConfig[d.value]=c[d.value];this.resetConfigurator();this.draw()}}else{return}}this.resetSugestions();if(this.configuringNetwork){for(var f in c){if(f.toLowerCase().indexOf(d.value.toLowerCase())>=0){b.push(f)}}}else{for(var f=0;f<this.config.length;f++){if(this.config[f].toLowerCase().indexOf(d.value.toLowerCase())>=0){b.push(this.config[f])}}for(var f=0;f<this.functions.length;f++){if(this.functions[f].toLowerCase().indexOf(d.value.toLowerCase())>=0){b.push(this.functions[f])}}}if(b.length>0){if(b.length==1){d.value=b[0];this.resetSugestions();this.configureSelect()}else{b.sort();var f=document.getElementById(this.target+"canvasXpressImage");f.style.zIndex=0;for(var f=0;f<b.length;f++){var c=document.createElement("option");c.text=b[f];c.value=b[f];try{m.add(c,null)}catch(h){m.add(c)}}m.style.display="block";m.size=Math.min(b.length,5)}}return false};this.resetSugestions=function(){var d=document.getElementById(this.target+"canvasXpressConfiguratorSugestions");var c=document.getElementById(this.target+"canvasXpressConfiguratorValue");var a=document.getElementById(this.target+"canvasXpressConfiguratorButton");if(d){if(d.hasChildNodes()){while(d.childNodes.length>=1){d.removeChild(d.firstChild)}}d.style.display="none"}if(c){c.value="";c.style.display="none"}if(a){a.style.display="none"}};this.clickSelect=function(a){return function(d){var b=document.getElementById(a.target+"canvasXpressConfiguratorKey");var c=document.getElementById(a.target+"canvasXpressConfiguratorSugestions");b.value=c.value;a.resetSugestions();a.configureSelect();return false}}(this);this.configureSelect=function(){var d=document.getElementById(this.target+"canvasXpressConfiguratorKey");var c=document.getElementById(this.target+"canvasXpressConfiguratorValue");var a=document.getElementById(this.target+"canvasXpressConfiguratorButton");if(d&&c&&a){c.style.display="block";a.style.display="block";if(this.configuringNetwork){if(typeof(this[d.value])=="function"){c.style.display="none"}else{if(this.configuringNetwork<this.data.nodes.length){c.value=JSON.stringify(this.data.nodes[this.configuringNetwork][d.value])}else{c.value=JSON.stringify(this.data.edges[this.configuringNetwork-this.data.nodes.length][d.value])}}}else{if(typeof(this[d.value])=="function"){if(this[d.value].length==0){c.style.display="none"}}else{c.value=JSON.stringify(this[d.value])}}setTimeout(function(){c.focus();c.select()},300)}};this.handleSelect=function(a){return function(f){var d=document.getElementById(a.target+"canvasXpressConfiguratorKey");var c=document.getElementById(a.target+"canvasXpressConfiguratorValue");if(d&&c){if(a.configuringNetwork){if(a.configuringNetwork<a.data.nodes.length){if(typeof(a[d.value])=="function"){a[d.value](a.data.nodes[a.configuringNetwork])}else{a.data.nodes[a.configuringNetwork][d.value]=JSON.parse(c.value)}}else{if(typeof(a[d.value])=="function"){a[d.value](a.data.edges[a.configuringNetwork-a.data.nodes.length])}else{a.data.edges[a.configuringNetwork-a.data.nodes.length][d.value]=JSON.parse(c.value)}}}else{if(typeof(a[d.value])=="function"){if(a[d.value].length>0&&c&&c.value){var b=JSON.parse(c.value);a[d.value].apply(a,b)}else{a[d.value]()}d.value="";c.value="";a.resetConfigurator();return}else{a[d.value]=JSON.parse(c.value);a.userConfig[d.value]=a[d.value]}}d.value="";c.value="";a.resetConfigurator();a.draw()}return false}}(this);this.resetConfigurator=function(){var a=document.getElementById(this.target+"canvasXpressImage");if(a){a.style.zIndex=9000;this.configuringOn=false;this.configuringNetwork=false}this.addRemoveConfiguratorListeners("removeEvtListener");this.removeTarget(this.target+"canvasXpressConfigurator")}};CanvasXpress.prototype.initCodeInfo=function(){this.addInfoCodeDiv=function(){if(document.getElementById(this.target+"canvasXpressCode")){return}var a=document.createElement("div");a.id=this.target+"canvasXpressInfoDiv";a.style.display="none";var d=document.createElement("div");d.id=this.target+"canvasXpressCode";d.style.display="none";var b=document.getElementById("canvasXpressRemoteWindow");if(b){b.parentNode.insertBefore(a,b);b.parentNode.appendChild(d)}else{this.canvas.parentNode.parentNode.insertBefore(a,this.canvas.parentNode);this.canvas.parentNode.parentNode.appendChild(d)}};this.clearCodeDiv=function(){var d=document.getElementById(this.target+"canvasXpressCode");if(d){var b=d.childNodes;if(b){for(var a=0;a<b.length;a++){d.removeChild(b[a])}}}d.style.display="none"};this.updateCodeDiv=function(){var f=document.getElementById(this.target+"canvasXpressCode");var e=this.cloneObject(this.data);var b=this.codeType=="pretty"?this.prettyJSON(e):JSON.stringify(e);var d=this.codeType=="pretty"?this.prettyJSON(this.userConfig):JSON.stringify(this.userConfig);if(f){this.clearCodeDiv();var e;var a="";if(this.codeType=="tab"){e=document.createElement("span");a=this.target+"\t"+b+"\t"+d+"\n"}else{if(this.codeType=="compact"){e=document.createElement("span");a='new CanvasXpress("'+this.target+'", '+b+", "+d+")\n"}else{e=document.createElement("pre");a='new CanvasXpress("'+this.target+'", '+b+", "+d+")\n"}}e.style.clear="both";e.innerHTML=a;f.appendChild(e);f.style.display="block"}};this.updateInfoDiv=function(a){var b=document.getElementById(this.target+"canvasXpressInfoDiv");if(b&&a){b.innerHTML=a}};this.showDiv=function(a){var b=document.getElementById(this.target+"canvasXpress"+a);if(b){b.style.display="block"}};this.hideDiv=function(a){var b=document.getElementById(this.target+"canvasXpress"+a);if(b){b.style.display="none"}};this.showCodeDiv=function(){this.showDiv("Code")};this.hideCodeDiv=function(){this.hideDiv("Code")};this.showInfoDiv=function(){this.showDiv("InfoDiv")};this.hideInfoDiv=function(){this.hideDiv("InfoDiv")};this.initializeCodeInfo=function(){this.addInfoCodeDiv()};this.initializeCodeInfo()};CanvasXpress.prototype.initDataTable=function(){this.scrollTable=function(a){return function(b){a.resizeDataTable();return false}}(this);this.hideTable=function(a){return function(b){a.showDataTable=false;a.hideUnhideDataTable(true);return false}}(this);this.dockTable=function(a){return function(b){a.moveDataTableDiv("dock");return false}}(this);this.minimizeTable=function(a){return function(b){a.moveDataTableDiv("min");return false}}(this);this.maximizeTable=function(a){return function(b){a.moveDataTableDiv("max");return false}}(this);this.mousedownDataTable=function(a){return function(b){a.registerDataTableDiv(b);return false}}(this);this.mousedownDataTableResizer=function(a){return function(b){a.registerDataTableResizer(b);return false}}(this);this.registerDataTableDiv=function(b){if(!b){b=window.event}var a=b.target||b.srcElement;if((b.button==1&&window.event!=null||b.button==0)&&a.className=="draggable"){this.dataTableTarget=a.parentNode;this.xMouseDown=b.clientX;this.yMouseDown=b.clientY;this.dataTableXoffset=parseInt(this.dataTableTarget.style.left)||0;this.dataTableYoffset=parseInt(this.dataTableTarget.style.top)||0;this.draggingDataTableOn=true}};this.updateDataTableDiv=function(b){if(!b){b=window.event}if(this.dataTableTarget&&this.dataTableTarget.style){var a=this.dataTableXoffset+b.clientX-this.xMouseDown;var c=this.dataTableYoffset+b.clientY-this.yMouseDown;this.dataTableTarget.style.left=a+"px";this.dataTableTarget.style.top=c+"px";this.dataTableLastX=a;this.dataTableLastY=c}};this.endDataTableDiv=function(a){if(this.dataTableTarget!=null){document.onselectstart=null;this.xMouseDown=null;this.yMouseDown=null;this.dataTableXoffset=null;this.dataTableYoffset=null;this.dataTableTarget.ondragstart=null;this.dataTableTarget=false;this.draggingDataTableOn=false}};this.moveDataTableDiv=function(a){if(!a){return}var b=document.getElementById(this.target+"canvasXpressDataTable");if(b){var e=document.getElementById(this.target+"canvasXpressDataTableContainer");if(a=="dock"){b.style.left="0px";b.style.top="0px";b.style.height="19px";if(e){e.style.display="none"}}else{if(a=="min"){}else{if(a=="max"){b.style.left=this.dataTableLastX+"px";b.style.top=this.dataTableLastY+"px";b.style.height=(this.dataTableTotalHeight+42)+"px";if(e){e.style.display="block"}}}}}};this.registerDataTableResizer=function(b){if(!b){b=window.event}var a=b.target||b.srcElement;if(a.className="resizable"){var d=document.getElementById(this.target+"canvasXpressDataTable");if(d){this.dataTableTarget=d;this.xMouseDown=b.clientX;this.yMouseDown=b.clientY;this.dataTableWidth=parseInt(this.dataTableTarget.style.width)||0;this.dataTableHeight=parseInt(this.dataTableTarget.style.height)||0;this.resizingDataTableOn=true}}};this.updateDataTableResizerDiv=function(b){if(!b){b=window.event}if(this.dataTableTarget&&this.dataTableTarget.style){var f=document.getElementById(this.target+"canvasXpressDataTableContainer");if(f){var a=Math.abs(this.dataTableWidth)-(this.xMouseDown-b.clientX);var d=Math.abs(this.dataTableHeight)-(this.yMouseDown-b.clientY);this.dataTableTarget.style.width=a+"px";this.dataTableTarget.style.height=d+"px";f.style.width=a+"px";f.style.height=(d-18)+"px";this.dataTableLastWidth=a;this.dataTableLastHeight=d}}};this.endDataTableResizerDiv=function(a){if(this.dataTableTarget!=null){this.resizeDataTable(true);this.xMouseDown=null;this.yMouseDown=null;this.dataTableWidth=null;this.dataTableHeight=null;this.dataTableTarget=false;this.resizingDataTableOn=false}};this.getDataTableDimensions=function(){var f=0;var g=0;var e=0;var b=0;var d=document.getElementById(this.target+"canvasXpressDataTableTable");if(d){var a=d.childNodes[0].childNodes[0].rows;if(a){f=a.length;g=a[0].cells.length;e=a[0].cells[0].childNodes[0]?a[0].cells[0].childNodes[0].clientHeight:0;b=a[0].cells[0].childNodes[0]?a[0].cells[0].childNodes[0].clientWidth:0}}return[f,g,e,b]};this.gettAllNetworkAttributes=function(e){var b={};var f=0;if(e[this.networkShowDataTable]){for(var d=0;d<e[this.networkShowDataTable].length;d++){for(var c in e[this.networkShowDataTable][d]){if(b.hasOwnProperty(c)){b[c]++}else{b[c]=1;f++}}}}return[b,f]};this.getVennCompartments=function(c){var b={};var d=0;if(c.venn&&c.venn.data){for(var a in c.venn.data){b[a]=1;d++}}return[b,d]};this.setDataTableDimensions=function(e){var b=0;var k=0;var f=0;var j=function(){for(var a=0;a<e.w.grps.length;a++){f+=e.w.grps[a].length}return f};if(!e){e=this.data}var p=0;if(e.x){for(var h in e.x){p++}}var l=0;if(e.z){for(var h in e.z){l++}}var m=this.gettAllNetworkAttributes(e);var q=this.getVennCompartments(e);var d=document.getElementById(this.target+"canvasXpressDataTableTable");var s=this.getDataTableDimensions();if(s[0]!=this.maxRows||s[1]!=this.maxCols){this.initialMaxRows=this.maxRows;this.initialMaxCols=this.maxCols}if(this.graphType=="Network"){b=this.dataTableTransposed?1+e[this.networkShowDataTable].length:1+m[1];k=this.dataTableTransposed?1+m[1]:1+e[this.networkShowDataTable].length}else{if(this.graphType=="Genome"){b=1;k=1}else{if(this.graphType=="Venn"){b=this.dataTableTransposed?1+q[1]:2;k=this.dataTableTransposed?2:1+q[1]}else{if(this.graphType=="Correlation"){b=this.correlationAxis=="samples"?1+e.y.smps.length:1+e.y.vars.length;k=b}else{if(this.graphType=="Candlestick"){if(e.y){b=this.dataTableTransposed?1+(e.y.smps.length*e.y.vars.length):6;k=this.dataTableTransposed?6:1+(e.y.smps.length*e.y.vars.length)}else{if(e.market){b=this.dataTableTransposed?1+(e.market.smps.length*e.market.vars.length):6;k=this.dataTableTransposed?6:1+(e.market.smps.length*e.market.vars.length)}}}else{if(e.y&&e.y.vars&&e.y.smps){b=this.dataTableTransposed?1+l+e.y.smps.length:1+p+e.y.vars.length;k=this.dataTableTransposed?1+p+e.y.vars.length:1+l+e.y.smps.length}else{if(e.w&&e.w.vars&&e.w.grps){f=j();b=this.dataTableTransposed?1+l+f:1+p+e.w.vars.length;k=this.dataTableTransposed?1+p+e.w.vars.length:1+l+f}}}}}}}if(this.maxRows>b){this.initialMaxRows=this.maxRows;this.maxRows=b}if(this.maxCols>k){this.initialMaxCols=this.maxCols;this.maxCols=k}if(this.totalRows==null||this.totalCols==null){this.totalRows=b;this.totalCols=k}else{if(b!=this.totalRows||k!=this.totalCols||s[0]!=this.maxRows||s[1]!=this.maxCols||s[2]!=this.rowHeight||s[3]!=this.colWidth){this.totalRows=b;this.totalCols=k;this.resetDataTable(true)}else{this.totalRows=b;this.totalCols=k;if(this.showDataTable){this.hideUnhideDataTable()}}}};this.addDataTableDiv=function(B,D){if(document.getElementById(this.target+"canvasXpressDataTable")){return}var g=this;var L=function(d,j,b){var i=b?document.createElement("th"):document.createElement("td");i.id=j;i.width=g.colWidth;i.height=g.rowHeight;d.appendChild(i)};if(!D){this.setDataTableDimensions(B)}var a=this.maxCols*10;var m=this.maxRows*4;var M=((this.maxCols+1)*this.colWidth)+a;var E=((this.maxRows+1)*this.rowHeight)+m;this.dataTableTotalWidth=M;this.dataTableTotalHeight=E;var J=document.createElement("div");J.id=this.target+"canvasXpressDataTable";J.style.width=(M+24)+"px";J.style.height=(E+42)+"px";J.style.zIndex=20000;J.style.overflow="hidden";J.style.position="relative";J.style.display="none";J.style.border="2px groove";J.style.background="#d4d0c8";J.style.clear="both";var f=document.createElement("div");f.id=this.target+"canvasXpressDataTableToolbar";f.style.left="0px";f.style.top="0px";f.style.width=(M+24)+"px";f.style.height=19+"px";f.style.position="absolute";f.style.cursor="move";f.style.background="#d4d0c8";f.className="draggable";var p=document.createElement("img");p.id=this.target+"canvasXpressDataTableIconifyImage";p.src=this.imageDir+"iconify_w.png";p.style.left=(M-27)+"px";p.style.top="2px";p.style.position="relative";p.style.cursor="default";p.style.zIndex=20001;var k=document.createElement("img");k.id=this.target+"canvasXpressDataTableMinimizeImage";k.src=this.imageDir+"minimize_w.png";k.style.left=(M-27)+"px";k.style.top="2px";k.style.position="relative";k.style.cursor="default";k.style.zIndex=20001;k.style.display="none";var c=document.createElement("img");c.id=this.target+"canvasXpressDataTableMaximizeImage";c.src=this.imageDir+"maximize_w.png";c.style.left=(M-27)+"px";c.style.top="2px";c.style.position="relative";c.style.cursor="default";c.style.zIndex=20001;var C=document.createElement("img");C.id=this.target+"canvasXpressDataTableCloseImage";C.src=this.imageDir+"close_w.png";C.style.left=(M-27)+"px";C.style.top="2px";C.style.position="relative";C.style.cursor="default";C.style.zIndex=20001;var F=document.createElement("div");F.id=this.target+"canvasXpressDataTableContainer";F.style.left="0px";F.style.top="20px";F.style.width=(M+24)+"px";F.style.height=(E+24)+"px";F.style.position="absolute";F.style.display="block";var y=document.createElement("div");y.id=this.target+"canvasXpressDataTableHeader";y.style.left="2px";y.style.top="0px";y.style.width=M+"px";y.style.height=1+"px";y.style.position="absolute";var x=document.createElement("div");x.id=this.target+"canvasXpressDataTableTable";x.style.left="2px";x.style.top="1px";x.style.width=M+"px";x.style.height=E+"px";x.style.position="absolute";var u=document.createElement("div");u.id=this.target+"canvasXpressDataTableVer";u.style.overflow="auto";u.style.right="3px";u.style.top="1px";u.style.width="18px";u.style.height=E+"px";u.style.position="absolute";var e=document.createElement("img");e.id=this.target+"canvasXpressDataTableVerImage";e.src=this.getPixelImage();e.width=1;e.height=((this.totalRows+1)*this.rowHeight)+m;u.appendChild(e);var A=document.createElement("div");A.id=this.target+"canvasXpressDataTableFooter";A.style.left="2px";A.style.top=(E+1)+"px";A.style.width=M+"px";A.style.height=1+"px";A.style.position="absolute";var I=document.createElement("div");I.id=this.target+"canvasXpressDataTableHor";I.style.overflow="auto";I.style.left="2px";I.style.bottom="5px";I.style.width=M+"px";I.style.height="18px";I.style.position="absolute";var s=document.createElement("img");s.id=this.target+"canvasXpressDataTableHorImage";s.src=this.getPixelImage();s.width=((this.totalCols+1)*this.colWidth)+a;s.height=1;I.appendChild(s);var h=document.createElement("div");h.id=this.target+"canvasXpressDataTableResizer";h.style.right="0px";h.style.bottom="2px";h.style.width="13px";h.style.height="13px";h.style.position="absolute";h.style.cursor="se-resize";h.style.backgroundImage="url('"+this.imageDir+"resize_w.png')";h.style.backgroundRepeat="no-repeat";h.className="resizable";var q=document.createElement("table");q.id=this.target+"canvasXpressTable";q.style.border="2px groove";q.style.borderCollapse="collapse";q.style.fontSize="x-small";q.style.left="0px";q.style.top="0px";q.style.width=M+"px";q.style.height=E+"px";q.style.position="absolute";q.style.background="#fefefe";var K=document.createElement("tbody");for(var H=0;H<this.maxRows;H++){var v=document.createElement("tr");for(var G=0;G<this.maxCols;G++){var z=this.target+"canvasXpressDataTableCell."+H+"."+G;var s=H==0||G==0?true:false;L(v,z,s)}K.appendChild(v)}f.appendChild(p);f.appendChild(k);f.appendChild(c);f.appendChild(C);q.appendChild(K);x.appendChild(q);F.appendChild(y);F.appendChild(x);F.appendChild(u);F.appendChild(A);F.appendChild(I);F.appendChild(h);J.appendChild(f);J.appendChild(F);var l=document.getElementById("canvasXpressRemoteWindow");if(l){l.parentNode.appendChild(J)}else{this.canvas.parentNode.parentNode.appendChild(J)}this.addRemoveDataTableListeners("addEvtListener")};this.addRemoveDataTableListeners=function(d){var f=document.getElementById(this.target+"canvasXpressDataTableHor");var k=document.getElementById(this.target+"canvasXpressDataTableVer");var l=document.getElementById(this.target+"canvasXpressDataTableToolbar");var e=document.getElementById(this.target+"canvasXpressDataTableIconifyImage");var b=document.getElementById(this.target+"canvasXpressDataTableMinimizeImage");var j=document.getElementById(this.target+"canvasXpressDataTableMaximizeImage");var g=document.getElementById(this.target+"canvasXpressDataTableCloseImage");var a=document.getElementById(this.target+"canvasXpressDataTableResizer");if(f){this[d](f,"scroll",this.scrollTable,false)}if(k){this[d](k,"scroll",this.scrollTable,false)}if(l){this[d](l,"mousedown",this.mousedownDataTable,false)}if(e){this[d](e,"click",this.dockTable,false)}if(b){this[d](b,"click",this.minimizeTable,false)}if(j){this[d](j,"click",this.maximizeTable,false)}if(g){this[d](g,"click",this.hideTable,false)}if(a){this[d](a,"mousedown",this.mousedownDataTableResizer,false)}};this.resizeDataTable=function(g){var i=document.getElementById(this.target+"canvasXpressDataTable");var b=document.getElementById(this.target+"canvasXpressDataTableVer");var f=document.getElementById(this.target+"canvasXpressDataTableHor");var j=document.getElementById(this.target+"canvasXpressDataTableContainer");if(g){if(j){this.startCol=0;this.startRow=0;this.maxCols=parseInt((parseInt(j.style.width))/this.colWidth)-3;this.maxRows=parseInt((parseInt(j.style.height))/this.rowHeight)-3;this.updateDataTable()}}else{if(i&&b&&f){var a=Math.max(0,parseInt(f.scrollLeft/this.colWidth));var e=Math.max(0,parseInt(b.scrollTop/this.rowHeight));if(a!=this.startCol||e!=this.startRow){this.startCol=a;this.startRow=e;this.updateDataTable()}}}};this.updateDataTable=function(A){var h=0;var f=0;var z=0;var w=0;var H=[];var I=[];var y=[];var x=[];if(!A){A=this.currentDataTableData?this.currentDataTableData:this.data}else{if(this.isGroupedData){var E=this.getVariableIndices(A.w.vars);var F=[];for(var D=0;D<A.w.grps.length;D++){F=F.concat(A.w.grps[D])}this.isGroupedData=false;A=this.extractDataObject(F,E);this.isGroupedData=true}}this.setDataTableDimensions(A);if(this.graphType=="Network"){var J=this.gettAllNetworkAttributes(A);y.push("");x.push("cxb");if(this.dataTableTransposed){for(var E in J[0]){if(f<this.maxCols&&w>=this.startCol){y.push(E);x.push("cxx");f++}w++}H.push(y);I.push(x);for(var E=0;E<A[this.networkShowDataTable].length;E++){if(h<this.maxRows&&z>=this.startRow){f=0;w=0;y=[E+1];x=["cxz"];for(var D in J[0]){if(f<this.maxCols&&w>=this.startCol){var q=A[this.networkShowDataTable][E][D];y.push(q?q:"");x.push("cxy");f++}w++}H.push(y);I.push(x);h++}z++}}else{for(var E=0;E<A[this.networkShowDataTable].length;E++){if(f<this.maxCols&&w>=this.startCol){y.push(E+1);x.push("cxz");f++}w++}H.push(y);I.push(x);for(var E in J[0]){if(h<this.maxRows&&z>=this.startRow){f=0;w=0;y=[E];x=["cxx"];for(var D=0;D<A[this.networkShowDataTable].length;D++){if(f<this.maxCols&&w>=this.startCol){var q=A[this.networkShowDataTable][D][E];y.push(q?q:"");x.push("cxy");f++}w++}H.push(y);I.push(x);h++}z++}}}else{if(this.graphType=="Genome"){H=[["Not implemented"]];I=[["cxb"]]}else{if(this.graphType=="Venn"){var q=this.getVennCompartments(A);y.push("");x.push("cxb");if(this.dataTableTransposed){y.push("No");x.push("cxz");H.push(y);I.push(x);for(var E in q[0]){if(h<this.maxRows&&z>=this.startRow){f=0;w=0;y=[E];x=["cxx"];if(f<this.maxCols&&w>=this.startCol){y.push(A.venn.data[E]);x.push("cxy");f++}w++;H.push(y);I.push(x);h++}z++}}else{for(var E in q[0]){if(f<this.maxCols&&w>=this.startCol){y.push(E);x.push("cxx");f++}w++}H.push(y);I.push(x);if(h<this.maxRows&&z>=this.startRow){f=0;w=0;y=["No"];x=["cxz"];for(var E in q[0]){if(f<this.maxCols&&w>=this.startCol){y.push(A.venn.data[E]);x.push("cxy");f++}w++}H.push(y);I.push(x)}}}else{if(this.graphType=="Correlation"){var p=this.correlationAxis=="samples"?A.y.smps:A.y.vars;var n=this.correlationAxis=="samples"?"cxs":"cxv";y.push("");x.push("cxb");for(var E=0;E<p.length;E++){if(f<this.maxCols&&w>=this.startCol){y.push(p[E]);x.push(n);f++}w++}H.push(y);I.push(x);for(var E=0;E<p.length;E++){if(h<this.maxRows&&z>=this.startRow){f=0;w=0;y=[p[E]];x=[n];for(var D=0;D<p.length;D++){if(f<this.maxCols&&w>=this.startCol){if(A.y.cor){y.push(A.y.cor[E][D])}else{y.push(E==D?1:A.y.data)}x.push("cxy");f++}w++}H.push(y);I.push(x);h++}z++}}else{if(this.graphType=="Candlestick"){var J=["open","low","high","close","volume"];y.push("");x.push("cxb");if(this.dataTableTransposed){for(var E=0;E<A.y.vars.length;E++){for(var D=0;D<J.length;D++){if(f<this.maxCols&&w>=this.startCol){var B=A.y.vars.length>1?A.y.vars[E]+":"+J[D]:J[D];y.push(B);x.push("cxv");f++}w++}}H.push(y);I.push(x);for(var E=0;E<A.y.smps.length;E++){if(h<this.maxRows&&z>=this.startRow){f=0;w=0;y=[A.y.smps[E]];x=["cxs"];for(var D=0;D<A.y.vars.length;D++){for(var C=0;C<J.length;C++){if(f<this.maxCols&&w>=this.startCol){y.push(A.y[J[C]][D][E]!=null?A.y[J[C]][D][E]:A.y[J[C]][E]);x.push("cxy");f++}w++}}H.push(y);I.push(x);h++}z++}}else{for(var E=0;E<A.y.smps.length;E++){if(f<this.maxCols&&w>=this.startCol){y.push(A.y.smps[E]);x.push("cxs");f++}w++}H.push(y);I.push(x);for(var E=0;E<A.y.vars.length;E++){for(var D=0;D<J.length;D++){if(h<this.maxRows&&z>=this.startRow){f=0;w=0;var B=A.y.vars.length>1?A.y.vars[E]+":"+J[D]:J[D];y=[B];x=["cxv"];for(var C=0;C<A.y.smps.length;C++){if(f<this.maxCols&&w>=this.startCol){y.push(A.y[J[D]][E][C]!=null?A.y[J[D]][E][C]:A.y[J[D]][C]);x.push("cxy");f++}w++}H.push(y);I.push(x);h++}z++}}}}else{if(A.y.vars&&A.y.smps){y.push("");x.push("cxb");if(this.dataTableTransposed){if(A.x){for(var E in A.x){if(f<this.maxCols&&w>=this.startCol){y.push(E);x.push("cxx");f++}w++}}for(var E=0;E<A.y.vars.length;E++){if(f<this.maxCols&&w>=this.startCol){y.push(A.y.vars[E]);x.push("cxv");f++}w++}H.push(y);I.push(x);if(A.z){for(var E in A.z){if(h<this.maxRows&&z>=this.startRow){f=0;w=0;y=[E];x=["cxz"];if(A.x){for(var D in A.x){if(f<this.maxCols&&w>=this.startCol){y.push("");x.push("cxb");f++}w++}}for(var D=0;D<A.y.vars.length;D++){if(f<this.maxCols&&w>=this.startCol){y.push(A.z[E][D]);x.push("cxz");f++}w++}H.push(y);I.push(x);h++}z++}}for(var E=0;E<A.y.smps.length;E++){if(h<this.maxRows&&z>=this.startRow){f=0;w=0;y=[A.y.smps[E]];x=["cxs"];if(A.x){for(var D in A.x){if(f<this.maxCols&&w>=this.startCol){y.push(A.x[D][E]);x.push("cxx");f++}w++}}for(var D=0;D<A.y.vars.length;D++){if(f<this.maxCols&&w>=this.startCol){y.push(A.y.data[D][E]!=null?A.y.data[D][E]:A.y.data[E]);x.push("cxy");f++}w++}H.push(y);I.push(x);h++}z++}}else{if(A.z){for(var E in A.z){if(f<this.maxCols&&w>=this.startCol){y.push(E);x.push("cxz");f++}w++}}for(var E=0;E<A.y.smps.length;E++){if(f<this.maxCols&&w>=this.startCol){y.push(A.y.smps[E]);x.push("cxs");f++}w++}H.push(y);I.push(x);if(A.x){for(var E in A.x){if(h<this.maxRows&&z>=this.startRow){f=0;w=0;y=[E];x=["cxx"];if(A.z){for(var D in A.z){if(f<this.maxCols&&w>=this.startCol){y.push("");x.push("cxb");f++}w++}}for(var D=0;D<A.y.smps.length;D++){if(f<this.maxCols&&w>=this.startCol){y.push(A.x[E][D]);x.push("cxx");f++}w++}H.push(y);I.push(x);h++}z++}}for(var E=0;E<A.y.vars.length;E++){if(h<this.maxRows&&z>=this.startRow){f=0;w=0;y=[A.y.vars[E]];x=["cxv"];if(A.z){for(var D in A.z){if(f<this.maxCols&&w>=this.startCol){y.push(A.z[D][E]);x.push("cxz");f++}w++}}for(var D=0;D<A.y.smps.length;D++){if(f<this.maxCols&&w>=this.startCol){y.push(A.y.data[E][D]!=null?A.y.data[E][D]:A.y.data[D]);x.push("cxy");f++}w++}H.push(y);I.push(x);h++}z++}}}}}}}}var u=document.getElementById(this.target+"canvasXpressDataTable");if(u){for(var E=0;E<H.length;E++){for(var D=0;D<H[E].length;D++){var G=document.getElementById(this.target+"canvasXpressDataTableCell."+E+"."+D);if(G){if(G.hasChildNodes()){while(G.childNodes.length>=1){G.removeChild(G.firstChild)}}var m=document.createElement("div");m.className="cxc";m.style.width=this.colWidth+"px";m.style.height=this.rowHeight+"px";var b=document.createTextNode(H[E][D]);m.appendChild(b);G.appendChild(m);G.className=I[E][D];G.title=H[E][D];G.alt=H[E][D]}}}u.style.display="block";this.currentDataTableData=A}};this.resetDataTable=function(a){this.addRemoveDataTableListeners("removeEvtListener");this.removeTarget(this.target+"canvasXpressDataTable");this.addDataTableDiv(false,a)};this.hideUnhideDataTable=function(a){this.currentDataTableData=null;if(this.initialMaxRows){this.maxRows=this.initialMaxRows}if(this.initialMaxCols){this.maxCols=this.initialMaxCols}var b=document.getElementById(this.target+"canvasXpressDataTable");if(b){if(a){b.style.display="none"}else{b.style.display="block"}}};this.initializeDataTableEvents=function(){this.addDataTableDiv()};this.initializeDataTableEvents()};CanvasXpress.prototype.initDendrogramEvents=function(){this.modifyDendrogram=function(g){var e=g.t.t=="varDendrogram"?this.varIndicesStart:this.smpIndicesStart;var c=g.t.t.replace("Dendrogram","s");var f=this[g.t.t].object;var h=g.t.d+"-"+g.t.o;var d=this.findDendrogramBranch(f,h);var b=this.reverseDendrogramBranch(d);var a=this.writeNewick(f,true);this.data.t[c]=a;this.draw()};this.findDendrogramBranch=function(b,c,a){if(b.id==c){a=b}if(!a){if(b.left){a=this.findDendrogramBranch(b.left,c,a)}if(b.right){a=this.findDendrogramBranch(b.right,c,a)}}else{return a}return a};this.reverseDendrogramBranch=function(b){if(b&&b.right&&b.left){b.right=this.reverseDendrogramBranch(b.right);b.left=this.reverseDendrogramBranch(b.left);var a=b.left;b.left=b.right;b.right=a;if(b.mid){b.mid=b.mid.reverse()}}return b}};CanvasXpress.prototype.initSelectEvents=function(){this.showHideSelectedDataPoint=function(f,j){this.stopEvent(f);if(j==45||j==46){var g=this.layoutComb?this.layoutValidN:0;var d=this.layoutComb?this.layoutParams[g].graphType:this.graphType;if(d=="Network"){var b=[];var a=j==45?false:true;for(var h in this.selectNode){b.push(h)}if(b.length>0){this.hideUnhideNodes(b,a)}}else{if(d.match(/Scatter/)){if(j==45){this.selectDataPoint=this.hideDataPoint;this.hideDataPoint=[]}else{this.hideDataPoint=this.selectDataPoint;this.selectDataPoint=[]}}}this.draw()}};this.addRemoveToSelectedDataPoints=function(h,f){var b=this.broadcast?CanvasXpress.references:[this];for(var e=0;e<b.length;e++){var g=b[e];if(!h){var j=g.layoutComb?g.layoutValidN:0;h=g.layoutComb?g.layoutParams[j].graphType:g.graphType}if(h=="Network"){var a=parseInt(f.join(", "));if(a<g.data.nodes.length){var d=g.data.nodes[a].id;if(g.selectNode.hasOwnProperty(d)){g.isSelectNodes--;delete g.selectNode[d]}else{g.isSelectNodes++;g.selectNode[d]=true}}}else{if(h.match(/Scatter/)){var d;if(!g.selectDataPoint[f[0]]){g.selectDataPoint[f[0]]={}}if(h=="Scatter3D"){d=f[1]+":"+f[2]+":"+f[3]}else{d=f[1]+":"+f[2]}if(g.selectDataPoint[f[0]].hasOwnProperty(d)){g.isSelectDataPoints--;delete g.selectDataPoint[f[0]][d]}else{g.isSelectDataPoints++;g.selectDataPoint[f[0]][d]=true}}}}};this.resetSelectedDataPoints=function(){if(this.isSelectDataPoints){this.selectDataPoint=[];this.hideDataPoint=[];this.isSelectDataPoints=0}};this.resetSelectedNodes=function(){if(this.isSelectNodes){this.selectNode={};this.isSelectNodes=0}}};CanvasXpress.prototype.initKeyEvents=function(){this.isInFocus=function(){var b=document.activeElement;var a=b.getElementsByTagName("img");if(!a||a.length==0){a=b.parentNode.getElementsByTagName("img")}if(!a||a.length==0){a=b.parentNode.parentNode.getElementsByTagName("img")}for(i=0;i<a.length;i++){if(a[i].id.match(this.target)){return true}}return false};this.isInView=function(e){if(e&&e.id&&e.id.match(this.target)){return true}else{if(!this.isInFocus()){return false}}var c=e.offsetTop;var b=e.offsetLeft;var a=e.offsetWidth;var d=e.offsetHeight;while(e.offsetParent){e=e.offsetParent;c+=e.offsetTop;b+=e.offsetLeft}return(c<(window.pageYOffset+window.innerHeight)&&b<(window.pageXOffset+window.innerWidth)&&(c+d)>window.pageYOffset&&(b+a)>window.pageXOffset)};this.getKeyCode=function(a){if(a){if((a.charCode)&&(a.keyCode==0)){return a.charCode}else{return a.keyCode}}};this.registerKey=function(a){if(!a){a=window.event}var b=this.getKeyCode(a);if(this.eventKeys||(a.ctrlKey&&a.altKey&&b==107)){if(b==27){if(this.animationOn){this.animationOn=false;return false}this.masterReset(a)}else{if(this.configuringOn){return}else{if(b==16&&this.helpKeyEvents){if(a.ctrlKey&&a.altKey){this.showCtrlShiftAltShorts()}else{if(a.ctrlKey){this.showCtrlShiftShorts()}else{if(a.altKey){this.showShiftAltShorts()}else{this.showShiftShorts()}}}}else{if(b==17&&this.helpKeyEvents){if(a.shiftKey&&a.altKey){this.showCtrlShiftAltShorts()}else{if(a.shiftKey){this.showCtrlShiftShorts()}else{if(a.altKey){this.showCtrlAltShorts()}else{this.showCtrlShorts()}}}}else{if((b==18||b==224)&&this.helpKeyEvents){if(a.ctrlKey&&a.shiftKey){this.showCtrlShiftAltShorts()}else{if(a.ctrlKey){this.showCtrlAltShorts()}else{if(a.shiftKey){this.showShiftAltShorts()}else{this.showAltShorts()}}}}else{if(a.ctrlKey&&a.shiftKey){if(b==80){this.print()}if(b>=33&&b<=40){this.arrowMove(b,true)}else{if(b==90&&this.graphType=="Network"){this.alignDistributeSelectedNodes(a,b)}}document.defaultAction=true}else{if(a.ctrlKey&&a.altKey){if(b==80){this.print()}document.defaultAction=true}else{if(a.shiftKey&&a.altKey){if(b>=50&&b<90){this.setGraphType(b)}document.defaultAction=true}else{if(a.ctrlKey){if(b>=33&&b<=40){this.arrowMove(b)}else{if(b==45||b==46){this.showHideSelectedDataPoint(a,b)}else{if(b>=48&&b<58){this.setLayout(b-48)}else{if(b>=65&&b<=90){if(b==80){this.print()}if(this.graphType=="Network"){this.alignDistributeSelectedNodes(a,b)}}}}}document.defaultAction=true}else{if(b==107||b==109||b==61||b==187||b==189){if(this.eventPlusMinusKeys){if(b==109||b==189){this.handleWheelEvent(a,-1)}else{this.handleWheelEvent(a,1)}}}else{if(b>=33&&b<=40){if(this.eventArrowKeys){this.handlePanning(a,b)}}else{if(a.shiftKey){document.defaultAction=true}else{if(a.altKey){document.defaultAction=true}}}}}}}}}}}}}}};this.handlePanning=function(f,j){if(this.graphType=="Network"){this.cancelEvent(f);var m=Math.abs(this.x*this.panningStep);var k=Math.abs(this.y*this.panningStep);if(j==33){this.panningY-=k*5}else{if(j==34){this.panningY+=k*5}else{if(j==35){this.panningX=m*20;this.panningY=k*20}else{if(j==36){this.panningX=0;this.panningY=0}else{if(j==37){this.panningX-=m}else{if(j==38){this.panningY-=k}else{if(j==39){this.panningX+=m}else{if(j==40){this.panningY+=k}}}}}}}}this.draw(false,false,false,true)}else{if(this.graphType=="Heatmap"){this.cancelEvent(f);this.resetAxesResizer(f);var g=this.layoutComb?this.layoutValidN:0;var p;var n=this.layoutComb?this.layoutParams[g].varIndices:this.varIndices;if(this.isGroupedData){p=this.layoutComb?this.layoutParams[g].grpIndices:this.grpIndices}else{p=this.layoutComb?this.layoutParams[g].smpIndices:this.smpIndices}this.setOriginalIndices(j,n,p);if(j==35){return false}else{if(j==36){this.varIndicesStart=-1;this.smpIndicesStart=-1;this.varIndices=this.startingVarIndices[g];if(this.isGroupedData){this.grpIndices=this.startingSmpIndices[g]}else{this.smpIndices=this.startingSmpIndices[g]}this.draw()}else{if(j==37){if(this.varIndicesStart>0){this.varIndices.unshift(this.startingVarIndices[g][this.varIndicesStart-1]);this.varIndices.pop();this.varIndicesStart--;this.draw()}}else{if(j==38||j==33){var o=j==33?5:1;var h=false;var a=this.isGroupedData?this.grpIndices:this.smpIndices;for(var b=0;b<o;b++){if(this.smpIndicesStart>0){a.unshift(this.startingSmpIndices[g][this.smpIndicesStart-1]);a.pop();this.smpIndicesStart--;h=true}}if(h){this.draw()}}else{if(j==39){if(this.varIndicesStart>-1&&this.varIndicesStart+n.length<this.startingVarIndices[g].length){this.varIndices.push(this.startingVarIndices[g][this.varIndicesStart+this.varIndices.length]);this.varIndices.shift();this.varIndicesStart++;this.draw()}}else{if(j==40||j==34){var o=j==34?5:1;var h=false;var a=this.isGroupedData?this.grpIndices:this.smpIndices;for(var b=0;b<o;b++){if(this.smpIndicesStart>-1&&this.smpIndicesStart+p.length<this.startingSmpIndices[g].length){a.push(this.startingSmpIndices[g][this.smpIndicesStart+a.length]);a.shift();this.smpIndicesStart++;h=true}}if(h){this.draw()}}}}}}}}}return false};this.showCtrlShiftAltShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Ctrl + Shift + Alt</th></tr>";a+="<tr><td class=k>&nbsp;</td><td class=d>&nbsp;</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.showCtrlShiftShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Shift + Ctrl</th></tr>";if(this.graphType=="Network"){if(this.is3DNetwork){a+="<tr><td class=k>&rarr;</td><td class=d>Rotate clockwise "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>&larr;</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>&darr;</td><td class=d>Rotate forward "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>&uarr;</td><td class=d>Rotate backward "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>PgUp</td><td class=d>Rotate anti-clockwise and backward "+(this.rotationStep*3)+"&deg; continuously</td></tr>";a+="<tr><td class=k>PgDn</td><td class=d>Rotate clockwise and forward "+(this.rotationStep*3)+"&deg; continuously</td></tr>"}else{a+="<tr><td class=k>&rarr; or &darr;</td><td class=d>Rotate clockwise "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>&larr; or &uarr;</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>PgUp</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*3)+"&deg; continuously</td></tr>";a+="<tr><td class=k>PgDn</td><td class=d>Rotate clockwise "+(this.rotationStep*3)+"&deg; continuously</td></tr>"}}else{if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){if(this.type2D=="XYZ"){if(this.xAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in X, Y and Z axes continuously (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in X, Y and Z axes continuously (2x)</td></tr>"}}else{if(this.type2D=="XY"){if(this.zAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update sample in Z axis continuously (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update sample in Z axis continuously (2x)</td></tr>"}}else{if(this.type2D=="X"){if(this.yAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in Y and Z axes continuously (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in Y and Z axes continuously (2x)</td></tr>"}}else{if(this.xAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in X and Z axes continuously (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in X and Z axes continuously (2x)</td></tr>"}}}}}else{if(this.graphType=="Scatter3D"){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Rotate continuously</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Rotate continuously</td></tr>"}else{if(this.isSegregable()){a+="<tr><td class=k>Click and Drag</td><td class=d>Select Samples</td></tr>"}}}}a+="<tr><td class=k>P</td><td class=d>Print</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.showCtrlAltShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Ctrl + Alt</th></tr>";a+="<tr><td class=k>P</td><td class=d>Print</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.showShiftAltShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Shift + Alt</th></tr>";a+="<tr><td class=k>2</td><td class=d>Scatter2D</td></tr>";a+="<tr><td class=k>3</td><td class=d>Scatter3D</td></tr>";a+="<tr><td class=k>4</td><td class=d>ScatterBubble2D</td></tr>";a+="<tr><td class=k>A</td><td class=d>Area</td></tr>";a+="<tr><td class=k>B</td><td class=d>Bar</td></tr>";a+="<tr><td class=k>C</td><td class=d>BarLine</td></tr>";a+="<tr><td class=k>D</td><td class=d>Dotplot</td></tr>";a+="<tr><td class=k>G</td><td class=d>Genome</td></tr>";a+="<tr><td class=k>H</td><td class=d>Heatmap</td></tr>";a+="<tr><td class=k>I</td><td class=d>Boxplot</td></tr>";a+="<tr><td class=k>L</td><td class=d>Line</td></tr>";a+="<tr><td class=k>M</td><td class=d>Candlestick</td></tr>";a+="<tr><td class=k>N</td><td class=d>Network</td></tr>";a+="<tr><td class=k>P</td><td class=d>Pie</td></tr>";a+="<tr><td class=k>S</td><td class=d>Stacked</td></tr>";a+="<tr><td class=k>U</td><td class=d>StackedLine</td></tr>";a+="<tr><td class=k>T</td><td class=d>StackedPercent</td></tr>";a+="<tr><td class=k>W</td><td class=d>StackedPercentLine</td></tr>";a+="<tr><td class=k>V</td><td class=d>Venn</td></tr>";a+="<tr><td class=k>X</td><td class=d>Correlation</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.showCtrlShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Ctrl</th></tr>";if(this.graphType=="Network"){if(this.is3DNetwork){a+="<tr><td class=k>&rarr;</td><td class=d>Rotate clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&larr;</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&darr;</td><td class=d>Rotate forward "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&uarr;</td><td class=d>Rotate backward "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>PgUp</td><td class=d>Rotate anti-clockwise and backward "+(this.rotationStep*3)+"&deg;</td></tr>";a+="<tr><td class=k>PgDn</td><td class=d>Rotate clockwise and forward "+(this.rotationStep*3)+"&deg;</td></tr>"}else{a+="<tr><td class=k>&rarr; or &darr;</td><td class=d>Rotate clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&larr; or &uarr;</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>PgUp</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*3)+"&deg;</td></tr>";a+="<tr><td class=k>PgDn</td><td class=d>Rotate clockwise "+(this.rotationStep*3)+"&deg;</td></tr>"}a+="<tr><td class=k>click</td><td class=d>Select/Unselect node</td></tr>";if(this.isSelectNodes){a+="<tr><td class=k>Delete</td><td class=d>Hide selected nodes</td></tr>";a+="<tr><td class=k>Insert</td><td class=d>Show selected-hidden nodes</td></tr>";a+="<tr><td class=k>t</td><td class=d>Align top</td></tr>";a+="<tr><td class=k>r</td><td class=d>Align right</td></tr>";a+="<tr><td class=k>b</td><td class=d>Align bottom</td></tr>";a+="<tr><td class=k>l</td><td class=d>Align left</td></tr>";a+="<tr><td class=k>v</td><td class=d>Distribute verticaly</td></tr>";a+="<tr><td class=k>h</td><td class=d>Distribute Horizontaly</td></tr>";a+="<tr><td class=k>z</td><td class=d>Undo</td></tr>";a+="<tr><td class=k>y</td><td class=d>Redo</td></tr>"}}else{if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){if(this.type2D=="XYZ"){if(this.xAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in X, Y and Z axes (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in X, Y and Z axes (2x)</td></tr>"}}else{if(this.type2D=="XY"){if(this.zAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update sample in Z axis (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update sample in Z axis (2x)</td></tr>"}}else{if(this.type2D=="X"){if(this.yAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in Y and Z axes (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in Y and Z axes (2x)</td></tr>"}}else{if(this.xAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in X and Z axes (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in X and Z axes (2x)</td></tr>"}}}}if(this.isSelectDataPoints){a+="<tr><td class=k>Delete</td><td class=d>Hide selected nodes</td></tr>";a+="<tr><td class=k>Insert</td><td class=d>Show selected-hidden nodes</td></tr>"}}else{if(this.graphType=="Scatter3D"){a+="<tr><td class=k>&rarr;</td><td class=d>Rotate clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&larr;</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&darr;</td><td class=d>Rotate forward "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&uarr;</td><td class=d>Rotate backward "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>PgUp</td><td class=d>Rotate anti-clockwise and backward "+(this.rotationStep*3)+"&deg;</td></tr>";a+="<tr><td class=k>PgDn</td><td class=d>Rotate clockwise and forward "+(this.rotationStep*3)+"&deg;</td></tr>";a+="<tr><td class=k>click</td><td class=d>Select/Unselect data points</td></tr>";if(this.isSelectDataPoints){a+="<tr><td class=k>Delete</td><td class=d>Hide selected nodes</td></tr>";a+="<tr><td class=k>Insert</td><td class=d>Show selected-hidden nodes</td></tr>"}}else{if(this.isSegregable()){}}}}a+="<tr><td class=k>P</td><td class=d>Print</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.showShiftShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Shift</th></tr>";a+="<tr><td class=k>&nbsp;</td><td class=d>&nbsp;</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.showAltShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Alt</th></tr>";if(this.graphType=="Network"){a+="<tr><td class=k>left-click node</td><td class=d>Configure Node</td></tr>"}a+="</table>";this.showInfoSpan(false,a)};this.arrowMove=function(g,b){switch(this.graphType){case"Network":if(this.is3DNetwork){if(g==33){this.xRotate+=(this.rotationStep*3);this.yRotate-=(this.rotationStep*3)}else{if(g==34){this.xRotate-=(this.rotationStep*3);this.yRotate+=(this.rotationStep*3)}else{if(g==37){this.xRotate+=this.rotationStep}else{if(g==38){this.yRotate-=this.rotationStep}else{if(g==39){this.xRotate-=this.rotationStep}else{if(g==40){this.yRotate+=this.rotationStep}}}}}}}else{if(g==33){this.network2DRotate-=(this.rotationStep*3)}else{if(g==34){this.network2DRotate+=(this.rotationStep*3)}else{if(g==37||g==38){this.network2DRotate-=this.rotationStep}else{if(g==39||g==40){this.network2DRotate+=this.rotationStep}}}}}break;case"Scatter2D":case"ScatterBubble2D":var e;var f;if(this.type2D=="XYZ"){e=["xAxisCurrent","yAxisCurrent","zAxisCurrent"];f=["xAxis","yAxis","zAxis"]}else{if(this.type2D=="XY"){e=["zAxisCurrent"];f=["zAxis"]}else{if(this.type2D=="X"){e=["yAxisCurrent","zAxisCurrent"];f=["yAxis","zAxis"]}else{e=["xAxisCurrent","zAxisCurrent"];f=["xAxis","zAxis"]}}}if(g==33){for(var d=0;d<e.length;d++){this[e[d]]+=2}}else{if(g==34){for(var d=0;d<e.length;d++){this[e[d]]-=2}}else{if(g==35){for(var d=0;d<e.length;d++){this[e[d]]=this[f[d]].length-1}}else{if(g==36){for(var d=0;d<e.length;d++){this[e[d]]=0}}else{if(g==37||g==40){for(var d=0;d<e.length;d++){this[e[d]]--}}else{if(g==38||g==39){for(var d=0;d<e.length;d++){this[e[d]]++}}}}}}}this.xAxisCurrent=this.xAxisCurrent<0?this.xAxis.length-1:this.xAxisCurrent>this.xAxis.length-1?0:this.xAxisCurrent;this.yAxisCurrent=this.yAxisCurrent<0?this.xAxis.length-1:this.yAxisCurrent>this.yAxis.length-1?0:this.yAxisCurrent;this.zAxisCurrent=this.zAxisCurrent<0?this.xAxis.length-1:this.zAxisCurrent>this.zAxis.length-1?0:this.zAxisCurrent;break;case"Scatter3D":if(g==33){this.xRotate+=(this.rotationStep*3);this.yRotate-=(this.rotationStep*3)}else{if(g==34){this.xRotate-=(this.rotationStep*3);this.yRotate+=(this.rotationStep*3)}else{if(g==35){this.xRotate=0;this.yRotate=0;this.zRotate=45}else{if(g==36){this.xRotate=45;this.yRotate=0;this.zRotate=0}else{if(g==37){this.xRotate+=this.rotationStep}else{if(g==38){this.yRotate-=this.rotationStep}else{if(g==39){this.xRotate-=this.rotationStep}else{if(g==40){this.yRotate+=this.rotationStep}}}}}}}}break}if(b&&!this.animationOn){this.animationOn=true;this.animate(g)}else{this.draw(false,false,false,true)}};this.animate=function(d){var a=this;var b=function(){this.update=function(){if(!a.animationOn){clearInterval(c)}a.arrowMove(d);switch(a.graphType){case"Network":if(this.is3DNetwork){if(d==33){this.xRotate+=(this.rotationStep*3);this.yRotate-=(this.rotationStep*3)}else{if(d==34){this.xRotate-=(this.rotationStep*3);this.yRotate+=(this.rotationStep*3)}else{if(d==37){this.xRotate-=this.rotationStep}else{if(d==38){this.yRotate-=this.rotationStep}else{if(d==39){this.xRotate+=this.rotationStep}else{if(d==40){this.yRotate+=this.rotationStep}}}}}}}else{if(d==33){this.network2DRotate+=(this.rotationStep*3)}else{if(d==34){this.network2DRotate-=(this.rotationStep*3)}else{if(d==37||d==38){this.network2DRotate-=this.rotationStep}else{if(d==39||d==40){this.network2DRotate+=this.rotationStep}}}}}break;case"Scatter2D":case"ScatterBubble2D":if(d!=37){if(a.graphType=="ScatterBubble2D"&&a.xAxisIndices.length>1&&a.xAxisIndices.length==a.yAxisIndices.length&&a.xAxisIndices.length==a.zAxisIndices.length){if(a.xAxisCurrent>=a.xAxis.length-1){a.xAxisCurrent=a.xAxis.length-1;a.yAxisCurrent=a.yAxis.length-1;a.zAxisCurrent=a.zAxis.length-1;d=37}}else{if(a.xAxisIndices.length>1&&a.xAxisIndices.length==a.yAxisIndices.length){if(a.zAxisCurrent>=a.zAxis.length-1){a.zAxisCurrent=a.zAxis.length-1;d=37}}else{if(a.xAxisIndices.length>a.yAxisIndices.length){if(a.yAxisCurrent>=a.yAxis.length-1){a.yAxisCurrent=a.yAxis.length-1}if(a.zAxisCurrent>=a.zAxis.length-1){a.zAxisCurrent=a.zAxis.length-1}if(a.yAxisCurrent>=a.yAxis.length-1&&a.zAxisCurrent>=a.zAxis.length-1){d=37}}else{if(a.xAxisCurrent>=a.xAxis.length-1){a.xAxisCurrent=a.xAxis.length-1}if(a.zAxisCurrent>=a.zAxis.length-1){a.zAxisCurrent=a.zAxis.length-1}if(a.xAxisCurrent>=a.xAxis.length-1&&a.zAxisCurrent>=a.zAxis.length-1){d=37}}}}}else{if(d!=39){if(a.graphType=="ScatterBubble2D"&&a.xAxisIndices.length>1&&a.xAxisIndices.length==a.yAxisIndices.length&&a.xAxisIndices.length==a.zAxisIndices.length){if(a.xAxisCurrent<=0){a.xAxisCurrent=0;a.yAxisCurrent=0;a.zAxisCurrent=0;d=39}}else{if(a.xAxisIndices.length>1&&a.xAxisIndices.length==a.yAxisIndices.length){if(a.zAxisCurrent<=0){a.zAxisCurrent=0;d=39}}else{if(a.xAxisIndices.length>a.yAxisIndices.length){if(a.yAxisCurrent<=0){a.yAxisCurrent=0}if(a.zAxisCurrent<=0){a.zAxisCurrent=0}if(a.yAxisCurrent<=0&&a.zAxisCurrent<=0){d=39}}else{if(a.xAxisCurrent<=0){a.xAxisCurrent=0}if(a.zAxisCurrent<=0){a.zAxisCurrent=0}if(a.xAxisCurrent<=0&&a.zAxisCurrent<=0){d=39}}}}}}break;case"Scatter3D":if(a.xRotate<=0&&(d==39||d<37)){a.xRotate=0;a.yRotate=0;d=40}else{if(a.xRotate>=90&&(d==37||d<37)){a.xRotate=90;a.yRotate=90;d=38}else{if(a.yRotate<=0&&(d==38||d<37)){a.yRotate=0;a.xRotate=90;d=39}else{if(a.yRotate>=90&&(d==40||d<37)){a.yRotate=90;a.xRotate=0;d=37}}}}break}};var c=setInterval(this.update,a.animationTime)};b.call()};this.setGraphType=function(b){var a;if(b==66){a="Bar"}else{if(b==76){a="Line"}else{if(b==65){a="Area"}else{if(b==67){a="BarLine"}else{if(b==73){a="Boxplot"}else{if(b==68){a="Dotplot"}else{if(b==72){a="Heatmap"}else{if(b==83){a="Stacked"}else{if(b==85){a="StackedLine"}else{if(b==84){a="StackedPercent"}else{if(b==87){a="StackedPercentLine"}else{if(b==50){a="Scatter2D"}else{if(b==52){a="ScatterBubble2D"}else{if(b==51){a="Scatter3D"}else{if(b==88){a="Correlation"}else{if(b==86){a="Venn"}else{if(b==80){a="Pie"}else{if(b==78){a="Network"}else{if(b==71){a="Genome"}else{if(b==77){a="Candlestick"}}}}}}}}}}}}}}}}}}}}if(a&&this.isValidGraphType(a)){this.graphType=a;this.draw()}else{alert("Dude! You cannot plot this data in a "+a+" graph")}};this.redraw=function(){this.setInitialConfig();switch(this.graphType){case"Area":case"AreaLine":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Correlation":case"Venn":case"Pie":this.setAllVariablesVisible();this.setAllSamplesVisible();return true;case"Bar":case"Line":case"BarLine":case"Boxplot":case"Dotplot":case"Genome":case"Candlestick":this.setAllVariablesVisible();this.setAllSamplesVisible();this.setMin=null;this.setMax=null;this.setMin2=null;this.setMax2=null;break;case"Scatter2D":case"ScatterBubble2D":this.resetSelectedDataPoints();this.setAllVariablesVisible();this.setAllSamplesVisible();this.setMinX=null;this.setMaxX=null;this.setMinY=null;this.setMaxY=null;break;case"Scatter3D":this.resetSelectedDataPoints();this.setAllVariablesVisible();this.setAllSamplesVisible();this.xRotate=45;this.yRotate=0;break;case"Heatmap":this.setAllVariablesVisible();this.setAllSamplesVisible();this.varIndicesStart=-1;this.smpIndicesStart=-1;break;case"Network":this.resetSelectedNodes();this.setAllNodesVisible();this.network2DRotate=0;if(this.randomNetwork){this.layoutDone=false}this.ctx.translate(-this.offsetX,-this.offsetY);this.ctx.scale(1/this.scaleFactor,1/this.scaleFactor);break}this.draw();return true};this.resetZoomPan=function(){this.zoom=1;this.panningX=0;this.panningY=0;this.panningGlobalX=0;this.panningGlobalY=0};this.masterReset=function(a){this.resetDragDiv(a);this.resetSelectedDataPoints();this.resetSelectedNodes();this.hideUnhideDataTable(true);this.resetConfigurator();this.resetAxesResizer(a);this.resetFlags(a);this.resetZoomPan();this.redraw()}};CanvasXpress.prototype.initDraggingEvents=function(){this.addDragDiv=function(){if(document.getElementById(this.target+"canvasXpressDrag")){return}var a=document.createElement("div");a.id=this.target+"canvasXpressDrag";a.style.width="0.5px";a.style.height="0.5px";a.style.opacity=0.5;a.style.filter="alpha(opacity = 50)";a.style.backgroundColor=this.dragAreaColor;a.style.position="absolute";a.style.zIndex=9000;this.canvas.parentNode.appendChild(a)};this.registerDragDivNetwork=function(k){var d,h,g;var j=this.modelEvent!="local"?this.isEvent(k,true):false;var b=k.target||k.srcElement;var a=this.modelEvent!="local"?j[1]:b.id;var c=false;if(a&&a.match(/-legend-/)){if(a.match(/-legend-Nodes/)){this.moveLegend="Nodes"}else{if(a.match(/-legend-Edges/)){this.moveLegend="Edges"}else{this.moveLegend=a.split(/-legend-/)[1]}}c=true}else{if(a&&a.match(/-lab$/)){if(k.shiftKey){d=this.modelEvent!="local"?j[0][0]:parseInt(a.split(/-lab/)[0].replace(this.target,""));h=true}else{if(this.modelEvent!="local"){d=j[0][0]}else{d=this.isEvent(k);d=parseInt(d.split(/-/)[0].replace(this.target,""))}}}else{if(a&&a.match(/-dec$/)){if(k.shiftKey){d=this.modelEvent!="local"?j[0][0]:parseInt(a.split(/-dec/)[0].replace(this.target,""));g=true}else{this.resetDragDiv(k);this.resetFlags(k)}}else{if(this.modelEvent!="local"){d=j?j[0][0]:"NaN"}else{d=this.isEvent(k);if(d){d=parseInt(d.split(/-/)[0].replace(this.target,""))}else{d=parseInt(a.replace(this.target,""))}}}}if(!isNaN(d)&&d<this.data.nodes.length){b.style.cursor="move";this.moveNode=true;this.moveNodeIndex=d;if(h){this.moveNodeLab=true}else{if(g){this.moveNodeDec=true}}var f=this.data.nodes[this.moveNodeIndex];this.moveNodeW=f.width?f.width:f.size?(this.nodeSize*f.size):this.nodeSize;this.moveNodeH=f.height?f.height:f.size?(this.nodeSize*f.size):this.nodeSize;if(this.moveNodeLab){this.moveNodeX=f.labelX!=null?f.labelX-((this.xMouseDown/this.scaleFactor)-this.offsetX):0;this.moveNodeY=f.labelY!=null?f.labelY-((this.yMouseDown/this.scaleFactor)-this.offsetY):0}else{if(this.moveNodeDec){this.moveNodeX=f.decorationsX?f.decorationsX-((this.xMouseDown/this.scaleFactor)-this.offsetX):0;this.moveNodeY=f.decorationsY?f.decorationsY-((this.yMouseDown/this.scaleFactor)-this.offsetY):0}else{if(this.is3DNetwork){this.moveNodeX=f.x3d-((this.xMouseDown/this.scaleFactor)-this.offsetX);this.moveNodeY=f.y3d-((this.yMouseDown/this.scaleFactor)-this.offsetY)}else{this.moveNodeX=f.x-((this.xMouseDown/this.scaleFactor)-this.offsetX);this.moveNodeY=f.y-((this.yMouseDown/this.scaleFactor)-this.offsetY)}}}c=true}}if(c){this.addToNetworkStack()}};this.registerDragDiv=function(k){if(!k){k=window.event}if(this.isCanvasResize(k)){this.resizingCanvasOn=true}else{if(!k){return}var p=this.adjustedCoordinates(k);if(p){var a=p.x;var q=p.y;var o=0;for(var f=0;f<this.layoutRows;f++){for(var b=0;b<this.layoutCols;b++){var h=this.layoutComb?this.layoutParams[o].graphType:this.graphType;if(h.match(/Correlation|Pie|Venn|Stacked|Area/)){return false}var n=this.getBoundsXY(o);if(a>=n[0]&&a<=n[1]&&q>=n[2]&&q<=n[3]){this.skipClick=false;this.draggingOn=true;this.xMouseDown=a;this.yMouseDown=q;var m=document.getElementById(this.target+"canvasXpressDrag");if(h=="Network"){this.registerDragDivNetwork(k)}if((!h.match(/Scatter|Heatmap|Network|Genome/)&&this.graphOrientation=="vertical"&&!k.shiftKey)||(!h.match(/Scatter|Heatmap|Network|Genome/)&&this.graphOrientation!="vertical"&&k.shiftKey)){m.style.left=n[0]+"px"}else{m.style.left=this.xMouseDown+"px"}if((!h.match(/Scatter|Heatmap|Network|Genome/)&&this.graphOrientation!="vertical"&&!k.shiftKey)||(!h.match(/Scatter|Heatmap|Network|Genome/)&&this.graphOrientation=="vertical"&&k.shiftKey)||h=="Genome"){m.style.top=n[2]+"px"}else{m.style.top=this.yMouseDown+"px"}if(this.layoutValid){this.layoutValidR=f;this.layoutValidC=b;this.layoutValidN=o}return false}o++}}}}};this.updateDragDivScatter3D=function(d,u,g,e,m){if(!this.rotatingOn){this.rotatingOn=new Date().getTime();var k=this;var b=this.xMouseDown;var o=this.yMouseDown;var a=d;var n=u;var f=this.lineLength(b,o,a,n);var r=this.layoutComb?this.layoutParams[m].x:this.x;var h=this.layoutComb?this.layoutParams[m].y:this.y;var v=((a-b)*this.rotationSensitivity)/r;var s=((n-o)*this.rotationSensitivity)/h;var q=(f*this.rotationSensitivity)/r;this.xRotate-=v;this.yRotate+=s;this.zRotate-=q;this.draw();this.rotatingOn=true;this.skipClick=false;var p=function(){this.update=function(){var j=new Date().getTime();if(j-k.rotatingOn>k.rotationDelay){k.rotatingOn=false;clearInterval(c)}};var c=setInterval(this.update,20)};p.call()}};this.updateDragDivNetwork=function(n,f,v,k,g,o){this.movingOn=true;var q=f;var p=v;var d,z,u,s;var a=n.target||n.srcElement;if(this.moveNode||this.moveLegend){if(this.moveLegend){if(this.moveLegend=="Nodes"){z=this.data.legend.pos.nodes.x-((q/this.scaleFactor)-this.offsetX);u=this.data.legend.pos.nodes.y-((p/this.scaleFactor)-this.offsetY);this.data.legend.pos.nodes.x-=z;this.data.legend.pos.nodes.y-=u}else{if(this.moveLegend=="Edges"){z=this.data.legend.pos.edges.x-((q/this.scaleFactor)-this.offsetX);u=this.data.legend.pos.edges.y-((p/this.scaleFactor)-this.offsetY);this.data.legend.pos.edges.x-=z;this.data.legend.pos.edges.y-=u}else{s=parseInt(this.moveLegend.replace("Text",""));z=this.data.legend.text[s].x-((q/this.scaleFactor)-this.offsetX);u=this.data.legend.text[s].y-((p/this.scaleFactor)-this.offsetY);this.data.legend.text[s].x-=z;this.data.legend.text[s].y-=u}}}else{if(this.data.nodes[this.moveNodeIndex]){d=this.data.nodes[this.moveNodeIndex];if(this.is3DNetwork){z=(d.x3d-((q/this.scaleFactor)-this.offsetX))-this.moveNodeX;u=(d.y3d-((p/this.scaleFactor)-this.offsetY))-this.moveNodeY}else{z=(d.x-((q/this.scaleFactor)-this.offsetX))-this.moveNodeX;u=(d.y-((p/this.scaleFactor)-this.offsetY))-this.moveNodeY}if(this.moveNodeLab){z=d.labelX!=null?(d.labelX-((q/this.scaleFactor)-this.offsetX))-this.moveNodeX:z;u=d.labelY!=null?(d.labelY-((p/this.scaleFactor)-this.offsetY))-this.moveNodeY:u;this.modifyXYNodeLab(d.id,z,u)}else{if(this.moveNodeDec){z=d.decorationsX?(d.decorationsX-((q/this.scaleFactor)-this.offsetX))-this.moveNodeX:z;u=d.decorationsY?(d.decorationsY-((p/this.scaleFactor)-this.offsetY))-this.moveNodeY:u;this.modifyXYNodeDec(d.id,z,u)}else{if(n.shiftKey){var r=(this.moveNodeW-z)+((f-this.xMouseDown)/this.scaleFactor);var m=(this.moveNodeH-u)+((v-this.yMouseDown)/this.scaleFactor);this.modifyNodeSize(d.id,Math.abs(r),Math.abs(m));for(var s in this.selectNode){if(s!=d.id){this.modifyNodeSize(s,r,m)}}}else{this.modifyXYNode(d.id,z,u);for(var s in this.selectNode){if(s!=d.id){this.modifyXYNode(s,z,u)}}}}}}}}else{this.panningX=((f-this.xMouseDown)/this.scaleFactor);this.panningY=((v-this.yMouseDown)/this.scaleFactor)}this.skipClick=z!=null||u!=null?true:false;this.draw(false,false,false,true);if(this.is3DNetwork&&d){this.moveNodeIndex=this.data.nodeIndices[d.id]}var b=document.getElementById(a.id);if(b){b.style.cursor=n.shiftKey?"se-resize":"move"}};this.updateDragDiv=function(k){if(this.draggingOn){if(!k){k=window.event}if(this.resetOn){this.resetOn=false;this.stopEvent(k);return}var p=this.adjustedCoordinates(k);if(p){var a=p.x;var q=p.y;var f=this.layoutValidR;var b=this.layoutValidC;var o=this.layoutValidN;var h=this.layoutComb?this.layoutParams[o].graphType:this.graphType;if(h.match(/Correlation|Pie|Venn|Stacked|Area/)){return false}if(h=="Scatter3D"&&!k.shiftKey){this.updateDragDivScatter3D(a,q,f,b,o)}else{if(h=="Network"&&((this.moveNode||this.moveLegend)||(!k.ctrlKey&&!k.shiftKey&&!k.altKey))){this.updateDragDivNetwork(k,a,q,f,b,o)}else{var n=this.getBoundsXY(o);var m=document.getElementById(this.target+"canvasXpressDrag");this.skipClick=true;if((!h.match(/Scatter|Heatmap|Network|Genome/)&&this.graphOrientation=="vertical"&&!k.shiftKey)||(!h.match(/Scatter|Heatmap|Network|Genome/)&&this.graphOrientation!="vertical"&&k.shiftKey)){m.style.width=(n[1]-n[0])+"px"}else{if(a>this.xMouseDown){if(a>n[1]){m.style.width=(n[1]-this.xMouseDown)+"px"}else{m.style.width=(a-this.xMouseDown)+"px"}}else{if(a<n[0]){m.style.left=n[0]+"px";m.style.width=(this.xMouseDown-n[0])+"px"}else{m.style.left=a+"px";m.style.width=(this.xMouseDown-a)+"px"}}}if((!h.match(/Scatter|Heatmap|Network|Genome/)&&this.graphOrientation!="vertical"&&!k.shiftKey)||(!h.match(/Scatter|Heatmap|Network|Genome/)&&this.graphOrientation=="vertical"&&k.shiftKey)||h=="Genome"){m.style.height=(n[3]-n[2])+"px"}else{if(q>this.yMouseDown){if(q>n[3]){m.style.height=(n[3]-this.yMouseDown)+"px"}else{m.style.height=(q-this.yMouseDown)+"px"}}else{if(q<n[2]){m.style.top=n[2]+"px";m.style.height=(this.yMouseDown-n[2])+"px"}else{m.style.top=q+"px";m.style.height=(this.yMouseDown-q)+"px"}}}}}}this.movingOn=true;this.resetOn=false}};this.endDragDiv=function(j){if(this.draggingOn){var q=this.layoutComb?this.layoutParams[this.layoutValidN].graphType:this.graphType;if(q.match(/Correlation|Pie|Venn|Stacked|Area/)){return false}if(!j){j=window.event}var m=document.getElementById(this.target+"canvasXpressImage");if(m){m.style.cursor="default";var b=j.target||j.srcElement;if(b&&b.style){b.style.cursor="default"}}this.panningGlobalX+=this.panningX;this.panningGlobalY+=this.panningY;this.panningX=0;this.panningY=0;if(q=="Scatter3D"&&!j.shiftKey){this.resetDragDiv(j)}else{if(q=="Network"&&(this.moveNode||this.moveLegend)){if(m){if(this.isSelectNodes&&this.movingOn){this.resetSelectedNodes();this.draw()}if(this.userEvents.enddragnode&&this.movingOn){var h;if(this.moveLegend){h={legend:this.moveLegend}}else{var p=this.moveNodeIndex;var a=this.findChildrenNodeIndices(this.data.nodes[p].id);if(a){a.push(p)}else{a=[p]}h=this.extractDataObject(a)}this.resetDragDiv(j);this.userEvents.enddragnode.call(this,h)}else{this.resetDragDiv(j)}}}else{if(this.movingOn){var s=this.adjustedCoordinates(j);if(s){var g=s.x;var r=s.y;if(g!=this.xMouseDown||r!=this.yMouseDown){var k=document.getElementById(this.target+"canvasXpressDrag");var f=parseInt(k.style.left);var o=parseInt(k.style.top);var c=f+parseInt(k.style.width);var n=o+parseInt(k.style.height);this.handleDragEvent(j,f,o,c,n);this.resetDragDiv(j)}}}else{this.resetDragDiv(j)}}}}else{this.resetDragDiv(j)}};this.validateMinMax=function(b,a){if(!isNaN(b)&&!isNaN(a)){if(b>a){return false}return true}else{return false}};this.isObjectInsideCoordiantes=function(b,g,d,m,c,j){var k,h;switch(b){case"rect":k=(g[0]+g[2])/2;h=(g[1]+g[3])/2;break;case"circle":k=g[0];h=g[1];break;case"poly":var e=[];var a=[];for(var f=0;f<g.length;f++){if(f%2){a.push(g[f])}else{e.push(g[f])}}e.sort(function(o,n){return(o-n)});a.sort(function(o,n){return(o-n)});k=(e[0]+e[e.length-1])/2;h=(a[0]+a[a.length-1])/2;break}return this.isPointInsideArea("rect",k,h,[d,m,c,j])};this.handleDragEventNetwork=function(r,f,z,c,x){var g={};var p=[];var B=[];var A=[];var u=[];var y={};if(this.modelEvent=="local"){var j=document.getElementById(this.target+"canvasXpressMap");if(j){var v=j.childNodes;for(var o=0;o<v.length;o++){var k=this.toNumber(v[o].id.replace(this.target,""));var q=this.toNumber(v[o].coords.split(","));var b=v[o].shape;if(this.isObjectInsideCoordiantes(b,q,f,z,c,x)){if(k<this.data.nodes.length){g[k]=1}}}}}else{for(var o=0;o<this.dataEvent.length;o++){var k=this.dataEvent[o][0];var b=this.dataEvent[o][1];var q=this.dataEvent[o][2];if(this.isObjectInsideCoordiantes(b,q,f,z,c,x)){if(k<this.data.nodes.length){g[k]=1}}}}for(var o=0;o<this.data.nodes.length;o++){if(!g[o]){p.push(this.data.nodes[o].id)}else{B.push(this.data.nodes[o].id);A.push(o)}}if(p.length<this.data.nodes.length){if(r.shiftKey){this.setSelectNodes(B);this.isSelectNodes=B.length;this.draw()}else{this.resetZoomPan();this.hideUnhideNodes(p,true);this.ctx.translate(-this.offsetX,-this.offsetY);this.ctx.scale(1/this.scaleFactor,1/this.scaleFactor);this.draw(false,false,false,true)}if(this.showDataTableOnSelect){if(this.networkShowDataTable=="edges"){for(var o=0;o<B.length;o++){y[B[o]]=1}for(var o=0;o<this.data.edges.length;o++){if(y[this.data.edges[o].id1]||y[this.data.edges[o].id2]){u.push(this.data.nodes.length+o)}}this.updateDataTable(this.extractDataObject(u))}else{this.updateDataTable(this.extractDataObject(A))}}}};this.setOriginalIndices=function(e,d,a){if(!d){d=this.layoutComb?this.layoutParams[e].varIndices:this.varIndices}if(!a){if(this.isGroupedData){a=this.layoutComb?this.layoutParams[e].grpIndices:this.grpIndices}else{a=this.layoutComb?this.layoutParams[e].smpIndices:this.smpIndices}}if(!this.startingVarIndices){this.startingVarIndices=[]}if(!this.startingSmpIndices){this.startingSmpIndices=[]}if(!this.startingVarIndices[e]){this.startingVarIndices[e]=[];for(var b=0;b<d.length;b++){this.startingVarIndices[e][b]=d[b]}}if(!this.startingSmpIndices[e]){this.startingSmpIndices[e]=[];for(var b=0;b<a.length;b++){this.startingSmpIndices[e][b]=a[b]}}};this.handleDragEventHeatmap=function(k,e,q,b,p){var r=[];var w=[];var u;this.resetAxesResizer();var t=this.layoutComb?this.layoutParams[k].varIndices:this.varIndices;if(this.isGroupedData){u=this.layoutComb?this.layoutParams[k].grpIndices:this.grpIndices}else{u=this.layoutComb?this.layoutParams[k].smpIndices:this.smpIndices}this.setOriginalIndices(k,t,u);if(this.layoutComb){this.varIndicesStart=this.layoutParams[k].varIndicesStart<0?0:this.layoutParams[k].varIndicesStart;this.smpIndicesStart=this.layoutParams[k].smpIndicesStart<0?0:this.layoutParams[k].smpIndicesStart}else{this.varIndicesStart=this.varIndicesStart<0?0:this.varIndicesStart;this.smpIndicesStart=this.smpIndicesStart<0?0:this.smpIndicesStart}this.varIndices=[];if(this.isGroupedData){this.grpIndices=[]}else{this.smpIndices=[]}if(this.modelEvent=="local"){var f=document.getElementById(this.target+"canvasXpressMap");if(f){var n=f.childNodes;for(var h=0;h<n.length;h++){var g=this.toNumber(n[h].id.replace(this.target,"").split(","));var j=this.toNumber(n[h].coords.split(","));if((e<j[0]||e<j[2])&&b>j[0]&&(q<j[1]||q<j[3])&&p>j[1]){if(!r[g[0]]){this.varIndices.push(g[0]);r[g[0]]=1}if(!w[g[1]]){if(this.isGroupedData){this.grpIndices.push(g[1])}else{this.smpIndices.push(g[1])}w[g[1]]=1}}}}}else{for(var h=0;h<this.dataEvent.length;h++){var g=this.dataEvent[h][0];var j=this.dataEvent[h][2];if((e<j[0]||e<j[2])&&b>j[0]&&(q<j[1]||q<j[3])&&p>j[1]){if(!r[g[0]]){this.varIndices.push(g[0]);r[g[0]]=1}if(!w[g[1]]){if(this.isGroupedData){this.grpIndices.push(g[1])}else{this.smpIndices.push(g[1])}w[g[1]]=1}}}}for(var h=0;h<t.length;h++){if(t[h]==this.varIndices[0]){this.varIndicesStart+=h}}for(var h=0;h<u.length;h++){if(this.isGroupedData){if(u[h]==this.grpIndices[0]){this.smpIndicesStart+=h}}else{if(u[h]==this.smpIndices[0]){this.smpIndicesStart+=h}}}this.draw();if(this.showDataTableOnSelect){var d=this.extractDataObject(this.smpIndices,this.varIndices);this.updateDataTable(d)}this.skipClick=false};this.handleDragEventScatter=function(D,f,E,C,p,A,n){this.selectDataPoint=[];var b={v:{},s:{}};var t=0;if(D.shiftKey){if(this.modelEvent=="local"){var v=document.getElementById(this.target+"canvasXpressMap");if(v){var F=v.childNodes;for(var y=0;y<F.length;y++){var r=this.toNumber(F[y].id.replace(this.target,""));var q=this.toNumber(F[y].coords.split(","));var z=F[y].shape;if(this.isObjectInsideCoordiantes(z,q,C,p,A,n)){this.addRemoveToSelectedDataPoints(f,r);b.v[r.shift()]=1;for(var x=0;x<r.length;x++){b.s[r[x]]=1}t++}}}}else{for(var y=0;y<this.dataEvent.length;y++){var r=this.dataEvent[y][0];var z=this.dataEvent[y][1];var q=this.dataEvent[y][2];if(this.isObjectInsideCoordiantes(z,q,C,p,A,n)){this.addRemoveToSelectedDataPoints(f,r);b.v[r.shift()]=1;for(var x=0;x<r.length;x++){b.s[r[x]]=1}t++}}}if(t>0){this.isSelectDataPoints=t;this.draw();if(this.showDataTableOnSelect){var w=[];var B=[];for(y in b.v){w.push(parseInt(y))}for(y in b.s){B.push(parseInt(y))}w.sort(function(e,c){return(e-c)});B.sort(function(e,c){return(e-c)});var u=this.extractDataObject(B,w);this.updateDataTable(u)}}}else{var u=this.layoutComb?this.layoutParams[E]:this;var k=u.xAxisMin+((C-(this.marginLeft+u.offsetX+u.left))/u.xAxisUnit);var h=u.xAxisMin+((A-(this.marginLeft+u.offsetX+u.left))/u.xAxisUnit);var d=u.yAxisMax-((p-(this.marginTop+u.offsetY+u.top))/u.yAxisUnit);var g=u.yAxisMax-((n-(this.marginTop+u.offsetY+u.top))/u.yAxisUnit);if(this.validateMinMax(k,h)&&this.validateMinMax(g,d)){this.setMinX=k;this.setMaxX=h;this.setMaxY=d;this.setMinY=g;this.draw()}}};this.handleDragEventGenome=function(j,d,f,b,e){var a,h;var g=this.layoutComb?this.layoutParams[j]:this;var a=g.xAxisMin+((d-(this.marginLeft+g.offsetX+g.left))/g.xAxisUnit);var h=g.xAxisMin+((b-(this.marginLeft+g.offsetX+g.left))/g.xAxisUnit);if(this.validateMinMax(a,h)){this.setMin=a;this.setMax=h;this.draw()}};this.handleDragEventOneDimension=function(A,b,E,y,f,x,d,H){if(A.shiftKey||H){var n=[];var F=[];if(this.modelEvent=="local"){var q=document.getElementById(this.target+"canvasXpressMap");if(q){var G=q.childNodes;for(var u=1;u<G.length;u++){var h=this.toNumber(G[u].id.replace(this.target,"").split(","));var g=this.toNumber(G[u].coords.split(","));var v=G[u].shape;if(this.isObjectInsideCoordiantes(v,g,y,f,x,d)){if(!n[h[1]]){F.push(h[1]);n[h[1]]=1}}}}}else{for(var u=0;u<this.dataEvent.length;u++){var h=this.dataEvent[u][0];var v=this.dataEvent[u][1];var g=this.dataEvent[u][2];if(this.isObjectInsideCoordiantes(v,g,y,f,x,d)){if(!n[h[1]]){F.push(h[1]);n[h[1]]=1}}}}this.setSamplesVisible(F,true);this.draw();if(this.showDataTableOnSelect){var p=this.extractDataObject(F,this.varIndices);this.updateDataTable(p)}}else{var p=this.layoutComb?this.layoutParams[E]:this;var k=b=="Candlestick"&&E>0&&this.showVolume;var j=this.layoutComb&&this.layoutCurrent!=E;var r=k&&j?p.xAxis2Min:p.xAxisMin;var w=k&&j?p.xAxis2Max:p.xAxisMax;var D=this.marginLeft+p.offsetX+p.left;var C=D+p.x;var B=this.marginTop+p.offsetY+p.top;var z=B+p.y;if(this.graphOrientation=="vertical"){r=k?r+((z-d)/p.xAxis2Unit):r+((z-d)/p.xAxisUnit);w=k?w-((f-B)/p.xAxis2Unit):w-((f-B)/p.xAxisUnit)}else{r=k?r+((y-D)/p.xAxis2Unit):r+((y-D)/p.xAxisUnit);w=k?w-((C-x)/p.xAxis2Unit):w-((C-x)/p.xAxisUnit)}if(this.validateMinMax(r,w)){if(k){this.setMin2=r;this.setMax2=w}else{this.setMin=r;this.setMax=w}this.draw()}}};this.handleDragEvent=function(h,b,f,a,d){var j=this.layoutComb?this.layoutValidN:0;var g=this.layoutComb?this.layoutParams[j].graphType:this.graphType;if(g=="Network"){this.handleDragEventNetwork(h,b,f,a,d)}else{if(g=="Heatmap"){this.handleDragEventHeatmap(j,b,f,a,d)}else{if(g.match(/Scatter/)){this.handleDragEventScatter(h,g,j,b,f,a,d)}else{if(g=="Genome"){this.handleDragEventGenome(j,b,f,a,d)}else{this.handleDragEventOneDimension(h,g,j,b,f,a,d)}}}}};this.resetDragDiv=function(a){var b=document.getElementById(this.target+"canvasXpressDrag");if(b){b.style.left="0px";b.style.top="0px";b.style.width="0px";b.style.height="0px"}};this.initializeDraggingEvents=function(){if(!this.disableEvents){this.addDragDiv()}};this.initializeDraggingEvents()};CanvasXpress.prototype.initInfoEvents=function(){this.addInfoSpan=function(){if(document.getElementById(this.target+"canvasXpressInfo")){this.resetInfoSpan();return}var a=document.createElement("span");a.id=this.target+"canvasXpressInfo";a.style.backgroundColor=this.infoAreaColor;a.style.margin="1px 3px";a.style.padding="1px 3px";a.style.fontSize="x-small";a.style.border="1px solid";a.style.borderColor=this.background;a.style.position="absolute";a.style.display="none";a.style.zIndex=29010;this.canvas.parentNode.appendChild(a);this.addInfoSpanShadow()};this.addInfoSpanShadow=function(){if(document.getElementById(this.target+"canvasXpressInfoShadow")){return}var a=document.createElement("div");a.id=this.target+"canvasXpressInfoShadow";a.style.backgroundColor="#000000";a.style.margin="1px";a.style.padding="1px";a.style.fontSize="x-small";a.style.border="1px solid";a.style.borderColor="#999999";a.style.position="absolute";a.style.display="none";a.style.zIndex=19009;a.style.msFilter="progid:DXImageTransform.Microsoft.Alpha(Opacity=25)";a.style.filter="progid:DXImageTransform.Microsoft.Alpha(opacity=25)";a.style.mozOpacity=0.25;a.style.opacity=0.25;this.canvas.parentNode.appendChild(a)};this.resetInfoSpan=function(g,c){var b=document.getElementById(this.target+"canvasXpressInfo");var h=document.getElementById(this.target+"canvasXpressInfoShadow");if(b&&h&&this.infoStartTime){var a=new Date().getTime()-this.infoStartTime;if(a>100||c){b.style.left="0px";b.style.top="0px";b.style.borderColor=this.background;b.style.display="none";b.innerHTML="";h.style.left="0px";h.style.top="0px";h.style.borderColor="black";h.style.display="none";h.innerHTML=""}}};this.showInfoSpan=function(b,j,a){if(this.draggingOn||this.remoteUpdating){return}var n=document.getElementById(this.target+"canvasXpressInfo");var c=document.getElementById(this.target+"canvasXpressInfoShadow");if(n&&c&&j){var m=this.adjustedCoordinates(b,n);if(m){var g=m.x;var f=b?m.y:m.y+25;n.style.borderColor=j.match("</table>")?this.background:this.foreground;n.style.left=(g+5)+"px";n.style.top=(f-20)+"px";n.style.display="inline";n.innerHTML=j;c.style.left=(g+15)+"px";c.style.top=(f-17)+"px";c.style.display="inline";c.innerHTML=j;this.infoStartTime=new Date().getTime();var k=this;var h=function(){this.update=function(){var e=new Date().getTime();if(e-k.infoStartTime>k.infoTimeOut){k.resetInfoSpan();clearInterval(d)}};var d=setInterval(this.update,100)};h.call()}}};this.initializeInfoEvents=function(){if(!this.disableEvents){this.addInfoSpan()}};this.initializeInfoEvents()};CanvasXpress.prototype.initImageMapEvents=function(){this.addImage=function(){if(document.getElementById(this.target+"canvasXpressImage")){return}var b=document.getElementById(this.target);var a=document.createElement("img");a.id=this.target+"canvasXpressImage";a.src=this.getPixelImage();a.width=this.width;a.height=this.height;a.useMap="#"+this.target+"canvasXpressMap";a.style.left="0px";a.style.top="0px";a.style.border="0px";a.style.position="absolute";a.style.zIndex=9000;this.canvas.parentNode.appendChild(a)};this.resizeImage=function(c){var b=document.getElementById("wrapper-"+this.target);var e=document.getElementById(this.target+"canvasXpressImage");var a=this.graphType=="Network"?0:this.marginLeft+this.offsetX+this.left;var d=this.graphType=="Network"?0:this.marginTop+this.offsetY+this.top;if(b&&e){b.style.width=this.width+"px";b.style.height=this.height+"px";e.style.left="0px";e.style.top="0px";e.style.width=this.width+"px";e.style.height=this.height+"px";if(!c){if(this.modelEvent=="global"){this.addGlobalArea(["rect",a,d,a+this.x,d+this.y])}}}};this.mousedownImage=function(a){return function(c){if(c){var b;if(c.which){b=(c.which==3)}else{if(c.button){b=(c.button==2)}}if(b){if(a.Ext){return}else{}}else{if(!a.configuringOn){a.cancelEvent(c);a.registerDragDiv(c)}}}return false}}(this);this.clickImage=function(a){return function(c){if(!a.configuringOn){if(a.isHelp(c)){a.stopEvent(c);a.showInfoSpan(c,'Modify "helpKeyEvents"<br>&nbsp;&nbsp;&nbsp;to show or hide help<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;on key events"')}else{if(a.isAxis(c)){a.stopEvent(c)}else{if(a.axesResizerShow&&!a.resizerType){a.stopEvent(c);a.resetAxesResizer(c)}else{if(a.mobileApp){return false}else{var b=a.getEventAreaId(c);if(b){a.handleMouseAreaEvents("click",c,b)}}}}}}else{a.resetConfigurator()}}}(this);this.dblclickImage=function(a){return function(c){var b=a.getEventAreaId(c);if(b){a.handleMouseAreaEvents("dblclick",c,b)}else{a.cancelEvent(c);a.addConfigurator(c)}return false}}(this);this.wheelImage=function(a){return function(b){var c=0;if(!b){b=window.event}if(b.wheelDelta){c=b.wheelDelta/120;if(window.opera){c=-c}}else{if(b.detail){c=-b.detail/3}}if(c){a.handleWheelEvent(b,c)}}}(this);this.addRemoveCanvasListeners=function(b){var a=document.getElementById(this.target+"canvasXpressImage");if(a){this[b](a,"mousedown",this.mousedownImage,false);this[b](a,"click",this.clickImage,false);this[b](a,"dblclick",this.dblclickImage,false);this[b](a,"mousewheel",this.wheelImage,false);this[b](this.canvas,"click",this.clickImage,false)}};this.isVersion=function(b){if(this.showVersion){var a=this.adjustedCoordinates(b);return a&&a.x>0&&a.x<=10&&a.y>0&&a.y<=10?true:false}};this.isHelp=function(b){var a=this.adjustedCoordinates(b);return a&&a.x>0&&a.x<=10&&a.y>0&&a.y<=10?true:false};this.handleWheelEvent=function(g,j){if(this.graphType=="Network"){this.cancelEvent(g);var b=this.networkFreeze?this.scaleFactor*this.zoomStep:this.zoom*this.zoomStep;if(this.networkFreeze){this.scaleFactor=j>0?this.scaleFactor+b:this.scaleFactor-b;this.widthBounds=this.x/this.scaleFactor;this.heightBounds=this.y/this.scaleFactor}else{this.zoom=j>0?this.zoom+b:this.zoom-b}this.draw(false,false,false,true)}else{if(this.graphType=="Heatmap"){this.cancelEvent(g);this.resetAxesResizer(g);var k=this.layoutComb?this.layoutValidN:0;var a;var h=this.layoutComb?this.layoutParams[k].varIndices:this.varIndices;var f=this.isGroupedData?this.grpIndices:this.smpIndices;if(this.isGroupedData){a=this.layoutComb?this.layoutParams[k].grpIndices:this.grpIndices}else{a=this.layoutComb?this.layoutParams[k].smpIndices:this.smpIndices}this.setOriginalIndices(k,h,a);if(j>0){if(h.length>3){this.varIndices.shift();this.varIndices.pop();if(this.varIndicesStart<0){this.varIndicesStart++}this.varIndicesStart++}if(a.length>3){f.shift();f.pop();if(this.smpIndicesStart<0){this.smpIndicesStart++}this.smpIndicesStart++}}else{if(this.varIndicesStart>0){this.varIndices.unshift(this.startingVarIndices[k][this.varIndicesStart-1]);this.varIndicesStart--}if(this.varIndicesStart>=0&&this.varIndicesStart+h.length<this.startingVarIndices[k].length){this.varIndices.push(this.startingVarIndices[k][this.varIndicesStart+h.length])}if(this.smpIndicesStart>0){f.unshift(this.startingSmpIndices[k][this.smpIndicesStart-1]);this.smpIndicesStart--}if(this.smpIndicesStart>=0&&this.smpIndicesStart+a.length<this.startingSmpIndices[k].length){f.push(this.startingSmpIndices[k][this.smpIndicesStart+a.length])}}this.draw()}}return false};this.addMap=function(){if(document.getElementById(this.target+"canvasXpressMap")){return this.resetMap()}var a=document.createElement("map");a.name=this.target+"canvasXpressMap";a.id=this.target+"canvasXpressMap";this.canvas.parentNode.appendChild(a);this.addArea(["rect",0,0,10,10],[-1],false,0)};this.setLayoutValidIndices=function(k){if(this.layoutComb){var h=this.adjustedCoordinates(k);if(h){var a=h.x;var g=h.y;var m=0;for(var f=0;f<this.layoutRows;f++){for(var d=0;d<this.layoutCols;d++){var b=this.getBoundsXY(m);if(a>=b[0]&&a<=b[1]&&g>=b[2]&&g<=b[3]){if(this.layoutValid){this.layoutValidR=f;this.layoutValidC=d;this.layoutValidN=m}}m++}}}}};this.getNetworkEventAreaId=function(h){if(this.modelEvent=="local"){var b=h.target||h.srcElement;if(b){var c=b.id;var g;if(c.match(/-legend-/)){if(c.match(/-legend-Nodes/)){return false}else{if(c.match(/-legend-Edges/)){return false}else{return false}}}else{if(c.match(/-lab$|-dec$/)){g=this.isEvent(h);if(g){return[parseInt(g.split(/-/)[0].replace(this.target,""))]}else{return false}}else{g=this.isEvent(h);if(g){return[parseInt(g.split(/-/)[0].replace(this.target,""))]}else{return[parseInt(c.replace(this.target,""))]}}}}}else{var a=this.isEvent(h,true);var j=a[0];var d=a[1];if(j){return d&&d.match(/-legend-/)?false:j}else{return false}}};this.getEventAreaId=function(b){if(this.graphType=="Network"){return this.getNetworkEventAreaId(b)}if(this.modelEvent=="local"){var a=b.target||b.srcElement;if(a){this.setLayoutValidIndices(b);return a.id.replace(this.target,"").split(",")}else{this.setLayoutValidIndices(b);return this.isEvent(b)}}else{return this.isEvent(b)}};this.getEventAreaData=function(a){return this.extractDataObject(this.getEventAreaId(a))};this.handleMouseAreaEvents=function(b,c,a){if(a[0]==-1){this.showInfoSpan(c,"CanvasXpress ("+this.version+")")}else{var d=this.extractDataObject(a);if(this.userEvents[b]){if(typeof(this.userEvents[b])=="object"&&this.userEvents[b].handler&&this.userEvents[b].scope){if(c.ctrlKey&&b=="click"){this.addRemoveToSelectedDataPoints(false,this.getEventAreaId(c));this.draw()}else{if(c.shiftKey&&b=="click"&&this.graphType=="Network"&&this.networkLayoutType=="radial"){this.reRootRadialNetwork(this.getEventAreaId(c))}else{if(c.altKey&&b=="click"&&this.graphType=="Network"){this.addConfigurator.apply(this,[c,this.getEventAreaId(c)])}else{this.userEvents[b].handler.apply(this.userEvents[b].scope,[d,c])}}}}else{if(typeof(this.userEvents[b])=="object"&&this.userEvents[b].handler){if(c.ctrlKey&&b=="click"){this.addRemoveToSelectedDataPoints(false,this.getEventAreaId(c));this.draw()}else{if(c.shiftKey&&b=="click"&&this.graphType=="Network"&&this.networkLayoutType=="radial"){this.reRootRadialNetwork(this.getEventAreaId(c))}else{if(c.altKey&&b=="click"&&this.graphType=="Network"){this.addConfigurator.apply(this,[c,this.getEventAreaId(c)])}else{this.userEvents[b].handler(d,c)}}}}else{if(c.ctrlKey&&b=="click"){this.addRemoveToSelectedDataPoints(false,this.getEventAreaId(c));this.draw()}else{if(c.shiftKey&&b=="click"&&this.graphType=="Network"&&this.networkLayoutType=="radial"){this.reRootRadialNetwork(this.getEventAreaId(c))}else{if(c.altKey&&b=="click"&&this.graphType=="Network"){this.addConfigurator.apply(this,[c,this.getEventAreaId(c)])}else{this.userEvents[b](d,c)}}}}}}}};this.mouseoverArea=function(a){return function(c){var b=a.getEventAreaId(c);if(b){a.handleMouseAreaEvents("mouseover",c,b)}}}(this);this.mouseoutArea=function(a){return function(c){var b=a.getEventAreaId(c);if(b){a.handleMouseAreaEvents("mouseout",c,b)}}}(this);this.clickArea=function(a){return function(c){if(!a.skipClick){var b=a.getEventAreaId(c);if(b){a.handleMouseAreaEvents("click",c,b)}else{a.clickImage(c)}}}}(this);this.dblclickArea=function(a){return function(c){if(!a.skipClick){var b=a.getEventAreaId(c);if(b){a.handleMouseAreaEvents("dblclick",c,b)}else{a.dblclickImage(c)}}}}(this);this.addRemoveImageMapListeners=function(c,b){this[c](b,"mouseover",this.mouseoverArea,false);this[c](b,"mouseout",this.mouseoutArea,false);this[c](b,"mousedown",this.mousedownImage,false);this[c](b,"click",this.clickArea,false);this[c](b,"dblclick",this.dblclickArea,false);this[c](b,"mousewheel",this.wheelImage,false)};this.formatCoords=function(j,k){var f=[];if(this.graphType!="Network"){for(var e=0;e<k.length;e++){if(e%2){f.push(sprintf("%.0f",(k[e]+this.translateY)*this.scaleY))}else{if(this.layoutValid&&j=="circle"&&e==2){f.push(sprintf("%.0f",k[e]*((this.scaleX+this.scaleY)/2)))}else{f.push(sprintf("%.0f",(k[e]+this.translateX)*this.scaleX))}}}}else{for(var e=0;e<k.length;e++){f.push(sprintf("%.0f",k[e]))}}if(j=="rect"){var b=Math.min(f[0],f[2]);var d=Math.min(f[1],f[3]);var a=Math.max(f[0],f[2]);var g=Math.max(f[1],f[3]);f=[b,d,a,g]}return f.join(",")};this.addArea=function(o,h,k,e){if(!o||!h){return}var j=o.shift();if(j&&o){if(this.modelEvent=="local"){var d=document.getElementById(this.target+"canvasXpressMap");if(d){var g=document.createElement("area");g.shape=j;g.coords=this.formatCoords(j,o);g.id=this.target+h.join(",");g.style.cursor="default";if(k){g.id+=k}this.addRemoveImageMapListeners("addEvtListener",g);if(e!=null){var n=d.getElementsByTagName("area")[e];d.insertBefore(g,n)}else{d.appendChild(g)}}}else{this.dataEvent.push([h,j,o,k])}}};this.addGlobalArea=function(k,j){if(!k){return}var f=k.shift();if(f&&k){var h;if(j){h=0;var g=document.getElementById(this.target+"globalArea"+h);while(g){h++;g=document.getElementById(this.target+"globalArea"+h)}}else{h=""}var b=document.getElementById(this.target+"canvasXpressMap");var d=document.createElement("area");d.shape=f;d.coords=this.formatCoords(f,k);d.id=this.target+"globalArea"+h;this.addRemoveImageMapListeners("addEvtListener",d);b.appendChild(d)}};this.resetMap=function(){var b=document.getElementById(this.target+"canvasXpressMap");if(b){var d=b.childNodes;var g=[];var e=this.modelEvent=="local"?1:0;for(var f=e;f<d.length;f++){if(d[f].id){g.push(d[f])}}for(var f=0;f<g.length;f++){var c=g[f];if(c){this.addRemoveImageMapListeners("removeEvtListener",c);c.parentNode.removeChild(c)}}}this.dataEvent=[]};this.initializeImageMapEvents=function(){if(!this.disableEvents){this.addImage();this.addMap();this.addRemoveCanvasListeners("addEvtListener")}};this.initializeImageMapEvents()};CanvasXpress.prototype.initCanvasResizerEvents=function(){this.addCanvasResizerDiv=function(){if(document.getElementById(this.target+"canvasXpressCanvasResize")){return}var a=document.createElement("div");a.id=this.target+"canvasXpressCanvasResize";a.style.left="0px";a.style.top="0px";a.style.width="0.5px";a.style.height="0.5px";a.style.opacity=0.5;a.style.filter="alpha(opacity = 50)";a.style.backgroundColor=this.resizerAreaColor;a.style.position="absolute";a.style.display="none";a.style.zIndex=10001;this.canvas.parentNode.appendChild(a)};this.isCanvasResize=function(c){if(!c){c=window.event}var b=this.adjustedCoordinates(c);if(b){var a=b.x;var d=b.y;if(a>this.width-18&&d>this.height-18){this.resizeCanvasCursorShow="se-resize";return true}else{if(a>this.width-18){this.resizeCanvasCursorShow="e-resize";return true}else{if(d>this.height-18){this.resizeCanvasCursorShow="s-resize";return true}else{this.resizeCanvasCursorShow=false;return false}}}}};this.updateCanvasResizerCursor=function(d){if(!d){d=window.event}var b=document.getElementById(this.target+"canvasXpressImage");if(b){var c=this.adjustedCoordinates(d);if(c){var a=c.x;var f=c.y;if(a>this.width-18&&f>this.height-18){b.style.cursor="se-resize";this.resizeCanvasCursorShow="se-resize"}else{if(a>this.width-18){b.style.cursor="e-resize";this.resizeCanvasCursorShow="e-resize"}else{if(f>this.height-18){b.style.cursor="s-resize";this.resizeCanvasCursorShow="s-resize"}else{if(!this.movingOn){b.style.cursor="default";this.resizeCanvasCursorShow=false}}}}}}};this.updateCanvasResizer=function(c){if(this.resizingCanvasOn&&this.resizeCanvasCursorShow){document.body.style.cursor=this.resizeCanvasCursorShow;var b=document.getElementById(this.target+"canvasXpressCanvasResize");var a=this.adjustedCoordinates(c);if(b&&a){if(this.resizeCanvasCursorShow=="se-resize"){b.style.width=a.x+"px";b.style.height=a.y+"px"}else{if(this.resizeCanvasCursorShow=="e-resize"){b.style.width=a.x+"px";b.style.height=this.height+"px"}else{if(this.resizeCanvasCursorShow=="s-resize"){b.style.width=this.width+"px";b.style.height=a.y+"px"}}}b.style.display="block"}}};this.endCanvasResizer=function(d){if(this.resizingCanvasOn){var b=document.getElementById(this.target+"canvasXpressImage");var c=document.getElementById(this.target+"canvasXpressCanvasResize");if(b&&c){var a=parseInt(c.style.width.replace("px",""));var f=parseInt(c.style.height.replace("px",""));this.resetAxesResizer();this.draw(a,f);c.style.width="0.5px";c.style.height="0.5px";c.style.display="none";b.style.cursor="default";this.updateRemoteNavigationWindow();this.resizeCanvasCursorShow=false;this.resizingCanvasOn=false}}};this.initializeCanvasResizerEvents=function(){if(!this.disableEvents){this.addCanvasResizerDiv()}};this.initializeCanvasResizerEvents()};CanvasXpress.prototype.initAxisResizerEvents=function(){this.addAxesResizeDiv=function(){if(document.getElementById(this.target+"canvasXpressAxesResize")){return}var c=["Previous","Next","Current","Middle","Min","Max","Close"];var b=9001;var e=document.createElement("div");e.id=this.target+"canvasXpressAxesResize";if(this.resizerTransparency){e.style.opacity=0.85;e.style.filter="alpha(opacity = 85)"}e.style.position="absolute";e.style.display="none";e.style.zIndex=b;for(var a=0;a<c.length;a++){b++;var f=document.createElement("div");f.id=this.target+"canvasXpressAxesResize"+c[a];if(this.resizerTransparency){f.style.opacity=0.85;f.style.filter="alpha(opacity = 85)"}f.style.position="absolute";f.style.zIndex=b;e.appendChild(f)}this.canvas.parentNode.appendChild(e)};this.clickAxesResizeClose=function(a){return function(b){a.stopEvent(b);a.resetAxesResizer(b);a.resetFlags(b)}}(this);this.mousemoveActiveAxesResize=function(a){return function(b){a.activateDeactivateAxesResizer(b)}}(this);this.mousedownAxesResize=function(a){return function(b){a.cancelEvent(b);a.registerAxesResizer(b);return false}}(this);this.mousemoveAxesResize=function(a){return function(b){a.cancelEvent(b);a.updateAxesResizer(b);return false}}(this);this.mouseupAxesResize=function(a){return function(b){a.stopEvent(b);a.endAxesResizer(b);return false}}(this);this.addRemoveAxesResizerListeners=function(v){var a=document.getElementById(this.target+"canvasXpressAxesResize");var d=document.getElementById(this.target+"canvasXpressAxesResizeMin");var u=document.getElementById(this.target+"canvasXpressAxesResizeMax");var e=document.getElementById(this.target+"canvasXpressAxesResizeMiddle");var q=document.getElementById(this.target+"canvasXpressAxesResizeCurrent");var k=document.getElementById(this.target+"canvasXpressAxesResizeClose");var s=document.getElementById(this.target+"canvasXpressAxesResizePrevious");var p=document.getElementById(this.target+"canvasXpressAxesResizeNext");var g=document.getElementById(this.target+"canvasXpressImage");var b=[a,d,u,e,q];if(g){this[v](g,"mousemove",this.mousemoveAxesResize,false)}if(a){this[v](a,"mousemove",this.mousemoveActiveAxesResize,false);this[v](a,"mouseout",this.mousemoveActiveAxesResize,false)}if(k){this[v](k,"click",this.clickAxesResizeClose,false)}for(var f=0;f<b.length;f++){if(b[f]){this[v](b[f],"mousedown",this.mousedownAxesResize,false);this[v](b[f],"mousemove",this.mousemoveAxesResize,false);this[v](b[f],"mouseup",this.mouseupAxesResize,false)}}};this.showAxesResizer=function(f,e,c,t,q,n,b,g,u,w,o,k,j){if(!this.axesResizerShow){var a=document.getElementById(this.target+"canvasXpressAxesResize");var m=document.getElementById(this.target+"canvasXpressAxesResizeClose");if(a&&m){this.updateResizerEventData(null,null,f,e,c,t,q,n,b,g,u,w,o,k,j);this.refreshAxesResizer();a.style.display="block";if(this.resizerType&&this.layoutValid){m.style.display="none"}this.addRemoveAxesResizerListeners("addEvtListener");if(this.layoutValid){this.layoutValidR=k;this.layoutValidC=j;this.layoutValidN=o}this.axesResizerShow=true}}};this.refreshAxesResizer=function(){if(this.resizerEventData){var b=document.getElementById(this.target+"canvasXpressAxesResize");var e=document.getElementById(this.target+"canvasXpressAxesResizeMin");var p=document.getElementById(this.target+"canvasXpressAxesResizeMax");var f=document.getElementById(this.target+"canvasXpressAxesResizeMiddle");var j=document.getElementById(this.target+"canvasXpressAxesResizeCurrent");var g=document.getElementById(this.target+"canvasXpressAxesResizeClose");var o=document.getElementById(this.target+"canvasXpressAxesResizePrevious");var k=document.getElementById(this.target+"canvasXpressAxesResizeNext");if(b&&e&&p&&j&&g&&o&&k){var t=this.resizerEventData.areas.org[1]-this.resizerEventData.areas.org[0];var q=this.resizerEventData.areas.org[3]-this.resizerEventData.areas.org[2];var d=14;var a=9;var s=parseInt(a/2);if(this.resizerEventData.pos=="h"){l=this.resizerEventData.l.match(/^t/)?"top":"bottom";b.style.left=(this.resizerEventData.areas.org[0]-s)+"px";b.style.top=this.resizerEventData.areas.org[2]+"px";b.style.width=((t+a)-1)+"px";b.style.height=d+"px";b.style.backgroundImage="url('"+this.imageDir+"scroller_empty_hor_"+l+".png')";b.style.backgroundRepeat="repeat-x";o.style.left="0px";o.style.top="0px";o.style.width=a+"px";o.style.height=d+"px";o.style.backgroundImage="url('"+this.imageDir+"prev_"+l+".png')";e.style.left=this.resizerEventData.areas.min[0]+"px";e.style.top="0px";e.style.width=a+"px";e.style.height=d+"px";e.style.cursor="e-resize";e.style.backgroundImage="url('"+this.imageDir+"handle_left_"+l+".png')";j.style.left=this.resizerEventData.areas.cur[0]+"px";j.style.top="0px";j.style.width=this.resizerEventData.areas.cur[1]+"px";j.style.height=d+"px";j.style.cursor="move";j.style.backgroundImage="url('"+this.imageDir+"scroller_body_hor_"+l+".png')";j.style.backgroundRepeat="repeat-x";p.style.left=this.resizerEventData.areas.max[0]+"px";p.style.top="0px";p.style.width=a+"px";p.style.height=d+"px";p.style.cursor="e-resize";p.style.backgroundImage="url('"+this.imageDir+"handle_right_"+l+".png')";p.style.backgroundRepeat="no-repeat";f.style.left=(this.resizerEventData.areas.min[0]+((this.resizerEventData.areas.cur[1]-1)/2))+"px";f.style.top="0px";f.style.width="8px";f.style.height=d+"px";f.style.cursor="move";f.style.backgroundImage="url('"+this.imageDir+"scroller_handle_hor_"+l+".png')";k.style.left=(t-1)+"px";k.style.top="0px";k.style.width=a+"px";k.style.height=d+"px";k.style.backgroundImage="url('"+this.imageDir+"next_"+l+".png')";g.style.left=(t+a)+"px";g.style.top="0px";g.style.width=a+"px";g.style.height=d+"px";g.style.backgroundImage="url('"+this.imageDir+"close.png')"}else{l=this.resizerEventData.l.match(/^l/)?"left":"right";b.style.left=this.resizerEventData.areas.org[0]+"px";b.style.top=(this.resizerEventData.areas.org[2]-s)+"px";b.style.width=d+"px";b.style.height=(q+a)+"px";b.style.backgroundImage="url('"+this.imageDir+"scroller_empty_ver_"+l+".png')";b.style.backgroundRepeat="repeat-y";o.style.left="0px";o.style.top=q+"px";o.style.width=d+"px";o.style.height=a+"px";o.style.backgroundImage="url('"+this.imageDir+"prev_"+l+".png')";e.style.left="0px";e.style.top=this.resizerEventData.areas.min[2]+"px";e.style.width=d+"px";e.style.height=a+"px";e.style.cursor="n-resize";e.style.backgroundImage="url('"+this.imageDir+"handle_bottom_"+l+".png')";e.style.backgroundRepeat="no-repeat";j.style.left="0px";j.style.top=this.resizerEventData.areas.cur[2]+"px";j.style.width=d+"px";j.style.height=this.resizerEventData.areas.cur[3]+"px";j.style.cursor="move";j.style.backgroundImage="url('"+this.imageDir+"scroller_body_ver_"+l+".png')";j.style.backgroundRepeat="repeat-y";p.style.left="0px";p.style.top=this.resizerEventData.areas.max[2]+"px";p.style.width=d+"px";p.style.height=a+"px";p.style.cursor="n-resize";p.style.backgroundImage="url('"+this.imageDir+"handle_top_"+l+".png')";p.style.backgroundRepeat="no-repeat";f.style.left="0px";f.style.top=(this.resizerEventData.areas.max[2]+(this.resizerEventData.areas.cur[3]/2))+"px";f.style.width=d+"px";f.style.height=d+"px";f.style.cursor="move";f.style.backgroundImage="url('"+this.imageDir+"scroller_handle_ver_"+l+".png')";f.style.backgroundRepeat="no-repeat";k.style.left="0px";k.style.top="0px";k.style.width=d+"px";k.style.height=a+"px";k.style.backgroundImage="url('"+this.imageDir+"next_"+l+".png')";g.style.left=(d+1)+"px";g.style.top=-a+"px";g.style.width=a+"px";g.style.height=d+"px";g.style.backgroundImage="url('"+this.imageDir+"close.png')"}this.drawAxesResizerMasks()}}};this.updateResizerEventData=function(h,G,A,q,o,a,W,T,J,N,H,I,y,t,r){var j,F,E,m,k,z,x,f,c,P,O,D,C,n,V;A=A?A:this.resizerEventData.axis;q=q?q:this.resizerEventData.areas.org[0];o=o?o:this.resizerEventData.areas.org[1];a=a?a:this.resizerEventData.areas.org[2];W=W?W:this.resizerEventData.areas.org[3];T=T?T:this.resizerEventData.dim;J=J?J:this.resizerEventData.pos;N=N?N:this.resizerEventData.l;H=H?H:this.resizerEventData.vals;I=I?I:this.resizerEventData.set?this.resizerEventData.set:"";y=y?y:this.resizerEventData.c,t=t?t:this.resizerEventData.i;r=r?r:this.resizerEventData.j;var R=H.graphType;var e=o-q;var b=W-a;if(R=="Heatmap"){if(T=="y"){j=this.isGroupedData?this.data.w.smps.length:this.data.y?this.data.y.smps.length:0}else{j=this.data.y?this.data.y.vars.length:0}}else{j=this.isGroupedData?this.data.w.smps.length-1:this.data.y?this.data.y.smps.length-1:0}var U=this.resizerType=="samples"||R=="Heatmap"?0:H[A+"AbsMin"];var B=this.resizerType=="samples"||R=="Heatmap"?j:H[A+"AbsMax"];var u=J=="h"?e:b;var Q=u/(B-U);if(h==null||isNaN(h)){if(this.resizerType=="samples"){h=this.isGroupedData?this.grpIndices[0]:this.smpIndices[0]}else{if(R=="Heatmap"){h=T=="y"?Math.max(0,H.smpIndicesStart):Math.max(0,H.varIndicesStart)}else{h=R.match(/Scatter/)?H["setMin"+T.toUpperCase()]:R=="BarLine"&&N.match(/b|r/)?H.setMin2:H.setMin}if(h==null||isNaN(h)){h=U}}}h=Math.max(h,U);if(G==null||isNaN(G)){if(this.resizerType=="samples"){G=this.isGroupedData?this.grpIndices[this.grpIndices.length-1]:this.smpIndices[this.smpIndices.length-1]}else{if(R=="Heatmap"){G=T=="x"?H.varIndices.length:this.isGroupedData?H.grpIndices.length:H.smpIndices.length;G+=h}else{G=R.match(/Scatter/)?H["setMax"+T.toUpperCase()]:R=="BarLine"&&N.match(/b|r/)?H.setMax2:H.setMax}if(G==null||isNaN(G)){G=B}}}G=Math.min(G,B);var w=(h-U)*Q;var S=(G-U)*Q;var M=14;var L=9;var K=parseInt(L/2);if(J=="h"){F=parseInt(w);E=L;m=0;k=M;P=parseInt(w+K+1);O=parseInt(S-(w+1));D=0;C=M;z=parseInt(S-1);x=L;f=0;c=M;n=o+(L-1);V=W}else{F=0;E=M;m=this.resizerType=="samples"||R=="Heatmap"?parseInt(S):parseInt(b-(w+1));k=L;P=0;O=M;D=this.resizerType=="samples"||R=="Heatmap"?parseInt(w+K):parseInt((b-S)+K);C=parseInt(S-w);z=0;x=M;f=this.resizerType=="samples"||R=="Heatmap"?parseInt(w+1):parseInt(b-S);c=L;n=o;V=W+(L-1)}this.resizerEventData={g:R,axis:A,dim:T,pos:J,l:N,vals:H,min:U,max:B,smin:h,smax:G,len:u,unit:Q,width:M,set:I,c:y,i:t,j:r,areas:{org:[q,o,a,W],lim:[q,n,a,V],min:[F,E,m,k],max:[z,x,f,c],cur:[P,O,D,C]}}};this.updateAxesResizer=function(v){if(this.axesResizingOn){if(!v){v=window.event}var q=this.resizerEventData.areas;var z=this.adjustedCoordinates(v);if(z){var n,A,b,c,a;var f=this.xMouseDown-z.x;var d=this.yMouseDown-z.y;var j,h;var s=null;var u=null;var w="";var E=14;var D=9-1;var B=parseInt(D/2);if(this.resizerEventData.g=="Heatmap"){if(this.resizerEventData.dim=="y"){n=this.isGroupedData?this.data.w.smps.length:this.data.y?this.data.y.smps.length:0;b=this.resizerEventData.lastMax!=null?this.resizerEventData.lastMax:this.resizerEventData.smax!=null?this.resizerEventData.smax:this.isGroupedData?this.data.w.smps.length:this.data.y.smps.length}else{n=this.data.y?this.data.y.vars.length:0;b=this.resizerEventData.lastMax!=null?this.resizerEventData.lastMax:this.resizerEventData.smax!=null?this.resizerEventData.smax:this.data.y.vars.length}A=this.resizerEventData.lastMin!=null?this.resizerEventData.lastMin:this.resizerEventData.smin!=null?this.resizerEventData.smin:0;a=this.resizerEventData.pos=="h"?(q.org[1]-q.org[0])/n:(q.org[3]-q.org[2])/n}else{n=this.isGroupedData?this.data.w.smps.length-1:this.data.y?this.data.y.smps.length-1:0;A=this.resizerEventData.lastMin!=null?this.resizerEventData.lastMin:this.resizerEventData.smin!=null?this.resizerEventData.smin:0;b=this.resizerEventData.lastMax!=null?this.resizerEventData.lastMax:this.resizerEventData.smax!=null?this.resizerEventData.smax:this.isGroupedData?this.data.w.smps.length-1:this.data.y.smps.length-1;a=this.resizerEventData.pos=="h"?(q.org[1]-q.org[0])/n:(q.org[3]-q.org[2])/n}if(this.resizerEventData.active=="min"){j=f>q.min[0]?this.xMouseDown-q.min[0]:f<(q.min[0]+q.min[1])-q.max[0]?this.xMouseDown-((q.min[0]+q.min[1])-q.max[0]):z.x;h=d>q.min[2]-(q.max[2]+q.max[3])?this.yMouseDown-(q.min[2]-(q.max[2]+q.max[3])):d<(q.lim[2]+q.min[2]+q.min[3])-q.lim[3]?(q.lim[3]-(q.lim[2]+q.min[2]+q.min[3]))+this.yMouseDown:z.y}else{if(this.resizerEventData.active=="max"){j=f>q.max[0]-(q.min[0]+q.min[1])?this.xMouseDown-(q.max[0]-(q.min[0]+q.min[1])):f<(q.lim[0]+q.max[0]+q.max[1])-q.lim[1]?(q.lim[1]-(q.lim[0]+q.max[0]+q.max[1]))+this.xMouseDown:z.x;h=d>q.max[2]?this.yMouseDown-q.max[2]:d<(q.lim[2]+q.max[2]+q.max[3])-(q.lim[2]+q.min[2])?((q.lim[2]+q.min[2])-(q.lim[2]+q.max[2]+q.max[3]))+this.yMouseDown:z.y}else{if(this.resizerEventData.active=="cur"){j=f>q.min[0]?this.xMouseDown-q.min[0]:f<(q.lim[0]+q.max[0]+q.max[1])-q.lim[1]?(q.lim[1]-(q.lim[0]+q.max[0]+q.max[1]))+this.xMouseDown:z.x;h=d>q.max[2]?this.yMouseDown-q.max[2]:d<(q.lim[2]+q.min[2]+q.min[3])-q.lim[3]?(q.lim[3]-(q.lim[2]+q.min[2]+q.min[3]))+this.yMouseDown:z.y}else{return}}}var m=j-this.xMouseDown;var k=h-this.yMouseDown;if(this.resizerType=="samples"||this.resizerEventData.g=="Heatmap"){m-=m%a;k-=k%a}var r=m/this.resizerEventData.unit;var p=k/this.resizerEventData.unit;var t=document.getElementById(this.target+"canvasXpressAxesResizeMin");var o=document.getElementById(this.target+"canvasXpressAxesResizeMax");var C=document.getElementById(this.target+"canvasXpressAxesResizeMiddle");var g=document.getElementById(this.target+"canvasXpressAxesResizeCurrent");if(t&&o&&C&&g){if(this.resizerEventData.active=="min"){if(this.resizerEventData.pos=="h"){t.style.left=(q.min[0]+m)+"px";C.style.left=((q.min[0]+m)+((q.cur[1]-m)/2))+"px";g.style.left=(q.min[0]+m+B+1)+"px";g.style.width=(q.cur[1]-m)+"px";A=parseInt((q.min[0]+D+m)/a);if(this.resizerType=="samples"){s=dateFormat(this.data.y.smps[A],this.timeFormat)}else{if(this.resizerEventData.g=="Heatmap"){s=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[A]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[A]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[A]]}else{s=this.formatNumber(this.resizerEventData.smin+r)}}}else{t.style.top=(q.min[2]+k)+"px";C.style.top=((q.min[2]+k)-((q.cur[3]+k)/2))+"px";g.style.height=((q.cur[3]+k))+"px";b=parseInt((q.min[2]+D+k)/a);if(this.resizerType=="samples"){s=dateFormat(this.data.y.smps[b],this.timeFormat)}else{if(this.resizerEventData.g=="Heatmap"){s=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[b]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[b]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[b]]}else{s=this.formatNumber(this.resizerEventData.smin-p)}}}this.showInfoSpan(v,s)}else{if(this.resizerEventData.active=="max"){if(this.resizerEventData.pos=="h"){o.style.left=(q.max[0]+m)+"px";C.style.left=((q.min[0]+m)+((q.cur[1]-m)/2))+"px";g.style.width=(q.cur[1]+m)+"px";b=parseInt((q.max[0]+D+m)/a);if(this.resizerType=="samples"){u=dateFormat(this.data.y.smps[b],this.timeFormat)}else{if(this.resizerEventData.g=="Heatmap"){u=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[b]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[b]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[b]]}else{u=this.formatNumber(this.resizerEventData.smax+r)}}}else{o.style.top=(q.max[2]+k)+"px";C.style.top=((q.max[2]+k)+((q.cur[3]-k)/2))+"px";g.style.top=(q.max[2]+k+B)+"px";g.style.height=(q.cur[3]-k)+"px";A=parseInt((q.max[2]+D+k)/a);if(this.resizerType=="samples"){u=dateFormat(this.data.y.smps[A],this.timeFormat)}else{if(this.resizerEventData.g=="Heatmap"){u=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[A]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[A]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[A]]}else{u=this.formatNumber(this.resizerEventData.smax-p)}}}this.showInfoSpan(v,u)}else{if(this.resizerEventData.active=="cur"){if(this.resizerEventData.pos=="h"){t.style.left=(q.min[0]+m)+"px";C.style.left=((q.min[0]+m)+(q.cur[1]/2))+"px";o.style.left=(q.max[0]+m)+"px";g.style.left=(q.min[0]+m+B+1)+"px";A=parseInt((q.min[0]+D+m)/a);b=parseInt((q.max[0]+D+m)/a);if(this.resizerType=="samples"){s=dateFormat(this.data.y.smps[A],this.timeFormat);u=dateFormat(this.data.y.smps[b],this.timeFormat)}else{if(this.resizerEventData.g=="Heatmap"){s=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[A]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[A]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[A]];u=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[b]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[b]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[b]]}else{s=this.formatNumber(this.resizerEventData.smin+r);u=this.formatNumber(this.resizerEventData.smax+r)}}this.showInfoSpan(v,s+"--"+u)}else{t.style.top=(q.min[2]+k)+"px";C.style.top=((q.max[2]+k)+(q.cur[3]/2))+"px";o.style.top=(q.max[2]+k)+"px";g.style.top=(q.max[2]+k+B)+"px";b=parseInt((q.min[2]+D+k)/a);A=parseInt((q.max[2]+D+k)/a);if(this.resizerType=="samples"){s=dateFormat(this.data.y.smps[b],this.timeFormat);u=dateFormat(this.data.y.smps[A],this.timeFormat);this.showInfoSpan(v,u+"--"+s)}else{if(this.resizerEventData.g=="Heatmap"){s=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[b]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[b]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[b]];u=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[A]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[A]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[A]];this.showInfoSpan(v,u+"--"+s)}else{s=this.formatNumber(this.resizerEventData.smin-p);u=this.formatNumber(this.resizerEventData.smax-p);this.showInfoSpan(v,s+"--"+u)}}}}}}this.resizerEventData.lastMin=this.resizerType=="samples"||this.resizerEventData.g=="Heatmap"?A:s;this.resizerEventData.lastMax=this.resizerType=="samples"||this.resizerEventData.g=="Heatmap"?b:u;if(this.resizerDraw){this.drawAxesResizerUpdate()}}}}};this.drawAxesResizerUpdate=function(m){var d=this.resizerEventData.lastMin!=null?parseFloat(this.resizerEventData.lastMin):parseFloat(this.resizerEventData.smin);var j=this.resizerEventData.lastMax!=null?parseFloat(this.resizerEventData.lastMax):parseFloat(this.resizerEventData.smax);var h=this.resizerEventData.c||0;if(this.resizerType=="samples"){var k=this.isGroupedData?this.data.w.smps.length-1:this.data.y.smps.length-1;var a=[];var g=[];for(var f=0;f<d;f++){g.push(true)}for(var f=d;f<=j;f++){a.push(f);g.push(false)}for(var f=j+1;f<k;f++){g.push(true)}if(this.isGroupedData){this.grpIndices=a;this.hiddenGrps=g}else{this.smpIndices=a;this.hiddenSmps=g}}else{if(this.resizerEventData.g=="Heatmap"){if(!this.startingVarIndices||!this.startingSmpIndices){this.setOriginalIndices(h)}var b=this.startingVarIndices[h];var e=this.startingSmpIndices[h];if(this.resizerEventData.dim=="y"){if(this.isGroupedData){if(this.layoutComb){this.layoutParams[h]["grpIndices"]=[];for(var f=d;f<j;f++){this.layoutParams[h]["grpIndices"].push(e[f])}this.layoutParams[h]["smpIndicesStart"]=d}else{this.grpIndices=[];for(var f=d;f<j;f++){this.grpIndices.push(e[f])}this.smpIndicesStart=d}}else{if(this.layoutComb){this.layoutParams[h]["smpIndices"]=[];for(var f=d;f<j;f++){this.layoutParams[h]["smpIndices"].push(e[f])}this.layoutParams[h]["smpIndicesStart"]=d}else{this.smpIndices=[];for(var f=d;f<j;f++){this.smpIndices.push(e[f])}this.smpIndicesStart=d}}}else{if(this.layoutComb){this.layoutParams[h]["varIndices"]=[];for(var f=d;f<j;f++){this.layoutParams[h]["varIndices"].push(b[f])}this.layoutParams[h]["varIndicesStart"]=d}else{this.varIndices=[];for(var f=d;f<j;f++){this.varIndices.push(b[f])}this.varIndicesStart=d}}}else{if(this.resizerEventData.lastMin){this["setMin"+this.resizerEventData.set]=d}if(this.resizerEventData.lastMax){this["setMax"+this.resizerEventData.set]=j}}}if(m){this.updateResizerEventData(d,j)}this.draw()};this.drawAxesResizerBackgroundData=function(d,o,b,n){if(this.resizerType&&this.resizerDataIndex>-1){this.setAllSamplesVisible();var a,j,c,m;var k=this.graphType=="Candlestick"?"close":false;var g=[];var e=[];var p=[];for(var f=0;f<this.smpIndices.length;f++){g.push(this.getDataAtPos(this.resizerDataIndex,f,k))}var h=this.range(g);if(this.resizerPosition.match(/top|bottom/)){a=b/(this.smpIndices.length-1);j=n/((h[1]-h[0])*1.2);c=(h[1]-h[0])*0.1*j;m=o+n;e.push(d);p.push(m);for(var f=0;f<g.length;f++){e.push(d);p.push(m-(((g[f]-h[0])*j)+c));d+=a}d-=a;e.push(d);p.push(m)}else{a=n/(this.smpIndices.length-1);j=b/((h[1]-h[0])*1.2);c=(h[1]-h[0])*0.1*j;e.push(d);p.push(o);for(var f=0;f<g.length;f++){e.push(d+((g[f]-h[0])*j)+c);p.push(o);o+=a}o-=a;e.push(d);p.push(o)}this.drawShape("polygon",e,p,false,false,this.resizerAreaColorCurrent,this.resizerAreaColorOutlineCurrent,"closed")}};this.drawAxesResizerMasks=function(){if(this.resizerType){var e,h,d,f;var c=this.resizerEventData.areas;var b=this.isGroupedData?this.data.w.grps.length-1:this.data.y.smps.length-1;var a=this.resizerEventData.pos=="h"?(c.org[1]-c.org[0])/b:(c.org[3]-c.org[2])/b;var g=9-1;if(this.resizerEventData.pos=="h"){if(this.resizerEventData.smin>0){e=c.org[0]-1;h=c.org[2]-this.resizerWidth;d=a*this.resizerEventData.smin;f=this.resizerWidth;this.rectangle(e,h,d,f,this.resizerAreaColor,this.resizerAreaColor);this.drawLine("line",e,h,e+d+1,h,this.foreground);this.drawLine("line",e+d,h,e+d,h+f,this.foreground)}if(this.resizerEventData.smax<b){e=c.org[0]+c.max[0]+1;h=c.org[2]-this.resizerWidth;d=(a*(b-this.resizerEventData.smax))+1;f=this.resizerWidth;this.rectangle(e,h,d,f,this.resizerAreaColor,this.resizerAreaColor);this.drawLine("line",e-1,h,e+d+2,h,this.foreground);this.drawLine("line",e-1,h,e-1,h+f,this.foreground)}e=c.org[0]+c.max[0];h=c.org[2]-1;d=c.org[0]+a*this.resizerEventData.smin;this.drawLine("line",e,h,d,h,this.foreground)}else{if(this.resizerEventData.smin>0){e=c.org[0]+14;h=c.org[2];d=this.resizerWidth;f=a*this.resizerEventData.smin;this.rectangle(e,h,d,f,this.resizerAreaColor,this.resizerAreaColor);this.drawLine("line",e,h+f,e+d,h+f,this.foreground);this.drawLine("line",e+d,h,e+d,h+f,this.foreground)}if(this.resizerEventData.smax<b){e=c.org[0]+14;h=c.org[2]+c.min[2];d=this.resizerWidth;f=(b-this.resizerEventData.smax)*a;this.rectangle(e,h,d,f,this.resizerAreaColor,this.resizerAreaColor);this.drawLine("line",e,h,e+d,h,this.foreground);this.drawLine("line",e+d,h,e+d,h+f,this.foreground)}e=c.org[0]+14;h=c.org[2]+c.min[2];f=c.org[2]+(a*this.resizerEventData.smin);this.drawLine("line",e,h,e,f,this.foreground)}}};this.registerAxesResizer=function(d){if(!d){d=window.event}var h=this.adjustedCoordinates(d);if(h){var g=h.x;var f=h.y;var c=this.resizerEventData.areas;var k=c.lim[1]-c.lim[0];var j=c.lim[3]-c.lim[2];var a=5;var b=k>j?"h":"v";if(g>=c.min[0]+c.lim[0]&&g<=c.min[0]+c.min[1]+c.lim[0]&&f>=c.min[2]+c.lim[2]&&f<=c.min[2]+c.min[3]+c.lim[2]){this.resizerEventData.active="min";this.axesResizingOn=true}else{if(g>=c.max[0]+c.lim[0]&&g<=c.max[0]+c.max[1]+c.lim[0]&&f>=c.max[2]+c.lim[2]&&f<=c.max[2]+c.max[3]+c.lim[2]){this.resizerEventData.active="max";this.axesResizingOn=true}else{if(g>=c.cur[0]+c.lim[0]&&g<=c.cur[0]+c.cur[1]+c.lim[0]&&f>=c.cur[2]+c.lim[2]&&f<=c.cur[2]+c.cur[3]+c.lim[2]){this.resizerEventData.active="cur";this.axesResizingOn=true}else{if(b=="h"){if(g>=c.lim[0]&&g<c.min[0]+c.lim[0]){this.resizerEventData.active="prev";this.axesResizingOn=true}else{if(g>c.lim[0]+c.max[0]+c.max[1]&&g<=c.lim[1]-a){this.resizerEventData.active="next";this.axesResizingOn=true}}}else{if(f>=c.lim[2]+c.min[2]+c.min[3]&&f<=c.lim[2]+c.lim[3]){this.resizerEventData.active="prev";this.axesResizingOn=true}else{if(f>=c.lim[2]&&f<=c.lim[2]+c.max[2]){this.resizerEventData.active="next";this.axesResizingOn=true}}}}}}this.xMouseDown=g;this.yMouseDown=f}};this.activateDeactivateAxesResizer=function(j){if(!j){j=window.event}var s=this.adjustedCoordinates(j);if(s){var q;var r=s.x;var m=s.y;var h=this.resizerEventData.areas;var u=h.lim[1]-h.lim[0];var t=h.lim[3]-h.lim[2];var c=5;var f=u>t?"h":"v";if(f=="h"){if(r>=h.lim[0]&&r<=h.lim[0]+h.min[0]){q="prev"}else{if(r>=h.lim[0]+h.max[0]+h.max[1]&&r<=h.lim[1]-c){q="next"}}}else{if(m>=h.lim[2]+h.min[2]+h.min[3]&&m<=h.lim[2]+h.lim[3]){q="prev"}else{if(m>=h.lim[2]&&m<=h.lim[2]+h.max[2]){q="next"}}}var d=document.getElementById(this.target+"canvasXpressAxesResizePrevious");var g=document.getElementById(this.target+"canvasXpressAxesResizeNext");if(d&&g){if(q=="prev"){var k=d.style.backgroundImage;if(j.type.match(/mouseout/i)){if(k.match(/_active.png/)){d.style.backgroundImage=k.replace("_active.png",".png")}}else{if(!k.match(/_active.png/)){d.style.backgroundImage=k.replace(".png","_active.png")}}}else{if(q=="next"){var k=g.style.backgroundImage;if(j.type.match(/mouseout/i)){if(k.match(/_active.png/)){g.style.backgroundImage=k.replace("_active.png",".png")}}else{if(!k.match(/_active.png/)){g.style.backgroundImage=k.replace(".png","_active.png")}}}else{var k=d.style.backgroundImage;if(k.match(/_active.png/)){d.style.backgroundImage=k.replace("_active.png",".png")}k=g.style.backgroundImage;if(k.match(/_active.png/)){g.style.backgroundImage=k.replace("_active.png",".png")}}}}return false}};this.moveAxesResizer=function(k){var g=this.resizerEventData.smin;var m=this.resizerEventData.smax;var c=this.resizerType=="samples"||this.resizerEventData.g=="Heatmap"?1:(m-g)/10;if((this.resizerType=="samples"||this.resizerEventData.g=="Heatmap")&&this.resizerEventData.pos=="v"){if(this.resizerEventData.active=="prev"){if(g+c<this.resizerEventData.min){c=g-this.resizerEventData.min;this.resizerEventData.lastMin=this.resizerEventData.min;this.resizerEventData.lastMax=m+c}else{this.resizerEventData.lastMin=g+c;this.resizerEventData.lastMax=m+c}}else{if(m-c>this.resizerEventData.max){c=this.resizerEventData.max-m;this.resizerEventData.lastMin=g-c;this.resizerEventData.lastMax=this.resizerEventData.max}else{this.resizerEventData.lastMin=g-c;this.resizerEventData.lastMax=m-c}}}else{if(this.resizerEventData.active=="prev"){if(g-c<this.resizerEventData.min){c=g-this.resizerEventData.min;this.resizerEventData.lastMin=this.resizerEventData.min;this.resizerEventData.lastMax=m-c}else{this.resizerEventData.lastMin=g-c;this.resizerEventData.lastMax=m-c}}else{if(m+c>this.resizerEventData.max){c=this.resizerEventData.max-m;this.resizerEventData.lastMin=g+c;this.resizerEventData.lastMax=this.resizerEventData.max}else{this.resizerEventData.lastMin=g+c;this.resizerEventData.lastMax=m+c}}}var f=this.resizerEventData.areas;var d=document.getElementById(this.target+"canvasXpressAxesResizeMin");var o=document.getElementById(this.target+"canvasXpressAxesResizeMax");var n=document.getElementById(this.target+"canvasXpressAxesResizeMiddle");var j=document.getElementById(this.target+"canvasXpressAxesResizeCurrent");var b=14;var a=9-1;var p=parseInt(a/2);var h=c*this.resizerEventData.unit;if((this.resizerEventData.pos=="h"&&this.resizerEventData.active=="prev")||(this.resizerEventData.pos=="v"&&this.resizerEventData.active=="next")){h*=-1}if(this.resizerEventData.pos=="h"){d.style.left=(f.min[0]+h+1)+"px";n.style.left=((f.min[0]+h)+(f.cur[1]/2))+"px";o.style.left=(f.max[0]+h)+"px";j.style.left=(f.min[0]+h+p+1)+"px"}else{d.style.top=(f.min[2]+h+1)+"px";n.style.top=((f.max[2]+h)+(f.cur[3]/2))+"px";o.style.top=(f.max[2]+h)+"px";j.style.top=(f.max[2]+h+p+1)+"px"}};this.getAxesVals=function(e){var d=["minData","maxData","xAxisMin","xAxisMax","xAxis2Min","xAxis2Max","yAxisMin","yAxisMax","zAxisMin","zAxisMax","xAxisUnit","xAxis2Unit","yAxisUnit","zAxisUnit","setMin","setMax","setMin2","setMax2","setMinX","setMaxX","setMinY","setMaxY","setMinZ","setMaxZ","xAxisAbsMin","xAxisAbsMax","xAxis2AbsMin","xAxis2AbsMax","yAxisAbsMin","yAxisAbsMax","zAxisAbsMin","zAxisAbsMax","graphType","x","y","varIndices","smpIndices","grpIndices","varIndicesStart","smpIndicesStart"];var b={};if(this.layoutComb){for(var a=0;a<d.length;a++){b[d[a]]=this.layoutParams[e][d[a]]}}else{for(var a=0;a<d.length;a++){b[d[a]]=this[d[a]]}}return b};this.isAxis=function(h){if(!h){h=window.event}if(this.resizerType&&this.layoutValid){return false}var s=this.adjustedCoordinates(h);if(s){var q=s.x;var o=s.y;var m=0;var r=(this.margin*1);var p=(this.margin*2);var a=18;for(var d=0;d<this.layoutRows;d++){for(var b=0;b<this.layoutCols;b++){var f=this.layoutComb?this.layoutParams[m].graphType:this.graphType;if(f.match(/Network|Pie|Venn|Stacked|Area|Correlation/)){return false}var k=this.getBoundsXY(m);if(f.match(/Scatter/)){if(q>=k[0]&&q<=k[1]&&o>=k[3]&&o<=k[3]+a){var n=this.getAxesVals(m);this.showAxesResizer("xAxis",k[0],k[1],k[3]+r,k[3]+this.getAxisFont(n.x)+p,"x","h","b",n,"X",m,d,b);return true}else{if(q>=k[0]-a&&q<=k[0]&&o>=k[2]&&o<=k[3]){var n=this.getAxesVals(m);this.showAxesResizer("yAxis",k[0]-(this.getAxisFont(n.y)+p),k[0]-r,k[2],k[3],"y","v","l",n,"Y",m,d,b);return true}}}else{if(f.match(/Heatmap/)){if(q>=k[0]-a&&q<=k[0]&&o>=k[2]&&o<=k[3]){var n=this.getAxesVals(m);this.showAxesResizer("xAxis",k[0]-(this.getAxisFont(n.y)+p),k[0]-r,k[2],k[3],"y","v","l",n,"",m,d,b);return true}else{if(q>=k[1]&&q<=k[1]+a&&o>=k[2]&&o<=k[3]){var n=this.getAxesVals(m);this.showAxesResizer("xAxis",k[1]+r,k[1]+this.getAxisFont(n.y)+p,k[2],k[3],"y","v","r",n,"",m,d,b);return true}else{if(q>=k[0]&&q<=k[1]&&o>=k[2]-a&&o<=k[2]){var n=this.getAxesVals(m);this.showAxesResizer("xAxis",k[0],k[1],k[2]-(this.getAxisFont(n.x)+p),k[2]-r,"x","h","t",n,"",m,d,b);return true}else{if(q>=k[0]&&q<=k[1]&&o>=k[3]&&o<=k[3]+a){var n=this.getAxesVals(m);this.showAxesResizer("xAxis",k[0],k[1],k[3]+r,k[3]+this.getAxisFont(n.x)+p,"x","h","b",n,"",m,d,b);return true}}}}}else{if(this.graphOrientation=="vertical"){if(q>=k[0]-a&&q<=k[0]&&o>=k[2]&&o<=k[3]){var n=this.getAxesVals(m);this.showAxesResizer("xAxis",k[0]-(this.getAxisFont(n.y)+p),k[0]-r,k[2],k[3],"y","v","l",n,"",m,d,b);return true}else{if(q>=k[1]&&q<=k[1]+a&&o>=k[2]&&o<=k[3]){var n=this.getAxesVals(m);if(f=="BarLine"){this.showAxesResizer("xAxis2",k[1]+r,k[1]+this.getAxisFont(n.y)+p,k[2],k[3],"y","v","r",n,"2",m,d,b)}else{this.showAxesResizer("xAxis",k[1]+r,k[1]+this.getAxisFont(n.y)+p,k[2],k[3],"y","v","r",n,"",m,d,b)}return true}}}else{if(q>=k[0]&&q<=k[1]&&o>=k[2]-a&&o<=k[2]){var n=this.getAxesVals(m);this.showAxesResizer("xAxis",k[0],k[1],k[2]-(this.getAxisFont(n.x)+p),k[2]-r,"x","h","t",n,"",m,d,b);return true}else{if(q>=k[0]&&q<=k[1]&&o>=k[3]&&o<=k[3]+a){var n=this.getAxesVals(m);if(f=="BarLine"){this.showAxesResizer("xAxis2",k[0],k[1],k[3]+r,k[3]+this.getAxisFont(n.x)+p,"x","h","b",n,"2",m,d,b)}else{this.showAxesResizer("xAxis",k[0],k[1],k[3]+r,k[3]+this.getAxisFont(n.x)+p,"x","h","b",n,"",m,d,b)}return true}}}}}m++}}}return false};this.endAxesResizer=function(a){if(this.axesResizingOn){this.resetInfoSpan(a);if(this.resizerEventData.active=="prev"||this.resizerEventData.active=="next"){this.moveAxesResizer(a)}this.drawAxesResizerUpdate(true);this.axesResizingOn=false}else{if(this.resizerType){this.updateResizerEventData();this.refreshAxesResizer()}}};this.resetAxesResizer=function(b){if(this.axesResizerShow){var a=document.getElementById(this.target+"canvasXpressAxesResize");if(a){this.addRemoveAxesResizerListeners("removeEvtListener");a.style.display="none";this.resizerEventData={};this.resetInfoSpan(b);this.axesResizerShow=false}}};this.initializeAxisResizerEvents=function(){if(!this.disableEvents){this.addAxesResizeDiv()}};this.initializeAxisResizerEvents()};CanvasXpress.prototype.initEvents=function(){this.cancelEvent=function(a){if(!a){a=window.event}if(a.preventDefault){a.preventDefault()}else{a.returnValue=true}};this.stopEvent=function(a){if(!a){a=window.event}if(a.stopPropagation){a.stopPropagation()}else{a.cancelBubble=true}};this.normalizeEvtName=function(a){return this.isIE?"on"+a:a};this.addEvtListener=function(d,b,g,a){if(this.isIE){d.attachEvent(this.normalizeEvtName(b),g)}else{d.addEventListener(b,g,a);if(b=="mousewheel"){d.addEventListener("DOMMouseScroll",g,a)}}};this.removeEvtListener=function(d,b,g,a){if(this.isIE){d.detachEvent(this.normalizeEvtName(b),g)}else{d.removeEventListener(b,g,a);if(b=="mousewheel"){d.removeEventListener("DOMMouseScroll",g,a)}}};this.destroy=function(a){if(a){if(CanvasXpress.references.length==1&&CanvasXpress.references[i].target==a){return this.destroy()}else{this.removeReference(a)}}else{while(CanvasXpress.references.length>0){a=CanvasXpress.references[0];this.removeReference(a.target)}}};this.removeReference=function(e,b){var d=CanvasXpress.references;CanvasXpress.references=[];for(var c=0;c<d.length;c++){if(d[c].target!=e){CanvasXpress.references.push(d[c])}else{var f=d[c];f.cleanEvtListeners(b);f.removeTarget("wrapper-"+f.target);f.removeTarget(f.target+"canvasXpressCode");f.removeTarget(f.target+"canvasXpressInfoDiv");f.removeTarget(f.target+"canvasXpressDataTable")}}};this.cleanEvtListeners=function(b){this.addRemoveConfiguratorListeners("removeEvtListener");this.addRemoveDataTableListeners("removeEvtListener");this.addRemoveCanvasListeners("removeEvtListener");this.resetMap();this.addRemoveAxesResizerListeners("removeEvtListener");this.addRemoveNavigationTopListeners("removeEvtListener");this.addRemoveNavigationLeftRightListeners("removeEvtListener");this.removeEvtListener(document,"mousemove",this.mousemoveDoc,false);this.removeEvtListener(document,"mouseup",this.mouseupDoc,false);this.removeEvtListener(document,"keydown",this.keydownDoc,false);this.removeEvtListener(document,"keyup",this.keyupDoc,false);this.removeEvtListener(window,"resize",this.resizeWindow,false)};this.adjustedCoordinates=function(g,d){if(!d){d=document.getElementById(this.target+"canvasXpressImage")}if(d){var j={};var f=d.parentNode.getClientRects();if(f&&f[0]){var b=f[0].left;var d=f[0].top;var a=g&&g.clientX?g.clientX:g&&g[0]?g[0]:b;var h=g&&g.clientY?g.clientY:g&&g[1]?g[1]:d;j.x=document.body.scrollLeft>Math.abs(b)+a&&a>document.body.scrollLeft-b?Math.abs(b)+a:a-b;j.y=document.body.scrollTop>Math.abs(d)+h&&h>document.body.scrollTop-d?Math.abs(d)+h:(h-d)}else{j.x=0;j.y=0}return j}};this.isPointInsideArea=function(o,n,m,k){switch(o){case"rect":if(k[0]>k[2]){k[4]=k[0];k[0]=k[2];k[2]=k[4]}if(k[1]>k[3]){k[4]=k[1];k[1]=k[3];k[3]=k[4]}if(n>=k[0]&&n<=k[2]&&m>=k[1]&&m<=k[3]){return true}else{return false}case"circle":var f=k[2]/2;k[0]=parseInt(k[0]);k[1]=parseInt(k[1]);if(n>=k[0]-f&&n<=k[0]+f&&m>=k[1]-f&&m<=k[1]+f){return true}else{return false}case"poly":var d=[];var a=[];var g=false;for(var e=0;e<k.length;e++){if(e%2){a.push(k[e])}else{d.push(k[e])}}if(a[0]<a[1]){a=a.reverse();d=d.reverse()}for(var e=0,b=d.length-1;e<d.length;b=e++){if(((a[e]<=m&&m<a[b])||(a[b]<=m&&m<a[e]))&&(n<(d[b]-d[e])*(m-a[e])/(a[b]-a[e])+d[e])){g=!g}}return g}};this.isEvent=function(o,g){var u=this.adjustedCoordinates(o);if(u){var b=o.target||o.srcElement;if(b&&b.id&&b.id.match(this.target)){var t=u.x;var q=u.y;if(this.modelEvent=="local"){var h=document.getElementById(this.target+"canvasXpressMap");if(h){var r=h.childNodes;for(var j=r.length-1;j>=0;j--){var d=r[j].id.replace(this.target,"");var v=r[j].shape;var p=r[j].coords.split(",");if(this.isPointInsideArea(v,t,q,p)){return d}}}}else{var r=this.dataEvent;for(var j=r.length-1;j>=0;j--){var d=r[j][0];var v=r[j][1];var p=r[j][2];var k=r[j][3];if(this.isPointInsideArea(v,t,q,p)){if(k){k=d[0]+k}return g?[d,k]:k?[k]:d}}}}}return false};this.getBoundsXY=function(e){var d=this.layoutComb?this.layoutParams[e]:this;var a=this.graphType=="Network"?0:this.marginLeft+d.offsetX+d.left;var b=this.graphType=="Network"?0:this.marginTop+d.offsetY+d.top;return[a,a+d.x,b,b+d.y]};this.extractDataObject=function(h,b){var k=this;var B=this.layoutComb&&this.layoutValidN>-1?this.layoutParams[this.layoutValidN].graphType:this.graphType;var H=[];var F=[];var E=[];var v=function(d){var n={};for(var j in k.data.x){n[j]=[];for(var g=0;g<d.length;g++){n[j].push(k.data.x[j][d[g]])}}return n};var u=function(d){var n={};for(var j in k.data.z){n[j]=[];for(var g=0;g<d.length;g++){n[j].push(k.data.z[j][d[g]])}}return n};var C=function(d){var j=[];for(var g=0;g<d.length;g++){j.push(k.data.y.vars[d[g]])}return j};var m=function(j,p){var d=p?k.data.w.smps:k.data.y.smps;var t=[];for(var n=0;n<j.length;n++){t.push(d[j[n]])}return t};var f=function(d){var j=[];for(var g=0;g<d.length;g++){j.push(k.data.w.grps[d[g]])}return j};var e=function(g,d){var t=[];if(d){for(var p=0;p<g.length;p++){t[p]=[];for(var n=0;n<d.length;n++){t[p].push(k.data.y.data[g[p]][d[n]])}}}else{for(var p=0;p<g.length;p++){t.push(k.data.y.data[g[p]])}}return t};switch(B){case"Area":case"AreaLine":case"Bar":case"Line":case"BarLine":case"Boxplot":case"Dotplot":case"Heatmap":case"Pie":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Scatter2D":case"ScatterBubble2D":case"Scatter3D":case"Candlestick":if(!h||h.length==0||h[0]==null){return}else{if(isNaN(h[0])){if(h[0]&&h[0].match(/Dendrogram/)){var x={t:{}};var w=h[0].split("-");x.t.d=parseInt(w[1]);x.t.o=parseInt(w[2]);x.t.t=w[3];return x}else{if(h[0]&&h[0].match(/Var/)){var w=h[0].split("-");var A=parseInt(w[1]);var G=[A];G=G.concat(this.smpIndices);var x=this.extractDataObject(G);x.display=this.data.y.vars[A];return x}else{if(h[0]&&h[0].match(/Smp/)){var w=h[0].split("-");var A=parseInt(w[1]);var x=this.extractDataObject([A],this.varIndices);x.display=this.isGroupedData?this.data.w.smps[A]:this.data.y.smps[A];return x}else{return}}}}else{if(b){H=b;F=h}else{H=[h[0]];F=[];for(var A=1;A<h.length;A++){F.push(h[A])}}if(B.match(/Scatter/)){if(this.colorBy&&this.getSampleIndices(this.colorBy)>-1){F.push(this.getSampleIndices(this.colorBy))}if(this.shapeBy&&this.getSampleIndices(this.shapeBy)>-1){F.push(this.getSampleIndices(this.shapeBy))}if(this.sizeBy&&this.getSampleIndices(this.sizeBy)>-1){F.push(this.getSampleIndices(this.sizeBy))}}}}if(B.match(/Area/)){return{x:this.data.x,y:{vars:C(H),smps:this.data.y.smps,data:e(H)},z:u(H)}}else{if(this.isGroupedData){var x={x:{},w:{},z:u(H)};for(var w in this.data.w){if(w=="smps"){x.w[w]=m(F,true)}else{if(w=="grps"){x.w[w]=f(F)}else{if(w=="vars"){x.w[w]=C(H)}else{if(this.data.w[w].length>H[0]&&this.data.w[w][H[0]].length>F[0]){x.w[w]=[];x.w[w].push(this.data.w[w][H[0]][F[0]])}}}}}for(var w in this.data.x){var q=[];for(var A=0;A<x.w.grps[0].length;A++){q.push(this.data.x[w][x.w.grps[0][A]])}x.x[w]=q}}else{var x={x:v(F),y:{vars:C(H),smps:m(F)},z:u(H)};if(B=="Candlestick"){for(var w in this.data.y){if(w&&w!="vars"&&w!="smps"&&w!="desc"){x.y[w]=[];for(var A=0;A<H.length;A++){x.y[w][A]=[];for(var z=0;z<F.length;z++){x.y[w][A].push(this.data.y[w][H[A]][F[z]])}}}}}else{x.y.data=e(H,F)}}}return x;case"Correlation":if(!h||(isNaN(h[0])&&!h[0].match(/^\d/))){return}else{var D=this.isGroupedData?this.data.w.cor:this.data.y.cor}if(this.correlationAxis=="samples"){var x={x:{},y:{}};for(var w in this.data.x){var q=[];for(var A=0;A<h.length;A++){q.push(this.data.x[w][h[A]])}x.x[w]=q}x.y.smps=[this.data.y.smps[h[0]],this.data.y.smps[h[1]]]}else{var x={y:{},z:{}};for(var w in this.data.y){var c=[];for(var A=0;A<h.length;A++){c.push(this.data.y[w][h[A]])}x.z[w]=c}x.y.vars=[this.data.y.vars[h[0]],this.data.y.vars[h[1]]]}x.y.data=D[h[0]][h[1]];return x;case"Venn":var x={venn:{data:{}}};x.venn.data[this.vennCompartments[h[0]]]=this.data.venn.data[this.vennCompartments[h[0]]];return x;case"Network":var x={};if(!h||h.length==0){return}if(isNaN(h[0])){h[0]=h[0].toString();if(h[0].match(/legend/)){if(h[0].match(/Nodes/)){x={nodeLegend:this.data.legend.nodes}}else{if(h[0].match(/Edges/)){x={edgeLegend:this.data.legend.edges}}else{if(h[0].match(/Decorations/)){x={decorationLegend:this.data.legend.decorations}}else{var r=parseInt(h[0].replace("-1-legend-Text",""));x={textLegend:this.data.legend.text[r]}}}}}}else{for(var A=0;A<h.length;A++){if(h[A]>=this.data.nodes.length){if(!x.edges){x.edges=[]}x.edges.push(this.data.edges[h[A]-this.data.nodes.length])}else{if(!x.nodes){x.nodes=[]}x.nodes.push(this.data.nodes[h[A]])}}}return x;case"Genome":var x=[];x[0]={};var r=0;for(var A=0;A<this.data.tracks.length;A++){var y=this.data.tracks[A].data.length;r+=y;if(h[0]<r){var s=h[0]-(r-y);for(var w in this.data.tracks[A]){if(w=="data"){x[0][w]=[];x[0][w].push(this.data.tracks[A][w][s])}else{x[0][w]=this.data.tracks[A][w]}}return x}}}};this.getSummaryDataObject=function(h){if(h){switch(this.graphType){case"Bar":case"Line":case"Area":case"AreaLine":case"BarLine":case"Boxplot":case"Dotplot":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Scatter2D":case"ScatterBubble2D":case"Scatter3D":var g="";if(h.display){return"<b>"+h.display+"</b><br>"}else{if(this.isGroupedData&&h.w){g="<b>"+h.w.vars[0]+"</b><br>";if(this.summaryType=="mean"){for(var b=0;b<h.w.smps.length;b++){g+="<b>"+h.w.smps[b]+"</b>: "+h.w.mean[b]+"<br>"}}else{if(this.summaryType=="median"||this.summaryType=="iqr"){for(var b=0;b<h.w.smps.length;b++){g+="<b>"+h.w.smps[b]+"</b>: "+h.w.median[b]+"<br>"}}else{if(this.summaryType=="sum"){for(var b=0;b<h.w.smps.length;b++){g+="<b>"+h.w.smps[b]+"</b>: "+h.w.sum[b]+"<br>"}}}}}else{if(h.y){g="<b>"+h.y.vars[0]+"</b><br>";for(var b=0;b<h.y.smps.length;b++){g+="<b>"+h.y.smps[b]+"</b>: "+h.y.data[0][b]+"<br>"}}else{if(h.t){g="<b>"+h.t.t+"</b><br>Depth: "+h.t.d+"<br>"}}}}return g;case"Pie":var f="<b>"+h.y.smps[0]+"</b><br>";for(var b=0;b<h.y.vars.length;b++){var d=sprintf("%."+this.pieSegmentPrecision+"f",(h.y.data[b]/this.varPie.tot)*100);f+="<b>"+h.y.vars[b]+"</b>: "+h.y.data[b]+" ("+d+"%)<br>"}return f;case"Candlestick":return dateFormat(h.y.smps[0],this.timeFormat)+", "+h.y.close[0];case"Correlation":var f;if(this.correlationAxis=="samples"){f=h.y.smps[0]+" vs "+h.y.smps[1]}else{f=h.y.vars[0]+" vs "+h.y.vars[1]}return f;case"Venn":for(var a in h.venn.data){return a+" = "+h.venn.data[a]}case"Network":var f;if(h&&h.nodes){if(h.nodes[0]){f=h.nodes[0].name||h.nodes[0].label||h.nodes[0].id}}else{if(h&&h.edges){var e=this.nodes[h.edges[0].id1];var c=this.nodes[h.edges[0].id2];f=(e.label||e.id)+" - "+(c.label||c.id)}}return f;case"Genome":return h[0].data[0].id}}else{return""}};this.setUserEvents=function(){this.userEvents={};if(this.disableEvents){return}var b=this;if(this.events&&this.events.enddragnode){this.userEvents.enddragnode=this.events.enddragnode}if(this.events&&this.events.mouseout){this.userEvents.mouseout=this.events.mouseout}else{this.userEvents.mouseout=function(f,d){b.resetInfoSpan(d)}}if(this.events&&this.events.click){this.userEvents.click=this.events.click}else{this.userEvents.click=function(f,d){if(f&&f.t){b.modifyDendrogram(f)}else{b.updateDataTable(f)}return false}}if(this.events&&this.events.dblclick){this.userEvents.dblclick=this.events.dblclick}else{this.userEvents.dblclick=function(f,d){if(f){alert(b.prettyJSON(f))}return false}}var c=["mouseover"];if(b.modelEvent!="local"){c.push("mousemove")}for(var a=0;a<c.length;a++){if(this.events&&this.events[c[a]]){this.userEvents[c[a]]=this.events[c[a]]}else{this.userEvents[c[a]]=function(g,d){var f=b.getSummaryDataObject(g);if(f&&f!=""){b.showInfoSpan(d,f)}}}}};this.resetFlags=function(a){this.resetOn=true;this.animationOn=false;this.draggingOn=false;this.movingOn=false;this.xMouseDown=false;this.yMouseDown=false;this.moveNode=false;this.moveNodeIndex=false;this.moveNodeLab=false;this.moveNodeDec=false;this.moveLegend=false;this.moveNodeX=false;this.moveNodeY=false;this.moveNodeW=false;this.moveNodeH=false;if(a){this.stopEvent(a)}document.defaultAction=true;document.body.style.cursor="default"};this.mousemoveDoc=function(a){return function(d){var b=document.getElementById(a.target+"canvasXpressImage");if(a.isVersion(d)){b.style.cursor="help";a.showInfoSpan([d.clientX,d.clientY+50],"CanvasXpress ("+a.version+")")}else{if(a.draggingDataTableOn){a.updateDataTableDiv(d)}else{if(a.resizingDataTableOn){a.updateDataTableResizerDiv(d)}else{if(b&&a.isInView(b)){if(!a.configuringOn){a.cancelEvent(d);if(a.draggingOn){a.updateDragDiv(d)}else{if(a.resizingCanvasOn&&a.resizeCanvasCursorShow){a.updateCanvasResizer(d)}else{a.updateCanvasResizerCursor(d)}}if(a.modelEvent!="local"){var c=a.isEvent(d);if(c){a.handleMouseAreaEvents("mousemove",d,c)}else{a.resetInfoSpan(d,true)}}}}}}}return false}}(this);this.initDocEvents=function(){this.mouseupDoc=function(a){return function(b){if(a.draggingDataTableOn){a.endDataTableDiv(b)}else{if(a.resizingDataTableOn){a.endDataTableResizerDiv(b)}else{if(!a.configuringOn){a.stopEvent(b);a.endDragDiv(b);a.endCanvasResizer(b);a.endAxesResizer(b);a.resetFlags(b)}}}}}(this);this.keydownDoc=function(a){return function(c){var b=document.getElementById(a.target+"canvasXpressImage");if(b&&a.isInView(b)){a.registerKey(c)}}}(this);this.keyupDoc=function(a){return function(c){var b=document.getElementById(a.target+"canvasXpressImage");if(b&&a.isInView(b)){if(a.configuringOn){a.selectConfig(c)}}}}(this);this.resizeWindow=function(a){return function(b){a.resizeImage(true);return false}}(this);this.addEvtListener(document,"mousemove",this.mousemoveDoc,false);this.addEvtListener(document,"mouseup",this.mouseupDoc,false);this.addEvtListener(document,"keydown",this.keydownDoc,false);this.addEvtListener(document,"keyup",this.keyupDoc,false);this.addEvtListener(window,"resize",this.resizeWindow,false)};this.initializeEvents=function(){this.setUserEvents();this.initConfigurator();this.initDataTable();this.initDraggingEvents();this.initCanvasResizerEvents();this.initAxisResizerEvents();this.initInfoEvents();this.initKeyEvents();this.initSelectEvents();this.initDendrogramEvents();this.initImageMapEvents();this.initCodeInfo();this.initDocEvents()};this.initializeEvents()};CanvasXpress.prototype.initAnimation=function(){this.saveSnapshot=function(){var a=this.cloneVisualData(this.data);if(a){this.snapshots.push(a)}};this.playSnapshot=function(b,d,c){if(this.snapshots.length<1){return}this.stopSnapshotPlay();var a=this;this.snapshotPlay={idx:0,time:b,task:setTimeout(function(){a.nextSnapshot(c)},0),callback:d,oldData:this.data};this.snapshotPaused=false};this.nextSnapshot=function(c){if(this.snapshotPlay.idx>=this.snapshots.length){if(this.snapshotPlay.callback){this.snapshotPlay.callback.call(this,c)}else{this.snapshotPlay.idx=0}}if(this.snapshotPlay){var b=this.snapshotPlay.time||this.snapshots[this.snapshotPlay.idx].time||50;this.loadData(this.snapshots[this.snapshotPlay.idx++],true);var a=this;this.snapshotPlay.task=setTimeout(function(){a.nextSnapshot(c)},b);this.snapshotPaused=false}};this.stopSnapshotPlay=function(a){if(!this.snapshotPlay){return}clearTimeout(this.snapshotPlay.task);this.loadData(this.snapshotPlay.oldData,a);delete this.snapshotPlay;this.snapshotPaused=false};this.clearSnapshot=function(){this.stopSnapshotPlay(true);this.snapshots=[];this.snapshotPaused=false};this.duplicateSnapshot=function(){if(this.snapshots.length<1){return}var a=(this.snapshotPlay?this.snapshotPlay.idx:this.snapshots.length)-1;var b=this.cloneVisualData(this.snapshots[a]);if(this.snapshotPlay){this.snapshots.splice(a+1,0,b);this.snapshotPlay.idx++}else{this.snapshots.push(b)}};this.makeSnapshotPlay=function(){if(!this.snapshotPlay){this.snapshotPlay={idx:this.snapshots.length,oldData:this.data}}else{this.pauseSnapshot()}};this.moveSnapshot=function(c){if(this.snapshots.length<1){return}this.makeSnapshotPlay();var b=this.snapshotPlay.idx-1,a=b+c;if(a>=0&&a<=this.snapshots.length){this.snapshots.splice(a,0,(this.snapshots.splice(b,1))[0])}this.snapshotPlay.idx=a+1};this.prevSnapshotOnce=function(){if(this.snapshots.length<2){return}this.makeSnapshotPlay();this.snapshotPlay.idx-=2;if(this.snapshotPlay.idx<0){this.snapshotPlay.idx=0}this.loadData(this.snapshots[this.snapshotPlay.idx++],true);this.snapshotPaused=true};this.nextSnapshotOnce=function(){if(!this.snapshotPlay){return}if(this.snapshotPlay.idx<this.snapshots.length){this.loadData(this.snapshots[this.snapshotPlay.idx++],true)}this.snapshotPaused=true};this.hasNextSnapshot=function(){return this.snapshots.length>1&&this.snapshotPlay&&this.snapshotPaused&&this.snapshotPlay.idx<this.snapshots.length};this.hasPrevSnapshot=function(){return this.snapshots.length>1&&(!this.snapshotPlay||(this.snapshotPlay.idx>1&&this.snapshotPaused))};this.updateSnapshot=function(){if(this.snapshotPlay){this.snapshots[this.snapshotPlay.idx-1]=this.cloneVisualData(this.data)}};this.pauseSnapshot=function(){if(!this.snapshotPlay){return}if(this.snapshotPlay.task){clearTimeout(this.snapshotPlay.task)}this.snapshotPaused=true};this.setSnapshotTime=function(a){if(a>0){this.snapshots[this.snapshotPlay.idx-1].time=a}};this.getSnapshotTime=function(){return this.snapshots[this.snapshotPlay.idx-1].time||50};this.assembleObj=function(b,k,p){var e=[];if(!k[p]){return b[p]}if(!k[p].indices){k[p].indices={}}for(var h=0;h<b[p].length;h++){var f=b[p][h],a=f.id||f.id1+"-"+f.id2;if(!k[p].deleted[a]){var m=k[p].changed[a];if(m){for(var g in m){f[g]=m[g]}}var q=k[p].indices[a]!=null?k[p].indices[a]:p=="nodes"?b.nodeIndices[a]:b.edgeIndices[a];e[q]=f;k[p].indices[a]=q}}for(var a in k[p].added){e[k[p].indices[a]]=k[p].added[a]}return e};this.assembleData=function(b,c){var a={};a.nodes=this.assembleObj(b,c,"nodes");a.nodeIndices=c.nodes&&c.nodes.indices?c.nodes.indices:b.nodeIndices;a.edges=this.assembleObj(b,c,"edges");a.legend=c.legend||b.legend;return a};this.loadData=function(d,e){this.data=d;switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Dotplot":case"Scatter2D":case"ScatterBubble2D":break;case"Scatter3D":case"Area":case"AreaLine":case"Boxplot":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Candlestick":case"Correlation":case"Venn":case"Pie":case"Genome":return false;break;case"Network":if(this.data.type=="changedData"){this.data=this.assembleData(this.cloneObject(this.snapshotsBase),this.cloneObject(this.data))}this.edges=this.data.edges;var b={};for(var c=0;c<this.data.nodes.length;c++){var a=this.data.nodes[c];b[a.id]=a}this.nodes=b;break}if(e){this.draw(false,false,true)}};this.changedNodeData=function(c,g){var j={deleted:{},changed:{},added:{}};for(var b in c.nodeIndices){var k=g.nodeIndices[b];if(k==null){j.deleted[b]=1}else{var h=c.nodes[c.nodeIndices[b]],e=g.nodes[k],m={id:b},f=false;for(var a in e){if(!this.isSameObject(e[a],h[a])){m[a]=e[a];f=true}}if(f){j.changed[b]=m}}}for(var b in g.nodeIndices){if(c.nodeIndices[b]==null){j.added[b]=g.nodes[g.nodeIndices[b]]}}j.indices=this.changedIndices(c.nodeIndices,g.nodeIndices);return j};this.getEdgeIndices=function(f){var b={};if(f.edges.length){for(var a=0;a<f.edges.length;a++){var c=f.edges[a];b[c.id1+"-"+c.id2]=a}}return b};this.changedEdgeData=function(f,g){var c={deleted:{},changed:{},added:{}};if(!f.edgeIndices){f.edgeIndices=this.getEdgeIndices(f)}var e=this.getEdgeIndices(g);for(var h in f.edgeIndices){var a=e[h];if(a==null){c.deleted[h]=1}else{var b=g.edges[a];if(!this.isSameObject(f.edges[f.edgeIndices[h]],b)){c.changed[h]=b}}}for(var h in e){if(f.edgeIndices[h]==null){c.added[h]=g.edges[e[h]]}}c.indices=this.changedIndices(f.edgeIndices,e);return c};this.changedIndices=function(b,c){var a={};for(var e in c){if(b[e]==null||b[e]!=c[e]){a[e]=c[e]}}return a};this.getSnapshotChanged=function(b){var a=this.snapshotsBase;return{type:"changedData",nodes:this.changedNodeData(a,b),edges:this.changedEdgeData(a,b),legend:this.isSameObject(a.legend,b.legend)?null:b.legend}};this.cloneVisualData=function(f){switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Dotplot":case"Scatter2D":case"ScatterBubble2D":return this.cloneObject(f);break;case"Scatter3D":case"Area":case"AreaLine":case"Boxplot":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Candlestick":case"Correlation":case"Venn":case"Pie":case"Genome":return false;break;case"Network":if(this.snapshotCopyChangeOnly){if(this.snapshots.length){return f.type=="changedData"?this.cloneObject(f):this.getSnapshotChanged(f)}else{this.snapshotsBase=this.cloneObject(f);return{type:"changedData"}}}if(!this.snapshotNoCopyData){return this.cloneObject(f)}var c={nodes:[],edges:[]};if(f.nodes&&f.nodes.length){for(var b=0;b<f.nodes.length;b++){var g={};var e=f.nodes[b];var h=["outline","width","height","pattern","rotate","color","shape","size","x","y","id","hideName","hideChildren","hideParent","label","labelX","labelY","labelSize","name","hide","anchor","parentNode","imagePath"];for(var a=0;a<h.length;a++){g[h[a]]=e[h[a]]}c.nodes.push(g)}}if(f.edges&&f.edges.length){for(var b=0;b<f.edges.length;b++){var g={};var e=f.edges[b];var h=["color","width","type","id1","id2","anchor"];for(var a=0;a<h.length;a++){g[h[a]]=e[h[a]]}c.edges.push(g)}}return c;break}};this.isValidAnimation=function(){switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Dotplot":case"Scatter2D":case"ScatterBubble2D":return true;case"Scatter3D":case"Area":case"AreaLine":case"Boxplot":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Candlestick":case"Correlation":case"Venn":case"Pie":case"Genome":case"Network":return false}};this.createAnimation=function(e){switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Dotplot":case"Scatter2D":case"ScatterBubble2D":this.isAnimation=true;var f=this.cloneVisualData(this.data);if(e.match(/grow|spring|random/)&&this.data.y.data){var d=this.animationCycles;for(var c=0;c<d;c++){for(var b=0;b<this.data.y.data.length;b++){for(var a=0;a<this.data.y.data[b].length;a++){if(!isNaN(this.data.y.data[b][a])){var g=this.data.y.data[b][a];if(e=="grow"){this.data.y.data[b][a]=g/d*c}else{if(e=="spring"){this.data.y.data[b][a]=g/(d-1.5)*(c+1)}else{this.data.y.data[b][a]=g/d*Math.floor(Math.random()*c)}}}}}this.saveSnapshot();this.data=this.cloneVisualData(f)}}this.data=f;this.saveSnapshot();this.playSnapshot(this.animationTime,this.stopAnimation);break;case"Scatter3D":case"Area":case"AreaLine":case"Boxplot":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Candlestick":case"Correlation":case"Venn":case"Pie":case"Genome":case"Network":return;break}};this.stopAnimation=function(){this.stopSnapshotPlay();this.snapshots=[];this.isAnimation=false};this.setSnapshotsData=function(a){this.snapshots=a.ss||a;this.snapshotsBase=a.base};this.getSnapshotsData=function(){return{base:this.snapshotsBase,ss:this.snapshots}};this.createDemoNetworkAnimation=function(h){var q=[],e={},s=[];for(var v=0;v<h;v++){var o=v+1;q.push({size:0.5,x:Math.floor(Math.random()*h*5),y:Math.floor(Math.random()*h*5),outline:"rgb(255,255,255)",color:"rgb(255,0,0)",id:o,label:o,hideName:true,labelSize:0.7,name:"Node "+o,pattern:"closed",shape:"star"});e[o]=v}var d={nodes:q,nodeIndices:e,edges:[],edgeIndices:{}};s.push({type:"changedData"});var t=10;var b=5;var p=255/b;var a=0.5/b;var k=5;for(var u=0;u<t;u++){var n=Math.floor(Math.random()*q.length);for(var v=0;v<b;v++){var g=Math.floor(255-(v+1)*p);var m=Math.floor((v+1)*p),w=[g,m,m];var f={};f[q[n].id]={size:0.5+a*(v+1),color:"rgb("+w.join(",")+")"};s.push({type:"changedData",nodes:{deleted:{},added:{},changed:f},time:5})}}this.setSnapshotsData({base:d,ss:s})};this.createDemoNetworkAnimation1=function(){var b=[];var m={};var p=[];var o=10;var n=200;var a="ball";var f={width:o,x:100,y:0,color:"rgb(0,255,0)",id:a,label:a,hideName:true,labelSize:0.7,name:a,pattern:"closed",shape:"sphere"};a="plank";var g={width:200,height:5,x:100,y:n,color:"rgb(255,255,0)",id:a,label:a,hideName:true,labelSize:0.7,name:a,pattern:"closed",shape:"rectangle"};a="ref";var d={width:10,x:80,y:0,color:"rgb(0,0,255)",id:a,label:a,hideName:true,labelSize:0.7,name:a,pattern:"closed",shape:"sphere"};var c={nodes:[f,g,d],nodeIndices:{ball:0,plank:1,ref:2},edges:[],edgeIndices:{}};p.push({type:"changedData"});for(var k=1,h=0;h<n-o/2;h+=o/2,k+=0.1){var e=k*k;p.push({type:"changedData",nodes:{deleted:{},added:{},changed:{ball:{y:h,time:25*o>h?50-h*2/o:5}}},time:100/e})}this.setSnapshotsData({base:c,ss:p})}};CanvasXpress.prototype.initData=function(a){this.exampleRawData={x:{Tissue:["Kidney","Liver","Kidney","Liver","Kidney","Liver","Kidney","Liver"],Donor:["D1","D1","D1","D1","D2","D2","D2","D2"],Time:["1h","1h","2h","2h","1h","1h","2h","2h"]},z:{Symbol:["abc","def","ghi","jkl","mno","pqr"],Cat:["A","A","B","C","D","C"],Class:["A","A","A","A","A","B"]},y:{vars:["Gene1","Gene2","Gene3","Gene4","Gene5","Gene6"],smps:["Smp1","Smp2","Smp3","Smp4","Smp5","Smp6","Smp7","Smp8"],desc:["Intensity","Normalized Intensity"],data:[[10,12,3,4,100,73,42,64],[12,4,60,5,24,14,32,13],[7,12,20,13,49,52,42,92],[21,10,30,8,65,166,47,58],[15,14,100,5,34,30,82,51],[100,82,73,4,3,4,5,2]]},a:{xAxis:["Gene1","Gene2","Gene3"],xAxis2:["Gene4","Gene5","Gene6"]},t:{vars:"((Gene6:0.2,Gene3:0.3):0.2,((Gene1:0.25,(Gene4:0.15,Gene2:0.3):0.2):0.3,Gene5:0.7):0.1)",smps:"((Smp2:0.8,(Smp4:0.7,((Smp1:0.6,(Smp6:0.2,Smp5:0.1):0.2):0.15,(Smp8:0.15,Smp3:0.05):0.1):0.15):0.2):0.05,Smp7:0.9)"},d:{nlfit:[{param:[1,100,50,1,1.23e-7],label:"Fit Example",type:"reg"}]},l:{vars:[["Gene1","Gene2","Gene3","Gene4","Gene5"],["Gene6"]],weight:[0.7,0.3],type:["Bar","Line"],desc:["Intensity","Score"]},venn:{data:{A:340,B:562,C:620,D:592,AB:639,AC:456,AD:257,BC:915,BD:354,CD:143,ABC:552,ABD:578,ACD:298,BCD:613,ABCD:148},legend:{A:"List 1",B:"List 2",C:"List 3",D:"List 4"}},nodes:[{id:"Gene1",color:"rgb(255,0,0)",shape:"square",size:1},{id:"Gene2",color:"rgb(255,0,0)",shape:"square",size:1.8},{id:"Gene3",color:"rgb(255,0,0)",shape:"square",size:1.4},{id:"Gene4",color:"rgb(255,0,0)",shape:"square",size:1.2},{id:"Gene5",color:"rgb(255,0,0)",shape:"square",size:1.3},{id:"Gene6",color:"rgb(255,0,0)",shape:"square",size:1},{id:"Gene7",color:"rgb(255,0,0)",shape:"square",size:1},{id:"Gene8",color:"rgb(255,0,0)",shape:"square",size:1},{id:"SNP1",color:"rgb(0,255,0)",shape:"sphere",size:1},{id:"SNP2",color:"rgb(0,255,0)",shape:"sphere",size:1},{id:"SNP3",color:"rgb(0,255,0)",shape:"sphere",size:1},{id:"SNP4",color:"rgb(0,255,0)",shape:"sphere",size:1.5},{id:"SNP5",color:"rgb(0,255,0)",shape:"sphere",size:1},{id:"SNP6",color:"rgb(0,255,0)",shape:"sphere",size:1},{id:"SNP7",color:"rgb(0,255,0)",shape:"sphere",size:1},{id:"SNP8",color:"rgb(0,255,0)",shape:"sphere",size:1.2},{id:"PH1",color:"rgb(0,255,255,0.5)",shape:"triangle",size:1,hideChildren:false},{id:"PH2",color:"rgb(0,255,255,0.6)",shape:"triangle",size:1,parentNode:"PH1"},{id:"PH3",color:"rgb(0,255,255,0.7)",shape:"triangle",size:1,parentNode:"PH1"},{id:"PH4",color:"rgb(0,255,255,0.8)",shape:"triangle",size:1,parentNode:"PH3"}],edges:[{id1:"Gene1",id2:"Gene2",color:"rgb(51,102,255)",width:"1",type:"line"},{id1:"Gene2",id2:"Gene3",color:"rgb(51,102,255)",width:"1",type:"arrowHeadLine"},{id1:"Gene1",id2:"Gene4",color:"rgb(51,102,255)",width:"1",type:"arrowHeadLine"},{id1:"Gene3",id2:"Gene5",color:"rgb(51,102,255)",width:"1",type:"dashedArrowHeadLine"},{id1:"Gene6",id2:"Gene5",color:"rgb(51,102,255)",width:"1",type:"arrowHeadSquareTailLine"},{id1:"Gene7",id2:"Gene5",color:"rgb(153,153,255)",width:"1",type:"dottedArrowHeadLine"},{id1:"Gene8",id2:"Gene7",color:"rgb(51,102,255)",width:"1",type:"line"},{id1:"Gene4",id2:"Gene7",color:"rgb(51,102,255)",width:"1",type:"squareHeadArrowTailLine"},{id1:"Gene1",id2:"SNP2",color:"rgb(153,102,255)",width:"1",type:"bezierLine"},{id1:"SNP1",id2:"SNP4",color:"rgb(51,102,152)",width:"1",type:"line"},{id1:"SNP5",id2:"Gene5",color:"rgb(153,102,255)",width:"1",type:"arrowHeadLine"},{id1:"SNP1",id2:"PH2",color:"rgb(51,102,152)",width:"1",type:"line"},{id1:"SNP1",id2:"Gene2",color:"rgb(51,102,152)",width:"1",type:"line"},{id1:"PH4",id2:"SNP7",color:"rgb(153,102,255)",width:"1",type:"arrowHeadLine"},{id1:"PH2",id2:"Gene5",color:"rgb(51,102,152)",width:"1",type:"line"},{id1:"PH1",id2:"Gene7",color:"rgb(153,102,255)",width:"1",type:"arrowHeadLine"},{id1:"PH3",id2:"Gene2",color:"rgb(51,102,152)",width:"1",type:"line"},{id1:"SNP6",id2:"Gene2",color:"rgb(51,102,152)",width:"1",type:"line"},{id1:"SNP3",id2:"Gene4",color:"rgb(153,102,255)",width:"1",type:"arrowHeadLine"},{id1:"SNP4",id2:"Gene5",color:"rgb(51,102,152)",width:"1",type:"line"},{id1:"SNP5",id2:"Gene7",color:"rgb(153,102,255)",width:"1",type:"arrowHeadLine"},{id1:"SNP7",id2:"Gene5",color:"rgb(153,102,255)",width:"1",type:"arrowHeadLine"},{id1:"SNP8",id2:"Gene6",color:"rgb(153,102,255)",width:"1",type:"arrowHeadLine"},{id1:"SNP8",id2:"Gene2",color:"rgb(51,102,152)",width:"1",type:"line"}],legend:{nodes:[],edges:[]},tracks:[{name:"Affy Probes",type:"box",connect:true,fill:"rgb(255,255,51)",line:"rgb(0,0,0)",data:[{id:"123456_at",dir:"right",data:[[100,120],[123,132],[141,160]]},{id:"234567_at",dir:"left",data:[[181,200],[211,230],[251,270]]},{id:"345678_at",dir:"right",data:[[281,300],[311,330],[351,370]]}]},{hide:true,type:"bar",height:20,fill:["rgb(255,0,0)","rgb(0,0,255)","rgb(255,255,0)"],line:["rgb(255,0,0)","rgb(0,0,255)","rgb(255,255,0)"],data:[{id:"123456_at",data:[100,25,35,46]},{id:"234567_at",data:[181,80,45,10]},{id:"345678_at",data:[281,65,46,29]}]},{name:"Tissue Distribution (Heart, Liver, Kidney)",hide:false,type:"heatmap",autowidth:true,height:20,line:"rgb(0,0,0)",smps:["Heart","Kidney","Liver"],data:[{id:"123456_at",data:[100,25,35,46]},{id:"234567_at",data:[181,80,45,10]},{id:"345678_at",data:[281,65,46,29]}]},{name:"Ref Seq",type:"box",connect:true,fill:"rgb(0,100,0)",stroke:"rgb(0,0,0)",data:[{id:"NM_012345",dir:"left",data:[[171,190],[201,220],[241,290]]},{id:"NM_567890",dir:"right",data:[[121,140],[145,156],[168,196]]},{id:"NM_987654",dir:"right",data:[[271,290],[301,320],[341,390]]}]},{name:"SNP",type:"triangle",fill:"rgb(100,0,0)",line:"rgb(0,0,0)",data:[{id:"SNP123",data:123},{id:"SNP234",data:145},{id:"SNP789",data:220}]},{type:"sequence",subtype:"DNA",hide:true,line:"rgb(255,255,255)",data:[{id:"SNP123",data:[119,"AGCT[TA]CGAG"]},{id:"SNP234",data:[141,"ATCG[TG]AATA"]},{id:"SNP789",data:[216,"GCCC[CT]AGGG"]}]}],market:[{symbol:"BMY",data:[[20100824,26.26,26.37,25.95,26.02,11625900,26.02],[20100823,26.48,26.76,26.38,26.48,12146600,26.48],[20100820,26.31,26.54,26.08,26.44,18140100,26.44],[20100819,26.2,26.29,25.81,26.06,8218000,26.06],[20100818,26.53,26.57,26.23,26.28,12235800,26.28],[20100817,26.4,26.79,26.26,26.59,12325700,26.59],[20100816,26.24,26.34,26.04,26.28,10377700,26.28],[20100813,26.24,26.46,26.1,26.32,5760100,26.32],[20100812,26.01,26.39,26,26.33,7350500,26.33],[20100811,26.32,26.5,26.15,26.25,8808100,26.25],[20100810,26.32,26.78,26.3,26.66,7009500,26.66],[20100809,26.37,26.54,26.3,26.51,6825300,26.51],[20100806,26.29,26.45,26.05,26.37,8774900,26.37],[20100805,25.83,26.38,25.8,26.38,12264600,26.38],[20100804,25.7,26.13,25.61,26.03,10233700,26.03],[20100803,25.65,25.85,25.58,25.68,6842900,25.68],[20100802,25.33,25.61,25.29,25.53,9770900,25.53],[20100730,24.98,25.13,24.78,24.92,11435700,24.92],[20100729,25.37,25.5,24.85,25.08,9463800,25.08],[20100728,25.25,25.36,25.02,25.12,8072400,25.12],[20100727,25.09,25.35,24.84,25.32,14152600,25.32],[20100726,24.57,25.03,24.57,24.97,8817400,24.97],[20100723,24.94,24.95,24.26,24.65,13043700,24.65],[20100722,24.96,25.22,24.75,24.93,10385300,24.93],[20100721,24.92,25.11,24.59,24.75,9830000,24.75],[20100720,24.65,25.09,24.46,25.02,10655500,25.02],[20100719,25.27,25.27,24.78,24.84,11804800,24.84],[20100716,25.44,25.47,25.1,25.17,13136300,25.17]]}]};this.exampleBasicData={x:{Tissue:["Kidney","Liver","Breast","Brain"],Donor:["D1","D2","D2","D1"]},z:{Symbol:["abc","def","ghi","jkl","mno","pqr"],Desc:["blah","yeah","maybe","good","bad","awsome"]},y:{vars:["Gene1","Gene2","Gene3","Gene4","Gene5","Gene6"],smps:["Smp1","Smp2","Smp3","Smp4"],desc:["Intensity"],mean:[[1,2,3,4],[2,1,3,6],[3,2,1,5],[4,2,1,3],[4,3,2,1],[9,2,7,4]],stdev:[[1,3,2,1],[2,3,2,1],[2,2,2,1],[2,3,1,1],[1,1,1,1],[3,1,3,1]],n:[[4,5,5,5],[4,5,5,5],[6,4,4,5],[6,4,5,6],[5,5,5,5],[6,5,5,5]]},a:{xAxis:["Gene1","Gene2","Gene3"],xAxis2:["Gene4","Gene5","Gene6"]}};this.isValidPlotData=function(b){var c=this.isGroupedData?this.data.w:this.data.y;if(b=="cor"&&c.cor){return true}else{if(b=="venn"&&this.data.venn){return true}else{if(b=="network"&&this.data.nodes){return true}else{if(b=="genome"&&this.data.tracks){return true}else{if(b=="sum"&&c.sum&&c.sum[0].length>0){return true}else{if(b=="mean"&&c.mean&&c.mean[0].length>0){return true}else{if(b=="median"&&c.median&&c.median[0].length>0){return true}else{if(b=="iqr"&&c.iqr1&&c.qtl1&&c.median&&c.qtl3&&c.iqr3&&c.median[0].length>0){return true}else{if(b=="candle"&&c.close&&c.open&&c.high&&c.low&&c.close[0].length>0){return true}else{if(b=="volume"&&c.volume&&c.volume[0].length>0){return true}else{if(b=="raw"&&this.isRawData){return true}else{return false}}}}}}}}}}}};this.setAllNodesVisible=function(){this.nodes={};this.data.nodeIndices={};for(var b=0;b<this.data.nodes.length;b++){var c=this.data.nodes[b];c.hide=false;this.nodes[c.id]=c;this.data.nodeIndices[c.id]=b}};this.setNodeIndices=function(){this.nodes={};this.data.nodeIndices={};for(var b=0;b<this.data.nodes.length;b++){var c=this.data.nodes[b];this.nodes[c.id]=c;this.data.nodeIndices[c.id]=b}};this.setNodes=function(){if(this.data.nodeIndices){this.nodes={};for(var b=0;b<this.data.nodes.length;b++){var c=this.data.nodes[b];this.nodes[c.id]=c}this.data.nodes=[];for(var d in this.data.nodeIndices){this.data.nodes[this.data.nodeIndices[d]]=this.nodes[d]}}else{this.setNodeIndices()}};this.hideUnhideNodes=function(d,c){c=c?true:false;if(d){if(this.isArray(d)){for(var b=0;b<d.length;b++){var f=d[b];var e=this.data.nodes[this.data.nodeIndices[f]];e.hide=c;if(this.nodes&&this.nodes[f]){this.nodes[f].hide=c}}}}else{for(var b=0;b<this.data.nodes.length;b++){var e=this.data.nodes[b];e.hide=c;e.hideChildren=c;if(this.nodes&&this.nodes[e.id]){this.nodes[e.id].hide=c;this.nodes[e.id].hideChildren=c}}}};this.hideUnhideChildrenNodes=function(e,c){c=c?true:false;if(this.nodeParentHood[e]&&this.nodeParentHood[e].children){for(var b=0;b<this.nodeParentHood[e].children.length;b++){var d=this.nodeParentHood[e].children[b];this.data.nodes[this.data.nodeIndices[d]].hiddenParent=c;this.hideUnhideChildrenNodes(d,c)}}};this.setSelectNodes=function(c){this.selectNode={};this.isSelectNodes=0;for(var b=0;b<c.length;b++){this.selectNode[c[b]]=true;this.isSelectNodes++}};this.getAnnotations=function(c){var b=[];if(c){if(this.data.z){for(var d in this.data.z){b.push(d)}}}else{if(this.data.x){for(var d in this.data.x){b.push(d)}}}return b};this.getNetworkImages=function(){var b=[];if(this.graphType=="Network"){for(var c=0;c<this.data.nodes.length;c++){var d=this.data.nodes[c];if(d.imagePath){if(!d.imagePath.match(/^http:\/\//)){d.imagePath=this.imageDir+d.imagePath}b.push(d.imagePath)}}}return b};this.setAllVariablesVisible=function(){if(this.data.y){if(!this.data.y.vars&&this.data.y.data){this.data.y.vars=[];for(var b=0;b<this.data.y.data.length;b++){this.data.y.vars.push("var"+(b+1))}}this.varIndices=[];this.hiddenVars=[];this.xAxisVarIndices=[];this.xAxis2VarIndices=[];for(var b=0;b<this.data.y.vars.length;b++){this.varIndices.push(b);this.hiddenVars.push(false)}}if(this.data.a){if(this.data.a.xAxis){this.xAxisVarIndices=this.getVariableIndices(this.data.a.xAxis)}if(this.data.a.xAxis2){this.xAxis2VarIndices=this.getVariableIndices(this.data.a.xAxis2)}}};this.resetVariablesVisibleByAxis=function(b){if(this.data.a){this.setVariablesVisibleByAxis(b,this.getVariableIndices(this.data.a[b]))}};this.setVariablesVisibleByAxis=function(e,b){var c=e+"VarIndices";this[c]=[];for(var d=0;d<b.length;d++){this[c].push(b[d])}};this.getVariablesVisibleByAxis=function(b){return this[b+"VarIndices"]};this.getVariablesByAxis=function(b){if(this.data.a&&this.data.a[b]){return this.data.a[b]}return[]};this.setVariablesVisible=function(b){this.varIndices=[];for(var c=0;c<b.length;c++){this.varIndices.push(b[c])}};this.getVariableIndices=function(b){if(b&&this.data.y.vars){var e=[];if(this.isArray(b)){if(b.length>0){for(var d=0;d<b.length;d++){for(var c=0;c<this.data.y.vars.length;c++){if(this.data.y.vars[c]==b[d]){e.push(c);break}}}return e}}else{for(var d=0;d<this.data.y.vars.length;d++){if(this.data.y.vars[d]==b){return d}}return -1}}};this.hideUnhideVars=function(g){if(g){if(this.isArray(g)){for(var d=0;d<g.length;d++){for(var c=0;c<this.data.y.vars.length;c++){if(this.data.y.vars[c]==g[d]){if(this.hiddenVars[c]){this.hiddenVars[c]=false}else{this.hiddenVars[c]=true}break}}}}else{for(var d=0;d<this.data.y.vars.length;d++){if(this.data.y.vars[d]==g){if(this.hiddenVars[d]){this.hiddenVars[d]=false}else{this.hiddenVars[d]=true}break}}}var b=[];for(var d=0;d<this.data.y.vars.length;d++){if(!this.hiddenVars[d]){b.push(d)}}this.setVariablesVisible(b);var f=["xAxis","xAxis2"];if(this.data.a){for(var d=0;d<f.length;d++){var h=this.getVariableIndices(this.data.a[f[d]]);if(h.length>0){var b=[];for(var c=0;c<h.length;c++){var e=h[c];if(!this.hiddenVars[e]){b.push(e)}}this.setVariablesVisibleByAxis(f[d],b)}}}this.draw()}};this.getVariables=function(){var e=[];for(var d=0;d<this.data.y.vars.length;d++){var b=-1;for(var c=0;c<this.varIndices.length;c++){if(this.varIndices[c]==d){b=c;break}}e.push({name:this.data.y.vars[d],hidden:this.hiddenVars[d],index:b})}return e};this.setAllSamplesVisible=function(){if(this.data.y&&this.data.y.smps){if(!this.data.y.smps&&this.data.y.data&&this.data.y.vars){this.data.y.smps=[];for(var b=0;b<this.data.y.data.vars[0].length;b++){this.data.y.smps.push("smp"+(b+1))}}this.smpIndices=[];this.hiddenSmps=[];for(var b=0;b<this.data.y.smps.length;b++){this.smpIndices.push(b);this.hiddenSmps.push(false)}}if(this.data.w&&this.data.w.smps){this.grpIndices=[];this.hiddenGrps=[];for(var b=0;b<this.data.w.smps.length;b++){this.grpIndices.push(b);this.hiddenGrps.push(false)}}};this.getSamplesByAxis=function(b){if(this[b]){return this[b]}return[]};this.setSamplesVisible=function(b,c){if(this.isGroupedData){this.grpIndices=[];for(var e=0;e<b.length;e++){this.grpIndices.push(b[e])}}else{this.smpIndices=[];for(var e=0;e<b.length;e++){this.smpIndices.push(b[e])}}if(c){var d=this.getObjectArray(b);var g=this.isGroupedData?this.data.w:this.data.y;var f=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;for(var e=0;e<g.smps.length;e++){if(d.hasOwnProperty(e)){f[e]=false}else{f[e]=true}}}};this.getSampleIndices=function(b){var f=this.isGroupedData?this.data.w:this.data.y;if(b&&f.smps){var e=[];if(this.isArray(b)){if(b.length>0){for(var d=0;d<b.length;d++){for(var c=0;c<f.smps.length;c++){if(f.smps[c]==b[d]){e.push(c);break}}}return e}}else{for(var d=0;d<f.smps.length;d++){if(f.smps[d]==b){return d}}return -1}}};this.hideUnhideSmps=function(g){if(g){var h=this.isGroupedData?this.data.w:this.data.y;var e=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;var f=[];if(this.isArray(g)){for(var d=0;d<g.length;d++){for(var c=0;c<h.smps.length;c++){if(h.smps[c]==g[d]){if(e[c]){e[c]=false}else{e[c]=true}break}}}}else{for(var d=0;d<h.smps.length;d++){if(h.smps[d]==g){if(e[d]){e[d]=false}else{e[d]=true}break}}}var b=[];for(var d=0;d<h.smps.length;d++){if(!e[d]){b.push(d)}}this.setSamplesVisible(b);this.draw()}};this.getSamples=function(){var d=[];var h=this.isGroupedData?this.data.w.smps:this.data.y.smps;var k=this.isGroupedData?this.data.w:this.data.y;var f=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;var g=this.isGroupedData?this.grpIndices:this.smpIndices;for(var e=0;e<h.length;e++){var b=-1;for(var c=0;c<g.length;c++){if(g[c]==e){b=c;break}}d.push({name:h[e],hidden:f[e],index:b})}return d};this.setIndices=function(){if(this.graphType=="Network"){this.setNodes()}else{if(this.graphType!="Genome"&&this.graphType!="Venn"){this.setAllVariablesVisible();this.setAllSamplesVisible()}}};this.resetIndices=function(){if(this.isGroupedData){this.setIndices()}};this.setMaxSmpStringAttr=function(c,b){this.setMaxSmpStringAnnt(c,b);this.setMaxSmpStringLabel(c,b);this.setMaxSmpStringDesc(b);this.setMaxSmpStringName(b)};this.setMaxSmpStringAnnt=function(e,d){if(!d){d=this.smpLabelFont}var c=0;this.maxSmpAnnt=0;this.maxSmpAnntStr="";if(this.data.x){if(e&&this.data.x[e]){return e}else{for(var f in this.data.x){var b=this.measureText(f,d);if(b>c){c=b;this.maxSmpAnnt=f.length;this.maxSmpAnntStr=f}}}}};this.setMaxSmpStringLabel=function(f,d){if(!d){d=this.smpLabelFont}var c=0;this.maxSmpLabel=0;this.maxSmpLabelStr="";if(this.data.x){if(f&&this.data.x[f]){var h="";for(var e=0;e<this.smpIndices.length;e++){var b=this.measureText(this.data.x[f][this.smpIndices[e]],d);if(b>c){c=b;h=this.data.x[f][this.smpIndices[e]]}}return h}else{for(var g in this.data.x){for(var e=0;e<this.smpIndices.length;e++){if(this.data.x[g][this.smpIndices[e]]){var b=this.measureText(this.data.x[g][this.smpIndices[e]],d);if(b>c){c=b;this.maxSmpLabel=this.data.x[g][this.smpIndices[e]].length;this.maxSmpLabelStr=this.data.x[g][this.smpIndices[e]]}}}}}}};this.setMaxSmpStringDesc=function(d){if(!d){d=this.smpLabelFont}var c=0;this.maxSmpLabelDesc=0;this.maxSmpLabelDescStr="";if(this.data.x&&this.smpLabelDescription&&this.data.x[this.smpLabelDescription]){for(var e=0;e<this.smpIndices.length;e++){if(this.data.x[this.smpLabelDescription][this.smpIndices[e]]){var b=this.measureText(this.data.x[this.smpLabelDescription][this.smpIndices[e]],d);if(b>c){c=b;this.maxSmpLabelDesc=this.data.x[this.smpLabelDescription][this.smpIndices[e]].length;this.maxSmpLabelDescStr=this.data.x[this.smpLabelDescription][this.smpIndices[e]]}}}}};this.setMaxSmpStringName=function(d){if(!d){d=this.smpLabelFont}if(this.data.y||this.data.w){var f=this.isGroupedData?this.data.w:this.data.y;var c=0;this.maxSmpName=0;this.maxSmpNameStr="";if(this.isGroupedData){for(var e=0;e<f.smps.length;e++){var b=this.measureText(f.smps[e],d);if(b>c){c=b;this.maxSmpName=f.smps[e].length;this.maxSmpNameStr=f.smps[e]}}}else{for(var e=0;e<this.smpIndices.length;e++){var b=this.measureText(f.smps[this.smpIndices[e]],d);if(b>c){c=b;this.maxSmpName=f.smps[this.smpIndices[e]].length;this.maxSmpNameStr=f.smps[this.smpIndices[e]]}}}}};this.setMaxVarStringAttr=function(c,b){this.setMaxVarStringAnnt(c,b);this.setMaxVarStringLabel(c,b);this.setMaxVarStringDesc(b);this.setMaxVarStringName(b)};this.setMaxVarStringAnnt=function(e,d){if(!d){d=this.varLabelFont}var c=0;this.maxVarAnnt=0;this.maxVarAnntStr="";if(this.data.z){if(e&&this.data.z[e]){return e}else{for(var f in this.data.z){var b=this.measureText(f,d);if(b>c){c=b;this.maxVarAnnt=f.length;this.maxVarAnntStr=f}}}}};this.setMaxVarStringLabel=function(f,d){if(!d){d=this.varLabelFont}var c=0;this.maxVarLabel=0;this.maxVarLabelStr="";if(this.data.z){if(f&&this.data.z[f]){var h="";for(var e=0;e<this.varIndices.length;e++){var b=this.measureText(this.data.z[f][this.varIndices[e]],d);if(b>c){c=b;h=this.data.z[f][this.varIndices[e]]}}return h}else{for(var g in this.data.z){for(var e=0;e<this.varIndices.length;e++){if(this.data.z[g][this.varIndices[e]]){var b=this.measureText(this.data.z[g][this.varIndices[e]],d);if(b>c){c=b;this.maxVarLabel=this.data.z[g][this.varIndices[e]].length;this.maxVarLabelStr=this.data.z[g][this.varIndices[e]]}}}}}}};this.setMaxVarStringDesc=function(d){if(!d){d=this.varLabelFont}var c=0;this.maxVarLabelDesc=0;this.maxVarLabelDescStr="";if(this.data.z&&this.varLabelDescription&&this.data.z[this.varLabelDescription]){for(var e=0;e<this.varIndices.length;e++){if(this.data.z[this.varLabelDescription][this.varIndices[e]]){var b=this.measureText(this.data.z[this.varLabelDescription][this.varIndices[e]],d);if(b>c){c=b;this.maxVarLabelDesc=this.data.z[this.varLabelDescription][this.varIndices[e]].length;this.maxVarLabelDescStr=this.data.z[this.varLabelDescription][this.varIndices[e]]}}}}};this.setMaxVarStringName=function(d){if(!d){d=this.varLabelFont}if(this.data.y||this.data.w){var f=this.graphType.match(/BarLine|StackedLine|StackedPercentLine/)?this.data.y:this.isGroupedData?this.data.w:this.data.y;var c=0;this.maxVarName=0;this.maxVarNameStr="";if(f.vars){for(var e=0;e<this.varIndices.length;e++){var b=this.measureText(f.vars[this.varIndices[e]],d);if(b>c){c=b;this.maxVarName=f.vars[this.varIndices[e]].length;this.maxVarNameStr=f.vars[this.varIndices[e]]}}}}};this.setRangeData=function(d,e,b,u){var c=this.isGroupedData&&!e?this.data.w:this.data.y;var n=Number.MAX_VALUE;var r=Number.MIN_VALUE;if(this.setMin!=null&&this.setMax!=null){this.minData=this.setMin;this.maxData=this.setMax;return}if(this.isGroupedData&&!d){d=this.summaryType}if(d=="genome"){for(var s=0;s<this.data.tracks.length;s++){for(var p=0;p<this.data.tracks[s].data.length;p++){for(var o=0;o<this.data.tracks[s].data[p].data.length;o++){if(this.data.tracks[s].type=="box"){m=this.data.tracks[s].data[p].data[o];r=Math.max(r,Math.max(m[0],m[1]));n=Math.min(n,Math.min(m[0],m[1]))}else{if(this.data.tracks[s].type.match(/bar|heatmap|sequence/)){m=this.data.tracks[s].data[p].data;r=Math.max(r,m[0]);n=Math.min(n,m[0])}else{m=this.data.tracks[s].data[p].data;r=Math.max(r,m);n=Math.min(n,m)}}}}}}else{if(d=="percentile"&&!e){n=0;r=100}else{if((d=="mean"||d=="median"||d=="sum")&&!e){if(u){var f=this.isGroupedData?this.grpIndices:this.smpIndices;var y=this.isTransformedData?c.trans:c[this.summaryType];for(var s=0;s<f.length;s++){var l=f[s];var h=0;for(var p=0;p<this.varIndices.length;p++){var t=this.varIndices[p];var A=y[t][l];if(!isNaN(A)&&A>0){h+=A}}r=Math.max(h,r)}n=0}else{for(var s=0;s<this.varIndices.length;s++){var l=this.varIndices[s];var m;if(this.isTransformedData){m=c.trans[l]}else{if(this.summaryType=="mean"){m=c.mean[l]}else{if(this.summaryType=="median"){m=c.median[l]}else{if(this.summaryType=="sum"){m=c.sum[l]}}}}for(var p=0;p<m.length;p++){var x;var A=m[p];if(c.stdev&&!this.isTransformedData){x=c.stdev[l][p]}else{x=Number.NaN}if(!isNaN(A)){if(!isNaN(x)){if(b){if(A>0){n=Math.min(A,n);r=Math.max(A+x,r)}}else{n=Math.min(A,n);r=Math.max(A+x,r)}}else{if(b){if(A>0){n=Math.min(A,n);r=Math.max(A,r)}}else{n=Math.min(A,n);r=Math.max(A,r)}}}}}}}else{if(d=="iqr"&&!e){if(this.isTransformedData){alert("Transformation not allowed");this.isTransformedData=false}for(var s=0;s<this.varIndices.length;s++){var l=this.varIndices[s];for(var p=0;p<c.iqr1.length;p++){var w=c.iqr1[l][p];var v=c.iqr3[l][p];var q=c.out[l][p];if(!isNaN(w)&&!isNaN(v)){if(b){if(w>0&&v>0){n=Math.min(w,n);r=Math.max(v,r)}}else{n=Math.min(w,n);r=Math.max(v,r)}}if(q){for(var o=0;o<q.length;o++){if(!isNaN(q[o])){if(b){if(q[o]>0){n=Math.min(q[o],n);r=Math.max(q[o],r)}}else{n=Math.min(q[o],n);r=Math.max(q[o],r)}}}}}}}else{if(d=="candle"){if(this.isTransformedData){alert("Transformation not allowed");this.isTransformedData=false}var f=this.isGroupedData?this.grpIndices:this.smpIndices;for(var s=0;s<this.varIndices.length;s++){var l=this.varIndices[s];for(var p=0;p<f.length;p++){var t=f[p];var g=c.high[l][t];var z=c.low[l][t];if(!isNaN(g)&&!isNaN(z)){n=Math.min(z,n);r=Math.max(g,r)}}}}else{if(d=="volume"){var f=this.isGroupedData?this.grpIndices:this.smpIndices;for(var s=0;s<this.varIndices.length;s++){var l=this.varIndices[s];for(var p=0;p<f.length;p++){var t=f[p];if(!isNaN(c.volume[l][t])){n=Math.min(c.volume[l][t],n);r=Math.max(c.volume[l][t],r)}}}}else{if(d=="cor"){var f=this.correlationAxis=="variables"?this.varIndices:this.isGroupedData?this.grpIndices:this.smpIndices;for(var s=0;s<f.length;s++){for(var p=0;p<f.length;p++){var A=this.isTransformedData?c.trans[s][p]:c.cor[s][p];if(!isNaN(A)){if(b){if(A>0){n=Math.min(A,n);r=Math.max(A,r)}}else{n=Math.min(A,n);r=Math.max(A,r)}}}}}else{var y=this.isTransformedData?c.trans:c.data;if(u){for(var s=0;s<this.smpIndices.length;s++){var h=0;for(var p=0;p<this.varIndices.length;p++){var A=y[this.varIndices[p]][this.smpIndices[s]];if(!isNaN(A)&&A>0){h+=A}}r=Math.max(h,r)}n=0}else{for(var s=0;s<this.varIndices.length;s++){for(var p=0;p<this.smpIndices.length;p++){var A=y[this.varIndices[s]][this.smpIndices[p]];if(!isNaN(A)){if(b){if(A>0){n=Math.min(A,n);r=Math.max(A,r)}}else{n=Math.min(A,n);r=Math.max(A,r)}}}}}}}}}}}}this.minData=this.setMin!=null?this.setMin:n;this.maxData=this.setMax!=null?this.setMax:r};this.sortIndices=function(e,c,b,h,d){var f=this;var g=this.isGroupedData?this.grpIndices:e=="vars"?this.varIndices:this.smpIndices;if(!c){c=this.sortDir}if(b&&e=="vars"&&this.data.z[b]){this.tmpAsciiArray=this.data.z[b];this.smpSort=-1;this.varSort=b}else{if(b&&e=="smps"&&this.data.x[b]){this.tmpAsciiArray=this.data.x[b];this.varSort=-1;this.smpSort=b}else{if(h){this.tmpAsciiArray=this.getDataForSmpGrpAtIndex(h-1);this.smpSort=h-1}else{if(d){this.tmpAsciiArray=this.data.y.data[d-1];this.varSort=d-1}else{this.tmpAsciiArray=this.isGroupedData?this.data.w.smps:e=="vars"?this.data.y.vars:this.data.y.smps;if(e=="vars"){this.varSort=false}else{this.smpSort=false}}}}}if(this.isAsciiArray(this.tmpAsciiArray)){g.sort(function(j,i){return f.sortAsciibetically(j,i)})}else{g.sort(function(j,i){return f.sortNumerically(j,i)})}if(c!="ascending"){g.reverse()}this.tmpAsciiArray=[]};this.isAsciiArray=function(b){for(var c=0;c<b.length;c++){if(isNaN(b[c])){return true}}return false};this.sortAsciibetically=function(d,c){return((this.tmpAsciiArray[d]>this.tmpAsciiArray[c])?1:(this.tmpAsciiArray[d]<this.tmpAsciiArray[c])?-1:0)};this.sortNumerically=function(d,c){return(this.tmpAsciiArray[d]-this.tmpAsciiArray[c])};this.isNumeric=function(b,f,e){if(f){for(var d=0;d<this.smpIndices.length;d++){var c=this.smpIndices[d];if(b[c]&&isNaN(b[c])){return false}}}else{if(e){for(var d=0;d<this.varIndices.length;d++){var c=this.varIndices[d];if(b[c]&&isNaN(b[c])){return false}}}else{for(var c=0;c<b.length;c++){if(b[c]&&isNaN(b[c])){return false}}}}return true};this.precedence={sin:16,cos:16,tan:16,sec:16,csc:16,cot:16,asin:16,acos:16,atan:16,asec:16,acsc:16,acot:16,sinh:16,cosh:16,tanh:16,sech:16,csch:16,coth:16,asinh:16,acosh:16,atanh:16,asech:16,acsch:16,acoth:16,exp:16,ln:16,log:16,logb:16,pow:16,sq:16,sqrt:16,abs:16,sgn:16,chs:16,floor:16,ceil:16,ip:16,fp:16,inv:16,min:16,max:16,gamma:16,fact:16,comb:16,perm:16,rand:16,gcd:16,lcm:16,prime:16,and:16,or:16,xor:16,x:16,y:16,pi:16,e:16,neg:15,not:15,"^":14,"*":13,"/":13,mod:13,div:13,"+":12,"-":12,"<":10,"<=":10,"==":10,"!=":10,">=":10,">":10,"&&":5,"||":4,",":1};this.expects={sin:1,cos:1,tan:1,sec:1,csc:1,cot:1,asin:1,acos:1,atan:1,asec:1,acsc:1,acot:1,sinh:1,cosh:1,tanh:1,sech:1,csch:1,coth:1,asinh:1,acosh:1,atanh:1,asech:1,acsch:1,acoth:1,exp:1,ln:1,log:1,logb:2,pow:2,sq:1,sqrt:1,abs:1,sgn:1,chs:1,floor:1,ceil:1,ip:1,fp:1,inv:1,min:2,max:2,gamma:1,fact:1,comb:2,perm:2,gcd:2,lcm:2,prime:1,and:2,or:2,xor:2,neg:1,not:1,"^":2,"*":2,"/":2,mod:2,div:2,"+":2,"-":2,"<":2,"<=":2,"==":2,"!=":2,">=":2,">":2,"&&":2,"||":2};this.alias={"+":"add","-":"sub","*":"mul","/":"div","!":"fact","x^y":"pow","^":"pow","10^":"pow10",div:"idiv","<":"lt","<=":"le","==":"eq","!=":"ne",">=":"ge",">":"gt","%":"pc","%ch":"pcch"};this.add=function(c,b){return new Number(b)+new Number(c)};this.sub=function(c,b){return b-c};this.mul=function(c,b){return b*c};this.div=function(c,b){return b/c};this.sin=function(b){return Math.sin(b)};this.cos=function(b){return Math.cos(b)};this.tan=function(b){return Math.tan(b)};this.sec=function(b){return 1/Math.cos(b)};this.csc=function(b){return 1/Math.sin(b)};this.cot=function(b){return 1/Math.tan(b)};this.asin=function(b){return Math.asin(b)};this.acos=function(b){return Math.acos(b)};this.atan=function(b){return Math.atan(b)};this.asec=function(b){return Math.acos(1/b)};this.acsc=function(b){return Math.asin(1/b)};this.acot=function(b){return Math.atan(1/b)};this.sinh=function(b){return(Math.exp(b)-Math.exp(-b))*0.5};this.cosh=function(b){return(Math.exp(b)+Math.exp(-b))*0.5};this.tanh=function(b){return(Math.exp(b)-Math.exp(-b))/(Math.exp(b)+Math.exp(-b))};this.sech=function(b){return 1/cosh(b)};this.csch=function(b){return 1/sinh(b)};this.coth=function(b){return 1/tanh(b)};this.asinh=function(b){return Math.log(b+Math.sqrt(b*b+1))};this.acosh=function(b){return Math.log(b+Math.sqrt(b*b-1))};this.atanh=function(b){return Math.log((1+b)/(1-b))*0.5};this.asech=function(b){return acosh(1/b)};this.acsch=function(b){return asinh(1/b)};this.acoth=function(b){return atanh(1/b)};this.exp=function(b){return Math.exp(b)};this.ln=function(b){return Math.log(b)};this.log=function(b){return Math.log(b)/Math.LN10};this.logb=function(c,b){return Math.log(b)/Math.log(c)};this.pow=function(c,b){return Math.pow(b,c)};this.pow10=function(b){return Math.pow(10,b)};this.sq=function(b){return b*b};this.sqrt=function(b){return Math.sqrt(b)};this.abs=function(b){return b>=0?b:-b};this.sgn=function(b){return b==0?0:(b>0?1:-1)};this.chs=function(b){return -b};this.neg=function(b){return -b};this.floor=function(b){return Math.floor(b)};this.ceil=function(b){return Math.ceil(b)};this.ip=function(b){return parseInt(b)};this.fp=function(b){return abs(b)-ip(abs(b))};this.inv=function(b){return 1/b};this.idiv=function(c,b){return parseInt(b/c)};this.mod=function(c,b){return b%c};this.and=function(c,b){return b&c};this.or=function(c,b){return b|c};this.xor=function(c,b){return b^c};this.not=function(b){return ~b};this.lt=function(c,b){return b<c?1:0};this.le=function(c,b){return b<=c?1:0};this.eq=function(c,b){return b==c?1:0};this.ne=function(c,b){return b!=c?1:0};this.ge=function(c,b){return b>=c?1:0};this.gt=function(c,b){return b>c?1:0};this.Min=function(c,b){return Math.min(b,c)};this.Max=function(c,b){return Math.max(b,c)};this.pc=function(c,b){return b*c/100};this.pcch=function(c,b){return 100*c/b};this.gammaConsts=new Array(76.18009172947146,-86.50532032941678,24.01409824083091,-1.231739572450155,0.001208650973866179,-0.000005395239384953);this.gammaLn=function(b){var f=new Number(b);var e=new Number(b+5.5);var c=new Number(1.000000000190015);e-=(b+0.5)*Math.log(e);for(var d in this.gammaConsts){c+=this.gammaConsts[d]/++f}return Math.log(2.5066282746310007*c/b)-e};this.gamma=function(b){return Math.exp(this.gammaLn(b))};this.fact=function(c){var b=new Number(c);if(c<=1){return 1}if(c>100||(c%1)){return Math.exp(this.gammaLn(c+1))}while(--c){b*=c}return b};this.comb=function(c,b){return Math.floor(0.5+Math.exp(this.gammaLn(b+1)-this.gammaLn(c+1)-this.gammaLn(b-c+1)))};this.perm=function(c,b){return Math.floor(0.5+Math.exp(this.gammaLn(b+1)-this.gammaLn(b-c+1)))};this.gcd=function(d,c){if(d==0){return(c||1)}return(c?this.gcd(c,d%c):d)};this.lcm=function(d,c){return(d/this.gcd(d,c))*c};this.prime=function(f){var e=new Number(5);var b=new Number(4);var c=parseInt(f/e);if(f==2||f==3||f==5){return 1}if(f<5||(f&1)==0||(f%3)==0){return 0}while(e*c<f&&e<c){c=parseInt(f/(e+=(b=6-b)))}return(e*c==f?0:1)};this.cleanArray=function(b,g,f){var d=[];if(g){for(var e=0;e<this.smpIndices.length;e++){var c=this.smpIndices[e];if(!isNaN(b[c])){d.push(b[c])}}}else{if(f){for(var e=0;e<this.varIndices.length;e++){var c=this.varIndices[e];if(!isNaN(b[c])){d.push(b[c])}}}else{for(var c=0;c<b.length;c++){if(!isNaN(b[c])){d.push(b[c])}}}}return d};this.cleanArrays=function(c,b,j,h){var g=[];var f=[];if(j){for(var e=0;e<this.smpIndices.length;e++){var d=this.smpIndices[e];if(!isNaN(c[d])&&!isNaN(b[d])){g.push(c[d]);f.push(b[d])}}}else{if(h){for(var e=0;e<this.varIndices.length;e++){var d=this.varIndices[e];if(!isNaN(c[d])&&!isNaN(b[d])){g.push(c[d]);f.push(b[d])}}}else{for(var d=0;d<c.length;d++){if(!isNaN(c[d])&&!isNaN(b[d])){g.push(c[d]);f.push(b[d])}}}}return[g,f]};this.sortArray=function(b,c){var e=[];if(b.length!=c.length){return b}for(var d=0;d<b.length;d++){if(b[c[d]]){e[d]=b[c[d]]}else{return b}}return e};this.reverseArray=function(b){var e=[];var d=0;for(var c=b.length-1;c>=0;c--){e[d]=b[c];d++}return e};this.percentile=function(e,b,f){var c=b-e;if(c==0){return 50}var d=f-e;return d*100/c};this.rank=function(b){var d=[];for(var c=0;c<b.length;c++){d.push(c)}d.sort(function(f,e){return b[f]-b[e]});return d};this.min=function(b,f,e){if(this.isArray(b)){b=this.cleanArray(b,f,e);var d=Number.MAX_VALUE;for(var c=0;c<b.length;c++){d=Math.min(d,b[c])}return d}else{return this.Min(b,f)}};this.max=function(c,f,e){if(this.isArray(c)){c=this.cleanArray(c,f,e);var b=Number.MIN_VALUE;for(var d=0;d<c.length;d++){b=Math.max(b,c[d])}return b}else{return this.Max(c,f)}};this.sum=function(b,g,f,e){b=this.cleanArray(b,g,f);var d=0;for(var c=0;c<b.length;c++){if(e){if(b[c]>0){d+=b[c]}}else{d+=b[c]}}return d};this.mean=function(b,g,e){b=this.cleanArray(b,g,e);var c=0;var f=0;for(var d=0;d<b.length;d++){if(!isNaN(b[d])){c+=b[d];f++}}if(f>0){c/=f}return c};this.range=function(c,g,f){c=this.cleanArray(c,g,f);var e=Number.MAX_VALUE;var b=Number.MIN_VALUE;for(var d=0;d<c.length;d++){e=Math.min(c[d],e);b=Math.max(c[d],b)}return[e,b]};this.median=function(b,h,f){b=this.cleanArray(b,h,f);var e=[];var d=[];var g=0;e[0]=Number.NaN;e[1]=Number.NaN;for(var c=0;c<b.length;c++){d.push(b[c]);g++}if(g>0){e[1]=g;d.sort(function(j,i){return j-i});if(g%2){e[0]=d[parseInt(g/2)]}else{e[0]=(d[parseInt((g-1)/2)]+d[g/2])/2}}return e};this.meanStandardDeviationN=function(b,j,g){b=this.cleanArray(b,j,g);var f=[];var d=0;var c=0;var h=0;for(var e=0;e<b.length;e++){c+=b[e];d+=b[e]*b[e];h++}if(h>0){c/=h;d=Math.sqrt(d/h-c*c);f.push(c);f.push(d);f.push(h)}else{f.push("");f.push("");f.push("")}return f};this.quantiles=function(l,d,s){l=this.cleanArray(l,d,s);var o=[];var h=[];var e=l.length;if(e>2){var p=Math.floor(e*0.25);var k=Math.floor(e*0.5);var c=Math.floor(e*0.75);l.sort(function(n,i){return n-i});var b;var r;var q;if(e%2){r=l[k]}else{r=this.mean([l[k-1],l[k]])}if((e/2)%2){b=l[p];q=l[c]}else{b=this.mean([l[p-1],l[p]]);q=this.mean([l[c-1],l[c]])}var m=(q-b)*1.5;var g;var f;for(var j=0;j<=p;j++){if(l[j]<b-m){h.push(l[j])}else{g=l[j];break}}for(var j=e-1;j>=c;j--){if(l[j]>q+m){h.push(l[j])}else{f=l[j];break}}o.push(b);o.push(r);o.push(q);o.push(g);o.push(f);o.push(h);o.push(e)}else{if(e>1){o.push(l[0]);o.push(l[1]);o.push(l[1]);o.push(l[0]);o.push(l[1]);o.push(h);o.push(e)}else{if(e>0){o.push(l[0]);o.push(l[0]);o.push(l[0]);o.push(l[0]);o.push(l[0]);o.push(h);o.push(e)}else{o.push(Number.NaN);o.push(Number.NaN);o.push(Number.NaN);o.push(Number.NaN);o.push(Number.NaN);o.push(Number.NaN)}}}return o};this.covariance=function(g,f,b,l){var e=this.cleanArrays(g,f,b,l);g=e[0];f=e[1];var k=0;var c=0;var j=this.mean(g);var h=this.mean(f);for(var d=0;d<g.length;d++){k+=g[d]*f[d];c++}if(c>0){k/=c;return k-(j*h)}return k};this.correlation=function(h,g,c,p){var f=this.cleanArrays(h,g,c,p);h=f[0];g=f[1];var d=0;var m=0;var k=0;var b=0;var j=0;var l=this.covariance(h,g);var o=0;for(var e=0;e<h.length;e++){m+=h[e];k+=g[e];b+=h[e]*h[e];j+=g[e]*g[e];d++}if(d>0){o=(d*d)*l/Math.sqrt(((d*b)-(m*m))*((d*j)-(k*k)))}return o};this.regression=function(k,j,c,s){var h=this.cleanArrays(k,j,c,s);k=h[0];j=h[1];var d=0;var p=0;var m=0;var r=0;var b=0;var l=0;var o=this.covariance(k,j);var q=0;var g=0;var e=0;for(var f=0;f<k.length;f++){p+=k[f];m+=j[f];r+=k[f]*j[f];b+=k[f]*k[f];l+=j[f]*j[f];d++}if(d>2){g=(d*r-p*m)/(d*b-p*p);e=(m-g*p)/d;q=(d*d)*o/Math.sqrt(((d*b)-(p*p))*((d*l)-(m*m)))}return[g,e,q]};this.slope=function(c,e,b,d){return e!=d?(b-c)/(d-e):0};this.intercept=function(b,d,c){return d-(b*c)};this.slopeIntercept=function(c,f,b,e){var d=this.slope(c,f,b,e);return[d,this.intercept(c,f,d)]};this.normalize=function(f){for(var e=0;e<f.length;e++){var b=this.meanStandardDeviationN(f[e]);for(var c=0;c<f[e].length;c++){f[e][c]=(f[e][c]-b[0])/b[1]}}return f};this.euclidianDistance=function(c,b,j,h){var f=this.cleanArrays(c,b,j,h);c=f[0];b=f[1];var g=0;if(c.length==b.length){for(var e=0;e<c.length;e++){g+=Math.pow(c[e]-b[e],2)}g=Math.sqrt(g)}return g};this.manhattanDistance=function(c,b,j,h){var f=this.cleanArrays(c,b,j,h);c=f[0];b=f[1];var g=0;if(c.length==b.length){for(var e=0;e<c.length;e++){g+=Math.abs(c[e]-b[e])}}return g};this.maxDistance=function(c,b,j,h){var f=this.cleanArrays(c,b,j,h);c=f[0];b=f[1];var g=0;if(c.length==b.length){for(var e=0;e<c.length;e++){g=Math.max(g,Math.abs(c[e]-b[e]))}}return g};this.addVectors=function(d,c,h,g){var f=this.cleanArrays(d,c,h,g);d=f[0];c=f[1];var b=[];if(d.length==c.length){for(var e=0;e<d.length;e++){b.push(d[e]+c[e])}}return b};this.compareVectors=function(c,b){if(this.isArray(c)&&this.isArray(b)){if(c.length!=b.length){return false}for(var d=0;d<c.length;d++){if(this.isArray(c[d])&&this.isArray(b[d])){if(!this.compareArrays(c[d],b[d])){return false}}if(c[d]!==b[d]){return false}}return true}};this.vectorDotProduct=function(c,b,h,g){var e=this.cleanArrays(c,b,h,g);c=e[0];b=e[1];var f=0;if(c.length==b.length){for(var d=0;d<c.length;d++){f+=c[d]*b[d]}}return f};this.multiplyVectorByValue=function(b,e,f,d){b=this.cleanArray(b,f,d);for(var c=0;c<b.length;c++){b[c]*=e}return b};this.getCentroid=function(e,h,g,b){var j=[];if(h.length==b.length){var f=e+g;for(var d=0;d<h.length;d++){j.push((e*h[d]+g*b[d])/f)}}return j};this.createNode=function(j,e,f,g,i,b){var h={id:j,left:e,right:f,dist:g,centroid:i};if(b){h.mid=b}if(e==null&&f==null){h.size=1;h.depth=0}else{h.size=e.size+f.size;h.depth=1+Math.max(e.depth,f.depth)}return h};this.createRandomVectors=function(e,h){var d=h.length;if(e>d){return null}var m=[];var g=[];var b={};var o=0;var p=0;var l,c;while(p<e){if(o==d){return null}var j=Math.floor(Math.random()*d);if(j in b){continue}b[j]=1;o++;l=h[j];c=true;for(var f=0;f<p;f++){if(this.compareVectors(l,m[f])){c=false;break}}if(c){m[p]=l;g[p]=j;p++}}return{vectors:m,indices:g}};this.imputeDatum=function(b){var e=[];if(this.clusterAxis=="samples"){for(var c=0;c<this.varIndices.length;c++){var d=this.varIndices[c];e.push(this.data.y.data[d][b])}}else{for(var c=0;c<this.smpIndices.length;c++){var d=this.smpIndices[c];e.push(this.data.y.data[b][d])}}return this[this.imputeMethod](e)};this.getIdsForClustering=function(){var e=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];e[b]=this.data.y.smps[c]}}else{for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];e[b]=this.data.y.vars[c]}}return e};this.getDataForClustering=function(){var k=[];var b=[];if(this.clusterAxis=="samples"){for(var e=0;e<this.smpIndices.length;e++){k[e]=[]}for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];for(var c=0;c<this.smpIndices.length;c++){var g=this.smpIndices[c];var h=this.data.y.data[f][g];if(isNaN(h)){if(!b[c]){b[c]=this.imputeDatum(g)}h=b[c]}k[c][e]=h}}}else{for(var e=0;e<this.varIndices.length;e++){k[e]=[]}for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];for(var c=0;c<this.smpIndices.length;c++){var g=this.smpIndices[c];var h=this.data.y.data[f][g];if(isNaN(h)){if(!b[e]){b[e]=this.imputeDatum(f)}h=b[e]}k[e][c]=h}}}if(this.centerData){k=this.normalize(k)}return k};this.cluster=function(){var v;var o=this.getDataForClustering();var g=this.getIdsForClustering();var f=[];var e=[];var q=[];var u=[];for(var n=0;n<o.length;n++){f[n]=[]}for(var n=0;n<o.length;n++){f[n][n]=Number.POSITIVE_INFINITY;for(var k=n+1;k<o.length;k++){f[n][k]=this[this.distance+"Distance"](o[n],o[k]);f[k][n]=f[n][k]}}for(var n=0;n<o.length;n++){e[n]=0;for(var k=0;k<o.length;k++){if(f[n][e[n]]>f[n][k]){e[n]=k}}}for(var n=0;n<o.length;n++){u[n]=[];u[n][0]=this.createNode(g[n],null,null,0,o[n]);q[n]=1}for(var b=0;b<o.length-1;b++){var m=0;for(var n=0;n<o.length;n++){if(f[n][e[n]]<f[m][e[m]]){m=n}}var h=e[m];var c=u[m][0];var r=u[h][0];var t=this.getCentroid(c.size,c.centroid,r.size,r.centroid);var s=this.createNode(-1,c,r,f[m][h],t);u[m].splice(0,0,s);q[m]+=q[h];for(var k=0;k<o.length;k++){if(this.linkage=="single"){if(f[m][k]>f[h][k]){f[k][m]=f[m][k]=f[h][k]}}else{if(this.linkage=="complete"){if(f[m][k]<f[h][k]){f[k][m]=f[m][k]=f[h][k]}}else{if(this.linkage=="average"){f[k][m]=f[m][k]=(q[m]*f[m][k]+q[h]*f[h][k])/(q[m]+q[k])}}}}f[m][m]=Number.POSITIVE_INFINITY;for(var n=0;n<o.length;n++){f[n][h]=f[h][n]=Number.POSITIVE_INFINITY}for(var k=0;k<o.length;k++){if(e[k]==h){e[k]=m}if(f[m][k]<f[m][e[m]]){e[m]=k}}v=s}return this.writeNewick(v)};this.isLeafNode=function(b){if(b.left==null&&b.right==null){return true}else{return false}};this.writeNewick=function(c,j){var h="";var g="";if(this.isLeafNode(c)){h=c.id}else{var b;var d=this.writeNewick(c.left,j);var f=this.writeNewick(c.right,j);if(c.mid){for(var e=0;e<c.mid.length;e++){if(j&&c.mid[e].dist){g+=","+c.mid[e].id+":"+c.mid[e].dist}else{g+=","+c.mid[e].id}g+=c.mid[e].id}}h="("+d+g+","+f+")"}if(j&&c.dist){h+=":"+c.dist}return h};this.kmeans=function(){var m;var o=this.getDataForClustering();var c=this.getIdsForClustering();var n=[];var p=[];var r=true;var q=0;var h=null;var w=this.createRandomVectors(this.kmeansClusters,o);if(w==null){return null}else{h=w.vectors}while(r){for(var k=0;k<this.kmeansClusters;k++){p[k]=0}for(var k=0;k<o.length;k++){var s=o[k];var g=Number.MAX_VALUE;var e;for(var f=0;f<this.kmeansClusters;f++){var b=this.euclidianDistance(h[f],s);if(b<g){g=b;e=f}}p[e]++;n[k]=e}var u=[];for(var k=0;k<this.kmeansClusters;k++){u[k]=null}for(var k=0;k<o.length;k++){if(u[n[k]]==null){u[n[k]]=o[k]}else{u[n[k]]=this.addVectors(u[n[k]],o[k])}}for(var k=0;k<this.kmeansClusters;k++){u[k]=this.multiplyVectorByValue(u[k],1/p[k])}r=false;for(var k=0;k<this.kmeansClusters;k++){if(!this.compareVectors(u[k],h[k])){r=true;break}}h=u;q++;if(q>this.maxIterations){r=false}}for(var k=0;k<n.length;k++){n[k]="K-"+(n[k]+1)}return n};this.transpose=function(h){if(h){var l=[];for(var f=0;f<h.length;f++){for(var e=0;e<h[f].length;e++){if(!l[e]){l[e]=[]}l[e][f]=h[f][e]}}return l}else{this.ungroupSamples();this.transform("reset");if(this.data.l){delete (this.data.l)}if(this.data.d){delete (this.data.d)}if(this.data.a){delete (this.data.a)}if(this.data.t){var c=this.data.t.vars;var g=this.data.t.smps;if(c){this.data.t.smps=c}if(g){this.data.t.vars=g}}var b=this.data.x;var k=this.data.z;if(b){this.data.z=b}if(k){this.data.x=k}var g=this.data.y.smps;this.data.y.smps=this.data.y.vars;this.data.y.vars=g;var l=this.data.y.data;this.data.y.data=[];for(var f=0;f<this.data.y.vars.length;f++){this.data.y.data[f]=[];for(var e=0;e<this.data.y.smps.length;e++){this.data.y.data[f][e]=l[e][f]}}this.initializeData(this.data);this.resetObject();this.draw()}};this.checkObject=function(){var d=this.data.y;if(this.isGroupedData){this.data.w={};d=this.data.w}var c=["vars","smps","desc","data","mean","median","stdev","n","qtl1","qtl3","iqr1","iqr3","out","trans","cor","sum","grps","close","open","high","low","volume"];for(var b=0;b<c.length;b++){if(!d[c[b]]){d[c[b]]=[]}}};this.resetObject=function(b){var d=["mean","median","stdev","n","qtl1","qtl3","iqr1","iqr3","out","cor","sum","grps","close","open","high","low","volume"];if(this.isGroupedData){if(!this.isTransformedData){d.push("trans")}for(var c=0;c<d.length;c++){delete (this.data.y[d[c]])}delete (this.data.w)}else{if(!this.isTransformedData){d.push("trans")}if(this.isRawData){for(var c=0;c<d.length;c++){delete (this.data.y[d[c]])}}else{delete (this.data.y.data)}}if(b){this.checkObject()}};this.getDataAtPos=function(g,e,c,d,f,b){var h=Number.NaN;var k=this.isGroupedData?this.data.w:this.data.y;if(this.isGroupedData||!this.isRawData){if(this.isTransformedData){h=k.trans[g][e]}else{c=c?c:this.summaryType;if(k.hasOwnProperty(c)){h=k[c][g][e]}else{h=0}}}else{if(c&&k[c][g]){h=k[c][g][e]}else{if(this.isTransformedData){h=k.trans[g][e]}else{h=k.data[g][e]}}}if(d){if(!isNaN(h)){if(d=="log2"){h=Math.log(h)/Math.LN2}else{if(d=="log10"){h=Math.log(h)/Math.LN10}else{if(d=="exp2"){h=Math.pow(2,h)}else{if(d=="exp10"){h=Math.pow(2,h)}else{if(d=="percentile"){h=this.percentile(f,b,h)}}}}}}}return h};this.getDataForSmpGrpAtIndex=function(c,g){var b=[];if(!g){g=this.varIndices}if(this.isGroupedData||!this.isRawData){var h=this.isGroupedData?this.data.w:this.data.y;if(this.isTransformedData){b.push(h.trans[f][c])}else{var d=this.summaryType;if(h.hasOwnProperty(d)){for(var e=0;e<g.length;e++){var f=g[e];b.push(h[d][f][c])}}}}else{if(this.isTransformedData){for(var e=0;e<g.length;e++){var f=g[e];b.push(this.data.y.trans[f][c])}}else{for(var e=0;e<g.length;e++){var f=g[e];b.push(this.data.y.data[f][c])}}}return b};this.getMetaDataForVariableAtIndex=function(b){var d={};if(this.data.z){for(var c in this.data.z){d[c]=this.data.z[c][b]}}d[name]=this.data.y.vars[b];return d};this.getMetaDataForSampleAtIndex=function(b){if(this.isGroupedData){return this.getMetaDataForGrpAtIndex(b)}else{return this.getMetaDataForSmpAtIndex(b)}};this.getMetaDataForSmpAtIndex=function(b){var d={};if(this.data.x){for(var c in this.data.x){d[c]=this.data.x[c][b]}}d[name]=this.data.y.vars[b];return d};this.getMetaDataForGrpAtIndex=function(b){var e=[];for(var c=0;c<this.data.w.grps[b].length;c++){var d=this.data.w.grps[b][c];e.push(this.getMetaDataForSmpAtIndex[d])}return e};this.summarize=function(l,o){var b=this.isGroupedData?this.data.w:this.data.y;var c=this.isGroupedData?false:true;if(!this.isGroupedData){this.checkObject()}if(l=="cor"){this.isBoxPlotCalc=false;if(this.correlationAxis=="samples"){var p=this.isGroupedData?this.grpIndices:this.smpIndices;for(var e=0;e<p.length;e++){var q=p[e];var m=this.getDataForSmpGrpAtIndex(q);if(!b.cor[q]){b.cor[q]=[]}for(var d=e;d<p.length;d++){var g=p[d];if(!b.cor[g]){b.cor[g]=[]}var k=this.getDataForSmpGrpAtIndex(g);if(e==d){if(this.isTransformedData){b.trans[q][g]=1}b.cor[q][g]=1}else{b.cor[q][g]=this.correlation(m,k);b.cor[g][q]=b.cor[q][g];if(this.isTransformedData){b.trans[q][g]=b.cor[q][g];b.trans[g][q]=b.cor[g][q]}}}}}else{for(var e=0;e<this.varIndices.length;e++){var q=this.varIndices[e];if(!b.cor[q]){b.cor[q]=[]}for(var d=e;d<this.varIndices.length;d++){var g=this.varIndices[d];if(!b.cor[g]){b.cor[g]=[]}if(e==d){b.cor[q][g]=1;if(this.isTransformedData){b.trans[q][g]=1}}else{b.cor[q][g]=this.correlation(b.data[q],b.data[g],c);b.cor[g][q]=b.cor[q][g];if(this.isTransformedData){b.trans[q][g]=b.cor[q][g];b.trans[g][q]=b.cor[g][q]}}}}}}else{this.isBoxPlotCalc=l=="iqr"?true:false;for(var e=0;e<this.varIndices.length;e++){var f;var q=this.varIndices[e];if(!b.mean[q]){b.trans[q]=[];b.mean[q]=[];b.median[q]=[];b.stdev[q]=[];b.qtl1[q]=[];b.qtl3[q]=[];b.iqr1[q]=[];b.iqr3[q]=[];b.out[q]=[];b.n[q]=[];b.sum[q]=[]}if(this.isGroupedData){f=o[q]}else{b.grps=[];f=[];for(var d=0;d<this.smpIndices.length;d++){var g=this.smpIndices[d];b.grps[d]=[];b.grps[d].push(g);f[d]=[b.data[q][g]]}}if(l=="iqr"){this.summaryType="iqr";for(var d=0;d<f.length;d++){var n=this.quantiles(f[d],c);if(this.isTransformedData){b.trans[q][d]=n[1]}b.median[q][d]=n[1];b.qtl1[q][d]=n[0];b.qtl3[q][d]=n[2];b.iqr1[q][d]=n[3];b.iqr3[q][d]=n[4];b.out[q][d]=n[5];b.n[q][d]=n[6]}}else{if(l=="median"){this.summaryType="median";for(var d=0;d<f.length;d++){var n=this.median(f[d],c);if(this.isTransformedData){b.trans[q][d]=n[1]}b.median[q][d]=n[0];b.n[q][d]=n[1]}}else{if(l=="mean"){this.summaryType="mean";for(var d=0;d<f.length;d++){var n=this.meanStandardDeviationN(f[d],c);if(this.isTransformedData){b.trans[q][d]=n[1]}b.mean[q][d]=n[0];b.stdev[q][d]=n[1];b.n[q][d]=n[2]}}else{if(l=="sum"){this.summaryType="sum";for(var d=0;d<f.length;d++){var h=this.sum(f[d],c);if(this.isTransformedData){b.trans[q][d]=h}b.sum[q][d]=h;b.n[q][d]=f[d].length}}}}}}}};this.copySummarizedData=function(){var f=this.isGroupedData?this.data.w:this.data.y;var e;for(var c=0;c<this.varIndices.length;c++){var d=this.varIndices[c];f.data[d]=[];f.trans[d]=[];if(this.summaryType=="mean"){for(var b=0;b<f.mean[d].length;b++){f.data[d][b]=f.mean[d][b]}}else{if(this.summaryType=="median"||this.summaryType=="iqr"){for(var b=0;b<f.median[d].length;b++){f.data[d][b]=f.median[d][b]}}else{if(this.summaryType=="candle"){for(var b=0;b<f.close[d].length;b++){f.data[d][b]=f.close[d][b]}}else{if(this.summaryType=="volume"){for(var b=0;b<f.volume[d].length;b++){f.data[d][b]=f.volume[d][b]}}else{if(this.summaryType=="sum"){for(var b=0;b<f.volume[d].length;b++){f.data[d][b]=f.sum[d][b]}}}}}}if(!e){e=d}}return e};this.transformValue=function(c,d,b){switch(c){case"log2":return b?Math.pow(2,d):Math.log(d)/Math.LN2;case"log10":return b?Math.pow(10,d):Math.log(d)/Math.LN10;case"exp2":return b?Math.log(d)/Math.LN2:Math.pow(2,d);case"exp10":return b?Math.log(d)/Math.LN10:Math.pow(10,d);default:return d}};this.transform=function(d,c,b){var e=0;if(!this.isGroupedData){this.checkObject()}if(!this.isRawData||this.isGroupedData){e=this.copySummarizedData()}this.transformType=d;if(d=="reset"||d=="undo"){this.transformReset();this.transformType=false;this.isTransformedData=false}else{if(d=="save"){this.transformSave();this.transformType=false;this.isTransformedData=false}else{if(d=="log2"||d=="log10"||d=="exp2"||d=="exp10"){this.transformLogExp(d);this.isTransformedData=true}else{if(d=="ratio"||d=="ratio2"||d=="ratio10"){this.transformRatio(d,b);this.isTransformedData=true}else{this.transformRelative(d,c,e);this.isTransformedData=true}}}}this.draw()};this.transformReset=function(){var e=this.isGroupedData?this.data.w:this.data.y;for(var c=0;c<this.varIndices.length;c++){var d=this.varIndices[c];for(var b=0;b<e.data[d].length;b++){if(e.trans[d]&&!isNaN(e.data[d][b])){e.trans[d][b]=e.data[d][b]}}}};this.transformSave=function(){var e=this.isGroupedData?this.data.w:this.data.y;for(var c=0;c<this.varIndices.length;c++){var d=this.varIndices[c];for(var b=0;b<e.data[d].length;b++){if(!isNaN(e.data[d][b])){e.data[d][b]=e.trans[d][b]}}}};this.transformLogExp=function(e){var f=this.isGroupedData?this.data.w:this.data.y;if(e=="log"){e=this.transformBase==2?"type2":"type10"}else{if(e=="exp"){e=this.transformBase==2?"exp2":"exp10"}}for(var c=0;c<this.varIndices.length;c++){var d=this.varIndices[c];if(!f.trans[d]){f.trans[d]=[]}for(var b=0;b<f.data[d].length;b++){if(!isNaN(f.data[d][b])){if(e=="log2"){this.isLogData=true;this.transformBase=2;f.trans[d][b]=Math.log(f.data[d][b])/Math.LN2}else{if(e=="log10"){this.isLogData=true;this.transformBase=10;f.trans[d][b]=Math.log(f.data[d][b])/Math.LN10}else{if(e=="exp2"){this.isLogData=false;this.transformBase=2;f.trans[d][b]=Math.pow(2,f.data[d][b])}else{if(e=="exp10"){this.isLogData=false;this.transformBase=10;f.trans[d][b]=Math.pow(10,f.data[d][b])}}}}}}}};this.transformRatio=function(f,b){var h=this.isGroupedData?this.data.w:this.data.y;b=b?b:this.ratioReference;for(var d=0;d<this.varIndices.length;d++){var e=this.varIndices[d];if(!h.trans[e]){h.trans[e]=[]}for(var c=0;c<h.data[e].length;c++){if(!isNaN(h.data[e][c])&&!isNaN(h.data[e][b])){if(this.isLogData){if(f=="ratio"){f=this.transformBase==2?"ratio2":"ratio10"}var g;if(h.data[e][c]>=h.data[e][b]){g=h.data[e][c]-h.data[e][b];if(f=="ratio2"){h.trans[e][c]=Math.pow(2,g)}else{if(f=="ratio10"){h.trans[e][c]=Math.pow(10,g)}}}else{g=h.data[e][b]/h.data[e][d];if(f=="ratio2"){h.trans[e][c]=Math.pow(2,g)*-1}else{h.trans[e][c]=Math.pow(10,g)*-1}}}else{if(h.data[e][c]>=h.data[e][b]){h.trans[e][c]=h.data[e][c]/h.data[e][b]}else{h.trans[e][c]=h.data[e][b]/h.data[e][c]*-1}}}}}};this.transformRelative=function(l,d,e){var b=this.isGroupedData?this.data.w:this.data.y;var c=this.isGroupedData?false:true;d=d?d:this.zscoreAxis;if(d=="samples"){for(var g=0;g<b.data[e].length;g++){var h=[];for(var f=0;f<this.varIndices.length;f++){var k=this.varIndices[f];h.push(b.data[k][g])}if(l=="percentile"){var m=this.range(h,c)}else{if(l=="zscore"){var m=this.meanStandardDeviationN(h,c)}}for(var f=0;f<this.varIndices.length;f++){var k=this.varIndices[f];if(!b.trans[k]){b.trans[k]=[]}if(!isNaN(b.data[k][g])){if(l=="percentile"){b.trans[k][g]=this.percentile(m[0],m[1],b.data[k][g])}else{if(l=="zscore"){b.trans[k][g]=(b.data[k][g]-m[0])/m[1]}}}}}}else{for(var g=0;g<this.varIndices.length;g++){var n=this.varIndices[g];b.trans[n]=[];var h=b.data[n];if(l=="percentile"){var m=this.range(h,c)}else{if(l=="zscore"){var m=this.meanStandardDeviationN(h,c)}}for(var f=0;f<h.length;f++){if(!isNaN(b.data[n][f])){if(l=="percentile"){b.trans[n][f]=this.percentile(m[0],m[1],b.data[n][f])}else{if(l=="zscore"){b.trans[n][f]=(b.data[n][f]-m[0])/m[1]}}}}}}};this.sortSamples=function(e,f,b){this.sortIndices("smps",e,f,false,b);this.draw()};this.sortVariables=function(e,f,b){this.sortIndices("vars",e,f,b);this.draw()};this.getGroupingFactors=function(b){if(b){return this.groupingFactors}else{return this.getObjectArray(this.groupingFactors)}};this.modifyGroupingFactors=function(c,b){this.modifyObjectArray(c,b,"groupingFactors")};this.segregateSamplesVariables=function(l,k,g,m,c){delete (this.data.l);this.deleteSubGraphAttributes();this.data.l={};this.data.l.smps=l;this.data.l.vars=k;this.data.l.weight=[];this.data.l.type=[];this.data.l.name=[];this.data.l.desc=[];var h=1/l.length;var e=1/k.length;var f=this.data.y.desc[0]?this.data.y.desc[0]:"";for(var d=0;d<k.length;d++){for(var b=0;b<l.length;b++){this.data.l.weight.push([e,h]);this.data.l.type.push(this.graphType);this.data.l.name.push([m[d],g[b]]);this.data.l.desc.push(f)}}this.layoutComb=true;this.layout=l.length+"X"+k.length;this.isValidLayout();if(!c){this.draw()}};this.desegregateSamples=function(b){this.segregateSamplesBy=false;this.showAnimation=this.showAnimationTemp;this.resetLayout();if(this.segregateVariablesBy){this.segregateVariables(this.segregateVariablesBy,b)}else{this.isValidLayout()}if(!b){this.draw()}};this.segregateSamples=function(c,e){if(this.data.x&&this.data.x[c]){delete (this.layoutParams);var d={};var b=0;var g=[];var h=[];for(var f=0;f<this.data.x[c].length;f++){var k=this.data.x[c][f];if(!d.hasOwnProperty(k)){d[k]=[];b++}d[k].push(this.data.y.smps[f])}var j=1/b;if(this.segregateVariablesBy){vars=this.data.l.vars;for(var k in d){g.push(k);h.push(d[k])}this.segregateSamplesBy=c;this.segregateSamplesVariables(h,this.data.l.vars,g,this.data.l.name,e)}else{delete (this.data.l);this.deleteSubGraphAttributes();this.data.l={};this.data.l.smps=[];this.data.l.weight=[];this.data.l.type=[];this.data.l.name=[];this.data.l.desc=[];for(var k in d){this.data.l.smps.push(d[k]);this.data.l.weight.push(j);this.data.l.type.push(this.graphType);this.data.l.name.push(k);this.data.l.desc.push(this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:"")}this.segregateSamplesBy=c;this.layoutComb=true;this.showAnimationTemp=this.showAnimation;this.showAnimation=false;this.layout="1X"+this.data.l.smps.length;this.isValidLayout()}if(!e){this.draw()}}};this.desegregateVariables=function(b){this.segregateVariablesBy=false;this.showAnimation=this.showAnimationTemp;this.resetLayout();if(this.segregateSamplesBy){this.segregateSamples(this.segregateSamplesBy,b)}else{this.isValidLayout()}if(!b){this.draw()}};this.segregateVariables=function(k,d){if(this.data.z&&this.data.z[k]){delete (this.layoutParams);var c={};var b=0;var h=[];var j=[];for(var e=0;e<this.data.z[k].length;e++){var f=this.data.z[k][e];if(!c.hasOwnProperty(f)){c[f]=[];b++}c[f].push(this.data.y.vars[e])}var m=1/b;if(this.segregateSamplesBy){for(var f in c){j.push(f);h.push(c[f])}this.segregateVariablesBy=k;this.segregateSamplesVariables(this.data.l.smps,h,this.data.l.name,j,d)}else{delete (this.data.l);this.deleteSubGraphAttributes();this.data.l={};this.data.l.vars=[];this.data.l.weight=[];this.data.l.type=[];this.data.l.name=[];this.data.l.desc=[];for(var f in c){this.data.l.vars.push(c[f]);this.data.l.weight.push(m);this.data.l.type.push(this.graphType);this.data.l.name.push(f);this.data.l.desc.push(this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:"")}this.segregateVariablesBy=k;this.layoutComb=true;this.showAnimationTemp=this.showAnimation;this.showAnimation=false;this.layout="1X"+this.data.l.vars.length;this.isValidLayout()}if(!d){this.draw()}}};this.deleteSubGraphAttributes=function(){if(this.layoutRows&&this.layoutCols){var e=0;for(var d=0;d<this.layoutRows;d++){for(var b=0;b<this.layoutCols;b++){delete (this["subGraphWeight"+e]);delete (this["subGraphType"+e]);delete (this["subGraphSummaryType"+e]);delete (this["subGraphTransformType"+e]);e++}}}};this.unsetAllVsAll=function(){if(this.graphType.match(/Scatter/)){if(this.xAxisTemp&&this.xAxisTemp.length>0){this.xAxis=this.xAxisTemp;this.xAxisTmp=[]}if(this.yAxisTemp&&this.yAxisTemp.length>0){this.yAxis=this.yAxisTemp;this.yAxisTmp=[]}if(this.zAxisTemp&&this.zAxisTemp.length>0){this.zAxis=this.zAxisTemp;this.zAxisTmp=[]}if(!this.xAxis||!this.yAxis){this.xAxis=[];this.yAxis=[];this.xAxisIndices=[];this.yAxisIndices=[];this.xAxis=[this.data.y.smps[0]];for(var b=1;b<this.data.y.smps.length;b++){this.yAxis.push(this.data.y.smps[b])}this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis);this.initAxes(true)}this.allVsAll=false;if(this.showAnimationTemp){this.showAnimation=this.showAnimationTemp}this.resetLayout();this.isValidLayout()}};this.setAllVsAll=function(){if(this.graphType.match(/Scatter/)){var e=this.data.y.data[0].length;var b=1/e;this.xAxisTemp=this.xAxisTemp||this.xAxis;this.xAxis=[];this.yAxisTemp=this.yAxisTemp||this.yAxis;this.yAxis=[];this.zAxisTemp=this.zAxisTemp||this.zAxis;this.zAxis=[];this.data.l={};this.data.l.smps=[];this.data.l.weight=[];this.data.l.type=[];this.data.l.desc=[];for(var d=0;d<e;d++){for(var c=0;c<e;c++){this.data.l.weight.push(b);this.data.l.desc.push(this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:"");this.data.l.type.push(this.graphType);if(d==c){this.data.l.smps.push({})}else{if(this.allVsAllType=="upper"){if(c>d){this.data.l.smps.push({xAxis:[this.data.y.smps[c]],yAxis:[this.data.y.smps[d]]})}else{this.data.l.smps.push({})}}else{if(this.allVsAllType=="lower"){if(d>c){this.data.l.smps.push({xAxis:[this.data.y.smps[c]],yAxis:[this.data.y.smps[d]]})}else{this.data.l.smps.push({})}}else{this.data.l.smps.push({xAxis:[this.data.y.smps[c]],yAxis:[this.data.y.smps[d]]})}}}}}this.layoutComb=true;this.showAnimationTemp=this.showAnimation;this.showAnimation=false;this.layout=e+"X"+e;this.isValidLayout()}};this.setMultiplePies=function(){if(this.graphType.match(/Pie/)){var g,j;var h=this.xAxis.length;if(this.layout){var d=this.layout.split(/X/i);g=parseInt(d[0]);j=parseInt(d[1]);if(g*j<h){g=Math.ceil(Math.sqrt(h));j=Math.floor(Math.sqrt(h));this.layout=g+"X"+j}}else{g=Math.ceil(Math.sqrt(h));j=Math.floor(Math.sqrt(h));this.layout=g+"X"+j}var b=1/g;var f=1/j;delete (this.layoutParams);delete (this.data.l);this.deleteSubGraphAttributes();this.data.l={};this.data.l.smps=[];this.data.l.weight=[];this.data.l.type=[];this.data.l.desc=[];for(var e=0;e<h;e++){this.data.l.smps.push([this.xAxis[e]]);this.data.l.weight.push([f,b]);this.data.l.desc.push(this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:"");this.data.l.type.push(this.graphType)}this.layoutComb=true;this.showAnimationTemp=this.showAnimation;this.showAnimation=false;this.isValidLayout()}};this.ungroupSamples=function(){this.isGroupedData=false;this.groupingFactors=[];this.grpIndices=[];this.hiddenGrps=[];this.setMaxSmpStringName();return};this.createHistogram=function(d){var n,k,h,p,q;var c=0;var o=[];var b=[];var m=[];var g={};g.y={};g.y.data=[];g.y.vars=[];g.y.smps=[];if(this.graphType.match(/Scatter/)){if(this.type2D=="XYZ"){n=d=="y"?this.yAxisIndices[this.yAxisCurrent]:this.xAxisIndices[this.xAxisCurrent];o.push(n)}else{if(this.type2D=="XY"){for(var f=0;f<this.xAxisIndices.length;f++){n=d=="y"?this.yAxisIndices[f]:this.xAxisIndices[f];o.push(n)}}else{if(this.type2D=="X"){if(d=="y"){o.push(this.yAxisIndices[this.yAxisCurrent])}else{for(var f=0;f<this.xAxisIndices.length;f++){o.push(this.xAxisIndices[f])}}}else{if(d=="y"){for(var f=0;f<this.yAxisIndices.length;f++){o.push(this.yAxisIndices[f])}}else{o.push(this.xAxisIndices[this.xAxisCurrent])}}}}for(var f=0;f<this.histogramBins;f++){g.y.vars.push("Bin"+(f+1));g.y.data[f]=[]}for(var f=0;f<o.length;f++){g.y.smps.push(this.data.y.smps[o[f]]);g.y.smps.push(this.data.y.smps[o[f]]+" counts");b.push(this.data.y.smps[o[f]]);m.push(this.data.y.smps[o[f]]+" counts");var l=[];for(var e=0;e<this.histogramBins;e++){l[e]=0}k=this.getDataForSmpGrpAtIndex(o[f]);h=this.range(k);p=((h[1]-h[0])/this.histogramBins)+(h[0]/(this.histogramBins*2));for(var e=0;e<k.length;e++){q=Math.floor((k[e]-h[0])/p);l[q]++}for(var e=0;e<this.histogramBins;e++){g.y.data[e][c]=p*(e+1)}c++;for(var e=0;e<this.histogramBins;e++){g.y.data[e][c]=l[e]}c++}this.isCreateHistogram=true;this.isHistogram=true;this.histogramBarWidthStndBy=this.histogramBarWidth;this.dataStndBy=this.data;this.data={};this.resetConfig(["graphType","isHistogram"]);this.xAxis=b;this.yAxis=m;this.showLegend=false;this.histogramBarWidth=1.5;this.initializeData(g)}};this.removeHistogram=function(){this.isCreateHistogram=false;this.histogramBarWidth=this.histogramBarWidthStndBy;this.switchData()};this.addRegressionLine=function(){var c,h,e,b,j,g,d;if(this.graphType.match(/Scatter/)){if(this.type2D=="XYZ"){c=this.xAxisIndices[this.xAxisCurrent];h=this.yAxisIndices[this.yAxisCurrent];g=this.data.y.smps[c]+" vs "+this.data.y.smps[h];e=this.getDataForSmpGrpAtIndex(c);b=this.getDataForSmpGrpAtIndex(h);j=this.regression(e,b);this.addRegressionDecoration(j,g,this.foreground)}else{if(this.type2D=="XY"){for(var f=0;f<this.xAxisIndices.length;f++){d=f%this.colors.length;c=this.xAxisIndices[f];h=this.yAxisIndices[f];g=this.data.y.smps[c]+" vs "+this.data.y.smps[h];e=this.getDataForSmpGrpAtIndex(c);b=this.getDataForSmpGrpAtIndex(h);j=this.regression(e,b);this.addRegressionDecoration(j,g,this.colors[d])}}else{if(this.type2D=="X"){h=this.yAxisIndices[this.yAxisCurrent];b=this.getDataForSmpGrpAtIndex(h);for(var f=0;f<this.xAxisIndices.length;f++){d=f%this.colors.length;c=this.xAxisIndices[f];g=this.data.y.smps[c]+" vs "+this.data.y.smps[h];e=this.getDataForSmpGrpAtIndex(c);j=this.regression(e,b);this.addRegressionDecoration(j,g,this.colors[d])}}else{c=this.xAxisIndices[this.xAxisCurrent];e=this.getDataForSmpGrpAtIndex(c);for(var f=0;f<this.yAxisIndices.length;f++){d=f%this.colors.length;h=this.yAxisIndices[f];b=this.getDataForSmpGrpAtIndex(h);g=this.data.y.smps[c]+" vs "+this.data.y.smps[h];j=this.regression(e,b);this.addRegressionDecoration(j,g,this.colors[d])}}}}}};this.addRegressionDecoration=function(d,c,b){this.showDecorations=true;if(!this.data.d){this.data.d={}}if(!this.data.d.reg){this.data.d.reg=[]}this.data.d.reg.push({slope:d[0],intercept:d[1],cor:d[2],label:c,color:b})};this.addNormalDistributionLine=function(c){var o,g,m,h,j,k,l,f,d,f,b,n;if(this.graphType.match(/Scatter/)){if(this.type2D=="XYZ"){m=c=="y"?this.yAxisIndices[this.yAxisCurrent]:this.xAxisIndices[this.xAxisCurrent];h=c=="y"?this.xAxisIndices[this.xAxisCurrent]:this.yAxisIndices[this.yAxisCurrent];j=this.getDataForSmpGrpAtIndex(m);k=this.getDataForSmpGrpAtIndex(h);l=this.max(k);f=this.data.y.smps[m];d=this.meanStandardDeviationN(j);this.addNormalDistributionDecoration(d,l,f,this.foreground,c)}else{o=c=="y"?this.yAxisIndices:this.xAxisIndices;g=c=="y"?this.xAxisIndices:this.yAxisIndices;n=c=="y"?this.xAxisCurrent:this.yAxisCurrent;for(var e=0;e<o.length;e++){b=e%this.colors.length;m=o[e];h=g[e]?g[e]:g[n];j=this.getDataForSmpGrpAtIndex(m);k=this.getDataForSmpGrpAtIndex(h);l=this.max(k);f=this.data.y.smps[m];d=this.meanStandardDeviationN(j);this.addNormalDistributionDecoration(d,l,f,this.colors[b],c)}}}};this.addNormalDistributionDecoration=function(f,b,d,c,e){this.showDecorations=true;if(!this.data.d){this.data.d={}}if(!this.data.d.nor){this.data.d.nor=[]}if(e&&e=="y"){this.data.d.nor.push({mu:f[0],sigma:f[1],yAxis:true,max:b,label:d,color:c})}else{this.data.d.nor.push({mu:f[0],sigma:f[1],max:b,label:d,color:c})}};this.createRandomData=function(){var e={};e.y={};e.y.data=[];e.y.vars=[];e.y.smps=[];for(var c=0;c<this.randomDataSamples;c++){e.y.smps[c]="Sample"+(c+1)}for(var c=0;c<this.randomDataVariables;c++){e.y.data[c]=[];e.y.vars[c]="Variable"+(c+1);for(var b=0;b<this.randomDataSamples;b++){e.y.data[c].push(Math.floor(((Math.random()*2-1)+(Math.random()*2-1)+(Math.random()*2-1))*this.randomDataSigma+this.randomDataMean))}}e.x={};var d=Math.floor(this.randomDataSamples/this.randomDataSampleAnnotationRatio);for(var c=0;c<this.randomDataSampleAnnotations;c++){e.x["Factor"+(c+1)]=[];for(var b=0;b<this.randomDataSamples;b++){e.x["Factor"+(c+1)][b]="Level"+(Math.floor(Math.random()*d)+1)}}e.z={};var d=Math.floor(this.randomDataVariables/this.randomDataVariableAnnotationRatio);for(var c=0;c<this.randomDataVariableAnnotations;c++){e.z["Annt"+(c+1)]=[];for(var b=0;b<this.randomDataVariables;b++){e.z["Annt"+(c+1)][b]="Desc"+(Math.floor(Math.random()*d)+1)}}if(this.data&&!this.dataStndBy){this.dataStndBy=this.data;this.data={}}this.resetConfig(["graphType"]);this.initializeData(e)};this.restoreRandomData=function(){this.switchData()};this.groupSamples=function(e,p){if(e.length<1){return this.ungroupSamples()}for(var h=0;h<e.length;h++){if(!e||!this.data.x[e[h]]){return this.ungroupSamples()}}if(this.layoutComb&&this.data.l.comp){this.varIndices=[];for(var h=0;h<this.data.l.comp.length;h++){for(var g=0;g<this.data.l.comp[h].length;g++){this.varIndices.push(this.data.l.comp[h][g])}}}this.resetIndices();this.isGroupedData=true;this.groupingFactors=e;this.resetObject(true);this.hiddenGrps=[];var v={};var b=[];var d=0;for(var h=0;h<this.smpIndices.length;h++){var r=this.smpIndices[h];var u=[];var q;for(var g=0;g<e.length;g++){var l=e[g];q=this.data.x[l][r];if(!q){q="NA"}u.push(q)}q=u.join(" - ");if(!v.hasOwnProperty(q)){this.data.w.smps.push(q);b[d]=q;v[q]=[];v[q].push(r);d++}else{v[q].push(r)}}for(var h=0;h<b.length;h++){var q=b[h];this.data.w.grps.push(v[q])}this.grpIndices=[];for(var h=0;h<this.data.w.grps.length;h++){this.grpIndices.push(h);this.hiddenGrps.push(false)}for(var h=0;h<this.varIndices.length;h++){this.data.w.vars.push(this.data.y.vars[this.varIndices[h]])}var m=[];if(p){if(this.isArray(p)){m=p}else{m.push(p)}}else{p=this.graphType=="Boxplot"?"iqr":"mean";m.push(p)}for(var s=0;s<m.length;s++){var o=[];var n=m[s];if(this.isTransformedData){a=this.data.y.trans}else{if(this.isRawData){a=this.data.y.data}else{if(this.summaryType=="median"||this.summaryType=="iqr"){a=this.data.y.median}else{if(this.summaryType=="mean"){a=this.data.y.mean}else{if(this.summaryType=="cor"){a=this.data.y.cor}else{if(this.summaryType=="sum"){a=this.data.y.sum}else{a=this.data.y[this.summaryType]}}}}}}for(var h=0;h<this.varIndices.length;h++){var r=this.varIndices[h];o[r]=[];for(var g=0;g<this.data.w.grps.length;g++){o[r][g]=[];for(var f=0;f<this.data.w.grps[g].length;f++){var c=this.data.w.grps[g][f];o[r][g].push(a[r][c])}}}this.summarize(n,o)}this.setMaxVarStringName();this.setMaxSmpStringName();this.xAxisValues=[];this.xAxis2Values=[];this.yAxisValues=[];this.zAxisValues=[];if(!this.layoutComb||!this.layoutAdjust){if(typeof(this.setAxes)=="function"){this.setAxes()}}this.draw()};this.initializeDataAttributes=function(){this.setIndices();if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){this.setMaxVarStringAttr();this.setMaxSmpStringAttr()}};this.initializeData=function(b){if(a&&!b){this.isExample=false;this.data=a;delete a}else{if(b){this.isExample=false;this.data=b;delete b}else{if(!this.remoteService){this.isExample=true}this.data=this.exampleRawData}}this.validGraphTypes=[];if(this.data.y||this.data.venn||this.data.nodes||this.data.tracks||this.data.market||this.data.fx){if(this.data.fx){this.FunctionData()}if(this.data.market){this.setMarketData();this.summaryType="candle";this.validGraphTypes.push("Candlestick")}if(this.data.venn){this.summaryType="venn";this.validGraphTypes.push("Venn")}if(this.data.nodes){this.summaryType="network";this.validGraphTypes.push("Network")}if(this.data.tracks){this.summaryType="genome";this.validGraphTypes.push("Genome")}if(this.data.y){if(!this.data.y.data&&!this.data.y.mean&&!this.data.y.median&&!this.data.y.cor&&!this.data.y.sum&&!this.data.y.close){alert("Dude! there is not a valid data structure");return}else{if(this.data.y.data){this.isRawData=true;this.summaryType="raw"}else{this.isRawData=false;if(this.data.y.iqr1&&this.data.y.qtl1&&this.data.y.median&&this.data.y.qtl3&&this.data.y.iqr3){this.summaryType="iqr"}else{if(this.data.y.median){this.summaryType="median"}else{if(this.data.y.mean){this.summaryType="mean"}else{if(this.data.y.cor){this.summaryType="cor"}else{if(this.data.y.sum){this.summaryType="sum"}}}}}}}this.validGraphTypes.push("Bar");this.validGraphTypes.push("Line");this.validGraphTypes.push("Area");this.validGraphTypes.push("AreaLine");this.validGraphTypes.push("BarLine");this.validGraphTypes.push("Boxplot");this.validGraphTypes.push("Dotplot");this.validGraphTypes.push("Heatmap");this.validGraphTypes.push("Stacked");this.validGraphTypes.push("StackedLine");this.validGraphTypes.push("StackedPercent");this.validGraphTypes.push("StackedPercentLine");this.validGraphTypes.push("Pie");this.validGraphTypes.push("Correlation");if(this.data.y.smps){if(this.data.y.smps.length>2){this.validGraphTypes.push("Scatter2D");this.validGraphTypes.push("ScatterBubble2D");this.validGraphTypes.push("Scatter3D")}else{if(this.data.y.smps.length>1){this.validGraphTypes.push("Scatter2D")}}}}this.validGraphTypes.sort()}this.initializeDataAttributes()};this.setMarketTechnicalData=function(){if(this.stockIndicators.length>0){var c={};var h=false;var l={Sma5:5,Sma10:10,Sma20:20,Sma25:25,Sma50:50};var b=[];for(var g=0;g<this.stockIndicators.length;g++){if(l.hasOwnProperty(this.stockIndicators[g])){b.push(this.stockIndicators[g])}}if(b.length>0){this.stockIndicators=b;var m={};for(var g=0;g<this.stockIndicators.length;g++){var o=this.stockIndicators[g];if(l.hasOwnProperty(o)&&!this.data.y.hasOwnProperty(o)){c[o]=true;h=true;m[o]=[];this.data.y[o]=[];for(var f=0;f<this.data.y.vars.length;f++){m[o][f]=[];this.data.y[o][f]=[]}}}if(h){for(var g=0;g<this.data.y.smps.length;g++){for(var f=0;f<this.data.y.vars.length;f++){for(var d=0;d<this.stockIndicators.length;d++){var o=this.stockIndicators[d];if(c.hasOwnProperty(o)){if(!isNaN(this.data.y.close[f][g])){m[o][f].push(this.data.y.close[f][g]);if(m[o][f].length==l[o]){if(o.match(/Sma/)){this.data.y[o][f][g]=this.mean(m[o][f]);m[o][f].shift()}}}}}}}}}}};this.setMarketData=function(){if(this.data.market&&!this.isMarketDataFormated){var c=this.data.market;this.data.market={};this.data.market.smps=[];this.data.market.vars=[];this.data.market.close=[];this.data.market.open=[];this.data.market.high=[];this.data.market.low=[];this.data.market.volume=[];this.data.market.desc=["Price","Vol"];var k={};var g=0;for(var f=0;f<c.length;f++){this.data.market.vars.push(c[f].symbol);this.data.market.close[f]=[];this.data.market.open[f]=[];this.data.market.high[f]=[];this.data.market.low[f]=[];this.data.market.volume[f]=[];var h=c[f].data;for(var e=h.length-1;e>=0;e--){var l=this.parseDate(h[e][0]);var b=0;if(!k.hasOwnProperty(l)){b=g;k[l]=g;this.data.market.smps.push(l);g++}else{b=k[l]}this.data.market.open[f][b]=h[e][1];this.data.market.high[f][b]=h[e][2];this.data.market.low[f][b]=h[e][3];this.data.market.close[f][b]=h[e][4];this.data.market.volume[f][b]=h[e][5]}}}this.isMarketDataFormated=true};this.switchToMarketData=function(){var b=this.data.market;this.dataStndBy=this.data;this.data={};this.data.y=b;this.initializeDataAttributes();if(this.showVolume){this.deleteSubGraphAttributes();this.data.l={};this.data.l.vars=[this.data.y.vars,this.data.y.vars];this.data.l.weight=this.graphOrientation=="vertical"?[0.75,0.25]:[0.25,0.75];this.data.l.type=["Candlestick","Candlestick"];this.data.l.name=this.graphOrientation=="vertical"?["Price","Volume"]:["Volume","Price"];this.data.l.desc=this.graphOrientation=="vertical"?["Price","Volume"]:["Volume","Price"];this.segregateSamplesBy=false;this.segregateVariablesBy=false;this.layoutComb=true;this.layout="1X2";this.isValidLayout()}};this.switchFromMarketData=function(){this.switchData();if(this.showVolume){this.resetLayout();this.isValidLayout()}};this.switchData=function(){if(this.dataStndBy){this.initConfig();this.data=this.dataStndBy;this.initializeData(this.data)}};this.initializeData()};CanvasXpress.prototype.initRemote=function(){this.ajaxRequest=function(url,callback,format,method){format=format=="json"?"json":"text";method=method=="POST"?"POST":"GET";var http=false;if(window.XMLHttpRequest){try{http=new XMLHttpRequest()}catch(e){http=false}}else{if(typeof ActiveXObject!="undefined"){try{http=new ActiveXObject("Msxml2.XMLHTTP")}catch(e){try{http=new ActiveXObject("Microsoft.XMLHTTP")}catch(E){http=false}}}}if(http&&url&&callback){var now="uid="+new Date().getTime();url+=(url.indexOf("?")+1)?"&":"?";url+=now;http.open(method,url,true);if(method=="GET"){if(http.overrideMimeType){http.overrideMimeType("text/xml")}}else{var parameters=false;var parts=url.split("?");url=parts[0];parameters=parts[1];http.setRequestHeader("Content-type","application/x-www-form-urlencoded");http.setRequestHeader("Content-length",parameters.length);http.setRequestHeader("Connection","close")}http.onreadystatechange=function(){if(http.readyState==4){if(http.status==200){var result="";if(http.responseText){result=http.responseText}if(format=="json"){result=result.replace(/[\n\r]/g,"");result=eval("("+result+")")}if(callback){callback(result)}}else{if(error){error(http.status)}}}};http.send(parameters)}};this.requestRemoteData=function(ini){var params="index="+this.remoteDataIndex+"&dir="+this.remoteDirection;for(var p in this.remoteParams){params+="&"+p+"="+this.remoteParams[p]}if(ini){params+="&records=true"}var url=this.remoteService+"?"+params;this.ajaxRequest(url,this.updateRemoteData,"json","GET")};this.castRemoteParameters=function(o){o.remoteService=this.remoteService;o.remoteDirection=this.remoteDirection;o.remoteDataIndex=this.remoteDataIndex;o.remoteWindow=this.remoteWindow;o.remoteAutoPlay=this.remoteAutoPlay;o.remoteAutoPlayDelay=this.remoteAutoPlayDelay;for(var p in this.remoteParams){o.remoteParams[p]=this.remoteParams[p]}o.addRemoveNavigationTopListeners("addEvtListener");o.addRemoveNavigationLeftRightListeners("addEvtListener")};this.updateRemoteData=function(t){return function(res){if(res&&res.data){var d=res.data;var a=t.remoteDirection=="next"?true:false;var w=document.getElementById("wrapper-"+t.target);if(w){var p=w.parentNode;var r=w.getClientRects();var o=document.getElementById(t.target);var l=t.target;t.insertTarget(d.renderTo,w,o.width,o.height,a);d.hidden=true;var n=new CanvasXpress(d);t.castRemoteParameters(n);t.addSelectOptionsRemoteData(p,res.ids);t.updateSelectOptionsRemoteData(p);t.resetInfoSpan(false,true);t.animateTransition(p,r[0],l);if(t.Ext){if(!n.Ext){n.Ext={canvasId:d.renderTo,canvas:n}}}if(res.postprocess){for(var i=0;i<res.postprocess.length;i++){var fn=res.postprocess[i].func;var pr=res.postprocess[i].param;if(fn){if(pr){n[fn].apply(n,pr)}else{n[fn]()}}}}if(res.info){n.updateInfoDiv(res.info);n.showInfoDiv()}if(t.showCode){n.updateCodeDiv()}}}else{t.remoteDataIndex=t.remoteDirection=="next"?t.remoteDataIndex-1:t.remoteDataIndex+1;t.remoteUpdating=false}}}(this);this.addSelectOptionsRemoteData=function(p,ids){if(ids){var s=p.parentNode.firstChild.lastChild;for(var i=0;i<ids.length;i++){var opt=document.createElement("option");opt.text=ids[i];opt.value=i;if(this.remoteDataIndex==i){opt.selected="selected"}try{s.add(opt,null)}catch(ex){s.add(opt)}}if(ids.length==1){this.hideNavigation()}else{this.showNavigation()}}};this.updateSelectOptionsRemoteData=function(p){var s=p.parentNode.firstChild.lastChild;if(s){s.selectedIndex=this.remoteDataIndex}};this.animateTransition=function(b,r,o){if(b&&r){var that=this;var step=15;var s=0;var c1=b.firstChild;var c2=b.lastChild;var w=r.width;var h=r.height;b.parentNode.style.overflow="hidden";if(this.isIE){if(this.remoteDirection=="next"){b.removeChild(c1)}else{b.removeChild(c2)}b.style.overflow="auto";b.parentNode.style.overflow="visible";this.remoteUpdating=false}else{var updater=function(){this.update=function(){var n=Math.atan((s/step)*10-5)*0.5/Math.atan(5)+0.5;var l=w*n;if(s>=step){clearInterval(clearUpdateInt);that.destroy(o);if(that.remoteDirection=="next"){c2.style.left=0+"px"}else{c1.style.left=0+"px"}b.style.overflow="auto";b.parentNode.style.overflow="visible";that.remoteUpdating=false}else{if(that.remoteDirection=="next"){c1.style.left=(l*-1)+"px";c2.style.left=(l*-1)+"px"}else{c1.style.left=(-w+l)+"px";c2.style.left=(-w+l)+"px"}c1.style.display="block";c2.style.display="block"}s++};var clearUpdateInt=setInterval(this.update,100)};updater.call()}}};this.handleRemoteSelect=function(t){return function(e){var i=t.isIE?e.srcElement.selectedIndex:e.target.selectedIndex;t.remoteDirection=i>t.remoteDataIndex?"next":"previous";t.remoteDataIndex=i;t.requestRemoteData()}}(this);this.handleRemoteClickStop=function(t){return function(e){t.remoteStop=true}}(this);this.handleRemoteClickPlay=function(t){return function(e){var s=t.isIE?e.srcElement.parentNode.lastChild:e.target.parentNode.lastChild;t.remoteDirection="next";t.remoteStop=false;t.playRemoteData(s)}}(this);this.playRemoteData=function(s){var updater=function(){that=CanvasXpress.references[0];if(that){if(!that.remoteUpdating&&!that.remoteStop){that.remoteUpdating=true;that.showInfoSpan(false,"Updating ...",true);if(s&&s.tagName.match(/select/i)&&that.remoteDataIndex>=s.length-1){that.remoteDataIndex=0}else{that.remoteDataIndex++}that.requestRemoteData()}}this.update=function(){that=CanvasXpress.references[0];if(that){if(!that.remoteUpdating&&!that.remoteStop){that.remoteUpdating=true;that.showInfoSpan(false,"Updating ...",true);if(s&&s.tagName.match(/select/i)&&that.remoteDataIndex>=s.length-1){that.remoteDataIndex=0}else{that.remoteDataIndex++}that.requestRemoteData()}if(that.remoteStop){clearInterval(cl)}}else{clearInterval(cl)}};var cl=setInterval(this.update,that.remoteAutoPlayDelay)};updater.call()};this.handleRemoteClickPrev=function(t){return function(e){if(!t.remoteUpdating){var s=t.isIE?e.srcElement.parentNode.lastChild:e.target.parentNode.lastChild;t.remoteUpdating=true;t.showInfoSpan(false,"Updating ...",true);t.remoteDirection="previous";if(s&&s.tagName.match(/select/i)&&t.remoteDataIndex<=0){t.remoteDataIndex=s.length-1}else{t.remoteDataIndex--}t.requestRemoteData()}}}(this);this.handleRemoteClickNext=function(t){return function(e){if(!t.remoteUpdating){var s=t.isIE?e.srcElement.parentNode.lastChild:e.target.parentNode.lastChild;t.remoteUpdating=true;t.showInfoSpan(false,"Updating ...",true);t.remoteDirection="next";if(s&&s.tagName.match(/select/i)&&t.remoteDataIndex>=s.length-1){t.remoteDataIndex=0}else{t.remoteDataIndex++}t.requestRemoteData()}}}(this);this.addRemoteNavigationTop=function(w){var m="3px";var n=document.createElement("div");n.id="canvasXpressRemoteWindowTopBar";n.style.position="absolute";n.style.marginLeft=w+"px";n.style.display="none";var r=document.createElement("img");r.id="canvasXpressRemoteWindowTopBarPrev";r.src=this.imageDir+this.previousButton;r.style.margin=m;n.appendChild(r);var p=document.createElement("img");p.id="canvasXpressRemoteWindowTopBarPlay";p.src=this.imageDir+this.playButton;p.style.margin=m;n.appendChild(p);var e=document.createElement("img");e.id="canvasXpressRemoteWindowTopBarStop";e.src=this.imageDir+this.stopButton;e.style.margin=m;n.appendChild(e);var f=document.createElement("img");f.id="canvasXpressRemoteWindowTopBarNext";f.src=this.imageDir+this.nextButton;f.style.margin=m;n.appendChild(f);var s=document.createElement("select");s.id="canvasXpressRemoteWindowTopBarSelect";s.style.position="absolute";s.style.fontSize="x-small";n.appendChild(s);return n};this.addRemoveNavigationTopListeners=function(t){var r=document.getElementById("canvasXpressRemoteWindowTopBarPrev");var p=document.getElementById("canvasXpressRemoteWindowTopBarPlay");var e=document.getElementById("canvasXpressRemoteWindowTopBarStop");var f=document.getElementById("canvasXpressRemoteWindowTopBarNext");var s=document.getElementById("canvasXpressRemoteWindowTopBarSelect");if(r){this[t](r,"click",this.handleRemoteClickPrev,false)}if(p){this[t](p,"click",this.handleRemoteClickPlay,false)}if(e){this[t](e,"click",this.handleRemoteClickStop,false)}if(f){this[t](f,"click",this.handleRemoteClickNext,false)}if(s){this[t](s,"change",this.handleRemoteSelect,false)}};this.addRemoteNavigationBottom=function(w){var n=document.createElement("div");n.id="canvasXpressRemoteWindowBottomBar";n.style.position="absolute";n.style.marginLeft=w+"px";n.style.display="none";n.style.height="18px";return n};this.addRemoteNavigationLeftRight=function(d,w,h,m,q){var n=document.createElement("div");var i=document.createElement("img");n.style.height=(h+q)+"px";n.style.width=m+"px";n.style.top="0px";i.style.position="absolute";i.style.top=(h/2)+"px";i.style.left="1px";if(d=="l"){n.style.position="relative";n.id="canvasXpressRemoteWindowPrevBar";n.style.left="0px";n.style.display="none";i.src=this.imageDir+this.previousButton}else{n.style.position="absolute";n.id="canvasXpressRemoteWindowNextBar";n.style.left=(m+w)+"px";n.style.display="none";i.src=this.imageDir+this.nextButton}i.style.margin="auto";n.appendChild(i);return n};this.addRemoveNavigationLeftRightListeners=function(t){var p=document.getElementById("canvasXpressRemoteWindowPrevBar");var n=document.getElementById("canvasXpressRemoteWindowNextBar");if(p){this[t](p,"click",this.handleRemoteClickPrev,false)}if(n){this[t](n,"click",this.handleRemoteClickNext,false)}};this.updateRemoteNavigationWindow=function(){var c=document.getElementById(this.target);var x=18;var y=20;var l=document.getElementById("canvasXpressRemoteWindowPrevBar");var r=document.getElementById("canvasXpressRemoteWindowNextBar");var w=document.getElementById("canvasXpressRemoteWindow");var b=document.getElementById("canvasXpressRemoteWindowBuffer");if(l&&r&&w&&b){var il=l.childNodes[0];l.style.left="0px";l.style.height=(c.height+y)+"px";il.style.top=(c.height/2)+"px";var ir=r.childNodes[0];r.style.left=(c.width+x)+"px";r.style.height=(c.height+y)+"px";ir.style.top=(c.height/2)+"px";w.style.height=(y+c.height)+"px";w.style.width=((x*2)+c.width)+"px";b.style.height=c.height+"px";b.style.width=(c.width*2)+"px";b.style.left=x+"px";b.style.top=y+"px"}};this.addRemoteWindow=function(){var w=document.getElementById("wrapper-"+this.target);var c=document.getElementById(this.target);var p=w.parentNode;var x=18;var y=20;if(p.id&&!p.id.match(/canvasXpressRemoteWindow/)){var d=document.createElement("div");var t=this.addRemoteNavigationTop(x);var l=this.addRemoteNavigationLeftRight("l",c.width,c.height,x,y);var v=document.createElement("div");var r=this.addRemoteNavigationLeftRight("r",c.width,c.height,x,y);var b=this.addRemoteNavigationBottom(x);d.id="canvasXpressRemoteWindow";d.style.height=(y+c.height)+"px";d.style.width=((x*2)+c.width)+"px";d.style.position="relative";v.id="canvasXpressRemoteWindowBuffer";v.style.height=c.height+"px";v.style.width=(c.width*2)+"px";v.style.position="absolute";v.style.left=x+"px";v.style.top=y+"px";v.style.overflow="hidden";d.appendChild(t);d.appendChild(l);d.appendChild(v);d.appendChild(r);d.appendChild(b);p.insertBefore(d,w);v.appendChild(w.parentNode.appendChild(w));this.addRemoveNavigationTopListeners("addEvtListener");this.addRemoveNavigationLeftRightListeners("addEvtListener");this.requestRemoteData(true);this.initialRemoteDataRequest=true;if(this.remoteAutoPlay){this.remoteUpdating=true;this.remoteDirection="next";this.remoteStop=false;this.playRemoteData(t.lastChild)}}else{this.initialRemoteDataRequest=false}};this.hideNavigation=function(){var t=document.getElementById("canvasXpressRemoteWindowTopBar");var p=document.getElementById("canvasXpressRemoteWindowPrevBar");var n=document.getElementById("canvasXpressRemoteWindowNextBar");var b=document.getElementById("canvasXpressRemoteWindowBottomBar");if(t){t.style.display="none"}if(p){p.style.display="none"}if(n){n.style.display="none"}if(b){b.style.display="none"}};this.showNavigation=function(){var t=document.getElementById("canvasXpressRemoteWindowTopBar");var p=document.getElementById("canvasXpressRemoteWindowPrevBar");var n=document.getElementById("canvasXpressRemoteWindowNextBar");var b=document.getElementById("canvasXpressRemoteWindowBottomBar");if(t){t.style.display="block"}if(p){p.style.display="block"}if(n){n.style.display="block"}if(b){b.style.display="block"}};this.initializeRemote=function(){if(this.remoteService){this.addRemoteWindow()}};this.initializeRemote()};CanvasXpress.prototype.FunctionData=function(){this.implied=function(a){if(a=="neg"){return false}return/^(\d+\.\d+|\d+\.?|\.\d+)(e[-+]?\d+)?|\w+$/.test(a)};this.tokenize=function(f){var b;var a=[];var d=new String("");var c=/(\d+\.\d+|\d+\.?|\.\d+)(e[-+]?\d+)?|[xy]|[a-z]+|[-+*\/(),^]|<=?|>=?|==|!=|&&|\|\|/g;f=f.toLowerCase();f=f.replace(/\s/g,"");f=f.replace(/\+\+/g,"+").replace(/\+-/g,"-").replace(/-\+/g,"-").replace(/--/g,"+");f=f.replace(/^\+/,"").replace(/([(*\/&\|<>=])\+/g,"$1");f=f.replace(/^-/,"neg ").replace(/([(*\/&\|<>=])-/g,"$1neg ");f=f.replace(/\)(\(|\w)/g,")*$1");f=f.replace(/(\d)\(/g,"$1*(");while(b=c.exec(f)){if(this.implied(d)&&this.implied(b[0].toString())){a.push("*")}a.push(d=b[0])}return a};this.isValidEnd=function(a){return/^(\d+\.\d+|\d+\.?|\.\d+)(e[-+]?\d+)?|[)xye]|pi|rand$/.test(a)};this.toPostFx=function(d){var b=new String();var c=new String("");var a=new Array();var e=new Array();while(b=d.shift()){if(b=="("){a.push(b)}else{if(this.precedence[b]){while(a.length&&a[a.length-1]!="("&&this.precedence[a[a.length-1]]>=this.precedence[b]){e.push(a.pop())}if(b==","&&!this.isValidEnd(c)){e.push("Unexpected: "+c)}if(b!=","){a.push(b)}}else{if(b==")"){if(!this.isValidEnd(c)){e.push("Unexpected: "+c)}while(a.length&&a[a.length-1]!="("){e.push(a.pop())}if(a.length==0){e.push("Unmatched: )")}a.pop()}else{if(/^[-+]?(\d+\.?|\d*\.\d+)(e[-+]?\d+)?$/.test(b)){e.push(b)}else{e.push("Unknown: "+b)}}}}c=b}if(!this.isValidEnd(c)){e.push("Unexpected: "+c)}while(b=a.pop()){if(b=="("){e.push("Unmatched: (")}e.push(b)}return e};this.syntaxCheck=function(d){var a=new Number(0);var c=new String();for(var b=0;b<d.length;b++,a++){if(/^Un(matched|known|expected).*/.test(c=d[b])){return c}if(this.expects[c]){if(a<this.expects[c]){return"Invalid use of: "+c}a-=this.expects[c]}}return a==1?false:(d.length?"Unused arguments":"No function")};this.evaluate=function(e,b,f){var a=new Array();var d=new String();for(var c=0;c<e.length;c++){d=e[c];if(d=="x"){a.push(b)}else{if(d=="y"){a.push(f)}else{if(d=="pi"){a.push(Math.PI)}else{if(d=="e"){a.push(Math.E)}else{if(d=="rand"){a.push(Math.random())}else{if(this[this.alias[d]||d]){a.push(this[this.alias[d]||d](a.pop(),this[this.alias[d]||d].length>1?a.pop():0))}else{a.push(d)}}}}}}if(isNaN(a[a.length-1])){return Number.NaN}}return parseFloat(a.pop())};this.set2DPlot=function(j,g){var k={vars:[],smps:["X","Y"],data:[]};var f=this.setMinX?this.setMinX:(0-1);var b=this.setMaxX?this.setMaxX:(1-0);var e=this.setMinY?this.setMinY:(0-1);var a=this.setMaxY?this.setMaxY:(1-0);var p=(b-f)/this.functionIntervals;var o=(a-e)/this.functionIntervals;var c=1;if(g==1){var m=f;for(var h=0;h<this.functionIntervals;h++){var l=this.evaluate(j,m,0);if(isNaN(l)){l=""}m+=p;k.vars.push("v"+c);k.data.push([m,l]);c++}}else{var l=e;for(var h=0;h<this.functionIntervals;h++){var m=this.evaluate(j,0,l);if(isNaN(m)){m=""}l+=o;k.vars.push("v"+c);k.data.push([m,l]);c++}}return k};this.set3DPlot=function(k){var l={vars:[],smps:["X","Y","Z"],data:[]};var f=this.setMinX?this.setMinX:-Math.PI/2;var b=this.setMaxX?this.setMaxX:Math.PI/2;var e=this.setMinY?this.setMinY:-Math.PI/2;var a=this.setMaxY?this.setMaxY:Math.PI/2;var q=this.width<=180?20:this.width<=600?30:40;var c=1;for(var h=0;h<=q;h++){var o=e+(a-e)*h/q;for(var g=0;g<=q;g++){var p=f+(b-f)*g/q;var m=this.evaluate(k,p,o);if(!isFinite(m)){m=0}l.vars.push("v"+c);l.data.push([p,m,o]);c++}}return l};this.initializeFunctionData=function(){var e=this.toPostFx(this.tokenize(this.data.fx));var c=this.syntaxCheck(e);if(c){alert(c);return}var a=0;for(var b in e){if(e[b]=="x"){a|=1}else{if(e[b]=="y"){a|=2}}}var d;if(a==0){a=1}if(a==3){this.data.y=this.set3DPlot(e);this.graphType="Scatter3D";this.colorBy="Y"}else{this.data.y=this.set2DPlot(e,a);this.graphType="Scatter2D";this.lineType="spline"}this.scatterType="function"};this.initializeFunctionData()};CanvasXpress.prototype.initGraph=function(){this.draw=function(b,d,a,c){this.setUserEvents();this.initializeGraph(true,b,d,a,c)};this.isValidGraphType=function(a){switch(a){case"Bar":case"Line":case"Area":case"AreaLine":case"Dotplot":case"Heatmap":case"Stacked":case"StackedPercent":case"Boxplot":case"Correlation":case"Pie":if(this.data.y){return true}else{return false}case"BarLine":case"StackedLine":case"StackedPercentLine":if(this.data.y&&this.data.a&&this.data.a.xAxis&&this.data.a.xAxis2){return true}else{return false}case"Scatter2D":if(this.data.y&&this.data.y.smps&&this.data.y.smps.length>1){return true}else{return false}case"ScatterBubble2D":case"Scatter3D":if(this.data.y&&this.data.y.smps&&this.data.y.smps.length>2){return true}else{return false}case"Candlestick":if(this.data.market){return true}else{return false}case"Venn":if(this.data.venn){return true}else{return false}case"Network":if(this.data.nodes){return true}else{return false}case"Genome":if(this.data.tracks){return true}else{return false}}return false};this.setColorScheme=function(){switch(this.colorScheme){case"basic":this.colors=this.colors0;break;case"dark":this.colors=this.colors1;break;case"strong":this.colors=this.colors2;break;case"light":this.colors=this.colors3;break;case"pastel":this.colors=this.colors4;break;case"user":this.colors=this.colors;break}};this.reinitializeGraph=function(){if(this.graphType=="Candlestick"){this.isGraphTime=true;if(!this.isMarketSwitched){this.switchToMarketData();this.initAxes();this.summaryType="candle";this.initializeDataAttributes();this.isMarketSwitched=true}this.setMarketTechnicalData()}else{if(this.isExample&&this.isMarketSwitched){this.switchFromMarketData();this.isMarketSwitched=false;this.summaryType=this.data.y.data?"raw":"mean";this.initializeDataAttributes();this.isGraphTime=false;if(this.showVolume){this.layoutComb=false}}else{if(this.graphType.match(/Scatter/)&&this.allVsAll){this.setAllVsAll()}else{if(this.graphType.match(/Pie/)&&this.xAxis.length>1){this.setMultiplePies()}}}}};this.initializeGraph=function(m,a,l,g,b){var d=this;var h=5;var k=0;var e=[];var j=function(){for(var n=0;n<e.length;n++){if(!CanvasXpress.cacheImages.hasOwnProperty(e[n])){return false}}return true};if(this.graphType=="Network"){e=this.getNetworkImages()}else{if(this.graphType.match(/scatter/i)){for(var c=0;c<this.images.length;c++){if(!this.images[c].match(/^http:\/\//)){this.images[c]=this.imageDir+this.images[c]}e.push(this.images[c])}}}if(this.backgroundImage){if(!this.backgroundImage.match(/^http:\/\//)){this.backgroundImage=this.imageDir+this.backgroundImage}e.push(this.backgroundImage)}if(e.length>0&&!j()){for(var c=0;c<e.length;c++){if(!CanvasXpress.cacheImages.hasOwnProperty(e[c])){var f=new Image;f.onload=function(){CanvasXpress.cacheImages[this.src]=this;if(k<(h*e.length)){if(j()){d.renderGraph(m,a,l,g,b)}else{k++}}else{alert("Problem loading images")}};f.src=e[c]}}}else{this.renderGraph(m,a,l,g,b)}};this.renderGraph=function(g,d,a,c,f){if(this.initialRemoteDataRequest){return}this.setColorScheme();this.reinitializeGraph();if((!this.layoutComb||!this.layoutAdjust)&&!c){if(this.graphType!="Candlestick"||(this.graphType=="Candlestick"&&!this.showVolume)){this.initAxes(g)}}if(g){this.resizeCanvas(true,d,a)}else{this.resizeCanvas(false,d,a)}if(this.isVML){this.showShadow=false}if(this.isValidAnimation()&&this.showAnimation&&!this.isAnimation){this.createAnimation(this.animationType)}else{var e=this.layoutComb?true:false;switch(this.graphType){case"Bar":case"Line":case"Area":case"AreaLine":case"BarLine":case"Dotplot":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Candlestick":if(this.isBoxPlotCalc&&this.isGroupedData){this.groupSamples(this.getGroupingFactors(true))}this.oneDPlot();break;case"Boxplot":if(!this.isBoxPlotCalc&&this.isGroupedData){this.groupSamples(this.getGroupingFactors(true))}this.oneDPlot();break;case"Scatter2D":case"ScatterBubble2D":this.Scatter2D();break;case"Scatter3D":this.Scatter3D();break;case"Correlation":this.Correlation();break;case"Venn":this.Venn();break;case"Pie":this.Pie();break;case"Network":if(f){var b=this.calculateLayout;var e=this.randomNetwork;this.calculateLayout=false;this.randomNetwork=false;this.Network();this.calculateLayout=b;this.randomNetwork=e}else{this.Network()}break;case"Genome":this.Genome();break}this.resizeImage(e);this.drawCanvasBox();if(this.showCode){this.updateCodeDiv()}if(this.showDataTable){this.updateDataTable()}else{this.hideUnhideDataTable(true)}}};this.initializeGraph()};CanvasXpress.prototype.initAxes=function(b,a){this.getValidAxes=function(c){var d=[];if(this.graphType=="Scatter2D"){d.push("xAxis");d.push("yAxis")}else{if(this.graphType=="ScatterBubble2D"||this.graphType=="Scatter3D"){d.push("xAxis");d.push("yAxis");d.push("zAxis")}else{if(this.graphType.match(/Network|Genome|Correlation|Venn|Heatmap|Pie/)){if(c){d.push("xAxis")}else{return false}}else{if(this.graphType.match(/BarLine|AreaLine|StackedLine|StackedPercentLine/)||(this.graphType=="Candlestick"&&this.showVolume)){d.push("xAxis");d.push("xAxis2")}else{d.push("xAxis")}}}}return d};this.addRemoveSamplesInAxis=function(e,d,c){if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){if(c){return this.removeSamplesFromAxis(e,d)}else{return this.addSamplesToAxis(e,d)}}else{if(this.graphType=="Scatter3D"||this.graphType=="Pie"){return this.switchSampleInAxis(e,d)}}};this.addSamplesToAxis=function(e,d){if(this[d]){if(this.isArray(e)){for(var c=0;c<e.length;c++){this[d].push(e[c])}}else{this[d].push(e)}return false}else{return"Not a valid axis"}};this.removeSamplesFromAxis=function(g,f){if(this[f]){if(this[f].length>1){var d={};var c=[];if(this.isArray(g)){for(var e=0;e<g.length;e++){d[g[e]]=1}}else{d[g]=1}for(var e=0;e<this[f].length;e++){if(!d.hasOwnProperty(this[f][e])){c.push(this[f][e])}}this[f]=c;return false}else{return f+" cannot be null"}}else{return"Not a valid axis"}};this.switchSampleInAxis=function(d,c){if(this[c]){this[c][0]=d;return false}else{return"Not a valid axis"}};this.addRemoveVariablesInAxis=function(e,d,c){if(c){return this.removeVariablesFromAxis(e,d)}else{return this.addVariablesToAxis(e,d)}};this.addVariablesToAxis=function(e,d){if(!this.data.a){this.data.a={}}if(!this.data.a[d]){this.data.a[d]=[]}if(this.isArray(e)){for(var c=0;c<e.length;c++){this.data.a[d].push(e[c])}}else{this.data.a[d].push(e)}this.resetVariablesVisibleByAxis(d);return false};this.removeVariablesFromAxis=function(g,f){if(this.data.a&&this.data.a[f]){var d={};var c=[];if(this.isArray(g)){for(var e=0;e<g.length;e++){d[g[e]]=1}}else{d[g]=1}for(var e=0;e<this.data.a[f].length;e++){if(!d.hasOwnProperty(this.data.a[f][e])){c.push(this.data.a[f][e])}}this.data.a[f]=c}this.resetVariablesVisibleByAxis(f);return false};this.formatAxisValue=function(d,c){if(this[c+"TickFormat"]){if(this.graphType=="Candlestick"&&this.summaryType=="volume"){if(this.xAxis2TickFormat){return sprintf(this.xAxis2TickFormat,d)}else{return sprintf(this[c+"TickFormat"],d)}}else{return sprintf(this[c+"TickFormat"],d)}}else{return this.graphType=="Candlestick"&&this.summaryType=="volume"?sprintf("%."+this.xAxis2Decs+"f",d):sprintf("%."+this[c+"Decs"]+"f",d)}};this.getAxisRangeBySample=function(c){var g=[];if(this.isArray(c)){for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];for(var d=0;d<c.length;d++){g.push(this.getDataAtPos(f,d))}}}else{for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];g.push(this.getDataAtPos(f,c))}}return this.range(g)};this.getAxisIncrements=function(f,m,n,i){if(m-f<=Number.MIN_VALUE){return 0.1}if(i){return m==f?m*this.axisExtension/n:(m-f)/n}else{var k;var l=(m-f)*this.axisExtension;var d=m==f?f-(f*this.axisExtension):f-l;var g=m==f?m+(m*this.axisExtension):m+l;var h=g-d;var j=-Math.floor(Math.log(h/n)/Math.LN10);var e=Math.pow(10,-j);var c=((h/n)/e);if(c<1.5){k=e}else{if(c<2){k=e*2}else{if(c<2.5){k=e*2.5}else{if(c<5){k=e*5}else{if(c<7.5){k=e*7.5}else{k=e*10}}}}}if(f+(k*n)<m){return this.getAxisIncrements(f,m+k,n,i)}else{return k}}};this.getAxisMin=function(c,d){var e=d*Math.floor(c/d);return e<0&&this.minData>0?0:e};this.getAxisDecimals=function(c){var d=(c-parseInt(c)).toString().replace(/\./,"").length-1;return d};this.setAxis=function(c){var d=this.isGroupedData?this.data.w:this.data.y;if(this[c].length==0){if(c=="xAxis"){this[c].push(d.smps[this.smpIndices[0]])}else{if(c=="yAxis"){if(d.smps.length>1){this[c].push(d.smps[this.smpIndices[1]])}else{this[c].push(d.smps[this.smpIndices[0]])}}else{if(c=="zAxis"){if(d.smps.length>2){this[c].push(d.smps[this.smpIndices[2]])}else{if(d.smps.length>1){this[c].push(d.smps[this.smpIndices[1]])}else{this[c].push(d.smps[this.smpIndices[0]])}}}}}}else{if(this.graphType=="Scatter3D"&&this[c].length>1){this[c]=[this[c][0]]}}};this.setAxisValues=function(e){var z,p,m,n,o,x,k,f;var d={};var h=e+"MinorValues";var l=e+"Values";var v=e+"Ticks";var w=e+"TickFormat";var u=e+"Incr";var c=e+"Decs";var q=e+"Min";var g=e+"Transform";var t=e+"MaxStrLength";if(this[g]=="percentile"){this[c]=0;this[l]=[];this[h]=[];var y=[0,25,50,75,100];for(var s=0;s<y.length;s++){z=this.formatNumber(y[s]);if(d.hasOwnProperty(z)){k=true}else{d[z]=1}this[l].push(z)}for(var s=5;s<100;s+=5){this[h].push(s)}}else{if(this[l].length==0||b){if(b){this[l]=[];this[h]=[]}z=this[q];o=this[u]/this[v];for(var s=1;s<=this[v];s++){for(var r=1;r<this[v];r++){this[h].push(z+(o*r))}z+=this[u];if(this[c]==0&&z.toString().match(/\.5$/)){this[c]=1}if(this[w]){p=sprintf(this[w],z)}else{p=this.formatNumber(sprintf("%."+this[c]+"f",z))}if(d.hasOwnProperty(p)&&!this[w]){k=true}else{d[p]=1}this[l].push(p)}}else{m=this[l];this[l]=[];for(var s=0;s<m.length;s++){z=m[s];n=parseFloat(z);if(this[w]){p=sprintf(this[w],n)}else{p=this.formatNumber(sprintf("%."+this[c]+"f",n))}if(d.hasOwnProperty(p)&&!this[w]){k=true}else{d[p]=1}this[l].push(p)}}}if(k){this[c]++;this[l]=[];this[h]=[];this.setAxisValues(e)}else{f=this.getMaxText(this[l]);if(!this[t]){this[t]=f}else{this[t]=this.getMaxText([this[t],f])}}};this.setAxisAttributes=function(h,o,r,e,n){var q=e&&e.match(/log/)?true:false;var l=h+"Ticks";var d=h+"Incr";var g=h+"Exact";var c=h+"AbsMin";var k=h+"AbsMax";var i=h+"Min";var p=h+"Max";var m=h+"Range";var j=h+"Decs";var f=h+"Transform";this.setRangeData(o,r,q,n);if(e){if(e=="log2"){this.minData=Math.log(this.minData)/Math.LN2;this.maxData=Math.log(this.maxData)/Math.LN2}else{if(e=="log10"){this.minData=Math.log(this.minData)/Math.LN10;this.maxData=Math.log(this.maxData)/Math.LN10}else{if(e=="exp2"){this.minData=Math.pow(2,this.minData);this.maxData=Math.pow(2,this.maxData)}else{if(e=="exp10"){this.minData=Math.pow(10,this.minData);this.maxData=Math.pow(10,this.maxData)}else{if(e=="percentile"){this.minData=-12.5;this.maxData=112.5}}}}}}this[c]=this.setMin==null?this.minData:this[c];this[k]=this.setMax==null?this.maxData:this[k];this[d]=this.getAxisIncrements(this.minData,this.maxData,this[l],this[g]);this[j]=this.getAxisDecimals(this[d]);if(n){this[i]=0;if(this.graphType.match(/Percent/)){this[p]=100}else{this[p]=this[i]+(this[d]*this[l])}}else{if(this[g]||(e&&e=="percentile")){this[i]=this.minData;this[p]=this.maxData}else{this[i]=this.getAxisMin(this.minData,this[d]);this[p]=this[i]+(this[d]*this[l])}}this[m]=this[p]-this[i];this.setAxisValues(h)};this.setAxes=function(){if(this.graphType.match(/Correlation/)){var e=this.isGroupedData?this.data.w:this.data.y;this.setMin=null;this.setMax=null;if(this.correlationAnchorLegend){this.setAxisAttributes("xAxis")}if(!e.cor||e.cor.length==0){this.summarize("cor");this.setRangeData("cor")}if(!this.yAxisTitle){this.yAxisTitle="Correlation"}}else{if(this.graphType.match(/Scatter|Pie/)){var s=this.smpIndices;var o=["xAxis"];var c=["X"];this.setMin=null;this.setMax=null;if(this.graphType.match(/Scatter/)){o.push("yAxis");c.push("Y")}if(this.graphType.match(/ScatterBubble2D|Scatter3D/)){o.push("zAxis");c.push("Z")}if(this.graphType=="Scatter3D"){this.xAxisTicks=10;this.yAxisTicks=10;this.zAxisTicks=10}for(var j=0;j<o.length;j++){var k=o[j]+"Indices";var h="setMin"+c[j];var q="setMax"+c[j];this.setAxis(o[j]);this[k]=this.getSampleIndices(this[o[j]]);this.setSamplesVisible(this[k]);if(this[h]){this.setMin=this[h]}if(this[q]){this.setMax=this[q]}this.setAxisAttributes(o[j],false,false,this[o[j]+"Transform"]);this.setSamplesVisible(s)}if(!this.xAxisTitle){this.xAxisTitle=this.xAxis.length==1?this.xAxis[0]:" "}if(!this.yAxisTitle){this.yAxisTitle=this.yAxis.length==1?this.yAxis[0]:" "}if(!this.zAxisTitle){this.zAxisTitle=this.zAxis.length==1?this.zAxis[0]:" "}}else{if(this.graphType.match(/Genome/)){if(this.setMin==null||this.setMax==null){this.setRangeData("genome")}this.xAxisExact=true;this.xAxisTransform=false;this.xAxisMin=this.setMin!=null?this.setMin:this.minData;this.xAxisMax=this.setMax!=null?this.setMax:this.maxData;this.xAxisDecs=0;this.xAxisRange=this.xAxisMax-this.xAxisMin;this.xAxisTicks=this.ticks;this.xAxisIncr=this.xAxisRange/this.xAxisTicks;this.setAxisValues("xAxis")}else{var n=this.smpIndices;var d=this.varIndices;var g=this.grpIndices;var l=this.varIndices;var r=this.graphType=="Dotplot"&&this.isGroupedData?true:false;var f=this.graphType.match(/Percent/)?"percentile":false;var m=this.graphType.match(/Stacked/)||(this.graphType.match(/Area/)&&this.areaIsCumulative)?true:false;var p=this.graphType=="Candlestick"?"candle":f?f:false;if(this.graphType=="Heatmap"){this.graphOrientation="horizontal";if(this.varIndicesStart>-1||this.smpIndicesStart>-1){this.setAllVariablesVisible();this.setAllSamplesVisible()}}else{if(this.graphType=="StackedPercent"||this.graphType=="StackedPercentLine"){this.setMin=null;this.setMax=null;this.axisExact=true;this.xAxisExact=true}else{if(this.graphType=="Boxplot"&&!this.isGroupedData){if(!this.data.y.median){this.summarize("iqr")}}}}if(this.graphType.match(/BarLine|AreaLine|StackedLine|StackedPercentLine/)&&this.data.a){this.setVariablesVisible(this.getVariablesVisibleByAxis("xAxis"))}this.setAxisAttributes("xAxis",p,r,f,m);this["xAxisTitle"]=!this["xAxisTitle"]&&this.data.y.desc?this.data.y.desc[0]:"";if((this.graphType.match(/BarLine|AreaLine|StackedLine|StackedPercentLine/)&&this.data.a)||(this.graphType=="Candlestick"&&this.showVolume)){p=this.graphType=="Candlestick"?"volume":false;if(this.graphType.match(/BarLine|AreaLine|StackedLine|StackedPercentLine/)){this.setVariablesVisible(l);this.setVariablesVisible(this.getVariablesVisibleByAxis("xAxis2"))}var q=this.setMax!=null?this.setMax:null;var h=this.setMin!=null?this.setMin:null;this.setMax=this.setMax2!=null?this.setMax2:null;this.setMin=this.setMin2!=null?this.setMin2:null;this.setAxisAttributes("xAxis2",p,r);this["xAxis2Title"]=!this["xAxis2Title"]&&this.data.y.desc?this.data.y.desc[1]:"";this.setMax=q!=null?q:null;this.setMin=h!=null?h:null}this.setVariablesVisible(l);this.smpIndices=n;this.varIndices=d;this.grpIndices=g}}}};this.setScatterPointSize=function(){this.scatterPointSize=this.varIndices.length>50?this.sizes[1]:this.varIndices.length>20?this.sizes[2]:this.sizes[3];if(this.layoutComb){this.scatterPointSize=Math.ceil(this.scatterPointSize/this.layoutRows)}};this.setAxisUnits=function(e,g){var f=e+"Unit";var d=e+"Range";var c=g?g:e.substring(0,1);this[f]=this[c]/this[d]};this.setAxisFont=function(h,g){var f=this.graphType=="Venn"?16:12;if(this.autoScaleFont||!this.axisTickFont||!this.decorationFont||!this.axisTitleFont){var c,e,d;if(g>=600){c=12*this.tickScaleFontFactor;d=10*this.decorationScaleFontFactor;e=this.getFontPt(this.scaleTextToFont(h,f,g-2))*this.axisTitleScaleFontFactor}else{if(g>=400){c=10*this.tickScaleFontFactor;d=8*this.decorationScaleFontFactor;e=this.getFontPt(this.scaleTextToFont(h,f,g-2))*this.axisTitleScaleFontFactor}else{if(g>=200){c=8*this.tickScaleFontFactor;d=6*this.decorationScaleFontFactor;e=8*this.axisTitleScaleFontFactor}else{c=6*this.tickScaleFontFactor;d=4*this.decorationScaleFontFactor;e=6*this.axisTitleScaleFontFactor}}}this.axisTickFont=(parseInt(c))+"Pt "+this.fontName;this.decorationFont=(parseInt(d))+"Pt "+this.fontName;this.axisTitleFont=(parseInt(e))+"Pt "+this.fontName}else{this.axisTickFont=parseInt(this.axisTickFontSize)+"Pt "+this.fontName;this.decorationFont=parseInt(this.decorationFontSize)+"Pt "+this.fontName;this.axisTitleFont=parseInt(this.axisTitleFontSize)+"Pt "+this.fontName}};this.getAxisFont=function(c){if(c>=600){return 12}else{if(c>=400){return 10}else{if(c>=200){return 8}else{return 6}}}};this.getHeatmapShades=function(c){switch(c){case"green":return this.greens;case"red":return this.reds;case"blue":return this.blues;case"yellow":return this.yellows;case"cyan":return this.cyans;case"purple":return this.purples}};this.setHeatmapColors=function(c){this.setRGB();var k=c?c:this.maxData-this.minData;var d=this.heatmapType.split("-");var m=256/this.indicatorBins;var l=this.getHeatmapShades(d[0]);this.heatmapColors=[];this.heatmapBin=(k?k:1)/this.indicatorBins;if(this.indicatorCenter.match("rainbow")&&d.length>1){var e=["red","purple","blue","cyan","green","yellow"];if(this.indicatorCenter=="rainbow-green"){e.reverse()}var n=null;for(var h=0;h<e.length;h++){if(e[h]==d[0]){n=h}}if(n==null){alert("Dude! "+d[0]+" ain't a valid color ... This is not looking good ...");this.heatmapColors=this.blues;return}var f=[e[n]];n++;while(f.length<6){if(n>5){n=0}f.push(e[n]);n++}n=null;for(var h=0;h<f.length;h++){if(f[h]==d[1]){n=h}}if(n==null){alert("Dude! "+d[1]+" ain't a valid color ... This is not looking good ...");this.heatmapColors=this.blues;return}for(var h=0;h<n;h++){l=this.getHeatmapShades(f[h]);for(var g=0;g<m;g++){this.heatmapColors.push(l[g])}}}else{if(d.length>1){for(var h=0;h<m;h++){this.heatmapColors.push(l[h])}if(this.indicatorCenter=="black"){this.heatmapColors.push("rgb(0,0,0)")}else{this.heatmapColors.push("rgb(255,255,255)")}l=this.getHeatmapShades(d[1]);for(var h=m-1;h>=0;h--){this.heatmapColors.push(l[h])}}else{if(this.indicatorCenter=="black"){this.heatmapColors.push("rgb(0,0,0)")}else{this.heatmapColors.push("rgb(255,255,255)")}for(var h=m-1;h>=0;h--){this.heatmapColors.push(l[h]);this.heatmapColors.push(l[h])}}}};this.initializeAxis=function(){if(!this.graphType.match(/Venn|Network/)){if(!a){this.setAxes();this.setHeatmapColors()}}};this.initializeAxis()};CanvasXpress.prototype.Pie=function(){this.setVarPie=function(){var f=[];var a=this.smpIndices[0];if(this.varIndices.length>=this.maxPieSectors-1){var e=this;this.varIndices.sort(function(g,d){return e.data.y.data[d][a]-e.data.y.data[g][a]})}for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];f.push(this.getDataAtPos(c,a))}this.varPie=this.setPieData(f,true)};this.getPieLegendDimensions=function(){this.setLegendFont();var e=this.getFontPt(this.legendFont);var d=this.shortenText(this.maxVarNameStr,this.maxVarStringLen);var b=this.measureText(d,this.legendFont);if(b>this.width/2){this.legendFont=this.scaleTextToFont(b,e,this.width/2)}var c=e+this.measureText(d,this.legendFont)+(this.margin*5);var f=this.varIndices.length>this.maxPieSectors?this.maxPieSectors:this.varIndices.length;var a=(f*(e+this.margin))+(this.margin*3);return([c,a])};this.setPieXYDimensions=function(){var a=this.getPieLegendDimensions();if(this.showLegend){this.right=this.layoutComb?this.layoutRight:a[0]}this.x=this.layoutComb?this.layoutWidth:this.width-(this.marginLeft+this.left+this.right+this.marginRight);this.y=this.layoutComb?this.layoutHeight:this.height-(this.marginTop+this.top+this.bottom+this.marginBottom);this.setAxisFont("Pie",this.x)};this.drawPieDataPoints=function(){var b=Math.min(this.x,this.y);var c=(b-(b/5))/2;var a=this.marginLeft+this.offsetX+this.left+(this.x/2);var d=this.marginTop+this.offsetY+this.top+(this.y/2);this.setVarPie();this.drawPie(this.varPie,a,d,c,true)};this.drawPieLegend=function(){if(this.showLegend){var k=this.getPieLegendDimensions();var l=this.getFontPt(this.legendFont);var j=l/2;var b=this.layoutComb?(this.width-(this.marginRight+k[0]))+this.marginLeft+this.left:this.marginLeft+this.left+this.x+(this.margin*2)+j;var a=b+j+this.margin;var g=this.layoutComb?(this.layoutTop+(this.margin*3)+((this.height-(this.layoutTop+this.layoutBottom))/2))-(k[1]/2):this.marginTop+this.top+((this.y/2)-(k[1]/2))+this.margin;var f=g;for(var d=0;d<this.varPie.ids.length;d++){var h=this.varPie.ids[d];var c=d%this.colors.length;var e=h>-1?this.shortenText(this.data.y.vars[h],this.maxVarStringLen):"Other";this.drawShape("square",b,f,l,l,this.colors[c],this.foreground,"closed");this.drawText(e,a,f,this.legendFont,this.legendColor,"left","middle");f+=l+this.margin}if(this.legendBox){this.rectangle(b-(this.margin*2),g-(this.margin*2),k[0]-l,k[1]-l,false,this.legendBoxColor,"open")}}};this.drawPiePlot=function(){this.setPieXYDimensions();this.drawTitle();this.drawPieDataPoints();this.drawPieLegend()};this.initializePiePlot=function(){if(this.xAxisMin<0){alert("Dude you can't draw a pie chart with negative numbers!");return}if(this.layoutValid){this.drawLayoutCompartments(this.drawPiePlot)}else{this.drawPiePlot()}};this.initializePiePlot()};CanvasXpress.prototype.Venn=function(){this.setVennXYDimensions=function(){var a;this.vennMarginLeft=0;this.vennMarginTop=0;this.setLegendFont();this.setAxisFont("Venn",this.width);if(this.showLegend){this.bottom=this.margin+((this.getFontPt(this.legendFont)+this.margin)*this.vennGroups)}if(this.width<=this.height){this.x=this.width-(this.marginLeft+this.left+this.right+this.marginRight)}else{this.x=this.height-(this.marginTop+this.top+this.bottom+this.marginBottom)}this.y=this.vennGroups==4?this.x*0.8:this.vennGroups==3?this.x*0.95:this.vennGroups==2?this.x*0.65:this.x;if(this.autoAdjust){this.height=this.marginTop+this.top+this.y+this.bottom+this.marginBottom;this.width=this.marginLeft+this.left+this.x+this.right+this.marginRight}else{this.vennMarginTop=(this.height-(this.marginTop+this.top+this.y+this.bottom+this.marginBottom))/2;this.vennMarginLeft=(this.width-(this.marginLeft+this.left+this.x+this.right+this.marginRight))/2}if(this.x<400){var b=this.getFontPt(this.axisTickFont)-2;if(this.x<200){b-=1}this.axisTickFont=b+"Pt "+this.fontName}this.resizeCanvas()};this.drawVennBubble=function(b,c,a){if(this.vennGroups==4){if(this.isVML){a=a.replace("rgb","rgba");a=a.replace(")",",0.5)");this.drawShape("ellipse2",0,0,this.x/1.4,this.x/1.4,a,this.foreground,"closed")}else{this.drawShape("ellipse2",0,0,this.x/1.4,this.x/1.4,a,this.foreground,"closed");this.ctx.globalCompositeOperation="lighter"}}else{if(this.isVML){a=a.replace("rgb","rgba");a=a.replace(")",",0.5)");this.drawShape("circle",b,c,this.x/2,this.x/2,a,this.foreground,"closed")}else{this.drawShape("circle",b,c,this.x/2,this.x/2,a,this.foreground,"closed");this.ctx.globalCompositeOperation="lighter"}}};this.drawVennLayout=function(){var g,h,b,e;var a=["A","B","C","D"];this.ctx.clearRect(0,0,this.width,this.height);if(this.vennGroups==4){this.ctx.save();g=this.vennMarginLeft+this.marginLeft+this.margin+(this.x/4.94);h=this.vennMarginTop+this.marginTop+this.top+(this.x/13);this.ctx.translate(g,h);this.ctx.rotate(Math.PI/4);this.drawVennBubble(0,0,this.vennColors&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");g=this.x/22.4;h=this.x/-5.32;this.ctx.translate(g,h);this.drawVennBubble(0,0,this.vennColors&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[1]):"rgb(0,153,51)");g=this.x/1.84;h=this.x/-5.32;this.ctx.translate(g,h);this.ctx.rotate(Math.PI/2);g=this.x/-22.4;h=this.x/-5.32;this.ctx.translate(g,h);this.drawVennBubble(0,0,this.vennColors&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)");g=this.x/22.4;h=this.x/5.32;this.ctx.translate(g,h);this.drawVennBubble(0,0,this.vennColors&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[3]):"rgb(153,204,0)");this.ctx.restore();b=[11.2,3.05,1.46,1.08];e=[7,42,42,7]}else{if(this.vennGroups==3){this.ctx.save();g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/2);h=this.vennMarginTop+this.marginTop+this.top+(this.x/2.86);this.drawVennBubble(g,h,this.vennColors&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h+=(this.x/3.33);g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/3);this.drawVennBubble(g,h,this.vennColors&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[1]):"rgb(0,255,0)");g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/1.5);this.drawVennBubble(g,h,this.vennColors&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)");this.ctx.restore();b=[2,8.66,1.13];e=[20,2.3,2.3]}else{if(this.vennGroups==2){this.ctx.save();g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/3);h=this.vennMarginTop+this.marginTop+this.top+(this.x/2.67);this.drawVennBubble(g,h,this.vennColors&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(0,0,255)");g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/1.5);h=this.vennMarginTop+this.marginTop+this.top+(this.x/2.67);this.drawVennBubble(g,h,this.vennColors&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[1]):"rgb(255,0,0)");this.ctx.restore();b=[3,1.5];e=[16,16]}else{if(this.vennGroups==1){g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/2);h=this.vennMarginTop+this.marginTop+this.top+(this.x/2);this.drawShape("circle",g,h,this.x,this.x,this.vennColors&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)",this.foreground,"closed");b=[100];e=[100]}}}}for(var d=0;d<this.vennGroups;d++){var c=this.vennMarginLeft+this.marginLeft+this.left+(this.x/b[d]);var f=this.vennMarginTop+this.marginTop+this.top+(this.x/e[d]);this.drawText(a[d],c,f,this.axisTickFont,this.axisTickColor,"center","middle")}};this.drawVennDataPoints=function(){var a,e;if(this.vennGroups==4){a=[5.6,2.94,3.5,1.54,3.29,2,2.59,1.212,2,1.442,1.4,1.757,2.31,1.624,2];e=[2.94,7,3.92,7,1.89,4.06,2.66,2.94,1.54,1.89,3.92,1.729,1.729,2.66,2.03];this.y=(this.x*1.1)/1.4}else{if(this.vennGroups==3){a=[2,3.5,2.55,1.4,1.6,2,2];e=[3.6,1.54,2.07,1.54,2.07,1.54,1.83];this.y=this.x*0.95}else{if(this.vennGroups==2){a=[3.5,1.4,2];e=[2.66,2.66,2.66];this.y=this.x*0.65}else{if(this.vennGroups==1){a=[2];e=[2]}}}}for(var d=0;d<a.length;d++){var c=this.vennMarginLeft+this.marginLeft+this.left+(this.x/a[d]);var f=this.vennMarginTop+this.marginTop+this.top+(this.x/e[d]);var b=this.getFontPt(this.axisTickFont);var g=this.data.venn.data[this.vennCompartments[d]]?this.data.venn.data[this.vennCompartments[d]]:0;this.drawText(g,c,f,this.axisTickFont,this.axisTickColor,"center","middle");this.addArea(["circle",c,f,b],[d])}};this.drawVennLegend=function(){if(this.showLegend){var f=["A","B","C","D"];var h=this.getFontPt(this.legendFont);var e=this.vennMarginLeft+this.marginLeft+this.left;var c=e+(h*2);var g=this.vennMarginTop+this.marginTop+this.top+this.y+this.margin+(h/2);for(var d=0;d<this.vennGroups;d++){this.drawText(f[d]+": ",e,g,this.legendFont,this.legendColor,"left","middle");var b=this.data.venn.legend&&this.data.venn.legend[f[d]]?this.data.venn.legend[f[d]]:"N/A";var a=(this.measureText(b,this.legendFont)>this.x)?this.scaleTextToFont(b,h,this.x-this.margin):this.legendFont;this.drawText(b,c,g,a,this.legendColor,"left","middle");g+=this.margin+h}}};this.drawVennPlot=function(){this.setVennXYDimensions();this.drawTitle();this.showShadow=false;this.drawVennLayout();this.showShadow=this.tmpshowShadow;this.drawVennDataPoints();this.drawVennLegend()};this.initializeVennPlot=function(){this.transparency=null;this.tmpshowShadow=this.showShadow;this.background="rgb(255,255,255)";this.foreground="rgb(0,0,0)";this.drawVennPlot()};this.initializeVennPlot()};CanvasXpress.prototype.Correlation=function(){this.setCorrelationVarSmpLabelFont=function(b){var a=this.scaleTextToSize(b);a=this.correlationAxis=="samples"?a*this.smpLabelScaleFontFactor:a*this.varLabelScaleFontFactor;a=Math.min(a,this.maxTextSize);this.smpLabelFont=(a)+"Pt "+this.fontName;this.varLabelFont=(a)+"Pt "+this.fontName};this.getCorrelationLabelsHeight=function(){var a=0;if(this.correlationAxis=="samples"){if(this.maxSmpName>this.maxSmpStringLen){a+=this.measureText(this.maxSmpNameStr.substring(0,this.maxSmpStringLen),this.smpLabelFont)}else{a+=this.measureText(this.maxSmpNameStr,this.smpLabelFont)}}else{if(this.maxVarName>this.maxVarStringLen){a+=this.measureText(this.maxVarNameStr.substring(0,this.maxVarStringLen),this.varLabelFont)}else{a+=this.measureText(this.maxVarNameStr,this.varLabelFont)}}if(this.correlationAnchorLegend){a+=this.correlationAnchorLegendAlignWidth+this.margin}return a};this.setCorrelationXYDimensions=function(){this.corMarginLeft=0;this.corMarginTop=0;if(this.yAxisShow){this.setAxisFont(this.yAxisTitle,this.height);this.left=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}if(this.width<=this.height){this.x=this.width-(this.marginLeft+this.left+this.right+this.marginRight)}else{this.x=this.height-(this.marginTop+this.top+this.bottom+this.marginBottom)}var a=this.correlationAxis=="variables"?this.varIndices.length:this.isGroupedData?this.grpIndices.length:this.smpIndices.length;this.diamondSize=this.x/a;this.setCorrelationVarSmpLabelFont(a);this.y=this.x/2+(this.diamondSize/2);if(this.xAxisShow){this.top+=this.margin+this.getCorrelationLabelsHeight()+this.margin}if(this.autoAdjust){this.height=this.marginTop+this.top+this.y+this.bottom+this.marginBottom;this.width=this.marginLeft+this.left+this.x+this.right+this.marginRight}else{this.corMarginTop=(this.height-(this.marginTop+this.top+this.y+this.bottom+this.marginBottom))/2;this.corMarginLeft=(this.width-(this.marginLeft+this.left+this.x+this.right+this.marginRight))/2}this.resizeCanvas()};this.drawCorrelationLayout=function(){if(this.yAxisShow){this.drawText(this.yAxisTitle,this.corMarginLeft+this.marginLeft+this.left/2,this.marginTop+this.top+(this.y/2),this.axisTitleFont,this.axisTitleColor,"center","middle",-Math.PI/2)}if(this.xAxisShow){var c=this.corMarginLeft+this.marginLeft+this.left+(this.diamondSize/2);var o=(this.corMarginTop+this.marginTop+this.top)-this.margin;var n=(this.corMarginTop+this.marginTop+this.top)-(this.getCorrelationLabelsHeight()+this.margin);var m=n+this.correlationAnchorLegendAlignWidth;var k,f,h;var a=this.isGroupedData?this.data.w:this.data.y;var q=this.correlationAxis=="variables"?this.varIndices:this.isGroupedData?this.grpIndices:this.smpIndices;var l=this.correlationAxis=="samples"?this.maxSmpStringLen:this.maxVarStringLen;if(this.correlationAnchorLegend){h=this.correlationAxis=="samples"?a.data[0]:this.getDataForSmpGrpAtIndex(0);q.sort(function(r,i){return h[r]-h[i]});this.setAxisUnits("xAxis")}if(this.correlationAxis=="samples"){k=a.smps;f=this.smpLabelFont}else{k=a.vars;f=this.varLabelFont}for(var g=0;g<q.length;g++){var p=q[g];var j=this.shortenText(k[p],l);var e=this.correlationAxis=="samples"?this.getSmpColor(k[p]):this.getVarColor(k[p]);if(q.length<100){this.drawText(j,c,o,f,e,"left","middle",-Math.PI/2)}else{if(g%2){this.drawText(j,c,o,f,e,"left","middle",-Math.PI/2)}}if(this.correlationAnchorLegend){var d=h[p];var b=this.corMarginLeft+this.marginLeft+this.left+((d-this.xAxisMin)*this.xAxisUnit);this.drawLine("line",b,n-this.margin,b,n,e);this.drawLine("line",b,n,c,m,e)}c+=this.diamondSize}}c=(this.corMarginLeft+this.marginLeft+this.left+(this.x/3))-(this.heatmapColors.length*this.indicatorWidth);o=this.corMarginTop+this.marginTop+this.top+(this.y*7/8);if(this.correlationAnchorLegend){this.setRangeData("cor")}if(this.minData==null||this.maxData==null){this.setRangeData("cor")}this.drawColorIndicator(c,o,this.minData,this.maxData,2)};this.drawCorrelationDataPoints=function(){var c,o,b,n;var r=this.diamondSize/2;var h=this.isGroupedData?this.data.w.cor:this.data.y.cor;var q=this.correlationAxis=="variables"?this.varIndices:this.isGroupedData?this.grpIndices:this.smpIndices;c=this.corMarginLeft+this.marginLeft+this.left+r;o=this.corMarginTop+this.marginTop+this.top+r;for(var l=0;l<Math.ceil(q.length/2);l++){var p=q[l];b=c+(this.diamondSize*l);n=o;for(var g=l;g<q.length-l;g++){var m=q[g];var e=h[p][m];var d=this.getHeatmapColor(this.minData,this.maxData,e);if(isNaN(e)){this.addArea(this.drawShape("diamond",b,n,this.diamondSize,this.diamondSize,this.missingDataColor,this.missingDataColor,"closed"),[p,m])}else{this.addArea(this.drawShape("diamond",b,n,this.diamondSize,this.diamondSize,d,d,"closed"),[p,m])}b+=r;n+=r}n-=this.diamondSize;for(var f=g-2;f>=l;f--){var a=q[(q.length-f)-1];var e=h[a][m];var d=this.getHeatmapColor(this.minData,this.maxData,e);if(isNaN(e)){this.addArea(this.drawShape("diamond",b,n,this.diamondSize,this.diamondSize,this.missingDataColor,this.missingDataColor,"closed"),[a,m])}else{this.addArea(this.drawShape("diamond",b,n,this.diamondSize,this.diamondSize,d,d,"closed"),[a,m])}b+=r;n-=r}}this.drawLine("line",this.corMarginLeft+this.marginLeft+this.left,this.corMarginTop+this.marginTop+this.top+r,this.corMarginLeft+this.marginLeft+this.left+(this.x/2),this.corMarginTop+this.marginTop+this.top+this.y,this.foreground,false,"butt");this.drawLine("line",this.corMarginLeft+this.marginLeft+this.left+this.x,this.corMarginTop+this.marginTop+this.top+r,this.corMarginLeft+this.marginLeft+this.left+(this.x/2),this.corMarginTop+this.marginTop+this.top+this.y,this.foreground,false,"butt");c=this.corMarginLeft+this.marginLeft+this.left+r;o=this.corMarginTop+this.marginTop+this.top;b=c+(this.x/2);n=(this.corMarginTop+this.marginTop+this.top+this.y)-r;for(var l=0;l<q.length;l++){this.drawLine("line",c,o,b,n,this.foreground,false,"butt");c+=this.diamondSize;b+=r;n-=r}c=(this.corMarginLeft+this.marginLeft+this.left+this.x)-r;o=this.corMarginTop+this.marginTop+this.top;b=(this.corMarginLeft+this.marginLeft+this.left+(this.x/2))-r;n=(this.corMarginTop+this.marginTop+this.top+this.y)-r;for(var l=0;l<q.length;l++){this.drawLine("line",c,o,b,n,this.foreground,false,"butt");c-=this.diamondSize;b-=r;n-=r}};this.drawCorrelationPlot=function(){this.setCorrelationXYDimensions();this.drawCorrelationLayout();this.drawTitle();this.drawCorrelationDataPoints()};this.initializeCorrelationPlot=function(){this.drawCorrelationPlot()};this.initializeCorrelationPlot()};CanvasXpress.prototype.Scatter2D=function(){this.get2DYAxisWidth=function(){if(this.allVsAll){return this.yAxisShow?this.measureText(this.yAxisMaxStrLength,this.axisTickFont)+(this.margin*3):this.margin}else{return this.yAxisShow?this.getFontPt(this.axisTitleFont)+this.measureText(this.yAxisMaxStrLength,this.axisTickFont)+(this.margin*5):this.margin}};this.get2DXAxisHeight=function(){if(this.allVsAll){return this.xAxisShow?this.getFontPt(this.axisTitleFont)+(this.margin*5):this.margin}else{return this.xAxisShow?this.getFontPt(this.axisTickFont)+this.getFontPt(this.axisTitleFont)+(this.margin*5):this.margin}};this.set2DType=function(){if(this.graphType=="ScatterBubble2D"&&this.xAxisIndices.length>1&&this.xAxisIndices.length==this.yAxisIndices.length&&this.xAxisIndices.length==this.zAxisIndices.length){this.type2D="XYZ"}else{if(this.xAxisIndices.length>1&&this.xAxisIndices.length==this.yAxisIndices.length){this.type2D="XY"}else{if(this.xAxisIndices.length>this.yAxisIndices.length){this.type2D="X"}else{this.type2D="Y"}}}};this.set2DText=function(){var b=this.xAxisTitle.length>this.yAxisTitle.length?this.xAxisTitle:this.yAxisTitle;var a=this.layoutComb?Math.min(this.layoutWidth,this.layoutHeight):Math.min(this.width,this.height);this.setAxisFont(b,a)};this.setDecorationsLegendPositions=function(){if(this.showDecorations){this.setDecorationLegendDimension();if(this.showLegend){if(this.legendPosition=="bottom"){this.decorationsPosition="right"}else{this.decorationsPosition="bottom"}}}};this.set2DXYDimensions=function(){this.setDecorationsLegendPositions();this.setLegendDimensions();this.right=0;if(this.showLegend||this.showIndicators){this.right=this.legendWidth}if(this.showDecorations&&this.decorationsPosition=="right"){this.right+=this.legendDecorationWidth+(this.margin*2)}if(this.graphType=="ScatterBubble2D"&&this.zAxisShow){this.right+=this.getFontPt(this.axisTitleFont)+this.margin}else{this.right+=this.margin}this.left=this.get2DYAxisWidth();this.bottom=this.get2DXAxisHeight();if(this.showLegend||this.showIndicators){this.bottom+=this.legendHeight}if(this.showDecorations&&this.decorationsPosition=="bottom"){this.bottom+=this.legendDecorationHeight+(this.margin*2)}this.x=this.layoutComb?this.layoutWidth-(this.left+this.right):this.width-(this.marginLeft+this.left+this.right+this.marginRight);this.y=this.layoutComb?this.layoutHeight-(this.top+this.bottom):this.height-(this.marginTop+this.top+this.bottom+this.marginBottom);this.setScatterPointSize();this.setAxisUnits("xAxis");this.setAxisUnits("yAxis")};this.set2DWireFrame=function(){var d,f,b,e,a,g;d=this.marginLeft+this.offsetX+this.left;b=d+this.x;a=this.yAxisTickStyle=="dotted"?"dottedLine":"line";if(this.yAxisMinorTicks){for(var c=0;c<this.yAxisMinorValues.length;c++){g=parseFloat(this.yAxisMinorValues[c]);f=(this.marginTop+this.offsetY+this.top+this.y)-((g-this.yAxisMin)*this.yAxisUnit);this.drawLine(a,d,f,b,f,this.yAxisTickColor,this.outlineWidth/3,"butt")}}for(var c=0;c<this.yAxisValues.length;c++){g=parseFloat(this.yAxisValues[c]);f=(this.marginTop+this.offsetY+this.top+this.y)-((g-this.yAxisMin)*this.yAxisUnit);this.drawLine(a,d,f,b,f,this.yAxisTickColor,false,"butt")}f=this.marginTop+this.offsetY+this.top;e=f+this.y;a=this.xAxisTickStyle=="dotted"?"dottedLine":"line";if(this.xAxisMinorTicks){for(var c=0;c<this.xAxisMinorValues.length;c++){g=parseFloat(this.xAxisMinorValues[c]);d=(this.marginLeft+this.offsetX+this.left)+((g-this.xAxisMin)*this.xAxisUnit);this.drawLine(a,d,f,d,e,this.xAxisTickColor,this.outlineWidth/3,"butt")}}for(var c=0;c<this.xAxisValues.length;c++){g=parseFloat(this.xAxisValues[c]);d=(this.marginLeft+this.offsetX+this.left)+((g-this.xAxisMin)*this.xAxisUnit);this.drawLine(a,d,f,d,e,this.xAxisTickColor,false,"butt")}};this.set2DLayout=function(){var b=this.marginLeft+this.offsetX+this.margin+(this.getFontPt(this.axisTitleFont)/2);var c=this.marginTop+this.offsetY+this.top+(this.y/2);if(this.yAxisShow&&!this.allVsAll){this.drawText(this.yAxisTitle,b,c,this.axisTitleFont,this.axisTitleColor,"center","middle",-Math.PI/2)}b=this.marginLeft+this.offsetX+this.left-this.margin;for(var a=0;a<this.yAxisValues.length-1;a++){var e=parseFloat(this.yAxisValues[a]);var d=this.yAxisTransform&&!this.yAxisTransformTicks?this.formatAxisValue(this.transformValue(this.yAxisTransform,e,true),"yAxis"):this.formatAxisValue(e,"yAxis");c=(this.marginTop+this.offsetY+this.top+this.y)-((e-this.yAxisMin)*this.yAxisUnit);if(this.yAxisShow){this.drawText(d,b,c,this.axisTickFont,this.axisTickColor,"right","middle")}}b=this.marginLeft+this.offsetX+this.left+(this.x/2);c=this.marginTop+this.offsetY+this.top+this.y+this.margin+this.margin+this.getFontPt(this.axisTickFont)+this.margin+this.margin+(this.getFontPt(this.axisTitleFont)/2);if(this.xAxisShow&&!this.allVsAll){this.drawText(this.xAxisTitle,b,c,this.axisTitleFont,this.axisTitleColor,"center","middle")}c=this.marginTop+this.offsetY+this.top+this.y+this.margin+this.margin+(this.getFontPt(this.axisTickFont)/2);for(var a=0;a<this.xAxisValues.length-1;a++){var e=parseFloat(this.xAxisValues[a]);var d=this.xAxisTransform&&!this.xAxisTransformTicks?this.formatAxisValue(this.transformValue(this.xAxisTransform,e,true),"xAxis"):this.formatAxisValue(e,"xAxis");b=(this.marginLeft+this.offsetX+this.left)+((e-this.xAxisMin)*this.xAxisUnit);if(this.xAxisShow){this.drawText(d,b,c,this.axisTickFont,this.axisTickColor,"center","middle")}}if(this.graphType=="ScatterBubble2D"){if(this.zAxisShow){b=this.marginLeft+this.offsetX+this.left+this.x+this.margin;c=this.marginTop+this.offsetY+this.top+(this.y/2);this.drawText(this.zAxisTitle,b,c,this.axisTitleFont,this.axisTitleColor,"center","bottom",Math.PI/2)}}this.rectangle(this.marginLeft+this.offsetX+this.left,this.marginTop+this.offsetY+this.top,this.x,this.y,false,this.foreground,"open")};this.draw2DDataPoints=function(){var G,e,D,c;var q,I,H;var w,b,a;var F,h,f;var d=[];var v=[];if(this.type2D=="XYZ"){var t=this.xAxisIndices[this.xAxisCurrent];var J=this.yAxisIndices[this.yAxisCurrent];var l=this.zAxisIndices[this.zAxisCurrent];var L=t+":"+J;if(this.xAxisTransform=="percentile"){q=this.getAxisRangeBySample(this.xAxisIndices);H=q[0];I=q[1]}if(this.yAxisTransform=="percentile"){w=this.getAxisRangeBySample(this.yAxisIndices);a=w[0];b=w[1]}F=this.getAxisRangeBySample(this.zAxisIndices);f=F[0];h=F[1];for(var A=0;A<this.varIndices.length;A++){var E=this.varIndices[A];var o=this.getDataAtPos(E,t,false,this.xAxisTransform,H,I);var n=this.getDataAtPos(E,J,false,this.yAxisTransform,a,b);var m=this.getDataAtPos(E,l,false,"percentile",f,h);var s=this.sizeBy?this.dataSizes[A]:this.sizes[Math.floor(m/10)+1];var k=this.colorBy?this.dataColors[A]:this.colors[0];var u=this.shapeBy?this.dataShapes[A]:this.shapes[0];var K=this.scatterType&&this.scatterType.match(/image/i)?this.images[A]:false;var C=K?"image":u;G=(this.marginLeft+this.offsetX+this.left)+((o-this.xAxisMin)*this.xAxisUnit);e=(this.marginTop+this.offsetY+this.top+this.y)-((n-this.yAxisMin)*this.yAxisUnit);if(this.isVisibleSelectedDataPoint(E,L)){if(!this.scatterType||this.scatterType!="function"){this.drawSelectedBackground(E,L,u,G,e,s,s,false,true);this.addArea(this.drawShape(C,G,e,s,s,k,this.foreground,"closed",false,false,true,false,false,false,K),[E,t,J,l])}if(this.scatterType&&this.scatterType.match(/line|functio/)&&A<this.varIndices.length-1&&this.isVisibleSelectedDataPoint(this.varIndices[A+1],L)){E=this.varIndices[A+1];o=this.getDataAtPos(E,t,false,this.xAxisTransform,H,I);n=this.getDataAtPos(E,J,false,this.yAxisTransform,a,b);D=(this.marginLeft+this.offsetX+this.left)+((o-this.xAxisMin)*this.xAxisUnit);c=(this.marginTop+this.offsetY+this.top+this.y)-((n-this.yAxisMin)*this.yAxisUnit);if(this.lineType=="spline"){d.push(G);v.push(e)}else{this.drawLine("line",G,e,D,c,this.colors[0])}}}}if(this.lineType=="spline"){d.push(D);v.push(c);this.drawLine("spline",d,v,false,false,this.colors[0])}}else{if(this.type2D=="XY"){for(var B=0;B<this.xAxisIndices.length;B++){var k=B%this.colors.length;var t=this.xAxisIndices[B];var J=this.yAxisIndices[B];var l;var L=t+":"+J;if(this.xAxisTransform=="percentile"){q=this.getAxisRangeBySample(t);H=q[0];I=q[1]}if(this.yAxisTransform=="percentile"){w=this.getAxisRangeBySample(J);a=w[0];b=w[1]}if(this.graphType=="ScatterBubble2D"&&!this.sizeBy){if(this.zAxisIndices[this.zAxisCurrent]){l=this.zAxisIndices[this.zAxisCurrent];F=this.getAxisRangeBySample(l);f=F[0];h=F[1]}}for(var A=0;A<this.varIndices.length;A++){var E=this.varIndices[A];var o=this.getDataAtPos(E,t,false,this.xAxisTransform,H,I);var n=this.getDataAtPos(E,J,false,this.yAxisTransform,a,b);var m;var u=this.shapeBy?this.dataShapes[A]:this.shapes[0];var s=this.scatterPointSize;var K=this.scatterType&&this.scatterType.match(/image/i)?this.images[A]:false;var C=K?"image":u;if(this.sizeBy){s=this.dataSizes[A]}else{if(this.graphType=="ScatterBubble2D"){if(this.zAxisIndices[B]){m=this.getDataAtPos(E,l,false,"percentile",f,h);s=this.sizes[Math.floor(m/10)+1]}}}G=(this.marginLeft+this.offsetX+this.left)+((o-this.xAxisMin)*this.xAxisUnit);e=(this.marginTop+this.offsetY+this.top+this.y)-((n-this.yAxisMin)*this.yAxisUnit);if(this.isHistogram){c=(this.marginTop+this.offsetY+this.top+this.y)-e;if(this.isVisibleSelectedDataPoint(E,L)){this.drawSelectedBackground(E,L,"rectangle",G-this.histogramBarWidth,e-this.histogramBarWidth,this.histogramBarWidth*2,c,false,true);this.addArea(this.rectangle(G-this.histogramBarWidth,e,this.histogramBarWidth*2,c,this.colors[k],false,"closed",false,false,true),[E,t,J])}}else{if(this.isVisibleSelectedDataPoint(E,L)){if(!this.scatterType||this.scatterType!="function"){this.drawSelectedBackground(E,L,u,G,e,s,s,false,true);if(this.graphType=="ScatterBubble2D"){if(this.colorBy){this.addArea(this.drawShape(C,G,e,s,s,this.dataColors[A],this.colors[k],"closed",false,false,true,false,false,false,K),[E,t,J,l])}else{this.addArea(this.drawShape(C,G,e,s,s,this.colors[k],this.foreground,"closed",false,false,true,false,false,false,K),[E,t,J,l])}}else{if(this.colorBy){this.addArea(this.drawShape(C,G,e,s,s,this.dataColors[A],this.colors[k],"closed",false,false,true,false,false,false,K),[E,t,J])}else{this.addArea(this.drawShape(C,G,e,s,s,this.colors[k],this.foreground,"closed",false,false,true,false,false,false,K),[E,t,J])}}}if(this.scatterType&&this.scatterType.match(/line|functio/)&&A<this.varIndices.length-1&&this.isVisibleSelectedDataPoint(this.varIndices[A+1],L)){E=this.varIndices[A+1];o=this.getDataAtPos(E,t,false,this.xAxisTransform,H,I);n=this.getDataAtPos(E,J,false,this.yAxisTransform,a,b);D=(this.marginLeft+this.offsetX+this.left)+((o-this.xAxisMin)*this.xAxisUnit);c=(this.marginTop+this.offsetY+this.top+this.y)-((n-this.yAxisMin)*this.yAxisUnit);if(this.lineType=="spline"){d.push(G);v.push(e)}else{this.drawLine("line",G,e,D,c,this.colors[B])}}}}}if(this.lineType=="spline"){d.push(D);v.push(c);this.drawLine("spline",d,v,false,false,this.colors[B])}}}else{if(this.type2D=="X"){var r=this.yAxisIndices[this.yAxisCurrent];if(this.yAxisTransform=="percentile"){w=this.getAxisRangeBySample(r);a=w[0];b=w[1]}var g;if(this.graphType=="ScatterBubble2D"&&!this.sizeBy){if(this.zAxisIndices[this.zAxisCurrent]){g=this.zAxisIndices[this.zAxisCurrent];F=this.getAxisRangeBySample(g);f=F[0];h=F[1]}}for(var B=0;B<this.xAxisIndices.length;B++){var k=B%this.colors.length;var p=this.xAxisIndices[B];var L=p+":"+r;if(this.xAxisTransform=="percentile"){q=this.getAxisRangeBySample(p);H=q[0];I=q[1]}for(var A=0;A<this.varIndices.length;A++){var E=this.varIndices[A];var o=this.getDataAtPos(E,p,false,this.xAxisTransform,H,I);var n=this.getDataAtPos(E,r,false,this.yAxisTransform,a,b);var m;var s=this.scatterPointSize;var u=this.shapeBy?this.dataShapes[A]:this.shapes[0];var K=this.scatterType&&this.scatterType.match(/image/i)?this.images[A]:false;var C=K?"image":u;if(this.sizeBy){s=this.dataSizes[A]}else{if(this.graphType=="ScatterBubble2D"){if(this.zAxisIndices[this.zAxisCurrent]){m=this.getDataAtPos(E,g,false,"percentile",f,h);s=this.sizes[Math.floor(m/10)+1]}}}G=(this.marginLeft+this.offsetX+this.left)+((o-this.xAxisMin)*this.xAxisUnit);e=(this.marginTop+this.offsetY+this.top+this.y)-((n-this.yAxisMin)*this.yAxisUnit);if(this.isHistogram){c=(this.marginTop+this.offsetY+this.top+this.y)-e;if(this.isVisibleSelectedDataPoint(E,L)){this.drawSelectedBackground(E,L,"rectangle",G-this.histogramBarWidth,e-this.histogramBarWidth,this.histogramBarWidth*2,c,false,true);this.addArea(this.rectangle(G-this.histogramBarWidth,e,this.histogramBarWidth*2,c,this.colors[k],false,"closed",false,false,true),[E,p,r])}}else{if(this.isVisibleSelectedDataPoint(E,L)){if(!this.scatterType||this.scatterType!="function"){this.drawSelectedBackground(E,L,u,G,e,s,s,false,true);if(this.graphType=="ScatterBubble2D"){if(this.colorBy){this.addArea(this.drawShape(C,G,e,s,s,this.dataColors[A],this.colors[k],"closed",false,false,true,false,false,false,K),[E,p,r,g])}else{this.addArea(this.drawShape(C,G,e,s,s,this.colors[k],this.foreground,"closed",false,false,true,false,false,false,K),[E,p,r,g])}}else{if(this.colorBy){this.addArea(this.drawShape(C,G,e,s,s,this.dataColors[A],this.colors[k],"closed",false,false,true,false,false,false,K),[E,p,r])}else{this.addArea(this.drawShape(C,G,e,s,s,this.colors[k],this.foreground,"closed",false,false,true,false,false,false,K),[E,p,r])}}}if(this.scatterType&&this.scatterType.match(/line|functio/)&&A<this.varIndices.length-1&&this.isVisibleSelectedDataPoint(this.varIndices[A+1],L)){E=this.varIndices[A+1];o=this.getDataAtPos(E,p,false,this.xAxisTransform,H,I);n=this.getDataAtPos(E,r,false,this.yAxisTransform,a,b);D=(this.marginLeft+this.offsetX+this.left)+((o-this.xAxisMin)*this.xAxisUnit);c=(this.marginTop+this.offsetY+this.top+this.y)-((n-this.yAxisMin)*this.yAxisUnit);if(this.lineType=="spline"){d.push(G);v.push(e)}else{this.drawLine("line",G,e,D,c,this.colors[B])}}}}}if(this.lineType=="spline"){d.push(D);v.push(c);this.drawLine("spline",d,v,false,false,this.colors[B])}}}else{var r=this.xAxisIndices[this.xAxisCurrent];if(this.xAxisTransform=="percentile"){q=this.getAxisRangeBySample(r);H=q[0];I=q[1]}var g;if(this.graphType=="ScatterBubble2D"&&!this.sizeBy){if(this.zAxisIndices[this.zAxisCurrent]){g=this.zAxisIndices[this.zAxisCurrent];F=this.getAxisRangeBySample(g);f=F[0];h=F[1]}}for(var B=0;B<this.yAxisIndices.length;B++){var k=this.colors[B%this.colors.length];var p=this.yAxisIndices[B];var L=r+":"+p;if(this.yAxisTransform=="percentile"){w=this.getAxisRangeBySample(p);a=w[0];b=w[1]}for(var A=0;A<this.varIndices.length;A++){var E=this.varIndices[A];var o=this.getDataAtPos(E,r,false,this.xAxisTransform,H,I);var n=this.getDataAtPos(E,p,false,this.yAxisTransform,a,b);var m;var u=this.shapeBy?this.dataShapes[A]:this.shapes[0];var s=this.scatterPointSize;var K=this.scatterType&&this.scatterType.match(/image/i)?this.images[A]:false;var C=K?"image":u;if(this.colorBy){k=this.dataColors[A]}if(this.sizeBy){s=this.dataSizes[A]}else{if(this.graphType=="ScatterBubble2D"){if(this.zAxisIndices[this.yAxisCurrent]){m=this.getDataAtPos(E,g,false,"percentile",f,h);s=this.sizes[Math.floor(m/10)+1]}}}G=(this.marginLeft+this.offsetX+this.left)+((o-this.xAxisMin)*this.xAxisUnit);e=(this.marginTop+this.offsetY+this.top+this.y)-((n-this.yAxisMin)*this.yAxisUnit);if(this.isHistogram){c=(this.marginTop+this.offsetY+this.top+this.y)-e;if(this.isVisibleSelectedDataPoint(E,L)){this.drawSelectedBackground(E,L,"rectangle",G-this.histogramBarWidth,e-this.histogramBarWidth,this.histogramBarWidth*2,c,false,true);this.addArea(this.rectangle(G-this.histogramBarWidth,e,this.histogramBarWidth*2,c,k,false,"closed",false,false,true),[E,r,p])}}else{if(this.isVisibleSelectedDataPoint(E,L)){if(!this.scatterType||this.scatterType!="function"){this.drawSelectedBackground(E,L,u,G,e,s,s,false,true);if(this.graphType=="ScatterBubble2D"){this.addArea(this.drawShape(C,G,e,s,s,k,this.foreground,"closed",false,false,true,false,false,false,K),[E,r,p,g])}else{this.addArea(this.drawShape(C,G,e,s,s,k,this.foreground,"closed",false,false,true,false,false,false,K),[E,r,p])}}if(this.scatterType&&this.scatterType.match(/line|functio/)&&A<this.varIndices.length-1&&this.isVisibleSelectedDataPoint(this.varIndices[A+1],L)){E=this.varIndices[A+1];o=this.getDataAtPos(E,r,false,this.xAxisTransform,H,I);n=this.getDataAtPos(E,p,false,this.yAxisTransform,a,b);D=(this.marginLeft+this.offsetX+this.left)+((o-this.xAxisMin)*this.xAxisUnit);c=(this.marginTop+this.offsetY+this.top+this.y)-((n-this.yAxisMin)*this.yAxisUnit);if(this.lineType=="spline"){d.push(G);v.push(e)}else{this.drawLine("line",G,e,D,c,this.colors[B])}}}}}if(this.lineType=="spline"){d.push(D);v.push(c);this.drawLine("spline",d,v,false,false,this.colors[B])}}}}}};this.draw2DLegend=function(){if(this.showLegend){this.drawScatterLegend()}if(this.showDecorations){this.drawDecorationLegend()}};this.set2DprivateParams=function(){this.set2DType();this.set2DText()};this.draw2DPlot=function(){if(this.xAxis&&this.yAxis){this.setDataColorShapeSize()}this.set2DprivateParams();this.set2DXYDimensions();if(this.xAxis&&this.yAxis){this.drawPlotWindow();this.set2DWireFrame();this.draw2DDataPoints();this.maskPlotArea();this.set2DLayout();this.drawTitle();this.drawDecorationData();this.draw2DLegend()}};this.initializeScatter2D=function(){if(this.layoutValid&&this.allVsAll){this.drawLayoutCompartments(this.draw2DPlot)}else{if(!this.allVsAll){this.unsetAllVsAll()}this.draw2DPlot()}};this.initializeScatter2D()};CanvasXpress.prototype.Scatter3D=function(){this.set3DText=function(){this.setAxisFont(false,this.x)};this.equalizeMargins=function(){var a=Math.max(this.marginLeft,Math.max(this.marginRight,Math.max(this.marginTop,this.marginBottom)));this.marginLeft=a;this.marginRight=a;this.marginTop=a;this.marginBottom=a};this.set3DXYDimensions=function(){this.equalizeMargins();if(this.height<this.width){this.height=this.width}this.x=this.width-(this.marginTop+this.top);this.y=this.height-(this.marginTop+this.top);this.left=this.top;if(this.showLegend||this.showIndicators){this.setLegendDimensions();var a=Math.max(this.legendWidth,this.legendHeight);this.x-=a;this.y-=a;this.width=this.x+this.legendWidth+this.marginLeft+this.marginRight;this.height=this.y+this.legendHeight+this.marginTop+this.marginBottom}this.resizeCanvas();this.setScatterPointSize()};this.draw3DLayout=function(h,a,n,j,b,o,f,c){var e,q,d,p,m;var g=this.marginLeft+this.offsetX+this.left;var r=this.marginTop+this.offsetY+this.top;for(var k=0;k<h.length;k++){m=this.get3DTransfrom(h[k],a[k],n[k]);e=m[0]+g;q=m[1]+r;m=this.get3DTransfrom(j[k],b[k],o[k]);d=m[0]+g;p=m[1]+r;if(c=="dotted"){this.drawLine("dottedLine",e,q,d,p,f[k],false,"butt")}else{this.drawLine("line",e,q,d,p,f[k],false,"butt")}}};this.draw3DBar=function(q,o,n,v,Q,S){var I=this.marginLeft+this.offsetX+this.left;var E=this.marginTop+this.offsetY+this.top;var k=I+(this.x/2);var g=E+(this.y/2);var M=v/2;var N=[[[q-v,o,n-v],[q+v,o,n-v],[q+v,M,n-v],[q-v,M,n-v]],[[q+v,o,n-v],[q+v,o,n+v],[q+v,M,n+v],[q+v,M,n-v]],[[q-v,o,n+v],[q+v,o,n+v],[q+v,M,n+v],[q-v,M,n+v]],[[q-v,o,n-v],[q-v,o,n+v],[q-v,M,n+v],[q-v,M,n-v]],[[q-v,o,n-v],[q+v,o,n-v],[q+v,o,n+v],[q-v,o,n+v]]];var P=[];var R=[];var O=[];var H=[];for(var L=0;L<N.length;L++){P[L]=[];for(var K=0;K<N[L].length;K++){var G=this.xAxisMin<0?0:this.xAxisMin;var D=this.yAxisMin<0?0:this.yAxisMin;var C=this.zAxisMin<0?0:this.zAxisMin;var A=((N[L][K][0]-G)*this.xAxisUnit)-this.xAxisOffset;var u=this.yAxisOffset-((N[L][K][1]-D)*this.yAxisUnit);var p=((N[L][K][2]-C)*this.zAxisUnit)-this.zAxisOffset;P[L].push(this.get3DTransfrom(A,u,p))}H.push(L);O.push(this.euclidianDistance([(P[L][0][0]+P[L][2][0])/2,(P[L][0][1]+P[L][2][1])/2,(P[L][0][2]+P[L][2][2])/2],[this.zero3DPoint[0],this.zero3DPoint[1],-this.x]))}H.sort(function(d,c){return O[c]-O[d]});for(var B=1;B<P.length;B++){var L=H[B];var F=B<3?this.darkenLightenColor(Q,-B*30):Q;var m=[];var J=[];for(var K=0;K<P[L].length;K++){m.push(P[L][K][0]+I);J.push(P[L][K][1]+E)}this.addArea(this.drawShape("polygon",m,J,false,false,F,this.foreground,"closed"),S)}};this.set3DXLayout=function(){var w=[],c=[],m=[],v=[],b=[],j=[],d=[];var u,k,o,a,z,q,h,g;var e=this.len/15;var p=(15*-e)+e;var f=this.xAxisTitle?this.xAxisTitle:this.data.y.smps[this.xAxisIndex];var r=this.marginLeft+this.offsetX+this.left;var n=this.marginTop+this.offsetY+this.top;if(this.show3DGrid){o=p;u=0;k=0;while(o<this.len){if((u+1)%3){w[k]=o;c[k]=-this.len;m[k]=this.len;v[k]=o;b[k]=this.len;j[k]=this.len;d.push(this.xAxisTickColor);k++;w[k]=-this.len;c[k]=o;m[k]=this.len;v[k]=this.len;b[k]=o;j[k]=this.len;d.push(this.xAxisTickColor);k++}o+=e;u++}this.draw3DLayout(w,c,m,v,b,j,d,this.xAxisTickStyle);w=[],c=[],m=[],v=[],b=[],j=[],d=[];o=p;u=0;k=0;z=this.xAxisIncr;while(o<this.len){if(!((u+1)%3)){w[k]=o;c[k]=-this.len;m[k]=this.len;v[k]=o;b[k]=this.len;j[k]=this.len;d.push(this.foreground);k++;w[k]=-this.len;c[k]=o;m[k]=this.len;v[k]=this.len;b[k]=o;j[k]=this.len;d.push(this.foreground);a=this.get3DTransfrom(o,this.len,-this.len);h=a[0]+r;g=a[1]+n;q=this.formatAxisValue(this.xAxisMin+z,"xAxis");z+=this.xAxisIncr;if(this.xAxisShow){this.drawText(q,h,g+5,this.axisTickFont,this.axisTickColor,"right",false,-Math.PI/2)}k++}o+=e;u++}this.draw3DLayout(w,c,m,v,b,j,d,this.xAxisTickStyle)}if(this.xAxisShow){this.draw3DAxisTitle(p-(e*2),this.len+e,this.len+(e*4),this.len+(e*4),-this.len-(e*4),-this.len-(e*4),f,"x")}w=[-this.len,-this.len,this.len,-this.len];c=[-this.len,-this.len,-this.len,this.len];m=[this.len,this.len,this.len,this.len];v=[-this.len,this.len,this.len,this.len];b=[this.len,-this.len,this.len,this.len];j=[this.len,this.len,this.len,this.len];d=[this.foreground,this.foreground,this.foreground,this.foreground];this.draw3DLayout(w,c,m,v,b,j,d,this.xAxisTickStyle)};this.set3DYLayout=function(){var A=[],c=[],m=[],z=[],b=[],j=[],d=[];var v,k,p,a,B,r,h,g;var e=this.len/15;var w=this.yAxisLen/30;var q=(15*-e)+e;var f=this.yAxisTitle?this.yAxisTitle:this.data.y.smps[this.yAxisIndex];var u=this.marginLeft+this.offsetX+this.left;var n=this.marginTop+this.offsetY+this.top;var o=[];if(this.show3DGrid){p=q;v=0;k=0;B=this.yAxisIncr;while(p<this.len){if((v+1)%3){A[k]=-this.len;c[k]=-this.len;m[k]=p;z[k]=-this.len;b[k]=this.len;j[k]=p;d.push(this.yAxisTickColor);k++;A[k]=-this.len;c[k]=p;m[k]=-this.len;z[k]=-this.len;b[k]=p;j[k]=this.len;d.push(this.yAxisTickColor);k++}else{o.push(B);B+=this.yAxisIncr}p+=e;v++}this.draw3DLayout(A,c,m,z,b,j,d,this.yAxisTickStyle);A=[],c=[],m=[],z=[],b=[],j=[],d=[];p=q;v=0;k=0;while(p<this.len){if(!((v+1)%3)){A[k]=-this.len;c[k]=-this.len;m[k]=p;z[k]=-this.len;b[k]=this.len;j[k]=p;d.push(this.foreground);k++;A[k]=-this.len;c[k]=p;m[k]=-this.len;z[k]=-this.len;b[k]=p;j[k]=this.len;d.push(this.foreground);a=this.get3DTransfrom(-this.len,p,-this.len);h=a[0]+u;g=a[1]+n;B=o.pop();r=this.formatAxisValue(this.yAxisMin+B,"yAxis");if(this.yAxisShow){if(this.yRotate>=45&&this.xRotate>=45){this.drawText(r,h,g+5,this.axisTickFont,this.axisTickColor,"right",false,-Math.PI/2)}else{this.drawText(r,h-5,g,this.axisTickFont,this.axisTickColor,"right")}}k++}p+=e;v++}this.draw3DLayout(A,c,m,z,b,j,d,this.yAxisTickStyle)}if(this.yAxisShow){this.draw3DAxisTitle(-this.len-(e*4),-this.len-(e*4),q-(e*2),this.len+e,-this.len-(e*4),-this.len-(e*4),f,"y")}A=[-this.len,-this.len,-this.len,-this.len];c=[-this.len,-this.len,-this.len,this.len];m=[-this.len,this.len,this.len,this.len];z=[-this.len,-this.len,-this.len,-this.len];b=[this.len,-this.len,this.len,this.len];j=[-this.len,-this.len,this.len,-this.len];d=[this.foreground,this.foreground,this.foreground,this.foreground];this.draw3DLayout(A,c,m,z,b,j,d,this.yAxisTickStyle)};this.set3DZLayout=function(){var w=[],c=[],m=[],v=[],b=[],j=[],d=[];var u,k,o,a,z,q,h,g;var e=this.len/15;var p=(15*-e)+e;var f=this.zAxisTitle?this.zAxisTitle:this.data.y.smps[this.zAxisIndex];var r=this.marginLeft+this.offsetX+this.left;var n=this.marginTop+this.offsetY+this.top;if(this.show3DGrid){o=p;u=0;k=0;while(o<this.len){if((u+1)%3){w[k]=-this.len;c[k]=this.len;m[k]=o;v[k]=this.len;b[k]=this.len;j[k]=o;d.push(this.zAxisTickColor);k++;w[k]=o;c[k]=this.len;m[k]=-this.len;v[k]=o;b[k]=this.len;j[k]=this.len;d.push(this.zAxisTickColor);k++}o+=e;u++}this.draw3DLayout(w,c,m,v,b,j,d,this.zAxisTickStyle);w=[],c=[],m=[],v=[],b=[],j=[],d=[];o=p;u=0;k=0;z=this.zAxisIncr;while(o<this.len){if(!((u+1)%3)){w[k]=-this.len;c[k]=this.len;m[k]=o;v[k]=this.len;b[k]=this.len;j[k]=o;d.push(this.foreground);k++;w[k]=o;c[k]=this.len;m[k]=-this.len;v[k]=o;b[k]=this.len;j[k]=this.len;d.push(this.foreground);a=this.get3DTransfrom(this.len,this.len,o);h=a[0]+r;g=a[1]+n;q=this.formatAxisValue(this.zAxisMin+z,"zAxis");z+=this.zAxisIncr;if(this.zAxisShow){if(this.xRotate>=45){if(this.yRotate>=45){this.drawText(q,h+5,g,this.axisTickFont,this.axisTickColor,"left")}else{this.drawText(q,h,g+5,this.axisTickFont,this.axisTickColor,"right",false,-Math.PI/2)}}else{this.drawText(q,h+5,g,this.axisTickFont,this.axisTickColor,"left")}}k++}o+=e;u++}this.draw3DLayout(w,c,m,v,b,j,d,this.zAxisTickStyle)}if(this.zAxisShow){this.draw3DAxisTitle(this.len+(e*6),this.len+(e*6),this.len+(e*6),this.len+(e*6),p-(e*2),this.len+e,f,"z")}w=[-this.len,-this.len,this.len,-this.len];c=[this.len,this.len,this.len,this.len];m=[-this.len,this.len,-this.len,-this.len];v=[-this.len,this.len,this.len,this.len];b=[this.len,this.len,this.len,this.len];j=[this.len,this.len,this.len,-this.len];d=[this.foreground,this.foreground,this.foreground,this.foreground];this.draw3DLayout(w,c,m,v,b,j,d,this.zAxisTickStyle)};this.draw3DAxisTitle=function(u,s,d,c,j,h,m,b){var o=this.measureText(m);var q=o/2;var v=m.split("");var g=(u+s)/2;var f=(d+c)/2;var e=(j+h)/2;var p=this.marginLeft+this.offsetX;var k=this.marginTop+this.offsetY;var n=this.xRotate>=45||this.yRotate>=45?4:0;if(this.xRotate>=45||this.yRotate>=45){o+=v.length*4;q=o/2}if(b=="x"){g-=q;for(var r=0;r<v.length;r++){var a=this.get3DTransfrom(g,f,e);this.drawText(v[r],p+a[0],k+a[1],this.axisTitleFont,this.axisTitleColor,"left","top");g+=this.measureText(v[r])+n}}else{if(b=="y"){f+=q;for(var r=0;r<v.length;r++){var a=this.get3DTransfrom(g,f,e);this.drawText(v[r],p+a[0],k+a[1],this.axisTitleFont,this.axisTitleColor,"left","bottom",-Math.PI/2);f-=this.measureText(v[r])+n}}else{if(b=="z"){e-=q;for(var r=0;r<v.length;r++){var a=this.get3DTransfrom(g,f,e);this.drawText(v[r],p+a[0],k+a[1],this.axisTitleFont,this.axisTitleColor,"left","bottom");e+=this.measureText(v[r])+n}}}}};this.set3DLayout=function(){this.set3DXLayout();this.set3DYLayout();this.set3DZLayout()};this.set3DAxes=function(){var b=["x","y","z"];for(var a=0;a<b.length;a++){var c=this.smpIndices;this[b[a]+"AxisIndex"]=this.getSampleIndices([this[b[a]+"Axis"]])[0];this.setSamplesVisible([this[b[a]+"AxisIndex"]]);this.setRangeData();this[b[a]+"AxisMin"]=this.minData;this[b[a]+"AxisMax"]=this.maxData;this[b[a]+"AxisIncr"]=this.getAxisIncrements(this[b[a]+"AxisMin"],this[b[a]+"AxisMax"],10);this[b[a]+"AxisDecs"]=this.getAxisDecimals(this[b[a]+"AxisIncr"]);this[b[a]+"AxisMin"]=this.getAxisMin(this.minData,this[b[a]+"AxisIncr"]);this[b[a]+"AxisMax"]=this[b[a]+"AxisMin"]+(this[b[a]+"AxisIncr"]*10);this[b[a]+"AxisRange"]=this[b[a]+"AxisMax"]-this[b[a]+"AxisMin"];this[b[a]+"AxisUnit"]=this.len*2/this[b[a]+"AxisRange"];this[b[a]+"AxisOffset"]=(this[b[a]+"AxisMin"]+(this[b[a]+"AxisRange"]/2))*this[b[a]+"AxisUnit"];this.setSamplesVisible(c)}this.set3DCenter()};this.set3DCenter=function(){var e=this.xAxisMin<0?0:this.xAxisMin;var c=this.yAxisMin<0?0:this.yAxisMin;var b=this.zAxisMin<0?0:this.zAxisMin;var a=((((this.xAxisMin+this.xAxisMax)/2)-e)*this.xAxisUnit)-this.xAxisOffset;var f=this.yAxisOffset-((((this.yAxisMin+this.yAxisMax)/2)-c)*this.yAxisUnit);var d=((((this.zAxisMin+this.zAxisMax)/2)-b)*this.zAxisUnit)-this.zAxisOffset;this.zero3DPoint=this.get3DTransfrom(a,f,d)};this.draw3DDataPoints=function(){var T=this.marginLeft+this.offsetX+this.left;var M=this.marginTop+this.offsetY+this.top;var C=this.xAxisIndex+":"+this.yAxisIndex+":"+this.zAxisIndex;var B=[];var m=[];var D=[];var N=[];var e=[];for(var W=0;W<this.varIndices.length;W++){var G=this.varIndices[W];var L=this.getDataAtPos(G,this.xAxisIndex);var K=this.getDataAtPos(G,this.yAxisIndex);var J=this.getDataAtPos(G,this.zAxisIndex);var u=this.xAxisMin<0?0:this.xAxisMin;var r=this.yAxisMin<0?0:this.yAxisMin;var o=this.zAxisMin<0?0:this.zAxisMin;var k=((L-u)*this.xAxisUnit)-this.xAxisOffset;var h=this.scatterType&&this.scatterType.match(/bar/)?0:this.yAxisOffset-((K-r)*this.yAxisUnit);var f=((J-o)*this.zAxisUnit)-this.zAxisOffset;B.push([L,K,J]);m.push(this.get3DTransfrom(k,h,f));if(this.scatterType!="function"){N.push(W);e.push(this.euclidianDistance([m[W][0],m[W][1],m[W][2]],[this.zero3DPoint[0],this.zero3DPoint[1],-this.x]))}}if(this.scatterType&&this.scatterType=="function"){var S=Math.sqrt(m.length);var G=0;var F=[];for(var W=1;W<S;W++){for(var U=0;U<S-1;U++){var V=((W-1)*S)+U;var d=(W*S)+U;var R=((W-1)*S)+U+1;var Y=(W*S)+U+1;var H=[m[V][0],m[d][0],m[Y][0],m[R][0]];var v=[m[V][1],m[d][1],m[Y][1],m[R][1]];var ab=[m[V][2],m[d][2],m[Y][2],m[R][2]];var I=this.colorBy?this.legendColorRange:false;var E=this.colorBy?this.getHeatmapColor(I[0],I[1],this.mean([B[V][1],B[d][1],B[Y][1],B[R][1]])):false;N.push(G++);e.push(this.euclidianDistance([this.mean(H),this.mean(v),this.mean(ab)],[this.zero3DPoint[0],this.zero3DPoint[1],-this.x]));F.push([H,v,E])}}N.sort(function(g,c){return e[c]-e[g]});for(var G=0;G<F.length;G++){var W=N[G];var aa=[W,this.xAxisIndex,this.yAxisIndex,this.zAxisIndex];if(this.colorBy){this.addArea(this.drawShape("polygon",F[W][0],F[W][1],false,false,F[W][2],this.foreground,"close"),aa)}else{this.addArea(this.drawShape("polygon",F[W][0],F[W][1],false,false,false,this.foreground,"open"),aa)}}}else{N.sort(function(g,c){return e[c]-e[g]});for(var G=0;G<m.length;G++){var W=N[G];var Z=this.colorBy?this.dataColors[W]:this.colors[0];var X=this.scatterType&&this.scatterType.match(/image/i)?this.images[U]:false;var aa=[W,this.xAxisIndex,this.yAxisIndex,this.zAxisIndex];if(this.isVisibleSelectedDataPoint(W,C)){if(this.scatterType&&this.scatterType.match(/bar/)){var O=this.isInSelectedDataPoints(W,C)?this.selectedBackgroundColor:Z;this.draw3DBar(B[W][0],B[W][1],B[W][2],this.scatterPointSize/3,O,aa)}else{var Q=this.shapeBy?this.dataShapes[W]:this.shapes[0];var P=X?"image":Q;var O=this.sizeBy?this.dataSizes[W]:this.scatterPointSize;var L=this.xAxisMin<0?(T+m[W][0]):(T+m[W][0]);var K=M+m[W][1];this.drawSelectedBackground(W,C,Q,L,K,O,O);this.addArea(this.drawShape(P,L,K,O,O,Z,this.foreground,"closed",false,false,false,false,false,false,X),aa);if(this.scatterType&&this.scatterType.match(/line/)){D[W]=L}}}}if(this.scatterType&&this.scatterType.match(/line/)&&D.length>0){for(var W=0;W<D.length-1;W++){if(this.isVisibleSelectedDataPoint(W,C)&&this.isVisibleSelectedDataPoint(W+1,C)){var A=T+D[W][0];var b=M+D[W][1];var w=T+D[W+1][0];var ac=M+D[W+1][1];this.drawLine("line",A,b,w,ac,this.colors[0])}}}}};this.set3DprivateParams=function(){this.set3DText();this.set3DParams()};this.draw3DPlot=function(){this.setDataColorShapeSize();this.set3DXYDimensions();this.set3DprivateParams();this.set3DRotation();this.set3DAxes();this.set3DLayout();this.drawTitle();this.draw3DDataPoints();this.drawScatterLegend()};this.initializeScatter3D=function(){if(this.layoutValid){this.drawLayoutCompartments(this.draw3DPlot)}else{this.draw3DPlot()}};this.initializeScatter3D()};CanvasXpress.prototype.oneDPlot=function(){this.getShapeSize=function(){if(this.x<100||this.y<100){return this.rowBlockSize/6}else{if(this.x<200||this.y<200){return this.rowBlockSize/3}else{return this.rowBlockSize/1.5}}};this.setRowColBlocks=function(){var c=this.isGroupedData?this.grpIndices.length:this.smpIndices.length;this.rowBlocks=0;if(this.graphType=="Line"||this.graphType=="Area"||this.graphType=="AreaLine"||this.graphType=="Heatmap"||this.graphType=="Stacked"||this.graphType=="StackedLine"||this.graphType=="StackedPercent"||this.graphType=="StackedPercentLine"){this.rowBlocks=c;if(this.graphType=="Heatmap"){this.colBlocks=this.varIndices.length}else{this.colBlocks=1}}else{if(this.graphType=="BarLine"&&this.data.a){var b=this.getVariablesVisibleByAxis("xAxis");this.rowBlocks=b.length*c;this.colBlocks=1}else{this.rowBlocks=this.varIndices.length*c;this.colBlocks=1}}};this.set1DVarSmpLabelFont=function(){if(this.autoScaleFont){var b,a;if(this.data.l&&this.data.l.vars&&this.data.l.smps&&this.graphOrientation=="vertical"){b=this.scaleTextToSize(this.layoutMaxSamples*2)}else{a=Math.abs(this.smpLabelRotate==90)?6:2;b=this.isGraphTime?this.scaleTextToSize(this.timeValues.length*a):this.scaleTextToSize(this.smpIndices.length*a)}b=Math.min(b*this.smpLabelScaleFontFactor,this.maxTextSize);this.smpLabelFont=(b)+"Pt "+this.fontName;b=this.scaleTextToSize(this.varIndices.length*2);b=Math.min(b*this.varLabelScaleFontFactor,this.maxTextSize);this.varLabelFont=(b)+"Pt "+this.fontName}else{this.smpLabelFont=parseInt(this.smpLabelFontSize)+"Pt "+this.fontName;this.varLabelFont=parseInt(this.varLabelFontSize)+"Pt "+this.fontName}};this.set1DText=function(){var a;if(!this.layoutComb){if(this.data.y.desc){if(this.data.y.desc.length>1){if(this.data.y.desc[0].length>this.data.y.desc[1].length){a=this.data.y.desc[0]}else{a=this.data.y.desc[1]}}else{a=this.data.y.desc[0]}}else{a="NA"}}if(this.layoutComb){this.setAxisFont(this.minLayoutAxisTitle,this.minLayoutAxis)}else{if(this.graphOrientation=="vertical"){this.setAxisFont(a,this.y)}else{this.setAxisFont(a,this.x)}}};this.getVariableTitleHeight=function(){if(this.varTitle){return parseInt(this.varTitleFontSize*this.varTitleScaleFontFactor)+this.margin}else{return 0}};this.getVariableLabelLength=function(){if(this.showVariableNames){if(this.varLabelRotate&&Math.abs(this.varLabelRotate)==90){return this.getFontPt(this.varLabelFont)+this.margin}else{return this.measureText(this.maxVarNameStr,this.varLabelFont)+this.margin}}else{return 0}};this.getVariableLabelDescLength=function(){if(this.showVariableNames&&this.varLabelDescription){if(this.maxVarLabelDesc>this.maxVarStringLen){return this.measureText(this.maxVarLabelDescStr.substring(0,this.maxVarStringLen),this.varLabelFont)+(this.margin*2)}else{return this.measureText(this.maxVarLabelDescStr,this.varLabelFont)+(this.margin*2)}}else{return 0}};this.getSampleTitleHeight=function(){if(this.smpTitle){return parseInt(this.smpTitleFontSize*this.smpTitleScaleFontFactor)+this.margin}else{return 0}};this.getSampleLabelLength=function(){if(this.showSampleNames){if(this.smpLabelRotate&&Math.abs(this.smpLabelRotate)==90){return this.getFontPt(this.smpLabelFont)+(this.margin*2)}else{if(this.isGraphTime){return this.measureText(this.getMaxText(this.timeValues),this.smpLabelFont)+(this.margin*2)}else{if(this.maxSmpName>this.maxSmpStringLen){return this.measureText(this.maxSmpNameStr.substring(0,this.maxSmpStringLen),this.smpLabelFont)+(this.margin*2)}else{return this.measureText(this.maxSmpNameStr,this.smpLabelFont)+(this.margin*2)}}}}else{return 0}};this.getSampleLabelDescLength=function(){if(this.showSampleNames&&this.smpLabelDescription){if(this.maxSmpLabelDesc>this.maxSmpStringLen){return this.measureText(this.maxSmpLabelDescStr.substring(0,this.maxSmpStringLen),this.smpLabelFont)+(this.margin*2)}else{return this.measureText(this.maxSmpLabelDescStr,this.smpLabelFont)+(this.margin*2)}}else{return 0}};this.getSmpOverlaysLength=function(){var b=0;if(this.showOverlays){if(!this.isGroupedData){for(var a=0;a<this.smpOverlays.length;a++){if(this.data.x.hasOwnProperty(this.smpOverlays[a])){b++}}if(b>0){b=(b*this.overlaysWidth)+this.margin}}}return b};this.getSmpOverlaysStrLength=function(){var b=0;if(this.showOverlays){if(this.graphType=="Heatmap"){for(var a=0;a<this.smpOverlays.length;a++){if(this.data.x.hasOwnProperty(this.smpOverlays[a])){b=Math.max(b,this.measureText(this.smpOverlays[a],this.overlayFont)+this.margin)}}}}return b};this.getVarOverlaysHeight=function(){var b=0;if(this.showOverlays){if(this.graphType=="Heatmap"){for(var a=0;a<this.varOverlays.length;a++){if(this.data.z.hasOwnProperty(this.varOverlays[a])){b++}}if(b>0){b=(b*this.overlaysWidth)+this.margin}}}return b};this.getVarOverlaysLength=function(){var b=0;if(this.showOverlays){if(this.graphType=="Heatmap"){for(var a=0;a<this.varOverlays.length;a++){if(this.data.z.hasOwnProperty(this.varOverlays[a])){b=Math.max(b,this.measureText(this.varOverlays[a],this.overlayFont)+this.margin)}}}}return b};this.getAxisTitleTickLength=function(){if(this.graphOrientation=="vertical"){var a;if(this.tickRotate&&Math.abs(this.tickRotate)==90){a=this.getFontPt(this.axisTickFont)}else{if(this.graphType=="Candlestick"){if(this.showVolume){a=Math.max(this.measureText(this.xAxisMaxStrLength,this.axisTickFont),this.measureText(this.xAxis2MaxStrLength,this.axisTickFont))}else{if(this.summaryType=="candle"){a=this.measureText(this.xAxisMaxStrLength,this.axisTickFont)}else{a=this.measureText(this.xAxis2MaxStrLength,this.axisTickFont)}}}else{a=this.measureText(this.xAxisMaxStrLength,this.axisTickFont)}}return this.getFontPt(this.axisTitleFont)+a+(this.margin*3)}else{return this.getFontPt(this.axisTitleFont)+this.getFontPt(this.axisTickFont)+(this.margin*5)}};this.getHeatmapIndicatorHeight=function(){return this.indicatorHeight+(this.margin*4)+this.getFontPt(this.legendFont)};this.getLegendHeight=function(c){if(this.graphType=="Heatmap"){return 0}else{if(this.colorBy&&this.graphType=="Bar"){if(this.legendColorsN>0){return this.legendColorHeight+this.margin}else{return this.legendPosition=="right"?this.legendColorIndicatorWidth:this.legendColorIndicatorHeight}}else{var a=Math.min(this.getFontPt(this.legendFont),this.maxTextSize);var b=this.layoutComb&&!c?this.layoutMaxVarLegend:this.varIndices.length;return(b*a*1.5)+(a/2)+this.margin}}};this.getLegendWidth=function(){if(this.graphType=="Heatmap"){return 0}else{if(this.colorBy&&this.graphType=="Bar"){if(this.legendColorsN>0){return this.legendColorWidth+this.margin}else{return this.legendPosition=="right"?this.legendColorIndicatorHeight:this.legendColorIndicatorWidth}}else{var b=Math.min(this.getFontPt(this.legendFont),this.maxTextSize);var a=this.layoutComb?this.layoutMaxVarLegendLabel:this.maxVarNameStr;var c=a.length>this.maxVarStringLen?a.substring(0,this.maxVarStringLen):a;return(b*2)+this.measureText(c,this.legendFont)+(this.margin*6)}}};this.getVarTreeHeight=function(){var a=0;if(this.graphType=="Heatmap"&&this.showVarDendrogram&&this.varDendrogram){a=((this.varDendrogram.depth+1)*this.dendrogramSpace)+this.margin}return a};this.getSmpTreeWidthHeight=function(){var a=0;if(this.showSmpDendrogram&&this.smpDendrogram&&!this.isGroupedData){a=((this.smpDendrogram.depth+1)*this.dendrogramSpace)+this.margin}return a};this.set1DXYDimensionsLeft=function(){if(this.graphOrientation=="vertical"){this.left=this.margin+this.getAxisTitleTickLength()}else{if(this.smpDendrogramPosition=="right"){this.left=this.margin+this.getSampleTitleHeight()+this.getSampleLabelLength()+this.getSmpOverlaysLength()}else{this.left=this.margin+this.getSampleTitleHeight()+this.getSmpTreeWidthHeight()+this.getSampleLabelLength()+this.getSmpOverlaysLength()}}};this.set1DXYDimensionsRight=function(){if(this.graphOrientation=="vertical"){this.right=this.margin+this.getAxisTitleTickLength()}else{if(this.smpDendrogramPosition=="right"){this.right=this.margin+this.getSmpTreeWidthHeight()}else{this.right=this.margin}}if(this.showLegend&&this.legendPosition=="right"){this.right+=this.getLegendWidth()}if(this.graphType=="Heatmap"){var b=this.getSampleLabelDescLength();var a=0;if(this.showOverlays){a=this.getVarOverlaysLength()}this.right+=Math.max(b,a)}};this.set1DXYDimensionsTop=function(){this.top=this.margin;if(this.title){this.top+=this.titleHeight+this.margin;if(this.subtitle){this.top+=this.subtitleHeight+this.margin}}if(this.graphOrientation=="vertical"){if(this.smpDendrogramPosition!="bottom"){this.top+=this.getSmpTreeWidthHeight()}}else{if(this.graphType=="Heatmap"){this.top+=this.getHeatmapIndicatorHeight();if(this.varDendrogramPosition!="bottom"){this.top+=this.getVarTreeHeight()}if(this.varTitleLabelOverlayPosition!="bottom"){this.top+=this.getVariableTitleHeight();this.top+=this.getVariableLabelLength();this.top+=this.getVarOverlaysHeight()}else{this.top+=this.getVariableLabelDescLength()}}else{this.top+=this.getAxisTitleTickLength()}}};this.set1DXYDimensionsBottom=function(){this.bottom=this.margin;if(this.graphOrientation=="vertical"){this.bottom+=this.getSampleTitleHeight()+this.getSampleLabelLength()+this.getSmpOverlaysLength();if(this.smpDendrogramPosition=="bottom"){this.bottom+=this.getSmpTreeWidthHeight()}if(this.showLegend&&this.legendPosition=="bottom"){this.bottom+=this.getLegendHeight()}}else{if(this.graphType=="Heatmap"){if(this.varTitleLabelOverlayPosition=="bottom"){this.bottom+=this.getVarOverlaysHeight();this.bottom+=this.getVariableLabelLength();this.bottom+=this.getVariableTitleHeight()}else{this.bottom+=Math.max(this.getVariableLabelDescLength(),this.getSmpOverlaysStrLength())}if(this.varDendrogramPosition=="bottom"){this.bottom+=this.getVarTreeHeight()}}else{this.bottom+=this.getAxisTitleTickLength();if(this.showLegend&&this.legendPosition=="bottom"){this.bottom+=this.getLegendHeight()}}}};this.set1DXYDimensions=function(a){if(this.isGraphTime){if(!this.showVolume||(this.layoutComb&&this.layoutCurrent==0)){this.setTimeAxis()}}if(!a){this.setRowColBlocks();this.set1DVarSmpLabelFont()}if(this.graphOrientation=="vertical"){this.set1DXYDimensionsTop();this.set1DXYDimensionsBottom();this.y=this.layoutComb?this.layoutHeight-(this.top+this.bottom):this.height-(this.marginTop+this.top+this.bottom+this.marginBottom);if(this.y<0){this.showLegend=false;this.set1DXYDimensionsBottom();this.y=this.layoutComb?this.layoutHeight-(this.top+this.bottom):this.height-(this.marginTop+this.top+this.bottom+this.marginBottom);if(this.debug){if(this.y<0){alert("Dude it doesn't fit make the graph bigger because it looks ugly!")}else{alert("Dude the legend was taken out because it doesn't fit make the graph bigger!")}}}this.set1DText();this.set1DXYDimensionsLeft();this.set1DXYDimensionsRight();this.x=this.layoutComb?this.layoutWidth-(this.left+this.right):this.width-(this.marginLeft+this.left+this.right+this.marginRight);if(this.x<0){this.showLegend=false;this.set1DXYDimensionsRight();this.x=this.layoutComb?this.layoutWidth-(this.left+this.right):this.width-(this.marginLeft+this.left+this.right+this.marginRight);if(this.debug){if(this.x<0){alert("Dude it doesn't fit make the graph bigger because it looks ugly!")}else{alert("Dude the legend was taken out because it doesn't fit make the graph bigger!")}}}}else{this.set1DXYDimensionsLeft();this.set1DXYDimensionsRight();this.x=this.layoutComb?this.layoutWidth-(this.left+this.right):this.width-(this.marginLeft+this.left+this.right+this.marginRight);if(this.x<0){this.showLegend=false;this.set1DXYDimensionsRight();this.x=this.layoutComb?this.layoutWidth-(this.left+this.right):this.width-(this.marginLeft+this.left+this.right+this.marginRight);if(this.debug){if(this.x<0){alert("Dude it doesn't fit make the graph bigger because it looks ugly!")}else{alert("Dude the legend was taken out because it doesn't fit make the graph bigger!")}}}this.set1DText();this.set1DXYDimensionsTop();this.set1DXYDimensionsBottom();this.y=this.layoutComb?this.layoutHeight-(this.top+this.bottom):this.height-(this.marginTop+this.top+this.bottom+this.marginBottom);if(this.y<0){this.showLegend=false;this.set1DXYDimensionsBottom();this.y=this.layoutComb?this.layoutHeight-(this.top+this.bottom):this.height-(this.marginTop+this.top+this.bottom+this.marginBottom);if(this.debug){if(this.y<0){alert("Dude it doesn't fit make the graph bigger because it looks ugly!")}else{alert("Dude the legend was taken out because it doesn't fit make the graph bigger!")}}}if(this.graphType=="Heatmap"&&!this.layoutComb){if(this.bottom*1.5>this.y){if(this.dendrogramSpace>2){this.dendrogramSpace-=2}var b=this.getFontPt(this.varLabelFont)-1;this.varLabelFont=b.toString()+"pt "+this.fontName;this.resizeCanvas(true);this.set1DXYDimensions(true)}}if(this.left*1.5>this.x&&!this.layoutComb){if(this.dendrogramSpace>2){this.dendrogramSpace-=2}var b=this.getFontPt(this.smpLabelFont)-1;this.smpLabelFont=b.toString()+"pt "+this.fontName;this.resizeCanvas(true);this.set1DXYDimensions(true)}}};this.set1DPrivateParams=function(){var a=this.isGroupedData?this.grpIndices.length:this.smpIndices.length;if(this.graphType=="Heatmap"){this.rowBlockSize=this.y/this.rowBlocks;this.blockSeparation=this.rowBlockSize;this.colBlockSize=this.x/this.varIndices.length}else{if(this.graphType.match(/Area/)){this.rowBlockSize=this.graphOrientation=="vertical"?this.x/(this.rowBlocks+a-2):this.y/(this.rowBlocks+a-2)}else{this.rowBlockSize=this.graphOrientation=="vertical"?this.x/(this.rowBlocks+a+1):this.y/(this.rowBlocks+a+1)}this.blockSeparation=this.rowBlockSize;this.colBlockSize=1}};this.setTrees=function(){if(this.showSmpDendrogram&&this.data.t.smps){this.smpDendrogram={};this.smpDendrogram.data=[];this.smpDendrogram.nodes=[];this.smpDendrogram.idxs=[];this.smpDendrogram.heights=[];this.parseNewick(this.data.t.smps,"smpDendrogram")}if(this.showVarDendrogram&&this.data.t.vars){this.varDendrogram={};this.varDendrogram.data=[];this.varDendrogram.nodes=[];this.varDendrogram.idxs=[];this.varDendrogram.heights=[];this.parseNewick(this.data.t.vars,"varDendrogram")}};this.parseNewick=function(b,d){var o=b.split(/,/);var v=0;var e=0;var f=0;var l=1;var k=0;var t=0;var a=0;var h=0;for(var r=0;r<o.length;r++){var p=o[r];var g=p.split(/:(?=[0-9\.]+)/);var w=g.shift();w=w.replace(/[\(\)]/g,"");this[d].nodes.push(w);var u=d=="smpDendrogram"?this.getSampleIndices(w):this.getVariableIndices(w);this[d].idxs.push(u);for(var q=0;q<g.length;q++){var c=g[q].replace(/[\(\)]/g,"");t=Math.max(t,c);this[d].heights.push(c)}this[d].max=t;var s=o[r].split(/ */);e=0;for(var q=0;q<s.length;q++){if(s[q]=="("){v++;e++}if(s[q]==")"){v--;e--}}h+=e;if(f>v){this[d].data.push([l,f,e,h])}else{this[d].data.push([l,v,e,h])}f=v;a=Math.max(a,f);k+=e;l++}this[d].unit=t>0?(a*this.dendrogramSpace)/t:0;this[d].depth=a;if(k>0){alert("Dude! Malformed newick tree. There are "+k+" additional right parenthesis!")}else{if(k<0){alert("Dude! Malformed newick tree. There are "+Math.abs(k)+" additional left parenthesis!")}}if(d=="varDendrogram"){if(this.varIndicesStart<0){if(this[d].nodes.length!=this.data.y.vars.length){alert("Dude! The length of the variable nodes in the dendrogram ("+this[d].nodes.length+") is different to that one in the data ("+this.data.y.vars.length+"). This ain't gonna work!");this.showVarDendrogram=false}else{if(this[d].nodes.length!=this.varIndices.length){alert("Ooops! Cannot show dendrogram with "+this[d].nodes.length+" nodes when only "+this.varIndices.length+" variables are visible.");this.showVarDendrogram=false}else{this.varIndices=this[d].idxs}}}else{var m=this.varIndicesStart+this.varIndices.length;this.varIndices=[];for(var r=this.varIndicesStart;r<m;r++){this.varIndices.push(this[d].idxs[r])}}}else{if(this.smpIndicesStart<0){if(this[d].nodes.length!=this.data.y.smps.length){alert("Dude! The length of the sample nodes in the dendrogram ("+this[d].nodes.length+") is different to that one in the data ("+this.data.y.smps.length+"). This ain't gonna work!");this.showSmpDendrogram=false}else{if(this[d].nodes.length!=this.smpIndices.length){alert("Ooops! Cannot show dendrogram with "+this[d].nodes.length+" nodes when only "+this.smpIndices.length+" samples visible.");this.showSmpDendrogram=false}else{this.smpIndices=this[d].idxs}}}else{var m=this.smpIndicesStart+this.smpIndices.length;this.smpIndices=[];for(var r=this.smpIndicesStart;r<m;r++){this.smpIndices.push(this[d].idxs[r])}}}};this.setOverlayColors=function(){var l=0;if(this.smpOverlays.length>0&&!this.isGroupedData){this.smpOverlayColors=[];for(var g=0;g<this.smpOverlays.length;g++){var a={};this.smpOverlayColors[g]=[];var f=this.smpOverlays[g];if(this.data.x.hasOwnProperty(f)){if(this.isNumeric(this.data.x[f],true)){var h=this.range(this.data.x[f],true);for(var e=0;e<this.smpIndices.length;e++){var k=this.smpIndices[e];var d=this.data.x[f][k];var c=!isNaN(d)?this.getHeatmapColor(h[0],h[1],d):this.missingDataColor;this.smpOverlayColors[g].push(c)}}else{for(var e=0;e<this.smpIndices.length;e++){var k=this.smpIndices[e];var b=this.data.x[f][k];if(!a.hasOwnProperty(b)){a[b]=l%this.colors.length;l++}this.smpOverlayColors[g].push(this.colors[a[b]])}}}}}l=0;if(this.varOverlays.length>0&&this.graphType=="Heatmap"){this.varOverlayColors=[];for(var g=0;g<this.varOverlays.length;g++){var a={};this.varOverlayColors[g]=[];var f=this.varOverlays[g];if(this.data.z.hasOwnProperty(f)){if(this.isNumeric(this.data.z[f],true)){var h=this.range(this.data.z[f],true);for(var e=0;e<this.varIndices.length;e++){var k=this.varIndices[e];var d=this.data.z[f][k];var c=!isNaN(d)?this.getHeatmapColor(h[0],h[1],d):this.missingDataColor;this.varOverlayColors[g].push(c)}}else{for(var e=0;e<this.varIndices.length;e++){var k=this.varIndices[e];var b=this.data.z[f][k];if(!a.hasOwnProperty(b)){a[b]=l%this.colors.length;l++}this.varOverlayColors[g].push(this.colors[a[b]])}}}}}};this.setOverlayFont=function(){var a=Math.min(this.overlayScaleFontFactor*this.overlayFontSize,this.maxTextSize);a=parseInt(Math.max(a,this.minTextSize));this.overlayFont=(a)+"Pt "+this.fontName};this.set1DAttributes=function(){this.setLegendFont();this.setTrees();this.setOverlayColors();this.setOverlayFont();this.setDataColor(true)};this.set1DXAxis=function(){var a=this.graphOrientation=="vertical"?"y":"x";this.setAxisUnits("xAxis",a);if((this.graphType.match(/BarLine|AreaLine|StackedLine|StackedPercentLine/)&&this.data.a)||(this.graphType=="Candlestick"&&this.showVolume)){this.setAxisUnits("xAxis2",a)}};this.draw1DWireFrame=function(){var s,d,r,c,q,a,e,h,p;var f=this.isGroupedData?this.grpIndices:this.smpIndices;var u=this.xAxisTickStyle=="dotted"||this.yAxisTickStyle=="dotted"?"dottedLine":"line";var v=this.smpHairline=="dotted"?"dottedLine":"line";var m=this.marginLeft+this.offsetX+this.left;var k=this.marginTop+this.offsetY+this.top;if(this.graphType!="Heatmap"){if(this.graphType=="BarLine"&&this.data.a&&this.data.y.desc[1]){var b=this.getVariablesVisibleByAxis("xAxis");p=b.length}else{if(this.graphType.match(/Stacked|Line|Area/)){p=1}else{p=this.varIndices.length}}h=p*this.rowBlockSize;if(this.graphOrientation=="vertical"){if(this.isGraphTime){var g=(this.x-this.blockSeparation)/f.length;var n=g/2;var j=this.graphType.match(/Area/)?0:m+(this.blockSeparation*0.5)+n;d=k;c=k+this.y;for(var o=0;o<this.timeValueIndices.length;o++){s=(this.timeValueIndices[o]*g)+j;if(this.smpHairline){this.drawLine(v,s,d,s,c,this.smpHairlineColor,false,"butt")}}}else{s=this.graphType.match(/Area/)?m:m+this.blockSeparation+(h/2);r=m;q=this.graphType.match(/Area/)?m+this.blockSeparation+h:m+(this.blockSeparation*1.5)+h;d=k;c=k+this.y;for(var o=0;o<f.length;o++){if(this.blockContrast){e=o%2?this.blockContrastEvenColor:this.blockContrastOddColor;this.ctx.save();this.rectangle(r,d,q,c,e,e);this.ctx.restore();r=q;q=r+this.blockSeparation+h}if(this.smpHairline){if(this.graphType.match(/Area/)&&(o==0||o==f.length-1)){s+=this.blockSeparation+h;continue}this.drawLine(v,s,d,s,c,this.smpHairlineColor,false,"butt")}s+=this.blockSeparation+h}}if((this.xAxisMinorTicks||this.xAxis2MinorTicks)&&this.summaryType!="volume"){for(var o=0;o<this.xAxisMinorValues.length;o++){var w=parseFloat(this.xAxisMinorValues[o]);d=this.marginTop+this.offsetY+this.top+this.y-((w-this.xAxisMin)*this.xAxisUnit);this.drawLine(u,m,d,m+this.x,d,this.xAxisTickColor,this.outlineWidth/3,"butt")}}s=this.marginLeft+this.offsetX+this.left-(this.margin*2);for(var o=0;o<this.xAxisValues.length;o++){var w=parseFloat(this.xAxisValues[o]);d=this.marginTop+this.offsetY+this.top+this.y-((w-this.xAxisMin)*this.xAxisUnit);this.drawLine(u,m,d,m+this.x,d,this.xAxisTickColor,false,"butt")}}else{if(this.isGraphTime){var g=(this.y-this.blockSeparation)/f.length;var n=g/2;var j=this.graphType.match(/Area/)?0:k+(this.blockSeparation*0.5)+n;s=m;r=m+this.x;for(var o=0;o<this.timeValueIndices.length;o++){d=(this.timeValueIndices[o]*g)+j;if(this.smpHairline){this.drawLine(v,s,d,r,d,this.smpHairlineColor,false,"butt")}}}else{s=m;r=m+this.x;d=this.graphType.match(/Area/)?k:k+this.blockSeparation+(h/2);c=k;a=this.graphType.match(/Area/)?k+this.blockSeparation+h:k+(this.blockSeparation*1.5)+h;for(var o=0;o<f.length;o++){if(this.blockContrast){e=o%2?this.blockContrastEvenColor:this.blockContrastOddColor;this.ctx.save();this.rectangle(s,c,r,a,e,e);this.ctx.restore();c=a;a=c+this.blockSeparation+h}if(this.smpHairline){if(this.graphType.match(/Area/)&&(o==0||o==f.length-1)){d+=this.blockSeparation+h;continue}this.drawLine(v,s,d,r,d,this.smpHairlineColor,false,"butt")}d+=this.blockSeparation+h}}if((this.xAxisMinorTicks||this.xAxis2MinorTicks)&&this.summaryType!="volume"){for(var o=0;o<this.xAxisMinorValues.length;o++){var w=parseFloat(this.xAxisMinorValues[o]);s=m+((w-this.xAxisMin)*this.xAxisUnit);this.drawLine(u,s,k,s,k+this.y,this.xAxisTickColor,this.outlineWidth/3,"butt")}}d=this.marginTop+this.offsetY+this.top-((this.margin*2)+(this.getFontPt(this.axisTickFont)/2));for(var o=0;o<this.xAxisValues.length;o++){var w=parseFloat(this.xAxisValues[o]);s=m+((w-this.xAxisMin)*this.xAxisUnit);this.drawLine(u,s,k,s,k+this.y,this.xAxisTickColor,false,"butt")}}}};this.drawTrees=function(){if(!this.isGroupedData){this.drawDendrogram("smpDendrogram");if(this.graphType=="Heatmap"){this.drawDendrogram("varDendrogram")}this.maskTreeArea()}};this.getMaxDepthDendrogramXYs=function(c){if(c.length>0){var a=[];for(var b=0;b<c.length;b++){a.push(c[b][1])}a.sort(function(e,d){return d-e});for(var b=0;b<c.length;b++){if(c[b][1]==a[0]){return b}}}else{return -1}};this.drawDendrogram=function(F){var Y=this.marginLeft+this.offsetX+this.left;var T=this.marginTop+this.offsetY+this.top;var K=F=="varDendrogram"?"showVarDendrogram":"showSmpDendrogram";var f=F=="varDendrogram"?this.varIndices:this.smpIndices;var B,a,A,ag,ae,G;var E=false;var W=this.dendrogramSpace/2;if(this.graphType!="Heatmap"){if(this.graphType=="BarLine"&&this.data.a&&this.data.y.desc[1]){var F=this.getVariablesVisibleByAxis("xAxis");G=F.length}else{if(this.graphType.match(/Stacked|Line|Area/)){G=1}else{G=this.varIndices.length}}ae=G*this.rowBlockSize}else{ae=0}if(this[K]&&this[F]){var D=this[F].data;var af=this[F].idxs;var G=this[F].depth;var o=this.getMaxDepthDendrogramXYs(D);var g=this[F].heights;var e=this[F].max;var m={};var v={};var d=[];if(F=="varDendrogram"){for(var ad=0;ad<D.length;ad++){d[ad]=this.createNode(this.data.y.vars[af[ad]],null,null,0,null)}}else{for(var ad=0;ad<D.length;ad++){d[ad]=this.createNode(this.data.y.smps[af[ad]],null,null,0,null)}}while(D.length>1){ad=o;var k=[ad];var P=D[ad][0];var O=D[ad][1];var N=D[ad][2];var R=D[ad][3];var q=[P];var p=[O];var n=[N];var s=[R];var H={};var V="";var C=N;H[ad]=1;for(var ab=ad+1;ab<D.length;ab++){var aa=D[ab][0];var Z=D[ab][1];var X=D[ab][2];var ac=D[ab][3];if(Z==O&&((X==0&&ac<=R)||(ac<R))){q.push(aa);p.push(Z);n.push(X);s.push(ac);C+=X;H[ab]=1;k.push(ab)}else{break}}if(q.length>1){if(F=="varDendrogram"){var h=this.colBlockSize/2;var Q;if(this.varDendrogramPosition=="bottom"){if(this.varTitleLabelOverlayPosition!="bottom"){Q=(T+this.y+this.bottom)-(this.margin+(this.dendrogramSpace*(G+1)))}else{Q=(T+this.y+this.bottom)-(this.margin+(this.dendrogramSpace*(G+1))+this.getVariableTitleHeight())}}else{if(this.varTitleLabelOverlayPosition!="bottom"){Q=T-(this.getVarOverlaysHeight()+this.getVariableLabelLength()+this.getVarTreeHeight())}else{Q=T-(this.margin+this.getVarTreeHeight()+this.getVariableLabelDescLength())}}if(!E&&this.modelEvent=="global"){this.addGlobalArea(["rect",Y,Q,Y+this.x,Q+this.getVarTreeHeight()],true);E=true}for(var ad=0;ad<q.length;ad++){d[k[ad]].dist=g[k[ad]];B=(Y+h)+(this.colBlockSize*(q[ad]-1));B=this.varIndicesStart>-1?B-(this.colBlockSize*this.varIndicesStart):B;if(this.varDendrogramPosition=="bottom"){if(this.varTitleLabelOverlayPosition!="bottom"){ag=this.height-(this.marginBottom+this.margin+(this.dendrogramSpace*p[ad]))}else{ag=this.height-(this.marginBottom+this.margin+(this.dendrogramSpace*p[ad])+this.getVariableTitleHeight())}if(this.dendrogramHeight){}else{if(this.isLeafNode(d[k[ad]])&&!this.dendrogramHang){a=Q}else{a=ag-this.dendrogramSpace}}}else{a=Q+(this.dendrogramSpace*p[ad]);if(this.dendrogramHeight){}else{if(this.isLeafNode(d[k[ad]])&&!this.dendrogramHang){ag=Q+(this.dendrogramSpace*(G+1))}else{ag=a+this.dendrogramSpace}}}this.drawLine("line",B,a,B,ag,this.foreground,false,"butt",false,false,true,[0,0,this.width,this.height]);if(!m.hasOwnProperty(R)){m[R]=0}if(!this.isLeafNode(d[k[ad]])){this.addArea(["rect",B-W,ag-W,B+W,ag+W],[-R],"-"+m[R]+"-varDendrogram");m[R]++}if(ad<q.length-1){A=(Y+h)+(this.colBlockSize*(q[ad+1]-1));A=this.varIndicesStart>-1?A-(this.colBlockSize*this.varIndicesStart):A;if(this.varDendrogramPosition=="bottom"){this.drawLine("line",B,ag,A,ag,this.foreground,false,"butt",false,false,true,[0,0,this.width,this.height])}else{this.drawLine("line",B,a,A,a,this.foreground,false,"butt",false,false,true,[0,0,this.width,this.height])}}}}else{if(this.graphOrientation=="vertical"){var Q;if(this.smpDendrogramPosition=="bottom"){Q=(T+this.y+this.bottom)-(this.margin+this.getSampleTitleHeight()+(this.dendrogramSpace*(G+1)));if(this.showLegend&&this.legendPosition=="bottom"){Q-=this.getLegendHeight()}}else{Q=T-this.getSmpTreeWidthHeight()}if(!E&&this.modelEvent=="global"){this.addGlobalArea(["rect",Y,Q,Y+this.x,Q+this.getSmpTreeWidthHeight()],true);E=true}for(var ad=0;ad<q.length;ad++){d[k[ad]].dist=g[k[ad]];B=(Y+this.blockSeparation+(ae/2))+((this.blockSeparation+ae)*(q[ad]-1));B=this.smpIndicesStart>-1?B-((this.blockSeparation+ae)*this.smpIndicesStart):B;if(this.smpDendrogramPosition=="bottom"){ag=this.height-(this.marginBottom+this.margin+(this.dendrogramSpace*p[ad]));if(this.showLegend&&this.legendPosition=="bottom"){ag-=this.getLegendHeight()}if(this.dendrogramHeight){}else{if(this.isLeafNode(d[k[ad]])&&!this.dendrogramHang){a=Q}else{a=ag-this.dendrogramSpace}}}else{a=Q+(this.dendrogramSpace*p[ad]);if(this.dendrogramHeight){}else{if(this.isLeafNode(d[k[ad]])&&!this.dendrogramHang){ag=Q+(this.dendrogramSpace*(G+1))}else{ag=a+this.dendrogramSpace}}}this.drawLine("line",B,a,B,ag,this.foreground,false,"butt",false,false,true,[0,0,this.width,this.height]);if(!m.hasOwnProperty(R)){m[R]=0}if(!this.isLeafNode(d[k[ad]])){this.addArea(["rect",B-W,ag-W,B+W,ag+W],[-R],"-"+m[R]+"-smpDendrogram");m[R]++}if(ad<q.length-1){A=(Y+this.blockSeparation+(ae/2))+((this.blockSeparation+ae)*(q[ad+1]-1));A=this.smpIndicesStart>-1?A-((this.blockSeparation+ae)*this.smpIndicesStart):A;if(this.smpDendrogramPosition=="bottom"){this.drawLine("line",B,ag,A,ag,this.foreground,false,"butt",false,false,true,[0,0,this.width,this.height])}else{this.drawLine("line",B,a,A,a,this.foreground,false,"butt",false,false,true,[0,0,this.width,this.height])}}}}else{if(this.smpDendrogramPosition=="right"){Q=Y+this.x+this.getSampleLabelDescLength()+this.margin}else{Q=this.marginLeft+this.offsetX+this.margin+this.getSampleTitleHeight()}if(!E&&this.modelEvent=="global"){this.addGlobalArea(["rect",Q,T,Q+this.getSmpTreeWidthHeight(),T+this.y],true);E=true}for(var ad=0;ad<q.length;ad++){d[k[ad]].dist=g[k[ad]];if(this.smpDendrogramPosition=="right"){A=(Y+this.x+this.getSampleLabelDescLength()+this.margin)+((this.dendrogramSpace*(G+1))-(this.dendrogramSpace*p[ad]))}else{B=this.marginLeft+this.offsetX+this.margin+this.getSampleTitleHeight()+(this.dendrogramSpace*p[ad])}if(this.graphType=="Heatmap"){a=(T+this.blockSeparation)+(this.rowBlockSize*(q[ad]-1));a=this.smpIndicesStart>-1?a-(this.rowBlockSize*this.smpIndicesStart):a;a-=this.blockSeparation/2}else{a=(T+this.blockSeparation+(ae/2))+((this.blockSeparation+ae)*(q[ad]-1));a=this.smpIndicesStart>-1?a-((this.blockSeparation+ae)*this.smpIndicesStart):a}if(this.smpDendrogramPosition=="right"){if(this.dendrogramHeight){}else{if(this.isLeafNode(d[k[ad]])&&!this.dendrogramHang){B=Y+this.x+this.getSampleLabelDescLength()+this.margin}else{B=A-this.dendrogramSpace}}}else{if(this.dendrogramHeight){}else{if(this.isLeafNode(d[k[ad]])&&!this.dendrogramHang){A=this.marginLeft+this.offsetX+this.margin+this.getSampleTitleHeight()+(this.dendrogramSpace*(G+1))}else{A=B+this.dendrogramSpace}}}this.drawLine("line",B,a,A,a,this.foreground,false,"butt",false,false,true,[0,0,this.width,this.height]);if(!m.hasOwnProperty(R)){m[R]=0}if(!this.isLeafNode(d[k[ad]])){this.addArea(["rect",A-W,a-W,A+W,a+W],[-R],"-"+m[R]+"-smpDendrogram");m[R]++}if(ad<q.length-1){if(this.graphType=="Heatmap"){ag=(T+this.blockSeparation)+(this.rowBlockSize*(q[ad+1]-1));ag=this.smpIndicesStart>-1?ag-(this.rowBlockSize*this.smpIndicesStart):ag;ag-=this.blockSeparation/2}else{ag=(T+this.blockSeparation+(ae/2))+((this.blockSeparation+ae)*(q[ad+1]-1));ag=this.smpIndicesStart>-1?ag-((this.blockSeparation+ae)*this.smpIndicesStart):ag}if(this.smpDendrogramPosition=="right"){this.drawLine("line",A,a,A,ag,this.foreground,false,"butt",false,false,true,[0,0,this.width,this.height])}else{this.drawLine("line",B,a,B,ag,this.foreground,false,"butt",false,false,true,[0,0,this.width,this.height])}}}}}var J,M;var b=[];var I=[];var S=[];var L=[];var u=this.mean(q);var c=false;if(!v.hasOwnProperty(R)){v[R]=0}V=(R-1)+"-"+v[R];for(var U in H){L.push(d[U])}for(var ab=0;ab<D.length;ab++){if(!H.hasOwnProperty(ab)){b.push(D[ab]);I.push(d[ab])}else{if(!c){b.push([u,O-1,C,s[s.length-1]]);J=L.shift();M=L.pop();if(L.length>0){I.push(this.createNode(V,J,M,0,null,L))}else{I.push(this.createNode(V,J,M,0,null))}v[R]++;c=true}}}for(var ab=0;ab<g.length;ab++){if(!H.hasOwnProperty(ab)){S.push(g[ab])}}D=b;d=I;g=S;o=this.getMaxDepthDendrogramXYs(D)}}this[F].object=d[0]}};this.draw1DYLayout=function(){var D,d,C,c,B,b,m,z;var u=this.marginLeft+this.offsetX+this.left;var p=this.marginTop+this.offsetY+this.top;if(this.smpTitle){var r=(parseInt(this.smpTitleFontSize*this.smpTitleScaleFontFactor))+"Pt "+this.fontName;if(this.graphOrientation=="vertical"){D=u+(this.x/2);d=(p+this.y+this.bottom)-(this.margin+(parseInt(this.smpTitleFontSize*this.smpTitleScaleFontFactor)/2));this.drawText(this.smpTitle,D,d,r,this.smpTitleFontColor,"center","middle")}else{D=this.marginLeft+this.offsetX+(parseInt(this.smpTitleFontSize*this.smpTitleScaleFontFactor)/2);d=p+(this.y/2);this.drawText(this.smpTitle,D,d,r,this.smpTitleColor,"center","middle",-Math.PI/2)}}if(this.showSampleNames){var g=this.isGroupedData?this.grpIndices:this.smpIndices;var q=this.isGroupedData?this.data.w.smps:this.data.y.smps;if(this.graphType=="Heatmap"){var x=Math.abs(this.smpLabelRotate)==90?"center":"right";if(this.isGraphTime){var h=this.y/g.length;var w=h/2;var n=p+w;D=(u)-(this.margin*2);C=u+this.x+this.margin;for(var y=0;y<this.timeValueIndices.length;y++){d=(this.timeValueIndices[y]*h)+n;if(this.smpLabelRotate){this.addArea(this.drawText(this.timeValues[y],D-this.margin,d,this.smpLabelFont,e,x,"middle",this.smpLabelRotate*Math.PI/180),["Smp-"+y])}else{this.addArea(this.drawText(this.timeValues[y],D,d,this.smpLabelFont,e,"right","middle"),["Smp-"+y])}if(this.smpLabelDescription){var k=this.shortenText(this.data.x[this.smpLabelDescription][g[y]],this.maxSmpStringLen);this.drawText(k,C,d,this.smpLabelFont,e,"right","middle")}}}else{D=u;C=u+this.x+this.margin;d=p+this.blockSeparation;d-=this.blockSeparation/2;z=1;var f=this.getSmpOverlaysLength();for(var y=0;y<g.length;y++){var o=g[y];var k=this.shortenText(q[o],this.maxSmpStringLen);var A=(this.margin*2)+f;var e=this.getSmpColor(q[o]);if(this.smpLabelRotate){this.addArea(this.drawText(k,D-(A+this.margin),d,this.smpLabelFont,e,x,"middle",this.smpLabelRotate*Math.PI/180),["Smp-"+o])}else{this.addArea(this.drawText(k,D-A,d,this.smpLabelFont,e,"right","middle"),["Smp-"+o])}if(this.smpLabelDescription){var k=this.shortenText(this.data.x[this.smpLabelDescription][o],this.maxSmpStringLen);this.drawText(k,C,d,this.smpLabelFont,e,"left","middle")}d+=this.rowBlockSize}}var w=this.colBlockSize/2;D=u+w;if(this.varTitleLabelOverlayPosition!="bottom"){var x=Math.abs(this.varLabelRotate)==90?"center":"left";d=p;d-=(this.margin+this.getVarOverlaysHeight());c=p+this.y+this.margin;for(var y=0;y<this.varIndices.length;y++){var o=this.varIndices[y];var s=this.shortenText(this.data.y.vars[o],this.maxVarStringLen);var e=this.getVarColor(this.data.y.vars[o]);if(this.varLabelRotate){this.addArea(this.drawText(s,D,d,this.varLabelFont,e,x,"middle",-Math.PI/2+(this.varLabelRotate*Math.PI/180)),["Var-"+o])}else{this.addArea(this.drawText(s,D,d,this.varLabelFont,e,"left","middle",-Math.PI/2),["Var-"+o])}if(this.varLabelDescription){var s=this.shortenText(this.data.z[this.varLabelDescription][o],this.maxVarStringLen);this.drawText(s,D,c,this.varLabelFont,e,"right","middle",-Math.PI/2)}D+=this.colBlockSize}}else{var x=Math.abs(this.varLabelRotate)==90?"center":"right";d=p+this.y+this.margin;if(this.varOverlays.length>0){d+=(this.varOverlays.length*this.overlaysWidth)+this.margin}c=p-this.margin;for(var y=0;y<this.varIndices.length;y++){var o=this.varIndices[y];var s=this.shortenText(this.data.y.vars[o],this.maxVarStringLen);var e=this.getVarColor(this.data.y.vars[o]);if(this.varLabelRotate){this.addArea(this.drawText(s,D,d+this.margin,this.varLabelFont,e,x,"middle",-Math.PI/2+(this.varLabelRotate*Math.PI/180)),["Var-"+o])}else{this.addArea(this.drawText(s,D,d,this.varLabelFont,e,"right","middle",-Math.PI/2),["Var-"+o])}if(this.varLabelDescription){var s=this.shortenText(this.data.z[this.varLabelDescription][o],this.maxVarStringLen);this.drawText(s,D,c,this.varLabelFont,e,"left","middle",-Math.PI/2)}D+=this.colBlockSize}}if(this.varTitle){var r=(parseInt(this.varTitleFontSize*this.varTitleScaleFontFactor))+"Pt "+this.fontName;D=u+(this.x/2);if(this.varTitleLabelOverlayPosition!="bottom"){d=this.offsetY+(this.margin*2)+this.top;d-=this.getVariableLabelLength();d-=this.getVarOverlaysHeight();if(this.varDendrogramPosition=="top"){d-=this.getVarTreeHeight()}}else{d=(p+this.y+this.bottom)-this.margin}this.drawText(this.varTitle,D,d,r,this.varTitleColor,"center","bottom")}}else{if(this.graphType=="BarLine"&&this.data.a&&this.data.y.desc[1]){var a=this.getVariablesVisibleByAxis("xAxis");z=a.length}else{if(this.graphType.match(/Stacked|Line|Area/)){z=1}else{z=this.varIndices.length}}m=z*this.rowBlockSize;if(this.graphOrientation=="vertical"){var x=Math.abs(this.smpLabelRotate)==90?"center":"right";if(this.isGraphTime){var h=(this.x-this.blockSeparation)/g.length;var w=h/2;var n=this.graphType.match(/Area/)?0:u+(this.blockSeparation*0.5)+w;d=p+this.y+this.getSmpOverlaysLength()+this.margin+this.margin;for(var y=0;y<this.timeValueIndices.length;y++){D=(this.timeValueIndices[y]*h)+n;if(this.smpHairline){if(this.smpLabelRotate){this.addArea(this.drawText(this.timeValues[y],D,d+this.margin,this.smpLabelFont,e,x,"middle",-Math.PI/2+(this.smpLabelRotate*Math.PI/180)),["Smp-"+y])}else{this.addArea(this.drawText(this.timeValues[y],D,d,this.smpLabelFont,e,"right","middle",-Math.PI/2),["Smp-"+y])}}}}else{D=this.graphType.match(/Area/)?u:u+this.blockSeparation+(m/2);d=p;c=p+this.y;b=c+this.getSmpOverlaysLength()+this.margin+this.margin;for(var y=0;y<g.length;y++){var o=g[y];var k=this.shortenText(q[o],this.maxSmpStringLen);var e=this.getSmpColor(q[o]);if(this.smpLabelRotate){this.addArea(this.drawText(k,D,b+this.margin,this.smpLabelFont,e,x,"middle",-Math.PI/2+(this.smpLabelRotate*Math.PI/180)),["Smp-"+o])}else{this.addArea(this.drawText(k,D,b,this.smpLabelFont,e,"right","middle",-Math.PI/2),["Smp-"+o])}D+=this.blockSeparation+m}}}else{if(this.isGraphTime){var h=(this.y-this.blockSeparation)/g.length;var w=h/2;var n=this.graphType.match(/Area/)?0:p+(this.blockSeparation*0.5)+w;D=(u)-(this.margin*2);for(var y=0;y<this.timeValueIndices.length;y++){d=(this.timeValueIndices[y]*h)+n;if(this.smpLabelRotate){this.addArea(this.drawText(this.timeValues[y],D-this.margin,d,this.smpLabelFont,e,x,"middle",this.smpLabelRotate*Math.PI/180),["Smp-"+y])}else{this.addArea(this.drawText(this.timeValues[y],D,d,this.smpLabelFont,e,"right","middle"),["Smp-"+y])}}}else{D=u;C=u+this.x;B=D-(this.getSmpOverlaysLength()+(this.margin*2));d=this.graphType.match(/Area/)?p:p+this.blockSeparation+(m/2);for(var y=0;y<g.length;y++){var o=g[y];var k=this.shortenText(q[o],this.maxSmpStringLen);var e=this.getSmpColor(q[o]);if(this.smpLabelRotate){this.addArea(this.drawText(k,B-this.margin,d,this.smpLabelFont,e,x,"middle",this.smpLabelRotate*Math.PI/180),["Smp-"+o])}else{this.addArea(this.drawText(k,B,d,this.smpLabelFont,e,"right","middle"),["Smp-"+o])}d+=this.blockSeparation+m}}}}}if(this.showOverlays){if(this.smpOverlays.length>0&&!this.isGroupedData){m=z*this.rowBlockSize;if(this.graphOrientation=="vertical"){D=u;C=m;c=this.overlaysWidth;if(this.graphType!="Heatmap"){D+=this.blockSeparation/2;C+=this.blockSeparation}for(var y=0;y<this.smpIndices.length;y++){d=p+this.y+this.margin;for(var v=0;v<this.smpOverlays.length;v++){this.rectangle(D,d,C,c,this.smpOverlayColors[v][y]);if(m>this.overlaysWidth){this.drawText(this.data.x[this.smpOverlays[v]][this.smpIndices[y]],D+(C/2),d+(c/2),this.overlayFont,this.overlayFontColor,"center","middle",false,m-2)}else{this.drawText(this.data.x[this.smpOverlays[v]][this.smpIndices[y]],D+(C/2),d+(c/2),this.overlayFont,this.overlayFontColor,"center","middle",-Math.PI/2,this.overlaysWidth-2)}d+=c}D+=C}D=u+this.x;d=p+this.y+this.margin+(c/2);for(var y=0;y<this.smpOverlays.length;y++){this.drawText(this.smpOverlays[y],D,d,this.overlayFont,this.overlayFontColor,"left","middle",false,m*2);d+=c}}else{C=this.overlaysWidth;d=p;c=m;if(this.graphType!="Heatmap"){d+=this.blockSeparation/2;c+=this.blockSeparation}for(var y=0;y<this.smpIndices.length;y++){D=u-(this.margin+(this.smpOverlays.length*this.overlaysWidth)+this.margin);for(var v=0;v<this.smpOverlays.length;v++){this.rectangle(D,d,C,c,this.smpOverlayColors[v][y]);if(m>this.overlaysWidth){this.drawText(this.data.x[this.smpOverlays[v]][this.smpIndices[y]],D+(C/2),d+(c/2),this.overlayFont,this.overlayFontColor,"center","middle",-Math.PI/2,m-2)}else{this.drawText(this.data.x[this.smpOverlays[v]][this.smpIndices[y]],D+(C/2),d+(c/2),this.overlayFont,this.overlayFontColor,"center","middle",false,this.overlaysWidth-2)}D+=C}d+=c}D=(u+(C/2))-(this.margin+(this.smpOverlays.length*this.overlaysWidth)+this.margin);d=p+this.y;if(this.graphType=="Heatmap"){d+=this.margin}for(var y=0;y<this.smpOverlays.length;y++){this.drawText(this.smpOverlays[y],D,d,this.overlayFont,this.overlayFontColor,"right","middle",-Math.PI/2,m*2);D+=C}}}if(this.varOverlays.length>0&&this.graphType=="Heatmap"){D=u+(this.colBlockSize/2);c=this.overlaysWidth;for(var y=0;y<this.varIndices.length;y++){if(this.varTitleLabelOverlayPosition!="bottom"){d=p-(this.margin+this.overlaysWidth)}else{d=p+this.y+this.margin}for(var v=0;v<this.varOverlays.length;v++){this.rectangle(D-(this.colBlockSize/2),d,this.colBlockSize,c,this.varOverlayColors[v][y]);if(this.colBlockSize>this.overlaysWidth){this.drawText(this.data.z[this.varOverlays[v]][this.varIndices[y]],D,d+(c/2),this.overlayFont,this.overlayFontColor,"center","middle",false,this.colBlockSize-2)}else{this.drawText(this.data.z[this.varOverlays[v]][this.varIndices[y]],D,d+(c/2),this.overlayFont,this.overlayFontColor,"center","middle",-Math.PI/2,this.overlaysWidth-2)}d+=this.overlaysWidth}D+=this.colBlockSize}D=u+this.x+this.margin;if(this.varTitleLabelOverlayPosition!="bottom"){d=(p+(c/2))-(this.margin+this.overlaysWidth)}else{d=p+this.y+this.margin+(c/2)}for(var y=0;y<this.varOverlays.length;y++){this.drawText(this.varOverlays[y],D,d,this.overlayFont,this.overlayFontColor,"left","middle",false,this.colBlockSize*2);d+=c}}}};this.draw1DXLayout=function(){var d=this.marginLeft+this.offsetX+this.left;var m=this.marginTop+this.offsetY+this.top;if(!this.layoutValid){this.layoutAxis=3}if(this.graphType=="Heatmap"){var b=(d+(this.x/2))-(this.heatmapColors.length*this.indicatorWidth/2);var k=m-this.getHeatmapIndicatorHeight();if(this.varDendrogramPosition=="top"){k-=this.getVarTreeHeight()}if(this.varTitleLabelOverlayPosition!="bottom"){k-=this.getVariableTitleHeight();k-=this.getVariableLabelLength();k-=this.getVarOverlaysHeight()}else{k-=this.getVariableLabelDescLength()}this.drawColorIndicator(b,k,this.minData,this.maxData,this.xAxisDecs)}else{var f;var j;if(this.graphOrientation=="vertical"){if(this.layoutAxis==1||this.layoutAxis==3){var b=this.marginLeft+this.offsetX+this.margin+(this.getFontPt(this.axisTitleFont)/2);var k=m+(this.y/2);f=this.graphType=="Candlestick"&&this.summaryType=="volume"?this.xAxis2Title:this.xAxisTitle?this.xAxisTitle:this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:this.yAxisTitle?this.yAxisTitle:"";if(this.graphType=="BarLine"&&this.data.a&&this.data.y.desc&&this.data.y.desc[1]){this.drawText(f+" (Bars)",b,k,this.axisTitleFont,this.axisTitleColor,"center","middle",-Math.PI/2)}else{if(this.graphType=="AreaLine"&&this.data.a&&this.data.y.desc&&this.data.y.desc[1]){this.drawText(f+" (Area)",b,k,this.axisTitleFont,this.axisTitleColor,"center","middle",-Math.PI/2)}else{this.drawText(f,b,k,this.axisTitleFont,this.axisTitleColor,"center","middle",-Math.PI/2)}}var g=Math.abs(this.tickRotate)==90?"center":"right";j=this.graphType=="Candlestick"&&this.summaryType=="volume"?this.xAxis2Values:this.xAxisValues;b=d-(this.margin*2);for(var e=0;e<j.length-1;e++){var c=parseFloat(j[e]);var h=this.formatAxisValue(c,"xAxis");k=this.graphType=="Candlestick"&&this.summaryType=="volume"?m+this.y-((c-this.xAxis2Min)*this.xAxis2Unit):m+this.y-((c-this.xAxisMin)*this.xAxisUnit);if(this.tickRotate){this.drawText(h,b,k,this.axisTickFont,this.axisTickColor,g,"middle",this.tickRotate*Math.PI/180)}else{this.drawText(h,b,k,this.axisTickFont,this.axisTickColor,"right","middle")}}}if(this.layoutAxis==2||this.layoutAxis==3){var g=Math.abs(this.tickRotate)==90?"center":"left";b=d+this.x+(this.margin*2);if(this.graphType.match(/BarLine|AreaLine|StackedLine|StackedPercentLine/)&&this.data.a&&this.data.y.desc&&this.data.y.desc[1]){for(var e=0;e<this.xAxis2Values.length-1;e++){var c=parseFloat(this.xAxis2Values[e]);var h=this.formatAxisValue(c,"xAxis2");k=m+this.y-((c-this.xAxis2Min)*this.xAxis2Unit);if(this.tickRotate){this.drawText(h,b,k,this.axisTickFont,this.axisTickColor,g,"middle",this.tickRotate*Math.PI/180)}else{this.drawText(h,b,k,this.axisTickFont,this.axisTickColor,"left","middle")}}if(this.graphType.match(/Stacked/)){f=this.data.y.desc&&this.data.y.desc[1]?this.data.y.desc[1]:""}else{f=this.data.y.desc&&this.data.y.desc[1]?this.data.y.desc[1]+" (Lines)":""}}else{j=this.graphType=="Candlestick"&&this.summaryType=="volume"?this.xAxis2Values:this.xAxisValues;for(var e=0;e<j.length-1;e++){var c=parseFloat(j[e]);var h=this.formatAxisValue(c,"xAxis");k=this.graphType=="Candlestick"&&this.summaryType=="volume"?m+this.y-((c-this.xAxis2Min)*this.xAxis2Unit):m+this.y-((c-this.xAxisMin)*this.xAxisUnit);if(this.tickRotate){this.drawText(h,b,k,this.axisTickFont,this.axisTickColor,g,"middle",this.tickRotate*Math.PI/180)}else{this.drawText(h,b,k,this.axisTickFont,this.axisTickColor,"left","middle")}}f=this.graphType=="Candlestick"&&this.summaryType=="volume"?this.xAxis2Title:this.xAxisTitle?this.xAxisTitle:this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:this.yAxisTitle?this.yAxisTitle:""}b=(d+this.x+this.right)-(this.margin+(this.getFontPt(this.axisTitleFont)/2));if(this.showLegend&&this.legendPosition=="right"){b-=this.getLegendWidth()}k=m+(this.y/2);this.drawText(f,b,k,this.axisTitleFont,this.axisTitleColor,"center","middle",-Math.PI/2)}}else{if(this.layoutAxis==1||this.layoutAxis==3){var b=d+(this.x/2);var k=m-((this.margin*4)+this.getFontPt(this.axisTickFont)+(this.getFontPt(this.axisTitleFont)/2));f=this.graphType=="Candlestick"&&this.summaryType=="volume"?this.xAxis2Title:this.xAxisTitle?this.xAxisTitle:this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:this.yAxisTitle?this.yAxisTitle:"";if(this.graphType=="BarLine"&&this.data.a&&this.data.y.desc&&this.data.y.desc[1]){this.drawText(f+" (Bars)",b,k,this.axisTitleFont,this.axisTitleColor,"center","middle")}else{if(this.graphType=="AreaLine"&&this.data.a&&this.data.y.desc&&this.data.y.desc[1]){this.drawText(f+" (Area)",b,k,this.axisTitleFont,this.axisTitleColor,"center","middle")}else{this.drawText(f,b,k,this.axisTitleFont,this.axisTitleColor,"center","middle")}}j=this.graphType=="Candlestick"&&this.summaryType=="volume"?this.xAxis2Values:this.xAxisValues;k=m-((this.margin*2)+(this.getFontPt(this.axisTickFont)/2));for(var e=0;e<j.length-1;e++){var c=parseFloat(j[e]);var h=this.formatAxisValue(c,"xAxis");b=this.graphType=="Candlestick"&&this.summaryType=="volume"?d+((c-this.xAxis2Min)*this.xAxis2Unit):d+((c-this.xAxisMin)*this.xAxisUnit);if(this.tickRotate){this.drawText(h,b,k,this.axisTickFont,this.axisTickColor,"center","middle",this.tickRotate*Math.PI/180)}else{this.drawText(h,b,k,this.axisTickFont,this.axisTickColor,"center","middle")}}}if(this.layoutAxis==2||this.layoutAxis==3){k=m+this.y+(this.margin*2)+(this.getFontPt(this.axisTickFont)/2);if(this.graphType.match(/BarLine|AreaLine|StackedLine|StackedPercentLine/)&&this.data.a&&this.data.y.desc&&this.data.y.desc[1]){for(var e=0;e<this.xAxis2Values.length-1;e++){var c=parseFloat(this.xAxis2Values[e]);var h=this.formatAxisValue(c,"xAxis2");b=d+((c-this.xAxis2Min)*this.xAxis2Unit);this.drawText(h,b,k,this.axisTickFont,this.axisTickColor,"center","middle")}if(this.graphType.match(/Stacked/)){f=this.data.y.desc&&this.data.y.desc[1]?this.data.y.desc[1]:""}else{f=this.data.y.desc&&this.data.y.desc[1]?this.data.y.desc[1]+" (Lines)":""}}else{j=this.graphType=="Candlestick"&&this.summaryType=="volume"?this.xAxis2Values:this.xAxisValues;for(var e=0;e<j.length-1;e++){var c=parseFloat(j[e]);var h=this.formatAxisValue(c,"xAxis");b=this.graphType=="Candlestick"&&this.summaryType=="volume"?d+((c-this.xAxis2Min)*this.xAxis2Unit):d+((c-this.xAxisMin)*this.xAxisUnit);if(this.tickRotate){this.drawText(h,b,k,this.axisTickFont,this.axisTickColor,"center","middle",this.tickRotate*Math.PI/180)}else{this.drawText(h,b,k,this.axisTickFont,this.axisTickColor,"center","middle")}}f=this.graphType=="Candlestick"&&this.summaryType=="volume"?this.xAxis2Title:this.xAxisTitle?this.xAxisTitle:this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:this.yAxisTitle?this.yAxisTitle:""}b=d+(this.x/2);k=m+this.y+(this.margin*4)+this.getFontPt(this.axisTickFont)+(this.getFontPt(this.axisTitleFont)/2);this.drawText(f,b,k,this.axisTitleFont,this.axisTitleColor,"center","middle")}}var a=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;this.rectangle(d,m,this.x,this.y,false,a,"open",false,this.outlineWidth)}};this.draw1DDataPoints=function(){switch(this.graphType){case"Bar":this.draw1DBarDataPoints(this.varIndices,"xAxis");return true;case"Line":this.draw1DLineDataPoints(this.varIndices,"xAxis");return true;case"BarLine":this.draw1DBarDataPoints(this.xAxisVarIndices,"xAxis");this.draw1DLineDataPoints(this.xAxis2VarIndices,"xAxis2");return true;case"Stacked":case"StackedPercent":this.draw1DStackedDataPoints();return true;case"StackedLine":case"StackedPercentLine":this.draw1DStackedDataPoints();this.draw1DLineDataPoints(this.xAxis2VarIndices,"xAxis2");return true;case"Area":this.draw1DAreaDataPoints(this.varIndices,"xAxis");return true;case"AreaLine":this.draw1DAreaDataPoints(this.xAxisVarIndices,"xAxis");this.draw1DAreaDataPoints(this.xAxis2VarIndices,"xAxis2",true);return true;case"Boxplot":this.draw1DBoxplotDataPoints();return true;case"Candlestick":this.draw1DCandlestickDataPoints();return true;case"Dotplot":this.draw1DDotplotDataPoints();return true;case"Heatmap":this.draw1DHeatmapDataPoints();return true}throw'Illegal graph type "'+this.graphType+'"'};this.draw1DBarDataPoints=function(y,w){var b=this.isGroupedData?this.grpIndices:this.smpIndices;var B=b.length;var r=this.xAxisMin<0?Math.abs(this.xAxisMin)*this.xAxisUnit:0;var g=this.marginLeft+this.offsetX+this.left;var A=this.marginTop+this.offsetY+this.top;var f=this.blockSeparation+(this.rowBlockSize*y.length);if(this.graphOrientation=="vertical"){g+=this.blockSeparation;A=(A+this.y)-r}else{g+=r;A+=this.blockSeparation}for(var k=0;k<y.length;k++){var p=[];var o=[];var q=[];var u=[];for(var h=0;h<B;h++){q.push(this.colorBy&&this.legendColorsN?this.dataColors[h]:this.colors[k%this.colors.length]);p.push(this.getDataAtPos(y[k],b[h]));if(this.isGroupedData||this.data.y.hasOwnProperty("stdev")){o.push(this.getDataAtPos(y[k],b[h],"stdev"))}u.push([y[k],b[h]])}this.drawBarPlot(p,o,g,A,this.rowBlockSize,f,this[w+"Unit"],r,this[w+"Min"],this.graphOrientation,q,u);if(this.graphOrientation=="vertical"){g+=this.rowBlockSize}else{A+=this.rowBlockSize}}};this.draw1DLineDataPoints=function(D,C){var h=this.isGroupedData?this.grpIndices:this.smpIndices;var F=h.length;var q=this.marginLeft+this.offsetX+this.left;var E=this.marginTop+this.offsetY+this.top;var b=this.graphType=="BarLine"?true:false;var g=b?this.blockSeparation+(this.xAxisVarIndices.length*this.rowBlockSize):this.blockSeparation+this.rowBlockSize;var k=this.blockSeparation+(this.rowBlockSize/2);if(this.graphOrientation=="vertical"){q+=k;E+=this.y}else{E+=k}for(var w=0;w<D.length;w++){var z=[];var y=[];var A=this.coordinateLineColor?this.colors[w%this.colors.length]:this.colors[(w+D.length)%this.colors.length];var f=this.lineDecoration=="symbol"?this.shapes[w%this.shapes.length]:"sphere";var B=[];for(var u=0;u<F;u++){z.push(this.getDataAtPos(D[w],h[u]));if(this.isGroupedData||this.data.y.hasOwnProperty("stdev")){y.push(this.getDataAtPos(D[w],h[u],"stdev"))}B.push([D[w],h[u]])}this.drawLinePlot(z,y,q,E,this.rowBlockSize,g,this[C+"Unit"],this[C+"Min"],this.graphOrientation,A,f,B);if(b&&this.xAxisVarIndices.length==this.xAxis2VarIndices.length){if(this.graphOrientation=="vertical"){q+=this.rowBlockSize}else{E+=this.rowBlockSize}}}};this.draw1DStackedDataPoints=function(){var e=this.isGroupedData?this.grpIndices:this.smpIndices;var B=e.length;var h=this.marginLeft+this.offsetX+this.left;var A=this.marginTop+this.offsetY+this.top;var f=this.blockSeparation+this.rowBlockSize;var z=this.graphType.match(/Line/)?this.xAxisVarIndices:this.varIndices;var y=this.graphType=="StackedPercentLine"?this.xAxisVarIndices:false;var b=this.graphType.match(/Percent/)?true:false;if(this.graphOrientation=="vertical"){h+=this.blockSeparation;A+=this.y}else{A+=this.blockSeparation}for(var o=0;o<B;o++){var q=this.sum(this.getDataForSmpGrpAtIndex(e[o],y));var r=[];var u=[];var x=[];for(var k=0;k<z.length;k++){r.push(this.getDataAtPos(z[k],e[o]));u.push(this.colors[k%this.colors.length]);x.push([z[k],e[o]])}this.drawStackedPlot(r,h,A,this.rowBlockSize,b,q,this.xAxisUnit,this.graphOrientation,u,x);if(this.graphOrientation=="vertical"){h+=f}else{A+=f}}};this.draw1DAreaDataPoints=function(B,A,p){var e=this.isGroupedData?this.grpIndices:this.smpIndices;var D=e.length;var h=this.marginLeft+this.offsetX+this.left;var C=this.marginTop+this.offsetY+this.top;var g=this.rowBlockSize+this.blockSeparation;var r=[];var w=[];var y=[];if(this.graphOrientation=="vertical"){C+=this.y}for(var o=0;o<B.length;o++){var u=[];var b=!this.coordinateLineColor&&A=="xAxis2"?this.colors[(o+B.length)%this.colors.length]:this.colors[(o+this[A].length)%this.colors.length];for(var k=0;k<D;k++){u.push(this.getDataAtPos(B[o],e[k]))}r.push(u);w.push(b);y.push([B[o]])}this.drawAreaPlot(r,h,C,this.x,this.y,g,this[A+"Unit"],this[A+"Min"],this.graphOrientation,p,w,y)};this.draw1DBoxplotDataPoints=function(){var e=this.isGroupedData?this.grpIndices:this.smpIndices;var B=e.length;var y=this.varIndices;var g=this.marginLeft+this.offsetX+this.left;var A=this.marginTop+this.offsetY+this.top;var f=this.blockSeparation+(this.rowBlockSize*y.length);if(this.graphOrientation=="vertical"){g+=this.blockSeparation;A+=this.y}else{A+=this.blockSeparation}for(var p=0;p<y.length;p++){var q=[];var w=this.colors[p%this.colors.length];var x=[];for(var o=0;o<B;o++){var b=["iqr1","iqr3","qtl1","qtl3","median","out"];var u=[];for(var h=0;h<y.length;h++){u.push(this.getDataAtPos(y[p],e[o],b[h]))}q.push(u);x.push([y[p],e[o]])}this.drawBoxPlot(q,g,A,this.rowBlockSize,f,this.xAxisUnit,this.xAxisMin,this.graphOrientation,w,x);if(this.graphOrientation=="vertical"){g+=this.rowBlockSize}else{A+=this.rowBlockSize}}};this.draw1DCandlestickDataPoints=function(){var B=this.isGroupedData?this.grpIndices:this.smpIndices;var w=B.length;var g=this.varIndices;var D=this.marginLeft+this.offsetX+this.left;var q=this.marginTop+this.offsetY+this.top;var C=this.blockSeparation+(this.rowBlockSize*g.length);var A=this.summaryType=="candle"?true:false;var o=A?this.xAxisUnit:this.xAxis2Unit;var f=A?this.xAxisMin:this.xAxis2Min;var H=this.rowBlockSize/2;if(this.graphOrientation=="vertical"){D+=this.blockSeparation;q+=this.y}else{q+=this.blockSeparation}for(var G=0;G<g.length;G++){var I=[];var J=this.colors[G%this.colors.length];var L=[];for(var F=0;F<w;F++){var y=A?["open","close","high","low"]:["volume"];var e=[];for(var E=0;E<y.length;E++){e.push(this.getDataAtPos(g[G],B[F],y[E]))}I.push(e);L.push([g[G],B[F]])}this.drawCandlestickPlot(I,D,q,this.rowBlockSize,C,o,f,A,this.graphOrientation,J,L);if(this.stockIndicators.length>0){for(var F=0;F<this.stockIndicators.length;F++){var K=this.getTechnicalIndicatorColor(this.stockIndicators[F]);var I=[];for(var E=0;E<w;E++){I.push(this.getDataAtPos(g[G],B[E],this.stockIndicators[F]))}if(this.graphOrientation=="vertical"){this.drawLinePlot(I,[],D+H,q,this.rowBlockSize,C,o,f,this.graphOrientation,K,false,[])}else{this.drawLinePlot(I,[],D,q+H,this.rowBlockSize,C,o,f,this.graphOrientation,K,false,[])}}}if(this.graphOrientation=="vertical"){D+=this.rowBlockSize}else{q+=this.rowBlockSize}}};this.draw1DDotplotDataPoints=function(){var h=this.isGroupedData?this.grpIndices:this.smpIndices;var H=h.length;var F=this.varIndices;var r=this.marginLeft+this.offsetX+this.left;var G=this.marginTop+this.offsetY+this.top;var D=this.blockSeparation+(this.rowBlockSize/2);var o=this.blockSeparation+(this.rowBlockSize*F.length);var f=this.getShapeSize();if(this.graphOrientation=="vertical"){r+=D;G+=this.y}else{G+=D}for(var x=0;x<F.length;x++){var A=[];var y=[];var C=this.colors[x%this.colors.length];var g=this.shapes[parseInt(x/this.colors.length)];var E=[];for(var w=0;w<H;w++){if(this.isGroupedData){var B=[];for(var u=0;u<this.data.w.grps[h[w]].length;u++){B.push(this.data.y.data[F[x]][this.data.w.grps[h[w]][u]])}A.push(B)}else{A.push([this.getDataAtPos(F[x],h[w])]);if(this.data.y.hasOwnProperty("stdev")){y.push(this.getDataAtPos(F[x],h[w],"stdev"))}}E.push([F[x],h[w]])}this.drawDotPlot(A,y,r,G,this.rowBlockSize,this.blockSeparation,o,this.xAxisUnit,this.xAxisMin,f,this.graphOrientation,C,g,E);if(this.graphOrientation=="vertical"){r+=this.rowBlockSize}else{G+=this.rowBlockSize}}};this.draw1DHeatmapDataPoints=function(){var b=this.isGroupedData?this.grpIndices:this.smpIndices;var p=b.length;var c=this.marginLeft+this.offsetX+this.left;var o=this.marginTop+this.offsetY+this.top;var h=this.varIndices.length*5>this.x?true:false;for(var g=0;g<p;g++){var k=[];var m=[];for(var f=0;f<this.varIndices.length;f++){k.push(this.getDataAtPos(this.varIndices[f],b[g]));m.push([this.varIndices[f],b[g]])}this.drawHeatmap(k,c,o,this.colBlockSize,this.rowBlockSize,this.minData,this.maxData,h,m);o+=this.rowBlockSize}};this.drawStockIndicatorsLegend=function(){var d=this.marginLeft+this.offsetX+this.left;var n=this.marginTop+this.offsetY+this.top;if(this.summaryType=="candle"&&this.stockIndicators.length>0){var a=this.getFontPt(this.legendFont);var f=a/2;var b=this.measureText(this.getMaxText(this.stockIndicators),this.legendFont)+a+(this.margin*2);var k=this.graphOrientation=="vertical"?d+(this.margin*2):d+this.x-b;var j=n+this.margin+a;for(var e=0;e<this.stockIndicators.length;e++){var g=this.getTechnicalIndicatorColor(this.stockIndicators[e]);this.drawLine("line",k+f,j+f,k+f+a,j+f,g,false,"butt",false,false,true);this.drawText(this.stockIndicators[e],k+a+this.margin,j+f,this.legendFont,g,"left","middle");j+=this.margin+a}}};this.draw1DLegend=function(){var f=this.marginLeft+this.offsetX+this.left;var w=this.marginTop+this.offsetY+this.top;var q=this.getFontPt(this.legendFont);var j=q/2;var o=q*2;if(this.layoutValid){if(this.legendPosition=="bottom"){w+=this.margin}else{f+=this.margin}}this.drawStockIndicatorsLegend();if(this.showLegend&&this.graphType!="Heatmap"){if(this.colorBy&&this.graphType=="Bar"){if(this.legendPosition=="right"){if(this.legendColorsN>0){f=(f+this.x+this.right)-(this.legendColorWidth+this.margin);w+=(this.y-this.legendColorHeight)/2;this.drawColorLegend(f,w)}else{f=(f+this.x+this.right)-this.legendColorIndicatorHeight;w+=((this.y-this.legendColorIndicatorWidth)/2)+this.legendColorIndicatorWidth;this.drawColorIndicator(f,w,this.legendColorRange[0],this.legendColorRange[1],this.legendColorDecs)}}else{if(this.legendColorsN>0){f+=(this.x-this.legendColorWidth)/2;w=(w+this.y+this.bottom)-(this.legendColorHeight+this.margin);this.drawColorLegend(f,w)}else{f+=((this.x-this.legendColorIndicatorWidth)/2);w=(w+this.y+this.bottom)-this.legendColorIndicatorHeight;this.drawColorIndicator(f,w,this.legendColorRange[0],this.legendColorRange[1],this.legendColorDecs)}}}else{if(this.graphType=="BarLine"||this.graphType=="AreaLine"||this.graphType=="StackedLine"||this.graphType=="StackedPercentLine"){var x=this.maxVarName>this.maxVarStringLen?this.maxVarNameStr.substring(0,this.maxVarStringLen):this.maxVarNameStr;var e=this.legendPosition=="right"?f+this.x+(this.margin*4):(f+(this.x/2))-((this.measureText(x,this.legendFont)+q)/2);var u=this.legendPosition=="right"?(w+(this.y/2))-(this.getLegendHeight(true)/2):w+this.y;if(this.smpDendrogramPosition=="right"){e+=this.getSmpTreeWidthHeight()}if(this.legendPosition=="bottom"){if(this.graphOrientation=="vertical"){u+=this.getSampleTitleHeight()+this.getSampleLabelLength()+this.getSmpOverlaysLength()+this.margin}else{u+=this.getAxisTitleTickLength()+this.margin}if(this.showSmpDendrogram&&this.smpDendrogramPosition=="bottom"){u+=this.getSmpTreeWidthHeight()}}else{if(this.graphOrientation=="vertical"){e+=this.getAxisTitleTickLength()}}var r=u-this.margin;if(this.legendBox&&this.legendBackgroundColor){var x=this.maxVarName>this.maxVarStringLen?this.maxVarNameStr.substring(0,this.maxVarStringLen):this.maxVarNameStr;var n=((this.xAxisVarIndices.length+this.xAxis2VarIndices.length)*q*1.5)+this.margin;var d=(this.margin*3)+o+this.measureText(x,this.legendFont);this.rectangle(e-this.margin*2,r,d,n,this.legendBackgroundColor,this.legendBoxColor)}for(var g=0;g<this.xAxisVarIndices.length;g++){var v=this.xAxisVarIndices[g];var m=this.colors[g%this.colors.length];var x=this.shortenText(this.data.y.vars[v],this.maxVarStringLen);this.addArea(this.rectangle(e,u,q,q,m,m),["Var-"+v]);this.addArea(this.drawText(x,e+o,u+j,this.legendFont,this.getVarColor(this.data.y.vars[v]),"left","middle"),["Var-"+v]);u+=q*1.5}for(var g=0;g<this.xAxis2VarIndices.length;g++){var v=this.xAxis2VarIndices[g];var m=this.coordinateLineColor?this.colors[g%this.colors.length]:this.colors[(g+this.xAxisVarIndices.length)%this.colors.length];var x=this.shortenText(this.data.y.vars[v],this.maxVarStringLen);var k=this.getFontPt(this.legendFont)/2;if(this.lineDecoration){if(this.lineDecoration=="symbol"){this.drawLine("line",e,u+j,e+q,u+j,m);this.addArea(this.drawShape(this.shapes[g%this.shapes.length],e+j,u+j,k,k,m,m),["Var-"+v])}else{if(this.lineDecoration=="dot"){this.drawLine("line",e,u+j,e+q,u+j,m);this.addArea(this.drawShape("circle",e+j,u+j,k,k,m,m),["Var-"+v])}}}else{this.addArea(this.drawLine("line",e,u+j,e+q,u+j,m),["Var-"+v])}this.addArea(this.drawText(x,e+o,u+j,this.legendFont,this.getVarColor(this.data.y.vars[v]),"left","middle"),["Var-"+v]);u+=q*1.5}if(this.legendBox){var x=this.maxVarName>this.maxVarStringLen?this.maxVarNameStr.substring(0,this.maxVarStringLen):this.maxVarNameStr;var n=((u-r)-j)+this.margin;var d=(this.margin*3)+o+this.measureText(x,this.legendFont);this.rectangle(e-this.margin*2,r,d,n,false,this.legendBoxColor,"open")}}else{var x=this.maxVarName>this.maxVarStringLen?this.maxVarNameStr.substring(0,this.maxVarStringLen):this.maxVarNameStr;var e=this.legendPosition=="right"?f+this.x+(this.margin*4):(f+(this.x/2))-((this.measureText(x,this.legendFont)+q)/2);var u=this.legendPosition=="right"?(w+(this.y/2))-(this.getLegendHeight(true)/2):w+this.y;if(this.legendPosition=="bottom"){if(this.graphOrientation=="vertical"){u+=this.getSampleTitleHeight()+this.getSampleLabelLength()+this.getSmpOverlaysLength()+this.margin}else{u+=this.getAxisTitleTickLength()+this.margin}if(this.showSmpDendrogram&&this.smpDendrogramPosition=="bottom"){u+=this.getSmpTreeWidthHeight()}}else{if(this.graphOrientation=="vertical"){e+=this.getAxisTitleTickLength()}}if(this.smpDendrogramPosition=="right"&&this.showLegend&&this.legendPosition=="right"){e+=this.getSmpTreeWidthHeight()}var r=u-this.margin;if(this.legendBox&&this.legendBackgroundColor){var x=this.maxVarName>this.maxVarStringLen?this.maxVarNameStr.substring(0,this.maxVarStringLen):this.maxVarNameStr;var n=((this.varIndices.length*q*1.5))+this.margin;var d=(this.margin*3)+o+this.measureText(x,this.legendFont);this.disableGradientTransparency();this.rectangle(e-this.margin*2,r,d,n,this.legendBackgroundColor,this.legendBoxColor);this.enableGradientTransparency()}for(var g=0;g<this.varIndices.length;g++){var v=this.varIndices[g];var m=this.colors[g%this.colors.length];var a=this.shapes[g%this.shapes.length];var x=this.shortenText(this.data.y.vars[v],this.maxVarStringLen);var k=this.getFontPt(this.legendFont)/2;if(this.graphType=="Line"){if(this.lineDecoration){if(this.lineDecoration=="symbol"){this.drawLine("line",e,u+j,e+q,u+j,m);this.addArea(this.drawShape(a,e+j,u+j,k,k,m,m),["Var-"+v])}else{if(this.lineDecoration=="dot"){this.drawLine("line",e,u+j,e+q,u+j,m);this.addArea(this.drawShape("circle",e+j,u+j,k,k,m,m),["Var-"+v])}}}else{this.addArea(this.drawLine("line",e,u+j,e+q,u+j,m),["Var-"+v])}}else{if(this.graphType=="Dotplot"){a=this.shapes[parseInt(g/this.colors.length)];this.addArea(this.drawShape(a,e+j,u+j,q,q,m,m),["Var-"+v])}else{this.addArea(this.rectangle(e,u,q,q,m,m),["Var-"+v])}}this.addArea(this.drawText(x,e+o,u+j,this.legendFont,this.getVarColor(this.data.y.vars[v]),"left","middle"),["Var-"+v]);u+=q*1.5}if(this.legendBox){var x=this.maxVarName>this.maxVarStringLen?this.maxVarNameStr.substring(0,this.maxVarStringLen):this.maxVarNameStr;var n=((u-r)-j)+this.margin;var d=(this.margin*3)+o+this.measureText(x,this.legendFont);this.rectangle(e-this.margin*2,r,d,n,false,this.legendBoxColor,"open")}}}}};this.setIndicatorsLegendPositions=function(){if(this.colorBy&&this.graphType=="Bar"){this.indicatorsPosition=this.legendPosition}};this.draw1DLayout=function(){this.drawTrees();this.draw1DXLayout();this.draw1DYLayout()};this.draw1DData=function(){this.drawPlotWindow();this.draw1DWireFrame();this.draw1DDataPoints();this.maskPlotArea();this.draw1DLayout();this.draw1DLegend();this.drawTitle()};this.draw1DPlot=function(){this.setIndicatorsLegendPositions();this.set1DAttributes();this.set1DXYDimensions();this.set1DPrivateParams();this.set1DXAxis();this.draw1DData()};this.checkSegregation=function(){if(this.graphType!="Candlestick"){if(this.data.l){if(!this.segregateSamplesBy){this.desegregateSamples(true)}else{if(!this.data.l.smps){this.segregateSamples(this.segregateSamplesBy,true)}}if(!this.segregateVariablesBy){this.desegregateVariables(true)}else{if(!this.data.l.vars){this.segregateVariables(this.segregateVariablesBy,true)}}}else{if(this.segregateSamplesBy){this.segregateSamples(this.segregateSamplesBy,true)}if(this.segregateVariablesBy){this.segregateVariables(this.segregateVariablesBy,true)}}}};this.initialize1DPlot=function(){this.checkSegregation();if(this.layoutValid){this.drawLayoutCompartments(this.draw1DPlot)}else{this.draw1DPlot()}};this.initialize1DPlot()};CanvasXpress.prototype.Network=function(){this.findXYCoordinates=function(b){var a=this.adjustedCoordinates(b);var d={};d.x=(a.x/this.scaleFactor||1)-this.offsetX;d.y=(a.y/this.scaleFactor||1)-this.offsetY;return d};this.addNode=function(d,c){if(d){if(!d.id){var a=0;var e="id"+a;while(this.nodes.hasOwnProperty(e)){a++;e="id"+a}d.id=e}if(!d.color){d.color=this.colors[0]}if(!d.shape){d.shape=this.shapes[0]}if(!d.size){d.size=1}if(c){var b=this.findXYCoordinates(c);d.x=b.x;d.y=b.y}this.data.nodeIndices[d.id]=this.data.nodes.length;this.data.nodes.push(d);this.nodes[d.id]=d;return d}};this.removeNode=function(d,k){if(d&&d.id){var a=k?this.getObjectArray(this.findChildrenNodeIndices(d.id)):false;var g=[];var b=0;if(this.nodeParentHood[d.id]){for(var h=0;h<this.nodeParentHood[d.id].children.length;h++){var l=this.nodeParentHood[d.id].children[h];delete (this.data.nodes[this.data.nodeIndices[l]].parentNode)}}this.data.nodeIndices={};for(var h=0;h<this.data.nodes.length;h++){if(this.data.nodes[h].id!=d.id){if(a&&a.hasOwnProperty(h)){var f=this.edgesForNode(this.data.edges,this.data.nodes[h].id);for(var e=0;e<f.length;e++){this.removeEdge(f[e])}}else{g.push(this.data.nodes[h]);this.data.nodeIndices[this.data.nodes[h].id]=b;b++}}else{var f=this.edgesForNode(this.data.edges,d.id);for(var e=0;e<f.length;e++){this.removeEdge(f[e])}}}this.data.nodes=g}};this.addEdge=function(a){if(a&&a.id1&&a.id2){if(!a.color){a.color=this.colors[0]}if(!a.width){a.width=1}if(!a.type){a.type="line"}this.data.edges.push(a)}};this.removeEdge=function(c){if(c&&c.id1&&c.id2){var b=[];for(var a=0;a<this.data.edges.length;a++){if(this.data.edges[a].id1!=c.id1||this.data.edges[a].id2!=c.id2){b.push(this.data.edges[a])}}this.data.edges=b}};this.getAllObjectAttributes=function(c){var d=[];if(this.data[c]){for(var b=0;b<this.data[c].length;b++){for(var a in this.data[c][b]){if(d.hasOwnProperty(a)){d[a]++}else{d[a]=1}}}}return d};this.setAllObjectAttributes=function(l,m,p,e){if(this.data[l]){var n=this.getAllObjectAttributeValues(l,p);if(n){if(this.isNumeric(n)){var j=this.range(n);if(m=="color"){this.setHeatmapColors(j[1]-j[0]);for(var g=0;g<this.data[l].length;g++){if(this.data[l][g].hasOwnProperty(p)){var d=this.data[l][g][p];var c=this.getHeatmapColor(j[0],j[1],d);this.data[l][g][m]=c}else{this.data[l][g][m]=this.missingDataColor}}}else{if(m=="size"){for(var g=0;g<this.data[l].length;g++){if(this.data[l][g].hasOwnProperty(p)){var d=this.data[l][g][p];var f=this.percentile(j[0],j[1],d);var b=parseInt(f*25/10);if(e){this.data[l][g]["decorationSize"]=1+(b/25)}else{this.data[l][g][m]=1+(b/100)}}else{if(e){this.data[l][g]["decorationSize"]=0.1}else{this.data[l][g][m]=0.1}}}}else{if(m=="shape"){if(l=="nodes"){var r="square";for(var g=0;g<this.data[l].length;g++){if(this.data[l][g].hasOwnProperty(p)){var d=this.data[l][g][p];var f=this.percentile(j[0],j[1],d);var q=parseInt(f/10);if(q>0){q--}this.data[l][g][m]="pie"+q}else{this.data[l][g][m]=r}}}else{if(l=="edges"){for(var g=0;g<this.data[l].length;g++){if(this.data[l][g].hasOwnProperty(p)){var d=this.data[l][g][p];var f=this.percentile(j[0],j[1],d);var q=parseInt(f/10);if(q>0){q--}this.data[l][g]["type"]=this.lines[q]}else{this.data[l][g]["type"]=this.lines[10]}}}}}}}}else{var o=0;var h=0;var k=0.1;var a={color:{},shape:{},size:{}};for(var g=0;g<n.length;g++){if(!a.color.hasOwnProperty(n[g])){a.color[n[g]]=this.colors[o%this.colors.length];o++}if(l=="nodes"){if(!a.shape.hasOwnProperty(n[g])){a.shape[n[g]]=this.shapes[h%this.shapes.length];h++}}else{if(!a.shape.hasOwnProperty(n[g])){a.lines[n[g]]=this.lines[h%this.lines.length];h++}}if(!a.size.hasOwnProperty(n[g])){a.size[n[g]]=k;k+=0.1}}for(var g=0;g<this.data[l].length;g++){if(this.data[l][g].hasOwnProperty(p)){var d=this.data[l][g][p];this.data[l][g][m]=a[m][d]}}}}}};this.getAllObjectAttributeValues=function(c,a){var d=[];if(this.data[c]){for(var b=0;b<this.data[c].length;b++){if(this.data[c][b].hasOwnProperty(a)){d.push(this.data[c][b][a])}}}return d};this.modifyNodeSize=function(d,a,b){var c=this.data.nodes[this.data.nodeIndices[d]];delete (c.size);c.width=a;c.height=b};this.modifyXYNode=function(g,c,a){var f=this.data.nodes[this.data.nodeIndices[g]];f.x-=c;f.y-=a;if(f.labelX!=null&&f.labelY!=null){this.modifyXYNodeLab(g,c,a)}if(this.networkLayoutType!="radial"){if(this.nodeParentHood[f.id]&&this.nodeParentHood[f.id]["children"]){for(var e=0;e<this.nodeParentHood[f.id]["children"].length;e++){var b=this.nodeParentHood[f.id]["children"][e];var d=this.data.nodes[this.data.nodeIndices[b]];this.modifyXYNode(b,c,a)}}}};this.modifyXYNodeLab=function(c,i,h){var d=this.data.nodes[this.data.nodeIndices[c]];var f=d.label!=null?d.label:d.name?d.name:d.id;var a=this.measureText(f,this.nodeFont);var g=this.nodeFontSize;var e=d.width?d.width:d.size?(this.nodeSize*d.size):this.nodeSize;var b=d.height?d.height:d.size?(this.nodeSize*d.size):this.nodeSize;if(d.labelX!=null&&d.labelY!=null){d.labelX-=i;d.labelY-=h}else{if(this.rangeX>this.rangeY){d.labelX=(d.x-(a/2))-i;d.labelY=(d.y+(b/1.3))-h}else{d.labelX=(d.x+(e/1.3))-i;d.labelY=(d.y-(g/2))-h}}};this.modifyXYNodeDec=function(d,b,a){var c=this.data.nodes[this.data.nodeIndices[d]];c.decorationsX-=b;c.decorationsY-=a};this.getHiddenNodes=function(){var b=[];if(this.data.nodes){for(var a=0;a<this.data.nodes.length;a++){if(this.data.nodes[a].hide){b.push(this.data.nodes[a])}}}return b};this.sendNodeToBack=function(c){var b=[c];for(var a=0;a<this.data.nodes.length;a++){if(this.data.nodes[a].id!=c.id){b.push(this.data.nodes[a])}}this.data.nodes=b;this.setNodeIndices()};this.sendNodeBackward=function(d){var c=[];var a=this.data.nodeIndices[d.id];if(a>0){for(var b=0;b<a-1;b++){c.push(this.data.nodes[b])}c.push(this.data.nodes[a]);c.push(this.data.nodes[a-1]);for(var b=a+1;b<this.data.nodes.length;b++){c.push(this.data.nodes[b])}this.data.nodes=c;this.setNodeIndices()}};this.bringNodeToFront=function(c){var b=[];for(var a=0;a<this.data.nodes.length;a++){if(this.data.nodes[a].id!=c.id){b.push(this.data.nodes[a])}}b.push(c);this.data.nodes=b;this.setNodeIndices()};this.bringNodeForward=function(d){var c=[];var a=this.data.nodeIndices[d.id];if(this.data.nodes.length-1>a){for(var b=0;b<a;b++){c.push(this.data.nodes[b])}c.push(this.data.nodes[a+1]);c.push(this.data.nodes[a]);for(var b=a+2;b<this.data.nodes.length;b++){c.push(this.data.nodes[b])}this.data.nodes=c;this.setNodeIndices()}};this.addToNetworkStack=function(a){if(!a){a=0}if(this.networkStack[a].length>=this.networkStackStates){this.networkStack[a].shift()}this.networkStack[a].push(this.cloneObject(this.data))};this.undoNetworkOp=function(){if(this.networkStack[0].length>0){this.addToNetworkStack(1);this.nodes={};this.updateData(this.networkStack[0].pop())}else{if(this.debug){alert("No data in Undo Stack")}}};this.canNetworkUndoOp=function(){return this.networkStack[0].length>0?true:false};this.redoNetworkOp=function(){if(this.networkStack[1].length>0){this.addToNetworkStack(0);this.nodes={};this.updateData(this.networkStack[1].pop())}else{if(this.debug){alert("No data in Redo Stack")}}};this.canNetworkRedoOp=function(){return this.networkStack[1].length>0?true:false};this.addLegend=function(a,d,c){this.inititalizeNetworkLegend();if(a&&d){if(c&&a=="text"){var b=this.findXYCoordinates(c);d.x=b.x;d.y=b.y}this.data.legend[a].push(d);return d}};this.deleteLegend=function(c,d){if(c&&d&&d.id){var b=[];for(var a=0;a<this.data.legend[c].length;a++){if(this.data.legend[c][a].id!=d.id){b.push(this.data.legend[c][a])}}this.data.legend[c]=b;delete this.data.legend.ids[c][d.id]}};this.alignDistributeSelectedNodes=function(j,b){var f,a,h,p,g;var k=this.getSelectedNodeCoordinates();if(k||b==89|b==90){this.cancelEvent(j);this.stopEvent(j);if(b!=90||(b==90&&j.shiftKey)){this.addToNetworkStack(0)}if(b==84){f=this.min(k.y);for(var g in this.selectNode){var d=this.data.nodes[this.data.nodeIndices[g]];d.y=f}}else{if(b==82){f=this.max(k.x);for(var g in this.selectNode){var d=this.data.nodes[this.data.nodeIndices[g]];d.x=f}}else{if(b==66){f=this.max(k.y);for(var g in this.selectNode){var d=this.data.nodes[this.data.nodeIndices[g]];d.y=f}}else{if(b==76){f=this.min(k.x);for(var g in this.selectNode){var d=this.data.nodes[this.data.nodeIndices[g]];d.x=f}}else{if(b==86){a=this.range(k.y);h=this.rank(k.y);p=(a[1]-a[0])/(this.isSelectNodes-1);f=a[0];for(var l=0;l<h.length;l++){g=k.i[h[l]];var d=this.data.nodes[this.data.nodeIndices[g]];d.y=f+(l*p)}}else{if(b==72){a=this.range(k.x);h=this.rank(k.x);p=(a[1]-a[0])/(this.isSelectNodes-1);f=a[0];for(var l=0;l<h.length;l++){g=k.i[h[l]];var d=this.data.nodes[this.data.nodeIndices[g]];d.x=f+(l*p)}}else{if(b==90&&!j.shiftKey){if(this.canNetworkUndoOp){this.addToNetworkStack(1);this.resetSelectedNodes();this.undoNetworkOp()}return false}else{if(b==89||b==90){if(this.canNetworkRedoOp){if(!this.canNetworkUndoOp){this.addToNetworkStack(0)}this.resetSelectedNodes();this.redoNetworkOp()}return false}}}}}}}}this.draw(false,false,false,true)}return false};this.getSelectedNodeCoordinates=function(){var f={x:[],y:[],i:[]};var b=false;for(var d in this.selectNode){var e=this.data.nodes[this.data.nodeIndices[d]];f.x.push(e.x);f.y.push(e.y);f.i.push(d);b=true}return b?f:false};this.findNodesBy=function(g){var a=[];var k=0;for(var b in g){g[b]=this.toArray(g[b]);k++}for(var h=0;h<this.data.nodes.length;h++){var d=this.data.nodes[h];var e=0;for(var b in g){var l=g[b];for(var f=0;f<l.length;f++){if(d[b]&&d[b]==l[f]){e++}}}if(e==k){a.push(d)}}return a};this.setNetworkDimensions=function(){this.left=0;this.top=0;this.x=this.width;this.y=this.height};this.setNetworkPrivateParams=function(){if(this.data.nodes.length>0){this.layoutDone=false;this.x=this.width;this.y=this.height;if(this.networkLayoutType=="radial"){var a=this.width;var b=this.height;if(this.width>this.height){this.width=this.height}else{this.height=this.width}this.x=this.width;this.y=this.height;this.networkXCenter=this.x/2;this.networkYCenter=this.y/2;this.width=a;this.height=b}else{this.x=this.width;this.y=this.height;this.set3DParams();this.area=this.x*this.y;this.k=Math.sqrt(this.area/this.data.nodes.length);this.temperature=this.data.nodes.length+Math.floor(Math.sqrt(this.data.edges.length));this.minimumTemperature=1;this.initialTemperature=this.temperature;this.iteration=0}if(this.x<=400||this.y<=400){this.nodeSize-=4;this.nodeFont=(this.nodeSize-6)+"Pt "+this.fontName;this.showAnimationFont=this.nodeFont+"Pt "+this.fontName}else{this.edgeWidth=2}}else{this.layoutDone=true}};this.networkContains=function(a,b){return this.findNode(a,b)!=null};this.findNode=function(b,d){for(var c in b){var a=b[c];if(d.call(a)){return a}}return null};this.filterEdges=function(b,e){var d=[];for(var c in b){var a=b[c];if(e.call(a)){d.push(a)}}return d};this.reduceNetwork=function(a,e,c){var d=null;for(var b in a){if(d==null){if(c){d=c.apply(c,[a[b]])}else{d=a[b]}}else{d=e.apply(a[b],[d,a[b]])}}return d};this.vectorDifference=function(b,a){return{x:b.x-a.x,y:b.y-a.y,z:b.z-a.z}};this.vectorMagnitude=function(a){if(this.is3DNetwork){var b=Math.sqrt((a.x*a.x)+(a.y*a.y)+(a.z*a.z));return isNaN(b)?0:b}else{return Math.sqrt((a.x*a.x)+(a.y*a.y))}};this.normalizeGraph=function(h){var g=[];var a={};var j=this;for(var e in h.nodes){if(!a.hasOwnProperty(h.nodes[e].id)){var d=h.nodes[e];var c=[];a[d.id]=1;if(!this.networkContains(c,function(){return j.networkContains(this.nodes,function(){return this.id=d.id})})){var b={};b.nodes=[];b.edges=[];this.addNodeToGraph(d,b,h);if(b.nodes.length>0){g.push(b)}for(var f=0;f<b.nodes.length;f++){a[b.nodes[f].id]=1}}}}return g};this.addNodeToGraph=function(c,e,d){if(this.findNodeForId(c.id,e)==null){e.nodes.push(c);var a=this.edgesForNode(d.edges,c.id);for(edgeIndex in a){var b=a[edgeIndex];e.edges.push(b);if(b.id1==c.id){this.addNodeToGraph(this.findNodeForId(b.id2,d),e,d)}else{this.addNodeToGraph(this.findNodeForId(b.id1,d),e,d)}}}};this.findNodeForId=function(b,a){return this.findNode(a.nodes,function(){return b==this.id})};this.edgesForNode=function(a,b){return this.filterEdges(a,function(c){return(this.id1==b||this.id2==b)})};this.attractiveForce=function(b,a){return(b*b)/a};this.repulsiveForce=function(b,a){return(a*a)/b};this.storePositions=function(){var d={};for(var b=0;b<this.data.nodes.length;b++){var c=this.data.nodes[b];if(!c.hide&&!c.hiddenParent){var a={x:c.x,y:c.y,z:c.z};d[c.id]=a}}return d};this.calculateRepulsiveDisplacement=function(e){for(var d=0;d<this.data.nodes.length;d++){var h=this.data.nodes[d];if(!h.hide&&!h.hiddenParent){var a={x:0,y:0,z:0};for(var b=0;b<this.data.nodes.length;b++){var f=this.data.nodes[b];if(!f.hide&&!f.hiddenParent){var g=this.vectorDifference(h,f);var c=this.vectorMagnitude(g);if(c!=0){a.x+=(g.x/c)*this.repulsiveForce(c,this.k);a.y+=(g.y/c)*this.repulsiveForce(c,this.k);a.z+=(g.z/c)*this.repulsiveForce(c,this.k)}}e[h.id]=a}}}};this.calculateAttractiveDisplacement=function(e){for(var c=0;c<this.data.edges.length;c++){var d=this.data.edges[c];if(!this.nodes||!this.nodes[d.id1]||!this.nodes[d.id2]){alert('Nodes "'+d.id1+'" and/or "'+d.id2+'" are missing!');return}if(this.nodes&&!this.nodes[d.id1].hide&&!this.nodes[d.id2].hide&&!this.nodes[d.id1].hiddenParent&&!this.nodes[d.id2].hiddenParent){var g=this.vectorDifference(this.nodes[d.id1],this.nodes[d.id2]);var b=this.vectorMagnitude(g);if(b!=0){var f=e[d.id1];f.x-=(g.x/b)*this.attractiveForce(b,this.k);f.y-=(g.y/b)*this.attractiveForce(b,this.k);f.z-=(g.z/b)*this.attractiveForce(b,this.k);var a=e[d.id2];a.x+=(g.x/b)*this.attractiveForce(b,this.k);a.y+=(g.y/b)*this.attractiveForce(b,this.k);a.z+=(g.z/b)*this.attractiveForce(b,this.k)}}}};this.isLayoutDone=function(){var h=this.storePositions();var j=0;var b=0;var d;var g;for(var f=0;f<this.data.nodes.length;f++){if(!this.data.nodes[f].hide&&!this.data.nodes[f].hiddenParent){var c=this.data.nodes[f].id;var a=h[c];if(d){d.x=Math.min(d.x,a.x);d.y=Math.min(d.y,a.y);d.z=Math.min(d.z,a.z);g.x=Math.max(g.x,a.x);g.y=Math.max(g.y,a.y);g.z=Math.max(g.z,a.z)}else{d={};g={};d.x=a.x;d.y=a.y;d.z=a.z;g.x=a.x;g.y=a.y;g.z=a.z}var k=Math.abs(this.vectorMagnitude(this.vectorDifference(this.previousNodePositions[c],a)));j+=k;b++}}var m=j/b;var e=Math.abs(this.vectorMagnitude(this.vectorDifference(d,g)));var l=Math.abs(this.vectorMagnitude({x:this.x,y:this.y,z:parseInt((this.x+this.y)/2)}));this.minimumTemperature=(e/l);this.layoutDone=m<(this.minimumTemperature/2);this.previousNodePositions=h;if(this.initialProgress==null&&this.temperature<=this.minimumTemperature){this.initialProgress=m-(this.minimumTemperature/2)}if(this.initialProgress!=null){this.layoutProgress=Math.max(this.layoutProgress,1-((m-(this.minimumTemperature/2))/this.initialProgress))}};this.applyDisplacement=function(d){if(this.nodes){for(var e in d){var c=this.nodes[e];var b=d[e];var a=this.vectorMagnitude(b);if(a!=0){c.x+=(b.x/a)*Math.min(this.temperature,Math.abs(b.x));c.y+=(b.y/a)*Math.min(this.temperature,Math.abs(b.y));c.z+=(b.z/a)*Math.min(this.temperature,Math.abs(b.z))}}}};this.setInitialForceDirectedLayout=function(){this.layoutProgress=0;for(var a=0;a<this.data.nodes.length;a++){if(!this.data.nodes[a].hide&&!this.data.nodes[a].hiddenParent){this.data.nodes[a].x=Math.floor(Math.random()*this.x);this.data.nodes[a].y=Math.floor(Math.random()*this.y);this.data.nodes[a].z=this.is3DNetwork?Math.floor(Math.random()*parseInt((this.x+this.y)/2)):0}}this.previousNodePositions=this.storePositions()};this.updateForceDirectedLayout=function(c){var d=new Date().getTime();var b=d;if(this.data.edges.length<1){this.layoutDone=true}if(!this.layoutDone){while(b-d<c){var a={};this.calculateRepulsiveDisplacement(a);this.calculateAttractiveDisplacement(a);this.applyDisplacement(a);this.iteration++;this.temperature=Math.max(this.temperature-(this.initialTemperature/100),this.minimumTemperature);if(this.iteration%this.maxIterations==0){this.isLayoutDone()}b=new Date().getTime()}}return this.layoutDone};this.renderNetwork=function(){this.ctx.shadowOffsetX=this.shadowOffsetX;this.ctx.shadowOffsetY=this.shadowOffsetY;this.ctx.shadowBlur=this.shadowBlur;this.ctx.shadowColor=this.shadowColor;this.setNetworkRotation();this.resizeCanvas();if(!this.layoutDone&&!this.showAnimation){this.drawNetworkProgressBar(true);return}if(this.data.nodes.length>0){if(this.layoutDone){this.setXYNodePrecision()}this.setNetworkMinMaxRangeXY();this.setNetworkScaleFactor();if(this.scaleFactor){if(this.showAnimation){if(this.preScaleNetwork){this.centerNetwork();this.ctx.save();this.ctx.scale(1/this.scaleFactor,1/this.scaleFactor);this.ctx.translate(this.offsetX,this.offsetY);this.ctx.restore();this.drawNetworkEdges();this.drawNetworkNodes();if(this.layoutDone){this.drawNetworkLegend()}this.ctx.save();this.ctx.translate(-this.offsetX,-this.offsetY);this.ctx.scale(this.scaleFactor,this.scaleFactor);this.ctx.restore()}else{this.ctx.scale(this.scaleFactor,this.scaleFactor);this.ctx.translate(this.offsetX,this.offsetY);if(this.networkLayoutType=="radial"&&this.showNetworkRadialLayout){this.renderRadialLayout()}this.drawNetworkEdges();this.drawNetworkNodes();if(this.layoutDone){this.drawNetworkDecorations();this.drawNetworkLegend()}this.ctx.translate(-this.offsetX,-this.offsetY);this.ctx.scale(1/this.scaleFactor,1/this.scaleFactor)}}else{if(this.preScaleNetwork){this.centerNetwork();this.ctx.save();this.ctx.scale(this.scaleFactor,this.scaleFactor);this.ctx.translate(this.offsetX,this.offsetY);this.ctx.restore()}else{this.ctx.scale(this.scaleFactor,this.scaleFactor);this.ctx.translate(this.offsetX,this.offsetY)}if(this.networkLayoutType=="radial"&&this.showNetworkRadialLayout){for(var a=1;a<this.networkDepth;a++){this.drawShape("circle",this.networkXCenter,this.networkYCenter,a*this.networkLevelSize*2,a*this.networkLevelSize*2,this.background,this.infoAreaColor,"open")}}this.drawNetworkEdges();this.drawNetworkNodes();if(this.layoutDone){this.drawNetworkDecorations();this.drawNetworkLegend()}}this.drawNetworkProgressBar()}}};this.reRootRadialNetwork=function(e){var d=this.data.nodes[e].id;this.networkCurrentAngle=this.getAngle(this.finalRadialNodePositions[d].x,this.finalRadialNodePositions[d].y,this.finalRadialNodePositions[this.networkRoot].x,this.finalRadialNodePositions[this.networkRoot].y,0)+180;this.orderRadialNetwork={};var b=this.data.nodeIndices[d];var c=0;for(var a=b;a<this.data.nodes.length;a++){this.orderRadialNetwork[this.data.nodes[a].id]=c;c++}for(var a=0;a<b;a++){this.orderRadialNetwork[this.data.nodes[a].id]=c;c++}this.networkXCenter=this.finalRadialNodePositions[d].x;this.networkYCenter=this.finalRadialNodePositions[d].y;this.networkRoot=d;this.layoutDone=false;this.draw()};this.renderRadialLayout=function(){var a=this.data.nodes[this.data.nodeIndices[this.networkRoot]];for(var b=1;b<this.networkDepth;b++){this.drawShape("circle",a.x,a.y,b*this.networkLevelSize*2,b*this.networkLevelSize*2,this.background,this.infoAreaColor,"open")}};this.centerNetwork=function(){for(var a=0;a<this.data.nodes.length;a++){var b=this.data.nodes[a];if(!b.hide&&!b.hiddenParent){b.x=(this.offsetX+b.x)*this.scaleFactor;b.y=(this.offsetY+b.y)*this.scaleFactor}}this.scaleFactor=0.9;this.offsetX=this.x*0.05;this.offsetY=this.y*0.05};this.adjustNetworkObjects=function(b){if(b){if(b[0]=="circle"){b[1]=(this.offsetX+b[1])*this.scaleFactor;b[2]=(this.offsetY+b[2])*this.scaleFactor;b[3]=b[3]*this.scaleFactor}else{for(var a=1;a<b.length;a++){if(a%2){b[a]=(this.offsetX+b[a])*this.scaleFactor}else{b[a]=(this.offsetY+b[a])*this.scaleFactor}}}}else{return false}return b};this.setXYNodePrecision=function(){if(this.approximateNodePositions){for(var a=0;a<this.data.nodes.length;a++){var b=this.data.nodes[a];if(b.x){b.x=parseInt(b.x);this.nodes[b.id].x=b.x}if(b.y){b.y=parseInt(b.y);this.nodes[b.id].y=b.y}if(b.z){b.z=parseInt(b.z);this.nodes[b.id].z=b.z}}}};this.getLengthToNodeBoundary=function(c,i,b,h,e,d){if(e){var g=e.size?e.size:1;var a=d&&e.height?e.height:e.width?e.width:this.nodeSize*g;var f=d&&e.width?e.width:e.height?e.height:this.nodeSize*g;var j=this.clip("line",[c,i,b,h],[c-(a/2),i-(f/2),a,f]);return this.lineLength(j[0],j[1],j[2],j[3])+(this.margin*2)}else{return this.margin*2}};this.drawNetworkEdges=function(){if(this.nodes){var a={};var b=1;var e=this.foreground;for(var p=0;p<this.data.edges.length;p++){var f=this.data.edges[p];var o=this.nodes[f.id1];var n=this.nodes[f.id2];var t=false;if(!o.hide&&!o.hiddenParent&&!n.hide&&!n.hiddenParent&&!f.anchor){t=true}else{if(this.showHiddenChildEdges){if(o.hide||o.hiddenParent||(o.parentNode&&this.nodes[o.parentNode].hideChildren)){o=this.findVisibleParentNode(f.id1);if(o){t=true}}if(n.hide||n.hiddenParent||(n.parentNode&&this.nodes[n.parentNode].hideChildren)){n=this.findVisibleParentNode(f.id2);if(n){t=true}}}}var v=o.id+":"+n.id;if(t){if(!a.hasOwnProperty(v)){var c=this.selectNode.hasOwnProperty(o.id)&&this.selectNode.hasOwnProperty(n.id)?this.nodeHighlightColor:f.color?f.color:e;var h=f.width?f.width:1;var g=f.cap?f.cap:false;var l,j,r,q;if(this.is3DNetwork){l=o.x3d;j=o.y3d;r=n.x3d;q=n.y3d}else{l=o.x;j=o.y;r=n.x;q=n.y}var k=f.type?f.type:"line";var m=k.match(/curved/)?true:false;var u=this.getLengthToNodeBoundary(l,j,r,q,o,m);var d=this.getLengthToNodeBoundary(r,q,l,j,n,m);var s=this.drawLine(k,l,j,r,q,c,h,g,u,d);if(this.layoutDone&&!this.isAnimation){if(this.preScaleNetwork){this.addArea(s,[p+this.data.nodes.length])}else{this.addArea(this.adjustNetworkObjects(s),[p+this.data.nodes.length])}b++}this.ctx.lineWidth=1;a[v]=1}}}}};this.drawNetworkNodes=function(){var o=this.data.nodes.length<this.showNodeNameThreshold?true:false;var k=this.foreground;var D=this.shapes[0];var b=6001;var l=this.rangeX>this.rangeY?"bottom":"right";var a=this.autoHideOnDecorationsCenter&&this.decorationsPosition=="center"&&this.decorations.length>0?true:false;for(var E=0;E<this.data.nodes.length;E++){var B=this.data.nodes[E];if(!B.hide&&!B.hiddenParent&&!B.anchor){var s=this.is3DNetwork?B.x3d:B.x;var H=this.is3DNetwork?B.y3d:B.y;var x=B.shape?B.shape:D;var j=this.selectNode.hasOwnProperty(B.id)?this.nodeHighlightColor:B.color?B.color:k;var F=B.outline?B.outline:this.foreground;var G=B.size?B.size:1;var r=B.width?B.width:this.nodeSize*G;var A=B.height?B.height:this.nodeSize*G;var t=B.pattern?B.pattern:"closed";var n=B.rotate?B.rotate*Math.PI/180:false;var z=B.outlineWidth?B.outlineWidth:false;var h=B.imagePath?B.imagePath:false;var d=B.zIndex?B.zIndex:h?b:false;var w=B.transparent?true:a;var I=this.drawShape(x,s,H,r,A,j,F,t,n,z,false,false,false,false,h,d,w);if(this.layoutDone&&!this.isAnimation){if(this.preScaleNetwork){this.addArea(I,[E])}else{this.addArea(this.adjustNetworkObjects(I),[E])}if(o&&!B.hideName){var f,e;var m=B.label?B.label:B.name?B.name:B.id;var C=this.getNodeColor(B.id);var g=B.labelSize?this.nodeFontSize*B.labelSize*this.nodeScaleFontFactor:this.nodeFontSize*this.nodeScaleFontFactor;var u=(parseInt(g))+"Pt "+this.fontName;var y=this.measureText(m,u);var v=g;if(B.labelX!=null&&B.labelY!=null){f=B.labelX-(y/2);e=B.labelY-(v/2);this.drawText(m,B.labelX,B.labelY,u,C,"center","middle")}else{var q=this.isMultipleLines(m);var c=parseInt(g)+4;if(q){if(q%2){H+=(parseInt(q/2)*c)+(c/2)}else{H=(H+parseInt(q/2)*c)}}if(B.labelPosition){switch(B.labelPosition){case"top":f=s-(y/2);e=H-((A/1.3)+v);this.drawText(m,s,e,u,C,"center","top");break;case"bottom":f=s-(y/2);e=H+(A/1.3);this.drawText(m,s,e,u,C,"center","top");break;case"right":f=s+(r/1.3);e=H-(v/2);this.drawText(m,f,H,u,C,"left","middle");break;case"left":f=s-((r/1.3)+y);e=H-(v/2);this.drawText(m,f,H,u,C,"left","middle");break;case"center":this.drawText(m,s,H,u,C,"center","middle");break}}else{if(l=="right"){f=s+(r/1.3);e=H-(v/2);this.drawText(m,f,H,u,C,"left","middle")}else{f=s-(y/2);e=H+(A/1.3);this.drawText(m,s,e,u,C,"center","top")}}}var p=["rect",f,e,f+y,e+v];if(this.preScaleNetwork&&!this.isAnimation){this.addArea(p,[E],"-lab")}else{this.addArea(this.adjustNetworkObjects(p),[E],"-lab")}}}b++}}};this.drawNetworkDecorations=function(){if(this.showDecorations&&this.decorations.length>0){var p=this.decorations.length*this.decorationsWidth;var w=p/2;var f=this.decorationsHeight/2;var A=this.decorationsHeight*2/3;var h=this.decorationsHeight/3;this.setHeatmapColors(this.decorationsRange[1]-this.decorationsRange[0]);for(var s=0;s<this.data.nodes.length;s++){var q=this.data.nodes[s];var x=[];var y=[];var k=false;var o=this.sizeDecorationBy&&q.decorationSize?q.decorationSize:f;if(!q.hide&&!q.hiddenParent&&!q.anchor){var l=this.is3DNetwork?q.x3d:q.x;var u=this.is3DNetwork?q.y3d:q.y;var B=q.size?this.nodeSize*q.size:this.nodeSize;var b=B/2;var v,e,t,c,n,g,m;switch(this.decorationsPosition){case"top":v=this.decorationsType=="pie"?l:l-w;e=u-(b+this.decorationsHeight+this.decorationsWidth);e=this.decorationsType=="pie"?e-f:e;break;case"bottom":v=this.decorationsType=="pie"?l:l-w;e=u+(b+this.decorationsHeight+this.decorationsWidth);e=this.decorationsType=="pie"?e+f:e;break;case"right":v=l+b+this.decorationsWidth;e=this.decorationsType=="pie"?u:u-f;v=this.decorationsType=="pie"?v+f:v;break;case"left":v=l-(b+(this.decorationsWidth*(this.decorations.length+1)));e=this.decorationsType=="pie"?u:u-f;v=this.decorationsType=="pie"?v-f:v;break;case"center":v=this.decorationsType=="pie"?l:l-w;e=this.decorationsType=="pie"?u:u-f;break}if(q.decorationsX!=null&&q.decorationsY!=null){v=q.decorationsX;e=q.decorationsY}if(this.preScaleNetwork&&!this.isAnimation){this.addArea(["rect",v,e,v+p,e-this.decorationsHeight],[s],"-dec")}else{this.addArea(this.adjustNetworkObjects(["rect",v,e,v+p,e-this.decorationsHeight]),[s],"-dec")}if(this.decorationsType=="bar"){m=this.decorationsRange[1]<0?e:this.decorationsRange[0]>=0?e+this.decorationsHeight:(e+this.decorationsHeight)-Math.abs(this.decorationsRange[0]*this.decorationsUnits);for(var r=0;r<this.decorations.length;r++){n=this.decorations[r];if(q[n]&&!isNaN(q[n])){this.rectangle(v,m,this.decorationsWidth,-q[n]*this.decorationsUnits,this.decorationsColors[r])}v+=this.decorationsWidth}}else{for(var r=0;r<this.decorations.length;r++){if(q[this.decorations[r]]!=null){k=true}x.push(q[this.decorations[r]]);y.push([s])}if(k){if(this.decorationsType=="heatmap"){this.drawHeatmap(x,v,e,this.decorationsWidth,A,this.decorationsRange[0],this.decorationsRange[1],false,y,"-dec");for(var r=0;r<this.decorations.length;r++){this.drawShape("circle",v+this.decorationsWidth/2,(e+this.decorationsHeight)-(h/3),h/3,h/3,this.decorationsColors[r],this.foreground,"closed");v+=this.decorationsWidth}}else{this.drawPie(this.setPieData(x),v,e,o)}}}}}}};this.getLegendId=function(b,c){if(b){if(!c){var a=0;c=b+"LegendId"+a;while(this.data.legend.ids[b].hasOwnProperty(c)){a++;c=b+"LegendId"+a}}this.data.legend.ids[b][c]=true;return c}};this.findNetworkXYRange=function(){if(this.data.nodes.length>0){var a=Number.MAX_VALUE;var e=Number.MIN_VALUE;var f=Number.MAX_VALUE;var d=Number.MIN_VALUE;if(this.is3DNetwork&&this.layoutDone&&this.scaleFactor){for(var b=0;b<this.data.nodes.length;b++){var c=this.data.nodes[b];if(!c.hide&&!c.hiddenParent&&!c.anchor){a=Math.min(a,c.x3d);e=Math.max(e,c.x3d);f=Math.min(f,c.y3d);d=Math.max(d,c.y3d)}}}else{for(var b=0;b<this.data.nodes.length;b++){var c=this.data.nodes[b];if(!c.hide&&!c.hiddenParent&&!c.anchor){a=Math.min(a,c.x);e=Math.max(e,c.x);f=Math.min(f,c.y);d=Math.max(d,c.y)}}}}return({minX:a,maxX:e,minY:f,maxY:d})};this.inititalizeNetworkLegend=function(){if(!this.data.legend){this.data.legend={}}if(!this.data.legend.pos){this.data.legend.pos={}}if(!this.data.legend.pos.nodes){this.data.legend.pos.nodes={x:false,y:false}}if(!this.data.legend.pos.edges){this.data.legend.pos.edges={x:false,y:false}}if(!this.data.legend.pos.decorations){this.data.legend.pos.decorations={x:false,y:false}}if(!this.data.legend.ids){this.data.legend.ids={nodes:{},edges:{},text:{},decorations:{}}}};this.drawNetworkLegend=function(){if(this.showLegend){this.inititalizeNetworkLegend();var a=this.findNetworkXYRange();this.curLegendX=a.minX;this.curLegendY=a.minY;if(this.showNetworkNodesLegend){this.drawNetworkLegendNodes()}if(this.showNetworkEdgesLegend){this.drawNetworkLegendEdges()}if(this.showNetworkTextLegend){this.drawNetworkLegendText()}if(this.showNetworkDecorationsLegend){this.drawNetworkLegendDecorations()}}};this.drawNetworkLegendNodes=function(){if(this.data.legend.nodes&&this.data.legend.nodes.length>0){var f=this.data.legend.pos.nodes.x!=null?this.data.legend.pos.nodes.x:this.curLegendX;var d=this.data.legend.pos.nodes.y!=null?this.data.legend.pos.nodes.y:this.curLegendY;this.data.legend.pos.nodes.x=parseInt(f);this.data.legend.pos.nodes.y=parseInt(d);var u=0;var t=0;for(var v=0;v<this.data.legend.nodes.length;v++){this.data.legend.nodes[v].id=this.getLegendId("nodes",this.data.legend.nodes[v].id);var s=this.data.legend.nodes[v].color||this.nodeFontColor;var w=this.data.legend.nodes[v].outline?this.data.legend.nodes[v].outline:this.foreground;var a=this.data.legend.nodes[v].shape||this.shapes[0];var o=this.data.legend.nodes[v].size?this.data.legend.nodes[v].size*this.nodeFontSize:this.nodeFontSize;var k=this.data.legend.nodes[v].width?this.data.legend.nodes[v].width:o;var q=this.data.legend.nodes[v].height?this.data.legend.nodes[v].height:o;var l=this.data.legend.nodes[v].pattern?this.data.legend.nodes[v].pattern:"closed";var j=this.data.legend.nodes[v].rotate?this.data.legend.nodes[v].rotate*Math.PI/180:false;var r=this.data.legend.nodes[v].outlineWidth?this.data.legend.nodes[v].outlineWidth:false;var g=this.data.legend.nodes[v].imagePath?this.data.legend.nodes[v].imagePath:false;var b=this.data.legend.nodes[v].zIndex?this.data.legend.nodes[v].zIndex:false;var h=this.data.legend.nodes[v].font?this.data.legend.nodes[v].font*this.nodeFontSize*this.nodeScaleFontFactor:this.nodeFontSize*this.nodeScaleFontFactor;var n=(parseInt(h))+"Pt "+this.fontName;var m=this.data.legend.nodes[v].text?this.data.legend.nodes[v].text:"";var p=this.measureText(m,n);o=parseFloat(sprintf("%.1f",o));u=Math.max(u,(this.margin*3)+o+p);t=o/2;d+=t;this.drawShape(a,this.margin+f+t,this.margin+d+t,k,q,s,w,l,j,r,false,false,false,false,g,b);this.drawText(m,(this.margin*2)+f+o,this.margin+d+t,n,this.nodeFontColor,"left","middle");d+=o}d+=this.margin+t;var y=this.data.legend.pos.nodes.x;var e=this.data.legend.pos.nodes.y;var x=u;var c=d-this.data.legend.pos.nodes.y;if(this.legendBox){this.rectangle(y,e,x,c,false,this.legendBoxColor,"open")}var z=["rect",y,e,y+x,e+c];if(this.preScaleNetwork){this.addArea(z,[-1],"-legend-Nodes")}else{this.addArea(this.adjustNetworkObjects(z),[-1],"-legend-Nodes")}this.curLegendX=f;this.curLegendY=d}};this.drawNetworkLegendEdges=function(){if(this.data.legend.edges&&this.data.legend.edges.length>0){var d=this.data.legend.pos.edges.x!=null?this.data.legend.pos.edges.x:this.curLegendX;var b=this.data.legend.pos.edges.y!=null?this.data.legend.pos.edges.y:this.curLegendY;this.data.legend.pos.edges.x=parseInt(d);this.data.legend.pos.edges.y=parseInt(b);var n=0;var m=0;for(var o=0;o<this.data.legend.edges.length;o++){this.data.legend.edges[o].id=this.getLegendId("edges",this.data.legend.edges[o].id);var l=this.data.legend.edges[o].color||this.nodeFontColor;var f=this.data.legend.edges[o].type||"line";var k=this.data.legend.edges[o].width||1;var j=this.data.legend.edges[o].size?this.data.legend.edges[o].size*this.nodeFontSize:this.nodeFontSize;var e=this.data.legend.edges[o].font?this.data.legend.edges[o].font*this.nodeFontSize*this.nodeScaleFontFactor:this.nodeFontSize*this.nodeScaleFontFactor;var h=(parseInt(e))+"Pt "+this.fontName;var g=this.data.legend.edges[o].text||"";var p=this.measureText(g,h);j=parseFloat(sprintf("%.1f",j));n=Math.max(n,(this.margin*3)+j+p);m=e/2;b+=m;this.ctx.lineWidth=k*this.edgeWidth;this.drawLine(f,this.margin+d,this.margin+b+m,d+j,this.margin+b+m,l,false,false,0,0);this.drawText(g,(this.margin*2)+d+j,this.margin+b+m,h,this.nodeFontColor,"left","middle");b+=e}b+=this.margin+m;var r=this.data.legend.pos.edges.x;var c=this.data.legend.pos.edges.y;var q=n;var a=b-this.data.legend.pos.edges.y;if(this.legendBox){this.rectangle(r,c,q,a,false,this.legendBoxColor,"open")}var s=["rect",r,c,r+q,c+a];if(this.preScaleNetwork){this.addArea(s,[-1],"-legend-Edges")}else{this.addArea(this.adjustNetworkObjects(s),[-1],"-legend-Edges")}this.curLegendX=d;this.curLegendY=b}};this.drawNetworkLegendText=function(){if(this.data.legend.text&&this.data.legend.text.length>0){var r=0;for(var l=0;l<this.data.legend.text.length;l++){this.data.legend.text[l].id=this.getLegendId("text",this.data.legend.text[l].id);var j=this.data.legend.text[l].x!=null?this.data.legend.text[l].x:this.curLegendX;var f=this.data.legend.text[l].y!=null?this.data.legend.text[l].y:this.curLegendY;this.data.legend.text[l].x=parseInt(j);this.data.legend.text[l].y=parseInt(f);var d=this.data.legend.text[l].boxed||this.legendBox;var g=this.data.legend.text[l].margin||this.margin;var m=this.setNetworkLegendMargins(g);var h=this.data.legend.text[l].color||this.nodeFontColor;var q=this.data.legend.text[l].text||"";var o=this.data.legend.text[l].font?this.data.legend.text[l].font*this.nodeFontSize*this.nodeScaleFontFactor:this.nodeFontSize*this.nodeScaleFontFactor;o=parseInt(o);var e=(o)+"Pt "+this.fontName;var c=this.measureText(q,e);r=o/2;this.drawText(q,m[3]+j,m[0]+f+r,e,h,"left","middle");var b=this.data.legend.text[l].x;var p=this.data.legend.text[l].y;var a=m[1]+m[3]+c;var n=m[0]+m[2]+o;if(d){this.rectangle(b,p,a,n,false,this.legendBoxColor,"open")}f+=m[0]+m[2]+o;var k=["rect",b,p,b+a,p+n];if(this.preScaleNetwork){this.addArea(k,[-1],"-legend-Text"+l)}else{this.addArea(this.adjustNetworkObjects(k),[-1],"-legend-Text"+l)}this.curLegendX=j;this.curLegendY=f}}};this.drawNetworkLegendDecorations=function(){if(this.data.legend.decorations&&this.data.legend.decorations.length>0){var e=this.data.legend.pos.decorations.x!=null?this.data.legend.pos.decorations.x:this.curLegendX;var c=this.data.legend.pos.decorations.y!=null?this.data.legend.pos.decorations.y:this.curLegendY;this.data.legend.pos.decorations.x=parseInt(e);this.data.legend.pos.decorations.y=parseInt(c);var s=0;var r=0;for(var t=0;t<this.data.legend.decorations.length;t++){this.data.legend.decorations[t].id=this.getLegendId("decorations",this.data.legend.decorations[t].id);var q=this.data.legend.decorations[t].color||this.nodeFontColor;var u=this.data.legend.decorations[t].outline?this.data.legend.decorations[t].outline:this.foreground;var a=this.data.legend.decorations[t].shape||this.shapes[0];var m=this.data.legend.decorations[t].size?this.data.legend.decorations[t].size*this.nodeFontSize:this.nodeFontSize;var h=this.data.legend.decorations[t].width?this.data.legend.decorations[t].width:m;var o=this.data.legend.decorations[t].height?this.data.legend.decorations[t].height:m;var j=this.data.legend.decorations[t].pattern?this.data.legend.decorations[t].pattern:"closed";var g=this.data.legend.decorations[t].rotate?this.data.legend.decorations[t].rotate*Math.PI/180:false;var p=this.data.legend.decorations[t].outlineWidth?this.data.legend.decorations[t].otlineWidth:false;var f=this.data.legend.decorations[t].font?this.data.legend.decorations[t].font*this.nodeFontSize*this.nodeScaleFontFactor:this.nodeFontSize*this.nodeScaleFontFactor;var l=(parseInt(f))+"Pt "+this.fontName;var k=this.data.legend.decorations[t].text?this.data.legend.decorations[t].text:"";var n=this.measureText(k,l);m=parseFloat(sprintf("%.1f",m));s=Math.max(s,(this.margin*3)+m+n);r=m/2;c+=r;this.drawShape(a,this.margin+e+r,this.margin+c+r,h,o,q,u,j,g,p);this.drawText(k,(this.margin*2)+e+m,this.margin+c+r,l,this.nodeFontColor,"left","middle");c+=m}c+=this.margin+r;var w=this.data.legend.pos.decorations.x;var d=this.data.legend.pos.decorations.y;var v=s;var b=c-this.data.legend.pos.decorations.y;if(this.legendBox){this.rectangle(w,d,v,b,false,this.legendBoxColor,"open")}var x=["rect",w,d,w+v,d+b];if(this.preScaleNetwork){this.addArea(x,[-1],"-legend-Decorations")}else{this.addArea(this.adjustNetworkObjects(x),[-1],"-legend-Decorations")}this.curLegendX=e;this.curLegendY=c}};this.setNetworkLegendMargins=function(a){if(isNaN(a)){var b=a.split(/[,\s]+/);if(b.length>3){return[parseInt(b[0]),parseInt(b[1]),parseInt(b[2]),parseInt(b[3])]}else{if(b.length==3){return[parseInt(b[0]),parseInt(b[1]),parseInt(b[2]),parseInt(b[1])]}else{if(b.length==2){return[parseInt(b[0]),parseInt(b[1]),parseInt(b[0]),parseInt(b[1])]}else{return[parseInt(b[0]),parseInt(b[0]),parseInt(b[0]),parseInt(b[0])]}}}}else{return[parseInt(a),parseInt(a),parseInt(a),parseInt(a)]}};this.drawNetworkProgressBar=function(b){if(!this.layoutDone){this.ctx.save();this.ctx.fillStyle="#fff";this.ctx.strokeStyle="#fff";var a=(new Date().getTime()-this.preUpdateTime)/(this.layoutTime*1000);a=Math.max(a,this.layoutProgress);if(b){this.ctx.strokeRect((this.width/2)-50,(this.height/2)-5,100,10);this.ctx.fillRect((this.width/2)-50,(this.height/2)-5,a*100,10);this.drawText("Calculating ...",(this.width/2)-50,(this.height/2)+10,this.showAnimationFont,this.showAnimationFontColor,"left","top")}else{this.ctx.strokeRect(this.width-110,this.height-20,100,10);this.ctx.fillRect(this.width-110,this.height-20,a*100,10)}this.ctx.restore()}};this.setNetworkMinMaxRangeXY=function(){if(!this.networkFreeze||(this.rangeX==null||this.rangeY==null)){this.minX=Number.MAX_VALUE;this.minY=Number.MAX_VALUE;this.maxX=0;this.maxY=0;if(this.is3DNetwork&&this.layoutDone){for(var b=0;b<this.data.nodes.length;b++){var d=this.data.nodes[b];var a=d.width?d.width:d.size?(this.nodeSize*d.size):this.nodeSize;var c=d.height?d.height:d.size?(this.nodeSize*d.size):this.nodeSize;if(!d.hide){this.minX=Math.min(this.minX,d.x3d-a/2);this.minY=Math.min(this.minY,d.y3d-c/2);this.maxX=Math.max(this.maxX,d.x3d+a/2);this.maxY=Math.max(this.maxY,d.y3d+c/2)}}}else{for(var b=0;b<this.data.nodes.length;b++){var d=this.data.nodes[b];var a=d.width?d.width:d.size?(this.nodeSize*d.size):this.nodeSize;var c=d.height?d.height:d.size?(this.nodeSize*d.size):this.nodeSize;if(!d.hide){this.minX=Math.min(this.minX,d.x-a/2);this.minY=Math.min(this.minY,d.y-c/2);this.maxX=Math.max(this.maxX,d.x+a/2);this.maxY=Math.max(this.maxY,d.y+c/2)}}}this.minX-=(this.nodeSize*3);this.minY-=(this.nodeSize*3);this.maxX+=(this.nodeSize*3);this.maxY+=(this.nodeSize*3);this.rangeX=this.maxX-this.minX;this.rangeY=this.maxY-this.minY}};this.setNetworkRotation=function(){if(this.is3DNetwork&&this.layoutDone){var e=[];var b=[];var k=[];this.set3DRotation();for(var c=0;c<this.data.nodes.length;c++){b.push(c);var a=this.data.nodes[c];var d=this.get3DTransfrom(a.x,a.y,a.z);a.x3d=d[0];a.y3d=d[1];a.z3d=d[2];e.push(Math.sqrt((a.x3d*a.x3d)+(a.y3d*a.y3d)+(a.z3d*a.z3d)))}b.sort(function(l,i){return e[i]-e[l]});for(var j=0;j<this.data.nodes.length;j++){var c=b[j];var a=this.data.nodes[c];k.push(a)}this.data.nodes=k;this.setNodeIndices()}else{if(this.network2DRotate!=0){if(this.network2DRotate>=Math.abs(360)){this.network2DRotate=0}var f=Math.PI*this.network2DRotate/360;for(var c=0;c<this.data.nodes.length;c++){var a=this.data.nodes[c];if(a.x!=null&&a.y!=null){var h=a.x;var g=a.y;a.x=(h*Math.cos(f))-(g*Math.sin(f));a.y=(g*Math.cos(f))+(h*Math.sin(f))}}if(this.data.legend.pos.nodes.x&&this.data.legend.pos.nodes.y){var h=this.data.legend.pos.nodes.x;var g=this.data.legend.pos.nodes.y;this.data.legend.pos.nodes.x=(h*Math.cos(f))-(g*Math.sin(f));this.data.legend.pos.nodes.y=(g*Math.cos(f))+(h*Math.sin(f))}if(this.data.legend.pos.edges.x&&this.data.legend.pos.edges.y){var h=this.data.legend.pos.edges.x;var g=this.data.legend.pos.edges.y;this.data.legend.pos.edges.x=(h*Math.cos(f))-(g*Math.sin(f));this.data.legend.pos.edges.y=(g*Math.cos(f))+(h*Math.sin(f))}if(this.data.legend.text){for(var c=0;c<this.data.legend.text.length;c++){var h=this.data.legend.text[c].x;var g=this.data.legend.text[c].y;this.data.legend.text[c].x=(h*Math.cos(f))-(g*Math.sin(f));this.data.legend.text[c].y=(g*Math.cos(f))+(h*Math.sin(f))}}this.network2DRotate=0}}};this.setNetworkScaleFactor=function(){if(!this.networkFreeze||this.scaleFactor==null){this.scaleFactor=this.networkLayoutType=="radial"?0.3:Math.min(this.x/(this.maxX-this.minX),this.y/(this.maxY-this.minY));this.scaleFactor*=this.zoom;this.widthBounds=this.x/this.scaleFactor;this.heightBounds=this.y/this.scaleFactor}this.offsetX=((this.widthBounds/2)-((this.minX+this.maxX)/2))+this.panningX+this.panningGlobalX;this.offsetY=((this.heightBounds/2)-((this.minY+this.maxY)/2))+this.panningY+this.panningGlobalY};this.optimizeNetworkLayout=function(){if(this.data.nodes.length>0){this.isAnimation=true;this.setInitialForceDirectedLayout();this.preUpdateTime=new Date().getTime();var a=this.layoutTime*1000;var b=this;var c=function(){this.update=function(){if(b.updateForceDirectedLayout(1000/30)||(a&&new Date().getTime()-b.preUpdateTime>a)){b.layoutDone=true;clearInterval(d);b.isAnimation=false}b.renderNetwork()};var d=setInterval(this.update,1000/30)};c.call()}};this.getAngle=function(e,g,c,f,d){var b=(Math.atan2(f-g,c-e)*180/Math.PI)%360;if(!d){d=0}while(b<d){b+=360}while(b>=(d+360)){b-=360}return b};this.getPolar=function(c,b){return{x:this.networkXCenter+c*Math.cos(b*Math.PI/180),y:this.networkYCenter+c*Math.sin(b*Math.PI/180)}};this.setNodePositions=function(a){for(var c in a){var b=this.data.nodes[this.data.nodeIndices[c]];b.x=a[c].x;b.y=a[c].y}};this.animateRadialNodePositions=function(){this.isAnimation=true;var e=this;var d=50;var c=0;var b=0;for(var g in e.finalRadialNodePositions){if(this.initialRadialNodePositions[g].r==0){this.initialRadialNodePositions[g].a=this.finalRadialNodePositions[g].a}if(this.finalRadialNodePositions[g].r==0){this.finalRadialNodePositions[g].a=this.initialRadialNodePositions[g].a}var a=(this.finalRadialNodePositions[g].a-this.initialRadialNodePositions[g].a);if(a<0){a+=360}if(a>360){a-=360}if(a>180){a-=360}this.finalRadialNodePositions[g].a=(this.initialRadialNodePositions[g].a+a)}var f=function(){this.update=function(){var j={};var q=Math.atan((c/d)*10-5)*0.5/Math.atan(5)+0.5;var m=1-q;for(var l in e.finalRadialNodePositions){var i=((m*e.initialRadialNodePositions[l].a)+(q*e.finalRadialNodePositions[l].a));var k=((m*e.initialRadialNodePositions[l].r)+(q*e.finalRadialNodePositions[l].r));var p=e.getPolar(k,i);j[l]={x:p.x,y:p.y}}if(c>=d){clearInterval(h);e.isAnimation=false;j=e.finalRadialNodePositions}c++;e.setNodePositions(j);e.renderNetwork()};var h=setInterval(this.update,50)};f.call()};this.setFinalRadialNodePositions=function(e,d){if(!this.finalRadialNodePositions){this.finalRadialNodePositions={}}if(!this.nodeParentHood.drawn.hasOwnProperty(e)){var m,o,g,n,b;var f=this.data.nodes[this.data.nodeIndices[e]];if(!f.hide&&!f.hiddenParent){if(this.nodeParentHood[e].children.length>1&&!d){var k=[];var j=this;if(this.orderRadialNetwork){this.nodeParentHood[e].children.sort(function(i,c){return j.orderRadialNetwork[i]-j.orderRadialNetwork[c]})}for(var h=0;h<this.nodeParentHood[e].children.length;h++){if(this.nodeParentHood[this.nodeParentHood[e].children[h]].level>this.nodeParentHood[e].level){this.setFinalRadialNodePositions(this.nodeParentHood[e].children[h]);k.push(this.nodeParentHood[this.nodeParentHood[e].children[h]].angle)}}if(k.length>0){if(k.length==1){n=k[0]}else{if(k[0]>k[k.length-1]){n=((k[0]+k[k.length-1])%360)/2}else{n=(k[0]+k[k.length-1])/2}}}else{this.setFinalRadialNodePositions(e,true)}}else{n=this.networkCurrentAngle;this.networkCurrentAngle=(this.networkCurrentAngle+this.networkAngleStep)}g=(this.networkDepth-1)-this.nodeParentHood[e].level;m=this.getPolar(this.networkRadialRadius,n);o=this.shortenLine(this.networkXCenter,this.networkYCenter,m.x,m.y,0,this.networkLevelSize*g,"line");b=this.lineLength(this.networkXCenter,this.networkYCenter,o[2],o[3]);if(this.nodeParentHood[e].level==0){n=0;b=0}this.finalRadialNodePositions[f.id]={x:o[2],y:o[3],r:b,a:n%360};this.nodeParentHood.drawn[e]=true;this.nodeParentHood[e].angle=n}}};this.setInitialRadialNodePositions=function(){if(!this.initialRadialNodePositions){this.initialRadialNodePositions={};for(var a=0;a<this.data.nodes.length;a++){if(!this.data.nodes[a].hide&&!this.data.nodes[a].hiddenParent){var b=this.data.nodes[a];this.initialRadialNodePositions[b.id]={x:this.networkXCenter,y:this.networkYCenter,r:0,a:0}}}}else{this.initialRadialNodePositions=this.finalRadialNodePositions;this.finalRadialNodePositions=false}};this.setRadialNetwrorkLayout=function(){if(this.data.nodes.length>0){this.networkLevelSize=this.x*4/(this.networkDepth*2);this.networkAngleStep=360/this.networkDivisions;this.networkCurrentAngle=this.networkCurrentAngle?this.networkCurrentAngle:0;this.networkRadialRadius=this.networkLevelSize*(this.networkDepth-1);this.setInitialRadialNodePositions();this.setFinalRadialNodePositions(this.networkRoot);this.layoutDone=true;if(this.showAnimation){this.animateRadialNodePositions()}else{this.setNodePositions(this.finalRadialNodePositions);this.renderNetwork()}}};this.createRandomNetwork=function(t){var l={};var a={};if(t){l=this.createMesh()}else{l.nodes=[];var d=Math.floor(Math.random()*this.randomNetworkNodes)+1;for(var m=0;m<d;m++){var g={};var r=Math.floor(Math.random()*this.shapes.length);var e=Math.floor(Math.random()*this.colors.length);g.id="id"+m;g.shape=this.shapes[r];g.color=this.colors[e];g.size=1;l.nodes.push(g)}l.edges=[];for(var m=0;m<l.nodes.length;m++){var f=l.nodes[m];var k=[];for(var h=0;h<Math.floor(Math.random()*this.randomNetworkNodeEdgesMax)-1;h++){k.push(Math.floor(Math.random()*d))}for(var h=0;h<k.length;h++){var c=l.nodes[k[h]];var q=m+":"+k[h];var p=k[h]+":"+m;if(f.id!=c.id&&!a.hasOwnProperty(q)&&!a.hasOwnProperty(q)){var b={};var s=Math.floor(Math.random()*this.lines.length);var e=Math.floor(Math.random()*this.colors.length);b.id1=f.id;b.id2=c.id;b.width=1;b.type=this.lines[s];b.color=this.colors[e];l.edges.push(b);a[q]=1;a[p]=1}}}}if(this.reduceRandomNetwork){var o=this.normalizeGraph(l);l=this.reduceNetwork(o,function(j,i){if(j.nodes&&i.nodes){if(j.nodes.length>=i.nodes.length){return j}else{return i}}else{if(j.nodes){return j}else{if(i.nodes){return i}else{return null}}}})}if(l.nodes.length<5){return this.createRandomNetwork(true)}else{var k=[];for(var m=0;m<l.edges.length;m++){if(l.edges[m].id1&&l.edges[m].id2){k.push(l.edges[m])}}l.edges=k;return l}};this.createMesh=function(){var f={};f.nodes=[];f.edges=[];var e=7;var a=this;for(var h=0;h<e*e;h++){var c={};var g=Math.floor(Math.random()*this.shapes.length);var b=Math.floor(Math.random()*this.colors.length);c.id="id"+h;c.shape=this.shapes[g];c.color=this.colors[b];c.size=1;f.nodes.push(c)}var d=function(m,l){var k={};var i=Math.floor(Math.random()*a.lines.length);var j=Math.floor(Math.random()*a.colors.length);k.id1=f.nodes[m].id;k.id2=f.nodes[l].id;k.width=1;k.type=a.lines[i];k.color=a.colors[j];return k};for(var h=0;h<f.nodes.length;h++){if(Math.floor(Math.random()*e)!=0){if(h+1<f.nodes.length&&(h+1)%e!=0){f.edges.push(d(h,h+1))}if(h+e<f.nodes.length){f.edges.push(d(h,h+e))}}}return f};this.setNodeChildren=function(f,b,g){this.networkDepth=b>this.networkDepth?b:this.networkDepth;var d=this.data.nodes[this.data.nodeIndices[f]];if(!d.hide&&!d.hiddenParent){var a=this.edgesForNode(this.data.edges,f);if(!this.nodeParentHood.hasOwnProperty(f)){if(a.length==1){this.networkDivisions++}if(a.length>0){for(var c=0;c<a.length;c++){if(!this.nodeParentHood[f]){this.nodeParentHood[f]={};this.nodeParentHood[f].children=[];this.nodeParentHood[f].level=b;this.nodeParentHood[f].angle=0;this.nodeParentHood[f].parent=g}this.nodeParentHood[f].level=b<this.nodeParentHood[f].level?b:this.nodeParentHood[f].level;if(a[c].id1==f){this.nodeParentHood[f].children.push(a[c].id2);this.setNodeChildren(a[c].id2,b+1,f)}else{if(a[c].id2==f){this.nodeParentHood[f].children.push(a[c].id1);this.setNodeChildren(a[c].id1,b+1,f)}}}}}else{this.nodeParentHood[f].level=b<this.nodeParentHood[f].level?b:this.nodeParentHood[f].level;for(var c=0;c<this.nodeParentHood[f].children.length;c++){var e=this.nodeParentHood[f].children[c];if(this.nodeParentHood[e]){if((b+1)<this.nodeParentHood[e].level){this.nodeParentHood[e].level=b+1;this.nodeParentHood[e].parent=f}}}}}};this.setNodeParentHood=function(){this.nodeParentHood={};if(this.networkLayoutType=="radial"){if(!this.networkRoot){this.networkRoot=this.data.nodes[0].id}this.nodeParentHood.drawn={};this.networkDepth=0;this.networkDivisions=0;this.setNodeChildren(this.networkRoot,0,false)}else{for(var a=0;a<this.data.nodes.length;a++){if(!this.data.nodes[a].hide){if(this.data.nodes[a].parentNode||this.data.nodes[a].hideChildren){if(this.data.nodes[a].parentNode&&!this.nodeParentHood.hasOwnProperty(this.data.nodes[a].parentNode)){this.nodeParentHood[this.data.nodes[a].parentNode]={}}if(this.data.nodes[a].parentNode){if(!this.nodeParentHood[this.data.nodes[a].parentNode].children){this.nodeParentHood[this.data.nodes[a].parentNode].children=[]}this.nodeParentHood[this.data.nodes[a].parentNode].children.push(this.data.nodes[a].id);if(this.data.nodes[this.data.nodeIndices[this.data.nodes[a].parentNode]].hideChildren){this.data.nodes[a].hiddenParent=true}}if(this.data.nodes[a].hideChildren){if(!this.nodeParentHood.hasOwnProperty(this.data.nodes[a].id)){this.nodeParentHood[this.data.nodes[a].id]={}}this.nodeParentHood[this.data.nodes[a].id].hideChildren=true}}}}for(var b in this.nodeParentHood){if(this.data.nodes[this.data.nodeIndices[b]].hideChildren||this.isParentHidden(b)){this.hideUnhideChildrenNodes(b,true)}else{if(this.nodeParentHood[b].children){this.hideUnhideChildrenNodes(b,false)}}}}};this.isParentHidden=function(c){var b=this.findParentNodes(c);if(b){for(var a=0;a<b.length;a++){if(this.data.nodes[this.data.nodeIndices[b[a]]].hideChildren){return true}}}return false};this.findParentNodes=function(c,a){if(this.data.nodes[this.data.nodeIndices[c]].parentNode){var b=this.data.nodes[this.data.nodeIndices[c]].parentNode;if(!a){a=[]}a.push(b);a=this.findParentNodes(b,a);return a}else{return a?a.reverse():false}};this.findChildrenNodeIndices=function(c,b){if(!b){b=[]}if(this.nodeParentHood[c]&&this.nodeParentHood[c]["children"]){for(var a=0;a<this.nodeParentHood[c]["children"].length;a++){b.push(this.data.nodeIndices[this.nodeParentHood[c]["children"][a]]);b=this.findChildrenNodeIndices(this.nodeParentHood[c]["children"][a],b)}}return b.length>0?b:false};this.hasChildren=function(a){return this.nodeParentHood[a]&&this.nodeParentHood[a].children};this.findVisibleParentNode=function(c){var b=this.findParentNodes(c);if(b){b.reverse();for(var a=0;a<b.length;a++){if(!this.nodes[b[a]].hide&&!this.nodes[b[a]].hiddenParent){return this.nodes[b[a]]}}}return false};this.collateNetworks=function(){if(this.data.nodes.length>0){var b=this.normalizeGraph({nodes:this.data.nodes,edges:this.data.edges});if(b.length>1){var e={id:"canvasXpressAnchorNode",anchor:true};this.addNode(e);for(var c=0;c<b.length;c++){var a=b[c].nodes[0];var d={id1:"canvasXpressAnchorNode",id2:a.id,anchor:true};this.addEdge(d)}}}};this.setObjectAttributes=function(){if(this.colorNodeBy){this.setAllObjectAttributes("nodes","color",this.colorNodeBy)}if(this.shapeNodeBy){this.setAllObjectAttributes("nodes","shape",this.shapeNodeBy)}if(this.sizeNodeBy){this.setAllObjectAttributes("nodes","size",this.sizeNodeBy)}if(this.sizeDecorationBy){this.setAllObjectAttributes("nodes","size",this.sizeDecorationBy,true)}if(this.colorEdgeBy){this.setAllObjectAttributes("edges","color",this.colorEdgeBy)}if(this.shapeEdgeBy){this.setAllObjectAttributes("edges","shape",this.shapeEdgeBy)}if(this.sizeEdgeBy){this.setAllObjectAttributes("edges","size",this.sizeEdgeBy)}};this.setDecorationsRangeUnits=function(){this.decorationsRange=[];var c={};if(this.showDecorations&&this.decorations.length>0){var g=[];for(var e=0;e<this.data.nodes.length;e++){var f=this.data.nodes[e];for(var d=0;d<this.decorations.length;d++){if(f[this.decorations[d]]&&!isNaN(f[this.decorations[d]])){g.push(f[this.decorations[d]])}}}this.decorationsRange=this.range(g);var a=this.decorationsRange[1]-this.decorationsRange[0];if(a==0){this.decorationsRange[1]=this.max(g)+1}var b=this.decorationsRange[0]-(a*0.05);if(b>0){this.decorationsRange[0]=b;a=this.decorationsRange[1]-this.decorationsRange[0]}this.decorationsUnits=this.decorationsHeight/a;if(!this.data.legend){this.data.legend={}}this.data.legend.decorations=[];for(var e=0;e<this.decorations.length;e++){if(this.decorationsColors[e]){c[this.decorationsColors[e]]=true;this.data.legend.decorations.push({shape:"square",color:this.decorationsColors[e],text:this.decorations[e],size:0.5,font:0.5})}else{for(var d=0;d<this.colors.length;d++){if(!c.hasOwnProperty(this.colors[d])){this.decorationsColors[e]=this.colors[d];c[this.colors[d]]=true;this.data.legend.decorations.push({shape:"square",color:this.decorationsColors[e],text:this.decorations[e],size:0.5,font:0.5});break}}}}}};this.drawNetworkPlot=function(){this.showAnimationFont=(this.showAnimationFontSize)+"Pt "+this.fontName;this.setNodeParentHood();this.setObjectAttributes();this.setDecorationsRangeUnits();if(this.calculateLayout){this.collateNetworks();this.setNetworkPrivateParams();if(this.networkLayoutType=="radial"){this.setRadialNetwrorkLayout()}else{this.optimizeNetworkLayout()}}else{this.layoutDone=true;this.renderNetwork()}if(this.networkFreezeOnLoad&&this.layoutDone){this.networkFreezeOnLoad=false;this.networkFreeze=true}};this.initializeNetwork=function(){this.setNetworkDimensions();if(!this.nodes&&this.data.nodes){this.setNodes()}if(this.randomNetwork){var a=this.createRandomNetwork();this.data.nodes=a.nodes;this.data.edges=a.edges;this.setAllNodesVisible();this.setNodes();this.layoutDone=false}this.drawNetworkPlot()};this.initializeNetwork()};CanvasXpress.prototype.Genome=function(){this.setGenomeSubtracks=function(){this.subtracks=[];this.y=this.margin*2;var e=0;for(var k=0;k<this.data.tracks.length;k++){if(this.data.tracks[k].name){this.y+=this.getFontPt(this.trackNameFont)+(this.margin*2)}var c=this.data.tracks[k];var o=c.data.length>this.showFeatureNameThereshold||c.hide?false:true;var m=c.type?c.type:"line";var b=c.width?c.width:this.featureWidthDefault;var p=c.height?c.height:this.featureHeightDefault;this.subtracks[k]={features:[],cur:[]};this.subtracks[k].cur[0]=-3;this.subtracks[k].features[0]=[];if(o){this.y+=this.getFontPt(this.featureNameFont)+this.margin}this.y+=p+this.margin;for(var g=0;g<c.data.length;g++){var d=0;var a,f;var q=c.data[g];var l=this.measureText(q.id,this.featureNameFont);var h=q.data;q.counter=e++;if(m=="box"){a=h[0][0]*this.xAxisUnit;f=h[h.length-1][1]*this.xAxisUnit}else{if(m.match(/bar|heatmap/)){a=h[0]*this.xAxisUnit;f=a+b}else{if(m=="sequence"){a=h[0]*this.xAxisUnit;f=a+(h[1].length*this.xAxisUnit)}else{a=h*this.xAxisUnit;f=a+1}}}var n=o?Math.max(a+l,f):f;while(a<(this.subtracks[k].cur[d]+2)){d++;if(!this.subtracks[k].cur[d]){if(o){this.y+=this.getFontPt(this.featureNameFont)+this.margin}this.y+=p+this.margin;this.subtracks[k].cur[d]=-3;this.subtracks[k].features[d]=[]}}this.subtracks[k].features[d].push(g);this.subtracks[k].cur[d]=n}this.y+=this.margin*2}};this.getGenomeRange=function(a){var e=[];for(var c=0;c<a.length;c++){var d=a[c].data;for(var b=1;b<d.length;b++){e.push(d[b])}}return this.range(e)};this.plotGenomeData=function(){var w,W,v,u;var C=this.getFontPt(this.trackNameFont);var I=this.getFontPt(this.featureNameFont);var b=this.marginTop+this.top+(this.margin*2);for(var R=0;R<this.data.tracks.length;R++){var x=this.marginLeft+this.left;if(this.data.tracks[R].name){this.drawText(this.data.tracks[R].name,x,b+(C/2),this.trackNameFont,this.trackNameFontColor,"left","middle");b+=C+(this.margin*2)}var B=this.cloneObject(this.data.tracks[R]);var m=B.data.length>this.showFeatureNameThereshold||B.hide?false:true;var V=B.type?B.type:"line";var f=B.height?B.height:this.featureHeightDefault;var y=B.fills?B.fills:B.fill?B.fill:this.foreground;var D=B.lines?B.lines:B.line?B.line:this.foreground;var p=V.match(/bar|heatmap/)?this.getGenomeRange(B.data):false;for(var Q=0;Q<this.subtracks[R].features.length;Q++){var r=this.subtracks[R].features[Q];for(var P=0;P<r.length;P++){var U=r[P];var H=B.data[U];var T=H.data;var t=H.id;if(V=="box"){if(T.length>0){x=this.marginLeft+this.left+((T[0][0]-this.xAxisMin)*this.xAxisUnit);if(m){this.drawText(t,x,b+(I/2),this.featureNameFont,this.featureNameFontColor,"left","middle");b+=I+this.margin}this.addArea(["rect",x,b,((T[T.length-1][1]-this.xAxisMin)*this.xAxisUnit),b+f],[H.counter]);var A=Math.floor(f*this.xAxisUnit);if(H.dir=="right"){w=(T[T.length-1][1]-this.xAxisMin)*this.xAxisUnit;if(w-A<(T[T.length-1][0]-this.xAxisMin)*this.xAxisUnit){T.pop()}else{T[T.length-1][1]-=f}x=this.marginLeft+this.left+((T[T.length-1][0]-this.xAxisMin)*this.xAxisUnit);W=b+(f/2);this.drawLine("line",x,W,w,W,y,false,"butt");x=w-((f/2)*this.xAxisUnit);this.drawLine("line",x,b,w,W,y,false,"butt");this.drawLine("line",x,b+f,w,W,y,false,"butt")}else{if(H.dir=="left"){if(x+A>(T[0][1]-this.xAxisMin)*this.xAxisUnit){T.shift()}else{T[0][0]+=f}w=this.marginLeft+this.left+((T[0][0]-this.xAxisMin)*this.xAxisUnit);W=b+(f/2);this.drawLine("line",x,W,w,W,y,false,"butt");w=x+((f/2)*this.xAxisUnit);this.drawLine("line",x,W,w,b,y,false,"butt");this.drawLine("line",x,W,w,b+f,y,false,"butt")}}for(var O=0;O<T.length;O++){x=this.marginLeft+this.left+((T[O][0]-this.xAxisMin)*this.xAxisUnit);w=((T[O][1]-this.xAxisMin)*this.xAxisUnit)-x;if(B.connect){if(O<T.length-1){W=b+(f/2);v=this.marginLeft+this.left+((T[O+1][0]-this.xAxisMin)*this.xAxisUnit);u=(((T[O][1]+((T[O+1][0]-T[O][1])/2))-this.xAxisMin)*this.xAxisUnit);this.drawLine("line",x+w,W,u,b,y,false,"butt");this.drawLine("line",u,b,v,W,y,false,"butt")}}this.rectangle(x,b,w,f,y,D)}}}else{if(V=="bar"){var a=B.autowidth?this.xAxisUnit/(T.length-1):B.width?B.width:this.featureWidthDefault;x=this.marginLeft+this.left+((T[0]-this.xAxisMin)*this.xAxisUnit);if(m){this.drawText(t,x,b+(I/2),this.featureNameFont,this.featureNameFontColor,"left","middle");b+=I+this.margin}this.addArea(["rect",x,b,x+(T.length*a),b+f],[H.counter]);w=x;var L=p[1]-p[0];var d=p[0]-(L*0.05);if(d>0){p[0]=d;L=p[1]-p[0]}var z=f/L;var c=p[1]<0?b:p[0]>=0?b+f:(b+f)-Math.abs(p[0]*z);for(var K=1;K<T.length;K++){var F=typeof y==="object"&&y[K-1]?y[K-1]:y[0];var q=typeof D==="object"&&D[K-1]?D[K-1]:D[0];var S=T[K]*z;this.rectangle(w,c,a,-S,F,q);if(B.autowidth){w+=a}else{w+=a+2}}}else{if(V=="heatmap"){var a=B.autowidth?this.xAxisUnit:B.width?B.width:this.featureWidthDefault;x=this.marginLeft+this.left+((T[0]-this.xAxisMin)*this.xAxisUnit);if(m){this.drawText(t,x,b+(I/2),this.featureNameFont,this.featureNameFontColor,"left","middle");b+=I+this.margin}this.addArea(["rect",x,b,x+a,b+f],[H.counter]);var S=f/(T.length-1);W=b;for(var K=1;K<T.length;K++){var E=T[K];var o=this.getHeatmapColor(p[0],p[1],E);if(isNaN(E)){this.rectangle(x,W,a,S,this.missingDataColor,this.missingDataColor)}else{this.rectangle(x,W,a,S,o,o)}W+=S}}else{if(V=="sequence"){var N=B.subtype;x=this.marginLeft+this.left+((T[0]-this.xAxisMin)*this.xAxisUnit);if(m){this.drawText(t,x,b+(I/2),this.featureNameFont,this.featureNameFontColor,"left","middle");b+=I+this.margin}var g=T[1].split(/ */);this.addArea(["rect",x,b,x+(g.length*this.xAxisUnit),b+I],[H.counter]);var M=0;var K=N=="DNA"?1:3;var O=this.measureText("A",this.sequenceFont)>K*this.xAxisUnit?true:false;while(g.length>0){var e=g.shift();if(e=="["){e=g.shift();var G=[];while(e!="]"){G.push(e);e=g.shift()}if(O){this.drawLine("line",x+(M*this.xAxisUnit),b,x+(M*this.xAxisUnit),b+I,this.sequenceMColor,false,"butt")}else{this.drawText(G.join("/"),x+(M*this.xAxisUnit),b+(I/2),this.sequenceFont,this.sequenceMColor,"center","middle")}M+=K}else{var o="sequence"+e.toUpperCase()+"Color";if(o=="sequenceTColor"){var J=true}if(O){this.drawLine("line",x+(M*this.xAxisUnit),b,x+(M*this.xAxisUnit),b+I,this[o],false,"butt")}else{this.drawText(e,x+(M*this.xAxisUnit),b+(I/2),this.sequenceFont,this[o],"center","middle")}M+=K}}}else{if(V=="triangle"){x=this.marginLeft+this.left+((T-this.xAxisMin)*this.xAxisUnit);if(m){this.drawText(t,x,b+(I/2),this.featureNameFont,this.featureNameFontColor,"left","middle");b+=I+this.margin}this.addArea(this.drawShape("triangle",x,b+(f/2),f,f,y,D,"closed"),[H.counter])}else{x=this.marginLeft+this.left+((T-this.xAxisMin)*this.xAxisUnit);if(m){this.drawText(t,x,b+(I/2),this.featureNameFont,this.featureNameFontColor,"left","middle");b+=I+this.margin}this.addArea(this.drawLine("line",x,b,x,b+f,D,false,"butt"),[H.counter])}}}}}if(m){b-=(I+this.margin)}}if(m){b+=I+this.margin}b+=f+this.margin}b+=(this.margin*2)}};this.setGenomeWireFrame=function(){var c=this.getFontPt(this.featureNameFont)/2;if(this.xAxisTickStyle=="dotted"){this.drawLine("dottedLine",this.marginLeft+this.left,this.marginTop+this.top,this.marginLeft+this.left,this.marginTop+this.top+this.y,this.wireColor,false,"butt")}else{this.drawLine("line",this.marginLeft+this.left,this.marginTop+this.top,this.marginLeft+this.left,this.marginTop+this.top+this.y,this.wireColor,false,"butt")}for(var b=0;b<this.xAxisValues.length;b++){var d=parseFloat(this.xAxisValues[b]);var a=this.marginLeft+this.left+((d-this.xAxisMin)*this.xAxisUnit);if(this.xAxisTickStyle=="dotted"){this.drawLine("dottedLine",a,this.marginTop+this.top,a,this.marginTop+this.top+this.y,this.wireColor,false,"butt")}else{this.drawLine("line",a,this.marginTop+this.top,a,this.marginTop+this.top+this.y,this.wireColor,false,"butt")}}if(this.xAxisTickStyle=="dotted"){this.drawLine("dottedLine",this.marginLeft+this.left+this.x,this.marginTop+this.top,this.marginLeft+this.left+this.x,this.marginTop+this.top+this.y,this.wireColor,false,"butt")}else{this.drawLine("line",this.marginLeft+this.left+this.x,this.marginTop+this.top,this.marginLeft+this.left+this.x,this.marginTop+this.top+this.y,this.wireColor,false,"butt")}};this.setGenomeTicks=function(){var c=this.getFontPt(this.featureNameFont)/2;for(var b=0;b<this.xAxisValues.length;b++){var d=parseFloat(this.xAxisValues[b]);var a=this.marginLeft+this.left+((d-this.xAxisMin)*this.xAxisUnit);if(!((b+(this.periodTicksLabels+1))%this.periodTicksLabels)){this.drawText(parseInt(d),a,this.marginTop+this.top+this.y+this.margin+c,this.featureNameFont,this.xAxisTickColor,"center","middle")}}};this.setGenomeAxisUnits=function(){this.setAxisUnits("xAxis")};this.setGenomeFontsColors=function(){this.trackNameFont=(this.trackNameFontSize)+"Pt "+this.fontName;this.featureNameFont=(this.featureNameFontSize)+"Pt "+this.fontName;this.sequenceFont=(this.sequenceFontSize)+"Pt "+this.fontName;if(!this.wireColor.match(/,0.1\)$/)){this.wireColor=this.wireColor.replace(/\)$/,",0.1)")}};this.setGenomeXDimentions=function(){if(this.width){this.x=this.width-(this.marginLeft+this.left+this.right+this.marginRight)}else{this.width=this.marginLeft+this.left+this.x+this.right+this.marginRight}};this.setGenomeYDimentions=function(){this.bottom+=this.margin+this.getFontPt(this.featureNameFont);if(this.autoAdjust||this.height<(this.marginTop+this.top+this.y+this.bottom+this.marginBottom)){this.height=this.marginTop+this.top+this.y+this.bottom+this.marginBottom}this.resizeCanvas()};this.drawGenome=function(){this.setGenomeFontsColors();this.setGenomeXDimentions();this.setGenomeAxisUnits();this.setGenomeSubtracks();this.setGenomeYDimentions();this.setGenomeWireFrame();this.plotGenomeData();this.maskPlotArea();this.setGenomeTicks()};this.initializeGenome=function(){this.drawGenome()};this.initializeGenome()};