/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;

public class ProteinAtlasExpressions {
    private TreeMap<String, ExpressionList> results;
    private String reliability;
    private ArrayList<String> expressionColumns = new ArrayList<String>(){
        {
            this.add("cellType");
            this.add("level");
            this.add("reliability");
            this.add("tissue");
            this.add("organ");
        }
    };

    public Map<String, ExpressionList> getByOrgan() {
        return this.results;
    }

    public Map<String, ExpressionList> getByCells() {
        TreeMap<String, ExpressionList> n = new TreeMap<String, ExpressionList>(new ByCellCountComparator());
        n.putAll(this.results);
        return n;
    }

    public Map<String, ExpressionList> getByLevel() {
        TreeMap<String, ExpressionList> n = new TreeMap<String, ExpressionList>(new ByOverallLevelComparator());
        n.putAll(this.results);
        return n;
    }

    public String getReliability() {
        return this.reliability;
    }

    public ProteinAtlasExpressions(ExportResultsIterator values) {
        this.results = new TreeMap();
        ByLevelComparator byLevelComparator = new ByLevelComparator();
        while (values.hasNext()) {
            ExpressionList q;
            List valuesRow = values.next();
            LinkedHashMap<String, String> resultRow = new LinkedHashMap<String, String>();
            for (int i = 0; i < this.expressionColumns.size(); ++i) {
                resultRow.put(this.expressionColumns.get(i), ((ResultElement)valuesRow.get(i)).getField().toString());
            }
            String organSlug = ((String)resultRow.get("organ")).toLowerCase().replaceAll("[^a-z0-9-]", "");
            if (!this.results.containsKey(organSlug)) {
                q = new ExpressionList(byLevelComparator);
                q.setOrganName(resultRow.get("organ"));
                this.results.put(organSlug, q);
            }
            q = this.results.get(organSlug);
            q.add(resultRow);
            q.stainingLevel.add(q.comparator.evaluate(resultRow.get("level")));
            if (this.reliability != null) continue;
            this.reliability = resultRow.get("reliability");
        }
    }

    public class ByOverallLevelComparator
    implements Comparator<String> {
        @Override
        public int compare(String aK, String bK) {
            Float aLevel = Float.valueOf(((ExpressionList)ProteinAtlasExpressions.this.results.get(aK)).stainingLevel.getLevelValue());
            Float bLevel = Float.valueOf(((ExpressionList)ProteinAtlasExpressions.this.results.get(bK)).stainingLevel.getLevelValue());
            if (aLevel.floatValue() < bLevel.floatValue()) {
                return 1;
            }
            if (aLevel.floatValue() > bLevel.floatValue()) {
                return -1;
            }
            return aK.compareTo(bK);
        }
    }

    public class ByCellCountComparator
    implements Comparator<String> {
        @Override
        public int compare(String aK, String bK) {
            Integer aSize = ((ExpressionList)ProteinAtlasExpressions.this.results.get(aK)).getValues().size();
            Integer bSize = ((ExpressionList)ProteinAtlasExpressions.this.results.get(bK)).getValues().size();
            if (aSize < bSize) {
                return 1;
            }
            if (aSize > bSize) {
                return -1;
            }
            return aK.compareTo(bK);
        }
    }

    public class ByLevelComparator
    extends StainingLevelEvaluator
    implements Comparator<String> {
        @Override
        public int compare(String aK, String bK) {
            Integer aLevel = this.evaluate(aK);
            Integer bLevel = this.evaluate(bK);
            if (aLevel < bLevel) {
                return 1;
            }
            return -1;
        }
    }

    public class StainingLevelEvaluator {
        private static final int HIGH = 3;
        private static final int MEDIUM = 2;
        private static final int LOW = 1;
        private static final int NONE = -1;
        private static final int OTHER = -2;

        public Integer evaluate(String strLevel) {
            String level = strLevel.toLowerCase();
            if ("strong".equals(level) || "high".equals(level)) {
                return 3;
            }
            if ("moderate".equals(level) || "medium".equals(level)) {
                return 2;
            }
            if ("weak".equals(level) || "low".equals(level)) {
                return 1;
            }
            if ("negative".equals(level) || "none".equals(level)) {
                return -1;
            }
            return -2;
        }

        public String reverseEvaluate(Integer levelValue) {
            switch (levelValue) {
                case 3: {
                    return "strong";
                }
                case 2: {
                    return "moderate";
                }
                case 1: {
                    return "weak";
                }
            }
            return "negative";
        }
    }

    public class ExpressionList {
        private ByLevelComparator comparator;
        private StainingLevel stainingLevel;
        private String organName;
        private TreeMap<String, Map<String, String>> values;

        public ExpressionList(Comparator<String> comparator) {
            this.comparator = (ByLevelComparator)comparator;
            this.values = new TreeMap(this.comparator);
            this.stainingLevel = new StainingLevel(this.comparator);
        }

        public void add(Map<String, String> resultRow) {
            this.values.put(resultRow.get("level"), resultRow);
        }

        public Map<String, Map<String, String>> getValues() {
            return this.values;
        }

        public void setOrganName(String string) {
            this.organName = string;
        }

        public String getOrganName() {
            return this.organName;
        }

        public StainingLevel getStainingLevel() {
            return this.stainingLevel;
        }

        public class StainingLevel {
            private Integer overall = 0;
            private Integer count = 0;
            private ByLevelComparator levelComparator;

            public StainingLevel(ByLevelComparator levelComparator) {
                this.levelComparator = levelComparator;
            }

            public void add(Integer level) {
                this.overall = this.overall + level;
                this.count = this.count + 1;
            }

            public float getLevelValue() {
                return this.overall.floatValue() / (float)this.count.intValue();
            }

            public String getLevelClass() {
                double doubleValue = this.getLevelValue();
                if (doubleValue % 1.0 > 0.5) {
                    return this.levelComparator.reverseEvaluate((int)Math.ceil(doubleValue));
                }
                return this.levelComparator.reverseEvaluate((int)Math.floor(doubleValue));
            }
        }
    }
}

