/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Gene;
import org.intermine.objectstore.ObjectStore;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.pathqueryresult.PathQueryResultHelper;
import org.intermine.web.logic.results.InlineResultsTable;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlyBaseExpressionDisplayer
extends ReportDisplayer {
    public FlyBaseExpressionDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        InterMineObject object = reportObject.getObject();
        HttpSession session = request.getSession();
        this.im = SessionMethods.getInterMineAPI((HttpSession)session);
        Model model = this.im.getModel();
        PathQuery query = new PathQuery(model);
        Gene gene = (Gene)object;
        Integer id = gene.getId();
        if (id != null) {
            String geneId = String.valueOf(id);
            try {
                query = FlyBaseExpressionDisplayer.getQuery((String)geneId, (PathQuery)query);
                Profile profile = SessionMethods.getProfile((HttpSession)session);
                PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
                ExportResultsIterator values = executor.execute(query);
                Map results = FlyBaseExpressionDisplayer.processResults((ExportResultsIterator)values);
                request.setAttribute("flybaseResults", (Object)results);
                InlineResultsTable table = this.processTable(request, reportObject);
                request.setAttribute("flybaseCollection", (Object)table);
            }
            catch (Exception e) {
                request.setAttribute("flybaseResults", new LinkedHashMap());
            }
        }
    }

    private InlineResultsTable processTable(HttpServletRequest request, ReportObject reportObject) {
        for (FieldDescriptor fd : reportObject.getClassDescriptor().getAllFieldDescriptors()) {
            if (!"rnaSeqResults".equals(fd.getName()) || !fd.isCollection()) continue;
            Collection collection = null;
            try {
                collection = (Collection)reportObject.getObject().getFieldValue("rnaSeqResults");
            }
            catch (IllegalAccessException e) {
                return null;
            }
            List lc = PathQueryResultHelper.queryForTypesInCollection((InterMineObject)reportObject.getObject(), (String)"rnaSeqResults", (ObjectStore)this.im.getObjectStore());
            InlineResultsTable t = new InlineResultsTable(collection, fd.getClassDescriptor().getModel(), SessionMethods.getWebConfig((HttpServletRequest)request), (Map)this.im.getClassKeys(), collection.size(), false, lc);
            return t;
        }
        return null;
    }

    private static Map<String, String> processResults(ExportResultsIterator it) {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        while (it.hasNext()) {
            List row = it.next();
            String stage = (String)((ResultElement)row.get(0)).getField();
            String expressionLevel = (String)((ResultElement)row.get(1)).getField();
            results.put(stage, expressionLevel);
        }
        return results;
    }

    private static PathQuery getQuery(String geneId, PathQuery query) {
        query.addViews(new String[]{"Gene.rnaSeqResults.stage", "Gene.rnaSeqResults.expressionLevel", "Gene.rnaSeqResults.expressionScore", "Gene.primaryIdentifier"});
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.id", (String)geneId));
        query.addOrderBy("Gene.rnaSeqResults.stage", OrderDirection.ASC);
        return query;
    }
}

