/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.logic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.bio.web.logic.SequenceFeatureExportUtil;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.model.bio.Protein;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.util.DynamicUtil;
import org.intermine.web.logic.session.SessionMethods;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SequenceFeatureExportUtil {
    private static final Logger LOG = Logger.getLogger(SequenceFeatureExportUtil.class);

    private SequenceFeatureExportUtil() {
    }

    public static List<Path> getExportClassPaths(PathQuery pathQuery) {
        ArrayList<Path> retPaths = new ArrayList<Path>();
        for (String view : pathQuery.getView()) {
            try {
                Path path = pathQuery.makePath(view);
                Path prefixPath = path.getPrefix();
                ClassDescriptor prefixCld = path.getLastClassDescriptor();
                Class prefixClass = DynamicUtil.getSimpleClass((Class)prefixCld.getType());
                if (!Protein.class.isAssignableFrom(prefixClass) && !SequenceFeature.class.isAssignableFrom(prefixClass) || retPaths.contains(prefixPath)) continue;
                retPaths.add(prefixPath);
            }
            catch (PathException e) {
                LOG.info((Object)("PathQuery contained an invalid path when attempting to export: " + view));
            }
        }
        return retPaths;
    }

    public static Set<String> getOrganisms(PathQuery pathQuery, HttpSession session) {
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        return SequenceFeatureExportUtil.getOrganisms((PathQuery)pathQuery, (InterMineAPI)im, (Profile)profile);
    }

    public static Set<String> getOrganisms(PathQuery pathQuery, InterMineAPI im, Profile profile) {
        WebResultsExecutor webResultsExecutor = im.getWebResultsExecutor(profile);
        HashSet<String> organismShortNames = new HashSet<String>();
        for (Path exportPath : SequenceFeatureExportUtil.getExportClassPaths((PathQuery)pathQuery)) {
            String summaryPath = exportPath.toStringNoConstraints() + ".organism.shortName";
            PathQuery cloneQuery = pathQuery.clone();
            cloneQuery.addView(summaryPath);
            try {
                Results results = webResultsExecutor.summariseQuery(cloneQuery, summaryPath);
                for (ResultsRow row : results) {
                    organismShortNames.add((String)row.get(0));
                }
            }
            catch (ObjectStoreException e) {
                LOG.error((Object)("Failed to summarise path: " + summaryPath + " when retrieving organism short name for query: " + cloneQuery));
            }
        }
        return organismShortNames;
    }

    public static void isValidFastaQuery(PathQuery pq) {
        Path path;
        if (pq.getView().size() > 1) {
            throw new InvalidQueryException("Queries to this service may only have one view.");
        }
        try {
            path = pq.makePath((String)pq.getView().get(0));
        }
        catch (PathException e) {
            throw new InvalidQueryException((Throwable)e);
        }
        ClassDescriptor klazz = path.getLastClassDescriptor();
        ClassDescriptor sf = pq.getModel().getClassDescriptorByName("SequenceFeature");
        ClassDescriptor protein = pq.getModel().getClassDescriptorByName("Protein");
        if (sf == klazz || protein == klazz || klazz.getAllSuperDescriptors().contains(sf) || klazz.getAllSuperDescriptors().contains(protein)) {
            return;
        }
        throw new InvalidQueryException("Unsuitable type for export: " + klazz);
    }

    public static void isValidSequenceFeatureQuery(PathQuery pq) {
        ClassDescriptor sf = pq.getModel().getClassDescriptorByName("SequenceFeature");
        Iterator iterator = pq.getView().iterator();
        if (iterator.hasNext()) {
            Path path;
            String view = (String)iterator.next();
            try {
                path = pq.makePath(view);
            }
            catch (PathException e) {
                throw new InvalidQueryException((Throwable)e);
            }
            ClassDescriptor klazz = path.getLastClassDescriptor();
            if (sf == klazz || klazz.getAllSuperDescriptors().contains(sf)) {
                return;
            }
            throw new InvalidQueryException("Unsuitable type for export: " + klazz);
        }
    }

    public static Set<String> getTaxonIds(PathQuery pathQuery, HttpSession session) {
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        return SequenceFeatureExportUtil.getTaxonIds((PathQuery)pathQuery, (InterMineAPI)im, (Profile)profile);
    }

    public static Set<String> getTaxonIds(PathQuery pathQuery, InterMineAPI im, Profile profile) {
        WebResultsExecutor webResultsExecutor = im.getWebResultsExecutor(profile);
        HashSet<String> organismTaxonIds = new HashSet<String>();
        for (Path exportPath : SequenceFeatureExportUtil.getExportClassPaths((PathQuery)pathQuery)) {
            String summaryPath = exportPath.toStringNoConstraints() + ".organism.taxonId";
            PathQuery cloneQuery = pathQuery.clone();
            cloneQuery.addView(summaryPath);
            try {
                Results results = webResultsExecutor.summariseQuery(cloneQuery, summaryPath);
                for (ResultsRow row : results) {
                    organismTaxonIds.add(String.valueOf(row.get(0)));
                }
            }
            catch (ObjectStoreException e) {
                LOG.error((Object)("Failed to summarise path: " + summaryPath + " when retrieving organism taxon id for query: " + cloneQuery));
            }
        }
        return organismTaxonIds;
    }
}

