/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.bio.webservice.GenomicRegionSearchListInput;
import org.intermine.bio.webservice.GenomicRegionSearchService;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreQueryDurationException;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.export.Exporter;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebServiceRequestParser;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.lists.ListInput;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;

public abstract class AbstractRegionExportService
extends GenomicRegionSearchService {
    private PrintWriter pw;
    private OutputStream os;

    public AbstractRegionExportService(InterMineAPI im) {
        super(im);
    }

    public boolean isAuthenticated() {
        return true;
    }

    protected void validateState() {
    }

    protected void makeList(ListInput input, String type, Profile profile, Set<String> temporaryBagNamesAccumulator) throws Exception {
        GenomicRegionSearchListInput searchInput = (GenomicRegionSearchListInput)input;
        HashSet<Integer> objectIds = new HashSet<Integer>();
        Map queries = this.createQueries(searchInput.getSearchInfo());
        for (Map.Entry e : queries.entrySet()) {
            Query q = (Query)e.getValue();
            ObjectStore objectstore = this.im.getObjectStore();
            Results rs = objectstore.execute(q);
            for (ResultsRow rr : rs) {
                Integer id = (Integer)rr.get(0);
                objectIds.add(id);
            }
        }
        PathQuery pq = this.makePathQuery(type, objectIds);
        this.export(pq, profile);
    }

    protected PathQuery makePathQuery(String type, Collection<Integer> ids) throws Exception {
        PathQuery pq = new PathQuery(this.im.getModel());
        pq.addView(type + ".primaryIdentifier");
        pq.addConstraint((PathConstraint)Constraints.inIds((String)type, ids));
        this.checkPathQuery(pq);
        return pq;
    }

    protected void checkPathQuery(PathQuery pq) throws Exception {
    }

    protected abstract Exporter getExporter(PathQuery var1);

    protected void export(PathQuery pq, Profile profile) {
        Exporter exporter = this.getExporter(pq);
        ExportResultsIterator iter = null;
        try {
            PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
            iter = executor.execute(pq, 0, WebServiceRequestParser.DEFAULT_LIMIT.intValue());
            iter.goFaster();
            exporter.export((Iterator)iter);
        }
        catch (ObjectStoreQueryDurationException e) {
            throw new ServiceException("Query would take too long to run.", (Throwable)e);
        }
        catch (ObjectStoreException e) {
            throw new ServiceException("Could not run query.", (Throwable)e);
        }
        finally {
            if (iter != null) {
                iter.releaseGoFaster();
            }
        }
    }

    protected abstract String getSuffix();

    protected String getDefaultFileName() {
        return "results" + StringUtil.uniqueString() + this.getSuffix();
    }

    protected PrintWriter getPrintWriter() {
        return this.pw;
    }

    protected OutputStream getOutputStream() {
        return this.os;
    }

    protected abstract String getContentType();

    protected Formatter getFormatter() {
        return new PlainFormatter();
    }

    protected Output getDefaultOutput(PrintWriter out, OutputStream outputstream, String separator) {
        this.pw = out;
        this.os = outputstream;
        this.output = new StreamedOutput(out, this.getFormatter(), separator);
        if (this.isUncompressed()) {
            ResponseUtil.setCustomTypeHeader((HttpServletResponse)this.response, (String)this.getDefaultFileName(), (String)this.getContentType());
        }
        return this.output;
    }

    public Format getDefaultFormat() {
        return Format.UNKNOWN;
    }
}

