/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ExpiresHeaderFilter
implements Filter {
    static final int CACHE_DURATION_IN_SECOND = 172800;
    static final long CACHE_DURATION_IN_MS = 172800000L;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        long now = System.currentTimeMillis();
        response.addHeader("Cache-Control", "max-age=172800");
        response.addHeader("Cache-Control", "must-revalidate");
        response.setDateHeader("Last-Modified", now);
        response.setDateHeader("Expires", now + 172800000L);
        chain.doFilter(req, (ServletResponse)response);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

