/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import org.intermine.web.security.KeySourceException;
import org.intermine.web.security.PublicKeySource;

public class KeyStorePublicKeySource
implements PublicKeySource {
    private KeyStore store;

    public KeyStorePublicKeySource(KeyStore store) {
        this.store = store;
    }

    public PublicKey get(String name) throws KeySourceException {
        Certificate cert;
        try {
            cert = this.store.getCertificate(name);
        }
        catch (KeyStoreException e) {
            throw new KeySourceException((Throwable)e);
        }
        return cert.getPublicKey();
    }

    public Collection<PublicKey> getAll() throws KeySourceException {
        HashSet<PublicKey> keys = new HashSet<PublicKey>();
        try {
            Enumeration<String> aliases = this.store.aliases();
            while (aliases.hasMoreElements()) {
                keys.add(this.get(aliases.nextElement()));
            }
        }
        catch (KeyStoreException e) {
            throw new KeySourceException((Throwable)e);
        }
        return keys;
    }

    public Collection<PublicKey> getSome(String ... names) throws KeySourceException {
        HashSet<PublicKey> keys = new HashSet<PublicKey>();
        for (String name : names) {
            keys.add(this.get(name));
        }
        return keys;
    }
}

