/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.api.InterMineAPI;
import org.intermine.api.results.WebTable;
import org.intermine.metadata.Model;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;

public class AddColumnAction
extends InterMineAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String columnToAdd = request.getParameter("columnToAdd");
        HttpSession session = request.getSession();
        String tableId = request.getParameter("table");
        PagedTable pt = SessionMethods.getResultsTable((HttpSession)session, (String)tableId);
        if (columnToAdd != null && columnToAdd.length() != 0) {
            this.changeView(pt.getWebTable(), columnToAdd, request);
        }
        return new ForwardParameters(mapping.findForward("results")).addParameter("table", tableId).addParameter("page", "" + pt.getPage()).addParameter("trail", request.getParameter("trail")).forward();
    }

    private void changeView(WebTable table, String columnToAdd, HttpServletRequest request) throws PathException {
        if (this.columnAlreadyAdded(columnToAdd, table.getPathQuery().getView())) {
            return;
        }
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)request.getSession());
        Model model = im.getModel();
        ArrayList<Path> paths = new ArrayList<Path>();
        Path path = new Path(model, columnToAdd);
        paths.add(path);
        table.getColumnsPath().add(path);
        table.addColumns(paths);
        PathQuery query = table.getPathQuery();
        query.addView(columnToAdd);
    }

    private boolean columnAlreadyAdded(String columnToAdd, List<String> displayedPaths) {
        return displayedPaths.contains(columnToAdd);
    }
}

