/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.TemplateHelper;
import org.intermine.api.template.TemplateManager;
import org.intermine.template.TemplateQuery;
import org.intermine.util.XmlUtil;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.TemplateAction;

public class TemplatesExportAction
extends TemplateAction {
    protected static final Logger LOG = Logger.getLogger(TemplatesExportAction.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        String name = request.getParameter("name");
        String scope = request.getParameter("scope");
        String originalTemplate = request.getParameter("originalTemplate");
        String xml = null;
        TemplateManager templateManager = im.getTemplateManager();
        if (name == null) {
            if (scope == null || scope.equals("user")) {
                xml = TemplateHelper.apiTemplateMapToXml((Map)profile.getSavedTemplates(), (int)2);
            } else {
                if (!scope.equals("global")) throw new IllegalArgumentException("Cannot export all templates for scope " + scope);
                xml = TemplateHelper.apiTemplateMapToXml((Map)templateManager.getGlobalTemplates(), (int)2);
            }
        } else {
            TemplateQuery template;
            Object object = template = originalTemplate != null ? templateManager.getTemplate(profile, name, scope) : (TemplateQuery)SessionMethods.getQuery((HttpSession)session);
            if (template != null) {
                xml = template.toXml(2);
            } else {
                this.recordError(new ActionMessage("errors.template.missing", (Object)name), request);
                return mapping.findForward("mymine");
            }
        }
        xml = XmlUtil.indentXmlSimple((String)xml);
        response.setContentType("text/plain; charset=utf-8");
        response.getWriter().write(xml);
        return null;
    }
}

