/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.search;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.FacetField;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.searchengine.KeywordSearchFacet;
import org.intermine.api.searchengine.KeywordSearchFacetData;
import org.intermine.api.searchengine.KeywordSearchPropertiesManager;
import org.intermine.api.searchengine.KeywordSearchResults;
import org.intermine.api.searchengine.solr.SolrKeywordSearchHandler;
import org.intermine.objectstore.ObjectStore;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.RequestUtil;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.search.KeywordSearchResult;
import org.intermine.web.search.SearchUtils;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.search.QuickSearch;
import org.intermine.webservice.server.search.QuickSearchJSONProcessor;
import org.intermine.webservice.server.search.QuickSearchResultProcessor;
import org.intermine.webservice.server.search.QuickSearchTextProcessor;
import org.intermine.webservice.server.search.QuickSearchXMLProcessor;

/*
 * Exception performing whole class analysis ignored.
 */
public class QuickSearch
extends JSONService {
    private static final String FACET_PREFIX = "facet_";
    private static final int PREFIX_LEN = "facet_".length();
    private static final Logger LOG = Logger.getLogger(QuickSearch.class);
    private Map<String, Map<String, Object>> headerObjs = new HashMap();
    Map<String, String> kvPairs = new HashMap();
    private final ServletContext servletContext;

    public QuickSearch(InterMineAPI im, ServletContext ctx) {
        super(im);
        this.servletContext = ctx;
    }

    protected void execute() throws Exception {
        String contextPath = this.servletContext.getRealPath("/");
        KeywordSearchPropertiesManager keywordSearchPropertiesManager = KeywordSearchPropertiesManager.getInstance((ObjectStore)this.im.getObjectStore());
        WebConfig wc = InterMineContext.getWebConfig();
        QuickSearchRequest input = new QuickSearchRequest(this);
        Vector facets = keywordSearchPropertiesManager.getFacets();
        Map facetValues = this.getFacetValues(facets);
        SolrKeywordSearchHandler keywordSearchHandler = new SolrKeywordSearchHandler();
        KeywordSearchResults results = keywordSearchHandler.doKeywordSearch(this.im, QuickSearchRequest.access$000((QuickSearchRequest)input), facetValues, input.getListIds(), QuickSearchRequest.access$100((QuickSearchRequest)input));
        Collection searchResultsParsed = SearchUtils.parseResults((InterMineAPI)this.im, (WebConfig)wc, (Collection)results.getHits());
        if (input.getIncludeFacets()) {
            HashMap facetData = new HashMap();
            for (KeywordSearchFacet kwsf : results.getFacets()) {
                HashMap<String, Integer> sfData = new HashMap<String, Integer>();
                List items = kwsf.getItems();
                for (FacetField.Count key : items) {
                    sfData.put(key.getName(), (int)key.getCount());
                }
                facetData.put(kwsf.getField(), sfData);
            }
            this.headerObjs.put("facets", facetData);
        }
        this.kvPairs.put("totalHits", String.valueOf(results.getTotalHits()));
        QuickSearchResultProcessor processor = this.getProcessor();
        Iterator it = searchResultsParsed.iterator();
        int i = 0;
        while (input.wantsMore(i) && it.hasNext()) {
            KeywordSearchResult kwsr = (KeywordSearchResult)it.next();
            this.output.addResultItem(processor.formatResult(kwsr, input.wantsMore(i + 1) && it.hasNext()));
            ++i;
        }
    }

    protected Map<String, Object> getHeaderAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(super.getHeaderAttributes());
        if (this.formatIsJSON()) {
            attributes.put("key_value_pairs", this.kvPairs);
            attributes.put("intro", "\"results\":[");
            attributes.put("outro", "]");
            attributes.put("headerObjs", this.headerObjs);
        }
        return attributes;
    }

    private Map<String, String> getFacetValues(Vector<KeywordSearchFacetData> facets) {
        HashMap<String, String> facetValues = new HashMap<String, String>();
        Enumeration params = this.request.getParameterNames();
        block0: while (params.hasMoreElements()) {
            String facetField;
            String param = (String)params.nextElement();
            String value = this.request.getParameter(param);
            if (!param.startsWith("facet_") || StringUtils.isBlank((String)value) || StringUtils.isBlank((String)(facetField = param.substring(PREFIX_LEN)))) continue;
            for (KeywordSearchFacetData facet : facets) {
                if (!facetField.equals(facet.getField())) continue;
                facetValues.put(facetField, value);
                continue block0;
            }
        }
        return facetValues;
    }

    private QuickSearchResultProcessor getProcessor() {
        if (this.formatIsJSON()) {
            return new QuickSearchJSONProcessor();
        }
        if (this.formatIsXML()) {
            return new QuickSearchXMLProcessor();
        }
        String separator = RequestUtil.isWindowsClient((HttpServletRequest)this.request) ? "\r\n" : "\n";
        return new QuickSearchTextProcessor(separator);
    }

    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader((HttpServletResponse)this.response, (String)"search.xml");
        return new StreamedOutput(out, (Formatter)new QuickSearchXMLFormatter(this, null));
    }

    static /* synthetic */ HttpServletRequest access$200(QuickSearch x0) {
        return x0.request;
    }

    static /* synthetic */ Logger access$300() {
        return LOG;
    }

    static /* synthetic */ HttpServletRequest access$400(QuickSearch x0) {
        return x0.request;
    }

    static /* synthetic */ HttpServletRequest access$500(QuickSearch x0) {
        return x0.request;
    }

    static /* synthetic */ HttpServletRequest access$600(QuickSearch x0) {
        return x0.request;
    }

    static /* synthetic */ HttpServletRequest access$700(QuickSearch x0) {
        return x0.request;
    }

    static /* synthetic */ InterMineAPI access$800(QuickSearch x0) {
        return x0.im;
    }

    static /* synthetic */ ProfileManager.ApiPermission access$900(QuickSearch x0) {
        return x0.getPermission();
    }
}

