/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.template.TemplatePopulator;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplatePopulatorException;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.template.TemplateResultInput;
import org.intermine.web.logic.template.Templates;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.query.QueryToListService;
import org.intermine.webservice.server.template.result.TemplateResultRequestParser;

public class TemplateToListService
extends QueryToListService {
    private static final String NOT_LISTABLE = "You cannot make lists from objects of type ";
    private static final String INVALID_VIEW = "The new view string is not a valid path";
    private static final String NOT_IM_OBJECT = "The new view string refers to an attribute which is not the object id";
    private static final String BAD_CONSTRAINT_VALUES = "Could not apply template constraint values. ";
    private static final String NEW_VIEW_PARAM = "path";
    private final TemplateManager templateManager;

    public TemplateToListService(InterMineAPI im) {
        super(im);
        this.templateManager = im.getTemplateManager();
    }

    protected PathQuery getQuery(HttpServletRequest request) {
        TemplateQuery populatedTemplate;
        Map templateValues;
        Path newViewPath;
        String newViewString = request.getParameter(NEW_VIEW_PARAM);
        if (StringUtils.isEmpty((String)newViewString)) {
            throw new BadRequestException("new view string is blank");
        }
        Profile profile = this.getPermission().getProfile();
        TemplateResultInput input = new TemplateResultRequestParser(request).getInput();
        ApiTemplate template = this.templateManager.getUserOrGlobalTemplate(profile, input.getName());
        try {
            newViewPath = template.makePath(newViewString);
        }
        catch (PathException e) {
            throw new BadRequestException(INVALID_VIEW, (Throwable)e);
        }
        if (newViewPath.endIsAttribute()) {
            if (!newViewString.endsWith(".id")) {
                throw new BadRequestException(NOT_IM_OBJECT);
            }
        } else {
            try {
                newViewString = newViewPath.append("id").getNoConstraintsString();
            }
            catch (PathException e) {
                throw new BadRequestException(NOT_LISTABLE + newViewPath.getLastClassDescriptor().getUnqualifiedName());
            }
        }
        try {
            templateValues = Templates.getValuesFromInput((TemplateQuery)template, (TemplateResultInput)input);
        }
        catch (Templates.TemplateValueParseException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        try {
            populatedTemplate = TemplatePopulator.getPopulatedTemplate((TemplateQuery)template, (Map)templateValues);
        }
        catch (TemplatePopulatorException e) {
            throw new BadRequestException(BAD_CONSTRAINT_VALUES + e.getMessage(), (Throwable)e);
        }
        PathQuery pq = populatedTemplate.getQueryToExecute();
        pq.clearView();
        pq.addView(newViewString);
        return pq;
    }
}

