/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.xml.ProfileBinding;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.context.MailAction;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.user.DeletionToken;
import org.intermine.webservice.server.user.DeletionTokens;
import org.intermine.webservice.server.user.DeregistrationService;
import org.intermine.webservice.server.user.UserDataFormatter;

public class DeregistrationService
extends WebService {
    private DeletionTokens tokens = DeletionTokens.getInstance();

    public DeregistrationService(InterMineAPI im) {
        super(im);
    }

    protected void validateState() {
        if (!this.isAuthenticated() || this.getPermission().isRO()) {
            throw new ServiceForbiddenException("Access denied");
        }
    }

    protected Format getDefaultFormat() {
        return Format.XML;
    }

    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader((HttpServletResponse)this.response, (String)"data.xml");
        return new StreamedOutput(out, (Formatter)new UserDataFormatter(), separator);
    }

    protected void execute() {
        XMLStreamWriter writer;
        DeletionToken token;
        String uuid = this.getRequiredParameter("deregistrationToken");
        Profile profile = this.getPermission().getProfile();
        try {
            UUID key = UUID.fromString(uuid);
            token = this.tokens.retrieveToken(key);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(uuid + " is not a deletion token.");
        }
        catch (DeletionTokens.TokenExpired e) {
            throw new BadRequestException("token expired.");
        }
        if (!profile.equals(token.getProfile())) {
            throw new ServiceForbiddenException("Access denied");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            writer = factory.createXMLStreamWriter(os);
        }
        catch (XMLStreamException e) {
            throw new ServiceException("Could not export personal data", (Throwable)e);
        }
        try {
            ProfileBinding.marshal((Profile)profile, (ObjectStore)this.im.getUserProfile(), (XMLStreamWriter)writer, (int)2, (Map)this.im.getClassKeys());
        }
        catch (Exception e) {
            throw new ServiceException("Error exporting userprofile", (Throwable)e);
        }
        String userData = os.toString();
        GoodbyeAction action = new GoodbyeAction(this, profile.getUsername(), userData);
        if (!InterMineContext.queueMessage((MailAction)action)) {
            throw new ServiceException("Cannot send your archive at this time, try again later.", 503);
        }
        try {
            this.im.getProfileManager().deleteProfile(profile);
        }
        catch (ObjectStoreException e) {
            throw new ServiceException("Could not delete your profile.", (Throwable)e);
        }
        this.output.addResultItem(Arrays.asList(userData));
    }
}

