/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.webservice.server.core.ReadWriteJSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;

public class TokenService
extends ReadWriteJSONService {
    public TokenService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        ProfileManager pm = this.im.getProfileManager();
        Profile profile = this.getPermission().getProfile();
        String tokenType = this.getOptionalParameter("type", "day").toLowerCase();
        String message = this.getOptionalParameter("message");
        String token = this.getToken(pm, profile, tokenType, message);
        this.addResultValue((CharSequence)token, false);
    }

    private String getToken(ProfileManager pm, Profile profile, String tokenType, String message) throws ObjectStoreException {
        if ("day".equals(tokenType)) {
            return pm.generate24hrKey(profile);
        }
        if ("once".equals(tokenType)) {
            return pm.generateSingleUseKey(profile);
        }
        if ("api".equals(tokenType)) {
            return pm.generateApiKey(profile);
        }
        if ("perm".equals(tokenType)) {
            if (profile.getUserId() == null) {
                throw new BadRequestException("Temporary users cannot have permanent tokens");
            }
            return pm.generateReadOnlyAccessToken(profile, message);
        }
        throw new BadRequestException("Unknown token type: " + tokenType);
    }

    protected String getResultsKey() {
        return "token";
    }
}

