/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.model.InterMineObject;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;

public class GeneIdentifiersDisplayer
extends ReportDisplayer {
    protected static final Logger LOG = Logger.getLogger(GeneIdentifiersDisplayer.class);
    private final String[] identifiers = new String[]{"primaryIdentifier", "secondaryIdentifier", "symbol"};

    public GeneIdentifiersDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        InterMineObject imObj = reportObject.getObject();
        try {
            for (String identifier : this.identifiers) {
                Object id = imObj.getFieldValue(identifier);
                if (id == null) continue;
                String value = id.toString();
                if (result.values().contains(value)) continue;
                result.put(identifier, value);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        request.setAttribute("identifiers", result);
    }
}

