/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.pathqueryresult.PathQueryResultHelper;
import org.intermine.web.logic.results.InlineResultsTable;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class MouseAllelesDisplayer
extends ReportDisplayer {
    protected static final Logger LOG = Logger.getLogger(MouseAllelesDisplayer.class);

    public MouseAllelesDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        ExportResultsIterator qResults;
        HttpSession session = request.getSession();
        this.im = SessionMethods.getInterMineAPI((HttpSession)session);
        Model model = this.im.getModel();
        PathQueryExecutor executor = this.im.getPathQueryExecutor(SessionMethods.getProfile((HttpSession)session));
        PathQuery q = new PathQuery(model);
        Integer alleleCount = 0;
        Boolean mouser = false;
        if (!MouseAllelesDisplayer.isThisAMouser(reportObject).booleanValue()) {
            q.addViews(new String[]{"Gene.symbol", "Gene.primaryIdentifier", "Gene.id", "Gene.homologues.homologue.alleles.genotypes.phenotypeTerms.name"});
            q.addViews(new String[]{"Gene.homologues.homologue.id", "Gene.homologues.homologue.alleles.id", "Gene.homologues.homologue.alleles.genotypes.id"});
            q.addConstraint((PathConstraint)Constraints.eq((String)"Gene.homologues.homologue.organism.shortName", (String)"M. musculus"), "A");
            q.addConstraint((PathConstraint)Constraints.eq((String)"Gene.id", (String)reportObject.getObject().getId().toString()), "B");
            q.addConstraint((PathConstraint)Constraints.isNotNull((String)"Gene.homologues.homologue.alleles.id"));
            q.setConstraintLogic("A and B");
            q.addOrderBy("Gene.homologues.homologue.id", OrderDirection.ASC);
            PathQuery cq = new PathQuery(this.im.getModel());
            cq.addViews(new String[]{"Gene.homologues.homologue.alleles.primaryIdentifier"});
            cq.addConstraint((PathConstraint)Constraints.eq((String)"Gene.homologues.homologue.organism.shortName", (String)"M. musculus"), "A");
            cq.addConstraint((PathConstraint)Constraints.eq((String)"Gene.id", (String)reportObject.getObject().getId().toString()), "B");
            cq.setConstraintLogic("A and B");
            try {
                alleleCount = executor.count(cq);
            }
            catch (ObjectStoreException objectStoreException) {}
        } else {
            mouser = true;
            q.addViews(new String[]{"Gene.symbol", "Gene.primaryIdentifier", "Gene.id", "Gene.alleles.genotypes.phenotypeTerms.name"});
            q.addViews(new String[]{"Gene.alleles.id", "Gene.alleles.genotypes.id"});
            q.addConstraint((PathConstraint)Constraints.eq((String)"Gene.id", (String)reportObject.getObject().getId().toString()), "A");
            q.addConstraint((PathConstraint)Constraints.isNotNull((String)"Gene.alleles.id"));
            for (FieldDescriptor fd : reportObject.getClassDescriptor().getAllFieldDescriptors()) {
                if (!"alleles".equals(fd.getName()) || !fd.isCollection()) continue;
                Collection collection = null;
                try {
                    collection = (Collection)reportObject.getObject().getFieldValue("alleles");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                List lc = PathQueryResultHelper.queryForTypesInCollection((InterMineObject)reportObject.getObject(), (String)"alleles", (ObjectStore)this.im.getObjectStore());
                if (collection == null) {
                    return;
                }
                InlineResultsTable t = new InlineResultsTable(collection, fd.getClassDescriptor().getModel(), SessionMethods.getWebConfig((HttpServletRequest)request), (Map)this.im.getClassKeys(), collection.size(), false, lc);
                request.setAttribute("collection", (Object)t);
                alleleCount = collection.size();
                break;
            }
        }
        try {
            qResults = executor.execute(q);
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
        HashMap counts = new HashMap();
        while (qResults.hasNext()) {
            String alleleTerm;
            HashMap terms;
            List row = qResults.next();
            String sourceGeneSymbol = MouseAllelesDisplayer.getIdentifier(row);
            if (!counts.containsKey(sourceGeneSymbol)) {
                HashMap<String, Object> wrapper = new HashMap<String, Object>();
                terms = new LinkedHashMap();
                wrapper.put("terms", terms);
                wrapper.put("homologueId", mouser != false ? ((ResultElement)row.get(2)).getField().toString() : ((ResultElement)row.get(4)).getField().toString());
                wrapper.put("isMouser", mouser);
                counts.put(sourceGeneSymbol, wrapper);
            } else {
                terms = (HashMap)((HashMap)counts.get(sourceGeneSymbol)).get("terms");
            }
            if ((alleleTerm = ((ResultElement)row.get(3)).getField().toString()).isEmpty()) continue;
            if (!terms.containsKey(alleleTerm)) {
                terms.put(alleleTerm, 1);
                continue;
            }
            terms.put(alleleTerm, (Integer)terms.get(alleleTerm) + 1);
        }
        HashMap top = new HashMap();
        for (String symbol : counts.keySet()) {
            HashMap gene = (HashMap)counts.get(symbol);
            LinkedHashMap terms = (LinkedHashMap)gene.get("terms");
            if (terms == null) continue;
            TreeMap<String, Integer> sorted = new TreeMap<String, Integer>(new IntegerValueComparator(terms));
            for (String term : terms.keySet()) {
                sorted.put(term, (Integer)terms.get(term));
            }
            TreeMap marked = new TreeMap();
            Integer i = 0;
            for (String term : sorted.keySet()) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                Boolean topTerm = false;
                if (i < 20) {
                    topTerm = true;
                }
                m.put("top", topTerm);
                m.put("count", sorted.get(term));
                m.put("url", MouseAllelesDisplayer.getUrl((String)gene.get("homologueId"), term));
                marked.put(term, m);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            HashMap wrapper = new HashMap();
            wrapper.put("terms", marked);
            wrapper.put("homologueId", gene.get("homologueId"));
            wrapper.put("isMouser", gene.get("isMouser"));
            top.put(symbol, wrapper);
        }
        request.setAttribute("thisIsAMouser", (Object)mouser);
        request.setAttribute("counts", top);
        request.setAttribute("alleleCount", (Object)alleleCount);
    }

    private static String getUrl(String geneId, String term) {
        String url = "<query name=\"\" model=\"genomic\" view=\"Gene.alleles.genotypes.phenotypeTerms.name Gene.alleles.symbol Gene.alleles.primaryIdentifier Gene.alleles.genotypes.name Gene.alleles.name Gene.alleles.type Gene.alleles.genotypes.geneticBackground Gene.alleles.genotypes.zygosity Gene.alleles.organism.name\" longDescription=\"\" constraintLogic=\"B and C and A\"><constraint path=\"Gene.alleles.genotypes.phenotypeTerms.name\" code=\"B\" op=\"=\" value=\"" + term + "\"/><constraint path=\"Gene.organism.species\" code=\"C\" op=\"=\" value=\"musculus\"/><constraint path=\"Gene.id\" code=\"A\" op=\"=\" value=\"" + geneId + "\"/></query>";
        return url;
    }

    private static String getIdentifier(List<ResultElement> row) {
        String symbol = null;
        String primaryId = null;
        String id = null;
        if (row.get(0).getField() != null && StringUtils.isNotEmpty((String)(symbol = row.get(0).getField().toString()))) {
            return symbol;
        }
        if (row.get(1).getField() != null && StringUtils.isNotEmpty((String)(primaryId = row.get(1).getField().toString()))) {
            return primaryId;
        }
        return id;
    }

    private static Boolean isThisAMouser(ReportObject reportObject) {
        try {
            return "Mus".equals(((InterMineObject)reportObject.getObject().getFieldValue("organism")).getFieldValue("genus"));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    class IntegerValueComparator
    implements Comparator {
        Map base;

        public IntegerValueComparator(Map base) {
            this.base = base;
        }

        public int compare(Object a, Object b) {
            Integer aV = (Integer)this.base.get(a);
            Integer bV = (Integer)this.base.get(b);
            if (aV < bV) {
                return 1;
            }
            if (aV == bV) {
                return a.toString().compareTo(b.toString());
            }
            return -1;
        }
    }
}

