/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.struts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.bio.web.logic.GenomicRegionSearchQueryRunner;
import org.intermine.bio.web.logic.GenomicRegionSearchService;
import org.intermine.bio.web.logic.GenomicRegionSearchUtil;
import org.intermine.bio.web.logic.LiftOverService;
import org.intermine.bio.web.model.ChromosomeInfo;
import org.intermine.bio.web.model.GenomicRegion;
import org.intermine.bio.web.struts.GenomicRegionSearchForm;
import org.intermine.objectstore.query.Query;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class GenomicRegionSearchAction
extends InterMineAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GenomicRegionSearchForm grsForm = (GenomicRegionSearchForm)form;
        String organism = (String)grsForm.get("organism");
        if ("".equals(organism)) {
            this.recordError(new ActionMessage("genomicRegionSearch.organismEmpty"), request);
            return mapping.findForward("genomicRegionSearchOptions");
        }
        String spanUUIDString = UUID.randomUUID().toString();
        request.setAttribute("spanUUIDString", (Object)spanUUIDString);
        GenomicRegionSearchService grsService = GenomicRegionSearchUtil.getGenomicRegionSearchService(request);
        ActionMessage actmsg = grsService.parseGenomicRegionSearchForm(grsForm);
        if (actmsg != null) {
            this.recordError(actmsg, request);
            return mapping.findForward("genomicRegionSearchOptions");
        }
        Properties webProperties = SessionMethods.getWebProperties((ServletContext)request.getSession().getServletContext());
        String liftOver = webProperties.getProperty("genomicRegionSearch.liftOver");
        String liftOverServiceUrl = webProperties.getProperty("genomicRegionSearch.liftOver.url");
        if ("true".equals(liftOver) && !"".equals(liftOverServiceUrl) && liftOverServiceUrl != null) {
            String liftOverServiceAvailable = (String)grsForm.get("liftover-service-available");
            String genomeVersionSource = (String)grsForm.get("liftover-genome-version-source");
            String genomeVersionTarget = (String)grsForm.get("liftover-genome-version-target");
            if (genomeVersionSource.contains("/")) {
                genomeVersionSource = genomeVersionSource.substring(genomeVersionSource.indexOf("/") + 1);
            }
            if (genomeVersionTarget.contains("/")) {
                genomeVersionTarget = genomeVersionTarget.substring(genomeVersionTarget.indexOf("/") + 1);
            }
            if ("true".equals(liftOverServiceAvailable) && "true".equals(liftOver) && liftOverServiceUrl.length() > 0 && !genomeVersionSource.equals(genomeVersionTarget)) {
                LiftOverService los = new LiftOverService();
                String liftOverResponse = los.doLiftOver(grsService.getConstraint(), organism, genomeVersionSource, genomeVersionTarget, liftOverServiceUrl);
                ArrayList<GenomicRegion> liftedList = new ArrayList<GenomicRegion>();
                StringBuffer unmapped = new StringBuffer();
                try {
                    int i;
                    JSONObject json = new JSONObject(liftOverResponse);
                    JSONArray liftedArray = json.getJSONArray("coords");
                    JSONArray unmappedArray = json.getJSONArray("unmapped");
                    for (i = 0; i < liftedArray.length(); ++i) {
                        String coord = (String)liftedArray.get(i);
                        coord.trim();
                        GenomicRegion gr = new GenomicRegion();
                        gr.setOrganism(organism);
                        gr.setExtendedRegionSize(grsService.getConstraint().getExtendedRegionSize());
                        gr.setChr(coord.split("\t")[0].trim());
                        gr.setStart(Integer.valueOf(coord.split("\t")[1].trim()));
                        gr.setEnd(Integer.valueOf(coord.split("\t")[2].trim()));
                        gr.setMinusStrand(gr.getStart() > gr.getEnd());
                        liftedList.add(gr);
                    }
                    for (i = 0; i < unmappedArray.length(); ++i) {
                        String info = (String)unmappedArray.get(i);
                        info.trim();
                        if (info.startsWith("#")) {
                            unmapped.append(info.subSequence(1, info.length() - 1)).append(" - ");
                            continue;
                        }
                        String chr = info.split("\t")[0].trim();
                        String start = info.split("\t")[1].trim();
                        String end = info.split("\t")[2].trim();
                        unmapped.append(chr + ":" + start + ".." + end).append("<br>");
                    }
                    if (!unmapped.toString().isEmpty()) {
                        request.setAttribute("liftOverStatus", (Object)("Genomic region cannot be lifted:<br>" + unmapped.toString().substring(0, unmapped.toString().lastIndexOf("<br>"))));
                    } else {
                        request.setAttribute("liftOverStatus", (Object)"All coordinates are lifted");
                    }
                    if (!liftedList.isEmpty()) {
                        grsService.getConstraint().setGenomicRegionList(liftedList);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    request.setAttribute("liftOverStatus", (Object)"<i>Genomic region coordinates are not lifted. liftOver service error, please contact system admin</i>");
                }
            }
        }
        Map<String, Map<String, ChromosomeInfo>> chrInfoMap = grsService.getChromosomeInfomationMap();
        Map<String, List<GenomicRegion>> resultMap = grsService.validateGenomicRegions();
        if (chrInfoMap != null && chrInfoMap.size() > 0 && resultMap != null) {
            String errorMsg = "";
            if (resultMap.get("error").size() == 0) {
                errorMsg = null;
            } else {
                String spanString = "";
                for (GenomicRegion span : resultMap.get("error")) {
                    spanString = spanString + span.getChr() + ":" + span.getStart() + ".." + span.getEnd() + ", ";
                }
                errorMsg = "<b>Invalid genomic regions in <i>" + grsService.getConstraint().getOrgName() + "</i>:</b> " + spanString.substring(0, spanString.lastIndexOf(","));
            }
            if (resultMap.get("error").size() == grsService.getConstraint().getGenomicRegionList().size()) {
                this.recordError(new ActionMessage("genomicRegionSearch.allRegionInvalid"), request);
                return mapping.findForward("genomicRegionSearchOptions");
            }
            grsService.getConstraint().setGenomicRegionList(resultMap.get("pass"));
            request.setAttribute("errorMsg", (Object)errorMsg);
        }
        Map<GenomicRegion, Query> queryMap = grsService.createQueryList();
        GenomicRegionSearchQueryRunner grsqRunner = new GenomicRegionSearchQueryRunner(request, spanUUIDString, grsService.getConstraint(), queryMap);
        grsqRunner.search();
        request.setAttribute("selectionInfo", grsService.getSelectionInformation());
        request.setAttribute("resultsCss", (Object)grsService.getResultsCss());
        request.setAttribute("resultsJavascript", (Object)grsService.getResultsJavascript());
        return mapping.findForward("genomicRegionSearchResults");
    }
}

