/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.Util;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Gene;
import org.intermine.model.bio.Organism;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class HomologueDisplayer
extends ReportDisplayer {
    protected static final Logger LOG = Logger.getLogger(HomologueDisplayer.class);

    public HomologueDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        ExportResultsIterator it;
        TreeMap homologues = new TreeMap();
        HashMap<String, String> organismIds = new HashMap<String, String>();
        Path symbolPath = null;
        Path primaryIdentifierPath = null;
        try {
            symbolPath = new Path(this.im.getModel(), "Gene.symbol");
            primaryIdentifierPath = new Path(this.im.getModel(), "Gene.primaryIdentifier");
        }
        catch (PathException e) {
            return;
        }
        Gene gene = (Gene)reportObject.getObject();
        HashSet<String> dataSets = new HashSet<String>();
        JSONObject params = this.config.getParameterJson();
        try {
            JSONArray dataSetsArray = params.getJSONArray("dataSets");
            for (int i = 0; i < dataSetsArray.length(); ++i) {
                dataSets.add(dataSetsArray.getString(i));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Error parsing configuration value 'dataSets'", e);
        }
        PathQuery q = HomologueDisplayer.getQuery((InterMineAPI)this.im, (Integer)gene.getId(), dataSets);
        Profile profile = SessionMethods.getProfile((HttpSession)request.getSession());
        PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
        try {
            it = executor.execute(q);
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
        while (it.hasNext()) {
            List row = it.next();
            Organism organism = (Organism)((ResultElement)row.get(0)).getObject();
            InterMineObject homologueObject = (InterMineObject)((ResultElement)row.get(1)).getObject();
            organismIds.put(organism.getSpecies(), organism.getId().toString());
            try {
                ResultElement re;
                if (homologueObject.getFieldValue("symbol") != null) {
                    re = new ResultElement((FastPathObject)homologueObject, symbolPath, true);
                    Util.addToSetMap(homologues, (Object)organism.getShortName(), (Object)re);
                    continue;
                }
                re = new ResultElement((FastPathObject)homologueObject, primaryIdentifierPath, true);
                Util.addToSetMap(homologues, (Object)organism.getShortName(), (Object)re);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("Failed to resolve path: " + symbolPath + " for gene: " + gene));
            }
        }
        request.setAttribute("organismIds", organismIds);
        request.setAttribute("homologues", homologues);
    }

    private static PathQuery getQuery(InterMineAPI im, Integer geneId, Set<String> dataSets) {
        PathQuery q = new PathQuery(im.getModel());
        q.addViews(new String[]{"Gene.homologues.homologue.organism.shortName", "Gene.homologues.homologue.primaryIdentifier"});
        q.addConstraint((PathConstraint)Constraints.eq((String)"Gene.id", (String)("" + geneId)));
        if (dataSets != null && !dataSets.isEmpty()) {
            q.addConstraint((PathConstraint)Constraints.oneOfValues((String)"Gene.homologues.dataSets.name", dataSets));
        }
        q.addConstraint((PathConstraint)Constraints.neq((String)"Gene.homologues.type", (String)"paralogue"));
        q.addOrderBy("Gene.homologues.homologue.organism.shortName", OrderDirection.ASC);
        return q;
    }
}

