/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.bio.web.model.ProteinAtlasExpressions;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Gene;
import org.intermine.model.bio.Protein;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class ProteinAtlasDisplayer
extends ReportDisplayer {
    public ProteinAtlasDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        InterMineObject object = reportObject.getObject();
        HttpSession session = request.getSession();
        Model model = this.im.getModel();
        PathQuery query = new PathQuery(model);
        if (object instanceof Gene) {
            Gene gene = (Gene)object;
            String genePrimaryIDObj = gene.getPrimaryIdentifier();
            if (genePrimaryIDObj != null) {
                ExportResultsIterator values;
                String genePrimaryID = String.valueOf(genePrimaryIDObj);
                query = this.geneProteinAtlasExpressionQuery(genePrimaryID, query);
                Profile profile = SessionMethods.getProfile((HttpSession)session);
                PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
                try {
                    values = executor.execute(query);
                }
                catch (ObjectStoreException e) {
                    throw new RuntimeException(e);
                }
                ProteinAtlasExpressions pae = new ProteinAtlasExpressions(values);
                request.setAttribute("expressions", (Object)pae);
                request.setAttribute("url", (Object)("http://www.proteinatlas.org/" + genePrimaryID + "/normal"));
            }
        } else if (object instanceof Protein) {
            // empty if block
        }
    }

    private PathQuery geneProteinAtlasExpressionQuery(String genePrimaryID, PathQuery query) {
        query.addViews(new String[]{"Gene.proteinAtlasExpression.cellType", "Gene.proteinAtlasExpression.level", "Gene.proteinAtlasExpression.reliability", "Gene.proteinAtlasExpression.tissue.name", "Gene.proteinAtlasExpression.tissue.tissueGroup.name", "Gene.primaryIdentifier"});
        query.addOrderBy("Gene.proteinAtlasExpression.tissue.name", OrderDirection.ASC);
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.primaryIdentifier", (String)genePrimaryID));
        return query;
    }
}

