/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class SnpToGeneDisplayer
extends ReportDisplayer {
    protected static final Logger LOG = Logger.getLogger(SnpToGeneDisplayer.class);

    public SnpToGeneDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        ExportResultsIterator result;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        SequenceFeature snp = (SequenceFeature)reportObject.getObject();
        PathQuery query = this.snpToGene(snp.getPrimaryIdentifier());
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        PathQueryExecutor executor = im.getPathQueryExecutor(profile);
        try {
            result = executor.execute(query);
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
        ArrayList list = new ArrayList();
        int size = 0;
        String lastID = "";
        block9: while (result.hasNext()) {
            List row = result.next();
            ArrayList<String> columns = new ArrayList<String>();
            int snpStart = 0;
            int geneStart = 0;
            int geneEnd = 0;
            String direction = null;
            String currentID = null;
            if (size == 0) {
                size = row.size();
            }
            block10: for (int i = 1; i < size; ++i) {
                Object e = ((ResultElement)row.get(i)).getField();
                switch (i) {
                    case 2: {
                        currentID = e.toString();
                        if (lastID.equals(currentID)) continue block9;
                        columns.add(currentID);
                        lastID = currentID;
                        continue block10;
                    }
                    case 5: {
                        snpStart = Integer.parseInt(e.toString());
                        continue block10;
                    }
                    case 6: {
                        geneStart = Integer.parseInt(e.toString());
                        continue block10;
                    }
                    case 7: {
                        geneEnd = Integer.parseInt(e.toString());
                        continue block10;
                    }
                    case 8: {
                        direction = e.toString();
                        continue block10;
                    }
                    default: {
                        if (e != null) {
                            columns.add(e.toString());
                            continue block10;
                        }
                        columns.add("[no value]");
                    }
                }
            }
            if (snpStart <= geneEnd) {
                if (snpStart >= geneStart) {
                    columns.add("0");
                    columns.add("");
                } else {
                    columns.add(Integer.toString(geneStart - snpStart));
                    columns.add(direction);
                }
            } else {
                columns.add(Integer.toString(snpStart - geneEnd));
                columns.add(direction);
            }
            list.add(columns);
        }
        Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        request.setAttribute("list", list);
    }

    private PathQuery snpToGene(String snpPrimaryIdentifier) {
        PathQuery query = new PathQuery(this.im.getModel());
        query.addViews(new String[]{"SNP.primaryIdentifier", "SNP.overlappingFeatures.gene.id", "SNP.overlappingFeatures.gene.primaryIdentifier", "SNP.overlappingFeatures.gene.name", "SNP.overlappingFeatures.gene.symbol", "SNP.locations.start", "SNP.overlappingFeatures.gene.locations.start", "SNP.overlappingFeatures.gene.locations.end", "SNP.overlappingFeatures.direction"});
        query.addOrderBy("SNP.primaryIdentifier", OrderDirection.ASC);
        query.addConstraint((PathConstraint)Constraints.eq((String)"SNP.primaryIdentifier", (String)snpPrimaryIdentifier));
        query.addConstraint((PathConstraint)Constraints.type((String)"SNP.overlappingFeatures", (String)"GeneFlankingRegion"));
        query.addConstraint((PathConstraint)Constraints.eq((String)"SNP.overlappingFeatures.distance", (String)"10.0kb"));
        return query;
    }
}

