/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.bio.web.export.BEDExporter;
import org.intermine.bio.web.struts.BEDExportForm;
import org.intermine.metadata.StringUtil;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.pathquery.Path;
import org.intermine.web.logic.export.ExportException;
import org.intermine.web.logic.export.ExportHelper;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.logic.export.http.HttpExportUtil;
import org.intermine.web.logic.export.http.HttpExporterBase;
import org.intermine.web.logic.export.http.TableHttpExporter;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.struts.TableExportForm;

/*
 * Exception performing whole class analysis ignored.
 */
public class BEDHttpExporter
extends HttpExporterBase
implements TableHttpExporter {
    public static final int BIG_BATCH_SIZE = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(PagedTable pt, HttpServletRequest request, HttpServletResponse response, TableExportForm form, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) {
        block14: {
            boolean doGzip = form != null && form.getDoGzip();
            HttpSession session = request.getSession();
            ServletContext servletContext = session.getServletContext();
            String organisms = null;
            boolean makeUcscCompatible = false;
            String trackDescription = null;
            if (form != null && form instanceof BEDExportForm) {
                organisms = ((BEDExportForm)form).getOrgansimString();
                trackDescription = ((BEDExportForm)form).getTrackDescription();
                if ("yes".equals(((BEDExportForm)form).getUcscCompatibleCheck())) {
                    makeUcscCompatible = true;
                }
            }
            if (doGzip) {
                ResponseUtil.setGzippedHeader((HttpServletResponse)response, (String)("table" + StringUtil.uniqueString() + ".bed.gz"));
            } else {
                BEDHttpExporter.setBEDHeader((HttpServletResponse)response);
            }
            List indexes = ExportHelper.getClassIndexes((List)ExportHelper.getColumnClasses((PagedTable)pt), SequenceFeature.class);
            Properties props = (Properties)servletContext.getAttribute("WEB_PROPERTIES");
            String sourceName = props.getProperty("project.title");
            String sourceReleaseVersion = props.getProperty("project.releaseVersion");
            if ("".equals(trackDescription) || trackDescription == null) {
                trackDescription = sourceName + " " + sourceReleaseVersion + " Custom Track";
            }
            try {
                Object out = response.getOutputStream();
                if (doGzip) {
                    out = new GZIPOutputStream((OutputStream)out);
                }
                PrintWriter writer = HttpExportUtil.getPrintWriterForClient((HttpServletRequest)request, (OutputStream)out);
                BEDExporter exporter = new BEDExporter(writer, indexes, sourceName, organisms, makeUcscCompatible, trackDescription);
                ExportResultsIterator iter = null;
                try {
                    iter = this.getResultRows(pt, request);
                    iter.goFaster();
                    exporter.export((Iterator)iter, unionPathCollection, newPathCollection);
                    if (!(out instanceof GZIPOutputStream)) break block14;
                    try {
                        ((GZIPOutputStream)out).finish();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (iter != null) {
                        iter.releaseGoFaster();
                    }
                }
            }
            catch (Exception e) {
                throw new ExportException("Export failed", e);
            }
        }
    }

    private static void setBEDHeader(HttpServletResponse response) {
        ResponseUtil.setTabHeader((HttpServletResponse)response, (String)("table" + StringUtil.uniqueString() + ".bed"));
    }

    public List<Path> getInitialExportPaths(PagedTable pt) {
        return ExportHelper.getColumnPaths((PagedTable)pt);
    }

    public boolean canExport(PagedTable pt) {
        return BEDExporter.canExportStatic((List)ExportHelper.getColumnClasses((PagedTable)pt));
    }

    public List<Path> getExportClassPaths(PagedTable pt) {
        return new ArrayList<Path>();
    }
}

