/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.export;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.api.results.ResultElement;
import org.intermine.bio.io.gff3.GFF3Record;
import org.intermine.bio.ontology.SequenceOntology;
import org.intermine.bio.ontology.SequenceOntologyFactory;
import org.intermine.bio.web.export.GFF3Util;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.pathquery.Path;
import org.intermine.util.IntPresentSet;
import org.intermine.util.PropertiesUtil;
import org.intermine.web.logic.export.ExportException;
import org.intermine.web.logic.export.ExportHelper;
import org.intermine.web.logic.export.Exporter;

/*
 * Exception performing whole class analysis ignored.
 */
public class GFF3Exporter
implements Exporter {
    private static final Logger LOG = Logger.getLogger(GFF3Exporter.class);
    public static final Set<String> GFF_FIELDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("chromosome.primaryIdentifier", "primaryIdentifier", "score")));
    public static final String WORM_LINK = "https://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=6239";
    public static final String FLY_LINK = "https://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=7227";
    PrintWriter out;
    private List<Integer> featureIndexes;
    private Map<String, String> soClassNames;
    private int writtenResultsCount = 0;
    private boolean headerPrinted = false;
    private IntPresentSet exportedIds = new IntPresentSet();
    private List<String> attributesNames;
    private String sourceName;
    private Set<String> organisms;
    private Set<String> cNames = new HashSet();
    private boolean makeUcscCompatible = false;
    private List<Path> paths = Collections.emptyList();
    private Map<String, Integer> attributeVersions = new HashMap();
    private Integer lastLsfId = null;
    private SequenceFeature lastLsf = null;
    private Map<String, List<String>> attributes = null;
    private Map<String, Set<Integer>> seenAttributes = new HashMap();

    public GFF3Exporter(PrintWriter out, List<Integer> indexes, Map<String, String> soClassNames, List<String> attributesNames, String sourceName, Set<String> organisms, boolean makeUcscCompatible) {
        this.out = out;
        this.featureIndexes = indexes;
        this.soClassNames = soClassNames;
        this.attributesNames = attributesNames;
        this.sourceName = sourceName;
        this.organisms = organisms;
        this.makeUcscCompatible = makeUcscCompatible;
        for (String s : soClassNames.keySet()) {
            this.cNames.add(s.toLowerCase());
        }
    }

    public GFF3Exporter(PrintWriter out, List<Integer> indexes, Map<String, String> soClassNames, List<String> attributesNames, String sourceName, Set<String> organisms, boolean makeUcscCompatible, List<Path> paths) {
        this.out = out;
        this.featureIndexes = indexes;
        this.soClassNames = soClassNames;
        this.attributesNames = attributesNames;
        this.sourceName = sourceName;
        this.organisms = organisms;
        this.makeUcscCompatible = makeUcscCompatible;
        this.paths = paths;
        for (String s : soClassNames.keySet()) {
            this.cNames.add(s.toLowerCase());
        }
    }

    private String getHeaderParts() {
        StringBuffer header = new StringBuffer();
        Properties props = PropertiesUtil.getProperties();
        if (this.organisms != null && !this.organisms.isEmpty()) {
            for (String taxId : this.organisms) {
                String fV;
                if (!"7227".equals(taxId) || (fV = props.getProperty("genomeVersion.fly")) == null || fV.length() <= 0) continue;
                header.append("\n##species https://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=7227");
                header.append("\n##genome-build FlyBase r" + fV);
            }
            for (String taxId : this.organisms) {
                String wV;
                if (!"6239".equals(taxId) || (wV = props.getProperty("genomeVersion.worm")) == null || wV.length() <= 0) continue;
                header.append("\n##species https://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=6239");
                header.append("\n##genome-build WormBase ws" + wV);
            }
            String mV = props.getProperty("project.releaseVersion");
            if (mV != null && mV.length() > 0) {
                header.append("\n#" + this.sourceName + " " + mV);
                header.append("\n# #index-subfeatures 1");
            }
        }
        return header.toString();
    }

    private String getHeader() {
        return "##gff-version 3" + this.getHeaderParts();
    }

    public void export(Iterator<? extends List<ResultElement>> resultIt, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) {
        if (this.featureIndexes.size() == 0) {
            throw new ExportException("No columns with sequence");
        }
        try {
            while (resultIt.hasNext()) {
                List<ResultElement> row = resultIt.next();
                this.exportRow(row, unionPathCollection, newPathCollection);
            }
            if (this.writtenResultsCount == 0) {
                this.out.println("Nothing to export. Sequence features might miss some information, e.g. chromosome location, etc.");
            }
            this.out.flush();
        }
        catch (Exception ex) {
            throw new ExportException("Export failed", ex);
        }
    }

    public void export(Iterator<? extends List<ResultElement>> resultIt) {
        this.export(resultIt, (Collection)this.paths, (Collection)this.paths);
    }

    private void exportRow(List<ResultElement> row, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) {
        List elWithObject = this.getResultElements(row);
        if (elWithObject == null) {
            return;
        }
        HashMap<String, Integer> pathToIdMap = new HashMap<String, Integer>();
        HashMap idToParentPathMap = new HashMap();
        HashMap<Integer, ResultElement> idToResultElementMap = new HashMap<Integer, ResultElement>();
        for (ResultElement el : elWithObject) {
            if (el == null) continue;
            List pathList = el.getPath().decomposePath();
            pathList.remove(pathList.size() - 1);
            String lastClassPath = ((Path)pathList.get(pathList.size() - 1)).toStringNoConstraints();
            Integer id = null;
            try {
                id = ((SequenceFeature)el.getObject()).getId();
            }
            catch (Exception e) {
                LOG.info((Object)"Object cannot be cast to SequenceFeature");
                continue;
            }
            idToResultElementMap.put(id, el);
            pathToIdMap.put(lastClassPath, id);
            List clsdList = el.getPath().getElementClassDescriptors();
            LinkedList<String> parentPaths = new LinkedList<String>();
            for (int i = clsdList.size() - 2; i >= 0 && SequenceFeature.class.isAssignableFrom(((ClassDescriptor)clsdList.get(i)).getType()); --i) {
                parentPaths.add(((Path)pathList.get(i)).toStringNoConstraints());
            }
            idToParentPathMap.put(id, parentPaths);
        }
        SequenceOntology so = SequenceOntologyFactory.getSequenceOntology();
        Path lastLsfPath = null;
        for (ResultElement re : elWithObject) {
            try {
                SequenceFeature lsf = (SequenceFeature)re.getObject();
                if (this.exportedIds.contains(lsf.getId()) && !lsf.getId().equals(this.lastLsfId)) continue;
                if (this.lastLsfId != null && !lsf.getId().equals(this.lastLsfId)) {
                    this.processAttributes(row, unionPathCollection, newPathCollection, re.getPath());
                    this.processParent(pathToIdMap, idToParentPathMap, idToResultElementMap, so);
                    this.makeRecord();
                }
                if (this.lastLsfId == null) {
                    this.attributes = new LinkedHashMap();
                }
                this.lastLsfId = lsf.getId();
                this.lastLsf = lsf;
                lastLsfPath = re.getPath();
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to write GFF3 file: " + ex));
            }
        }
        if (this.lastLsfId != null && !this.exportedIds.contains(this.lastLsfId)) {
            this.processAttributes(row, unionPathCollection, newPathCollection, lastLsfPath);
            this.processParent(pathToIdMap, idToParentPathMap, idToResultElementMap, so);
            this.makeRecord();
        }
    }

    private void processAttributes(List<ResultElement> row, Collection<Path> unionPathCollection, Collection<Path> newPathCollection, Path p) {
        List newRow = GFF3Exporter.filterResultRow(row, unionPathCollection, newPathCollection);
        boolean isCollection = p.containsCollections();
        for (int i = 0; i < newRow.size(); ++i) {
            ResultElement el = (ResultElement)newRow.get(i);
            if (el == null || isCollection || el.getPath().containsCollections() || "location".equalsIgnoreCase(el.getPath().getLastClassDescriptor().getUnqualifiedName()) || el.getField() == null) continue;
            String unqualName = el.getPath().getLastClassDescriptor().getUnqualifiedName();
            String attributeName = this.trimAttribute((String)this.attributesNames.get(i), unqualName);
            this.checkAttribute(el, attributeName);
        }
    }

    private void processParent(Map<String, Integer> pathToIdMap, Map<Integer, List<String>> idToParentPathMap, Map<Integer, ResultElement> idToResultElementMap, SequenceOntology so) {
        LinkedHashSet<String> addPar = new LinkedHashSet<String>();
        List<String> parentPaths = idToParentPathMap.get(this.lastLsfId);
        if (!parentPaths.isEmpty()) {
            for (String parentPath : parentPaths) {
                Integer parentId = pathToIdMap.get(parentPath);
                if (parentId == null) continue;
                SequenceFeature parent = (SequenceFeature)idToResultElementMap.get(parentId).getObject();
                String parentClassName = idToResultElementMap.get(parentId).getPath().getLastClassDescriptor().getUnqualifiedName().toLowerCase();
                String featureClassName = idToResultElementMap.get(this.lastLsfId).getPath().getLastClassDescriptor().getUnqualifiedName().toLowerCase();
                Set parentsSOTerms = so.getAllPartOfs(featureClassName);
                if (!parentsSOTerms.contains(parentClassName)) continue;
                addPar.add(parent.getPrimaryIdentifier());
            }
        }
        if (addPar.size() > 0) {
            this.attributes.put("Parent", new ArrayList(addPar));
        }
    }

    private String trimAttribute(String attribute, String unqualName) {
        if (!attribute.contains(".")) {
            return attribute;
        }
        if (this.cNames.contains(unqualName.toLowerCase())) {
            String plainAttribute = attribute.substring(attribute.lastIndexOf(46) + 1);
            return plainAttribute;
        }
        return attribute;
    }

    private void makeRecord() {
        GFF3Record gff3Record = GFF3Util.makeGFF3Record((SequenceFeature)this.lastLsf, (Map)this.soClassNames, (String)this.sourceName, (Map)this.attributes, (boolean)this.makeUcscCompatible);
        if (gff3Record != null) {
            if (!this.headerPrinted) {
                this.out.println(this.getHeader());
                this.headerPrinted = true;
            }
            this.out.println(gff3Record.toGFF3());
            this.exportedIds.add(this.lastLsf.getId());
            ++this.writtenResultsCount;
        }
        this.lastLsfId = null;
        this.attributeVersions.clear();
        this.seenAttributes.clear();
    }

    private void checkAttribute(ResultElement el, String attributeName) {
        if (!GFF_FIELDS.contains(attributeName)) {
            HashSet<Integer> seenAttributeValues = (HashSet<Integer>)this.seenAttributes.get(attributeName);
            if (seenAttributeValues == null) {
                seenAttributeValues = new HashSet<Integer>();
                this.seenAttributes.put(attributeName, seenAttributeValues);
            }
            if (!seenAttributeValues.contains(el.getId())) {
                seenAttributeValues.add(el.getId());
                Integer version = (Integer)this.attributeVersions.get(attributeName);
                if (version == null) {
                    version = new Integer(1);
                    this.attributes.put(attributeName, GFF3Exporter.formatElementValue((ResultElement)el));
                } else {
                    this.attributes.put(attributeName + version, GFF3Exporter.formatElementValue((ResultElement)el));
                }
                this.attributeVersions.put(attributeName, new Integer(version + 1));
            }
        }
    }

    private static List<String> formatElementValue(ResultElement el) {
        Object obj;
        ArrayList<String> ret = new ArrayList<String>();
        String s = el == null ? "-" : ((obj = el.getField()) == null ? "-" : obj.toString());
        ret.add(s);
        return ret;
    }

    private List<ResultElement> getResultElements(List<ResultElement> row) {
        ArrayList<ResultElement> els = new ArrayList<ResultElement>();
        for (Integer index : this.featureIndexes) {
            if (row.get(index) == null) continue;
            els.add(row.get(index));
        }
        return els;
    }

    public boolean canExport(List<Class<?>> clazzes) {
        return GFF3Exporter.canExportStatic(clazzes);
    }

    public static boolean canExportStatic(List<Class<?>> clazzes) {
        return ExportHelper.getClassIndex(clazzes, SequenceFeature.class) >= 0;
    }

    public int getWrittenResultsCount() {
        return this.writtenResultsCount;
    }

    private static List<ResultElement> filterResultRow(List<ResultElement> row, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) {
        ArrayList<ResultElement> newRow = new ArrayList<ResultElement>();
        if (unionPathCollection == null && newPathCollection == null) {
            return row;
        }
        if (unionPathCollection.containsAll(newPathCollection)) {
            for (Path p : newPathCollection) {
                ResultElement el = null;
                if (!p.toString().endsWith(".id")) {
                    el = row.get(((List)unionPathCollection).indexOf(p));
                }
                newRow.add(el);
            }
            return newRow;
        }
        throw new RuntimeException("pathCollection: " + newPathCollection + ", elPathList contains pathCollection: " + unionPathCollection.containsAll(newPathCollection));
    }
}

