/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.export;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.log4j.Logger;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.io.FastaWriterHelper;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.intermine.bio.web.model.GenomicRegion;
import org.intermine.metadata.StringUtil;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.Organism;
import org.intermine.objectstore.ObjectStore;
import org.intermine.util.DynamicUtil;

public class GenomicRegionSequenceExporter {
    private static final Logger LOG = Logger.getLogger(GenomicRegionSequenceExporter.class);
    private ObjectStore os;
    private OutputStream out;
    private static Map<MultiKey, String> chromosomeSequenceMap = new HashMap();

    public GenomicRegionSequenceExporter(ObjectStore os, OutputStream out) {
        this.os = os;
        this.out = out;
    }

    public void export(List<GenomicRegion> grList) throws Exception {
        GenomicRegion aRegion = grList.get(0);
        Organism org = (Organism)DynamicUtil.createObject(Collections.singleton(Organism.class));
        org.setShortName(aRegion.getOrganism());
        org = (Organism)this.os.getObjectByExample((InterMineObject)org, Collections.singleton("shortName"));
        for (GenomicRegion gr : grList) {
            int end;
            int start;
            String chrResidueString;
            Chromosome chr = (Chromosome)DynamicUtil.createObject(Collections.singleton(Chromosome.class));
            chr.setPrimaryIdentifier(gr.getChr());
            chr.setOrganism(org);
            chr = (Chromosome)this.os.getObjectByExample((InterMineObject)chr, new HashSet<String>(Arrays.asList("primaryIdentifier", "organism")));
            if (chromosomeSequenceMap.get(new MultiKey((Object)gr.getChr(), (Object)gr.getOrganism())) == null) {
                chrResidueString = chr.getSequence().getResidues().toString();
                chromosomeSequenceMap.put(new MultiKey((Object)gr.getChr(), (Object)gr.getOrganism()), chr.getSequence().getResidues().toString());
            } else {
                chrResidueString = (String)chromosomeSequenceMap.get(new MultiKey((Object)gr.getChr(), (Object)gr.getOrganism()));
            }
            int chrLength = chr.getLength();
            if (gr.getExtendedRegionSize() > 0) {
                start = gr.getExtendedStart();
                end = gr.getExtendedEnd();
            } else {
                start = gr.getStart();
                end = gr.getEnd();
            }
            end = Math.min(end, chrLength);
            start = Math.max(start, 1);
            ArrayList<String> headerBits = new ArrayList<String>();
            headerBits.add(gr.getChr() + ":" + start + ".." + end);
            headerBits.add(end - start + 1 + "bp");
            headerBits.add(gr.getOrganism());
            String header = StringUtil.join(headerBits, (String)" ");
            String seqName = "genomic_region_" + gr.getChr() + "_" + start + "_" + end + "_" + gr.getOrganism().replace("\\. ", "_");
            DNASequence chrSeg = new DNASequence(chrResidueString.substring(start - 1, end).toLowerCase());
            chrSeg.setAccession(new AccessionID(header.toString()));
            FastaWriterHelper.writeSequence((OutputStream)this.out, (Sequence)chrSeg);
        }
        this.out.flush();
    }
}

