/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.export;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.log4j.Logger;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.io.FastaWriterHelper;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.ontology.utils.SmallAnnotation;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.api.results.ResultElement;
import org.intermine.bio.util.ClobAccessReverseComplement;
import org.intermine.bio.web.biojava.BioSequence;
import org.intermine.bio.web.biojava.BioSequenceFactory;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.StringUtil;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.BioEntity;
import org.intermine.model.bio.CDS;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.Location;
import org.intermine.model.bio.Protein;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.pathquery.Path;
import org.intermine.util.IntPresentSet;
import org.intermine.web.logic.export.ExportException;
import org.intermine.web.logic.export.ExportHelper;
import org.intermine.web.logic.export.Exporter;

/*
 * Exception performing whole class analysis ignored.
 */
public class SequenceExporter
implements Exporter {
    private ObjectStore os;
    private OutputStream out;
    private int featureIndex;
    private int writtenResultsCount = 0;
    private final Map<String, List<FieldDescriptor>> classKeys;
    private static final String NEGATIVE_STRAND = "-1";
    private int extension;
    private String translate;
    private static Map<MultiKey, String> chromosomeSequenceMap = new HashMap();
    private List<Path> paths = Collections.emptyList();
    private static final Logger LOG = Logger.getLogger(SequenceExporter.class);
    private static final String PROPERTY_DESCRIPTIONLINE = "description_line";

    public SequenceExporter(ObjectStore os, OutputStream outputStream, int featureIndex, Map<String, List<FieldDescriptor>> classKeys, int extension, String translate) {
        this.os = os;
        this.out = outputStream;
        this.featureIndex = featureIndex;
        this.classKeys = classKeys;
        this.extension = extension;
        this.translate = translate;
    }

    public SequenceExporter(ObjectStore os, OutputStream outputStream, int featureIndex, Map<String, List<FieldDescriptor>> classKeys, int extension, String translate, List<Path> paths) {
        this.os = os;
        this.out = outputStream;
        this.featureIndex = featureIndex;
        this.classKeys = classKeys;
        this.extension = extension;
        this.paths = paths;
        this.translate = translate;
    }

    public int getWrittenResultsCount() {
        return this.writtenResultsCount;
    }

    public void export(Iterator<? extends List<ResultElement>> resultIt) {
        this.export(resultIt, (Collection)this.paths, (Collection)this.paths);
    }

    public void export(Iterator<? extends List<ResultElement>> resultIt, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) {
        IntPresentSet exportedIDs = new IntPresentSet();
        try {
            while (resultIt.hasNext()) {
                Integer objectId;
                List<ResultElement> row = resultIt.next();
                StringBuffer header = new StringBuffer();
                ResultElement resultElement = row.get(this.featureIndex);
                BioSequence bioSequence = null;
                InterMineObject object = this.os.getObjectById(resultElement.getId());
                if (!(object instanceof InterMineObject) || exportedIDs.contains(objectId = object.getId())) continue;
                if (object instanceof CDS && "y".equalsIgnoreCase(this.translate)) {
                    if ("y".equalsIgnoreCase(this.translate)) {
                        bioSequence = this.createSequenceFeatureWithTranslation(header, (Object)object, row, unionPathCollection, newPathCollection);
                    }
                } else if (object instanceof SequenceFeature) {
                    bioSequence = this.extension > 0 ? this.createSequenceFeatureWithExtension(header, (Object)object, row, unionPathCollection, newPathCollection) : this.createSequenceFeature(header, (Object)object, row, unionPathCollection, newPathCollection);
                } else {
                    if (!(object instanceof Protein)) continue;
                    bioSequence = this.createProtein(header, (Object)object, row, unionPathCollection, newPathCollection);
                }
                if (bioSequence == null) {
                    header.append(" no sequence attached.");
                    LOG.debug((Object)header);
                    continue;
                }
                SmallAnnotation annotation = bioSequence.getAnnotation();
                String headerString = header.toString();
                bioSequence.setAccession(new AccessionID(header.toString()));
                if (headerString.length() > 0) {
                    annotation.setProperty((Object)"description_line", (Object)headerString);
                } else if (object instanceof BioEntity) {
                    annotation.setProperty((Object)"description_line", (Object)((BioEntity)object).getPrimaryIdentifier());
                } else {
                    annotation.setProperty((Object)"description_line", (Object)("sequence_" + exportedIDs.size()));
                }
                FastaWriterHelper.writeSequence((OutputStream)this.out, (Sequence)bioSequence);
                ++this.writtenResultsCount;
                exportedIDs.add(objectId);
            }
            if (this.writtenResultsCount == 0) {
                this.out.write("Nothing was found for export".getBytes(Charset.forName("UTF-8")));
            }
            this.out.flush();
        }
        catch (Exception e) {
            throw new ExportException("Export failed.", e);
        }
    }

    private BioSequence createProtein(StringBuffer header, Object object, List<ResultElement> row, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) throws CompoundNotFoundException {
        Protein protein = (Protein)object;
        BioSequence bioSequence = BioSequenceFactory.make((Protein)protein);
        this.makeHeader(header, object, row, unionPathCollection, newPathCollection);
        return bioSequence;
    }

    private BioSequence createSequenceFeature(StringBuffer header, Object object, List<ResultElement> row, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) throws CompoundNotFoundException {
        SequenceFeature feature = (SequenceFeature)object;
        BioSequence bioSequence = BioSequenceFactory.make((SequenceFeature)feature);
        this.makeHeader(header, object, row, unionPathCollection, newPathCollection);
        return bioSequence;
    }

    private BioSequence createSequenceFeatureWithTranslation(StringBuffer header, Object object, List<ResultElement> row, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) throws CompoundNotFoundException {
        SequenceFeature feature = (SequenceFeature)object;
        BioSequence bioSequence = BioSequenceFactory.makeWithTranslation((SequenceFeature)feature);
        this.makeHeader(header, object, row, unionPathCollection, newPathCollection);
        return bioSequence;
    }

    private BioSequence createSequenceFeatureWithExtension(StringBuffer header, Object object, List<ResultElement> row, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) throws CompoundNotFoundException {
        SequenceFeature feature = (SequenceFeature)object;
        Chromosome chr = feature.getChromosome();
        String chrName = chr.getPrimaryIdentifier();
        int chrLength = chr.getLength();
        int start = feature.getChromosomeLocation().getStart();
        int end = feature.getChromosomeLocation().getEnd();
        String org = feature.getOrganism().getShortName();
        String strand = feature.getChromosomeLocation().getStrand();
        if (this.extension > 0) {
            start -= this.extension;
            end += this.extension;
        }
        end = Math.min(end, chrLength);
        start = Math.max(start, 1);
        ClobAccess fca = chr.getSequence().getResidues().subSequence(start - 1, end);
        if ("-1".equals(strand)) {
            fca = new ClobAccessReverseComplement(fca);
        }
        String residueString = fca.toString().toLowerCase();
        DNASequence seq = new DNASequence(residueString);
        BioSequence bioSequence = new BioSequence((AbstractSequence)seq, (BioEntity)feature);
        LOG.debug((Object)("SEQ: " + seq.getLength() + " - " + seq.getSequenceAsString()));
        this.makeHeader(header, object, row, unionPathCollection, newPathCollection);
        return bioSequence;
    }

    private void makeHeader(StringBuffer header, Object object, List<ResultElement> row, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) {
        ArrayList<String> headerBits = new ArrayList<String>();
        Object keyFieldValue = ClassKeyHelper.getKeyFieldValue((FastPathObject)((FastPathObject)object), (Map)this.classKeys);
        if (keyFieldValue != null) {
            headerBits.add(keyFieldValue.toString());
        } else {
            headerBits.add("-");
        }
        List<Object> subRow = new ArrayList();
        if (newPathCollection != null && unionPathCollection != null && unionPathCollection.containsAll(newPathCollection)) {
            for (Path path : newPathCollection) {
                if (path.toString().endsWith(".id")) continue;
                subRow.add(row.get(((List)unionPathCollection).indexOf(path)));
            }
        } else {
            subRow = row;
        }
        if (object instanceof SequenceFeature) {
            SequenceFeature feature = (SequenceFeature)object;
            Location location = feature.getChromosomeLocation();
            if (location == null) {
                headerBits.add("-");
            } else {
                String chr = location.getLocatedOn().getPrimaryIdentifier();
                Integer n = location.getStart();
                Integer end = location.getEnd();
                String locString = (String)chr + ':' + n + '-' + end;
                headerBits.add(locString);
            }
            if (this.extension > 0) {
                headerBits.add("extension:" + this.extension + "bp");
            }
            for (ResultElement resultElement : subRow) {
                if (resultElement == null || resultElement.getPath().containsCollections()) continue;
                Object fieldValue = resultElement.getField();
                if (fieldValue == null) {
                    headerBits.add("-");
                    continue;
                }
                if (fieldValue.toString().equals(keyFieldValue) || resultElement.getObject() instanceof Location || resultElement.getObject() instanceof Chromosome) continue;
                headerBits.add(fieldValue.toString());
            }
        } else if (object instanceof Protein) {
            for (ResultElement resultElement : subRow) {
                if (resultElement == null || resultElement.getPath().containsCollections()) continue;
                Object fieldValue = resultElement.getField();
                if (fieldValue == null) {
                    headerBits.add("-");
                    continue;
                }
                if (fieldValue.toString().equals(keyFieldValue)) continue;
                headerBits.add(fieldValue.toString());
            }
        }
        header.append(StringUtil.join(headerBits, (String)" "));
    }

    public boolean canExport(List<Class<?>> clazzes) {
        return SequenceExporter.canExportStatic(clazzes);
    }

    public static boolean canExportStatic(List<Class<?>> clazzes) {
        return ExportHelper.getClassIndex(clazzes, SequenceFeature.class) >= 0 || ExportHelper.getClassIndex(clazzes, Protein.class) >= 0;
    }
}

