/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.results.Column;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.bio.web.export.SequenceExporter;
import org.intermine.bio.web.logic.SequenceFeatureExportUtil;
import org.intermine.bio.web.struts.SequenceExportForm;
import org.intermine.metadata.StringUtil;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.export.ExportException;
import org.intermine.web.logic.export.ExportHelper;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.logic.export.http.HttpExporterBase;
import org.intermine.web.logic.export.http.TableHttpExporter;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.TableExportForm;

/*
 * Exception performing whole class analysis ignored.
 */
public class SequenceHttpExporter
extends HttpExporterBase
implements TableHttpExporter {
    protected static final Logger LOG = Logger.getLogger(SequenceHttpExporter.class);

    public static void setSequenceExportHeader(HttpServletResponse response, boolean doGzip) {
        String fileName = "sequence" + StringUtil.uniqueString() + ".fasta";
        if (doGzip) {
            ResponseUtil.setGzippedHeader((HttpServletResponse)response, (String)(fileName + ".gz"));
        } else {
            ResponseUtil.setCustomTypeHeader((HttpServletResponse)response, (String)fileName, (String)"chemical/x-fasta");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(PagedTable pt, HttpServletRequest request, HttpServletResponse response, TableExportForm form, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) {
        block12: {
            boolean doGzip = form != null && form.getDoGzip();
            InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)request.getSession());
            ObjectStore os = im.getObjectStore();
            SequenceHttpExporter.setSequenceExportHeader((HttpServletResponse)response, (boolean)doGzip);
            SequenceExportForm sef = (SequenceExportForm)form;
            Object outputStream = null;
            try {
                outputStream = response.getOutputStream();
                if (doGzip) {
                    outputStream = new GZIPOutputStream((OutputStream)outputStream);
                }
            }
            catch (IOException e) {
                throw new ExportException("Export failed.", (Exception)e);
            }
            String sequencePathString = null;
            if (sef != null) {
                sequencePathString = sef.getSequencePath();
            }
            if (sequencePathString == null) {
                List sequencePaths = SequenceFeatureExportUtil.getExportClassPaths((PathQuery)pt.getPathQuery());
                sequencePathString = ((Path)sequencePaths.iterator().next()).toString();
            }
            sequencePathString = sequencePathString.replaceAll(" > ", ".");
            int realFeatureIndex = 0;
            for (Column column : pt.getColumns()) {
                Path path = column.getPath();
                String pathString = path.toStringNoConstraints();
                if (!path.endIsAttribute() || !pathString.startsWith(sequencePathString) || pathString.substring(sequencePathString.length() + 1).contains(".")) continue;
                realFeatureIndex = column.getIndex();
                break;
            }
            SequenceExporter exporter = new SequenceExporter(os, (OutputStream)outputStream, realFeatureIndex, (Map)im.getClassKeys(), 0, "n");
            ExportResultsIterator iter = null;
            try {
                iter = this.getResultRows(pt, request);
                iter.goFaster();
                exporter.export((Iterator)iter, unionPathCollection, newPathCollection);
                if (!(outputStream instanceof GZIPOutputStream)) break block12;
                try {
                    ((GZIPOutputStream)outputStream).finish();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (iter != null) {
                    iter.releaseGoFaster();
                }
            }
        }
    }

    public List<Path> getInitialExportPaths(PagedTable pt) throws PathException {
        ArrayList<Path> paths = new ArrayList<Path>(ExportHelper.getColumnPaths((PagedTable)pt));
        List sequencePaths = SequenceFeatureExportUtil.getExportClassPaths((PathQuery)pt.getPathQuery());
        for (Path seqPath : sequencePaths) {
            Class seqPathClass = seqPath.getLastClassDescriptor().getType();
            if (SequenceFeature.class.isAssignableFrom(seqPathClass) && !Chromosome.class.isAssignableFrom(seqPathClass)) continue;
        }
        return paths;
    }

    public boolean canExport(PagedTable pt) {
        return SequenceExporter.canExportStatic((List)ExportHelper.getColumnClasses((PagedTable)pt));
    }
}

