/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.bio.web.logic.ValueComparator;
import org.intermine.bio.web.model.ChromosomeInfo;
import org.intermine.bio.web.model.GenomicRegion;
import org.intermine.bio.web.model.GenomicRegionSearchConstraint;
import org.intermine.metadata.ConstraintOp;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.Organism;
import org.intermine.model.bio.SOTerm;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SingletonResults;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.session.SessionMethods;

/*
 * Exception performing whole class analysis ignored.
 */
public class GenomicRegionSearchQueryRunner
implements Runnable {
    private HttpServletRequest request = null;
    private String spanUUIDString = null;
    private GenomicRegionSearchConstraint grsc = null;
    private Map<GenomicRegion, Query> queryMap = null;
    private static Map<String, Map<String, ChromosomeInfo>> chrInfoMap = null;

    public GenomicRegionSearchQueryRunner(HttpServletRequest request, String spanUUIDString, GenomicRegionSearchConstraint grsc, Map<GenomicRegion, Query> queryMap) {
        this.request = request;
        this.spanUUIDString = spanUUIDString;
        this.grsc = grsc;
        this.queryMap = queryMap;
    }

    public void search() {
        HashMap<GenomicRegionSearchConstraint, String> spanConstraintMap = (HashMap<GenomicRegionSearchConstraint, String>)this.request.getSession().getAttribute("spanConstraintMap");
        if (spanConstraintMap == null) {
            spanConstraintMap = new HashMap<GenomicRegionSearchConstraint, String>();
        }
        if (spanConstraintMap.size() == 0) {
            spanConstraintMap.put(this.grsc, this.spanUUIDString);
        } else if (spanConstraintMap.containsKey(this.grsc)) {
            this.spanUUIDString = (String)spanConstraintMap.get(this.grsc);
            this.request.setAttribute("spanUUIDString", (Object)this.spanUUIDString);
        } else {
            spanConstraintMap.put(this.grsc, this.spanUUIDString);
        }
        this.request.getSession().setAttribute("spanConstraintMap", spanConstraintMap);
        this.request.setAttribute("spanQueryTotalCount", (Object)this.grsc.getGenomicRegionList().size());
        new Thread((Runnable)this).start();
    }

    @Override
    public void run() {
        this.queryExecutor();
    }

    private void queryExecutor() {
        HashMap spanOverlapFullStatMap;
        HashMap spanOverlapFullResultMap = (HashMap)this.request.getSession().getAttribute("spanOverlapFullResultMap");
        if (spanOverlapFullResultMap == null) {
            spanOverlapFullResultMap = new HashMap();
        }
        if ((spanOverlapFullStatMap = (HashMap)this.request.getSession().getAttribute("spanOverlapFullStatMap")) == null) {
            spanOverlapFullStatMap = new HashMap();
        }
        Map spanOverlapResultDisplayMap = Collections.synchronizedMap(new LinkedHashMap());
        Map spanOverlapResultStatMap = Collections.synchronizedMap(new LinkedHashMap());
        if (!spanOverlapFullResultMap.containsKey(this.spanUUIDString) && !spanOverlapFullStatMap.containsKey(this.spanUUIDString)) {
            spanOverlapFullResultMap.put(this.spanUUIDString, spanOverlapResultDisplayMap);
            this.request.getSession().setAttribute("spanOverlapFullResultMap", spanOverlapFullResultMap);
            spanOverlapFullStatMap.put(this.spanUUIDString, spanOverlapResultStatMap);
            this.request.getSession().setAttribute("spanOverlapFullStatMap", spanOverlapFullStatMap);
            try {
                ObjectStore os = SessionMethods.getInterMineAPI((HttpSession)this.request.getSession()).getObjectStore();
                for (Map.Entry e : this.queryMap.entrySet()) {
                    Results results = os.execute((Query)e.getValue());
                    ArrayList spanResults = new ArrayList();
                    HashMap<String, Integer> spanStatMap = new HashMap<String, Integer>();
                    ValueComparator bvc = new ValueComparator(spanStatMap);
                    TreeMap<String, Integer> sortedStatMap = new TreeMap<String, Integer>((Comparator<String>)bvc);
                    if (results == null || results.isEmpty()) {
                        spanOverlapResultDisplayMap.put((GenomicRegion)e.getKey(), null);
                        continue;
                    }
                    for (ResultsRow row : results) {
                        ArrayList<String> resultRow = new ArrayList<String>();
                        for (Object o : row) {
                            String item = new String();
                            Object object = o = o == null ? new String() : o;
                            if (o instanceof Class) {
                                item = ((Class)o).getSimpleName();
                                if (spanStatMap.containsKey(item)) {
                                    spanStatMap.put(item, (Integer)spanStatMap.get(item) + 1);
                                } else {
                                    spanStatMap.put(item, 1);
                                }
                            } else {
                                item = o.toString();
                            }
                            resultRow.add(item);
                        }
                        spanResults.add(resultRow);
                    }
                    spanOverlapResultDisplayMap.put((GenomicRegion)e.getKey(), spanResults);
                    sortedStatMap.putAll(spanStatMap);
                    spanOverlapResultStatMap.put((GenomicRegion)e.getKey(), sortedStatMap);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, Map<String, ChromosomeInfo>> getChromosomeInfo(InterMineAPI im) {
        return GenomicRegionSearchQueryRunner.getChromosomeInfo((InterMineAPI)im, (int)10000);
    }

    public static Map<String, Map<String, ChromosomeInfo>> getChromosomeInfo(InterMineAPI im, int batchSize) {
        if (chrInfoMap != null) {
            return chrInfoMap;
        }
        chrInfoMap = new HashMap();
        Query q = new Query();
        q.setDistinct(true);
        QueryClass qcChr = new QueryClass(Chromosome.class);
        QueryClass qcOrg = new QueryClass(Organism.class);
        q.addFrom((FromElement)qcChr);
        q.addFrom((FromElement)qcOrg);
        QueryField qfOrgName = new QueryField(qcOrg, "shortName");
        QueryField qfChrIdentifier = new QueryField(qcChr, "primaryIdentifier");
        QueryField qfChrLength = new QueryField(qcChr, "length");
        q.addToSelect((QuerySelectable)qfOrgName);
        q.addToSelect((QuerySelectable)qfChrIdentifier);
        q.addToSelect((QuerySelectable)qfChrLength);
        QueryObjectReference orgRef = new QueryObjectReference(qcChr, "organism");
        ContainsConstraint ccOrg = new ContainsConstraint((QueryReference)orgRef, ConstraintOp.CONTAINS, qcOrg);
        q.setConstraint((Constraint)ccOrg);
        Results results = im.getObjectStore().execute(q, batchSize, true, true, true);
        ArrayList<ChromosomeInfo> chrInfoList = new ArrayList<ChromosomeInfo>();
        HashSet<String> orgSet = new HashSet<String>();
        for (ResultsRow row : results) {
            String orgName = (String)row.get(0);
            String chrIdentifier = (String)row.get(1);
            Integer chrLength = (Integer)row.get(2);
            orgSet.add(orgName);
            ChromosomeInfo chrInfo = new ChromosomeInfo();
            chrInfo.setOrgName(orgName);
            chrInfo.setChrPID(chrIdentifier);
            if (chrLength != null) {
                chrInfo.setChrLength(chrLength);
            }
            chrInfoList.add(chrInfo);
        }
        for (String o : orgSet) {
            HashMap<String, ChromosomeInfo> chrInfoSubMap = new HashMap<String, ChromosomeInfo>();
            for (ChromosomeInfo chrInfo : chrInfoList) {
                if (!o.equals(chrInfo.getOrgName())) continue;
                chrInfoSubMap.put(chrInfo.getChrPIDLowerCase(), chrInfo);
                chrInfoMap.put(o, chrInfoSubMap);
            }
        }
        return chrInfoMap;
    }

    public static Map<String, List<String>> getFeatureAndSOInfo(InterMineAPI im, Map<String, String> classDescrs, int batchSize) {
        HashMap<String, List<String>> featureTypeToSOTermMap = new HashMap<String, List<String>>();
        Query q = new Query();
        q.setDistinct(true);
        QueryClass qcFeature = new QueryClass(SequenceFeature.class);
        QueryClass qcSOTerm = new QueryClass(SOTerm.class);
        QueryField qfFeatureClass = new QueryField(qcFeature, "class");
        QueryField qfSOName = new QueryField(qcSOTerm, "name");
        q.addToSelect((QuerySelectable)qfFeatureClass);
        q.addToSelect((QuerySelectable)qfSOName);
        q.addFrom((FromElement)qcFeature);
        q.addFrom((FromElement)qcSOTerm);
        q.addToOrderBy((QueryOrderable)qfSOName);
        QueryObjectReference soTerm = new QueryObjectReference(qcFeature, "sequenceOntologyTerm");
        ContainsConstraint ccSoTerm = new ContainsConstraint((QueryReference)soTerm, ConstraintOp.CONTAINS, qcSOTerm);
        q.setConstraint((Constraint)ccSoTerm);
        Results results = im.getObjectStore().execute(q, batchSize, true, true, true);
        for (ResultsRow row : results) {
            ArrayList<String> soInfo = new ArrayList<String>();
            String ft = ((Class)row.get(0)).getSimpleName();
            String soName = (String)row.get(1);
            String soDes = classDescrs.get(ft) == null ? "description not avaliable" : classDescrs.get(ft);
            soDes = soDes.replaceAll("'", "&apos;");
            soDes = soDes.replaceAll("\"", "&quot;");
            soInfo.add(soName);
            soInfo.add(soDes);
            if (featureTypeToSOTermMap.containsKey(ft)) continue;
            featureTypeToSOTermMap.put(ft, soInfo);
        }
        return featureTypeToSOTermMap;
    }

    public static Map<String, String> getTaxonInfo(InterMineAPI im, int batchSize) {
        HashMap<String, String> orgTaxonIdMap = new HashMap<String, String>();
        Query q = new Query();
        QueryClass organisms = new QueryClass(Organism.class);
        q.addFrom((FromElement)organisms);
        q.addToSelect((QuerySelectable)organisms);
        SingletonResults orgs = im.getObjectStore().executeSingleton(q, batchSize, true, true, true);
        for (Object o : orgs) {
            Organism org = (Organism)o;
            orgTaxonIdMap.put(org.getShortName(), org.getTaxonId());
        }
        return orgTaxonIdMap;
    }

    public static void getRegionStringFromSequenceFeatureList(Collection<SequenceFeature> features, InterMineAPI im, Profile profile) {
    }

    public static void getRegionStringFromPathQuery(PathQuery query, InterMineAPI im, Profile profile) {
    }
}

