/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.logic;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.intermine.util.PropertiesUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public final class OrganismGenomeBuildLookup {
    private static Map<Integer, String> taxonMap = new HashMap();
    private static Map<String, String> abbreviationMap = new HashMap();
    private static Map<String, String> fullnameMap = new HashMap();

    private OrganismGenomeBuildLookup() {
    }

    private static void prepareData() {
        if (taxonMap.size() == 0 || abbreviationMap.size() == 0 || fullnameMap.size() == 0) {
            Properties props = PropertiesUtil.getProperties();
            String flyGB = props.getProperty("genomeVersion.fly");
            String wormGB = props.getProperty("genomeVersion.worm");
            String humanGB = props.getProperty("genomeVersion.human");
            String mouseGB = props.getProperty("genomeVersion.mouse");
            if (flyGB != null) {
                taxonMap.put(7227, flyGB);
                abbreviationMap.put("D. melanogaster", flyGB);
                fullnameMap.put("Drosophila melanogaster", flyGB);
            }
            if (wormGB != null) {
                taxonMap.put(6239, wormGB);
                abbreviationMap.put("C. elegans", wormGB);
                fullnameMap.put("Caenorhabditis elegans", wormGB);
            }
            if (humanGB != null) {
                taxonMap.put(9606, humanGB);
                abbreviationMap.put("H. sapiens", humanGB);
                fullnameMap.put("Homo sapiens", humanGB);
            }
            if (mouseGB != null) {
                taxonMap.put(10090, mouseGB);
                abbreviationMap.put("M. musculus", mouseGB);
                fullnameMap.put("Mus musculus", mouseGB);
            }
        }
    }

    public static String getGenomeBuildbyOrgansimFullName(String fn) {
        OrganismGenomeBuildLookup.prepareData();
        return (String)fullnameMap.get(fn);
    }

    public static String getGenomeBuildbyOrgansimAbbreviation(String abbr) {
        OrganismGenomeBuildLookup.prepareData();
        return (String)abbreviationMap.get(abbr);
    }

    public static String getGenomeBuildbyOrgansimTaxon(Integer taxon) {
        OrganismGenomeBuildLookup.prepareData();
        return (String)taxonMap.get(taxon);
    }

    public static String getGenomeBuildbyOrgansimId(String id) {
        OrganismGenomeBuildLookup.prepareData();
        if (id.contains(". ")) {
            return (String)abbreviationMap.get(id);
        }
        if (Pattern.matches("^\\d+$", id)) {
            return (String)taxonMap.get(id);
        }
        return (String)fullnameMap.get(id);
    }

    public static Collection<String> getGenomeBuildByOrgansimCollection(Collection<String> c) {
        OrganismGenomeBuildLookup.prepareData();
        LinkedHashSet<String> gbc = new LinkedHashSet<String>();
        for (String id : c) {
            if (id.contains(". ")) {
                gbc.add((String)abbreviationMap.get(id));
                continue;
            }
            if (Pattern.matches("^\\d+$", id)) {
                gbc.add((String)taxonMap.get(id));
                continue;
            }
            gbc.add((String)fullnameMap.get(id));
        }
        return gbc;
    }
}

