/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Gene;
import org.intermine.util.DynamicUtil;

public class GeneModel {
    Model model;
    Gene gene;
    InterMineObject transcript;
    InterMineObject threePrimeUTR;
    InterMineObject fivePrimeUTR;
    List<InterMineObject> exons;
    List<InterMineObject> introns;
    List<InterMineObject> cdss;
    Set<Integer> ids = null;
    private static String[] types = new String[]{"Gene", "Transcript", "Exon", "UTR", "CDS"};
    public static final Set<String> TYPES = new HashSet<String>(Arrays.asList(types));
    protected static final Logger LOG = Logger.getLogger(GeneModel.class);

    public GeneModel(Model model, Gene gene, InterMineObject transcript) {
        this.gene = gene;
        this.transcript = transcript;
        this.model = model;
        this.init();
    }

    private void init() {
        if (this.transcript == null) {
            return;
        }
        if (!this.classExists("Transcript")) {
            return;
        }
        if (this.fieldExists("Transcript", "exons")) {
            this.exons = new ArrayList();
            try {
                Collection transcriptExons = (Collection)this.transcript.getFieldValue("exons");
                for (InterMineObject exon : transcriptExons) {
                    this.exons.add(exon);
                }
            }
            catch (IllegalAccessException e) {
                LOG.warn((Object)("Failed to fetch exons for transcript: " + this.transcript.getId()));
            }
        }
        if (this.fieldExists("Transcript", "introns")) {
            this.introns = new ArrayList();
            try {
                Collection transcriptIntrons = (Collection)this.transcript.getFieldValue("introns");
                for (InterMineObject intron : transcriptIntrons) {
                    this.introns.add(intron);
                }
            }
            catch (IllegalAccessException e) {
                LOG.warn((Object)("Failed to fetch introns for transcript: " + this.transcript.getId()));
            }
        }
        if (this.fieldExists("Transcript", "CDSs")) {
            this.cdss = new ArrayList();
            try {
                Collection transcriptCdss = (Collection)this.transcript.getFieldValue("CDSs");
                for (InterMineObject cds : transcriptCdss) {
                    this.cdss.add(cds);
                }
            }
            catch (IllegalAccessException e) {
                LOG.warn((Object)("Failed to fetch CDSs for transcript: " + this.transcript.getId()));
            }
        }
        if (this.fieldExists("Transcript", "UTRs")) {
            try {
                Collection transcriptUTRs = (Collection)this.transcript.getFieldValue("UTRs");
                for (InterMineObject utr : transcriptUTRs) {
                    String clsName = DynamicUtil.getSimpleClass((FastPathObject)utr).getSimpleName();
                    if ("FivePrimeUTR".equals(clsName)) {
                        if (this.fivePrimeUTR != null) {
                            LOG.warn((Object)("More than one five prime UTR found for transcript: " + this.transcript.getId()));
                        } else {
                            this.fivePrimeUTR = utr;
                        }
                    }
                    if (!"ThreePrimeUTR".equals(clsName)) continue;
                    if (this.threePrimeUTR != null) {
                        LOG.warn((Object)("More than one three prime UTR found for transcript: " + this.transcript.getId()));
                        continue;
                    }
                    this.threePrimeUTR = utr;
                }
            }
            catch (IllegalAccessException e) {
                LOG.warn((Object)("Failed to fetch UTRs for transcript: " + this.transcript.getId()));
            }
        }
    }

    public Gene getGene() {
        return this.gene;
    }

    public InterMineObject getTranscript() {
        return this.transcript;
    }

    public List<InterMineObject> getExons() {
        return this.exons;
    }

    public List<InterMineObject> getIntrons() {
        return this.introns;
    }

    public List<InterMineObject> getCDSs() {
        return this.cdss;
    }

    public InterMineObject getThreePrimeUTR() {
        return this.threePrimeUTR;
    }

    public InterMineObject getFivePrimeUTR() {
        return this.fivePrimeUTR;
    }

    public Set<Integer> getIds() {
        if (this.ids == null) {
            this.ids = new HashSet();
            this.ids.add(this.gene.getId());
            this.ids.add(this.transcript.getId());
            this.addCollectionIds(this.ids, (Collection)this.exons);
            this.addCollectionIds(this.ids, (Collection)this.introns);
            this.addCollectionIds(this.ids, (Collection)this.cdss);
            if (this.threePrimeUTR != null) {
                this.ids.add(this.threePrimeUTR.getId());
            }
            if (this.fivePrimeUTR != null) {
                this.ids.add(this.fivePrimeUTR.getId());
            }
        }
        return this.ids;
    }

    private void addCollectionIds(Set<Integer> ids, Collection<InterMineObject> col) {
        if (col != null) {
            for (InterMineObject obj : col) {
                ids.add(obj.getId());
            }
        }
    }

    private boolean classExists(String clsName) {
        ClassDescriptor cld = this.model.getClassDescriptorByName(clsName);
        return cld != null;
    }

    private boolean fieldExists(String clsName, String fieldName) {
        ClassDescriptor cld = this.model.getClassDescriptorByName(clsName);
        FieldDescriptor fd = cld.getFieldDescriptorByName(fieldName);
        return fd != null;
    }
}

